#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor;
use List::Util qw(min max);
############ NOT USED ##################
open (DHS_TRIMETHYLATION_SYMMETRY, "/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/NUCLEAR_RNASEQ_BIGBAM/FEATURECOUNTS_FOR_ESTIMATION/H3K4me3_Coverage_500bp_around_DHS_summits.coverage");
open (DHS_BED, ">Selected_DHS_p300.bed");

while ($line=<DHS_TRIMETHYLATION_SYMMETRY>)
{
@DATA=split("\t",$line);
$DHS_ID=$DATA[3];
($ID,$CHR,$SUMMIT)=split(":::",$DHS_ID);
$LEFT=$SUMMIT-500;$RIGHT=$SUMMIT+500; print DHS_BED "$CHR\t$LEFT\t$RIGHT\t$DHS_ID\t255\t.\n";

if (($DATA[0] ne $DATA[7]) || ($DHS_ID ne $DATA[10])) {print color ("red"),"IDs do not match"; die;}

$SYMMETRY_RATIO{$DHS_ID}=max(($DATA[6]+0.33),($DATA[13]+0.33))/min(($DATA[6]+0.33),($DATA[13]+0.33));
if ($SYMMETRY_RATIO{$DHS_ID} > 3) {$ASYMMETRICAL++;print "$line\n";}
}
close DHS_TRIMETHYLATION_SYMMETRY;
close DHS_BED;
print "ASSYMETRICAL=$ASYMMETRICAL\n";
##############################
system ("bedtools getfasta -name -tab -fi /scratch/iwase-lab/SAURABH/GENOMES/MM9/mm9.fa -bed Selected_DHS_p300.bed -fo Selected_DHS_p300.fa");
open (FASTA,"Selected_DHS_p300.fa");

while ($line=<FASTA>)
{
($ID,$SEQ)=split("\t",$line);
@NUMBER=split("CG",$SEQ);
$CpG_CONTENT{$ID}=$#NUMBER/10;
}
close FASTA;
##############################

system ("ls -l; rm *.bed *.list; sleep 3; ls -l");
$TOTAL_INPUT= 	207912051/(1000000/2.001);
$TOTAL_H3K4me1=  41202217/(1000000/2.001);
$TOTAL_H3K4me2=  83279604/(1000000/1.501);
$TOTAL_H3K4me3=  44855008/(1000000/1.501);
$TOTAL_H3K27Ac=  87718221/(1000000/1.501);
$TOTAL_H3K27me3=147445234/(1000000/2.001);
$TOTAL_H3K9Ac= 	 42691637/(1000000/1.501);
$TOTAL_H3K9me3=  96607773/(1000000/2.001);

$TOTAL_GROSEQ        = 96816568/(1000000/1.001);
$TOTAL_NUCLEAR_RNASEQ=233915289/(1000000/1.001);
$TOTAL_TOTAL_RNASEQ  = 70183812/(1000000/1.001);
$TOTAL_p300=29971501/(1000000/0.601);
$TOTAL_LSD1=22846609/(1000000/0.601);
$TOTAL_SMCX=50182748/(1000000/0.601);



open (NORM_SUMMARIZATION,">WT_mES_ALL_MARKS_Normalized_to_valid_reads.list");
open (NORM_ENHANCER_VALUES,">WT_mES_ENHANCERS_Normalized_to_valid_reads.list");
open (NORM_ENHANCER_RPKMS,">WT_mES_ENHANCERS_RPKMS_Normalized_to_valid_reads.list");
open (LIST_OF_ENHANCERS,">WT_mES_ENHANCERS_RATIOS_VALUES.list");

open (ENHANCER_BED_FILE, ">All_Mappable_Predicted_Enhancers.bed");
print ENHANCER_BED_FILE "browser position chr12:86788117-86853216\n";
print ENHANCER_BED_FILE "track type=bed name=\"All_Mappable_DHS_p300_Predicted_Enhancers_2016_1250bp_apart_H3K4me1_Only\" description=\"All_Mappable_DHS_p300_Predicted_Enhancers_2016_1250bp_apart_H3K4me1_Only\" useScore=1 color=0,128,0\n";
print LIST_OF_ENHANCERS "Geneid\tChr\tStart\tEnd\tENHANCER_TYPE\tH3K4me1_ratio\tH3K4me2_ratio\tH3K4me3_ratio\tH3K27Ac_ratio\tH3K27me3_ratio\tH3K9Ac_ratio\tH3K9me3_ratio\tNORM_GROSEQ\tNORM_NUCLEAR\tNORM_TOTAL_RNASEQ\tp300\tLSD1\tSMCX\n";
##############
open (READ_SUMMARIZATION,"../../WT_mES_ALL_MARKS_For_Enhancer_Prediction");

$n=0;
NEXT_DHS:while ($line = <READ_SUMMARIZATION>)
{
$n++;
chomp $line;
($Geneid,$Chr,$Start,$End,$Strand,$Length,$INPUT,$H3K4me1,$H3K4me2,$H3K4me3,$H3K27Ac,$H3K27me3,$H3K9Ac,$H3K9me3,$GROSEQ,$NUCLEAR_RNASEQ,$TOTAL_RNASEQ,$p300,$LSD1,$SMCX)=split("\t",$line);



if ($n eq 1) 
{print color ("yellow"), "Geneid=$Geneid\nINPUT=$INPUT\nH3K4me1=$H3K4me1\nH3K4me2=$H3K4me2\nH3K4me3=$H3K4me3\nH3K27Ac=$H3K27Ac\nH3K27me3=$H3K27me3\nH3K9Ac=$H3K9Ac\nH3K9me3=$H3K9me3\n
GROSEQ=$GROSEQ\nNUCLEAR=$NUCLEAR_RNASEQ\nTOTAL=$TOTAL_RNASEQ\n";
print NORM_SUMMARIZATION "Geneid\tChr\tStart\tEnd\tStrand\tH3K4me1_ratio\tH3K4me2_ratio\tH3K4me3_ratio\tH3K27Ac_ratio\tH3K27me3_ratio\tH3K9Ac_ratio\tH3K9me3_ratio\tNORM_GROSEQ\tNORM_NUCLEAR\tNORM_TOTAL_RNA\n";
print NORM_ENHANCER_VALUES "Geneid\tChr\tStart\tEnd\tStrand\tH3K4me1_ratio\tH3K4me2_ratio\tH3K4me3_ratio\tH3K27Ac_ratio\tH3K27me3_ratio\tH3K9Ac_ratio\tH3K9me3_ratio\tNORM_GROSEQ\tNORM_NUCLEAR\tNORM_TOTAL_RNA\n"; 
print NORM_ENHANCER_RPKMS "Geneid\tChr\tStart\tEnd\tStrand\tNORM_INPUT\tNORM_H3K4me1\tNORM_H3K4me2\tNORM_H3K4me3\tNORM_H3K27Ac\tNORM_H3K27me3\tNORM_H3K9Ac\tNORM_H3K9me3\tNORM_GROSEQ\tNORM_NUCLEAR\tNORM_TOTAL_RNASEQ\n";next NEXT_DHS;}	

$LEFT=$Start+500;
$RIGHT= $End-500;


$NORM_INPUT=($INPUT+2)/$TOTAL_INPUT;
$NORM_H3K4me1=$H3K4me1/$TOTAL_H3K4me1;
$NORM_H3K4me2=$H3K4me2/$TOTAL_H3K4me2;
$NORM_H3K4me3=$H3K4me3/$TOTAL_H3K4me3;

$NORM_H3K27Ac=$H3K27Ac/$TOTAL_H3K27Ac;
$NORM_H3K27me3=$H3K27me3/$TOTAL_H3K27me3;

$NORM_H3K9Ac=$H3K9Ac/$TOTAL_H3K9Ac;
$NORM_H3K9me3=$H3K9me3/$TOTAL_H3K9me3;

$NORM_GROSEQ=$GROSEQ/$TOTAL_GROSEQ;
$NORM_NUCLEAR=$NUCLEAR_RNASEQ/$TOTAL_NUCLEAR_RNASEQ;
$NORM_TOTAL_RNASEQ=$TOTAL_RNASEQ/$TOTAL_TOTAL_RNASEQ;

$p300_ratio=$p300/($TOTAL_p300*$NORM_INPUT);
$LSD1_ratio=$LSD1/($TOTAL_LSD1*$NORM_INPUT);
$SMCX_ratio=$SMCX/($TOTAL_SMCX*$NORM_INPUT);

$H3K4me1_ratio=$NORM_H3K4me1/$NORM_INPUT;
$H3K4me2_ratio=$NORM_H3K4me2/$NORM_INPUT;
$H3K4me3_ratio=$NORM_H3K4me3/$NORM_INPUT;

$H3K27Ac_ratio=$NORM_H3K27Ac/$NORM_INPUT;
$H3K27me3_ratio=$NORM_H3K27me3/$NORM_INPUT;

$H3K9Ac_ratio=$NORM_H3K9Ac/$NORM_INPUT;
$H3K9me3_ratio=$NORM_H3K9me3/$NORM_INPUT;

$GRO_K27Ac_ratio=$NORM_GROSEQ/($H3K27Ac_ratio+0.05);

$Tri_to_Di_Methyl_Ratio=($H3K4me3_ratio+0.05)/($H3K4me2_ratio+0.05);
$Mono_to_Di_Methyl_Ratio=($H3K4me1_ratio+0.05)/($H3K4me2_ratio+0.05);

$NORM_PRINT="$Geneid\t$Chr\t$Start\t$End\t$Strand\t$H3K4me1_ratio\t$H3K4me2_ratio\t$H3K4me3_ratio\t$H3K27Ac_ratio\t$H3K27me3_ratio\t$H3K9Ac_ratio\t$H3K9me3_ratio\t$NORM_GROSEQ\t$NORM_NUCLEAR\t$NORM_TOTAL_RNASEQ\n";
print NORM_SUMMARIZATION "$NORM_PRINT";

$PRINT_RPKMS="$Geneid\t$Chr\t$Start\t$End\t$Strand\t$NORM_INPUT\t$NORM_H3K4me1\t$NORM_H3K4me2\t$NORM_H3K4me3\t$NORM_H3K27Ac\t$NORM_H3K27me3\t$NORM_H3K9Ac\t$NORM_H3K9me3\t$NORM_GROSEQ\t$NORM_NUCLEAR\t$NORM_TOTAL_RNASEQ\n";

$GROSEQ_TO_RNASEQ_RATIO=($NORM_GROSEQ+0.001)/($NORM_TOTAL_RNASEQ+0.001);
####################### FILTERING #######################
if ($NORM_H3K4me1 < 1) {next NEXT_DHS;}
$MAX_OF_MONO_DI_RATIO=max($H3K4me1_ratio,$H3K4me2_ratio); if ($H3K4me3_ratio > $MAX_OF_MONO_DI_RATIO) {next NEXT_DHS;}
if ($NORM_TOTAL_RNASEQ > 0.5) {next NEXT_DHS;}
if (($NORM_NUCLEAR > 0.1) && ($NORM_NUCLEAR > $NORM_GROSEQ)) {next NEXT_DHS;} 
$SCORE=0; $ENHANCER_TYPE="NONE";

if ($H3K4me1_ratio > 1.5)
{
if (($H3K4me3_ratio < 1.25) && ($NORM_TOTAL_RNASEQ < 0.125)) 
	{
	if (($H3K4me2_ratio <  0.5*$H3K4me1_ratio))
		{$TOTAL_ENHANCERS++;$MONOMETHYLATED_ENHANCERS++;$ENHANCER_TYPE="MONO";$SCORE=125;      goto TYPE_OF_ENHANCER;}

	if (($H3K4me2_ratio >= 0.5*$H3K4me1_ratio) && ($H3K4me2_ratio <  $H3K4me1_ratio))
		{$TOTAL_ENHANCERS++;$MONOnDIMETHYLATED_ENHANCERS++;$ENHANCER_TYPE="MONOnDI";$SCORE=250;goto TYPE_OF_ENHANCER;}

	if (($H3K4me2_ratio >=  $H3K4me1_ratio))
		{$TOTAL_ENHANCERS++;$DIMETHYLATED_ENHANCERS++;$ENHANCER_TYPE="DI";$SCORE=500;          goto TYPE_OF_ENHANCER;}
	}

if ((($H3K4me3_ratio >= 1.25) || ($NORM_TOTAL_RNASEQ >= 0.125)) && ($GROSEQ_TO_RNASEQ_RATIO > 5)) 
	{	
	if (($H3K4me2_ratio <  0.5*$H3K4me1_ratio))
		{$TOTAL_ENHANCERS++;$MONOMETHYLATED_ENHANCERS++;$ENHANCER_TYPE="MONO";$SCORE=125;      goto TYPE_OF_ENHANCER;}

	if (($H3K4me2_ratio >= 0.5*$H3K4me1_ratio) && ($H3K4me2_ratio <  $H3K4me1_ratio))
		{$TOTAL_ENHANCERS++;$MONOnDIMETHYLATED_ENHANCERS++;$ENHANCER_TYPE="MONOnDI";$SCORE=250;goto TYPE_OF_ENHANCER;}

	if (($H3K4me2_ratio >=  $H3K4me1_ratio))
		{$TOTAL_ENHANCERS++;$DIMETHYLATED_ENHANCERS++;$ENHANCER_TYPE="DI";$SCORE=500;          goto TYPE_OF_ENHANCER;}
	}
}
if ($ENHANCER_TYPE eq "NONE") {next NEXT_DHS;}

TYPE_OF_ENHANCER:
$ACTIVITY="GRO_NONE";$K9_STATUS="K9_NONE";$K27_STATUS="K27_NONE";

if ($NORM_GROSEQ <= 0.1)                           {$ACTIVITY="LOW_GRO";$LOW_GRO++;}
if (($NORM_GROSEQ > 0.1) && ($NORM_GROSEQ < 0.6)) {$ACTIVITY="MEDIUM_GRO";$MEDIUM_GRO++;}
if ($NORM_GROSEQ >= 0.6)                          {$ACTIVITY="HIGH_GRO";$HIGH_GRO++;}

if (($H3K27Ac_ratio < 1) && ($H3K27me3_ratio > 1.25)) {$K27_STATUS="K27_Methylated";$K27_Methylated++;}
if (($H3K27Ac_ratio > 2) && ($H3K27me3_ratio < 1)) {$K27_STATUS="K27_Acetylated";$K27_Acetylated++;}

if (($H3K9Ac_ratio < 1) && ($H3K9me3_ratio > 1.25)) {$K9_STATUS="K9_Methylated";$K9_Methylated++;}
if (($H3K9Ac_ratio > 2) && ($H3K9me3_ratio < 1)) {$K9_STATUS="K9_Acetylated";$K9_Acetylated++;}

$S="!!!";

print ENHANCER_BED_FILE "$Chr\t$LEFT\t$RIGHT\t$Geneid$S$ENHANCER_TYPE$S$ACTIVITY$S$K27_STATUS$S$K9_STATUS\t$SCORE\t.\n";
print NORM_ENHANCER_VALUES "$NORM_PRINT";
print NORM_ENHANCER_RPKMS "$PRINT_RPKMS"; 
print LIST_OF_ENHANCERS "$Geneid\t$Chr\t$Start\t$End\t$ENHANCER_TYPE\t$H3K4me1_ratio\t$H3K4me2_ratio\t$H3K4me3_ratio\t$H3K27Ac_ratio\t$H3K27me3_ratio\t$H3K9Ac_ratio\t$H3K9me3_ratio\t$NORM_GROSEQ\t$NORM_NUCLEAR\t$NORM_TOTAL_RNASEQ\t$p300_ratio\t$LSD1_ratio\t$SMCX_ratio\n";
}

close LIST_OF_ENHANCERS;
close NORM_SUMMARIZATION;
close READ_SUMMARIZATION;
close ENHANCER_BED_FILE;

print "TOTAL_ENHANCERS=$TOTAL_ENHANCERS\n";
print "MONOMETHYLATED_ENHANCERS=$MONOMETHYLATED_ENHANCERS\n";
print "MONO_n_DIMETHYLATED_ENHANCERS=$MONOnDIMETHYLATED_ENHANCERS\n";
print "DIMETHYLATED_ENHANCERS=$DIMETHYLATED_ENHANCERS\n";
print "TRIMETHYLATED_ENHANCERS=$TRIMETHYLATED_ENHANCERS\n";
system ("wc -l *.bed");
print "GROSEQ_LEVELS:\nLOW_GRO=$LOW_GRO\nMEDIUM_GRO=$MEDIUM_GRO\nHIGH_GRO=$HIGH_GRO\n\n";
print "H3K27 Status:\nK27_Methylated=$K27_Methylated\nK27_Acetylated=$K27_Acetylated\n\n";
print "H3K9 Status:\nK9_Methylated=$K9_Methylated\nK9_Acetylated=$K9_Acetylated\n\n";

#########################################
open (LIST_OF_ENHANCERS,"WT_mES_ENHANCERS_RATIOS_VALUES.list");
open (VALUES_FOR_BOXPLOT_H3K4,">Values_For_Boxplot_H3K4.list");
open (VALUES_FOR_BOXPLOT_RNA,">Values_For_Boxplot_RNA.list");
open (VALUES_FOR_BOXPLOT_K9_K27,">Values_For_Boxplot_K9K27.list");
open (VALUES_FOR_BOXPLOT_LSD1_p300,">Values_For_Boxplot_LSD1_p300.list");

print VALUES_FOR_BOXPLOT_H3K4 "value\tfeature\n";
print VALUES_FOR_BOXPLOT_RNA "value\tfeature\n";
print VALUES_FOR_BOXPLOT_K9_K27 "value\tfeature\n";
print VALUES_FOR_BOXPLOT_LSD1_p300 "value\tfeature\n";

$n=0;
NEXT_ENHANCER:while ($line = <LIST_OF_ENHANCERS>)
{
$n++;chomp $line;
if ($n eq 1) {next NEXT_ENHANCER;}

($Geneid,$Chr,$Start,$End,$ENHANCER_TYPE,$H3K4me1_ratio,$H3K4me2_ratio,$H3K4me3_ratio,$H3K27Ac_ratio,$H3K27me3_ratio,$H3K9Ac_ratio,$H3K9me3_ratio,$NORM_GROSEQ,$NORM_NUCLEAR,$NORM_TOTAL_RNASEQ,$p300_ratio,$LSD1_ratio,$SMCX_ratio)=split("\t",$line);

$RRATIO=$H3K4me2_ratio/$H3K4me1_ratio;

if ($RRATIO < 0.4172) 				{$TYPE="Q1";$NQ1++;}
if (($RRATIO >= 0.4172) && ($RRATIO < 0.7388)) 	{$TYPE="Q2";$NQ2++;}
if (($RRATIO >= 0.7388) && ($RRATIO < 1.333)) 	{$TYPE="Q3";$NQ3++;}
if ($RRATIO >= 1.333)  				{$TYPE="Q4";$NQ4++;}

$P[1]=$TYPE;

$H3K4me1=log($H3K4me1_ratio+0.01)/log(2);
$H3K4me2=log($H3K4me2_ratio+0.01)/log(2);
$H3K4me3=log($H3K4me3_ratio+0.01)/log(2);
$H3K27Ac=log($H3K27Ac_ratio+0.01)/log(2);
$H3K27me3=log($H3K27me3_ratio+0.01)/log(2);
$H3K9Ac=log($H3K9Ac_ratio+0.01)/log(2);
$H3K9me3=log($H3K9me3_ratio+0.01)/log(2);
$GROSEQ=log($NORM_GROSEQ+0.001)/log(10);
$NUCLEAR=log($NORM_NUCLEAR+0.001)/log(10);
$TOTAL=log($NORM_TOTAL_RNASEQ+0.001)/log(10);
$K27r=log(($H3K27Ac_ratio+0.01)/($H3K27me3_ratio+0.01))/log(2);
$K9r=log(($H3K9Ac_ratio+0.01)/($H3K9me3_ratio+0.01))/log(2);

$p300=log($p300_ratio+0.01)/log(2);
$LSD1=log($LSD1_ratio+0.01)/log(2);
$SMCX=log($SMCX_ratio+0.01)/log(2);

print VALUES_FOR_BOXPLOT_H3K4 "$H3K4me1\tA$P[1]_H3K4me1\n\tAY_GAP\n\tAZ_GAP\n";
print VALUES_FOR_BOXPLOT_H3K4 "$H3K4me2\tB$P[1]_H3K4me2\n\tBY_GAP\n\tBZ_GAP\n";
print VALUES_FOR_BOXPLOT_H3K4 "$H3K4me3\tC$P[1]_H3K4me3\n\tCY_GAP\n\tCZ_GAP\n";
print VALUES_FOR_BOXPLOT_H3K4 "$H3K27Ac\tD$P[1]_H3K27Ac\n\tDY_GAP\n\tDZ_GAP\n";
print VALUES_FOR_BOXPLOT_H3K4 "$H3K9Ac\tF$P[1]_H3K9Ac\n\tFY_GAP\n\tFZ_GAP\n";
print VALUES_FOR_BOXPLOT_H3K4 "$p300\tG$P[1]_p300\n\tGY_GAP\n\tGZ_GAP\n";
print VALUES_FOR_BOXPLOT_H3K4 "$LSD1\tH$P[1]_LSD1\n";


print VALUES_FOR_BOXPLOT_RNA "$GROSEQ\tA$P[1]_GROSEQ\n\tAY_GAP\n\tAZ_GAP\n";
print VALUES_FOR_BOXPLOT_RNA "$NUCLEAR\tB$P[1]_NUCLEAR\n\tBY_GAP\n\tBZ_GAP\n";
print VALUES_FOR_BOXPLOT_RNA "$TOTAL\tC$P[1]_TOTAL\n\tCY_GAP\n\tCZ_GAP\n";
print VALUES_FOR_BOXPLOT_RNA "$H3K27Ac\tD$P[1]_H3K27Ac\n\tDY_GAP\n\tDZ_GAP\n";
print VALUES_FOR_BOXPLOT_RNA "$H3K9Ac\tE$P[1]_H3K9Ac\n\tEY_GAP\n\tEZ_GAP\n";
print VALUES_FOR_BOXPLOT_RNA "$p300\tF$P[1]_p300\n\tFY_GAP\n\tFZ_GAP\n";
print VALUES_FOR_BOXPLOT_RNA "$LSD1\tG$P[1]_LSD1\n";


print VALUES_FOR_BOXPLOT_K9_K27 "$H3K27Ac\tD$P[1]_H3K27Ac\n\tDY_GAP\n\tDZ_GAP\n";
print VALUES_FOR_BOXPLOT_K9_K27 "$H3K27me3\tE$P[1]_H3K27me3\n\tEY_GAP\n\tEZ_GAP\n";
print VALUES_FOR_BOXPLOT_K9_K27 "$H3K9Ac\tF$P[1]_H3K9Ac\n\tFY_GAP\n\tFZ_GAP\n";
print VALUES_FOR_BOXPLOT_K9_K27 "$H3K9me3\tG$P[1]_H3K9me3\n\tGY_GAP\n\tGZ_GAP\n";
print VALUES_FOR_BOXPLOT_K9_K27 "$K27r\tN$P[1]_K27Ac-me3\n\tNY_GAP\n\tNZ_GAP\n";
print VALUES_FOR_BOXPLOT_K9_K27 "$K9r\tO$P[1]_K9Ac-me3\n";

print VALUES_FOR_BOXPLOT_LSD1_p300 "$p300\tK$P[1]_p300\n\tKZ_GAP\n";
print VALUES_FOR_BOXPLOT_LSD1_p300 "$LSD1\tL$P[1]_LSD1\n\tLZ_GAP\n";
print VALUES_FOR_BOXPLOT_LSD1_p300 "$SMCX\tM$P[1]_SMCX\n\tMZ_GAP\n";
print VALUES_FOR_BOXPLOT_LSD1_p300 "\tNZ_GAP\n\tOZ_GAP\n\tPZ_GAP\n\tQZ_GAP\n\tRZ_GAP\n\tSZ_GAP\n";



#print VALUES_FOR_BOXPLOT "$CpG_CONTENT{$Geneid}\tP$P[1]_CpG\n";
}
close LIST_OF_ENHANCERS;
close VALUES_FOR_BOXPLOT_H3K4;
close VALUES_FOR_BOXPLOT_RNA;
close VALUES_FOR_BOXPLOT_K9_K27;
close VALUES_FOR_BOXPLOT_LSD1_p300;


@ENHANCER_TYPES=qw(MONO MONOnDI DI TRI);

for $x (0 .. 3)
{
$ENHANCER_TYPE=$ENHANCER_TYPES[$x];
print color ("cyan");
print "$ENHANCER_TYPE"."methylated & LOW GROSEQ =$LOW_GROSEQ{$ENHANCER_TYPE}\n";
print "$ENHANCER_TYPE"."methylated & MED GROSEQ =$MED_GROSEQ{$ENHANCER_TYPE}\n";
print "$ENHANCER_TYPE"."methylated & HIGH GROSEQ=$HIGH_GROSEQ{$ENHANCER_TYPE}\n\n";
}

@BOXPLOTS=qw(Boxplot_H3K4 Boxplot_RNA Boxplot_K9K27 Boxplot_LSD1_p300);
for $x (0 .. $#BOXPLOTS)
{
$BOX=$BOXPLOTS[$x];
print color ("magenta"), "$BOX\n",color ("reset");
system ("Rscript BOXPLOT.R Values_For_$BOX.list $BOX.pdf");
}

print "Q1=$NQ1\nQ2=$NQ2\nQ3=$NQ3\nQ4=$NQ4\n";
