#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor;
use List::Util qw[min max];
system ("rm *.REGIONS; rm *.bed *.narrowPeak; ls -l; sleep 3");
##########################################
$BEDTOOLS="/home/saurabha/UTILITIES/BEDTOOLS/BEDTOOLS_2/bin";
$sortBed="$BEDTOOLS/sortBed";
$intersectBed="$BEDTOOLS/intersectBed";
$subtractBed="$BEDTOOLS/subtractBed";
$mergeBed="$BEDTOOLS/mergeBed";

############### GETTING CTCF +/- 500 bp peaks ##################
$CTCF_NARROWPEAKS="/mnt/iwase/AGARWAL/External_mES_Data_2/CTCF/MACS2_PEAKS/Merged_CTCF_3_replicates_SRR207081_SRR172853_SRR172854.nodup_p1e-12_peaks.narrowPeak";
$P300_NARROWPEAKS="/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/MACS2_PEAKS/p300_Peaks/MACS2_p300/p300_123_replicates_Input_None_q0.01_peaks.narrowPeak";
$DHS_NARROWPEAKS="/mnt/iwase/AGARWAL/UW_DHS_DATA/ALL_MACS2_PEAKS/UW_mES_DHS_no_subpeaks_q_0.05_peaks.narrowPeak";
$LSD1_NARROWPEAKS="/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/MACS2_PEAKS/LSD1_Peaks/LSD1_mES_ChipSeq_2_Young_SRR122470_19_bw1_mm9_Input_Merged_All_q0.05_peaks.narrowPeak";


@MARKS=("CTCF:::$CTCF_NARROWPEAKS","P300:::$P300_NARROWPEAKS","LSD1:::$LSD1_NARROWPEAKS","DHS:::$DHS_NARROWPEAKS");

for $x (0 .. 2)
{
($MARK,$NARROWPEAKS)=split(":::",$MARKS[$x]);
print "$x\t$MARK\t$NARROWPEAKSCTCF", `ls -l $NARROWPEAKS`,`wc -l $NARROWPEAKS`,"\n";

open (NARROWPEAKS,"cat $NARROWPEAKS|grep -v hap|grep -v random|grep -v chrM|");
open (PEAKS_500,">$MARK.bed");
open (SUMMITS,">SUMMITS_$MARK.bed");

while ($line = <NARROWPEAKS>) 
{
	chomp $line;$c++;
	@MARK_DATA=split("\t",$line);
	$CHR        = $MARK_DATA[0];
	$LEFT       = $MARK_DATA[1];
	$RIGHT	    = $MARK_DATA[2];
	$SUMMIT     = $LEFT+$MARK_DATA[9];
	$SUMMIT_R   = $SUMMIT+1;
	print SUMMITS "$CHR\t$SUMMIT\t$SUMMIT\n"; 
	$PEAK_LEFT = min($LEFT ,$SUMMIT-100);
	$PEAK_RIGHT= max($RIGHT,$SUMMIT+100);
	print PEAKS_500 "$CHR\t$PEAK_LEFT\t$PEAK_RIGHT\n";
}
close NARROWPEAKS; close PEAKS_500; close SUMMITS;
}
@COMPARISONS=qw(P300:::LSD1:::CTCF CTCF:::P300:::LSD1 LSD1:::P300:::CTCF);

for $x (0 .. 2)
{
($A,$B,$C)=split(":::",$COMPARISONS[$x]);
#AnB
print "\n$A\n";
system("$intersectBed -wa -u -a $A.bed -b $B.bed > $A\_n_$B.bed");
system("$intersectBed -wa -u -a $A.bed -b $C.bed > $A\_n_$C.bed");
system("$intersectBed -wa -u -a $A\_n_$B.bed -b $A\_n_$C.bed > $A\_n_$B$C.bed");
system("$intersectBed -wa -v -a $A.bed -b $B.bed $C.bed > $A\_Only.bed");

system ("wc -l $A*.bed");
}



