#!/usr/bin/perl
use Time::Local;
use Term::ANSIColor; 
$FEATURECOUNTS="/home/saurabha/UTILITIES/SUBREAD/subread-1.5.0-p1-source/bin/featureCounts";

################### SAF FILES ###################
$SAF_FOLDER="/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/DHS_SITES_INTERGENIC";
$SAF_FILE_300 ="$SAF_FOLDER/Mappable_Valid_Intergenic_DHS_SAF_300bp.SAF";
$SAF_FILE_500 ="$SAF_FOLDER/Mappable_Valid_Intergenic_DHS_SAF_500bp.SAF";
$SAF_FILE_750 ="$SAF_FOLDER/Mappable_Valid_Intergenic_DHS_SAF_750bp.SAF";
$SAF_FILE_1000="$SAF_FOLDER/Mappable_Valid_Intergenic_DHS_SAF_1000bp.SAF";

system ("wc -l $SAF_FILE_500; wc -l $SAF_FILE_750; wc -l $SAF_FILE_1000");
system ("head $SAF_FILE_500; head $SAF_FILE_750; head $SAF_FILE_1000");
#################################################
open (LEFT_500_BED,">Mappable_Valid_Intergenic_DHS_500bp_LEFT.bed");
open (RIGHT_500_BED,">Mappable_Valid_Intergenic_DHS_500bp_RIGHT.bed");

open (SAF_INFILE,"$SAF_FILE_500");

INFILE_LINE_500:while ($line = <SAF_INFILE>)
{
($DHS_ID,$CHR,$LEFT,$RIGHT,$STRAND)=split("\t",$line);
if (($DHS_ID eq "GeneID") || ($LEFT eq 'Start')){next INFILE_LINE_500;}
$SUMMIT=$LEFT+500;
$SUMMIT_L=$SUMMIT-50;
$SUMMIT_R=$SUMMIT+50;

print LEFT_500_BED  "$CHR\t$LEFT\t$SUMMIT_R\t$DHS_ID\t255\t.\n";
print RIGHT_500_BED "$CHR\t$SUMMIT_L\t$RIGHT\t$DHS_ID\t255\t.\n";
}
close SAF_INFILE;
close LEFT_500_BED;
close RIGHT_500_BED;

$H3K4me3_EXTENDED_BED_FILE="/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/Merged_Sorted_N_Extended_BED_BG_BW_FILES/Sorted_Extended_H3K4me3_WT_mES.bed.gz";
system("gzip -cd $H3K4me3_EXTENDED_BED_FILE |bedtools coverage -mean -a Mappable_Valid_Intergenic_DHS_500bp_LEFT.bed  -b stdin > H3K4me3_Coverage_500bp_Left_Of_DHS_summits.coverage &");
sleep 3;
system("gzip -cd $H3K4me3_EXTENDED_BED_FILE |bedtools coverage -mean -a Mappable_Valid_Intergenic_DHS_500bp_RIGHT.bed -b stdin > H3K4me3_Coverage_500bp_Right_Of_DHS_summits.coverage");

system("paste H3K4me3_Coverage_500bp_Left_Of_DHS_summits.coverage H3K4me3_Coverage_500bp_Right_Of_DHS_summits.coverage > H3K4me3_Coverage_500bp_around_DHS_summits.coverage");

#################### FEATURECOUNTS ####################
$SAF{'INPUT_WT_mES'}         =$SAF_FILE_1000;
$SAF{'H3K4me1_WT_mES'}       =$SAF_FILE_1000;
$SAF{'H3K4me2_WT_mES'}       =$SAF_FILE_750;
$SAF{'H3K4me3_WT_mES'}       =$SAF_FILE_750;
$SAF{'H3K27Ac_WT_mES'}       =$SAF_FILE_750;
$SAF{'H3K27me3_WT'}          =$SAF_FILE_1000;
$SAF{'H3K9Ac_WT'}            =$SAF_FILE_750;
$SAF{'H3K9me3_WT'}           =$SAF_FILE_1000;
$SAF{'GROSEQ_WT_mES'}        =$SAF_FILE_500;
$SAF{'NUCLEAR_RNASEQ_WT_mES'}=$SAF_FILE_500;
$SAF{'TOTAL_RNASEQ_WT_mES'}  =$SAF_FILE_500;
$SAF{'LSD1_mESc'}  =$SAF_FILE_300;
$SAF{'SMCX_mESc'}  =$SAF_FILE_300;
$SAF{'p300_mESc'}  =$SAF_FILE_300;
$SAF{'DHS_mESc'}   =$SAF_FILE_300;
#################################################
system ("ls -l");

$FOLDER="/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/BAM_FILES";
$OPTIONS="-T 16 -F SAF -O -g gene_id ";

system ("cat /scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/READ_COUNT/Formatted_READ_COUNTS.txt /scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/READ_COUNT_2/Formatted_READ_COUNTS.txt > READ_COUNTS_ALL.txt; sleep 3");

open (SAMPLE_INFO,"READ_COUNTS_ALL.txt");
open (READ_INFO,">Valid_Read_Info_Merged_mES_mm9_data_for_Enhancer_Prediction.txt");
$num=0;$FILE_LIST="";
READCOUNTS:while ($line = <SAMPLE_INFO>)
{
chomp $line;
if ($line eq "") {next READCOUNTS;}
$num++;
print color ("reset"), "\n\n\n$num\t$line\n";
($MARK,$T, $TOTAL, $R, $rRNA, $M, $mtRNA)=split("\t",$line);

$GOOD_READS=$TOTAL-$rRNA-$mtRNA;
print color ("cyan"), "$num\t$MARK\t$GOOD_READS\n"; 
print READ_INFO "$MARK|||$GOOD_READS\n "; 

if ($MARK eq 'p300_mESc') {$FOLDER="/scratch/iwase-lab/SAURABH/INTERGENIC_ENHANCERS/READ_COUNT_2";}
system ("ls -lh $FOLDER/$MARK.bam");
system ("ln -s $FOLDER/$MARK.bam $MARK.bam");
$SAF_FILE_USED=$SAF{$MARK};
print "SAF_FILE_USED=$SAF_FILE_USED\n";
system ("wc -l $SAF_FILE_USED");

$COUNT_COMMAND="$FEATURECOUNTS $OPTIONS -a $SAF_FILE_USED $MARK.bam -o $MARK.count";
print "$COUNT_COMMAND\n";
system ("$COUNT_COMMAND; sleep 3");

$FILE_LIST=$FILE_LIST." $MARK.count";
}
print "FILE_LIST=$FILE_LIST\n";
close SAMPLE_INFO;
close READ_INFO;
print "Counting Reads Done !!!\nNow Merging----\n";

#########################
$MERGE_COMMAND="paste$FILE_LIST > WT_mES_ALL_MARKS_For_Enhancer_Prediction_Intermediate";
print STDERR "$MERGE_COMMAN\n";
print color ("yellow"), "$MERGE_COMMAND\n";
system ("$MERGE_COMMAND;sleep 3");
system ("ls -l WT_mES_ALL_MARKS_For_Enhancer_Prediction_Intermediate");

open (FEATURECOUNTS_INPUT,"WT_mES_ALL_MARKS_For_Enhancer_Prediction_Intermediate");
open (FEATURECOUNTS_OUTPUT,">WT_mES_ALL_MARKS_For_Enhancer_Prediction");

$n=-1;
DHS:while ($line = <FEATURECOUNTS_INPUT>)
{
$n++;
chomp $line;
if ($n eq 0) {next DHS;}
@C=split("\t",$line);
$ID=$C[0];
$CHR=$C[1];
$PRINT="NO";

if (($C[0] eq $ID) && ($C[7] eq $ID) && ($C[14] eq $ID) && ($C[21] eq $ID) && ($C[28] eq $ID) && ($C[35] eq $ID) && ($C[42] eq $ID) && ($C[49] eq $ID) && ($C[56] eq $ID) && ($C[63] eq $ID) && ($C[70] eq $ID) && ($C[77] eq $ID) && ($C[84] eq $ID) && ($C[91] eq $ID) && ($C[1] eq $CHR) && ($C[8] eq $CHR) && ($C[15] eq $CHR) && ($C[22] eq $CHR) && ($C[29] eq $CHR) && ($C[36] eq $CHR) && ($C[43] eq $CHR) && ($C[50] eq $CHR) && ($C[57] eq $CHR) && ($C[64] eq $CHR) && ($C[71] eq $CHR)  && ($C[78] eq $CHR) && ($C[85] eq $CHR) && ($C[92] eq $CHR)) {$PRINT="YES";}

if ($PRINT eq "NO") {print color ("red"), "Values do Not match\n";die;}

if ($PRINT eq "YES") 
{
	print FEATURECOUNTS_OUTPUT "$C[0]\t$C[1]\t$C[2]\t$C[3]\t$C[4]\t$C[5]\t";
	print FEATURECOUNTS_OUTPUT "$C[6]\t$C[13]\t$C[20]\t$C[27]\t$C[34]\t$C[41]\t$C[48]\t$C[55]\t$C[62]\t$C[69]\t$C[76]\t$C[83]\t$C[90]\t$C[97]\n";
}
}
close FEATURECOUNTS_INPUT;
close FEATURECOUNTS_OUTPUT;

system ("cat WT_mES_ALL_MARKS_For_Enhancer_Prediction_Intermediate|grep -v Program:featureCounts |cut -f 1-6,7,14,21,28,35,42,49,56,63,70,77,84,91,98 > WT_mES_ALL_MARKS_For_Enhancer_Prediction_Check");
print "Now Checking the Difference\n";
system ("diff WT_mES_ALL_MARKS_For_Enhancer_Prediction_Check WT_mES_ALL_MARKS_For_Enhancer_Prediction");
print "Done !!!\nDone !!!\nDone !!!\nDone !!!\nDone !!!\n";

