/*  $Id: accguide.inc 611416 2020-07-06 14:17:04Z ucko $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Aaron Ucko
 *
 * File Description:
 *   Built-in copy of accguide.txt.
 *
 */

static const char* const kBuiltInGuide[] = {
    "# $Id: accguide.inc 611416 2020-07-06 14:17:04Z ucko $",
    "version  1 # of file format",
    "",
    "# three-letter-prefix protein accessions (traditionally with five digits)",
    "3+5  AAE  gb_patent_prot",
    "3+5  ??_  unknown # Longer variants (6-9 digits as of June 2018) are RefSeq",
    "3+5  A??  gb_prot",
    "3+7  A??  gb_prot",
    "3+9  A??  gb_prot",
    "3+11 A??  gb_prot",
    "3+5  B??  ddbj_prot",
    "3+7  B??  ddbj_prot",
    "3+9  B??  ddbj_prot",
    "3+11 B??  ddbj_prot",
    "3+5  C??  embl_prot *",
    "3+7  C??  embl_prot",
    "3+9  C??  embl_prot",
    "3+11 C??  embl_prot",
    "3+5  D??  gb_tpa_prot *",
    "3+7  D??  gb_tpa_prot",
    "3+9  D??  gb_tpa_prot",
    "3+11 D??  gb_tpa_prot",
    "3+5  E??  gb_wgs_prot",
    "3+7  E??  gb_wgs_prot # fallback to placate older clients",
    "3+7  E??  gb_wgsv_prot",
    "3+9  E??  gb_prot",
    "3+11 E??  gb_prot",
    "3+5  F??  ddbj_tpa_prot",
    "3+7  F??  ddbj_tpa_prot",
    "3+9  F??  ddbj_tpa_prot",
    "3+11 F??  ddbj_tpa_prot",
    "3+5  G??  ddbj_wgs_prot",
    "3+7  G??  ddbj_prot",
    "3+9  G??  ddbj_prot",
    "3+11 G??  ddbj_prot",
    "3+5  H??  gb_tpa_wgs_prot # fallback to placate older clients",
    "3+5  H??  gb_tpa_wgsv_prot",
    "3+7  H??  gb_tpa_wgs_prot # fallback to placate older clients",
    "3+7  H??  gb_tpa_wgsv_prot",
    "3+9  H??  gb_tpa_prot",
    "3+11 H??  gb_tpa_prot",
    "3+5  I??  ddbj_tpa_prot # fallback to placate older clients",
    "3+5  I??  ddbj_tpa_wgs_prot",
    "3+7  I??  ddbj_tpa_prot",
    "3+9  I??  ddbj_tpa_prot",
    "3+11 I??  ddbj_tpa_prot",
    "3+5  J??  gb_tsa_prot",
    "3+7  J??  gb_prot",
    "3+9  J??  gb_prot",
    "3+11 J??  gb_prot",
    "3+5  K??  gb_wgs_prot",
    "3+7  K??  gb_wgs_prot",
    "3+9  K??  gb_prot",
    "3+11 K??  gb_prot",
    "3+5  L??  ddbj_prot # mixed TSA and TLS",
    "3+7  L??  ddbj_prot",
    "3+9  L??  ddbj_prot",
    "3+11 L??  ddbj_prot",
    "3+5  M??  gb_wgs_prot # fallback to placate older clients",
    "3+5  M??  gb_wgsv_prot",
    "3+7  M??  gb_wgs_prot # fallback to placate older clients",
    "3+7  M??  gb_wgsv_prot",
    "3+9  M??  gb_prot",
    "3+11 M??  gb_prot",
    "3+5  N??  gb_wgs_prot # fallback to placate older clients",
    "3+5  N??  gb_wgsv_prot",
    "3+7  N??  gb_wgs_prot # fallback to placate older clients",
    "3+7  N??  gb_wgsv_prot",
    "3+9  N??  gb_prot",
    "3+11 N??  gb_prot",
    "3+5  O??  gb_wgs_prot",
    "3+7  O??  gb_prot",
    "3+9  O??  gb_prot",
    "3+11 O??  gb_prot",
    "3+5  P??  gb_wgs_prot",
    "3+7  P??  gb_prot",
    "3+9  P??  gb_prot",
    "3+11 P??  gb_prot",
    "3+5  Q??  gb_prot",
    "3+7  Q??  gb_prot",
    "3+9  Q??  gb_prot",
    "3+11 Q??  gb_prot",
    "3+5  R??  gb_wgs_prot",
    "3+7  R??  gb_prot",
    "3+9  R??  gb_prot",
    "3+11 R??  gb_prot",
    "3+5  S??  embl_prot *",
    "3+7  S??  embl_prot",
    "3+9  S??  embl_prot",
    "3+11 S??  embl_prot",
    "3+5  T??  gb_wgs_prot",
    "3+7  T??  gb_prot",
    "3+9  T??  gb_prot",
    "3+11 T??  gb_prot",
    "3+5  U??  gb_prot",
    "3+7  U??  gb_prot",
    "3+9  U??  gb_prot",
    "3+11 U??  gb_prot",
    "3+5  V??  embl_prot",
    "3+7  V??  embl_prot",
    "3+9  V??  embl_prot",
    "3+11 V??  embl_prot",
    "3+5  ???  unreserved_prot",
    "3+7  ???  unreserved_prot",
    "3+9  ???  unreserved_prot",
    "3+11 ???  unreserved_prot",
    "",
    "# Genome pipeline accessions",
    "4+9  GPC_  gpipe_chromosome",
    "4+9  GPG_  gpipe_genomic",
    "4+9  GPM_  gpipe_mrna",
    "4+9  GPN_  gpipe_other_nuc",
    "4+9  GPP_  gpipe_prot",
    "4+9  GPR_  gpipe_ncrna",
    "4+9  GPS_  gpipe_scaffold",
    "4+9  ZPC_  gpipe_chromosome",
    "4+9  ZPG_  gpipe_genomic",
    "4+9  ZPM_  gpipe_mrna",
    "4+9  ZPN_  gpipe_other_nuc",
    "4+9  ZPP_  gpipe_prot",
    "4+9  ZPR_  gpipe_ncrna",
    "4+9  ZPS_  gpipe_scaffold",
    "4+9  GP?_  gpipe_unreserved",
    "4+9  ZP?_  gpipe_unreserved",
    "",
    "# whole genome shotgun accessions",
    "4+8   ???_    unknown",
    "4+9   ???_    unknown",
    "4+10  ???_    unknown",
    "4+8   A???    gb_wgs_nuc",
    "4+9   A???    gb_wgs_nuc",
    "4+10  A???    gb_wgs_nuc",
    "4+8   B???    ddbj_wgs_nuc",
    "4+9   B???    ddbj_wgs_nuc",
    "4+10  B???    ddbj_wgs_nuc",
    "4+8   C???    embl_wgs_nuc",
    "4+9   C???    embl_wgs_nuc",
    "4+10  C???    embl_wgs_nuc",
    "4+8   D???    gb_tpa_wgs_nuc",
    "4+9   D???    gb_tpa_wgs_nuc",
    "4+10  D???    gb_tpa_wgs_nuc",
    "4+8   E???    ddbj_tpa_nuc # fallback to placate older clients",
    "4+9   E???    ddbj_tpa_nuc # fallback to placate older clients",
    "4+10  E???    ddbj_tpa_nuc # fallback to placate older clients",
    "4+8   E???    ddbj_tpa_wgs_nuc",
    "4+9   E???    ddbj_tpa_wgs_nuc",
    "4+10  E???    ddbj_tpa_wgs_nuc",
    "4+8   F???    embl_wgs_nuc",
    "4+9   F???    embl_wgs_nuc",
    "4+10  F???    embl_wgs_nuc",
    "4+8   G???    gb_tsa_nuc",
    "4+9   G???    gb_tsa_nuc",
    "4+10  G???    gb_tsa_nuc",
    "4+8   H???    embl_tsa_nuc",
    "4+9   H???    embl_tsa_nuc",
    "4+10  H???    embl_tsa_nuc",
    "4+8   I???    ddbj_tsa_nuc",
    "4+9   I???    ddbj_tsa_nuc",
    "4+10  I???    ddbj_tsa_nuc",
    "4+8   J???    gb_wgs_nuc",
    "4+9   J???    gb_wgs_nuc",
    "4+10  J???    gb_wgs_nuc",
    "4+8   K???    gb_wgs_nuc # fallback to placate older clients",
    "4+9   K???    gb_wgs_nuc # fallback to placate older clients",
    "4+10  K???    gb_wgs_nuc # fallback to placate older clients",
    "4+8   K???    gb_targeted_nuc",
    "4+9   K???    gb_targeted_nuc",
    "4+10  K???    gb_targeted_nuc",
    "4+8   L???    gb_wgs_nuc",
    "4+9   L???    gb_wgs_nuc",
    "4+10  L???    gb_wgs_nuc",
    "4+8   M???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+9   M???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+10  M???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+8   N???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+9   N???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+10  N???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+8   O???    embl_wgs_nuc",
    "4+9   O???    embl_wgs_nuc",
    "4+10  O???    embl_wgs_nuc",
    "4+8   P???    gb_wgs_nuc",
    "4+9   P???    gb_wgs_nuc",
    "4+10  P???    gb_wgs_nuc",
    "4+8   Q???    gb_wgs_nuc",
    "4+9   Q???    gb_wgs_nuc",
    "4+10  Q???    gb_wgs_nuc",
    "4+8   R???    gb_wgs_nuc",
    "4+9   R???    gb_wgs_nuc",
    "4+10  R???    gb_wgs_nuc",
    "4+8   S???    gb_wgs_nuc",
    "4+9   S???    gb_wgs_nuc",
    "4+10  S???    gb_wgs_nuc",
    "4+8   T???    ddbj_wgs_nuc # fallback to placate older clients",
    "4+9   T???    ddbj_wgs_nuc # fallback to placate older clients",
    "4+10  T???    ddbj_wgs_nuc # fallback to placate older clients",
    "4+8   T???    ddbj_targeted_nuc",
    "4+9   T???    ddbj_targeted_nuc",
    "4+10  T???    ddbj_targeted_nuc",
    "4+8   U???    embl_wgs_nuc",
    "4+9   U???    embl_wgs_nuc",
    "4+10  U???    embl_wgs_nuc",
    "4+8   V???    gb_wgs_nuc",
    "4+9   V???    gb_wgs_nuc",
    "4+10  V???    gb_wgs_nuc",
    "4+8   W???    gb_wgs_nuc",
    "4+9   W???    gb_wgs_nuc",
    "4+10  W???    gb_wgs_nuc",
    "4+8   ????    unreserved_nuc",
    "4+9   ????    unreserved_nuc",
    "4+10  ????    unreserved_nuc",
    "6+9   ?????_  unknown",
    "6+10  ?????_  unknown",
    "6+11  ?????_  unknown",
    "6+9   A?????  gb_wgs_nuc",
    "6+10  A?????  gb_wgs_nuc",
    "6+11  A?????  gb_wgs_nuc",
    "6+9   B?????  ddbj_wgs_nuc",
    "6+10  B?????  ddbj_wgs_nuc",
    "6+11  B?????  ddbj_wgs_nuc",
    "6+9   C?????  embl_wgs_nuc *",
    "6+10  C?????  embl_wgs_nuc",
    "6+11  C?????  embl_wgs_nuc",
    "6+9   D?????  gb_tpa_wgs_nuc",
    "6+10  D?????  gb_tpa_wgs_nuc",
    "6+11  D?????  gb_tpa_wgs_nuc",
    "6+9   J?????  gb_wgs_nuc",
    "6+10  J?????  gb_wgs_nuc",
    "6+11  J?????  gb_wgs_nuc",
    "6+9   ??????  unreserved_nuc",
    "6+10  ??????  unreserved_nuc",
    "6+11  ??????  unreserved_nuc",
    "",
    "# Mass sequence Genome for Annotation",
    "5+7   A???? ddbj_other_nuc",
    "5+7   A???? ddbj_mga",
    "",
    "# Named annotation track (new as of September 2008)",
    "3+9  AT_  local # fallback to placate older clients",
    "3+9  AT_  named_annot_track",
    "",
    "# NCBI reference sequence accessions",
    "3+6  AC_      refseq_chromosome",
    "3+6  AP_      refseq_prot",
    "3+6  NC_      refseq_chromosome",
    "3+6  NG_      refseq_genomic",
    "3+6  NM_      refseq_mrna",
    "3+9  NM_      refseq_mrna",
    "3+6  NP_      refseq_prot",
    "3+9  NP_      refseq_prot",
    "3+6  NR_      refseq_ncrna",
    "3+6  NS_      refseq_genome",
    "3+6  NT_      refseq_contig",
    "3+6  NW_      refseq_wgs_intermed",
    "3+9  NW_      refseq_wgs_intermed",
    "5+6  NZ_??    refseq_contig",
    "7+8  NZ_????  refseq_wgs_nuc",
    "7+9  NZ_????  refseq_wgs_nuc",
    "7+10 NZ_????  refseq_wgs_nuc",
    "9+9  NZ_?????? refseq_wgs_nuc",
    "9+10 NZ_?????? refseq_wgs_nuc",
    "9+11 NZ_?????? refseq_wgs_nuc",
    "3+9  WC_      refseq_chromosome # fallback to placate older clients",
    "3+9  WC_      refseq_chromosome_ncbo",
    "3+9  WP_      refseq_prot # fallback to placate older clients",
    "3+9  WP_      refseq_unique_prot",
    "3+9  WT_      refseq_contig # fallback to placate older clients",
    "3+9  WT_      refseq_contig_ncbo",
    "3+6  XM_      refseq_mrna_predicted",
    "3+9  XM_      refseq_mrna_predicted",
    "3+6  XP_      refseq_prot_predicted",
    "3+9  XP_      refseq_prot_predicted",
    "3+6  XR_      refseq_ncrna_predicted",
    "3+9  XR_      refseq_ncrna_predicted",
    "3+6  YP_      refseq_prot_predicted",
    "3+9  YP_      refseq_prot_predicted",
    "3+8  ZP_      refseq_wgs_prot",
    "3+6  ??_      refseq_unreserved",
    "3+7  ??_      refseq_unreserved",
    "3+8  ??_      refseq_unreserved",
    "3+9  ??_      refseq_unreserved",
    "",
    "# Unusually structured GenBank accessions",
    "4+6  MAP_  gb_other_nuc # Fallback to placate older clients",
    "4+6  MAP_  gb_optical_map",
    "",
    "# 6-character accessions (mixed, but generally nucleotide)",
    "1+5  A  embl_patent",
    "1+5  B  gb_gss",
    "1+5  C  ddbj_est *",
    "1+5  D  ddbj_dirsub *",
    "1+5  E  ddbj_patent",
    "1+5  F  embl_est *",
    "1+5  G  gb_sts",
    "1+5  H  gb_est",
    "1+5  I  gb_patent",
    "1+5  J  gsdb_dirsub",
    "1+5  K  gsdb_dirsub",
    "1+5  L  gsdb_dirsub *",
    "1+5  M  gsdb_dirsub *",
    "1+5  N  unreserved_nuc *",
    "1+5  O  swissprot",
    "1+5  P  swissprot",
    "1+5  Q  swissprot",
    "1+5  R  gb_est",
    "1+5  S  gb_backbone",
    "1+5  T  gb_est *",
    "1+5  U  gb_dirsub *",
    "1+5  V  embl_dirsub",
    "1+5  W  gb_est",
    "1+5  X  embl_dirsub *",
    "1+5  Y  embl_dirsub *",
    "1+5  Z  embl_dirsub *",
    "1+5  ?  unreserved_nuc",
    "",
    "# two-letter-prefix nucleotide accessions (traditionally with six digits)",
    "2+6  AA  gb_est",
    "2+8  AA  gb_other_nuc",
    "2+10 AA  gb_other_nuc",
    "2+6  AB  ddbj_dirsub *",
    "2+8  AB  ddbj_other_nuc",
    "2+10 AB  ddbj_other_nuc",
    "2+6  AC  gb_htgs",
    "2+8  AC  gb_other_nuc",
    "2+10 AC  gb_other_nuc",
    "2+6  AD  gb_gsdb",
    "2+8  AD  gb_other_nuc",
    "2+10 AD  gb_other_nuc",
    "2+6  AE  gb_genome",
    "2+8  AE  gb_other_nuc",
    "2+10 AE  gb_other_nuc",
    "2+6  AF  gb_dirsub *",
    "2+8  AF  gb_other_nuc",
    "2+10 AF  gb_other_nuc",
    "2+6  AG  ddbj_gss *",
    "2+8  AG  ddbj_other_nuc",
    "2+10 AG  ddbj_other_nuc",
    "2+6  AH  gb_segset",
    "2+8  AH  gb_other_nuc",
    "2+10 AH  gb_other_nuc",
    "2+6  AI  gb_est",
    "2+8  AI  gb_other_nuc",
    "2+10 AI  gb_other_nuc",
    "2+6  AJ  embl_dirsub *",
    "2+8  AJ  embl_other_nuc",
    "2+10 AJ  embl_other_nuc",
    "2+6  AK  ddbj_mrna",
    "2+8  AK  ddbj_other_nuc",
    "2+10 AK  ddbj_other_nuc",
    "2+6  AL  embl_dirsub *",
    "2+8  AL  embl_other_nuc",
    "2+10 AL  embl_other_nuc",
    "2+6  AM  embl_dirsub *",
    "2+8  AM  embl_other_nuc",
    "2+10 AM  embl_other_nuc",
    "2+6  AN  embl_con",
    "2+8  AN  embl_other_nuc",
    "2+10 AN  embl_other_nuc",
    "2+6  AO  unreserved_nuc",
    "2+8  AO  unreserved_nuc",
    "2+10 AO  unreserved_nuc",
    "2+6  AP  ddbj_genome",
    "2+8  AP  ddbj_other_nuc",
    "2+10 AP  ddbj_other_nuc",
    "2+6  AQ  gb_gss",
    "2+8  AQ  gb_other_nuc",
    "2+10 AQ  gb_other_nuc",
    "2+6  AR  gb_patent",
    "2+8  AR  gb_other_nuc",
    "2+10 AR  gb_other_nuc",
    "2+6  AS  gb_other_nuc",
    "2+8  AS  gb_other_nuc",
    "2+10 AS  gb_other_nuc",
    "2+6  AT  ddbj_est",
    "2+8  AT  ddbj_other_nuc",
    "2+10 AT  ddbj_other_nuc",
    "2+6  AU  ddbj_est *",
    "2+8  AU  ddbj_other_nuc",
    "2+10 AU  ddbj_other_nuc",
    "2+6  AV  ddbj_est",
    "2+8  AV  ddbj_other_nuc",
    "2+10 AV  ddbj_other_nuc",
    "2+6  AW  gb_est",
    "2+8  AW  gb_other_nuc",
    "2+10 AW  gb_other_nuc",
    "2+6  AX  embl_patent *",
    "2+8  AX  embl_other_nuc",
    "2+10 AX  embl_other_nuc",
    "2+6  AY  gb_dirsub *",
    "2+8  AY  gb_other_nuc",
    "2+10 AY  gb_other_nuc",
    "2+6  AZ  gb_gss",
    "2+8  AZ  gb_other_nuc",
    "2+10 AZ  gb_other_nuc",
    "2+6  BA  ddbj_con",
    "2+8  BA  ddbj_other_nuc",
    "2+10 BA  ddbj_other_nuc",
    "2+6  BB  ddbj_est",
    "2+8  BB  ddbj_other_nuc",
    "2+10 BB  ddbj_other_nuc",
    "2+6  BC  gb_cdna",
    "2+8  BC  gb_other_nuc",
    "2+10 BC  gb_other_nuc",
    "2+6  BD  ddbj_patent",
    "2+8  BD  ddbj_other_nuc",
    "2+10 BD  ddbj_other_nuc",
    "2+6  BE  gb_est",
    "2+8  BE  gb_other_nuc",
    "2+10 BE  gb_other_nuc",
    "2+6  BF  gb_est",
    "2+8  BF  gb_other_nuc",
    "2+10 BF  gb_other_nuc",
    "2+6  BG  gb_est",
    "2+8  BG  gb_other_nuc",
    "2+10 BG  gb_other_nuc",
    "2+6  BH  gb_gss",
    "2+8  BH  gb_other_nuc",
    "2+10 BH  gb_other_nuc",
    "2+6  BI  gb_est",
    "2+8  BI  gb_other_nuc",
    "2+10 BI  gb_other_nuc",
    "2+6  BJ  ddbj_est",
    "2+8  BJ  ddbj_other_nuc",
    "2+10 BJ  ddbj_other_nuc",
    "2+6  BK  gb_tpa_nuc",
    "2+8  BK  gb_tpa_nuc",
    "2+10 BK  gb_tpa_nuc",
    "2+6  BL  gb_tpa_nuc # Fallback to placate older clients",
    "2+6  BL  gb_tpa_segset # Formally CON but not necessarily genomic",
    "2+8  BL  gb_tpa_nuc",
    "2+10 BL  gb_tpa_nuc",
    "2+6  BM  gb_est",
    "2+8  BM  gb_other_nuc",
    "2+10 BM  gb_other_nuc",
    "2+6  BN  embl_tpa_nuc",
    "2+8  BN  embl_tpa_nuc",
    "2+10 BN  embl_tpa_nuc",
    "2+6  BO  unreserved_nuc",
    "2+8  BO  unreserved_nuc",
    "2+10 BO  unreserved_nuc",
    "2+6  BP  ddbj_est",
    "2+8  BP  ddbj_other_nuc",
    "2+10 BP  ddbj_other_nuc",
    "2+6  BQ  gb_est",
    "2+8  BQ  gb_other_nuc",
    "2+10 BQ  gb_other_nuc",
    "2+6  BR  ddbj_tpa_nuc",
    "2+8  BR  ddbj_tpa_nuc",
    "2+10 BR  ddbj_tpa_nuc",
    "2+6  BS  ddbj_genome # chimp genomes, specifically",
    "2+8  BS  ddbj_other_nuc",
    "2+10 BS  ddbj_other_nuc",
    "2+6  BT  gb_cdna",
    "2+8  BT  gb_other_nuc",
    "2+10 BT  gb_other_nuc",
    "2+6  BU  gb_est",
    "2+8  BU  gb_other_nuc",
    "2+10 BU  gb_other_nuc",
    "2+6  BV  gb_sts",
    "2+8  BV  gb_other_nuc",
    "2+10 BV  gb_other_nuc",
    "2+6  BW  ddbj_est",
    "2+8  BW  ddbj_other_nuc",
    "2+10 BW  ddbj_other_nuc",
    "2+6  BX  embl_dirsub *",
    "2+8  BX  embl_other_nuc",
    "2+10 BX  embl_other_nuc",
    "2+6  BY  ddbj_est",
    "2+8  BY  ddbj_other_nuc",
    "2+10 BY  ddbj_other_nuc",
    "2+6  BZ  gb_gss",
    "2+8  BZ  gb_other_nuc",
    "2+10 BZ  gb_other_nuc",
    "2+6  CA  gb_est",
    "2+8  CA  gb_other_nuc",
    "2+10 CA  gb_other_nuc",
    "2+6  CB  gb_est",
    "2+8  CB  gb_other_nuc",
    "2+10 CB  gb_other_nuc",
    "2+6  CC  gb_gss",
    "2+8  CC  gb_other_nuc",
    "2+10 CC  gb_other_nuc",
    "2+6  CD  gb_est",
    "2+8  CD  gb_other_nuc",
    "2+10 CD  gb_other_nuc",
    "2+6  CE  gb_gss",
    "2+8  CE  gb_other_nuc",
    "2+10 CE  gb_other_nuc",
    "2+6  CF  gb_est",
    "2+8  CF  gb_other_nuc",
    "2+10 CF  gb_other_nuc",
    "2+6  CG  gb_gss",
    "2+8  CG  gb_other_nuc",
    "2+10 CG  gb_other_nuc",
    "2+6  CH  gb_con",
    "2+8  CH  gb_other_nuc",
    "2+10 CH  gb_other_nuc",
    "2+6  CI  ddbj_est",
    "2+8  CI  ddbj_other_nuc",
    "2+10 CI  ddbj_other_nuc",
    "2+6  CJ  ddbj_est",
    "2+8  CJ  ddbj_other_nuc",
    "2+10 CJ  ddbj_other_nuc",
    "2+6  CK  gb_est",
    "2+8  CK  gb_other_nuc",
    "2+10 CK  gb_other_nuc",
    "2+6  CL  gb_gss",
    "2+8  CL  gb_other_nuc",
    "2+10 CL  gb_other_nuc",
    "2+6  CM  gb_con # Fallback to placate older clients",
    "2+6  CM  gb_chromosome",
    "2+8  CM  gb_other_nuc",
    "2+10 CM  gb_other_nuc",
    "2+6  CN  gb_est",
    "2+8  CN  gb_other_nuc",
    "2+10 CN  gb_other_nuc",
    "2+6  CO  gb_est",
    "2+8  CO  gb_other_nuc",
    "2+10 CO  gb_other_nuc",
    "2+6  CP  gb_genome *",
    "2+8  CP  gb_other_nuc",
    "2+10 CP  gb_other_nuc",
    "2+6  CQ  embl_patent",
    "2+8  CQ  embl_other_nuc",
    "2+10 CQ  embl_other_nuc",
    "2+6  CR  embl_dirsub *",
    "2+8  CR  embl_other_nuc",
    "2+10 CR  embl_other_nuc",
    "2+6  CS  embl_patent",
    "2+8  CS  embl_other_nuc",
    "2+10 CS  embl_other_nuc",
    "2+6  CT  embl_dirsub *",
    "2+8  CT  embl_other_nuc",
    "2+10 CT  embl_other_nuc",
    "2+6  CU  embl_dirsub *",
    "2+8  CU  embl_other_nuc",
    "2+10 CU  embl_other_nuc",
    "2+6  CV  gb_est",
    "2+8  CV  gb_other_nuc",
    "2+10 CV  gb_other_nuc",
    "2+6  CW  gb_gss",
    "2+8  CW  gb_other_nuc",
    "2+10 CW  gb_other_nuc",
    "2+6  CX  gb_est",
    "2+8  CX  gb_other_nuc",
    "2+10 CX  gb_other_nuc",
    "2+6  CY  gb_genome",
    "2+8  CY  gb_other_nuc",
    "2+10 CY  gb_other_nuc",
    "2+6  CZ  gb_gss",
    "2+8  CZ  gb_other_nuc",
    "2+10 CZ  gb_other_nuc",
    "2+6  DA  ddbj_est",
    "2+8  DA  ddbj_other_nuc",
    "2+10 DA  ddbj_other_nuc",
    "2+6  DB  ddbj_est",
    "2+8  DB  ddbj_other_nuc",
    "2+10 DB  ddbj_other_nuc",
    "2+6  DC  ddbj_est",
    "2+8  DC  ddbj_other_nuc",
    "2+10 DC  ddbj_other_nuc",
    "2+6  DD  ddbj_patent",
    "2+8  DD  ddbj_other_nuc",
    "2+10 DD  ddbj_other_nuc",
    "2+6  DE  ddbj_gss *",
    "2+8  DE  ddbj_other_nuc",
    "2+10 DE  ddbj_other_nuc",
    "2+6  DF  ddbj_con",
    "2+8  DF  ddbj_other_nuc",
    "2+10 DF  ddbj_other_nuc",
    "2+6  DG  ddbj_con",
    "2+8  DG  ddbj_other_nuc",
    "2+10 DG  ddbj_other_nuc",
    "2+6  DH  ddbj_gss",
    "2+8  DH  ddbj_other_nuc",
    "2+10 DH  ddbj_other_nuc",
    "2+6  DI  ddbj_patent # from Korea",
    "2+8  DI  ddbj_other_nuc",
    "2+10 DI  ddbj_other_nuc",
    "2+6  DJ  ddbj_patent",
    "2+8  DJ  ddbj_other_nuc",
    "2+10 DJ  ddbj_other_nuc",
    "2+6  DK  ddbj_est",
    "2+8  DK  ddbj_other_nuc",
    "2+10 DK  ddbj_other_nuc",
    "2+6  DL  ddbj_patent",
    "2+8  DL  ddbj_other_nuc",
    "2+10 DL  ddbj_other_nuc",
    "2+6  DM  ddbj_patent",
    "2+8  DM  ddbj_other_nuc",
    "2+10 DM  ddbj_other_nuc",
    "2+6  DN  gb_est",
    "2+8  DN  gb_other_nuc",
    "2+10 DN  gb_other_nuc",
    "2+6  DO  unreserved_nuc",
    "2+8  DO  unreserved_nuc",
    "2+10 DO  unreserved_nuc",
    "2+6  DP  gb_htgs # HTG scaffolds; look like gb_con, but built on htgs parts",
    "2+8  DP  gb_other_nuc",
    "2+10 DP  gb_other_nuc",
    "2+6  DQ  gb_dirsub *",
    "2+8  DQ  gb_other_nuc",
    "2+10 DQ  gb_other_nuc",
    "2+6  DR  gb_est",
    "2+8  DR  gb_other_nuc",
    "2+10 DR  gb_other_nuc",
    "2+6  DS  gb_con *",
    "2+8  DS  gb_other_nuc",
    "2+10 DS  gb_other_nuc",
    "2+6  DT  gb_est",
    "2+8  DT  gb_other_nuc",
    "2+10 DT  gb_other_nuc",
    "2+6  DU  gb_gss",
    "2+8  DU  gb_other_nuc",
    "2+10 DU  gb_other_nuc",
    "2+6  DV  gb_est",
    "2+8  DV  gb_other_nuc",
    "2+10 DV  gb_other_nuc",
    "2+6  DW  gb_est",
    "2+8  DW  gb_other_nuc",
    "2+10 DW  gb_other_nuc",
    "2+6  DX  gb_gss",
    "2+8  DX  gb_other_nuc",
    "2+10 DX  gb_other_nuc",
    "2+6  DY  gb_est",
    "2+8  DY  gb_other_nuc",
    "2+10 DY  gb_other_nuc",
    "2+6  DZ  gb_patent",
    "2+8  DZ  gb_other_nuc",
    "2+10 DZ  gb_other_nuc",
    "2+6  EA  gb_patent",
    "2+8  EA  gb_other_nuc",
    "2+10 EA  gb_other_nuc",
    "2+6  EB  gb_est",
    "2+8  EB  gb_other_nuc",
    "2+10 EB  gb_other_nuc",
    "2+6  EC  gb_est",
    "2+8  EC  gb_other_nuc",
    "2+10 EC  gb_other_nuc",
    "2+6  ED  gb_gss",
    "2+8  ED  gb_other_nuc",
    "2+10 ED  gb_other_nuc",
    "2+6  EE  gb_est",
    "2+8  EE  gb_other_nuc",
    "2+10 EE  gb_other_nuc",
    "2+6  EF  gb_dirsub *",
    "2+8  EF  gb_other_nuc",
    "2+10 EF  gb_other_nuc",
    "2+6  EG  gb_est",
    "2+8  EG  gb_other_nuc",
    "2+10 EG  gb_other_nuc",
    "2+6  EH  gb_est",
    "2+8  EH  gb_other_nuc",
    "2+10 EH  gb_other_nuc",
    "2+6  EI  gb_gss",
    "2+8  EI  gb_other_nuc",
    "2+10 EI  gb_other_nuc",
    "2+6  EJ  gb_gss",
    "2+8  EJ  gb_other_nuc",
    "2+10 EJ  gb_other_nuc",
    "2+6  EK  gb_gss",
    "2+8  EK  gb_other_nuc",
    "2+10 EK  gb_other_nuc",
    "2+6  EL  gb_est",
    "2+8  EL  gb_other_nuc",
    "2+10 EL  gb_other_nuc",
    "2+6  EM  gb_con",
    "2+8  EM  gb_other_nuc",
    "2+10 EM  gb_other_nuc",
    "2+6  EN  gb_con",
    "2+8  EN  gb_other_nuc",
    "2+10 EN  gb_other_nuc",
    "2+6  EO  gb_other_nuc # allocated but left unused to avoid O/0 confusion",
    "2+8  EO  gb_other_nuc # allocated but left unused to avoid O/0 confusion",
    "2+10 EO  gb_other_nuc # allocated but left unused to avoid O/0 confusion",
    "2+6  EP  gb_con",
    "2+8  EP  gb_other_nuc",
    "2+10 EP  gb_other_nuc",
    "2+6  EQ  gb_con",
    "2+8  EQ  gb_other_nuc",
    "2+10 EQ  gb_other_nuc",
    "2+6  ER  gb_gss",
    "2+8  ER  gb_other_nuc",
    "2+10 ER  gb_other_nuc",
    "2+6  ES  gb_est",
    "2+8  ES  gb_other_nuc",
    "2+10 ES  gb_other_nuc",
    "2+6  ET  gb_gss",
    "2+8  ET  gb_other_nuc",
    "2+10 ET  gb_other_nuc",
    "2+6  EU  gb_dirsub *",
    "2+8  EU  gb_other_nuc",
    "2+10 EU  gb_other_nuc",
    "2+6  EV  gb_est",
    "2+8  EV  gb_other_nuc",
    "2+10 EV  gb_other_nuc",
    "2+6  EW  gb_est",
    "2+8  EW  gb_other_nuc",
    "2+10 EW  gb_other_nuc",
    "2+6  EX  gb_est",
    "2+8  EX  gb_other_nuc",
    "2+10 EX  gb_other_nuc",
    "2+6  EY  gb_est",
    "2+8  EY  gb_other_nuc",
    "2+10 EY  gb_other_nuc",
    "2+6  EZ  gb_tsa_nuc",
    "2+8  EZ  gb_other_nuc",
    "2+10 EZ  gb_other_nuc",
    "2+6  FA  gb_con",
    "2+8  FA  gb_other_nuc",
    "2+10 FA  gb_other_nuc",
    "2+6  FB  embl_patent",
    "2+8  FB  embl_other_nuc",
    "2+10 FB  embl_other_nuc",
    "2+6  FC  gb_est",
    "2+8  FC  gb_other_nuc",
    "2+10 FC  gb_other_nuc",
    "2+6  FD  gb_est",
    "2+8  FD  gb_other_nuc",
    "2+10 FD  gb_other_nuc",
    "2+6  FE  gb_est",
    "2+8  FE  gb_other_nuc",
    "2+10 FE  gb_other_nuc",
    "2+6  FF  gb_est",
    "2+8  FF  gb_other_nuc",
    "2+10 FF  gb_other_nuc",
    "2+6  FG  gb_est",
    "2+8  FG  gb_other_nuc",
    "2+10 FG  gb_other_nuc",
    "2+6  FH  gb_gss",
    "2+8  FH  gb_other_nuc",
    "2+10 FH  gb_other_nuc",
    "2+6  FI  gb_gss",
    "2+8  FI  gb_other_nuc",
    "2+10 FI  gb_other_nuc",
    "2+6  FJ  gb_dirsub *",
    "2+8  FJ  gb_other_nuc",
    "2+10 FJ  gb_other_nuc",
    "2+6  FK  gb_est",
    "2+8  FK  gb_other_nuc",
    "2+10 FK  gb_other_nuc",
    "2+6  FL  gb_est",
    "2+8  FL  gb_other_nuc",
    "2+10 FL  gb_other_nuc",
    "2+6  FM  embl_dirsub *",
    "2+8  FM  embl_other_nuc",
    "2+10 FM  embl_other_nuc",
    "2+6  FN  embl_dirsub *",
    "2+8  FN  embl_other_nuc",
    "2+10 FN  embl_other_nuc",
    "2+6  FO  embl_dirsub *",
    "2+8  FO  embl_other_nuc",
    "2+10 FO  embl_other_nuc",
    "2+6  FP  embl_dirsub *",
    "2+8  FP  embl_other_nuc",
    "2+10 FP  embl_other_nuc",
    "2+6  FQ  embl_dirsub *",
    "2+8  FQ  embl_other_nuc",
    "2+10 FQ  embl_other_nuc",
    "2+6  FR  embl_dirsub *",
    "2+8  FR  embl_other_nuc",
    "2+10 FR  embl_other_nuc",
    "2+6  FS  ddbj_est",
    "2+8  FS  ddbj_other_nuc",
    "2+10 FS  ddbj_other_nuc",
    "2+6  FT  ddbj_gss",
    "2+8  FT  ddbj_other_nuc",
    "2+10 FT  ddbj_other_nuc",
    "2+6  FU  ddbj_patent",
    "2+8  FU  ddbj_other_nuc",
    "2+10 FU  ddbj_other_nuc",
    "2+6  FV  ddbj_patent",
    "2+8  FV  ddbj_other_nuc",
    "2+10 FV  ddbj_other_nuc",
    "2+6  FW  ddbj_patent",
    "2+8  FW  ddbj_other_nuc",
    "2+10 FW  ddbj_other_nuc",
    "2+6  FX  ddbj_tsa_nuc",
    "2+8  FX  ddbj_other_nuc",
    "2+10 FX  ddbj_other_nuc",
    "2+6  FY  ddbj_est",
    "2+8  FY  ddbj_other_nuc",
    "2+10 FY  ddbj_other_nuc",
    "2+6  FZ  ddbj_patent",
    "2+8  FZ  ddbj_other_nuc",
    "2+10 FZ  ddbj_other_nuc",
    "2+6  GA  ddbj_gss",
    "2+8  GA  ddbj_other_nuc",
    "2+10 GA  ddbj_other_nuc",
    "2+6  GB  ddbj_patent",
    "2+8  GB  ddbj_other_nuc",
    "2+10 GB  ddbj_other_nuc",
    "2+6  GC  gb_patent",
    "2+8  GC  gb_other_nuc",
    "2+10 GC  gb_other_nuc",
    "2+6  GD  gb_est",
    "2+8  GD  gb_other_nuc",
    "2+10 GD  gb_other_nuc",
    "2+6  GE  gb_est",
    "2+8  GE  gb_other_nuc",
    "2+10 GE  gb_other_nuc",
    "2+6  GF  gb_sts",
    "2+8  GF  gb_other_nuc",
    "2+10 GF  gb_other_nuc",
    "2+6  GG  gb_con",
    "2+8  GG  gb_other_nuc",
    "2+10 GG  gb_other_nuc",
    "2+6  GH  gb_est",
    "2+8  GH  gb_other_nuc",
    "2+10 GH  gb_other_nuc",
    "2+6  GI  unreserved_nuc # deliberately skipped",
    "2+8  GI  unreserved_nuc # deliberately skipped",
    "2+10 GI  unreserved_nuc # deliberately skipped",
    "2+6  GJ  gb_tpa_con",
    "2+8  GJ  gb_tpa_nuc",
    "2+10 GJ  gb_tpa_nuc",
    "2+6  GK  gb_tpa_chromosome",
    "2+8  GK  gb_tpa_nuc",
    "2+10 GK  gb_tpa_nuc",
    "2+6  GL  gb_con",
    "2+8  GL  gb_other_nuc",
    "2+10 GL  gb_other_nuc",
    "2+6  GM  embl_patent",
    "2+8  GM  embl_other_nuc",
    "2+10 GM  embl_other_nuc",
    "2+6  GN  embl_patent",
    "2+8  GN  embl_other_nuc",
    "2+10 GN  embl_other_nuc",
    "2+6  GO  gb_est",
    "2+8  GO  gb_other_nuc",
    "2+10 GO  gb_other_nuc",
    "2+6  GP  gb_patent",
    "2+8  GP  gb_other_nuc",
    "2+10 GP  gb_other_nuc",
    "2+6  GQ  gb_dirsub *",
    "2+8  GQ  gb_other_nuc",
    "2+10 GQ  gb_other_nuc",
    "2+6  GR  gb_est",
    "2+8  GR  gb_other_nuc",
    "2+10 GR  gb_other_nuc",
    "2+6  GS  gb_gss",
    "2+8  GS  gb_other_nuc",
    "2+10 GS  gb_other_nuc",
    "2+6  GT  gb_est",
    "2+8  GT  gb_other_nuc",
    "2+10 GT  gb_other_nuc",
    "2+6  GU  gb_dirsub *",
    "2+8  GU  gb_other_nuc",
    "2+10 GU  gb_other_nuc",
    "2+6  GV  gb_patent",
    "2+8  GV  gb_other_nuc",
    "2+10 GV  gb_other_nuc",
    "2+6  GW  gb_est",
    "2+8  GW  gb_other_nuc",
    "2+10 GW  gb_other_nuc",
    "2+6  GX  gb_patent",
    "2+8  GX  gb_other_nuc",
    "2+10 GX  gb_other_nuc",
    "2+6  GY  gb_patent",
    "2+8  GY  gb_other_nuc",
    "2+10 GY  gb_other_nuc",
    "2+6  GZ  gb_patent",
    "2+8  GZ  gb_other_nuc",
    "2+10 GZ  gb_other_nuc",
    "2+6  HA  embl_patent",
    "2+8  HA  embl_other_nuc",
    "2+10 HA  embl_other_nuc",
    "2+6  HB  embl_patent",
    "2+8  HB  embl_other_nuc",
    "2+10 HB  embl_other_nuc",
    "2+6  HC  embl_patent",
    "2+8  HC  embl_other_nuc",
    "2+10 HC  embl_other_nuc",
    "2+6  HD  embl_patent",
    "2+8  HD  embl_other_nuc",
    "2+10 HD  embl_other_nuc",
    "2+6  HE  embl_dirsub *",
    "2+8  HE  embl_other_nuc",
    "2+10 HE  embl_other_nuc",
    "2+6  HF  embl_dirsub *",
    "2+8  HF  embl_other_nuc",
    "2+10 HF  embl_other_nuc",
    "2+6  HG  embl_dirsub *",
    "2+8  HG  embl_other_nuc",
    "2+10 HG  embl_other_nuc",
    "2+6  HH  embl_patent",
    "2+8  HH  embl_other_nuc",
    "2+10 HH  embl_other_nuc",
    "2+6  HI  embl_patent",
    "2+8  HI  embl_other_nuc",
    "2+10 HI  embl_other_nuc",
    "2+6  HJ  gb_patent",
    "2+8  HJ  gb_other_nuc",
    "2+10 HJ  gb_other_nuc",
    "2+6  HK  gb_patent",
    "2+8  HK  gb_other_nuc",
    "2+10 HK  gb_other_nuc",
    "2+6  HL  gb_patent",
    "2+8  HL  gb_other_nuc",
    "2+10 HL  gb_other_nuc",
    "2+6  HM  gb_dirsub *",
    "2+8  HM  gb_other_nuc",
    "2+10 HM  gb_other_nuc",
    "2+6  HN  gb_gss",
    "2+8  HN  gb_other_nuc",
    "2+10 HN  gb_other_nuc",
    "2+6  HO  gb_est",
    "2+8  HO  gb_other_nuc",
    "2+10 HO  gb_other_nuc",
    "2+6  HP  gb_tsa_nuc",
    "2+8  HP  gb_other_nuc",
    "2+10 HP  gb_other_nuc",
    "2+6  HQ  gb_dirsub *",
    "2+8  HQ  gb_other_nuc",
    "2+10 HQ  gb_other_nuc",
    "2+6  HR  gb_gss",
    "2+8  HR  gb_other_nuc",
    "2+10 HR  gb_other_nuc",
    "2+6  HS  gb_est",
    "2+8  HS  gb_other_nuc",
    "2+10 HS  gb_other_nuc",
    "2+6  HT  ddbj_tpa_nuc # fallback to placate older clients",
    "2+6  HT  ddbj_tpa_con",
    "2+8  HT  ddbj_tpa_nuc",
    "2+10 HT  ddbj_tpa_nuc",
    "2+6  HU  ddbj_tpa_nuc # fallback to placate older clients",
    "2+6  HU  ddbj_tpa_chromosome",
    "2+8  HU  ddbj_tpa_nuc",
    "2+10 HU  ddbj_tpa_nuc",
    "2+6  HV  ddbj_patent",
    "2+8  HV  ddbj_other_nuc",
    "2+10 HV  ddbj_other_nuc",
    "2+6  HW  ddbj_patent",
    "2+8  HW  ddbj_other_nuc",
    "2+10 HW  ddbj_other_nuc",
    "2+6  HX  ddbj_est",
    "2+8  HX  ddbj_other_nuc",
    "2+10 HX  ddbj_other_nuc",
    "2+6  HY  ddbj_est",
    "2+8  HY  ddbj_other_nuc",
    "2+10 HY  ddbj_other_nuc",
    "2+6  HZ  ddbj_patent",
    "2+8  HZ  ddbj_other_nuc",
    "2+10 HZ  ddbj_other_nuc",
    "2+6  JA  embl_patent",
    "2+8  JA  embl_other_nuc",
    "2+10 JA  embl_other_nuc",
    "2+6  JB  embl_patent",
    "2+8  JB  embl_other_nuc",
    "2+10 JB  embl_other_nuc",
    "2+6  JC  embl_patent",
    "2+8  JC  embl_other_nuc",
    "2+10 JC  embl_other_nuc",
    "2+6  JD  embl_patent",
    "2+8  JD  embl_other_nuc",
    "2+10 JD  embl_other_nuc",
    "2+6  JE  embl_patent",
    "2+8  JE  embl_other_nuc",
    "2+10 JE  embl_other_nuc",
    "2+6  JF  gb_dirsub",
    "2+8  JF  gb_other_nuc",
    "2+10 JF  gb_other_nuc",
    "2+6  JG  gb_est",
    "2+8  JG  gb_other_nuc",
    "2+10 JG  gb_other_nuc",
    "2+6  JH  gb_con",
    "2+8  JH  gb_other_nuc",
    "2+10 JH  gb_other_nuc",
    "2+6  JI  gb_tsa_nuc",
    "2+8  JI  gb_other_nuc",
    "2+10 JI  gb_other_nuc",
    "2+6  JJ  gb_gss",
    "2+8  JJ  gb_other_nuc",
    "2+10 JJ  gb_other_nuc",
    "2+6  JK  gb_est",
    "2+8  JK  gb_other_nuc",
    "2+10 JK  gb_other_nuc",
    "2+6  JL  gb_tsa_nuc",
    "2+8  JL  gb_other_nuc",
    "2+10 JL  gb_other_nuc",
    "2+6  JM  gb_gss",
    "2+8  JM  gb_other_nuc",
    "2+10 JM  gb_other_nuc",
    "2+6  JN  gb_dirsub *",
    "2+8  JN  gb_other_nuc",
    "2+10 JN  gb_other_nuc",
    "2+6  JO  gb_tsa_nuc",
    "2+8  JO  gb_other_nuc",
    "2+10 JO  gb_other_nuc",
    "2+6  JP  gb_tsa_nuc",
    "2+8  JP  gb_other_nuc",
    "2+10 JP  gb_other_nuc",
    "2+6  JQ  gb_dirsub",
    "2+8  JQ  gb_other_nuc",
    "2+10 JQ  gb_other_nuc",
    "2+6  JR  gb_tsa_nuc",
    "2+8  JR  gb_other_nuc",
    "2+10 JR  gb_other_nuc",
    "2+6  JS  gb_gss",
    "2+8  JS  gb_other_nuc",
    "2+10 JS  gb_other_nuc",
    "2+6  JT  gb_tsa_nuc",
    "2+8  JT  gb_other_nuc",
    "2+10 JT  gb_other_nuc",
    "2+6  JU  gb_tsa_nuc",
    "2+8  JU  gb_other_nuc",
    "2+10 JU  gb_other_nuc",
    "2+6  JV  gb_tsa_nuc",
    "2+8  JV  gb_other_nuc",
    "2+10 JV  gb_other_nuc",
    "2+6  JW  gb_tsa_nuc",
    "2+8  JW  gb_other_nuc",
    "2+10 JW  gb_other_nuc",
    "2+6  JX  gb_dirsub",
    "2+8  JX  gb_other_nuc",
    "2+10 JX  gb_other_nuc",
    "2+6  JY  gb_gss",
    "2+8  JY  gb_other_nuc",
    "2+10 JY  gb_other_nuc",
    "2+6  JZ  gb_est",
    "2+8  JZ  gb_other_nuc",
    "2+10 JZ  gb_other_nuc",
    "2+6  KA  gb_tsa_nuc",
    "2+8  KA  gb_other_nuc",
    "2+10 KA  gb_other_nuc",
    "2+6  KB  gb_con",
    "2+8  KB  gb_other_nuc",
    "2+10 KB  gb_other_nuc",
    "2+6  KC  gb_dirsub",
    "2+8  KC  gb_other_nuc",
    "2+10 KC  gb_other_nuc",
    "2+6  KD  gb_con",
    "2+8  KD  gb_other_nuc",
    "2+10 KD  gb_other_nuc",
    "2+6  KE  gb_con",
    "2+8  KE  gb_other_nuc",
    "2+10 KE  gb_other_nuc",
    "2+6  KF  gb_dirsub *",
    "2+8  KF  gb_other_nuc",
    "2+10 KF  gb_other_nuc",
    "2+6  KG  gb_gss",
    "2+8  KG  gb_other_nuc",
    "2+10 KG  gb_other_nuc",
    "2+6  KH  gb_patent",
    "2+8  KH  gb_other_nuc",
    "2+10 KH  gb_other_nuc",
    "2+6  KI  gb_con",
    "2+8  KI  gb_other_nuc",
    "2+10 KI  gb_other_nuc",
    "2+6  KJ  gb_dirsub *",
    "2+8  KJ  gb_other_nuc",
    "2+10 KJ  gb_other_nuc",
    "2+6  KK  gb_con",
    "2+8  KK  gb_other_nuc",
    "2+10 KK  gb_other_nuc",
    "2+6  KL  gb_con",
    "2+8  KL  gb_other_nuc",
    "2+10 KL  gb_other_nuc",
    "2+6  KM  gb_dirsub *",
    "2+8  KM  gb_other_nuc",
    "2+10 KM  gb_other_nuc",
    "2+6  KN  gb_con",
    "2+8  KN  gb_other_nuc",
    "2+10 KN  gb_other_nuc",
    "2+6  KO  gb_gss",
    "2+8  KO  gb_other_nuc",
    "2+10 KO  gb_other_nuc",
    "2+6  KP  gb_dirsub",
    "2+8  KP  gb_other_nuc",
    "2+10 KP  gb_other_nuc",
    "2+6  KQ  gb_con",
    "2+8  KQ  gb_other_nuc",
    "2+10 KQ  gb_other_nuc",
    "2+6  KR  gb_dirsub",
    "2+8  KR  gb_other_nuc",
    "2+10 KR  gb_other_nuc",
    "2+6  KS  gb_gss",
    "2+8  KS  gb_other_nuc",
    "2+10 KS  gb_other_nuc",
    "2+6  KT  gb_dirsub",
    "2+8  KT  gb_other_nuc",
    "2+10 KT  gb_other_nuc",
    "2+6  KU  gb_dirsub",
    "2+8  KU  gb_other_nuc",
    "2+10 KU  gb_other_nuc",
    "2+6  KV  gb_con",
    "2+8  KV  gb_other_nuc",
    "2+10 KV  gb_other_nuc",
    "2+6  KW  gb_other_nuc",
    "2+8  KW  gb_other_nuc",
    "2+10 KW  gb_other_nuc",
    "2+6  KX  gb_dirsub",
    "2+8  KX  gb_other_nuc",
    "2+10 KX  gb_other_nuc",
    "2+6  KY  gb_dirsub",
    "2+8  KY  gb_other_nuc",
    "2+10 KY  gb_other_nuc",
    "2+6  KZ  gb_con",
    "2+8  KZ  gb_other_nuc",
    "2+10 KZ  gb_other_nuc",
    "2+6  LA  ddbj_tsa_nuc",
    "2+8  LA  ddbj_other_nuc",
    "2+10 LA  ddbj_other_nuc",
    "2+6  LB  ddbj_gss",
    "2+8  LB  ddbj_other_nuc",
    "2+10 LB  ddbj_other_nuc",
    "2+6  LC  ddbj_dirsub",
    "2+8  LC  ddbj_other_nuc",
    "2+10 LC  ddbj_other_nuc",
    "2+6  LD  ddbj_con",
    "2+8  LD  ddbj_other_nuc",
    "2+10 LD  ddbj_other_nuc",
    "2+6  LE  ddbj_tsa_nuc",
    "2+8  LE  ddbj_other_nuc",
    "2+10 LE  ddbj_other_nuc",
    "2+6  LF  ddbj_patent",
    "2+8  LF  ddbj_other_nuc",
    "2+10 LF  ddbj_other_nuc",
    "2+6  LG  ddbj_patent",
    "2+8  LG  ddbj_other_nuc",
    "2+10 LG  ddbj_other_nuc",
    "2+6  LH  ddbj_tsa_nuc",
    "2+8  LH  ddbj_other_nuc",
    "2+10 LH  ddbj_other_nuc",
    "2+6  LI  ddbj_tsa_nuc",
    "2+8  LI  ddbj_other_nuc",
    "2+10 LI  ddbj_other_nuc",
    "2+6  LJ  ddbj_tsa_nuc",
    "2+8  LJ  ddbj_other_nuc",
    "2+10 LJ  ddbj_other_nuc",
    "2+6  LK  embl_dirsub *",
    "2+8  LK  embl_other_nuc",
    "2+10 LK  embl_other_nuc",
    "2+6  LL  embl_dirsub",
    "2+8  LL  embl_other_nuc",
    "2+10 LL  embl_other_nuc",
    "2+6  LM  embl_dirsub *",
    "2+8  LM  embl_other_nuc",
    "2+10 LM  embl_other_nuc",
    "2+6  LN  embl_dirsub *",
    "2+8  LN  embl_other_nuc",
    "2+10 LN  embl_other_nuc",
    "2+6  LO  embl_dirsub *",
    "2+8  LO  embl_other_nuc",
    "2+10 LO  embl_other_nuc",
    "2+6  LP  embl_patent",
    "2+8  LP  embl_other_nuc",
    "2+10 LP  embl_other_nuc",
    "2+6  LQ  embl_patent",
    "2+8  LQ  embl_other_nuc",
    "2+10 LQ  embl_other_nuc",
    "2+6  LR  embl_dirsub # embl_patent?",
    "2+8  LR  embl_other_nuc",
    "2+10 LR  embl_other_nuc",
    "2+6  LS  embl_dirsub # embl_patent?",
    "2+8  LS  embl_other_nuc",
    "2+10 LS  embl_other_nuc",
    "2+6  LT  embl_dirsub *",
    "2+8  LT  embl_other_nuc",
    "2+10 LT  embl_other_nuc",
    "2+6  LU  ddbj_est",
    "2+8  LU  ddbj_other_nuc",
    "2+10 LU  ddbj_other_nuc",
    "2+6  LV  ddbj_patent",
    "2+8  LV  ddbj_other_nuc",
    "2+10 LV  ddbj_other_nuc",
    "2+6  LW  ddbj_other_nuc",
    "2+8  LW  ddbj_other_nuc",
    "2+10 LW  ddbj_other_nuc",
    "2+6  LX  ddbj_patent",
    "2+8  LX  ddbj_other_nuc",
    "2+10 LX  ddbj_other_nuc",
    "2+6  LY  ddbj_patent",
    "2+8  LY  ddbj_other_nuc",
    "2+10 LY  ddbj_other_nuc",
    "2+6  LZ  ddbj_patent",
    "2+8  LZ  ddbj_other_nuc",
    "2+10 LZ  ddbj_other_nuc",
    "2+6  MA  ddbj_patent",
    "2+8  MA  ddbj_other_nuc",
    "2+10 MA  ddbj_other_nuc",
    "2+6  MB  ddbj_patent",
    "2+8  MB  ddbj_other_nuc",
    "2+10 MB  ddbj_other_nuc",
    "2+6  MC  ddbj_patent",
    "2+8  MC  ddbj_other_nuc",
    "2+10 MC  ddbj_other_nuc",
    "2+6  MD  ddbj_patent",
    "2+8  MD  ddbj_other_nuc",
    "2+10 MD  ddbj_other_nuc",
    "2+6  ME  ddbj_patent",
    "2+8  ME  ddbj_other_nuc",
    "2+10 ME  ddbj_other_nuc",
    "2+6  MF  gb_dirsub",
    "2+8  MF  gb_other_nuc",
    "2+10 MF  gb_other_nuc",
    "2+6  MG  gb_dirsub",
    "2+8  MG  gb_other_nuc",
    "2+10 MG  gb_other_nuc",
    "2+6  MH  gb_dirsub",
    "2+8  MH  gb_other_nuc",
    "2+10 MH  gb_other_nuc",
    "2+6  MI  gb_patent",
    "2+8  MI  gb_other_nuc",
    "2+10 MI  gb_other_nuc",
    "2+6  MJ  gb_gss",
    "2+8  MJ  gb_other_nuc",
    "2+10 MJ  gb_other_nuc",
    "2+6  MK  gb_dirsub",
    "2+8  MK  gb_other_nuc",
    "2+10 MK  gb_other_nuc",
    "2+6  ML  gb_con",
    "2+8  ML  gb_other_nuc",
    "2+10 ML  gb_other_nuc",
    "2+6  MM  gb_patent",
    "2+8  MM  gb_other_nuc",
    "2+10 MM  gb_other_nuc",
    "2+6  MN  gb_dirsub",
    "2+8  MN  gb_other_nuc",
    "2+10 MN  gb_other_nuc",
    "2+6  MO  gb_patent",
    "2+8  MO  gb_other_nuc",
    "2+10 MO  gb_other_nuc",
    "2+6  MP  embl_patent",
    "2+8  MP  embl_other_nuc",
    "2+10 MP  embl_other_nuc",
    "2+6  MQ  embl_patent",
    "2+8  MQ  embl_other_nuc",
    "2+10 MQ  embl_other_nuc",
    "2+6  MR  embl_patent",
    "2+8  MR  embl_other_nuc",
    "2+10 MR  embl_other_nuc",
    "2+6  MS  embl_patent",
    "2+8  MS  embl_other_nuc",
    "2+10 MS  embl_other_nuc",
    "2+6  MT  gb_dirsub",
    "2+8  MT  gb_other_nuc",
    "2+10 MT  gb_other_nuc",
    "2+6  MU  gb_con",
    "2+8  MU  gb_other_nuc",
    "2+10 MU  gb_other_nuc",
    "2+6  MV  gb_patent",
    "2+8  MV  gb_other_nuc",
    "2+10 MV  gb_other_nuc",
    "2+6  M?  gb_other_nuc",
    "2+8  M?  gb_other_nuc",
    "2+10 M?  gb_other_nuc",
    "2+6  NC  unreserved_nuc # deliberately skipped",
    "2+8  NC  unreserved_nuc # deliberately skipped",
    "2+10 NC  unreserved_nuc # deliberately skipped",
    "2+6  NG  unreserved_nuc # deliberately skipped",
    "2+8  NG  unreserved_nuc # deliberately skipped",
    "2+10 NG  unreserved_nuc # deliberately skipped",
    "2+6  NM  unreserved_nuc # deliberately skipped",
    "2+8  NM  unreserved_nuc # deliberately skipped",
    "2+10 NM  unreserved_nuc # deliberately skipped",
    "2+6  NP  unreserved_nuc # deliberately skipped",
    "2+8  NP  unreserved_nuc # deliberately skipped",
    "2+10 NP  unreserved_nuc # deliberately skipped",
    "2+6  NR  unreserved_nuc # deliberately skipped",
    "2+8  NR  unreserved_nuc # deliberately skipped",
    "2+10 NR  unreserved_nuc # deliberately skipped",
    "2+6  NS  unreserved_nuc # deliberately skipped",
    "2+8  NS  unreserved_nuc # deliberately skipped",
    "2+10 NS  unreserved_nuc # deliberately skipped",
    "2+6  NT  unreserved_nuc # deliberately skipped",
    "2+8  NT  unreserved_nuc # deliberately skipped",
    "2+10 NT  unreserved_nuc # deliberately skipped",
    "2+6  NW  unreserved_nuc # deliberately skipped",
    "2+8  NW  unreserved_nuc # deliberately skipped",
    "2+10 NW  unreserved_nuc # deliberately skipped",
    "2+6  NZ  unreserved_nuc # deliberately skipped",
    "2+8  NZ  unreserved_nuc # deliberately skipped",
    "2+10 NZ  unreserved_nuc # deliberately skipped",
    "2+6  OA  embl_other_nuc",
    "2+8  OA  embl_other_nuc",
    "2+10 OA  embl_other_nuc",
    "2+6  OB  embl_other_nuc *",
    "2+8  OB  embl_other_nuc",
    "2+10 OB  embl_other_nuc",
    "2+6  OC  embl_other_nuc",
    "2+8  OC  embl_other_nuc",
    "2+10 OC  embl_other_nuc",
    "2+6  OD  embl_other_nuc",
    "2+8  OD  embl_other_nuc",
    "2+10 OD  embl_other_nuc",
    "2+6  OE  embl_other_nuc",
    "2+8  OE  embl_other_nuc",
    "2+10 OE  embl_other_nuc",
    "2+6  OF  ddbj_est",
    "2+8  OF  ddbj_other_nuc",
    "2+10 OF  ddbj_other_nuc",
    "2+6  OG  ddbj_est",
    "2+8  OG  ddbj_other_nuc",
    "2+10 OG  ddbj_other_nuc",
    "2+6  TI  unreserved_nuc # deliberately skipped",
    "2+8  TI  unreserved_nuc # deliberately skipped",
    "2+10 TI  unreserved_nuc # deliberately skipped",
    "2+6  WP  unreserved_nuc # deliberately skipped",
    "2+8  WP  unreserved_nuc # deliberately skipped",
    "2+10 WP  unreserved_nuc # deliberately skipped",
    "2+6  XM  unreserved_nuc # deliberately skipped",
    "2+8  XM  unreserved_nuc # deliberately skipped",
    "2+10 XM  unreserved_nuc # deliberately skipped",
    "2+6  XP  unreserved_nuc # deliberately skipped",
    "2+8  XP  unreserved_nuc # deliberately skipped",
    "2+10 XP  unreserved_nuc # deliberately skipped",
    "2+6  XR  unreserved_nuc # deliberately skipped",
    "2+8  XR  unreserved_nuc # deliberately skipped",
    "2+10 XR  unreserved_nuc # deliberately skipped",
    "2+6  YP  unreserved_nuc # deliberately skipped",
    "2+8  YP  unreserved_nuc # deliberately skipped",
    "2+10 YP  unreserved_nuc # deliberately skipped",
    "2+6  ZP  unreserved_nuc # deliberately skipped",
    "2+8  ZP  unreserved_nuc # deliberately skipped",
    "2+10 ZP  unreserved_nuc # deliberately skipped",
    "2+6  ??  unreserved_nuc",
    "2+8  ??  unreserved_nuc",
    "2+10 ??  unreserved_nuc",
    "",
    "# Specially handled type-general Dbtag names; commented out for now in",
    "# favor of a hard-coded list.  (Uncommenting them will override it.)",
    "",
    "#gnl  SRA         general_nuc",
    "#gnl  ti          general_nuc",
    "#gnl  TR_ASSM_CH  general_nuc",
    "#gnl  TRACE_ASSM  general_nuc",
    "#gnl  TRACE_CHGR  general_nuc",
    "",
    "# SPECIAL CASES",
    "# Mostly in the same order as baseline assignments, but embl_tpa_prot",
    "# specials are at the very end because there are so many of them.  To",
    "# keep to a rough limit of 100 lines per prefix, resort to *_other_nuc",
    "# for some heavily mixed ranges.",
    "",
    "# Some GenBank \"TPA\" 8-character protein accessions are really native.",
    "special  DAA00001           gb_prot",
    "special  DAA02110-DAA02116  gb_prot",
    "special  DAA34794-DAA34795  gb_prot",
    "",
    "# Nominally ddbj_est.",
    "special  C21595-C21827  ddbj_dirsub",
    "special  C22715-C22762  ddbj_dirsub",
    "special  C22783-C22911  ddbj_dirsub",
    "special  C24689-C24767  ddbj_dirsub",
    "special  C75685-C75936  ddbj_dirsub",
    "special  C95573-C95642  ddbj_dirsub",
    "special  C99933-C99976  ddbj_dirsub",
    "",
    "# Nominally ddbj_dirsub.  Split out EST ranges, and give the benefit",
    "# of the doubt to sequences that look like ddbj_con, ddbj_genome,",
    "# ddbj_mrna, or ddbj_other_nuc.",
    "special  D00922         ddbj_est",
    "special  D11487-D12469  ddbj_est",
    "special  D15075-D17289  ddbj_other_nuc # 62 EST ranges",
    "special  D17812-D21053  ddbj_est",
    "special  D21355-D26768  ddbj_other_nuc # 118 EST ranges",
    "special  D26771-D28109  ddbj_est",
    "special  D28170-D28183  ddbj_est",
    "special  D28185-D28196  ddbj_est",
    "special  D28198         ddbj_est",
    "special  D28200         ddbj_est",
    "special  D28203         ddbj_est",
    "special  D28205-D28206  ddbj_est",
    "special  D28208-D28215  ddbj_est",
    "special  D28217-D28224  ddbj_est",
    "special  D28227         ddbj_est",
    "special  D28229         ddbj_est",
    "special  D28232         ddbj_est",
    "special  D28234         ddbj_est",
    "special  D28281-D28288  ddbj_est",
    "special  D28290-D28310  ddbj_est",
    "special  D28312-D28318  ddbj_est",
    "special  D28320-D28326  ddbj_est",
    "special  D28603-D28744  ddbj_est",
    "special  D29018-D29624  ddbj_est",
    "special  D29993-D30029  ddbj_est",
    "special  D30816-D31599  ddbj_est",
    "special  D32304-D32958  ddbj_est",
    "special  D32960-D33769  ddbj_est",
    "special  D33771-D34214  ddbj_est",
    "special  D34216-D34410  ddbj_est",
    "special  D34412-D34589  ddbj_est",
    "special  D34640-D35674  ddbj_est",
    "special  D35676-D36684  ddbj_est",
    "special  D36686-D42011  ddbj_other_nuc # 101 EST ranges",
    "special  D42187-D43617  ddbj_est",
    "special  D44612-D49352  ddbj_other_nuc # 70 EST ranges",
    "special  D50936-D60141  ddbj_other_nuc # 1208 EST ranges",
    "special  D60143-D61376  ddbj_est",
    "special  D61420-D61685  ddbj_est",
    "special  D61708-D62388  ddbj_est",
    "special  D62390-D63133  ddbj_est",
    "special  D63171-D63317  ddbj_est",
    "special  D63319-D63324  ddbj_est",
    "special  D63330         ddbj_est",
    "special  D63746-D63758  ddbj_est",
    "special  D64179-D65034  ddbj_est",
    "special  D65036-D65241  ddbj_est",
    "special  D65243-D65978  ddbj_est",
    "special  D65980-D66873  ddbj_est",
    "special  D67099-D68048  ddbj_est",
    "special  D68050-D68323  ddbj_est",
    "special  D68325-D68600  ddbj_est",
    "special  D68602-D69603  ddbj_est",
    "special  D69605-D70813  ddbj_est",
    "special  D70900-D76413  ddbj_other_nuc # 45 EST ranges",
    "special  D76447-D77996  ddbj_est",
    "special  D78209-D89649  ddbj_other_nuc # 91 EST ranges",
    "",
    "special  F38006         embl_dirsub # Nominally embl_est.",
    "",
    "# Nominally gsdb_dirsub.  Split out EST, GSS, and STS ranges, and",
    "# give the benefit of the doubt to sequences that look like gb_cdna,",
    "# gb_con, gb_genome, gsdb_dirsub, or gb_other_nuc.",
    "special  L00738-L00844  gb_sts",
    "special  L00846-L00850  gb_sts",
    "special  L00852-L00891  gb_sts",
    "special  L00893-L00916  gb_sts",
    "special  L00994-L01014  gb_sts",
    "special  L01996-L02021  gb_sts",
    "special  L02080-L02091  gb_sts",
    "special  L04198-L04215  gb_sts",
    "special  L07331-L07332  gb_sts",
    "special  L07863         gb_sts",
    "special  L08881-L15794  gb_other_nuc # 6 EST ranges and 23 STS ranges",
    "special  L17188-L17290  gb_sts",
    "special  L18193-L18255  gb_sts",
    "special  L18857-L18858  gb_est",
    "special  L19032-L19041  gb_est",
    "special  L19143-L19155  gb_est",
    "special  L19160         gb_est",
    "special  L19202-L19214  gb_est",
    "special  L20451-L20461  gb_est",
    "special  L23479-L23493  gb_sts",
    "special  L23992         gb_sts",
    "special  L23997         gb_sts",
    "special  L24693         gb_sts",
    "special  L24826         gb_sts",
    "special  L25137         gb_sts",
    "special  L25173-L25249  gb_est",
    "special  L25344-L25345  gb_est",
    "special  L25347         gb_est",
    "special  L25417-L25420  gb_est",
    "special  L25449-L25525  gb_est",
    "special  L25888         gb_sts",
    "special  L26606-L26848  gb_est",
    "special  L27444         gb_est",
    "special  L28178-L28418  gb_sts",
    "special  L28420-L28422  gb_sts",
    "special  L30148         gb_est",
    "special  L31430-L31437  gb_sts",
    "special  L31440-L31489  gb_sts",
    "special  L31968-L32015  gb_est",
    "special  L32028-L32065  gb_est",
    "special  L33494-L33675  gb_est",
    "special  L34798-L34802  gb_sts",
    "special  L34957-L35007  gb_est",
    "special  L35580-L35581  gb_sts",
    "special  L35773-L35843  gb_est",
    "special  L36534         gb_sts",
    "special  L37208-L37288  gb_sts",
    "special  L37453-L37515  gb_est",
    "special  L37607-L37659  gb_est",
    "special  L37974-L38013  gb_est",
    "special  L38026-L38243  gb_est",
    "special  L38525-L38543  gb_est",
    "special  L38741         gb_est",
    "special  L38750-L38760  gb_est",
    "special  L38763         gb_est",
    "special  L38774         gb_est",
    "special  L38787         gb_est",
    "special  L39872-L39873  gb_sts",
    "special  L40034         gb_sts",
    "special  L40040-L40041  gb_sts",
    "special  L40351-L40352  gb_sts",
    "special  L40420-L40424  gb_est",
    "special  L41967         gb_sts",
    "special  L43576-L43577  gb_est",
    "special  L43579-L43580  gb_est",
    "special  L44279-L44576  gb_est",
    "special  L46401-L46582  gb_est",
    "special  L46914-L47098  gb_est",
    "special  L47214-L47215  gb_sts",
    "special  L47542         gb_sts",
    "special  L47554-L47568  gb_sts",
    "special  L47842-L47965  gb_est",
    "special  L48016         gb_sts",
    "special  L48736-L48796  gb_gss",
    "special  L48818-L48873  gb_est",
    "special  L49057-L49120  gb_est",
    "special  L76101-L76131  gb_est",
    "special  L76151         gb_sts",
    "special  L77669-L77670  gb_sts",
    "special  L77674-L77683  gb_sts",
    "special  L77685-L77686  gb_sts",
    "special  L77689         gb_sts",
    "special  L77878-L77883  gb_sts",
    "special  L77993         gb_sts",
    "special  L81201-L81260  gb_est",
    "",
    "# Nominally gsdb_dirsub.  Split out EST and STS ranges, and give the",
    "# benefit of the doubt to sequences that look like gb_cdna, gb_con,",
    "# gb_genome, gsdb_dirsub, or gb_other_nuc.",
    "special  M23606-M23610  gb_sts",
    "special  M61953-M62300  gb_est",
    "special  M75734-M75848  gb_est",
    "special  M75850-M75852  gb_est",
    "special  M75854-M75855  gb_est",
    "special  M75857         gb_est",
    "special  M75859-M75863  gb_est",
    "special  M75868-M75869  gb_est",
    "special  M75872         gb_est",
    "special  M75874         gb_est",
    "special  M75876-M75881  gb_est",
    "special  M75885         gb_est",
    "special  M75890         gb_est",
    "special  M75892-M75902  gb_est",
    "special  M75904-M75905  gb_est",
    "special  M75912         gb_est",
    "special  M75915         gb_est",
    "special  M75917-M75943  gb_est",
    "special  M75945-M75946  gb_est",
    "special  M75951         gb_est",
    "special  M75955         gb_est",
    "special  M75964-M75965  gb_est",
    "special  M75988         gb_est",
    "special  M76111-M76122  gb_est",
    "special  M77851-M79278  gb_est",
    "special  M79465-M80184  gb_est",
    "special  M80369-M80376  gb_sts",
    "special  M83631-M83639  gb_sts",
    "special  M84924-M84934  gb_sts",
    "special  M84943         gb_sts",
    "special  M85308-M86179  gb_est",
    "special  M88774-M89469  gb_est",
    "special  M91216-M91222  gb_est",
    "special  M91387-M91403  gb_est",
    "special  M91480-M91511  gb_est",
    "special  M92283-M92284  gb_est",
    "special  M92935         gb_est",
    "special  M94585-M94622  gb_sts",
    "special  M94635-M94643  gb_sts",
    "special  M94655-M94662  gb_sts",
    "special  M95212-M95280  gb_sts",
    "special  M95301-M95323  gb_sts",
    "special  M96605-M96621  gb_est",
    "special  M98979-M98996  gb_sts",
    "",
    "# Early N accessions were assigned haphazardly, and sometimes ambiguously.",
    "# (These are all secondary accessions nowadays, though.)  \"*\" denotes what,",
    "# if anything, N????? (and usually also N?????.1) immediately resolves to.",
    "# Some unambiguous accessions don't resolve, and some ambiguous ones do.",
    "special  N00001  gb_embl        # (L29187+L00109+L00110 / AH005313.2) / X04516.1",
    "special  N00002  gb_embl_ddbj   # M31027.1 / X04469.1 = D00002",
    "special  N00003  gb_ddbj        # L29169.1 / D00003.1",
    "special  N00004  gb_ddbj        # *L29170.1 / D00004.1",
    "special  N00005  gb_embl_ddbj   # L29171.1 / V01385.1 / D00005.1",
    "special  N00006  gb_ddbj        # (M31028.1 / AH002572.2) / D00006.1",
    "special  N00007  gb_ddbj        # (M31029.1 / AH002572.2) / D00007.1",
    "special  N00008  gb_other_nuc   # *L29172.1",
    "special  N00009  gb_embl_ddbj   # M13655.1 / *X00532.1 / D00009.1 (= M13655.1)",
    "special  N00010  gb_embl_ddbj   # *L29174.1 / X04067.1 = D00010.1",
    "special  N00011  gb_embl        # *L29175.1 = V00749.1",
    "special  N00012  gb_embl_ddbj   # L29176.1 = V00751.1 / D00012.1",
    "special  N00013  gb_other_nuc   # L29177.1 / AH002712.2",
    "special  N00014  gb_ddbj        # (L29178.1 / AH005322.2) / D00014.1",
    "special  N00015  gb_ddbj        # (L29187.1 / AH005313.2) / D00015.1",
    "special  N00016  gb_ddbj        # (L29188.1 / AH005313.2) / D00016.1",
    "special  N00017  gb_ddbj        # *L29190.1 / (M14043 =) D00017.1",
    "special  N00018  gb_other_nuc   # *L29191.1 / AH002172.2; only unversioned",
    "special  N00019  gb_other_nuc   # *L29197.1",
    "special  N00020  gb_embl_ddbj   # (L29198.1 / AH002320.2) / X03632.1 = D00020.1",
    "special  N00021  gb_ddbj        # (L29199.1 / AH002320.2) / D00021.1",
    "special  N00022  gb_embl_ddbj   # L29390.1 / V01168.1 / D00022.1",
    "special  N00023  gb_ddbj        # (L29391.1 / AH000963.2) / D00023.1",
    "special  N00024  gb_ddbj        # *L29392.1 / (M13071.1 =) D00024.1",
    "special  N00025  gb_embl_ddbj   # L29393.1 / X00626.1 / D00025.1",
    "special  N00026  gb_ddbj        # L29394.1 (= *X00442.1) / D00026.1",
    "special  N00027  gb_other_nuc   # *L29395.1",
    "special  N00028  ddbj_other_nuc # D00028.1",
    "special  N00029  gb_ddbj        # *L29397.1 / D00029.1",
    "special  N00030  gb_ddbj        # M10126.1 / D00030.1",
    "special  N00031  gb_ddbj        # (*L29400.1 / AH002739.2) / D00031.1; unvers.",
    "special  N00032  gb_ddbj        # (L?????.1 / AH??????.2) / D00032.1",
    "special  N00033  gb_ddbj        # (L29401.1 / AH002776.2) / D00033.1",
    "special  N00034  gb_ddbj        # (L29424.1 / AH001823.2) / D00034.1",
    "special  N00035  ddbj_other_nuc # D00035.1",
    "special  N00036  gb_ddbj        # M31030.1 / D00036.1",
    "special  N00037  ddbj_other_nuc # D00037.1",
    "special  N00038  gb_ddbj        # M31031.1 / D00038.1",
    "special  N00039  gb_ddbj        # *L29427.1 / D00039.1",
    "special  N00040  gb_ddbj        # L29428.1 / D00040.1",
    "special  N00041  gb_other_nuc   # L29429.1 / *M13756.1 (= D00041)",
    "special  N00042  gb_ddbj        # (L29430.1 / AH002209.2) / (M13752 =) D00042.1",
    "special  N00043  gb_ddbj        # (L29431.1 / AH005585.2) / (M13753 =) D00043.1",
    "special  N00044  gb_ddbj        # L29432.1 / D00044.1",
    "special  N00045  gb_other_nuc   # (*L29433.1/AH002727.2); once also DDBJ?",
    "special  N00046  gb_other_nuc   # *L29434.1",
    "special  N00047  gb_ddbj        # (*L29435.1 / AH002481.2) / D00047.1",
    "special  N00048  gb_other_nuc   # *L29436.1",
    "special  N00049  gb_ddbj        # M31032.1 / D00049.1",
    "special  N00050  gb_ddbj        # (L29399.1 / AH002739.2) / D00050.1",
    "special  N00051  gb_ddbj        # (L?????.1 / AH??????.2) / D00051.1",
    "special  N00052  gb_other_nuc   # L29472.1 / *M14909.1 (= D00052.1)",
    "special  N00053  ddbj_other_nuc # D00053.1",
    "special  N00054  gb_other_nuc   # M31033.1",
    "special  N00055  gb_ddbj        # (L?????.1 / AH??????.2) / D00055.1",
    "special  N00056  gb_ddbj        # L39908.1 / D00056.1",
    "special  N00057  gb_embl        # M31034.1 / X05532.1",
    "special  N00058  gb_embl_ddbj   # M31035.1 (= X05163.1) / (X05537.1 =) D00058.1",
    "special  N00059  gb_ddbj        # M22232.1 / (X05538.1 =) D00059.1",
    "special  N00060  embl_other_nuc # X05541.1 (= D00060.1)",
    "special  N00061  ddbj_other_nuc # (X05531.1 =) D00061.1",
    "special  N00062  ddbj_other_nuc # (X05530.1 =) D00062.1",
    "special  N00063  ddbj_other_nuc # (X05529.1 =) D00063.1",
    "special  N00064  embl_other_nuc # X05528.1 (= D00064.1 = D10030.1)",
    "special  N00065  ddbj_other_nuc # (X05527.1 =) D00065.1 = D10031.1",
    "special  N00066  ddbj_other_nuc # D00066.1",
    "special  N00067  ddbj_other_nuc # (M20207.1 =) D00067.1",
    "special  N00068  ddbj_other_nuc # D00068.1",
    "special  N00069  ddbj_other_nuc # D00069.1",
    "special  N00070  embl_ddbj      # X04036.1 = D00070.1",
    "special  N00078  ddbj_other_nuc # D00078.1",
    "special  N00079  ddbj_other_nuc # D00079.1",
    "special  N00083  ddbj_other_nuc # D00083.1",
    "special  N00088  ddbj_other_nuc # (M16550.1 =) D00088.1 = D10032.1",
    "special  N00090  ddbj_other_nuc # (X05597.1 =) D00090.1",
    "special  N00091  ddbj_other_nuc # (M15807.1 =) D00091.1",
    "special  N00092  ddbj_other_nuc # D00092.1",
    "special  N00093  ddbj_other_nuc # (M34437.1 = X04797.1 =) D00093.1",
    "special  N00094  ddbj_other_nuc # (X05040.1 =) D00094.1",
    "special  N18624  gb_other_nuc   # *L29496.1 / M23263.1",
    "special  N20001-N97317  gb_est",
    "special  N97318-N97531  gb_gss",
    "special  N97532-N99999  gb_est",
    "",
    "# Nominally gb_est.",
    "special  T02634-T02808  gb_gss",
    "special  T09496-T09993  gb_gss",
    "",
    "# Nominally gb_dirsub.",
    "special  U01537-U01551  gb_est",
    "special  U01921         gb_est",
    "special  U13686         gb_est",
    "special  U14111-U14114  gb_est",
    "special  U14171         gb_est",
    "special  U15041-U15047  gb_est",
    "special  U15988         gb_est",
    "special  U17154         gb_est",
    "special  U17513-U17564  gb_est",
    "special  U17582-U17584  gb_est",
    "special  U17905-U17909  gb_est",
    "special  U17976-U17977  gb_est",
    "special  U17999-U18008  gb_est",
    "special  U18010-U18017  gb_est",
    "special  U19036         gb_est",
    "special  U19135-U19141  gb_est",
    "special  U19502-U19510  gb_gss",
    "special  U19512-U19515  gb_est",
    "special  U19678-U19693  gb_est",
    "special  U19732         gb_est",
    "special  U19772         gb_est",
    "special  U19823         gb_est",
    "special  U21073-U21081  gb_est",
    "special  U21083-U21085  gb_est",
    "special  U21457-U21470  gb_est",
    "special  U21493-U21545  gb_gss",
    "special  U23049-U26690  gb_other_nuc # 21 EST ranges and 1 GSS range",
    "special  U27989-U31698  gb_other_nuc # 18 EST ranges and 1 GSS range",
    "special  U33921         gb_est",
    "special  U34233-U34244  gb_est",
    "special  U34396-U34400  gb_est",
    "special  U35429         gb_est",
    "special  U36594-U36596  gb_est",
    "special  U37151-U37164  gb_est",
    "special  U37229         gb_est",
    "special  U37231-U37234  gb_est",
    "special  U37588         gb_gss",
    "special  U37913-U37935  gb_est",
    "special  U37937-U38174  gb_est",
    "special  U39396         gb_est",
    "special  U39407-U39408  gb_est",
    "special  U39588-U39607  gb_est",
    "special  U40055         gb_est",
    "special  U40140-U40143  gb_est",
    "special  U40153         gb_est",
    "special  U40589         gb_est",
    "special  U40629         gb_est",
    "special  U41133-U41161  gb_est",
    "special  U41297         gb_est",
    "special  U42490-U42491  gb_est",
    "special  U42570-U42579  gb_est",
    "special  U42751         gb_est",
    "special  U43146         gb_est",
    "special  U44093-U44102  gb_est",
    "special  U44135-U44377  gb_est",
    "special  U44981-U44990  gb_est",
    "special  U46160-U53560  gb_other_nuc # 30 EST ranges and 5 GSS ranges",
    "special  U54592-U54607  gb_est",
    "special  U54706-U54733  gb_est",
    "special  U54735-U54739  gb_est",
    "special  U54779         gb_est",
    "special  U55034         gb_est",
    "special  U55777         gb_est",
    "special  U55962-U55991  gb_est",
    "special  U56653-U56660  gb_est",
    "special  U57844         gb_est",
    "special  U58051-U58082  gb_est",
    "special  U58979         gb_est",
    "special  U59417         gb_est",
    "special  U59419         gb_est",
    "special  U59755-U59756  gb_est",
    "special  U60299-U60311  gb_est",
    "special  U60606-U60638  gb_gss",
    "special  U60799         gb_est",
    "special  U61299-U61300  gb_gss",
    "special  U61522-U61525  gb_gss",
    "special  U62909         gb_est",
    "special  U63519         gb_est",
    "special  U63522-U63528  gb_est",
    "special  U64597         gb_est",
    "special  U64679         gb_est",
    "special  U64965-U64966  gb_est",
    "special  U65082         gb_est",
    "special  U65383-U65389  gb_est",
    "special  U65438-U65439  gb_est",
    "special  U65740         gb_est",
    "special  U65903-U65905  gb_gss",
    "special  U65917         gb_est",
    "special  U66210-U66213  gb_gss",
    "special  U66215         gb_gss",
    "special  U66423         gb_est",
    "special  U66576-U66577  gb_est",
    "special  U66693-U66697  gb_est",
    "special  U66718         gb_est",
    "special  U67850-U70383  gb_other_nuc # 13 EST ranges and 5 GSS ranges",
    "special  U72041-U95639  gb_other_nuc # 103 EST ranges, 35 GSS ranges, and 1 STS range",
    "special  U97486         gb_gss",
    "special  U97488         gb_gss",
    "special  U97490         gb_gss",
    "special  U97493         gb_gss",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_con, embl_genome, or embl_other_nuc, but split",
    "# out EST ranges.",
    "special  X61801-X61899  embl_est",
    "special  X62402         embl_est",
    "special  X65268-X65275  embl_est",
    "special  X65374-X65393  embl_est",
    "special  X71637-X71641  embl_est",
    "special  X71643-X71652  embl_est",
    "special  X73542-X73548  embl_est",
    "special  X73704-X73804  embl_est",
    "special  X76318         embl_est",
    "special  X76487         embl_est",
    "special  X78018-X78028  embl_est",
    "special  X82204         embl_est",
    "special  X83032-X83034  embl_est",
    "special  X83304-X83366  embl_est",
    "special  X84313         embl_est",
    "special  X84711-X84721  embl_est",
    "special  X85546-X85725  embl_est",
    "special  X86144-X86146  embl_est",
    "special  X86218-X86220  embl_est",
    "special  X87300-X87305  embl_est",
    "special  X89987-X89996  embl_est",
    "special  X90532-X90545  embl_est",
    "special  X91308-X91335  embl_est",
    "special  X91672-X91734  embl_est",
    "special  X92440         embl_est",
    "special  X92790-X92803  embl_est",
    "special  X93012-X93014  embl_est",
    "special  X93079         embl_est",
    "special  X93227-X93300  embl_est",
    "special  X93413-X93460  embl_est",
    "special  X93811-X93867  embl_est",
    "special  X93915-X93919  embl_est",
    "special  X93988-X93989  embl_est",
    "special  X94486-X94532  embl_est",
    "special  X95581         embl_est",
    "special  X95686         embl_est",
    "special  X96619-X96625  embl_est",
    "special  X97503-X97519  embl_est",
    "special  X97896-X97897  embl_est",
    "special  X98134-X98140  embl_est",
    "special  X98198-X98204  embl_est",
    "special  X98425-X98428  embl_est",
    "special  X98548-X98554  embl_est",
    "special  X99272         embl_est",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome or embl_other_nuc, but split out EST",
    "# ranges.",
    "special  Y07823         embl_est",
    "special  Y08464-Y08483  embl_est",
    "special  Y08705-Y08714  embl_est",
    "special  Y09139         embl_est",
    "special  Y09316-Y09320  embl_est",
    "special  Y09359-Y09364  embl_est",
    "special  Y09375-Y09377  embl_est",
    "special  Y09459-Y09464  embl_est",
    "special  Y09519-Y09523  embl_est",
    "special  Y09543-Y09545  embl_est",
    "special  Y09726-Y09732  embl_est",
    "special  Y09875         embl_est",
    "special  Y09981-Y09986  embl_est",
    "special  Y10008-Y10010  embl_est",
    "special  Y10037-Y10042  embl_est",
    "special  Y10056-Y10060  embl_est",
    "special  Y10217-Y10220  embl_est",
    "special  Y10671-Y10672  embl_est",
    "special  Y11191         embl_est",
    "special  Y11308         embl_est",
    "special  Y11615         embl_est",
    "special  Y14396-Y14402  embl_est",
    "special  Y16130-Y16131  embl_est",
    "special  Y16971-Y16974  embl_est",
    "special  Y18366         embl_est",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome or embl_other_nuc, but split out EST",
    "# ranges.",
    "special  Z12653-Z23155  embl_other_nuc # 69 EST ranges",
    "special  Z24464-Z24546  embl_est",
    "special  Z24760-Z24766  embl_est",
    "special  Z24769-Z25279  embl_est",
    "special  Z25283-Z25392  embl_est",
    "special  Z25400-Z25417  embl_est",
    "special  Z25486-Z25508  embl_est",
    "special  Z25510-Z25518  embl_est",
    "special  Z25546-Z25586  embl_est",
    "special  Z25588-Z25733  embl_est",
    "special  Z25776-Z25794  embl_est",
    "special  Z25799-Z25801  embl_est",
    "special  Z25805-Z25808  embl_est",
    "special  Z25825-Z25826  embl_est",
    "special  Z25832-Z25850  embl_est",
    "special  Z25889-Z26039  embl_est",
    "special  Z26045-Z26132  embl_est",
    "special  Z26184-Z26235  embl_est",
    "special  Z26237-Z26238  embl_est",
    "special  Z26243-Z26244  embl_est",
    "special  Z26323-Z26330  embl_est",
    "special  Z26342-Z26480  embl_est",
    "special  Z26495-Z26517  embl_est",
    "special  Z26525-Z26579  embl_est",
    "special  Z26658-Z26752  embl_est",
    "special  Z26754-Z26764  embl_est",
    "special  Z26772-Z26823  embl_est",
    "special  Z26868-Z26874  embl_est",
    "special  Z26952-Z26966  embl_est",
    "special  Z26971-Z27066  embl_est",
    "special  Z27095-Z27104  embl_est",
    "special  Z27240         embl_est",
    "special  Z27249-Z27303  embl_est",
    "special  Z28355-Z38124  embl_other_nuc # 84 EST ranges",
    "special  Z38136-Z46221  embl_est",
    "special  Z46243-Z46248  embl_est",
    "special  Z46291-Z46298  embl_est",
    "special  Z46428-Z46430  embl_est",
    "special  Z46510-Z46520  embl_est",
    "special  Z46526-Z46594  embl_est",
    "special  Z46677-Z46718  embl_est",
    "special  Z46813-Z46822  embl_est",
    "special  Z46830-Z46832  embl_est",
    "special  Z46974-Z46980  embl_est",
    "special  Z47057-Z47065  embl_est",
    "special  Z47278-Z47348  embl_est",
    "special  Z47350-Z47351  embl_est",
    "special  Z47382-Z47408  embl_est",
    "special  Z47575-Z47720  embl_est",
    "special  Z47801-Z47802  embl_est",
    "special  Z47985         embl_est",
    "special  Z48368-Z48427  embl_est",
    "special  Z48445-Z48448  embl_est",
    "special  Z48453-Z48467  embl_est",
    "special  Z48545-Z48560  embl_est",
    "special  Z48608-Z48611  embl_est",
    "special  Z48637         embl_est",
    "special  Z49229-Z49232  embl_est",
    "special  Z49744-Z49745  embl_est",
    "special  Z54295-Z54305  embl_est",
    "special  Z54309-Z54311  embl_est",
    "special  Z69578-Z69584  embl_est",
    "special  Z69945-Z69972  embl_est",
    "special  Z69974-Z69975  embl_est",
    "special  Z69983-Z69984  embl_est",
    "special  Z71789-Z71924  embl_est",
    "special  Z72392-Z72421  embl_est",
    "special  Z74621-Z74661  embl_est",
    "special  Z78280-Z78408  embl_est",
    "special  Z81149-Z81290  embl_est",
    "special  Z82016-Z82017  embl_est",
    "special  Z82913-Z82935  embl_est",
    "special  Z83019-Z83066  embl_est",
    "special  Z83980-Z84196  embl_est",
    "special  Z92674-Z92705  embl_est",
    "special  Z93025-Z93038  embl_est",
    "special  Z93725-Z93763  embl_est",
    "special  Z94848-Z94863  embl_est",
    "special  Z97038-Z97047  embl_est",
    "special  Z97731-Z97830  embl_est",
    "special  Z97862-Z97872  embl_est",
    "special  Z98057-Z98138  embl_est",
    "special  Z98443-Z98527  embl_est",
    "special  Z98764-Z98819  embl_est",
    "special  Z98821-Z98845  embl_est",
    "special  Z99067-Z99089  embl_est",
    "special  Z99348-Z99435  embl_est",
    "",
    "# Nominally ddbj_dirsub.",
    "special  AB001540-AB128048  ddbj_other_nuc # 197 EST ranges",
    "special  AB158145           ddbj_est",
    "special  AB158279-AB158287  ddbj_est",
    "special  AB158432           ddbj_est",
    "special  AB159214-AB159217  ddbj_est",
    "special  AB159736-AB159739  ddbj_est",
    "special  AB163429           ddbj_est",
    "special  AB163431           ddbj_est",
    "special  AB166724           ddbj_est",
    "special  AB178168-AB308274  ddbj_other_nuc # 80 EST ranges",
    "special  AB327169           ddbj_est",
    "special  AB331173-AB331192  ddbj_est",
    "special  AB331734-AB331746  ddbj_est",
    "special  AB331927-AB331949  ddbj_est",
    "special  AB334239           ddbj_est",
    "special  AB353143           ddbj_est",
    "special  AB354879           ddbj_est",
    "special  AB361047-AB361052  ddbj_est",
    "special  AB361241-AB361244  ddbj_est",
    "special  AB361292-AB361358  ddbj_est",
    "special  AB364678-AB364679  ddbj_est",
    "special  AB371430-AB371572  ddbj_est",
    "special  AB372866-AB372875  ddbj_est",
    "special  AB373997-AB374042  ddbj_est",
    "special  AB374263-AB374265  ddbj_est",
    "special  AB375019-AB375060  ddbj_est",
    "special  AB433981           ddbj_est",
    "special  AB434937-AB434950  ddbj_est",
    "special  AB437321-AB437344  ddbj_est",
    "special  AB446243-AB446391  ddbj_est",
    "special  AB447894-AB447981  ddbj_est",
    "special  AB448953-AB449020  ddbj_est",
    "special  AB450689-AB450761  ddbj_est",
    "special  AB458260-AB458300  ddbj_est",
    "special  AB458688-AB458789  ddbj_est",
    "special  AB461364-AB461372  ddbj_est",
    "special  AB471888-AB471891  ddbj_est",
    "special  AB474609-AB474619  ddbj_est",
    "special  AB474621-AB474714  ddbj_est",
    "special  AB474716-AB474721  ddbj_est",
    "special  AB474726-AB474739  ddbj_est",
    "special  AB474741-AB474748  ddbj_est",
    "special  AB480784-AB480824  ddbj_est",
    "special  AB485714-AB485715  ddbj_est",
    "special  AB485764-AB485770  ddbj_est",
    "special  AB485960-AB485992  ddbj_est",
    "special  AB492065-AB492083  ddbj_est",
    "special  AB505865-AB505873  ddbj_est",
    "special  AB509259           ddbj_est",
    "special  AB516772-AB516956  ddbj_est",
    "special  AB517053-AB517143  ddbj_est",
    "special  AB517145           ddbj_est",
    "special  AB529438-AB529445  ddbj_est",
    "special  AB535102-AB535104  ddbj_est",
    "special  AB537328-AB537329  ddbj_est",
    "special  AB542429-AB542450  ddbj_est",
    "special  AB552736-AB552841  ddbj_est",
    "special  AB553313-AB553315  ddbj_est",
    "special  AB568279-AB568290  ddbj_est",
    "special  AB571597-AB571602  ddbj_est",
    "special  AB572918-AB572921  ddbj_est",
    "special  AB573693-AB573709  ddbj_est",
    "special  AB575970-AB575978  ddbj_est",
    "special  AB576812-AB576850  ddbj_est",
    "special  AB585974-AB585996  ddbj_est",
    "special  AB594978-AB595127  ddbj_est",
    "special  AB602400-AB602424  ddbj_est",
    "special  AB613266           ddbj_est",
    "special  AB617526           ddbj_est",
    "special  AB626803           ddbj_est",
    "special  AB640724           ddbj_est",
    "special  AB646299-AB646300  ddbj_est",
    "special  AB646321-AB646345  ddbj_est",
    "special  AB668572-AB668577  ddbj_est",
    "special  AB669437-AB669464  ddbj_est",
    "special  AB709967-AB710073  ddbj_est",
    "special  AB734662-AB734675  ddbj_est",
    "special  AB738045-AB738062  ddbj_est",
    "special  AB742236-AB742251  ddbj_est",
    "special  AB757677-AB757705  ddbj_est",
    "special  AB811436           ddbj_est",
    "special  AB823195-AB823214  ddbj_est",
    "special  AB827265-AB827267  ddbj_est",
    "special  AB862603-AB862877  ddbj_est",
    "special  AB863290-AB863461  ddbj_est",
    "special  AB899003-AB899014  ddbj_est",
    "special  AB922020-AB922116  ddbj_est",
    "",
    "# Nominally gb_dirsub.",
    "special  AF000235-AF373213  gb_other_nuc # 585 EST ranges and 303 GSS ranges",
    "special  AF384864-AF384865  gb_gss",
    "special  AF387113-AF387121  gb_gss",
    "special  AF390017           gb_est",
    "special  AF390858           gb_est",
    "special  AF391795           gb_est",
    "special  AF391801-AF391804  gb_est",
    "special  AF391806-AF391807  gb_est",
    "special  AF396672           gb_gss",
    "special  AF396868           gb_est",
    "special  AF397194           gb_gss",
    "special  AF400792-AF400848  gb_gss",
    "special  AF401241-AF401271  gb_gss",
    "special  AF405213-AF405230  gb_est",
    "special  AF408415-AF408416  gb_est",
    "special  AF411092-AF411099  gb_est",
    "special  AF416103-AF416138  gb_gss",
    "special  AF420231           gb_est",
    "special  AF425300           gb_est",
    "special  AF435833-AF435837  gb_gss",
    "special  AF436075           gb_est",
    "special  AF439734           gb_est",
    "special  AF439736           gb_est",
    "special  AF439961-AF439972  gb_est",
    "special  AF440734           gb_gss",
    "special  AF441178-AF441182  gb_est",
    "special  AF441184-AF441187  gb_est",
    "special  AF441725           gb_gss",
    "special  AF441760-AF441769  gb_gss",
    "special  AF447921           gb_gss",
    "special  AF448511-AF448512  gb_est",
    "special  AF449707-AF449712  gb_gss",
    "special  AF451165-AF451181  gb_est",
    "special  AF451183-AF451189  gb_est",
    "special  AF453446           gb_est",
    "special  AF454762           gb_est",
    "special  AF455790-AF455802  gb_gss",
    "special  AF456411           gb_est",
    "special  AF461771           gb_est",
    "special  AF465471-AF465474  gb_gss",
    "special  AF468668-AF468672  gb_est",
    "special  AF469688-AF469692  gb_est",
    "special  AF472511           gb_gss",
    "special  AF486818-AF486819  gb_est",
    "special  AF487314-AF487325  gb_est",
    "special  AF487327-AF487329  gb_est",
    "special  AF492012-AF492014  gb_gss",
    "special  AF492272           gb_gss",
    "special  AF492356           gb_est",
    "special  AF494494-AF494495  gb_gss",
    "special  AF503187-AF503189  gb_est",
    "special  AF503588           gb_est",
    "special  AF506703-AF506706  gb_est",
    "special  AF507053           gb_est",
    "special  AF507058           gb_est",
    "special  AF507060           gb_est",
    "special  AF509571           gb_gss",
    "special  AF510188-AF510190  gb_est",
    "special  AF515664-AF515665  gb_gss",
    "special  AF516758-AF516766  gb_est",
    "special  AF520437-AF520439  gb_est",
    "special  AF520964           gb_est",
    "special  AF521604           gb_gss",
    "special  AF521978-AF522027  gb_est",
    "special  AF524047-AF524260  gb_gss",
    "special  AF524262-AF524826  gb_gss",
    "special  AF525702           gb_est",
    "special  AF525774-AF525775  gb_gss",
    "special  AF527684-AF527733  gb_est",
    "special  AF529172           gb_gss",
    "special  AF533598-AF533600  gb_est",
    "special  AF534530-AF534533  gb_gss",
    "special  AF537199-AF537202  gb_gss",
    "special  AF538926-AF538927  gb_est",
    "special  AF542503           gb_gss",
    "",
    "special  AG266800-AG266855  ddbj_dirsub # Nominally ddbj_gss.",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome or embl_other_nuc, but split out EST and",
    "# GSS ranges.",
    "special  AJ003249-AJ013072  embl_other_nuc # 29 EST ranges",
    "special  AJ131530-AJ131531  embl_est",
    "special  AJ131534           embl_est",
    "special  AJ131640           embl_est",
    "special  AJ131743           embl_est",
    "special  AJ132447-AJ132453  embl_est",
    "special  AJ132743-AJ132744  embl_est",
    "special  AJ132746-AJ132747  embl_est",
    "special  AJ132768           embl_est",
    "special  AJ132770           embl_est",
    "special  AJ133279-AJ133310  embl_est",
    "special  AJ133423           embl_est",
    "special  AJ133627-AJ133630  embl_est",
    "special  AJ133823-AJ133832  embl_est",
    "special  AJ133887-AJ133891  embl_est",
    "special  AJ223808-AJ252067  embl_other_nuc # 37 EST ranges",
    "special  AJ269829-AJ320073  embl_other_nuc # 106 EST ranges",
    "special  AJ344568-AJ344620  embl_est",
    "special  AJ345961-AJ346853  embl_est",
    "special  AJ347704-AJ347708  embl_est",
    "special  AJ348845-AJ348907  embl_est",
    "special  AJ388667-AJ441054  embl_other_nuc # 46 EST ranges",
    "special  AJ441341-AJ456950  embl_est",
    "special  AJ457094-AJ457095  embl_est",
    "special  AJ457215-AJ457787  embl_est",
    "special  AJ457797-AJ457801  embl_est",
    "special  AJ457995-AJ458180  embl_est",
    "special  AJ459102-AJ459105  embl_est",
    "special  AJ460001-AJ486853  embl_est",
    "special  AJ487042-AJ519345  embl_other_nuc # 41 EST ranges",
    "special  AJ532915-AJ583526  embl_other_nuc # 46 EST ranges",
    "special  AJ601557-AJ646868  embl_other_nuc # 55 EST ranges",
    "special  AJ646897-AJ697608  embl_est",
    "special  AJ697763-AJ697764  embl_est",
    "special  AJ698954           embl_est",
    "special  AJ699509-AJ703791  embl_est",
    "special  AJ704820           embl_est",
    "special  AJ704866-AJ704927  embl_est",
    "special  AJ705105-AJ715323  embl_est",
    "special  AJ716425-AJ717291  embl_est",
    "special  AJ719195-AJ719266  embl_est",
    "special  AJ721139-AJ744704  embl_est",
    "special  AJ745200-AJ745660  embl_est",
    "special  AJ746228-AJ746232  embl_est",
    "special  AJ746346           embl_est",
    "special  AJ746581-AJ747913  embl_est",
    "special  AJ749659-AJ749668  embl_est",
    "special  AJ750001-AJ767053  embl_est",
    "special  AJ767069-AJ780913  embl_est",
    "special  AJ781008-AJ781024  embl_est",
    "special  AJ783757           embl_est",
    "special  AJ784436-AJ784774  embl_est",
    "special  AJ785005-AJ785280  embl_est",
    "special  AJ785296-AJ785566  embl_est",
    "special  AJ785755           embl_est",
    "special  AJ786842-AJ809161  embl_est",
    "special  AJ810177-AJ810178  embl_est",
    "special  AJ812737-AJ821279  embl_est",
    "special  AJ821281-AJ821793  embl_est",
    "special  AJ821924-AJ829440  embl_est",
    "special  AJ831476-AJ831483  embl_est",
    "special  AJ831580-AJ831586  embl_est",
    "special  AJ831846-AJ832104  embl_est",
    "special  AJ833020-AJ833569  embl_est",
    "special  AJ843898-AJ920257  embl_other_nuc # 63 EST ranges and 2 GSS ranges",
    "special  AJ920420-AJ936931  embl_est",
    "special  AJ937840-AJ937842  embl_est",
    "special  AJ937844-AJ937846  embl_est",
    "special  AJ937848-AJ937851  embl_est",
    "special  AJ937853-AJ937854  embl_est",
    "special  AJ937856           embl_est",
    "special  AJ938183-AJ964871  embl_est",
    "special  AJ966338           embl_est",
    "special  AJ966532-AJ966570  embl_est",
    "special  AJ967011-AJ967015  embl_est",
    "special  AJ968963-AJ968985  embl_est",
    "special  AJ970155-AJ970160  embl_est",
    "special  AJ972495-AJ972503  embl_est",
    "special  AJ973481-AJ973591  embl_est",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_con, embl_genome, or embl_other_nuc, but split",
    "# out EST and GSS ranges.",
    "special  AL022607-AL022715  embl_est",
    "special  AL022730-AL023086  embl_est",
    "special  AL023993-AL024449  embl_est",
    "special  AL024459-AL024460  embl_est",
    "special  AL033283-AL033374  embl_est",
    "special  AL034585-AL042364  embl_other_nuc # 182 EST ranges",
    "special  AL042366-AL043422  embl_est",
    "special  AL043424-AL049170  embl_other_nuc # 72 EST ranges",
    "special  AL079357-AL079851  embl_est",
    "special  AL079853-AL079877  embl_est",
    "special  AL079879-AL080030  embl_est",
    "special  AL080032-AL080055  embl_est",
    "special  AL110302-AL110468  embl_est",
    "special  AL117695-AL118492  embl_est",
    "special  AL118560-AL121566  embl_est",
    "special  AL132634           embl_est",
    "special  AL132645-AL132647  embl_est",
    "special  AL132695-AL132706  embl_est",
    "special  AL132781-AL132790  embl_est",
    "special  AL132802-AL132817  embl_est",
    "special  AL132829-AL132837  embl_est",
    "special  AL132910-AL132942  embl_est",
    "special  AL133667-AL135743  embl_est",
    "special  AL137939-AL138463  embl_est",
    "special  AL138519           embl_est",
    "special  AL157506-AL157686  embl_est",
    "special  AL160494-AL161251  embl_other_nuc # Fallback to placate older clients",
    "special  AL160494-AL161251  embl_gss",
    "special  AL162087-AL162101  embl_est",
    "special  AL163072-AL163135  embl_est",
    "special  AL163154           embl_est",
    "special  AL163196           embl_est",
    "special  AL163331-AL163480  embl_est",
    "special  AL163493-AL163504  embl_est",
    "special  AL163513-AL163522  embl_est",
    "special  AL163614-AL163635  embl_est",
    "special  AL163643           embl_est",
    "special  AL163692-AL163701  embl_est",
    "special  AL163712-AL163759  embl_est",
    "special  AL163761-AL163762  embl_est",
    "special  AL163773-AL163784  embl_est",
    "special  AL163892-AL163901  embl_est",
    "special  AL352973-AL352975  embl_est",
    "special  AL352994-AL353006  embl_est",
    "special  AL353958-AL353985  embl_est",
    "special  AL354617-AL354621  embl_est",
    "special  AL355193-AL355214  embl_est",
    "special  AL355755-AL355764  embl_est",
    "special  AL355890-AL355912  embl_est",
    "special  AL355914-AL355915  embl_est",
    "special  AL355917-AL355918  embl_est",
    "special  AL360374-AL365136  embl_est",
    "special  AL365523-AL389869  embl_est",
    "special  AL391923-AL391974  embl_est",
    "special  AL392063-AL392067  embl_est",
    "special  AL441606-AL441620  embl_est",
    "special  AL441622-AL441623  embl_est",
    "special  AL449467-AL449917  embl_est",
    "special  AL450491-AL450982  embl_est",
    "special  AL499630-AL500520  embl_est",
    "special  AL500542-AL512267  embl_est",
    "special  AL513551-AL540319  embl_other_nuc # 490 EST ranges",
    "special  AL540321-AL541353  embl_est",
    "special  AL541355-AL583950  embl_other_nuc # 393 EST ranges",
    "special  AL583964-AL589147  embl_est",
    "special  AL589204-AL589622  embl_est",
    "special  AL593862-AL596018  embl_other_nuc # 251 EST ranges",
    "special  AL596479-AL603622  embl_est",
    "special  AL627462-AL663681  embl_other_nuc # 3583 EST ranges",
    "special  AL663683-AL666314  embl_est",
    "special  AL666316-AL666416  embl_est",
    "special  AL666418-AL666705  embl_est",
    "special  AL666707-AL666821  embl_est",
    "special  AL666823-AL667261  embl_est",
    "special  AL667264-AL667371  embl_est",
    "special  AL667373-AL668474  embl_est",
    "special  AL668476-AL668875  embl_est",
    "special  AL668877-AL669016  embl_est",
    "special  AL669018-AL669138  embl_est",
    "special  AL669140-AL669810  embl_est",
    "special  AL669812           embl_est",
    "special  AL669890           embl_est",
    "special  AL669994-AL669997  embl_est",
    "special  AL671927-AL683797  embl_other_nuc # 1244 EST ranges",
    "special  AL691524-AL713628  embl_est",
    "special  AL713805-AL713837  embl_est",
    "special  AL714032-AL731499  embl_est",
    "special  AL731899-AL732289  embl_est",
    "special  AL732297-AL732307  embl_est",
    "special  AL749534-AL749539  embl_est",
    "special  AL749541-AL750301  embl_est",
    "special  AL750303-AL751363  embl_est",
    "special  AL773605-AL805894  embl_other_nuc # 3341 EST ranges",
    "special  AL808211-AL823461  embl_est",
    "special  AL824717-AL831324  embl_est",
    "special  AL834580-AL837504  embl_est",
    "special  AL837529-AL840622  embl_est",
    "special  AL840645-AL840932  embl_est",
    "special  AL841430-AL844138  embl_est",
    "special  AL844226-AL844479  embl_est",
    "special  AL845558-AL901606  embl_other_nuc # 5767 EST ranges",
    "special  AL901610-AL928536  embl_est",
    "special  AL929474-AL929490  embl_est",
    "special  AL929609-AL935024  embl_est",
    "special  AL935073-AL935113  embl_est",
    "special  AL954873-AL973407  embl_other_nuc # 638 EST ranges",
    "",
    "# Nominally embl_dirsub.",
    "special  AM003907-AM039430  embl_est",
    "special  AM041272-AM041897  embl_est",
    "special  AM041899-AM041928  embl_est",
    "special  AM042018-AM042538  embl_est",
    "special  AM042715-AM048613  embl_est",
    "special  AM049439-AM049915  embl_est",
    "special  AM051087-AM051089  embl_est",
    "special  AM051366-AM055585  embl_est",
    "special  AM056504-AM062638  embl_est",
    "special  AM062766-AM063038  embl_est",
    "special  AM063043-AM071350  embl_est",
    "special  AM071401-AM071405  embl_est",
    "special  AM071408           embl_est",
    "special  AM071410-AM071411  embl_est",
    "special  AM071520-AM072286  embl_est",
    "special  AM072430-AM072444  embl_est",
    "special  AM075249-AM075607  embl_est",
    "special  AM083343-AM083946  embl_est",
    "special  AM085154-AM085297  embl_est",
    "special  AM088777-AM109845  embl_est",
    "special  AM110258-AM110692  embl_est",
    "special  AM111128-AM111305  embl_est",
    "special  AM111350-AM111351  embl_est",
    "special  AM111376-AM113422  embl_est",
    "special  AM113870           embl_est",
    "special  AM115672-AM115694  embl_est",
    "special  AM117760-AM117779  embl_est",
    "special  AM137442-AM156757  embl_est",
    "special  AM157797-AM158083  embl_est",
    "special  AM159647-AM160600  embl_est",
    "special  AM161052-AM161090  embl_est",
    "special  AM161647-AM162203  embl_est",
    "special  AM165128-AM167516  embl_est",
    "special  AM168256-AM168269  embl_est",
    "special  AM168526-AM176418  embl_est",
    "special  AM177644-AM179408  embl_est",
    "special  AM180191-AM180250  embl_est",
    "special  AM184308-AM228715  embl_est",
    "special  AM229723-AM230448  embl_est",
    "special  AM231596-AM231607  embl_est",
    "special  AM231751-AM231752  embl_est",
    "special  AM232089-AM232226  embl_est",
    "special  AM233524           embl_est",
    "special  AM233688-AM233739  embl_est",
    "special  AM237575-AM237581  embl_est",
    "special  AM237631-AM237802  embl_est",
    "special  AM237808-AM237828  embl_est",
    "special  AM259062-AM259066  embl_est",
    "special  AM260753-AM260790  embl_est",
    "special  AM261635-AM261651  embl_est",
    "special  AM261893-AM261919  embl_est",
    "special  AM263561-AM265360  embl_est",
    "special  AM265378-AM265389  embl_est",
    "special  AM265633-AM265637  embl_est",
    "special  AM267321-AM267478  embl_est",
    "special  AM268883-AM268894  embl_est",
    "special  AM279675           embl_est",
    "special  AM283547-AM284142  embl_est",
    "special  AM285455-AM285649  embl_est",
    "special  AM286691           embl_est",
    "special  AM287291-AM291980  embl_est",
    "special  AM292305           embl_est",
    "special  AM292925-AM292926  embl_est",
    "special  AM293570-AM293588  embl_est",
    "special  AM293624           embl_est",
    "special  AM295342-AM295345  embl_est",
    "special  AM296550-AM384871  embl_est",
    "special  AM384993-AM422606  embl_other_nuc # 21 EST ranges",
    "special  AM493773-AM493867  embl_est",
    "special  AM495471-AM495722  embl_est",
    "special  AM496020-AM496068  embl_est",
    "special  AM496070-AM497466  embl_est",
    "special  AM498769-AM500636  embl_est",
    "special  AM500638           embl_est",
    "special  AM502267-AM502286  embl_est",
    "special  AM503942-AM503952  embl_est",
    "special  AM504150-AM600638  embl_est",
    "special  AM695771-AM696203  embl_est",
    "special  AM696311-AM696688  embl_est",
    "special  AM713476-AM743079  embl_est",
    "special  AM743198-AM748699  embl_other_nuc # 23 EST ranges",
    "special  AM750062-AM765799  embl_est",
    "special  AM766003-AM773228  embl_est",
    "special  AM774151           embl_est",
    "special  AM779939-AM849033  embl_est",
    "special  AM849823-AM850054  embl_est",
    "special  AM851127-AM882506  embl_est",
    "special  AM894321-AM950290  embl_other_nuc # 183 EST ranges",
    "special  AM950553-AM980446  embl_est",
    "special  AM981402-AM982512  embl_est",
    "special  AM982822-AM983454  embl_est",
    "special  AM983577-AM988621  embl_est",
    "special  AM991118-AM991127  embl_est",
    "special  AM992040-AM992047  embl_est",
    "special  AM992256-AM992457  embl_est",
    "",
    "# Nominally ddbj_est.",
    "special  AU024804-AU029241  ddbj_dirsub",
    "special  AU036596-AU036726  ddbj_gss",
    "special  AU046301-AU050022  ddbj_dirsub",
    "special  AU050808-AU050815  ddbj_dirsub",
    "special  AU062283-AU062350  ddbj_dirsub",
    "special  AU066497-AU066498  ddbj_dirsub",
    "special  AU066500           ddbj_dirsub",
    "special  AU066504           ddbj_dirsub",
    "special  AU066506           ddbj_dirsub",
    "special  AU066511-AU066512  ddbj_dirsub",
    "special  AU066514-AU066515  ddbj_dirsub",
    "special  AU066521-AU066524  ddbj_dirsub",
    "special  AU066527-AU066529  ddbj_dirsub",
    "special  AU066535           ddbj_dirsub",
    "special  AU066540-AU066542  ddbj_dirsub",
    "special  AU066544           ddbj_dirsub",
    "special  AU066546           ddbj_dirsub",
    "special  AU066548-AU066553  ddbj_dirsub",
    "special  AU066555           ddbj_dirsub",
    "special  AU066557-AU066558  ddbj_dirsub",
    "special  AU078429-AU078598  ddbj_dirsub",
    "special  AU090535           ddbj_dirsub",
    "special  AU279339           ddbj_dirsub",
    "special  AU279378           ddbj_dirsub",
    "",
    "special  AX114121           embl_dirsub # Nominally embl_patent.",
    "",
    "# Nominally gb_dirsub.",
    "special  AY007260           gb_est",
    "special  AY026952-AY027433  gb_gss",
    "special  AY030235-AY030236  gb_est",
    "special  AY032615-AY032616  gb_est",
    "special  AY032902           gb_est",
    "special  AY032979           gb_est",
    "special  AY033289           gb_est",
    "special  AY038985-AY038987  gb_gss",
    "special  AY039709-AY039712  gb_gss",
    "special  AY042532           gb_est",
    "special  AY048753           gb_est",
    "special  AY055854           gb_gss",
    "special  AY063513           gb_est",
    "special  AY079522-AY080585  gb_gss",
    "special  AY093804-AY093817  gb_est",
    "special  AY096240           gb_est",
    "special  AY120880           gb_est",
    "special  AY123938           gb_gss",
    "special  AY125856-AY125890  gb_est",
    "special  AY127080-AY127557  gb_gss",
    "special  AY139011-AY139023  gb_est",
    "special  AY156078-AY156082  gb_gss",
    "special  AY160080-AY160082  gb_gss",
    "special  AY160682           gb_est",
    "special  AY166588           gb_est",
    "special  AY166650-AY166651  gb_gss",
    "special  AY168429-AY168439  gb_est",
    "special  AY174766-AY174778  gb_gss",
    "special  AY189691-AY189692  gb_est",
    "special  AY189695           gb_est",
    "special  AY196929-AY196933  gb_est",
    "special  AY198434-AY201593  gb_gss",
    "special  AY201595-AY201640  gb_gss",
    "special  AY201642-AY201691  gb_gss",
    "special  AY201693-AY203610  gb_gss",
    "special  AY243511           gb_est",
    "special  AY244458           gb_gss",
    "special  AY245441           gb_est",
    "special  AY265801-AY265804  gb_gss",
    "special  AY270178-AY270181  gb_gss",
    "special  AY282782-AY282785  gb_gss",
    "special  AY311391           gb_est",
    "special  AY321461-AY321462  gb_est",
    "special  AY325801-AY325802  gb_est",
    "special  AY326073           gb_est",
    "special  AY345126           gb_est",
    "special  AY347477           gb_est",
    "special  AY352272-AY352273  gb_gss",
    "special  AY356158-AY356311  gb_est",
    "special  AY357293-AY357295  gb_est",
    "special  AY366892-AY366899  gb_gss",
    "special  AY377860-AY377864  gb_est",
    "special  AY391730-AY391744  gb_gss",
    "special  AY395905           gb_est",
    "special  AY449735-AY449746  gb_est",
    "special  AY457064-AY457065  gb_est",
    "special  AY460108-AY460111  gb_est",
    "special  AY465830-AY465832  gb_est",
    "special  AY489065-AY489066  gb_gss",
    "special  AY491396-AY491398  gb_gss",
    "special  AY494600-AY494604  gb_est",
    "special  AY517518           gb_est",
    "special  AY518259-AY518264  gb_est",
    "special  AY547439-AY547457  gb_est",
    "special  AY553914           gb_est",
    "special  AY560545-AY560546  gb_est",
    "special  AY560548-AY560550  gb_est",
    "special  AY577286-AY577287  gb_est",
    "special  AY580990-AY580994  gb_gss",
    "special  AY583837           gb_gss",
    "special  AY589693-AY589694  gb_est",
    "special  AY589700-AY589701  gb_est",
    "special  AY589704           gb_est",
    "special  AY589708-AY589710  gb_est",
    "special  AY648006-AY648007  gb_gss",
    "special  AY651316           gb_est",
    "special  AY665687           gb_gss",
    "special  AY678444-AY678449  gb_est",
    "special  AY679774-AY679778  gb_est",
    "special  AY685649-AY685661  gb_gss",
    "special  AY686735-AY686747  gb_est",
    "special  AY688838-AY688840  gb_est",
    "special  AY714068-AY714071  gb_est",
    "special  AY736327           gb_est",
    "special  AY740678           gb_est",
    "special  AY750901-AY750904  gb_est",
    "special  AY758600-AY760022  gb_gss",
    "special  AY760098-AY760631  gb_gss",
    "special  AY760640-AY761013  gb_gss",
    "special  AY788904           gb_est",
    "special  AY796341           gb_est",
    "special  AY803125-AY803165  gb_est",
    "special  AY822675-AY822677  gb_gss",
    "special  AY831429           gb_est",
    "special  AY831657-AY831667  gb_gss",
    "special  AY838273-AY838277  gb_gss",
    "special  AY857201           gb_gss",
    "special  AY866420-AY866424  gb_gss",
    "special  AY870328           gb_gss",
    "special  AY872191-AY872255  gb_gss",
    "special  AY872390-AY873704  gb_gss",
    "special  AY879586-AY879591  gb_est",
    "special  AY885220-AY885221  gb_est",
    "special  AY898612           gb_gss",
    "special  AY922984-AY922988  gb_est",
    "special  AY928802-AY928805  gb_est",
    "special  AY952968-AY952970  gb_est",
    "special  AY966462-AY966485  gb_est",
    "special  AY987852           gb_est",
    "special  AY993980-AY993984  gb_gss",
    "special  AY994354-AY994356  gb_est",
    "",
    "# Nominally embl_dirsub.",
    "special  BX000562-BX000687  embl_est",
    "special  BX000710-BX000759  embl_est",
    "special  BX000976-BX000979  embl_est",
    "special  BX072585-BX088684  embl_other_nuc # 403 EST ranges",
    "special  BX088730-BX119313  embl_est",
    "special  BX119401-BX119900  embl_est",
    "special  BX248593           embl_est",
    "special  BX248783-BX248982  embl_est",
    "special  BX248986-BX249708  embl_est",
    "special  BX249763-BX251408  embl_est",
    "special  BX251414-BX255275  embl_est",
    "special  BX255279-BX255804  embl_est",
    "special  BX255991-BX279521  embl_other_nuc # 815 EST ranges",
    "special  BX279530-BX283066  embl_est",
    "special  BX283068-BX284108  embl_est",
    "special  BX294120-BX294121  embl_est",
    "special  BX294198-BX294232  embl_est",
    "special  BX295243-BX295348  embl_est",
    "special  BX295350-BX295358  embl_est",
    "special  BX295360-BX295378  embl_est",
    "special  BX295380-BX295516  embl_est",
    "special  BX295518           embl_est",
    "special  BX296570-BX318042  embl_other_nuc # 309 EST ranges",
    "special  BX318044-BX318558  embl_est",
    "special  BX318560-BX321855  embl_other_nuc # 42 EST ranges",
    "special  BX323813-BX465182  embl_other_nuc # 5821 EST ranges",
    "special  BX466087-BX466922  embl_est",
    "special  BX467129-BX469883  embl_est",
    "special  BX470269-BX510298  embl_est",
    "special  BX511045-BX511047  embl_est",
    "special  BX511314-BX511323  embl_est",
    "special  BX511333-BX526833  embl_est",
    "special  BX526835-BX530014  embl_est",
    "special  BX540327-BX540980  embl_other_nuc # 79 EST ranges",
    "special  BX548257-BX569683  embl_est",
    "special  BX601649-BX629297  embl_est",
    "special  BX629361-BX640397  embl_est",
    "special  BX641173-BX647061  embl_est",
    "special  BX663509           embl_est",
    "special  BX664722-BX677662  embl_other_nuc # 573 EST ranges",
    "special  BX677677-BX678768  embl_est",
    "special  BX678777-BX679656  embl_est",
    "special  BX679676-BX681414  embl_est",
    "special  BX681419-BX682226  embl_est",
    "special  BX682240-BX682527  embl_est",
    "special  BX682559-BX682952  embl_est",
    "special  BX682956-BX769172  embl_est",
    "special  BX769177-BX784021  embl_est",
    "special  BX784033           embl_est",
    "special  BX784044-BX784278  embl_est",
    "special  BX784281-BX784385  embl_est",
    "special  BX834112-BX841509  embl_est",
    "special  BX842705-BX861002  embl_other_nuc # 596 EST ranges",
    "special  BX861004-BX861521  embl_est",
    "special  BX861523-BX861681  embl_est",
    "special  BX861683-BX862186  embl_est",
    "special  BX862188-BX867356  embl_other_nuc # 51 EST ranges",
    "special  BX867358-BX867914  embl_est",
    "special  BX867916-BX872506  embl_other_nuc # 66 EST ranges",
    "special  BX872508-BX873028  embl_est",
    "special  BX873030-BX879623  embl_other_nuc # 76 EST ranges",
    "special  BX879625-BX880165  embl_est",
    "special  BX880167-BX889492  embl_other_nuc # 119 EST ranges",
    "special  BX889494-BX890135  embl_est",
    "special  BX890137-BX890188  embl_est",
    "special  BX890190-BX890198  embl_est",
    "special  BX890200-BX890202  embl_est",
    "special  BX890204-BX890224  embl_est",
    "special  BX890226-BX890232  embl_est",
    "special  BX890234-BX890308  embl_est",
    "special  BX890310-BX890394  embl_est",
    "special  BX890396-BX890483  embl_est",
    "special  BX890485-BX890537  embl_est",
    "special  BX897754-BX899178  embl_est",
    "special  BX899182-BX901874  embl_est",
    "special  BX908815-BX927274  embl_other_nuc # 343 EST ranges",
    "special  BX927416-BX928738  embl_est",
    "special  BX928759-BX929267  embl_est",
    "special  BX950875-BX957214  embl_est",
    "special  BX957366-BX957367  embl_est",
    "",
    "# Nominally gb_genome.",
    "special  CP000925           gb_dirsub",
    "special  CP002027           gb_dirsub",
    "special  CP006698           gb_dirsub",
    "special  CP010455-CP010456  gb_dirsub",
    "special  CP013186           gb_dirsub",
    "special  CP014940           gb_dirsub",
    "special  CP014992           gb_dirsub",
    "special  CP016816           gb_dirsub",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome, but split out EST ranges.",
    "special  CR278161-CR293495  embl_est",
    "special  CR354614-CR394505  embl_other_nuc # 315 EST ranges",
    "special  CR407721-CR450243  embl_est",
    "special  CR450855-CR457481  embl_other_nuc # 307 EST ranges",
    "special  CR457485-CR477643  embl_est",
    "special  CR502047           embl_est",
    "special  CR513801-CR559927  embl_other_nuc # 134 EST ranges",
    "special  CR559947-CR589873  embl_est",
    "special  CR627501-CR628310  embl_est",
    "special  CR628421-CR631118  embl_est",
    "special  CR735161-CR749142  embl_est",
    "special  CR749881-CR751205  embl_est",
    "special  CR751241-CR751527  embl_est",
    "special  CR751621-CR752637  embl_est",
    "special  CR752662-CR752728  embl_est",
    "special  CR752730-CR752981  embl_est",
    "special  CR752983-CR753092  embl_est",
    "special  CR753094-CR753178  embl_est",
    "special  CR753180-CR753308  embl_est",
    "special  CR753310-CR753327  embl_est",
    "special  CR753329-CR753416  embl_est",
    "special  CR753418-CR753420  embl_est",
    "special  CR753422-CR753508  embl_est",
    "special  CR753510-CR753608  embl_est",
    "special  CR753610-CR753633  embl_est",
    "special  CR753635-CR753650  embl_est",
    "special  CR753652-CR753793  embl_est",
    "special  CR753795-CR753802  embl_est",
    "special  CR753804-CR753811  embl_est",
    "special  CR753907-CR759280  embl_est",
    "special  CR759282-CR759423  embl_est",
    "special  CR759425-CR759701  embl_est",
    "special  CR759703-CR759731  embl_est",
    "special  CR762499-CR764089  embl_est",
    "special  CR764098-CR767811  embl_est",
    "special  CR767822-CR769762  embl_est",
    "special  CR770518-CR774176  embl_est",
    "special  CR774201-CR775849  embl_est",
    "special  CR786583-CR788225  embl_est",
    "special  CR788341-CR790347  embl_est",
    "special  CR790390-CR792412  embl_est",
    "special  CR848861-CR857055  embl_other_nuc # 70 EST ranges",
    "special  CR926157           embl_est",
    "special  CR926498-CR926878  embl_est",
    "special  CR926880-CR926886  embl_est",
    "special  CR926888-CR926910  embl_est",
    "special  CR926912-CR927049  embl_est",
    "special  CR927051-CR927214  embl_est",
    "special  CR927216-CR927367  embl_est",
    "special  CR927369-CR927455  embl_est",
    "special  CR927457-CR927478  embl_est",
    "special  CR927480-CR927552  embl_est",
    "special  CR927554-CR931631  embl_est",
    "special  CR938765-CR940296  embl_est",
    "special  CR942245-CR942270  embl_est",
    "special  CR942275           embl_est",
    "special  CR942825-CR944659  embl_est",
    "special  CR974421           embl_est",
    "special  CR974599-CR999998  embl_est",
    "",
    "# Nominally embl_dirsub.",
    "special  CT000001-CT005229  embl_est",
    "special  CT009777-CT010161  embl_est",
    "special  CT010409-CT010425  embl_est",
    "special  CT025916-CT025917  embl_est",
    "special  CT485799-CT485989  embl_est",
    "special  CT563249-CT571240  embl_est",
    "special  CT571279-CT572707  embl_est",
    "special  CT574594-CT583622  embl_est",
    "special  CT583731-CT737118  embl_est",
    "special  CT737258           embl_est",
    "special  CT737431-CT762374  embl_other_nuc # 1381 EST ranges",
    "special  CT762376-CT762504  embl_est",
    "special  CT762507-CT766183  embl_other_nuc # 153 EST ranges",
    "special  CT766185-CT766353  embl_est",
    "special  CT766355-CT773818  embl_other_nuc # 322 EST ranges",
    "special  CT773820-CT773949  embl_est",
    "special  CT773951-CT774143  embl_est",
    "special  CT774146-CT774910  embl_other_nuc # 37 EST ranges",
    "special  CT774912-CT775059  embl_est",
    "special  CT775061-CT777270  embl_other_nuc # 84 EST ranges",
    "special  CT777272-CT777416  embl_est",
    "special  CT777418-CT780755  embl_other_nuc # 137 EST ranges",
    "special  CT780757-CT780877  embl_est",
    "special  CT780879-CT781911  embl_other_nuc # 39 EST ranges",
    "special  CT781913-CT782070  embl_est",
    "special  CT782072-CT782090  embl_est",
    "special  CT782092-CT782100  embl_est",
    "special  CT782102-CT782110  embl_est",
    "special  CT782112-CT782124  embl_est",
    "special  CT782126-CT782150  embl_est",
    "special  CT782152-CT782183  embl_est",
    "special  CT782185-CT782187  embl_est",
    "special  CT782189-CT782321  embl_est",
    "special  CT782323-CT786110  embl_other_nuc # 147 EST ranges",
    "special  CT786112-CT786237  embl_est",
    "special  CT786239-CT792224  embl_other_nuc # 219 EST ranges",
    "special  CT792226-CT792352  embl_est",
    "special  CT792354-CT793395  embl_other_nuc # 36 EST ranges",
    "special  CT793397-CT793519  embl_est",
    "special  CT793521-CT794722  embl_other_nuc # 48 EST ranges",
    "special  CT794724-CT794853  embl_est",
    "special  CT794855-CT823556  embl_other_nuc # 2036 EST ranges",
    "special  CT842009-CT842118  embl_est",
    "special  CT842120-CT842121  embl_est",
    "special  CT842123-CT842130  embl_est",
    "special  CT842132-CT842147  embl_est",
    "special  CT842149-CT842158  embl_est",
    "special  CT842160-CT842178  embl_est",
    "special  CT842180-CT842181  embl_est",
    "special  CT842183-CT842516  embl_est",
    "special  CT842518-CT842528  embl_est",
    "special  CT842530-CT842531  embl_est",
    "special  CT842533-CT842540  embl_est",
    "special  CT842542-CT863709  embl_est",
    "special  CT863715-CT863733  embl_est",
    "special  CT868744-CT928681  embl_est",
    "special  CT928683-CT938375  embl_est",
    "special  CT938377-CT940347  embl_other_nuc # 367 EST ranges",
    "special  CT943670-CT950687  embl_est",
    "special  CT962514-CT963069  embl_est",
    "special  CT963097-CT963104  embl_est",
    "special  CT971504-CT971571  embl_est",
    "special  CT978604           embl_est",
    "special  CT978606-CT978646  embl_est",
    "special  CT978648-CT978649  embl_est",
    "special  CT978651-CT978652  embl_est",
    "special  CT978654           embl_est",
    "special  CT978656-CT978677  embl_est",
    "special  CT978679           embl_est",
    "special  CT978681           embl_est",
    "special  CT978683           embl_est",
    "special  CT978685-CT978926  embl_est",
    "special  CT978928-CT978956  embl_est",
    "special  CT978958-CT989251  embl_est",
    "special  CT989258-CT990465  embl_est",
    "special  CT990474-CT990486  embl_est",
    "special  CT990490-CT990531  embl_est",
    "",
    "# Nominally embl_dirsub.",
    "special  CU062670-CU062842  embl_est",
    "special  CU062844-CU062846  embl_est",
    "special  CU062848-CU074269  embl_est",
    "special  CU074339-CU074382  embl_est",
    "special  CU074423-CU075311  embl_est",
    "special  CU075931-CU076039  embl_est",
    "special  CU234182-CU234194  embl_est",
    "special  CU302207           embl_est",
    "special  CU302209-CU302216  embl_est",
    "special  CU302324           embl_est",
    "special  CU306818-CU310069  embl_est",
    "special  CU310076-CU311182  embl_est",
    "special  CU367886-CU368379  embl_est",
    "special  CU368381-CU368441  embl_est",
    "special  CU368443-CU368521  embl_est",
    "special  CU368523-CU368526  embl_est",
    "special  CU368528-CU368600  embl_est",
    "special  CU368602-CU368745  embl_est",
    "special  CU368747-CU368750  embl_est",
    "special  CU368752-CU369046  embl_est",
    "special  CU369048-CU369187  embl_est",
    "special  CU369189-CU369553  embl_est",
    "special  CU369555-CU369565  embl_est",
    "special  CU369567-CU372896  embl_est",
    "special  CU372931-CU392058  embl_est",
    "special  CU394257-CU405559  embl_est",
    "special  CU415883-CU424422  embl_est",
    "special  CU424474           embl_est",
    "special  CU424496-CU442700  embl_est",
    "special  CU442764-CU457374  embl_est",
    "special  CU457503-CU487206  embl_other_nuc # 81 EST ranges and 1 GSS range",
    "special  CU487231-CU498825  embl_est",
    "special  CU498835-CU499386  embl_other_nuc # 43 EST ranges",
    "special  CU499388-CU524144  embl_est",
    "special  CU524146-CU524185  embl_est",
    "special  CU524187-CU524607  embl_est",
    "special  CU524609-CU524647  embl_est",
    "special  CU524649-CU525008  embl_est",
    "special  CU525010-CU525305  embl_est",
    "special  CU525307-CU525317  embl_est",
    "special  CU525319-CU525433  embl_est",
    "special  CU525435-CU525727  embl_est",
    "special  CU525729-CU525806  embl_est",
    "special  CU525808-CU525920  embl_est",
    "special  CU525922-CU530337  embl_est",
    "special  CU530421-CU538870  embl_est",
    "special  CU539140-CU550647  embl_est",
    "special  CU550735-CU565320  embl_est",
    "special  CU565322-CU596014  embl_other_nuc # 231 EST ranges",
    "special  CU596016-CU606845  embl_est",
    "special  CU607105-CU611033  embl_est",
    "special  CU611062-CU618304  embl_est",
    "special  CU618343-CU627974  embl_est",
    "special  CU628007-CU633156  embl_est",
    "special  CU637754-CU638663  embl_est",
    "special  CU639489-CU640365  embl_est",
    "special  CU640490-CU640880  embl_est",
    "special  CU651679-CU660012  embl_other_nuc # 41 EST ranges",
    "special  CU660014-CU672219  embl_est",
    "special  CU681473-CU681818  embl_est",
    "special  CU682012-CU682338  embl_est",
    "special  CU682367-CU682456  embl_est",
    "special  CU682458-CU682575  embl_est",
    "special  CU682577-CU682600  embl_est",
    "special  CU682602-CU682603  embl_est",
    "special  CU682605-CU682621  embl_est",
    "special  CU682623-CU682639  embl_est",
    "special  CU682641-CU682661  embl_est",
    "special  CU682663-CU682763  embl_est",
    "special  CU682765-CU682766  embl_est",
    "special  CU682768-CU682776  embl_est",
    "special  CU682778-CU682779  embl_est",
    "special  CU682781-CU682810  embl_est",
    "special  CU682812-CU683823  embl_est",
    "special  CU683828-CU683864  embl_est",
    "special  CU684056-CU686587  embl_est",
    "special  CU693503-CU694195  embl_est",
    "special  CU695349-CU740080  embl_est",
    "special  CU862081-CU896531  embl_est",
    "special  CU896700-CU905499  embl_est",
    "special  CU905513-CU914123  embl_est",
    "special  CU983906-CU984539  embl_est",
    "special  CU986307-CU993795  embl_est",
    "special  CU993823-CU999999  embl_est",
    "",
    "# Nominally ddbj_gss.",
    "special  DE990447-DE990894  ddbj_dirsub",
    "special  DE997363-DE998419  ddbj_dirsub",
    "",
    "# Nominally gb_dirsub.",
    "special  DQ000203-DQ000205  gb_est",
    "special  DQ003271-DQ003274  gb_est",
    "special  DQ005448-DQ005452  gb_est",
    "special  DQ006915-DQ006921  gb_est",
    "special  DQ008074-DQ008087  gb_est",
    "special  DQ009493           gb_est",
    "special  DQ010056           gb_est",
    "special  DQ023561-DQ023596  gb_est",
    "special  DQ054537           gb_est",
    "special  DQ056320-DQ056336  gb_est",
    "special  DQ062432           gb_est",
    "special  DQ068265-DQ068267  gb_est",
    "special  DQ071657-DQ071667  gb_est",
    "special  DQ072281-DQ072378  gb_gss",
    "special  DQ073526-DQ073530  gb_gss",
    "special  DQ079655-DQ079657  gb_est",
    "special  DQ082731           gb_est",
    "special  DQ090495-DQ090499  gb_est",
    "special  DQ092578-DQ092599  gb_gss",
    "special  DQ093275-DQ093284  gb_gss",
    "special  DQ103519-DQ103523  gb_gss",
    "special  DQ114785           gb_gss",
    "special  DQ115593-DQ115640  gb_gss",
    "special  DQ118389-DQ118393  gb_est",
    "special  DQ119294           gb_est",
    "special  DQ124861-DQ124867  gb_gss",
    "special  DQ131496           gb_gss",
    "special  DQ137423-DQ137425  gb_gss",
    "special  DQ138061-DQ138069  gb_est",
    "special  DQ156350-DQ156363  gb_gss",
    "special  DQ159946-DQ159947  gb_est",
    "special  DQ160233-DQ160240  gb_gss",
    "special  DQ172857-DQ172899  gb_est",
    "special  DQ176001-DQ176002  gb_gss",
    "special  DQ178992-DQ178994  gb_gss",
    "special  DQ190447-DQ190449  gb_est",
    "special  DQ205195-DQ205199  gb_est",
    "special  DQ207956           gb_est",
    "special  DQ211055-DQ211083  gb_est",
    "special  DQ211697           gb_est",
    "special  DQ217772           gb_est",
    "special  DQ219385-DQ219392  gb_gss",
    "special  DQ225105-DQ225107  gb_est",
    "special  DQ238007-DQ238010  gb_est",
    "special  DQ256365-DQ256368  gb_est",
    "special  DQ286755-DQ286759  gb_est",
    "special  DQ296475-DQ296480  gb_est",
    "special  DQ301872-DQ301876  gb_est",
    "special  DQ306698-DQ306705  gb_est",
    "special  DQ323032-DQ323035  gb_gss",
    "special  DQ329527-DQ329529  gb_gss",
    "special  DQ334866           gb_gss",
    "special  DQ341431-DQ341441  gb_est",
    "special  DQ349205-DQ349206  gb_est",
    "special  DQ351716-DQ351721  gb_gss",
    "special  DQ351838-DQ351840  gb_est",
    "special  DQ354361           gb_est",
    "special  DQ394888-DQ394890  gb_est",
    "special  DQ399337-DQ399338  gb_gss",
    "special  DQ530238           gb_gss",
    "special  DQ641039           gb_gss",
    "special  DQ672588           gb_est",
    "special  DQ821447-DQ821472  gb_est",
    "special  DQ822605-DQ822689  gb_est",
    "special  DQ858157-DQ858164  gb_est",
    "special  DQ866805           gb_gss",
    "special  DQ873299-DQ873317  gb_est",
    "special  DQ883824-DQ884159  gb_est",
    "special  DQ886384-DQ886389  gb_est",
    "special  DQ988883-DQ988928  gb_gss",
    "special  DQ999011-DQ999023  gb_est",
    "",
    "# Nominally gb_con.",
    "special  DS483562           gb_dirsub",
    "special  DS483659           gb_dirsub",
    "special  DS483744-DS484493  gb_other_nuc # 159 dirsub ranges",
    "special  DS484496-DS484515  gb_dirsub",
    "special  DS484518-DS484535  gb_dirsub",
    "special  DS484538-DS484550  gb_dirsub",
    "special  DS484552-DS484553  gb_dirsub",
    "special  DS484555-DS484574  gb_dirsub",
    "special  DS484576-DS484611  gb_dirsub",
    "special  DS484614-DS484623  gb_dirsub",
    "special  DS484625-DS484626  gb_dirsub",
    "special  DS484628-DS484633  gb_dirsub",
    "special  DS484635-DS484637  gb_dirsub",
    "special  DS484639           gb_dirsub",
    "special  DS484641-DS484654  gb_dirsub",
    "special  DS484656-DS484675  gb_dirsub",
    "special  DS484677-DS484686  gb_dirsub",
    "special  DS484688-DS484703  gb_dirsub",
    "special  DS484706-DS484707  gb_dirsub",
    "special  DS484709-DS484710  gb_dirsub",
    "special  DS484712-DS484716  gb_dirsub",
    "special  DS484718-DS484742  gb_dirsub",
    "special  DS484745-DS485146  gb_other_nuc # 80 dirsub ranges",
    "special  DS485148-DS485167  gb_dirsub",
    "special  DS485169           gb_dirsub",
    "special  DS485172-DS485174  gb_dirsub",
    "special  DS485176-DS485178  gb_dirsub",
    "special  DS485181-DS485182  gb_dirsub",
    "special  DS485184           gb_dirsub",
    "special  DS485186           gb_dirsub",
    "special  DS485189-DS485190  gb_dirsub",
    "special  DS485192           gb_dirsub",
    "special  DS485194-DS485195  gb_dirsub",
    "special  DS485198-DS485201  gb_dirsub",
    "special  DS485203-DS485205  gb_dirsub",
    "special  DS485208-DS485209  gb_dirsub",
    "special  DS485211           gb_dirsub",
    "special  DS485215-DS485216  gb_dirsub",
    "special  DS485218-DS485221  gb_dirsub",
    "special  DS485223-DS485230  gb_dirsub",
    "special  DS485233           gb_dirsub",
    "special  DS485235-DS485236  gb_dirsub",
    "special  DS485238-DS485240  gb_dirsub",
    "special  DS485242-DS485243  gb_dirsub",
    "special  DS485245-DS485247  gb_dirsub",
    "special  DS485249-DS485268  gb_dirsub",
    "special  DS485270-DS485271  gb_dirsub",
    "special  DS485273           gb_dirsub",
    "special  DS485275           gb_dirsub",
    "special  DS485277-DS485278  gb_dirsub",
    "special  DS485280-DS485281  gb_dirsub",
    "special  DS485283-DS485285  gb_dirsub",
    "special  DS485287-DS485288  gb_dirsub",
    "special  DS485290-DS485292  gb_dirsub",
    "special  DS485294           gb_dirsub",
    "special  DS485296-DS485306  gb_dirsub",
    "special  DS485309-DS485311  gb_dirsub",
    "special  DS485313-DS485316  gb_dirsub",
    "special  DS485318-DS485320  gb_dirsub",
    "special  DS485322-DS485326  gb_dirsub",
    "special  DS485328-DS485331  gb_dirsub",
    "special  DS485333-DS485343  gb_dirsub",
    "special  DS485345           gb_dirsub",
    "special  DS485349           gb_dirsub",
    "special  DS485351           gb_dirsub",
    "special  DS485353-DS485354  gb_dirsub",
    "special  DS485356-DS485365  gb_dirsub",
    "special  DS485368           gb_dirsub",
    "special  DS485370-DS485371  gb_dirsub",
    "special  DS485374-DS485376  gb_dirsub",
    "special  DS485378-DS485379  gb_dirsub",
    "special  DS485381-DS485390  gb_dirsub",
    "special  DS485392-DS485393  gb_dirsub",
    "special  DS485395           gb_dirsub",
    "special  DS485397-DS485401  gb_dirsub",
    "special  DS485403           gb_dirsub",
    "special  DS485407           gb_dirsub",
    "special  DS485409-DS485411  gb_dirsub",
    "special  DS485415-DS485416  gb_dirsub",
    "special  DS485418-DS485430  gb_dirsub",
    "special  DS485433-DS485434  gb_dirsub",
    "special  DS485436-DS485443  gb_dirsub",
    "special  DS485448           gb_dirsub",
    "special  DS485450-DS485454  gb_dirsub",
    "special  DS485456-DS485457  gb_dirsub",
    "special  DS485459-DS485462  gb_dirsub",
    "special  DS485464-DS485473  gb_dirsub",
    "special  DS485475-DS485478  gb_dirsub",
    "special  DS485481-DS485483  gb_dirsub",
    "special  DS485488           gb_dirsub",
    "special  DS485490-DS485492  gb_dirsub",
    "special  DS485494-DS485498  gb_dirsub",
    "special  DS485500-DS485501  gb_dirsub",
    "special  DS485503-DS485506  gb_dirsub",
    "special  DS485509           gb_dirsub",
    "special  DS485512           gb_dirsub",
    "special  DS485514-DS485515  gb_dirsub",
    "special  DS485517-DS485518  gb_dirsub",
    "special  DS485520-DS485523  gb_dirsub",
    "special  DS485525-DS485545  gb_dirsub",
    "special  DS485547-DS486008  gb_other_nuc # 95 dirsub ranges",
    "",
    "# Nominally gb_dirsub.",
    "special  EF053039-EF053049  gb_gss",
    "special  EF063001           gb_est",
    "special  EF095769           gb_gss",
    "special  EF165098           gb_gss",
    "special  EF182756-EF182758  gb_gss",
    "special  EF189906-EF189916  gb_est",
    "special  EF204530-EF204533  gb_gss",
    "special  EF208191           gb_gss",
    "special  EF210438-EF210453  gb_gss",
    "special  EF377525-EF377537  gb_est",
    "special  EF422869           gb_est",
    "special  EF473211-EF473215  gb_est",
    "special  EF494771-EF494773  gb_est",
    "special  EF552376           gb_est",
    "special  EF578434-EF578635  gb_gss",
    "special  EF592824-EF592944  gb_gss",
    "",
    "# Nominally gb_dirsub.",
    "special  EU152056-EU152079  gb_est",
    "special  EU239816           gb_est",
    "special  EU306364-EU306386  gb_gss",
    "special  EU364506-EU364507  gb_est",
    "special  EU368044           gb_est",
    "special  EU369669           gb_est",
    "special  EU420034           gb_est",
    "special  EU597223-EU597228  gb_est",
    "",
    "# Nominally gb_dirsub.",
    "special  FJ710154-FJ710155  gb_est",
    "special  FJ842632-FJ842642  gb_est",
    "",
    "# Nominally embl_dirsub.",
    "special  FM000001-FM160408  embl_est",
    "special  FM164769           embl_est",
    "special  FM164940           embl_est",
    "special  FM165392           embl_est",
    "special  FM165707-FM172746  embl_est",
    "special  FM178562-FM178778  embl_est",
    "special  FM180579-FM196445  embl_est",
    "special  FM205236-FM205493  embl_est",
    "special  FM205777-FM205831  embl_est",
    "special  FM207878-FM207900  embl_est",
    "special  FM208280-FM208711  embl_est",
    "special  FM208851           embl_est",
    "special  FM208900           embl_est",
    "special  FM212937           embl_est",
    "special  FM215048-FM242054  embl_est",
    "special  FM246886-FM251871  embl_est",
    "special  FM253361           embl_est",
    "special  FM253366-FM253368  embl_est",
    "special  FM253372           embl_est",
    "special  FM253378           embl_est",
    "special  FM864313-FM864344  embl_est",
    "special  FM864347-FM865295  embl_est",
    "special  FM868295-FM872275  embl_est",
    "special  FM879143-FM881767  embl_est",
    "special  FM882258-FM883162  embl_est",
    "special  FM885959-FM886821  embl_est",
    "special  FM887038-FM896881  embl_est",
    "special  FM897212-FM897213  embl_est",
    "special  FM897377-FM945301  embl_est",
    "special  FM945441-FM945999  embl_est",
    "special  FM946183-FM954971  embl_est",
    "special  FM957013-FM957079  embl_est",
    "special  FM958532-FM985957  embl_est",
    "special  FM992847-FM992850  embl_est",
    "special  FM999776-FM999787  embl_est",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome, but split out EST ranges.",
    "special  FN000001-FN177896  embl_est",
    "special  FN179489-FN182188  embl_est",
    "special  FN182288-FN185725  embl_est",
    "special  FN186135-FN190445  embl_est",
    "special  FN190447-FN252183  embl_est",
    "special  FN252460-FN252789  embl_est",
    "special  FN263376-FN292969  embl_est",
    "special  FN377870-FN386264  embl_est",
    "special  FN393571-FN393732  embl_est",
    "special  FN393830-FN393849  embl_est",
    "special  FN424437-FN428571  embl_est",
    "special  FN430839-FN431219  embl_est",
    "special  FN431234-FN431660  embl_est",
    "special  FN432032-FN432041  embl_est",
    "special  FN432154-FN432328  embl_est",
    "special  FN432729-FN432775  embl_est",
    "special  FN433834-FN433837  embl_est",
    "special  FN435336-FN435350  embl_est",
    "special  FN539079-FN543092  embl_est",
    "special  FN551261-FN551733  embl_est",
    "special  FN552552-FN552591  embl_est",
    "special  FN552699-FN552705  embl_est",
    "special  FN555710-FN555987  embl_est",
    "special  FN557216-FN557223  embl_est",
    "special  FN561898-FN561924  embl_est",
    "special  FN562175-FN562396  embl_est",
    "special  FN564151-FN564158  embl_est",
    "special  FN565576-FN566839  embl_est",
    "special  FN588437-FN594512  embl_est",
    "special  FN600697           embl_est",
    "special  FN601407-FN610843  embl_est",
    "special  FN611035-FN640462  embl_est",
    "special  FN640581-FN641653  embl_est",
    "special  FN641925-FN643079  embl_est",
    "special  FN646764-FN647626  embl_est",
    "special  FN651825-FN651826  embl_est",
    "special  FN652903-FN652904  embl_est",
    "special  FN661971-FN662351  embl_est",
    "special  FN664012-FN665290  embl_est",
    "special  FN669777-FN673545  embl_est",
    "special  FN679295-FN686775  embl_est",
    "special  FN691927           embl_est",
    "special  FN692044-FN706436  embl_est",
    "special  FN706565-FN773062  embl_est",
    "special  FN773104-FN773170  embl_est",
    "special  FN796618-FN796723  embl_est",
    "special  FN796987-FN806772  embl_est",
    "special  FN806826-FN806848  embl_est",
    "special  FN811794-FN811851  embl_est",
    "special  FN811944-FN812314  embl_est",
    "special  FN813225-FN813226  embl_est",
    "special  FN813467-FN813469  embl_est",
    "special  FN814310-FN820203  embl_est",
    "special  FN822244-FN822743  embl_est",
    "special  FN823242-FN823254  embl_est",
    "special  FN868597           embl_est",
    "special  FN868902-FN868929  embl_est",
    "special  FN869177-FN869376  embl_est",
    "special  FN870962-FN907899  embl_est",
    "special  FN908254-FN908302  embl_est",
    "special  FN985040           embl_est",
    "special  FN985644-FN993914  embl_est",
    "special  FN997680-FN998838  embl_est",
    "special  FN999023-FN999906  embl_est",
    "",
    "# Nominally embl_dirsub.",
    "special  FO000003-FO076577  embl_est",
    "special  FO082887-FO117570  embl_est",
    "special  FO117633-FO181358  embl_est",
    "special  FO181544-FO203352  embl_est",
    "special  FO203528-FO393391  embl_est",
    "special  FO680693-FO681285  embl_est",
    "special  FO704924-FO722023  embl_est",
    "special  FO981374-FO999999  embl_est",
    "",
    "# Nominally embl_dirsub.",
    "special  FP000001-FP003579  embl_est",
    "special  FP003602-FP009753  embl_est",
    "special  FP009755-FP009758  embl_est",
    "special  FP009760-FP009761  embl_est",
    "special  FP009763-FP009764  embl_est",
    "special  FP009766-FP012228  embl_est",
    "special  FP024615-FP057328  embl_est",
    "special  FP057330-FP057370  embl_est",
    "special  FP057373-FP057454  embl_other_nuc # 33 EST ranges",
    "special  FP057456-FP057462  embl_est",
    "special  FP057465-FP057560  embl_other_nuc # 43 EST ranges",
    "special  FP057562-FP057566  embl_est",
    "special  FP057568-FP057656  embl_other_nuc # 39 EST ranges",
    "special  FP057664-FP057702  embl_other_nuc # 16 EST ranges",
    "special  FP057704-FP057709  embl_est",
    "special  FP057711-FP058036  embl_other_nuc # 141 EST ranges",
    "special  FP058042-FP058155  embl_other_nuc # 45 EST ranges",
    "special  FP058162-FP058163  embl_est",
    "special  FP058165           embl_est",
    "special  FP058167           embl_est",
    "special  FP058169           embl_est",
    "special  FP058171-FP058172  embl_est",
    "special  FP058174           embl_est",
    "special  FP058176-FP058177  embl_est",
    "special  FP058180           embl_est",
    "special  FP058183-FP058190  embl_est",
    "special  FP058192-FP058271  embl_other_nuc # 33 EST ranges",
    "special  FP058282           embl_est",
    "special  FP058284           embl_est",
    "special  FP058286           embl_est",
    "special  FP058293-FP058514  embl_other_nuc # 95 EST ranges",
    "special  FP058526-FP058527  embl_est",
    "special  FP058529           embl_est",
    "special  FP058531-FP058532  embl_est",
    "special  FP058534           embl_est",
    "special  FP058537           embl_est",
    "special  FP058539           embl_est",
    "special  FP058542-FP058543  embl_est",
    "special  FP058545           embl_est",
    "special  FP058547-FP058553  embl_est",
    "special  FP058556-FP058658  embl_other_nuc # 44 EST ranges",
    "special  FP058673-FP058706  embl_other_nuc # 15 EST ranges",
    "special  FP058708-FP058713  embl_est",
    "special  FP058715-FP059322  embl_other_nuc # 248 EST ranges",
    "special  FP059328           embl_est",
    "special  FP059330-FP059332  embl_est",
    "special  FP059334           embl_est",
    "special  FP059337           embl_est",
    "special  FP059339           embl_est",
    "special  FP059341           embl_est",
    "special  FP059343           embl_est",
    "special  FP059345           embl_est",
    "special  FP059348-FP059352  embl_est",
    "special  FP059354-FP059385  embl_other_nuc # 14 EST ranges",
    "special  FP059387-FP059393  embl_est",
    "special  FP059395-FP059833  embl_other_nuc # 187 EST ranges",
    "special  FP059841-FP059887  embl_other_nuc # 22 EST ranges",
    "special  FP059895-FP060210  embl_other_nuc # 136 EST ranges",
    "special  FP060212-FP060217  embl_est",
    "special  FP060219-FP060469  embl_other_nuc # 104 EST ranges",
    "special  FP060477-FP061762  embl_other_nuc # 552 EST ranges",
    "special  FP061764-FP061769  embl_est",
    "special  FP061771-FP062313  embl_other_nuc # 234 EST ranges",
    "special  FP062315-FP062321  embl_est",
    "special  FP062324-FP062896  embl_other_nuc # 246 EST ranges",
    "special  FP062906-FP062999  embl_other_nuc # 39 EST ranges",
    "special  FP063008-FP063034  embl_other_nuc # 11 EST ranges",
    "special  FP063036-FP063040  embl_est",
    "special  FP063043-FP063447  embl_other_nuc # 166 EST ranges",
    "special  FP063449-FP063453  embl_est",
    "special  FP063455-FP063802  embl_other_nuc # 154 EST ranges",
    "special  FP063804-FP063812  embl_est",
    "special  FP063814-FP063898  embl_other_nuc # 35 EST ranges",
    "special  FP063900-FP063904  embl_est",
    "special  FP063906-FP064076  embl_other_nuc # 74 EST ranges",
    "special  FP064082-FP064562  embl_other_nuc # 208 EST ranges",
    "special  FP064569-FP065157  embl_other_nuc # 251 EST ranges",
    "special  FP065159-FP067333  embl_est",
    "special  FP067453-FP074848  embl_est",
    "special  FP089705-FP089949  embl_est",
    "special  FP090914-FP091223  embl_est",
    "special  FP101920-FP101950  embl_est",
    "special  FP104570-FP236120  embl_est",
    "special  FP236870-FP243270  embl_est",
    "special  FP245546-FP312611  embl_est",
    "special  FP318637-FP325096  embl_est",
    "special  FP331359-FP339571  embl_est",
    "special  FP339630-FP340170  embl_est",
    "special  FP340462-FP340488  embl_est",
    "special  FP350355-FP360034  embl_est",
    "special  FP360036-FP458874  embl_est",
    "special  FP458876-FP475875  embl_est",
    "special  FP489021-FP539727  embl_est",
    "special  FP539730-FP565142  embl_est",
    "special  FP565937-FP578983  embl_est",
    "special  FP579010-FP583343  embl_est",
    "special  FP583356-FP628470  embl_est",
    "special  FP628472-FP671119  embl_est",
    "special  FP671140-FP680548  embl_est",
    "special  FP680607-FP690338  embl_est",
    "special  FP690350-FP700052  embl_est",
    "special  FP700189-FP710243  embl_est",
    "special  FP710258-FP791398  embl_est",
    "special  FP791400-FP884219  embl_est",
    "special  FP884235-FP885524  embl_est",
    "special  FP885545-FP885822  embl_est",
    "special  FP885927-FP893245  embl_est",
    "special  FP893247-FP924936  embl_est",
    "special  FP927985-FP928978  embl_est",
    "special  FP928990-FP928995  embl_est",
    "special  FP929145-FP999998  embl_est",
    "",
    "# Nominally embl_dirsub.",
    "special  FQ000001           embl_est",
    "special  FQ000005-FQ014216  embl_est",
    "special  FQ014236-FQ032656  embl_est",
    "special  FQ032836-FQ073829  embl_est",
    "special  FQ073967-FQ116746  embl_est",
    "special  FQ116748-FQ209379  embl_est",
    "special  FQ235350-FQ242479  embl_est",
    "special  FQ312199-FQ323093  embl_est",
    "special  FQ323164-FQ361146  embl_est",
    "special  FQ361149-FQ377486  embl_est",
    "special  FQ377488-FQ377516  embl_est",
    "special  FQ398062-FQ439981  embl_est",
    "special  FQ439983-FQ440019  embl_est",
    "special  FQ440021-FQ440022  embl_est",
    "special  FQ440024           embl_est",
    "special  FQ440026           embl_est",
    "special  FQ440028           embl_est",
    "special  FQ440030-FQ440032  embl_est",
    "special  FQ440034-FQ456868  embl_est",
    "special  FQ456875-FQ482045  embl_est",
    "special  FQ482048-FQ482071  embl_est",
    "special  FQ660554-FQ670147  embl_est",
    "special  FQ790408-FQ828345  embl_est",
    "special  FQ828348-FQ857191  embl_est",
    "special  FQ859091-FQ859175  embl_est",
    "special  FQ859187-FQ865452  embl_est",
    "special  FQ865457-FQ908260  embl_est",
    "special  FQ908267-FQ958209  embl_est",
    "special  FQ958213-FQ976554  embl_est",
    "special  FQ976923-FQ999999  embl_est",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_con or embl_genome, but split out EST and TPA(!)",
    "# ranges.",
    "special  FR595163-FR647444  embl_est",
    "special  FR660151-FR666602  embl_est",
    "special  FR668536           embl_est",
    "special  FR669245-FR669246  embl_est",
    "special  FR686584           embl_est",
    "special  FR686963-FR686965  embl_est",
    "special  FR688150-FR689535  embl_est",
    "special  FR691564           embl_est",
    "special  FR697056-FR714330  embl_est",
    "special  FR719326-FR719692  embl_est",
    "special  FR726163-FR726165  embl_est",
    "special  FR728240-FR728241  embl_est",
    "special  FR729927-FR731105  embl_est",
    "special  FR734011-FR734074  embl_tpa_nuc",
    "special  FR734407-FR744448  embl_est",
    "special  FR746042-FR746044  embl_est",
    "special  FR746111-FR747822  embl_est",
    "special  FR748230-FR749648  embl_est",
    "special  FR749997           embl_tpa_nuc",
    "special  FR753167-FR754317  embl_est",
    "special  FR754554-FR771822  embl_est",
    "special  FR773977           embl_est",
    "special  FR775966           embl_est",
    "special  FR819721-FR819744  embl_est",
    "special  FR821738-FR821754  embl_tpa_nuc",
    "special  FR822741           embl_tpa_nuc",
    "special  FR828827-FR831799  embl_est",
    "special  FR836483-FR837532  embl_est",
    "special  FR837542-FR837592  embl_est",
    "special  FR839767-FR845655  embl_est",
    "special  FR846456-FR846460  embl_est",
    "special  FR846537-FR846887  embl_est",
    "special  FR847124-FR847145  embl_est",
    "special  FR847228-FR847840  embl_est",
    "special  FR847888-FR847943  embl_est",
    "special  FR848368-FR848371  embl_est",
    "special  FR850135-FR850157  embl_est",
    "special  FR851958           embl_est",
    "special  FR852768           embl_est",
    "special  FR852894-FR852904  embl_est",
    "special  FR854398-FR856581  embl_est",
    "special  FR863689-FR864978  embl_est",
    "special  FR869720-FR869795  embl_est",
    "special  FR872817           embl_tpa_nuc",
    "special  FR873995-FR874005  embl_est",
    "special  FR877768-FR877777  embl_tpa_nuc",
    "special  FR877779-FR878008  embl_est",
    "special  FR878032-FR878040  embl_est",
    "",
    "special  GQ162211-GQ162212  gb_est # Nominally gb_dirsub.",
    "",
    "# Nominally gb_dirsub.",
    "special  GU357827-GU357840  gb_est",
    "special  GU385812           gb_est",
    "",
    "# Nominally embl_dirsub.",
    "special  HE575663-HE575667  embl_est",
    "special  HE578177-HE578180  embl_est",
    "special  HE578289-HE578716  embl_est",
    "special  HE580226-HE580228  embl_est",
    "special  HE580237-HE580238  embl_tpa_nuc",
    "special  HE583424-HE583588  embl_tpa_nuc",
    "special  HE600073-HE600122  embl_est",
    "special  HE602495-HE602530  embl_est",
    "special  HE612182           embl_est",
    "special  HE613800           embl_tpa_nuc",
    "special  HE617969-HE646283  embl_est",
    "special  HE681861-HE681882  embl_est",
    "special  HE775617-HE792769  embl_est",
    "special  HE795538-HE795641  embl_est",
    "special  HE799315-HE799645  embl_est",
    "special  HE802076-HE802106  embl_est",
    "special  HE804769-HE804772  embl_tpa_nuc",
    "special  HE858615-HE859937  embl_est",
    "special  HE862417-HE862958  embl_est",
    "special  HE957083-HE961812  embl_est",
    "special  HE962539           embl_est",
    "special  HE963851-HE964756  embl_tpa_nuc",
    "special  HE967761           embl_tpa_nuc",
    "special  HE967924-HE967957  embl_est",
    "special  HE981808-HE983324  embl_est",
    "special  HE985332-HE993548  embl_est",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome, but split out EST, TPA(!), and WGS ranges.",
    "special  HF546137-HF546200  embl_est",
    "special  HF546978           embl_est",
    "special  HF564658-HF564815  embl_tpa_nuc",
    "special  HF566097-HF566123  embl_est",
    "special  HF567775-HF567843  embl_est",
    "special  HF913790-HF920632  embl_wgs_nuc",
    "special  HF933207-HF933230  embl_tpa_nuc",
    "special  HF952730-HF952771  embl_est",
    "special  HF953988-HF954002  embl_est",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome, but split out EST and TPA(!) ranges.",
    "special  HG000495-HG000664  embl_est",
    "special  HG001312-HG001319  embl_est",
    "special  HG313979-HG314002  embl_tpa_nuc",
    "special  HG314154-HG314951  embl_est",
    "special  HG322958-HG323812  embl_tpa_nuc",
    "special  HG326529-HG326598  embl_est",
    "special  HG328835-HG329089  embl_tpa_nuc",
    "special  HG421036-HG421067  embl_est",
    "special  HG424982-HG425075  embl_est",
    "special  HG425120-HG425123  embl_tpa_nuc",
    "special  HG426065-HG426183  embl_tpa_nuc",
    "special  HG491497-HG512884  embl_tpa_nuc",
    "special  HG516089-HG518058  embl_est",
    "special  HG518794-HG528968  embl_tpa_nuc",
    "special  HG531973-HG532008  embl_tpa_nuc",
    "special  HG780872-HG792014  embl_tpa_nuc",
    "special  HG792878-HG792996  embl_est",
    "special  HG798530-HG798533  embl_est",
    "special  HG931734-HG931849  embl_tpa_nuc",
    "special  HG964498-HG964527  embl_est",
    "special  HG965112-HG965128  embl_est",
    "special  HG970048-HG970064  embl_est",
    "special  HG975377-HG975438  embl_tpa_nuc",
    "special  HG977712-HG983278  embl_tpa_nuc",
    "special  HG983548-HG986399  embl_tpa_nuc",
    "",
    "special  HM042681           gb_est # Nominally gb_dirsub.",
    "",
    "# Nominally gb_dirsub.",
    "special  HQ385980-HQ385998  gb_est",
    "special  HQ436350           gb_est",
    "special  HQ596498-HQ596504  gb_est",
    "special  HQ603829-HQ603854  gb_est",
    "special  HQ616895-HQ616912  gb_est",
    "special  HQ634394-HQ634477  gb_est",
    "",
    "special  JN376805-JN377341  gb_est # Nominally gb_dirsub.",
    "",
    "special  KF487514           gb_est # Nominally gb_dirsub.",
    "",
    "special  KJ472321-KJ472336  gb_est # Nominally gb_dirsub.",
    "",
    "special  KM673248-KM673271  gb_est # Nominally gb_dirsub.",
    "",
    "# Nominally embl_dirsub.",
    "special  LK000001-LK020668  embl_tpa_nuc",
    "special  LK937705-LK939125  embl_tpa_nuc",
    "special  LK985528-LK995307  embl_est",
    "",
    "# Nominally embl_dirsub.",
    "special  LM378690-LM383429  embl_tpa_nuc",
    "special  LM608092-LM611902  embl_tpa_nuc",
    "special  LM644135-LM644234  embl_tpa_nuc",
    "special  LM994684-LM994695  embl_est",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_con, but split out EST and TPA(!) ranges.",
    "special  LN607841-LN608991  embl_tpa_nuc",
    "special  LN624403-LN624404  embl_est",
    "special  LN651082-LN651092  embl_est",
    "special  LN651553-LN678462  embl_est",
    "special  LN680257-LN680271  embl_est",
    "special  LN714474-LN714514  embl_tpa_nuc",
    "special  LN794245-LN794246  embl_tpa_nuc",
    "special  LN809256-LN809883  embl_tpa_nuc",
    "special  LN846618-LN846619  embl_tpa_nuc",
    "special  LN847449-LN848230  embl_tpa_nuc",
    "special  LN849001           embl_tpa_nuc",
    "special  LN871971-LN872940  embl_tpa_nuc",
    "special  LN874312-LN874522  embl_tpa_nuc",
    "special  LN879549-LN879837  embl_est",
    "special  LN885135-LN885143  embl_tpa_nuc",
    "special  LN885145-LN885162  embl_tpa_nuc",
    "special  LN885164-LN885170  embl_tpa_nuc",
    "special  LN885172-LN885202  embl_tpa_nuc",
    "special  LN885204-LN885236  embl_tpa_nuc",
    "special  LN898187-LN898198  embl_tpa_nuc",
    "special  LN901194-LN901210  embl_tpa_nuc",
    "special  LN901386-LN901412  embl_est",
    "",
    "# Nominally embl_dirsub.",
    "special  LT159851-LT159865  embl_est",
    "special  LT548096-LT548244  embl_tpa_nuc",
    "special  LT556286-LT558089  embl_est",
    "special  LT571433-LT571435  embl_tpa_nuc",
    "special  LT605004           embl_tpa_nuc",
    "special  LT631550-LT631670  embl_tpa_nuc",
    "special  LT906301-LT906358  embl_tpa_nuc",
    "special  LT962964-LT963174  embl_tpa_nuc",
    "special  LT990249-LT990597  embl_tpa_nuc",
    "",
    "# Nominally (conservatively) embl_other_nuc.",
    "special  OB000001-OB660024  embl_con",
    "",
    "# Some \"EMBL\" WGS nucleotide accessions are really third-party annotations.",
    "special  CAADSF000000000-CAADSF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAADSM000000000-CAAGJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAAGKD000000000-CAAGKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAAGKS000000000-CAAGRI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAAGRK000000000-CAAGSH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAAHDL000000000-CAAHDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAAHDO000000000-CAAHFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADEPO000000000-CADEVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADEVJ000000000-CADFGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "",
    "# Some \"EMBL\" 8-character protein accessions are really third-party",
    "# annotations.",
    "special  CAD29848-CAD29850  embl_tpa_prot",
    "special  CAD29856           embl_tpa_prot",
    "special  CAD29858-CAD29868  embl_tpa_prot",
    "special  CAD29871-CAD29879  embl_tpa_prot",
    "special  CAD43606           embl_tpa_prot",
    "special  CAD44269           embl_tpa_prot",
    "special  CAD55807           embl_tpa_prot",
    "special  CAD56854           embl_tpa_prot",
    "special  CAD59554           embl_tpa_prot",
    "special  CAD59973-CAD59975  embl_tpa_prot",
    "special  CAD62250           embl_tpa_prot",
    "special  CAD62384-CAD62385  embl_tpa_prot",
    "special  CAD65874-CAD65875  embl_tpa_prot",
    "special  CAD66056-CAD66057  embl_tpa_prot",
    "special  CAD66176           embl_tpa_prot",
    "special  CAD66451-CAD66453  embl_tpa_prot",
    "special  CAD66657           embl_tpa_prot",
    "special  CAD67552-CAD67553  embl_tpa_prot",
    "special  CAD67575-CAD67579  embl_tpa_prot",
    "special  CAD67582           embl_tpa_prot",
    "special  CAD67592-CAD67593  embl_tpa_prot",
    "special  CAD67595           embl_tpa_prot",
    "special  CAD67963-CAD67964  embl_tpa_prot",
    "special  CAD67985           embl_tpa_prot",
    "special  CAD68170-CAD68171  embl_tpa_prot",
    "special  CAD71139           embl_tpa_prot",
    "special  CAD79639           embl_tpa_prot",
    "special  CAD79708           embl_tpa_prot",
    "special  CAD80155-CAD80157  embl_tpa_prot",
    "special  CAD80167           embl_tpa_prot",
    "special  CAD80169           embl_tpa_prot",
    "special  CAD80243           embl_tpa_prot",
    "special  CAD88272-CAD88273  embl_tpa_prot",
    "special  CAD89265-CAD89268  embl_tpa_prot",
    "special  CAD89361           embl_tpa_prot",
    "special  CAD89763           embl_tpa_prot",
    "special  CAD89874-CAD89875  embl_tpa_prot",
    "special  CAD91637           embl_tpa_prot",
    "special  CAD91909-CAD91911  embl_tpa_prot",
    "special  CAD92036           embl_tpa_prot",
    "special  CAD98145           embl_tpa_prot",
    "special  CAE00378-CAE00414  embl_tpa_prot",
    "special  CAE00502           embl_tpa_prot",
    "special  CAE12270-CAE12276  embl_tpa_prot",
    "special  CAE18110           embl_tpa_prot",
    "special  CAE30337           embl_tpa_prot",
    "special  CAE30362           embl_tpa_prot",
    "special  CAE30475-CAE30476  embl_tpa_prot",
    "special  CAE30490-CAE30502  embl_tpa_prot",
    "special  CAE45343           embl_tpa_prot",
    "special  CAE47417           embl_tpa_prot",
    "special  CAE48362-CAE48363  embl_tpa_prot",
    "special  CAE48373-CAE48393  embl_tpa_prot",
    "special  CAE48395-CAE48396  embl_tpa_prot",
    "special  CAE51393-CAE51417  embl_tpa_prot",
    "special  CAE51851           embl_tpa_prot",
    "special  CAE51855-CAE51856  embl_tpa_prot",
    "special  CAE51895-CAE51916  embl_tpa_prot",
    "special  CAE52317-CAE52320  embl_tpa_prot",
    "special  CAE54311-CAE54352  embl_tpa_prot",
    "special  CAE54495           embl_tpa_prot",
    "special  CAE75602-CAE75631  embl_tpa_prot",
    "special  CAE75743           embl_tpa_prot",
    "special  CAE82298-CAE82299  embl_tpa_prot",
    "special  CAF06526-CAF06530  embl_tpa_prot",
    "special  CAF18402           embl_tpa_prot",
    "special  CAF21736-CAF21739  embl_tpa_prot",
    "special  CAF32458           embl_tpa_prot",
    "special  CAG23871           embl_tpa_prot",
    "special  CAG26661-CAG26664  embl_tpa_prot",
    "special  CAG26750           embl_tpa_prot",
    "special  CAG29023-CAG29030  embl_tpa_prot",
    "special  CAG29113           embl_tpa_prot",
    "special  CAG30664           embl_tpa_prot",
    "special  CAG33760           embl_tpa_prot",
    "special  CAG34288-CAG34296  embl_tpa_prot",
    "special  CAH03726-CAH03727  embl_tpa_prot",
    "special  CAH17840-CAH17841  embl_tpa_prot",
    "special  CAH17860-CAH17862  embl_tpa_prot",
    "special  CAH18893           embl_tpa_prot",
    "special  CAH18925-CAH18926  embl_tpa_prot",
    "special  CAH56764           embl_tpa_prot",
    "special  CAH59193-CAH59194  embl_tpa_prot",
    "special  CAH69244-CAH69380  embl_tpa_prot",
    "special  CAH74220           embl_tpa_prot",
    "special  CAH74225           embl_tpa_prot",
    "special  CAH89261-CAH89263  embl_tpa_prot",
    "special  CAI56319-CAI56335  embl_tpa_prot",
    "special  CAI59572           embl_tpa_prot",
    "special  CAI61342-CAI61347  embl_tpa_prot",
    "special  CAI77244-CAI77245  embl_tpa_prot",
    "special  CAI77247           embl_tpa_prot",
    "special  CAI78909           embl_tpa_prot",
    "special  CAI84981-CAI85013  embl_tpa_prot",
    "special  CAI94882-CAI94883  embl_tpa_prot",
    "special  CAI94931-CAI94934  embl_tpa_prot",
    "special  CAI96518-CAI96519  embl_tpa_prot",
    "special  CAI96537           embl_tpa_prot",
    "special  CAI99155-CAI99156  embl_tpa_prot",
    "special  CAI99158-CAI99163  embl_tpa_prot",
    "special  CAI99872           embl_tpa_prot",
    "special  CAJ00225-CAJ00252  embl_tpa_prot",
    "special  CAJ09703           embl_tpa_prot",
    "special  CAJ13823-CAJ13825  embl_tpa_prot",
    "special  CAJ27980-CAJ27981  embl_tpa_prot",
    "special  CAJ29275           embl_tpa_prot",
    "special  CAJ29301-CAJ29302  embl_tpa_prot",
    "special  CAJ30479           embl_tpa_prot",
    "special  CAJ30481-CAJ30484  embl_tpa_prot",
    "special  CAJ31324           embl_tpa_prot",
    "special  CAJ33891           embl_tpa_prot",
    "special  CAJ38407-CAJ38408  embl_tpa_prot",
    "special  CAJ38499           embl_tpa_prot",
    "special  CAJ40614           embl_tpa_prot",
    "special  CAJ43796-CAJ43809  embl_tpa_prot",
    "special  CAJ43920-CAJ43921  embl_tpa_prot",
    "special  CAJ44080           embl_tpa_prot",
    "special  CAJ44121           embl_tpa_prot",
    "special  CAJ44286-CAJ44287  embl_tpa_prot",
    "special  CAJ44438-CAJ44439  embl_tpa_prot",
    "special  CAJ44441           embl_tpa_prot",
    "special  CAJ51090           embl_tpa_prot",
    "special  CAJ55345           embl_tpa_prot",
    "special  CAJ55730-CAJ55733  embl_tpa_prot",
    "special  CAJ55745-CAJ55747  embl_tpa_prot",
    "special  CAJ55783-CAJ55784  embl_tpa_prot",
    "special  CAJ55824-CAJ55825  embl_tpa_prot",
    "special  CAJ57445-CAJ57446  embl_tpa_prot",
    "special  CAJ57644-CAJ57646  embl_tpa_prot",
    "special  CAJ70647-CAJ70649  embl_tpa_prot",
    "special  CAJ75788-CAJ75789  embl_tpa_prot",
    "special  CAJ75791-CAJ75796  embl_tpa_prot",
    "special  CAJ77879-CAJ77886  embl_tpa_prot",
    "special  CAJ80803           embl_tpa_prot",
    "special  CAJ84770           embl_tpa_prot",
    "special  CAJ85665-CAJ85675  embl_tpa_prot",
    "special  CAJ85677-CAJ85711  embl_tpa_prot",
    "special  CAJ85713-CAJ85740  embl_tpa_prot",
    "special  CAJ97442           embl_tpa_prot",
    "special  CAK26553           embl_tpa_prot",
    "special  CAK26777-CAK26786  embl_tpa_prot",
    "special  CAK32514           embl_tpa_prot",
    "special  CAK32639           embl_tpa_prot",
    "special  CAL07997           embl_tpa_prot",
    "special  CAL08000-CAL08005  embl_tpa_prot",
    "special  CAL10024           embl_tpa_prot",
    "special  CAL36192           embl_tpa_prot",
    "special  CAL36432-CAL36433  embl_tpa_prot",
    "special  CAL41938-CAL41942  embl_tpa_prot",
    "special  CAL48250           embl_tpa_prot",
    "special  CAL48381-CAL48383  embl_tpa_prot",
    "special  CAL59562-CAL59577  embl_tpa_prot",
    "special  CAL63903-CAL63904  embl_tpa_prot",
    "special  CAL64054-CAL64058  embl_tpa_prot",
    "special  CAL69034-CAL69036  embl_tpa_prot",
    "special  CAL69054           embl_tpa_prot",
    "special  CAL69056-CAL69118  embl_tpa_prot",
    "special  CAL90972-CAL90973  embl_tpa_prot",
    "special  CAM06633           embl_tpa_prot",
    "special  CAM12311           embl_tpa_prot",
    "special  CAM31706-CAM31708  embl_tpa_prot",
    "special  CAM31891-CAM31896  embl_tpa_prot",
    "special  CAM32419           embl_tpa_prot",
    "special  CAM33450-CAM33457  embl_tpa_prot",
    "special  CAM33512-CAM33520  embl_tpa_prot",
    "special  CAM91227           embl_tpa_prot",
    "special  CAN88845-CAN88848  embl_tpa_prot",
    "special  CAO03085-CAO03089  embl_tpa_prot",
    "special  CAP39936-CAP39937  embl_tpa_prot",
    "special  CAP45848           embl_tpa_prot",
    "special  CAP49313-CAP49318  embl_tpa_prot",
    "special  CAP49321-CAP49327  embl_tpa_prot",
    "special  CAP64321           embl_tpa_prot",
    "special  CAP64323-CAP64334  embl_tpa_prot",
    "special  CAQ34914-CAQ34930  embl_tpa_prot",
    "special  CAQ76705-CAQ76712  embl_tpa_prot",
    "special  CAQ76718           embl_tpa_prot",
    "special  CAR63508-CAR63509  embl_tpa_prot",
    "special  CAR82065-CAR82067  embl_tpa_prot",
    "special  CAR82176-CAR82186  embl_tpa_prot",
    "special  CAR94693-CAR94710  embl_tpa_prot",
    "special  CAR95342-CAR95361  embl_tpa_prot",
    "special  CAR97787           embl_tpa_prot",
    "special  CAU95867-CAU95879  embl_tpa_prot",
    "special  CAV13457           embl_tpa_prot",
    "special  CAX62810-CAX62813  embl_tpa_prot",
    "special  CAX63316           embl_tpa_prot",
    "special  CAX63367           embl_tpa_prot",
    "special  CBF69357           embl_tpa_prot",
    "special  CBF69359-CBF69360  embl_tpa_prot",
    "special  CBF69362           embl_tpa_prot",
    "special  CBF69364           embl_tpa_prot",
    "special  CBF69366           embl_tpa_prot",
    "special  CBF69368-CBF69369  embl_tpa_prot",
    "special  CBF69371           embl_tpa_prot",
    "special  CBF69373           embl_tpa_prot",
    "special  CBF69375           embl_tpa_prot",
    "special  CBF69377           embl_tpa_prot",
    "special  CBF69379           embl_tpa_prot",
    "special  CBF69381           embl_tpa_prot",
    "special  CBF69383           embl_tpa_prot",
    "special  CBF69385           embl_tpa_prot",
    "special  CBF69387-CBF69388  embl_tpa_prot",
    "special  CBF69390           embl_tpa_prot",
    "special  CBF69392           embl_tpa_prot",
    "special  CBF69394           embl_tpa_prot",
    "special  CBF69396-CBF69397  embl_tpa_prot",
    "special  CBF69399           embl_tpa_prot",
    "special  CBF69401           embl_tpa_prot",
    "special  CBF69403           embl_tpa_prot",
    "special  CBF69405           embl_tpa_prot",
    "special  CBF69407-CBF69408  embl_tpa_prot",
    "special  CBF69410           embl_tpa_prot",
    "special  CBF69412           embl_tpa_prot",
    "special  CBF69414           embl_tpa_prot",
    "special  CBF69416           embl_tpa_prot",
    "special  CBF69418-CBF69419  embl_tpa_prot",
    "special  CBF69421           embl_tpa_prot",
    "special  CBF69423           embl_tpa_prot",
    "special  CBF69425           embl_tpa_prot",
    "special  CBF69427           embl_tpa_prot",
    "special  CBF69429           embl_tpa_prot",
    "special  CBF69431-CBF69432  embl_tpa_prot",
    "special  CBF69434           embl_tpa_prot",
    "special  CBF69436           embl_tpa_prot",
    "special  CBF69438           embl_tpa_prot",
    "special  CBF69440-CBF69441  embl_tpa_prot",
    "special  CBF69443           embl_tpa_prot",
    "special  CBF69445           embl_tpa_prot",
    "special  CBF69447           embl_tpa_prot",
    "special  CBF69449           embl_tpa_prot",
    "special  CBF69451           embl_tpa_prot",
    "special  CBF69453-CBF69454  embl_tpa_prot",
    "special  CBF69456           embl_tpa_prot",
    "special  CBF69458-CBF69459  embl_tpa_prot",
    "special  CBF69461           embl_tpa_prot",
    "special  CBF69463           embl_tpa_prot",
    "special  CBF69465           embl_tpa_prot",
    "special  CBF69467-CBF69468  embl_tpa_prot",
    "special  CBF69470           embl_tpa_prot",
    "special  CBF69472-CBF69473  embl_tpa_prot",
    "special  CBF69475           embl_tpa_prot",
    "special  CBF69477           embl_tpa_prot",
    "special  CBF69479-CBF69480  embl_tpa_prot",
    "special  CBF69482           embl_tpa_prot",
    "special  CBF69484-CBF69485  embl_tpa_prot",
    "special  CBF69487           embl_tpa_prot",
    "special  CBF69489-CBF69490  embl_tpa_prot",
    "special  CBF69492           embl_tpa_prot",
    "special  CBF69494           embl_tpa_prot",
    "special  CBF69496-CBF69497  embl_tpa_prot",
    "special  CBF69499-CBF69500  embl_tpa_prot",
    "special  CBF69502           embl_tpa_prot",
    "special  CBF69504           embl_tpa_prot",
    "special  CBF69506-CBF69507  embl_tpa_prot",
    "special  CBF69509           embl_tpa_prot",
    "special  CBF69511           embl_tpa_prot",
    "special  CBF69513           embl_tpa_prot",
    "special  CBF69515           embl_tpa_prot",
    "special  CBF69517-CBF69518  embl_tpa_prot",
    "special  CBF69520           embl_tpa_prot",
    "special  CBF69522           embl_tpa_prot",
    "special  CBF69524-CBF69525  embl_tpa_prot",
    "special  CBF69527           embl_tpa_prot",
    "special  CBF69529           embl_tpa_prot",
    "special  CBF69531           embl_tpa_prot",
    "special  CBF69533-CBF69534  embl_tpa_prot",
    "special  CBF69536           embl_tpa_prot",
    "special  CBF69538           embl_tpa_prot",
    "special  CBF69540           embl_tpa_prot",
    "special  CBF69542           embl_tpa_prot",
    "special  CBF69544           embl_tpa_prot",
    "special  CBF69546           embl_tpa_prot",
    "special  CBF69548           embl_tpa_prot",
    "special  CBF69550           embl_tpa_prot",
    "special  CBF69552           embl_tpa_prot",
    "special  CBF69554-CBF69555  embl_tpa_prot",
    "special  CBF69557-CBF69558  embl_tpa_prot",
    "special  CBF69560           embl_tpa_prot",
    "special  CBF69562           embl_tpa_prot",
    "special  CBF69564-CBF69565  embl_tpa_prot",
    "special  CBF69567           embl_tpa_prot",
    "special  CBF69569           embl_tpa_prot",
    "special  CBF69571           embl_tpa_prot",
    "special  CBF69573           embl_tpa_prot",
    "special  CBF69575-CBF69576  embl_tpa_prot",
    "special  CBF69578           embl_tpa_prot",
    "special  CBF69580           embl_tpa_prot",
    "special  CBF69582-CBF69583  embl_tpa_prot",
    "special  CBF69585           embl_tpa_prot",
    "special  CBF69587           embl_tpa_prot",
    "special  CBF69589           embl_tpa_prot",
    "special  CBF69591-CBF69592  embl_tpa_prot",
    "special  CBF69594           embl_tpa_prot",
    "special  CBF69596           embl_tpa_prot",
    "special  CBF69598           embl_tpa_prot",
    "special  CBF69600           embl_tpa_prot",
    "special  CBF69602           embl_tpa_prot",
    "special  CBF69604-CBF69605  embl_tpa_prot",
    "special  CBF69607           embl_tpa_prot",
    "special  CBF69609           embl_tpa_prot",
    "special  CBF69611           embl_tpa_prot",
    "special  CBF69613           embl_tpa_prot",
    "special  CBF69615           embl_tpa_prot",
    "special  CBF69617           embl_tpa_prot",
    "special  CBF69619           embl_tpa_prot",
    "special  CBF69621           embl_tpa_prot",
    "special  CBF69623           embl_tpa_prot",
    "special  CBF69625           embl_tpa_prot",
    "special  CBF69627           embl_tpa_prot",
    "special  CBF69629           embl_tpa_prot",
    "special  CBF69631           embl_tpa_prot",
    "special  CBF69633           embl_tpa_prot",
    "special  CBF69635           embl_tpa_prot",
    "special  CBF69637           embl_tpa_prot",
    "special  CBF69639-CBF69640  embl_tpa_prot",
    "special  CBF69642           embl_tpa_prot",
    "special  CBF69644           embl_tpa_prot",
    "special  CBF69646           embl_tpa_prot",
    "special  CBF69648-CBF69649  embl_tpa_prot",
    "special  CBF69652-CBF69653  embl_tpa_prot",
    "special  CBF69655           embl_tpa_prot",
    "special  CBF69657           embl_tpa_prot",
    "special  CBF69659           embl_tpa_prot",
    "special  CBF69661           embl_tpa_prot",
    "special  CBF69663           embl_tpa_prot",
    "special  CBF69665           embl_tpa_prot",
    "special  CBF69667           embl_tpa_prot",
    "special  CBF69669           embl_tpa_prot",
    "special  CBF69671-CBF69672  embl_tpa_prot",
    "special  CBF69674           embl_tpa_prot",
    "special  CBF69676           embl_tpa_prot",
    "special  CBF69678           embl_tpa_prot",
    "special  CBF69680           embl_tpa_prot",
    "special  CBF69682           embl_tpa_prot",
    "special  CBF69684           embl_tpa_prot",
    "special  CBF69686           embl_tpa_prot",
    "special  CBF69688-CBF69689  embl_tpa_prot",
    "special  CBF69691           embl_tpa_prot",
    "special  CBF69693           embl_tpa_prot",
    "special  CBF69695           embl_tpa_prot",
    "special  CBF69697           embl_tpa_prot",
    "special  CBF69699           embl_tpa_prot",
    "special  CBF69701           embl_tpa_prot",
    "special  CBF69703           embl_tpa_prot",
    "special  CBF69705           embl_tpa_prot",
    "special  CBF69707           embl_tpa_prot",
    "special  CBF69709           embl_tpa_prot",
    "special  CBF69711           embl_tpa_prot",
    "special  CBF69713           embl_tpa_prot",
    "special  CBF69715           embl_tpa_prot",
    "special  CBF69717           embl_tpa_prot",
    "special  CBF69719-CBF69720  embl_tpa_prot",
    "special  CBF69722           embl_tpa_prot",
    "special  CBF69724           embl_tpa_prot",
    "special  CBF69726           embl_tpa_prot",
    "special  CBF69728           embl_tpa_prot",
    "special  CBF69730           embl_tpa_prot",
    "special  CBF69732           embl_tpa_prot",
    "special  CBF69734           embl_tpa_prot",
    "special  CBF69736           embl_tpa_prot",
    "special  CBF69738           embl_tpa_prot",
    "special  CBF69740           embl_tpa_prot",
    "special  CBF69742           embl_tpa_prot",
    "special  CBF69744           embl_tpa_prot",
    "special  CBF69746           embl_tpa_prot",
    "special  CBF69748           embl_tpa_prot",
    "special  CBF69750           embl_tpa_prot",
    "special  CBF69752           embl_tpa_prot",
    "special  CBF69754           embl_tpa_prot",
    "special  CBF69756           embl_tpa_prot",
    "special  CBF69758-CBF69759  embl_tpa_prot",
    "special  CBF69761           embl_tpa_prot",
    "special  CBF69763           embl_tpa_prot",
    "special  CBF69765           embl_tpa_prot",
    "special  CBF69767           embl_tpa_prot",
    "special  CBF69769           embl_tpa_prot",
    "special  CBF69771           embl_tpa_prot",
    "special  CBF69773           embl_tpa_prot",
    "special  CBF69775           embl_tpa_prot",
    "special  CBF69777-CBF69778  embl_tpa_prot",
    "special  CBF69780           embl_tpa_prot",
    "special  CBF69782           embl_tpa_prot",
    "special  CBF69784           embl_tpa_prot",
    "special  CBF69786           embl_tpa_prot",
    "special  CBF69788           embl_tpa_prot",
    "special  CBF69790-CBF69791  embl_tpa_prot",
    "special  CBF69793           embl_tpa_prot",
    "special  CBF69795           embl_tpa_prot",
    "special  CBF69797           embl_tpa_prot",
    "special  CBF69799           embl_tpa_prot",
    "special  CBF69801           embl_tpa_prot",
    "special  CBF69803           embl_tpa_prot",
    "special  CBF69805           embl_tpa_prot",
    "special  CBF69807           embl_tpa_prot",
    "special  CBF69809           embl_tpa_prot",
    "special  CBF69811           embl_tpa_prot",
    "special  CBF69813           embl_tpa_prot",
    "special  CBF69815           embl_tpa_prot",
    "special  CBF69817           embl_tpa_prot",
    "special  CBF69819           embl_tpa_prot",
    "special  CBF69821           embl_tpa_prot",
    "special  CBF69823           embl_tpa_prot",
    "special  CBF69825           embl_tpa_prot",
    "special  CBF69827           embl_tpa_prot",
    "special  CBF69829           embl_tpa_prot",
    "special  CBF69831-CBF69832  embl_tpa_prot",
    "special  CBF69834           embl_tpa_prot",
    "special  CBF69836           embl_tpa_prot",
    "special  CBF69838           embl_tpa_prot",
    "special  CBF69840           embl_tpa_prot",
    "special  CBF69842           embl_tpa_prot",
    "special  CBF69844           embl_tpa_prot",
    "special  CBF69846           embl_tpa_prot",
    "special  CBF69848           embl_tpa_prot",
    "special  CBF69850           embl_tpa_prot",
    "special  CBF69852           embl_tpa_prot",
    "special  CBF69854           embl_tpa_prot",
    "special  CBF69856-CBF69857  embl_tpa_prot",
    "special  CBF69859           embl_tpa_prot",
    "special  CBF69861           embl_tpa_prot",
    "special  CBF69863           embl_tpa_prot",
    "special  CBF69865           embl_tpa_prot",
    "special  CBF69867           embl_tpa_prot",
    "special  CBF69869           embl_tpa_prot",
    "special  CBF69871           embl_tpa_prot",
    "special  CBF69873           embl_tpa_prot",
    "special  CBF69875           embl_tpa_prot",
    "special  CBF69877           embl_tpa_prot",
    "special  CBF69879           embl_tpa_prot",
    "special  CBF69881           embl_tpa_prot",
    "special  CBF69883-CBF69884  embl_tpa_prot",
    "special  CBF69887           embl_tpa_prot",
    "special  CBF69889-CBF69890  embl_tpa_prot",
    "special  CBF69892           embl_tpa_prot",
    "special  CBF69894           embl_tpa_prot",
    "special  CBF69896           embl_tpa_prot",
    "special  CBF69898           embl_tpa_prot",
    "special  CBF69900           embl_tpa_prot",
    "special  CBF69902           embl_tpa_prot",
    "special  CBF69904           embl_tpa_prot",
    "special  CBF69906           embl_tpa_prot",
    "special  CBF69908           embl_tpa_prot",
    "special  CBF69910-CBF69911  embl_tpa_prot",
    "special  CBF69913           embl_tpa_prot",
    "special  CBF69915           embl_tpa_prot",
    "special  CBF69917           embl_tpa_prot",
    "special  CBF69919           embl_tpa_prot",
    "special  CBF69921           embl_tpa_prot",
    "special  CBF69923           embl_tpa_prot",
    "special  CBF69925-CBF69926  embl_tpa_prot",
    "special  CBF69928           embl_tpa_prot",
    "special  CBF69930           embl_tpa_prot",
    "special  CBF69932           embl_tpa_prot",
    "special  CBF69934           embl_tpa_prot",
    "special  CBF69936           embl_tpa_prot",
    "special  CBF69938           embl_tpa_prot",
    "special  CBF69940           embl_tpa_prot",
    "special  CBF69942           embl_tpa_prot",
    "special  CBF69944-CBF69945  embl_tpa_prot",
    "special  CBF69947           embl_tpa_prot",
    "special  CBF69949           embl_tpa_prot",
    "special  CBF69951           embl_tpa_prot",
    "special  CBF69953           embl_tpa_prot",
    "special  CBF69955           embl_tpa_prot",
    "special  CBF69957           embl_tpa_prot",
    "special  CBF69959           embl_tpa_prot",
    "special  CBF69961           embl_tpa_prot",
    "special  CBF69963           embl_tpa_prot",
    "special  CBF69965           embl_tpa_prot",
    "special  CBF69967           embl_tpa_prot",
    "special  CBF69969           embl_tpa_prot",
    "special  CBF69971           embl_tpa_prot",
    "special  CBF69973           embl_tpa_prot",
    "special  CBF69975           embl_tpa_prot",
    "special  CBF69977           embl_tpa_prot",
    "special  CBF69979           embl_tpa_prot",
    "special  CBF69981           embl_tpa_prot",
    "special  CBF69983           embl_tpa_prot",
    "special  CBF69985           embl_tpa_prot",
    "special  CBF69987           embl_tpa_prot",
    "special  CBF69989           embl_tpa_prot",
    "special  CBF69991-CBF69992  embl_tpa_prot",
    "special  CBF69994           embl_tpa_prot",
    "special  CBF69996           embl_tpa_prot",
    "special  CBF69998           embl_tpa_prot",
    "special  CBF70000           embl_tpa_prot",
    "special  CBF70002           embl_tpa_prot",
    "special  CBF70004           embl_tpa_prot",
    "special  CBF70006           embl_tpa_prot",
    "special  CBF70008           embl_tpa_prot",
    "special  CBF70010           embl_tpa_prot",
    "special  CBF70012           embl_tpa_prot",
    "special  CBF70014           embl_tpa_prot",
    "special  CBF70016           embl_tpa_prot",
    "special  CBF70018-CBF70019  embl_tpa_prot",
    "special  CBF70021           embl_tpa_prot",
    "special  CBF70023           embl_tpa_prot",
    "special  CBF70025           embl_tpa_prot",
    "special  CBF70027           embl_tpa_prot",
    "special  CBF70029           embl_tpa_prot",
    "special  CBF70031           embl_tpa_prot",
    "special  CBF70033           embl_tpa_prot",
    "special  CBF70035           embl_tpa_prot",
    "special  CBF70037           embl_tpa_prot",
    "special  CBF70039           embl_tpa_prot",
    "special  CBF70041           embl_tpa_prot",
    "special  CBF70043           embl_tpa_prot",
    "special  CBF70045           embl_tpa_prot",
    "special  CBF70047           embl_tpa_prot",
    "special  CBF70049           embl_tpa_prot",
    "special  CBF70051           embl_tpa_prot",
    "special  CBF70053           embl_tpa_prot",
    "special  CBF70055           embl_tpa_prot",
    "special  CBF70057           embl_tpa_prot",
    "special  CBF70059           embl_tpa_prot",
    "special  CBF70061-CBF70062  embl_tpa_prot",
    "special  CBF70064           embl_tpa_prot",
    "special  CBF70066           embl_tpa_prot",
    "special  CBF70068           embl_tpa_prot",
    "special  CBF70070           embl_tpa_prot",
    "special  CBF70072           embl_tpa_prot",
    "special  CBF70074           embl_tpa_prot",
    "special  CBF70076           embl_tpa_prot",
    "special  CBF70078           embl_tpa_prot",
    "special  CBF70080           embl_tpa_prot",
    "special  CBF70082           embl_tpa_prot",
    "special  CBF70084-CBF70085  embl_tpa_prot",
    "special  CBF70087           embl_tpa_prot",
    "special  CBF70089           embl_tpa_prot",
    "special  CBF70091           embl_tpa_prot",
    "special  CBF70093-CBF70094  embl_tpa_prot",
    "special  CBF70096           embl_tpa_prot",
    "special  CBF70098           embl_tpa_prot",
    "special  CBF70100-CBF70101  embl_tpa_prot",
    "special  CBF70103           embl_tpa_prot",
    "special  CBF70105           embl_tpa_prot",
    "special  CBF70107-CBF70108  embl_tpa_prot",
    "special  CBF70110           embl_tpa_prot",
    "special  CBF70112           embl_tpa_prot",
    "special  CBF70114           embl_tpa_prot",
    "special  CBF70116           embl_tpa_prot",
    "special  CBF70118           embl_tpa_prot",
    "special  CBF70120           embl_tpa_prot",
    "special  CBF70122           embl_tpa_prot",
    "special  CBF70124           embl_tpa_prot",
    "special  CBF70126           embl_tpa_prot",
    "special  CBF70128           embl_tpa_prot",
    "special  CBF70130           embl_tpa_prot",
    "special  CBF70132           embl_tpa_prot",
    "special  CBF70134           embl_tpa_prot",
    "special  CBF70136           embl_tpa_prot",
    "special  CBF70138-CBF70139  embl_tpa_prot",
    "special  CBF70143           embl_tpa_prot",
    "special  CBF70145           embl_tpa_prot",
    "special  CBF70147           embl_tpa_prot",
    "special  CBF70149           embl_tpa_prot",
    "special  CBF70151           embl_tpa_prot",
    "special  CBF70153           embl_tpa_prot",
    "special  CBF70155           embl_tpa_prot",
    "special  CBF70157           embl_tpa_prot",
    "special  CBF70159           embl_tpa_prot",
    "special  CBF70161-CBF70162  embl_tpa_prot",
    "special  CBF70164           embl_tpa_prot",
    "special  CBF70166           embl_tpa_prot",
    "special  CBF70168           embl_tpa_prot",
    "special  CBF70170           embl_tpa_prot",
    "special  CBF70172-CBF70173  embl_tpa_prot",
    "special  CBF70175           embl_tpa_prot",
    "special  CBF70177           embl_tpa_prot",
    "special  CBF70179-CBF70181  embl_tpa_prot",
    "special  CBF70183           embl_tpa_prot",
    "special  CBF70185           embl_tpa_prot",
    "special  CBF70187           embl_tpa_prot",
    "special  CBF70189-CBF70190  embl_tpa_prot",
    "special  CBF70192           embl_tpa_prot",
    "special  CBF70194           embl_tpa_prot",
    "special  CBF70196           embl_tpa_prot",
    "special  CBF70198           embl_tpa_prot",
    "special  CBF70200           embl_tpa_prot",
    "special  CBF70202           embl_tpa_prot",
    "special  CBF70204           embl_tpa_prot",
    "special  CBF70206           embl_tpa_prot",
    "special  CBF70208-CBF70209  embl_tpa_prot",
    "special  CBF70211           embl_tpa_prot",
    "special  CBF70213           embl_tpa_prot",
    "special  CBF70215           embl_tpa_prot",
    "special  CBF70217           embl_tpa_prot",
    "special  CBF70219           embl_tpa_prot",
    "special  CBF70221           embl_tpa_prot",
    "special  CBF70223-CBF70224  embl_tpa_prot",
    "special  CBF70226           embl_tpa_prot",
    "special  CBF70228           embl_tpa_prot",
    "special  CBF70230           embl_tpa_prot",
    "special  CBF70232           embl_tpa_prot",
    "special  CBF70234           embl_tpa_prot",
    "special  CBF70236-CBF70237  embl_tpa_prot",
    "special  CBF70239           embl_tpa_prot",
    "special  CBF70241           embl_tpa_prot",
    "special  CBF70243           embl_tpa_prot",
    "special  CBF70245           embl_tpa_prot",
    "special  CBF70247           embl_tpa_prot",
    "special  CBF70249           embl_tpa_prot",
    "special  CBF70251           embl_tpa_prot",
    "special  CBF70253           embl_tpa_prot",
    "special  CBF70255           embl_tpa_prot",
    "special  CBF70257           embl_tpa_prot",
    "special  CBF70259           embl_tpa_prot",
    "special  CBF70261           embl_tpa_prot",
    "special  CBF70263           embl_tpa_prot",
    "special  CBF70265           embl_tpa_prot",
    "special  CBF70267           embl_tpa_prot",
    "special  CBF70269           embl_tpa_prot",
    "special  CBF70271           embl_tpa_prot",
    "special  CBF70273           embl_tpa_prot",
    "special  CBF70275           embl_tpa_prot",
    "special  CBF70277           embl_tpa_prot",
    "special  CBF70279-CBF70280  embl_tpa_prot",
    "special  CBF70282           embl_tpa_prot",
    "special  CBF70284           embl_tpa_prot",
    "special  CBF70286           embl_tpa_prot",
    "special  CBF70288           embl_tpa_prot",
    "special  CBF70290           embl_tpa_prot",
    "special  CBF70292           embl_tpa_prot",
    "special  CBF70294           embl_tpa_prot",
    "special  CBF70296           embl_tpa_prot",
    "special  CBF70298           embl_tpa_prot",
    "special  CBF70300-CBF70301  embl_tpa_prot",
    "special  CBF70303           embl_tpa_prot",
    "special  CBF70305           embl_tpa_prot",
    "special  CBF70307           embl_tpa_prot",
    "special  CBF70309           embl_tpa_prot",
    "special  CBF70311           embl_tpa_prot",
    "special  CBF70313           embl_tpa_prot",
    "special  CBF70315           embl_tpa_prot",
    "special  CBF70317           embl_tpa_prot",
    "special  CBF70319-CBF70320  embl_tpa_prot",
    "special  CBF70322           embl_tpa_prot",
    "special  CBF70324           embl_tpa_prot",
    "special  CBF70326           embl_tpa_prot",
    "special  CBF70328           embl_tpa_prot",
    "special  CBF70330           embl_tpa_prot",
    "special  CBF70332           embl_tpa_prot",
    "special  CBF70334           embl_tpa_prot",
    "special  CBF70336           embl_tpa_prot",
    "special  CBF70338           embl_tpa_prot",
    "special  CBF70340           embl_tpa_prot",
    "special  CBF70342           embl_tpa_prot",
    "special  CBF70344           embl_tpa_prot",
    "special  CBF70346           embl_tpa_prot",
    "special  CBF70348           embl_tpa_prot",
    "special  CBF70350           embl_tpa_prot",
    "special  CBF70352           embl_tpa_prot",
    "special  CBF70354           embl_tpa_prot",
    "special  CBF70356           embl_tpa_prot",
    "special  CBF70358           embl_tpa_prot",
    "special  CBF70360           embl_tpa_prot",
    "special  CBF70362           embl_tpa_prot",
    "special  CBF70364           embl_tpa_prot",
    "special  CBF70366           embl_tpa_prot",
    "special  CBF70368           embl_tpa_prot",
    "special  CBF70370           embl_tpa_prot",
    "special  CBF70372           embl_tpa_prot",
    "special  CBF70374-CBF70375  embl_tpa_prot",
    "special  CBF70377           embl_tpa_prot",
    "special  CBF70379           embl_tpa_prot",
    "special  CBF70381           embl_tpa_prot",
    "special  CBF70383           embl_tpa_prot",
    "special  CBF70385           embl_tpa_prot",
    "special  CBF70387           embl_tpa_prot",
    "special  CBF70389           embl_tpa_prot",
    "special  CBF70391           embl_tpa_prot",
    "special  CBF70393           embl_tpa_prot",
    "special  CBF70395           embl_tpa_prot",
    "special  CBF70397           embl_tpa_prot",
    "special  CBF70399           embl_tpa_prot",
    "special  CBF70401           embl_tpa_prot",
    "special  CBF70403           embl_tpa_prot",
    "special  CBF70405           embl_tpa_prot",
    "special  CBF70407           embl_tpa_prot",
    "special  CBF70409-CBF70410  embl_tpa_prot",
    "special  CBF70412           embl_tpa_prot",
    "special  CBF70414           embl_tpa_prot",
    "special  CBF70416           embl_tpa_prot",
    "special  CBF70418           embl_tpa_prot",
    "special  CBF70420           embl_tpa_prot",
    "special  CBF70422           embl_tpa_prot",
    "special  CBF70424           embl_tpa_prot",
    "special  CBF70426           embl_tpa_prot",
    "special  CBF70428           embl_tpa_prot",
    "special  CBF70430           embl_tpa_prot",
    "special  CBF70432           embl_tpa_prot",
    "special  CBF70434-CBF70435  embl_tpa_prot",
    "special  CBF70437           embl_tpa_prot",
    "special  CBF70439           embl_tpa_prot",
    "special  CBF70441           embl_tpa_prot",
    "special  CBF70443           embl_tpa_prot",
    "special  CBF70445           embl_tpa_prot",
    "special  CBF70447           embl_tpa_prot",
    "special  CBF70449           embl_tpa_prot",
    "special  CBF70451           embl_tpa_prot",
    "special  CBF70453           embl_tpa_prot",
    "special  CBF70455           embl_tpa_prot",
    "special  CBF70457           embl_tpa_prot",
    "special  CBF70459           embl_tpa_prot",
    "special  CBF70461-CBF70462  embl_tpa_prot",
    "special  CBF70464           embl_tpa_prot",
    "special  CBF70466           embl_tpa_prot",
    "special  CBF70468           embl_tpa_prot",
    "special  CBF70470           embl_tpa_prot",
    "special  CBF70472           embl_tpa_prot",
    "special  CBF70475-CBF70476  embl_tpa_prot",
    "special  CBF70478           embl_tpa_prot",
    "special  CBF70480           embl_tpa_prot",
    "special  CBF70482           embl_tpa_prot",
    "special  CBF70484           embl_tpa_prot",
    "special  CBF70486           embl_tpa_prot",
    "special  CBF70488           embl_tpa_prot",
    "special  CBF70490-CBF70491  embl_tpa_prot",
    "special  CBF70493           embl_tpa_prot",
    "special  CBF70495           embl_tpa_prot",
    "special  CBF70497           embl_tpa_prot",
    "special  CBF70499           embl_tpa_prot",
    "special  CBF70501           embl_tpa_prot",
    "special  CBF70503-CBF70504  embl_tpa_prot",
    "special  CBF70506           embl_tpa_prot",
    "special  CBF70508           embl_tpa_prot",
    "special  CBF70510           embl_tpa_prot",
    "special  CBF70512           embl_tpa_prot",
    "special  CBF70514           embl_tpa_prot",
    "special  CBF70516           embl_tpa_prot",
    "special  CBF70518           embl_tpa_prot",
    "special  CBF70520           embl_tpa_prot",
    "special  CBF70522           embl_tpa_prot",
    "special  CBF70524           embl_tpa_prot",
    "special  CBF70526           embl_tpa_prot",
    "special  CBF70528-CBF70529  embl_tpa_prot",
    "special  CBF70531           embl_tpa_prot",
    "special  CBF70533           embl_tpa_prot",
    "special  CBF70535           embl_tpa_prot",
    "special  CBF70537           embl_tpa_prot",
    "special  CBF70539-CBF70540  embl_tpa_prot",
    "special  CBF70542           embl_tpa_prot",
    "special  CBF70544           embl_tpa_prot",
    "special  CBF70546           embl_tpa_prot",
    "special  CBF70548           embl_tpa_prot",
    "special  CBF70550           embl_tpa_prot",
    "special  CBF70552           embl_tpa_prot",
    "special  CBF70554           embl_tpa_prot",
    "special  CBF70556-CBF70557  embl_tpa_prot",
    "special  CBF70559           embl_tpa_prot",
    "special  CBF70561           embl_tpa_prot",
    "special  CBF70563           embl_tpa_prot",
    "special  CBF70565           embl_tpa_prot",
    "special  CBF70567           embl_tpa_prot",
    "special  CBF70569           embl_tpa_prot",
    "special  CBF70571           embl_tpa_prot",
    "special  CBF70573           embl_tpa_prot",
    "special  CBF70575           embl_tpa_prot",
    "special  CBF70577           embl_tpa_prot",
    "special  CBF70579           embl_tpa_prot",
    "special  CBF70581           embl_tpa_prot",
    "special  CBF70583-CBF70584  embl_tpa_prot",
    "special  CBF70586           embl_tpa_prot",
    "special  CBF70588           embl_tpa_prot",
    "special  CBF70590           embl_tpa_prot",
    "special  CBF70592           embl_tpa_prot",
    "special  CBF70594           embl_tpa_prot",
    "special  CBF70596-CBF70597  embl_tpa_prot",
    "special  CBF70599           embl_tpa_prot",
    "special  CBF70601           embl_tpa_prot",
    "special  CBF70603           embl_tpa_prot",
    "special  CBF70605           embl_tpa_prot",
    "special  CBF70607           embl_tpa_prot",
    "special  CBF70609           embl_tpa_prot",
    "special  CBF70611-CBF70612  embl_tpa_prot",
    "special  CBF70614           embl_tpa_prot",
    "special  CBF70616           embl_tpa_prot",
    "special  CBF70618           embl_tpa_prot",
    "special  CBF70620           embl_tpa_prot",
    "special  CBF70622           embl_tpa_prot",
    "special  CBF70624           embl_tpa_prot",
    "special  CBF70626           embl_tpa_prot",
    "special  CBF70628-CBF70629  embl_tpa_prot",
    "special  CBF70631           embl_tpa_prot",
    "special  CBF70633           embl_tpa_prot",
    "special  CBF70635           embl_tpa_prot",
    "special  CBF70637           embl_tpa_prot",
    "special  CBF70639-CBF70640  embl_tpa_prot",
    "special  CBF70642           embl_tpa_prot",
    "special  CBF70644           embl_tpa_prot",
    "special  CBF70646-CBF70647  embl_tpa_prot",
    "special  CBF70649-CBF70650  embl_tpa_prot",
    "special  CBF70652           embl_tpa_prot",
    "special  CBF70654           embl_tpa_prot",
    "special  CBF70656-CBF70657  embl_tpa_prot",
    "special  CBF70659           embl_tpa_prot",
    "special  CBF70661           embl_tpa_prot",
    "special  CBF70663           embl_tpa_prot",
    "special  CBF70665-CBF70666  embl_tpa_prot",
    "special  CBF70668           embl_tpa_prot",
    "special  CBF70670           embl_tpa_prot",
    "special  CBF70672           embl_tpa_prot",
    "special  CBF70674-CBF70675  embl_tpa_prot",
    "special  CBF70677           embl_tpa_prot",
    "special  CBF70679           embl_tpa_prot",
    "special  CBF70681           embl_tpa_prot",
    "special  CBF70683-CBF70684  embl_tpa_prot",
    "special  CBF70686           embl_tpa_prot",
    "special  CBF70688           embl_tpa_prot",
    "special  CBF70690           embl_tpa_prot",
    "special  CBF70692           embl_tpa_prot",
    "special  CBF70694           embl_tpa_prot",
    "special  CBF70696           embl_tpa_prot",
    "special  CBF70698           embl_tpa_prot",
    "special  CBF70700-CBF70701  embl_tpa_prot",
    "special  CBF70703           embl_tpa_prot",
    "special  CBF70705           embl_tpa_prot",
    "special  CBF70707           embl_tpa_prot",
    "special  CBF70709           embl_tpa_prot",
    "special  CBF70711-CBF70712  embl_tpa_prot",
    "special  CBF70714           embl_tpa_prot",
    "special  CBF70716           embl_tpa_prot",
    "special  CBF70718           embl_tpa_prot",
    "special  CBF70720           embl_tpa_prot",
    "special  CBF70722           embl_tpa_prot",
    "special  CBF70724           embl_tpa_prot",
    "special  CBF70726           embl_tpa_prot",
    "special  CBF70728           embl_tpa_prot",
    "special  CBF70730           embl_tpa_prot",
    "special  CBF70732-CBF70733  embl_tpa_prot",
    "special  CBF70735           embl_tpa_prot",
    "special  CBF70737           embl_tpa_prot",
    "special  CBF70739           embl_tpa_prot",
    "special  CBF70741           embl_tpa_prot",
    "special  CBF70743           embl_tpa_prot",
    "special  CBF70745           embl_tpa_prot",
    "special  CBF70747           embl_tpa_prot",
    "special  CBF70749           embl_tpa_prot",
    "special  CBF70751           embl_tpa_prot",
    "special  CBF70753           embl_tpa_prot",
    "special  CBF70755-CBF70756  embl_tpa_prot",
    "special  CBF70758           embl_tpa_prot",
    "special  CBF70760           embl_tpa_prot",
    "special  CBF70762           embl_tpa_prot",
    "special  CBF70764           embl_tpa_prot",
    "special  CBF70766           embl_tpa_prot",
    "special  CBF70770           embl_tpa_prot",
    "special  CBF70772           embl_tpa_prot",
    "special  CBF70774           embl_tpa_prot",
    "special  CBF70776-CBF70777  embl_tpa_prot",
    "special  CBF70779           embl_tpa_prot",
    "special  CBF70781           embl_tpa_prot",
    "special  CBF70783           embl_tpa_prot",
    "special  CBF70785           embl_tpa_prot",
    "special  CBF70787           embl_tpa_prot",
    "special  CBF70789           embl_tpa_prot",
    "special  CBF70791           embl_tpa_prot",
    "special  CBF70793           embl_tpa_prot",
    "special  CBF70795           embl_tpa_prot",
    "special  CBF70797-CBF70798  embl_tpa_prot",
    "special  CBF70800           embl_tpa_prot",
    "special  CBF70802           embl_tpa_prot",
    "special  CBF70804           embl_tpa_prot",
    "special  CBF70806           embl_tpa_prot",
    "special  CBF70808           embl_tpa_prot",
    "special  CBF70810           embl_tpa_prot",
    "special  CBF70812           embl_tpa_prot",
    "special  CBF70814-CBF70815  embl_tpa_prot",
    "special  CBF70817           embl_tpa_prot",
    "special  CBF70819           embl_tpa_prot",
    "special  CBF70821           embl_tpa_prot",
    "special  CBF70823           embl_tpa_prot",
    "special  CBF70825           embl_tpa_prot",
    "special  CBF70827           embl_tpa_prot",
    "special  CBF70829           embl_tpa_prot",
    "special  CBF70831           embl_tpa_prot",
    "special  CBF70833           embl_tpa_prot",
    "special  CBF70835           embl_tpa_prot",
    "special  CBF70837           embl_tpa_prot",
    "special  CBF70839           embl_tpa_prot",
    "special  CBF70841           embl_tpa_prot",
    "special  CBF70843           embl_tpa_prot",
    "special  CBF70845-CBF70846  embl_tpa_prot",
    "special  CBF70848           embl_tpa_prot",
    "special  CBF70850           embl_tpa_prot",
    "special  CBF70852           embl_tpa_prot",
    "special  CBF70854           embl_tpa_prot",
    "special  CBF70856           embl_tpa_prot",
    "special  CBF70858-CBF70859  embl_tpa_prot",
    "special  CBF70861           embl_tpa_prot",
    "special  CBF70863           embl_tpa_prot",
    "special  CBF70865           embl_tpa_prot",
    "special  CBF70867           embl_tpa_prot",
    "special  CBF70869-CBF70870  embl_tpa_prot",
    "special  CBF70872           embl_tpa_prot",
    "special  CBF70874           embl_tpa_prot",
    "special  CBF70876           embl_tpa_prot",
    "special  CBF70878           embl_tpa_prot",
    "special  CBF70880           embl_tpa_prot",
    "special  CBF70882           embl_tpa_prot",
    "special  CBF70884           embl_tpa_prot",
    "special  CBF70886-CBF70887  embl_tpa_prot",
    "special  CBF70889           embl_tpa_prot",
    "special  CBF70891           embl_tpa_prot",
    "special  CBF70893           embl_tpa_prot",
    "special  CBF70895           embl_tpa_prot",
    "special  CBF70897           embl_tpa_prot",
    "special  CBF70899           embl_tpa_prot",
    "special  CBF70901           embl_tpa_prot",
    "special  CBF70903           embl_tpa_prot",
    "special  CBF70905           embl_tpa_prot",
    "special  CBF70907-CBF70908  embl_tpa_prot",
    "special  CBF70910           embl_tpa_prot",
    "special  CBF70912           embl_tpa_prot",
    "special  CBF70914           embl_tpa_prot",
    "special  CBF70916           embl_tpa_prot",
    "special  CBF70918           embl_tpa_prot",
    "special  CBF70920-CBF70921  embl_tpa_prot",
    "special  CBF70923           embl_tpa_prot",
    "special  CBF70925           embl_tpa_prot",
    "special  CBF70927           embl_tpa_prot",
    "special  CBF70929           embl_tpa_prot",
    "special  CBF70931           embl_tpa_prot",
    "special  CBF70933           embl_tpa_prot",
    "special  CBF70935           embl_tpa_prot",
    "special  CBF70937           embl_tpa_prot",
    "special  CBF70939           embl_tpa_prot",
    "special  CBF70941           embl_tpa_prot",
    "special  CBF70943           embl_tpa_prot",
    "special  CBF70945-CBF70946  embl_tpa_prot",
    "special  CBF70948           embl_tpa_prot",
    "special  CBF70950           embl_tpa_prot",
    "special  CBF70952           embl_tpa_prot",
    "special  CBF70954           embl_tpa_prot",
    "special  CBF70956           embl_tpa_prot",
    "special  CBF70958           embl_tpa_prot",
    "special  CBF70960           embl_tpa_prot",
    "special  CBF70962           embl_tpa_prot",
    "special  CBF70964           embl_tpa_prot",
    "special  CBF70966           embl_tpa_prot",
    "special  CBF70968           embl_tpa_prot",
    "special  CBF70970           embl_tpa_prot",
    "special  CBF70972           embl_tpa_prot",
    "special  CBF70974           embl_tpa_prot",
    "special  CBF70976-CBF70977  embl_tpa_prot",
    "special  CBF70979           embl_tpa_prot",
    "special  CBF70981           embl_tpa_prot",
    "special  CBF70983           embl_tpa_prot",
    "special  CBF70985           embl_tpa_prot",
    "special  CBF70987           embl_tpa_prot",
    "special  CBF70989           embl_tpa_prot",
    "special  CBF70991           embl_tpa_prot",
    "special  CBF70993-CBF70994  embl_tpa_prot",
    "special  CBF70996           embl_tpa_prot",
    "special  CBF70998           embl_tpa_prot",
    "special  CBF71000           embl_tpa_prot",
    "special  CBF71002           embl_tpa_prot",
    "special  CBF71004           embl_tpa_prot",
    "special  CBF71006-CBF71007  embl_tpa_prot",
    "special  CBF71009           embl_tpa_prot",
    "special  CBF71011           embl_tpa_prot",
    "special  CBF71013           embl_tpa_prot",
    "special  CBF71015           embl_tpa_prot",
    "special  CBF71017           embl_tpa_prot",
    "special  CBF71019           embl_tpa_prot",
    "special  CBF71021           embl_tpa_prot",
    "special  CBF71023           embl_tpa_prot",
    "special  CBF71025           embl_tpa_prot",
    "special  CBF71027           embl_tpa_prot",
    "special  CBF71029           embl_tpa_prot",
    "special  CBF71031-CBF71032  embl_tpa_prot",
    "special  CBF71034           embl_tpa_prot",
    "special  CBF71036           embl_tpa_prot",
    "special  CBF71038           embl_tpa_prot",
    "special  CBF71040-CBF71041  embl_tpa_prot",
    "special  CBF71043           embl_tpa_prot",
    "special  CBF71045           embl_tpa_prot",
    "special  CBF71047           embl_tpa_prot",
    "special  CBF71049           embl_tpa_prot",
    "special  CBF71051           embl_tpa_prot",
    "special  CBF71053           embl_tpa_prot",
    "special  CBF71055           embl_tpa_prot",
    "special  CBF71057-CBF71058  embl_tpa_prot",
    "special  CBF71060           embl_tpa_prot",
    "special  CBF71062           embl_tpa_prot",
    "special  CBF71064           embl_tpa_prot",
    "special  CBF71066           embl_tpa_prot",
    "special  CBF71068           embl_tpa_prot",
    "special  CBF71070-CBF71071  embl_tpa_prot",
    "special  CBF71073           embl_tpa_prot",
    "special  CBF71075           embl_tpa_prot",
    "special  CBF71077           embl_tpa_prot",
    "special  CBF71079           embl_tpa_prot",
    "special  CBF71081           embl_tpa_prot",
    "special  CBF71083           embl_tpa_prot",
    "special  CBF71085           embl_tpa_prot",
    "special  CBF71087           embl_tpa_prot",
    "special  CBF71089-CBF71090  embl_tpa_prot",
    "special  CBF71092           embl_tpa_prot",
    "special  CBF71094           embl_tpa_prot",
    "special  CBF71096           embl_tpa_prot",
    "special  CBF71098           embl_tpa_prot",
    "special  CBF71100           embl_tpa_prot",
    "special  CBF71102           embl_tpa_prot",
    "special  CBF71104           embl_tpa_prot",
    "special  CBF71106           embl_tpa_prot",
    "special  CBF71108           embl_tpa_prot",
    "special  CBF71110           embl_tpa_prot",
    "special  CBF71112           embl_tpa_prot",
    "special  CBF71114           embl_tpa_prot",
    "special  CBF71116-CBF71117  embl_tpa_prot",
    "special  CBF71119           embl_tpa_prot",
    "special  CBF71121           embl_tpa_prot",
    "special  CBF71123           embl_tpa_prot",
    "special  CBF71125           embl_tpa_prot",
    "special  CBF71127           embl_tpa_prot",
    "special  CBF71129           embl_tpa_prot",
    "special  CBF71131           embl_tpa_prot",
    "special  CBF71133           embl_tpa_prot",
    "special  CBF71135           embl_tpa_prot",
    "special  CBF71137-CBF71138  embl_tpa_prot",
    "special  CBF71140           embl_tpa_prot",
    "special  CBF71142           embl_tpa_prot",
    "special  CBF71144           embl_tpa_prot",
    "special  CBF71146           embl_tpa_prot",
    "special  CBF71148           embl_tpa_prot",
    "special  CBF71150           embl_tpa_prot",
    "special  CBF71152           embl_tpa_prot",
    "special  CBF71154           embl_tpa_prot",
    "special  CBF71156-CBF71157  embl_tpa_prot",
    "special  CBF71159           embl_tpa_prot",
    "special  CBF71161           embl_tpa_prot",
    "special  CBF71163           embl_tpa_prot",
    "special  CBF71165           embl_tpa_prot",
    "special  CBF71167           embl_tpa_prot",
    "special  CBF71169           embl_tpa_prot",
    "special  CBF71171-CBF71172  embl_tpa_prot",
    "special  CBF71174           embl_tpa_prot",
    "special  CBF71176           embl_tpa_prot",
    "special  CBF71178           embl_tpa_prot",
    "special  CBF71180           embl_tpa_prot",
    "special  CBF71182           embl_tpa_prot",
    "special  CBF71184           embl_tpa_prot",
    "special  CBF71186           embl_tpa_prot",
    "special  CBF71188           embl_tpa_prot",
    "special  CBF71190           embl_tpa_prot",
    "special  CBF71192           embl_tpa_prot",
    "special  CBF71194           embl_tpa_prot",
    "special  CBF71196           embl_tpa_prot",
    "special  CBF71198           embl_tpa_prot",
    "special  CBF71200-CBF71201  embl_tpa_prot",
    "special  CBF71203           embl_tpa_prot",
    "special  CBF71205           embl_tpa_prot",
    "special  CBF71207           embl_tpa_prot",
    "special  CBF71209           embl_tpa_prot",
    "special  CBF71211           embl_tpa_prot",
    "special  CBF71213           embl_tpa_prot",
    "special  CBF71215           embl_tpa_prot",
    "special  CBF71217-CBF71218  embl_tpa_prot",
    "special  CBF71220           embl_tpa_prot",
    "special  CBF71222           embl_tpa_prot",
    "special  CBF71224           embl_tpa_prot",
    "special  CBF71226           embl_tpa_prot",
    "special  CBF71228           embl_tpa_prot",
    "special  CBF71230           embl_tpa_prot",
    "special  CBF71232           embl_tpa_prot",
    "special  CBF71234           embl_tpa_prot",
    "special  CBF71236-CBF71237  embl_tpa_prot",
    "special  CBF71239           embl_tpa_prot",
    "special  CBF71241           embl_tpa_prot",
    "special  CBF71243           embl_tpa_prot",
    "special  CBF71245           embl_tpa_prot",
    "special  CBF71247           embl_tpa_prot",
    "special  CBF71249           embl_tpa_prot",
    "special  CBF71251           embl_tpa_prot",
    "special  CBF71253-CBF71254  embl_tpa_prot",
    "special  CBF71257-CBF71258  embl_tpa_prot",
    "special  CBF71260           embl_tpa_prot",
    "special  CBF71262           embl_tpa_prot",
    "special  CBF71264           embl_tpa_prot",
    "special  CBF71266           embl_tpa_prot",
    "special  CBF71268           embl_tpa_prot",
    "special  CBF71270-CBF71271  embl_tpa_prot",
    "special  CBF71273           embl_tpa_prot",
    "special  CBF71275           embl_tpa_prot",
    "special  CBF71277           embl_tpa_prot",
    "special  CBF71279           embl_tpa_prot",
    "special  CBF71281           embl_tpa_prot",
    "special  CBF71283           embl_tpa_prot",
    "special  CBF71285           embl_tpa_prot",
    "special  CBF71287           embl_tpa_prot",
    "special  CBF71289           embl_tpa_prot",
    "special  CBF71291           embl_tpa_prot",
    "special  CBF71293           embl_tpa_prot",
    "special  CBF71295-CBF71296  embl_tpa_prot",
    "special  CBF71298           embl_tpa_prot",
    "special  CBF71300           embl_tpa_prot",
    "special  CBF71302           embl_tpa_prot",
    "special  CBF71304           embl_tpa_prot",
    "special  CBF71306           embl_tpa_prot",
    "special  CBF71308           embl_tpa_prot",
    "special  CBF71310           embl_tpa_prot",
    "special  CBF71312-CBF71313  embl_tpa_prot",
    "special  CBF71315           embl_tpa_prot",
    "special  CBF71317           embl_tpa_prot",
    "special  CBF71319           embl_tpa_prot",
    "special  CBF71321           embl_tpa_prot",
    "special  CBF71323           embl_tpa_prot",
    "special  CBF71325           embl_tpa_prot",
    "special  CBF71327           embl_tpa_prot",
    "special  CBF71329           embl_tpa_prot",
    "special  CBF71331           embl_tpa_prot",
    "special  CBF71333           embl_tpa_prot",
    "special  CBF71335           embl_tpa_prot",
    "special  CBF71337           embl_tpa_prot",
    "special  CBF71339           embl_tpa_prot",
    "special  CBF71341           embl_tpa_prot",
    "special  CBF71343-CBF71344  embl_tpa_prot",
    "special  CBF71346           embl_tpa_prot",
    "special  CBF71348           embl_tpa_prot",
    "special  CBF71350           embl_tpa_prot",
    "special  CBF71352           embl_tpa_prot",
    "special  CBF71354           embl_tpa_prot",
    "special  CBF71356-CBF71357  embl_tpa_prot",
    "special  CBF71359           embl_tpa_prot",
    "special  CBF71361           embl_tpa_prot",
    "special  CBF71363           embl_tpa_prot",
    "special  CBF71365           embl_tpa_prot",
    "special  CBF71367           embl_tpa_prot",
    "special  CBF71369           embl_tpa_prot",
    "special  CBF71371           embl_tpa_prot",
    "special  CBF71373-CBF71374  embl_tpa_prot",
    "special  CBF71376           embl_tpa_prot",
    "special  CBF71378           embl_tpa_prot",
    "special  CBF71380           embl_tpa_prot",
    "special  CBF71382           embl_tpa_prot",
    "special  CBF71384           embl_tpa_prot",
    "special  CBF71386           embl_tpa_prot",
    "special  CBF71388           embl_tpa_prot",
    "special  CBF71390           embl_tpa_prot",
    "special  CBF71392-CBF71393  embl_tpa_prot",
    "special  CBF71395           embl_tpa_prot",
    "special  CBF71397           embl_tpa_prot",
    "special  CBF71399           embl_tpa_prot",
    "special  CBF71401           embl_tpa_prot",
    "special  CBF71403           embl_tpa_prot",
    "special  CBF71405           embl_tpa_prot",
    "special  CBF71407           embl_tpa_prot",
    "special  CBF71409           embl_tpa_prot",
    "special  CBF71411           embl_tpa_prot",
    "special  CBF71413           embl_tpa_prot",
    "special  CBF71415-CBF71416  embl_tpa_prot",
    "special  CBF71418           embl_tpa_prot",
    "special  CBF71420           embl_tpa_prot",
    "special  CBF71422           embl_tpa_prot",
    "special  CBF71424           embl_tpa_prot",
    "special  CBF71426           embl_tpa_prot",
    "special  CBF71428           embl_tpa_prot",
    "special  CBF71430           embl_tpa_prot",
    "special  CBF71432           embl_tpa_prot",
    "special  CBF71434           embl_tpa_prot",
    "special  CBF71436           embl_tpa_prot",
    "special  CBF71438           embl_tpa_prot",
    "special  CBF71440           embl_tpa_prot",
    "special  CBF71442           embl_tpa_prot",
    "special  CBF71444-CBF71445  embl_tpa_prot",
    "special  CBF71447           embl_tpa_prot",
    "special  CBF71449           embl_tpa_prot",
    "special  CBF71451           embl_tpa_prot",
    "special  CBF71453           embl_tpa_prot",
    "special  CBF71455           embl_tpa_prot",
    "special  CBF71457           embl_tpa_prot",
    "special  CBF71459           embl_tpa_prot",
    "special  CBF71461           embl_tpa_prot",
    "special  CBF71463           embl_tpa_prot",
    "special  CBF71465           embl_tpa_prot",
    "special  CBF71467           embl_tpa_prot",
    "special  CBF71469-CBF71470  embl_tpa_prot",
    "special  CBF71472           embl_tpa_prot",
    "special  CBF71474           embl_tpa_prot",
    "special  CBF71476           embl_tpa_prot",
    "special  CBF71478           embl_tpa_prot",
    "special  CBF71480           embl_tpa_prot",
    "special  CBF71482           embl_tpa_prot",
    "special  CBF71484           embl_tpa_prot",
    "special  CBF71486-CBF71487  embl_tpa_prot",
    "special  CBF71489           embl_tpa_prot",
    "special  CBF71491           embl_tpa_prot",
    "special  CBF71493           embl_tpa_prot",
    "special  CBF71495           embl_tpa_prot",
    "special  CBF71497           embl_tpa_prot",
    "special  CBF71499           embl_tpa_prot",
    "special  CBF71501           embl_tpa_prot",
    "special  CBF71503           embl_tpa_prot",
    "special  CBF71505           embl_tpa_prot",
    "special  CBF71507           embl_tpa_prot",
    "special  CBF71509           embl_tpa_prot",
    "special  CBF71511           embl_tpa_prot",
    "special  CBF71513           embl_tpa_prot",
    "special  CBF71516-CBF71517  embl_tpa_prot",
    "special  CBF71519           embl_tpa_prot",
    "special  CBF71521           embl_tpa_prot",
    "special  CBF71523           embl_tpa_prot",
    "special  CBF71525           embl_tpa_prot",
    "special  CBF71527           embl_tpa_prot",
    "special  CBF71529           embl_tpa_prot",
    "special  CBF71531           embl_tpa_prot",
    "special  CBF71533           embl_tpa_prot",
    "special  CBF71535           embl_tpa_prot",
    "special  CBF71537           embl_tpa_prot",
    "special  CBF71539           embl_tpa_prot",
    "special  CBF71541           embl_tpa_prot",
    "special  CBF71543           embl_tpa_prot",
    "special  CBF71545           embl_tpa_prot",
    "special  CBF71547           embl_tpa_prot",
    "special  CBF71549           embl_tpa_prot",
    "special  CBF71551-CBF71552  embl_tpa_prot",
    "special  CBF71554           embl_tpa_prot",
    "special  CBF71556           embl_tpa_prot",
    "special  CBF71558           embl_tpa_prot",
    "special  CBF71560           embl_tpa_prot",
    "special  CBF71562           embl_tpa_prot",
    "special  CBF71564           embl_tpa_prot",
    "special  CBF71566           embl_tpa_prot",
    "special  CBF71568           embl_tpa_prot",
    "special  CBF71570           embl_tpa_prot",
    "special  CBF71572           embl_tpa_prot",
    "special  CBF71574           embl_tpa_prot",
    "special  CBF71576           embl_tpa_prot",
    "special  CBF71578           embl_tpa_prot",
    "special  CBF71580           embl_tpa_prot",
    "special  CBF71582           embl_tpa_prot",
    "special  CBF71584-CBF71585  embl_tpa_prot",
    "special  CBF71587           embl_tpa_prot",
    "special  CBF71589           embl_tpa_prot",
    "special  CBF71591           embl_tpa_prot",
    "special  CBF71593           embl_tpa_prot",
    "special  CBF71595           embl_tpa_prot",
    "special  CBF71597           embl_tpa_prot",
    "special  CBF71599           embl_tpa_prot",
    "special  CBF71601           embl_tpa_prot",
    "special  CBF71603           embl_tpa_prot",
    "special  CBF71605           embl_tpa_prot",
    "special  CBF71607           embl_tpa_prot",
    "special  CBF71609           embl_tpa_prot",
    "special  CBF71611           embl_tpa_prot",
    "special  CBF71613           embl_tpa_prot",
    "special  CBF71615           embl_tpa_prot",
    "special  CBF71617           embl_tpa_prot",
    "special  CBF71619-CBF71620  embl_tpa_prot",
    "special  CBF71622           embl_tpa_prot",
    "special  CBF71624           embl_tpa_prot",
    "special  CBF71626           embl_tpa_prot",
    "special  CBF71628           embl_tpa_prot",
    "special  CBF71630           embl_tpa_prot",
    "special  CBF71632           embl_tpa_prot",
    "special  CBF71634           embl_tpa_prot",
    "special  CBF71636           embl_tpa_prot",
    "special  CBF71638           embl_tpa_prot",
    "special  CBF71640           embl_tpa_prot",
    "special  CBF71642           embl_tpa_prot",
    "special  CBF71644           embl_tpa_prot",
    "special  CBF71646           embl_tpa_prot",
    "special  CBF71648           embl_tpa_prot",
    "special  CBF71650-CBF71651  embl_tpa_prot",
    "special  CBF71653           embl_tpa_prot",
    "special  CBF71655           embl_tpa_prot",
    "special  CBF71657           embl_tpa_prot",
    "special  CBF71659           embl_tpa_prot",
    "special  CBF71661           embl_tpa_prot",
    "special  CBF71663           embl_tpa_prot",
    "special  CBF71665-CBF71666  embl_tpa_prot",
    "special  CBF71668           embl_tpa_prot",
    "special  CBF71670-CBF71671  embl_tpa_prot",
    "special  CBF71673           embl_tpa_prot",
    "special  CBF71675           embl_tpa_prot",
    "special  CBF71677           embl_tpa_prot",
    "special  CBF71679           embl_tpa_prot",
    "special  CBF71681           embl_tpa_prot",
    "special  CBF71683           embl_tpa_prot",
    "special  CBF71685           embl_tpa_prot",
    "special  CBF71687-CBF71688  embl_tpa_prot",
    "special  CBF71690           embl_tpa_prot",
    "special  CBF71692           embl_tpa_prot",
    "special  CBF71694           embl_tpa_prot",
    "special  CBF71696           embl_tpa_prot",
    "special  CBF71698           embl_tpa_prot",
    "special  CBF71700           embl_tpa_prot",
    "special  CBF71702-CBF71703  embl_tpa_prot",
    "special  CBF71706           embl_tpa_prot",
    "special  CBF71708           embl_tpa_prot",
    "special  CBF71710           embl_tpa_prot",
    "special  CBF71712           embl_tpa_prot",
    "special  CBF71714           embl_tpa_prot",
    "special  CBF71716           embl_tpa_prot",
    "special  CBF71718           embl_tpa_prot",
    "special  CBF71720           embl_tpa_prot",
    "special  CBF71722           embl_tpa_prot",
    "special  CBF71724           embl_tpa_prot",
    "special  CBF71727           embl_tpa_prot",
    "special  CBF71729           embl_tpa_prot",
    "special  CBF71731           embl_tpa_prot",
    "special  CBF71733           embl_tpa_prot",
    "special  CBF71735           embl_tpa_prot",
    "special  CBF71737           embl_tpa_prot",
    "special  CBF71739           embl_tpa_prot",
    "special  CBF71741           embl_tpa_prot",
    "special  CBF71743           embl_tpa_prot",
    "special  CBF71745           embl_tpa_prot",
    "special  CBF71747           embl_tpa_prot",
    "special  CBF71749-CBF71750  embl_tpa_prot",
    "special  CBF71752           embl_tpa_prot",
    "special  CBF71754           embl_tpa_prot",
    "special  CBF71756           embl_tpa_prot",
    "special  CBF71758           embl_tpa_prot",
    "special  CBF71760           embl_tpa_prot",
    "special  CBF71762           embl_tpa_prot",
    "special  CBF71764           embl_tpa_prot",
    "special  CBF71766           embl_tpa_prot",
    "special  CBF71768           embl_tpa_prot",
    "special  CBF71770           embl_tpa_prot",
    "special  CBF71772-CBF71773  embl_tpa_prot",
    "special  CBF71775           embl_tpa_prot",
    "special  CBF71777           embl_tpa_prot",
    "special  CBF71779           embl_tpa_prot",
    "special  CBF71781           embl_tpa_prot",
    "special  CBF71783           embl_tpa_prot",
    "special  CBF71785           embl_tpa_prot",
    "special  CBF71787-CBF71788  embl_tpa_prot",
    "special  CBF71790           embl_tpa_prot",
    "special  CBF71792-CBF71793  embl_tpa_prot",
    "special  CBF71795           embl_tpa_prot",
    "special  CBF71797           embl_tpa_prot",
    "special  CBF71799           embl_tpa_prot",
    "special  CBF71801           embl_tpa_prot",
    "special  CBF71803           embl_tpa_prot",
    "special  CBF71805           embl_tpa_prot",
    "special  CBF71807           embl_tpa_prot",
    "special  CBF71809           embl_tpa_prot",
    "special  CBF71811           embl_tpa_prot",
    "special  CBF71813           embl_tpa_prot",
    "special  CBF71815           embl_tpa_prot",
    "special  CBF71817           embl_tpa_prot",
    "special  CBF71819           embl_tpa_prot",
    "special  CBF71821           embl_tpa_prot",
    "special  CBF71823           embl_tpa_prot",
    "special  CBF71825           embl_tpa_prot",
    "special  CBF71827           embl_tpa_prot",
    "special  CBF71829-CBF71830  embl_tpa_prot",
    "special  CBF71832           embl_tpa_prot",
    "special  CBF71834           embl_tpa_prot",
    "special  CBF71836-CBF71837  embl_tpa_prot",
    "special  CBF71839           embl_tpa_prot",
    "special  CBF71841           embl_tpa_prot",
    "special  CBF71843-CBF71844  embl_tpa_prot",
    "special  CBF71846           embl_tpa_prot",
    "special  CBF71848           embl_tpa_prot",
    "special  CBF71850           embl_tpa_prot",
    "special  CBF71852           embl_tpa_prot",
    "special  CBF71854           embl_tpa_prot",
    "special  CBF71856           embl_tpa_prot",
    "special  CBF71858           embl_tpa_prot",
    "special  CBF71860           embl_tpa_prot",
    "special  CBF71862-CBF71863  embl_tpa_prot",
    "special  CBF73380           embl_tpa_prot",
    "special  CBF73382           embl_tpa_prot",
    "special  CBF73384           embl_tpa_prot",
    "special  CBF73386           embl_tpa_prot",
    "special  CBF73388           embl_tpa_prot",
    "special  CBF73390           embl_tpa_prot",
    "special  CBF73392           embl_tpa_prot",
    "special  CBF73394           embl_tpa_prot",
    "special  CBF73396-CBF73397  embl_tpa_prot",
    "special  CBF73399           embl_tpa_prot",
    "special  CBF73401           embl_tpa_prot",
    "special  CBF73403           embl_tpa_prot",
    "special  CBF73405           embl_tpa_prot",
    "special  CBF73407           embl_tpa_prot",
    "special  CBF73409           embl_tpa_prot",
    "special  CBF73411           embl_tpa_prot",
    "special  CBF73413           embl_tpa_prot",
    "special  CBF73415           embl_tpa_prot",
    "special  CBF73417           embl_tpa_prot",
    "special  CBF73419           embl_tpa_prot",
    "special  CBF73421           embl_tpa_prot",
    "special  CBF73423-CBF73424  embl_tpa_prot",
    "special  CBF73426           embl_tpa_prot",
    "special  CBF73428           embl_tpa_prot",
    "special  CBF73430-CBF73431  embl_tpa_prot",
    "special  CBF73433           embl_tpa_prot",
    "special  CBF73435-CBF73436  embl_tpa_prot",
    "special  CBF73438           embl_tpa_prot",
    "special  CBF73440-CBF73441  embl_tpa_prot",
    "special  CBF73444           embl_tpa_prot",
    "special  CBF73446-CBF73447  embl_tpa_prot",
    "special  CBF73449           embl_tpa_prot",
    "special  CBF73451           embl_tpa_prot",
    "special  CBF73453           embl_tpa_prot",
    "special  CBF73455           embl_tpa_prot",
    "special  CBF73457           embl_tpa_prot",
    "special  CBF73459           embl_tpa_prot",
    "special  CBF73461           embl_tpa_prot",
    "special  CBF73463           embl_tpa_prot",
    "special  CBF73465           embl_tpa_prot",
    "special  CBF73467           embl_tpa_prot",
    "special  CBF73469           embl_tpa_prot",
    "special  CBF73471           embl_tpa_prot",
    "special  CBF73473           embl_tpa_prot",
    "special  CBF73475           embl_tpa_prot",
    "special  CBF73477           embl_tpa_prot",
    "special  CBF73479-CBF73480  embl_tpa_prot",
    "special  CBF73482           embl_tpa_prot",
    "special  CBF73484           embl_tpa_prot",
    "special  CBF73486           embl_tpa_prot",
    "special  CBF73488           embl_tpa_prot",
    "special  CBF73490           embl_tpa_prot",
    "special  CBF73492           embl_tpa_prot",
    "special  CBF73494-CBF73495  embl_tpa_prot",
    "special  CBF73497           embl_tpa_prot",
    "special  CBF73499           embl_tpa_prot",
    "special  CBF73501           embl_tpa_prot",
    "special  CBF73503           embl_tpa_prot",
    "special  CBF73505           embl_tpa_prot",
    "special  CBF73507           embl_tpa_prot",
    "special  CBF73509           embl_tpa_prot",
    "special  CBF73511           embl_tpa_prot",
    "special  CBF73513-CBF73514  embl_tpa_prot",
    "special  CBF73516           embl_tpa_prot",
    "special  CBF73518           embl_tpa_prot",
    "special  CBF73520           embl_tpa_prot",
    "special  CBF73522           embl_tpa_prot",
    "special  CBF73524           embl_tpa_prot",
    "special  CBF73526           embl_tpa_prot",
    "special  CBF73528           embl_tpa_prot",
    "special  CBF73530           embl_tpa_prot",
    "special  CBF73532           embl_tpa_prot",
    "special  CBF73534-CBF73535  embl_tpa_prot",
    "special  CBF73537           embl_tpa_prot",
    "special  CBF73541           embl_tpa_prot",
    "special  CBF73543           embl_tpa_prot",
    "special  CBF73545           embl_tpa_prot",
    "special  CBF73547           embl_tpa_prot",
    "special  CBF73549           embl_tpa_prot",
    "special  CBF73551           embl_tpa_prot",
    "special  CBF73553           embl_tpa_prot",
    "special  CBF73555-CBF73556  embl_tpa_prot",
    "special  CBF73558           embl_tpa_prot",
    "special  CBF73560           embl_tpa_prot",
    "special  CBF73562           embl_tpa_prot",
    "special  CBF73564           embl_tpa_prot",
    "special  CBF73566           embl_tpa_prot",
    "special  CBF73568           embl_tpa_prot",
    "special  CBF73570           embl_tpa_prot",
    "special  CBF73572           embl_tpa_prot",
    "special  CBF73574           embl_tpa_prot",
    "special  CBF73576-CBF73577  embl_tpa_prot",
    "special  CBF73579           embl_tpa_prot",
    "special  CBF73581           embl_tpa_prot",
    "special  CBF73583-CBF73584  embl_tpa_prot",
    "special  CBF73586           embl_tpa_prot",
    "special  CBF73588           embl_tpa_prot",
    "special  CBF73590           embl_tpa_prot",
    "special  CBF73592           embl_tpa_prot",
    "special  CBF73594           embl_tpa_prot",
    "special  CBF73596-CBF73597  embl_tpa_prot",
    "special  CBF73599           embl_tpa_prot",
    "special  CBF73601           embl_tpa_prot",
    "special  CBF73603           embl_tpa_prot",
    "special  CBF73605           embl_tpa_prot",
    "special  CBF73607           embl_tpa_prot",
    "special  CBF73609           embl_tpa_prot",
    "special  CBF73611-CBF73612  embl_tpa_prot",
    "special  CBF73614           embl_tpa_prot",
    "special  CBF73616           embl_tpa_prot",
    "special  CBF73618           embl_tpa_prot",
    "special  CBF73620-CBF73621  embl_tpa_prot",
    "special  CBF73623           embl_tpa_prot",
    "special  CBF73625           embl_tpa_prot",
    "special  CBF73627           embl_tpa_prot",
    "special  CBF73629           embl_tpa_prot",
    "special  CBF73631           embl_tpa_prot",
    "special  CBF73633           embl_tpa_prot",
    "special  CBF73635           embl_tpa_prot",
    "special  CBF73637           embl_tpa_prot",
    "special  CBF73639           embl_tpa_prot",
    "special  CBF73641           embl_tpa_prot",
    "special  CBF73643-CBF73644  embl_tpa_prot",
    "special  CBF73646           embl_tpa_prot",
    "special  CBF73648           embl_tpa_prot",
    "special  CBF73650           embl_tpa_prot",
    "special  CBF73652           embl_tpa_prot",
    "special  CBF73654           embl_tpa_prot",
    "special  CBF73656           embl_tpa_prot",
    "special  CBF73658           embl_tpa_prot",
    "special  CBF73660           embl_tpa_prot",
    "special  CBF73662-CBF73663  embl_tpa_prot",
    "special  CBF73665           embl_tpa_prot",
    "special  CBF73667           embl_tpa_prot",
    "special  CBF73669           embl_tpa_prot",
    "special  CBF73671-CBF73672  embl_tpa_prot",
    "special  CBF73674           embl_tpa_prot",
    "special  CBF73676           embl_tpa_prot",
    "special  CBF73678           embl_tpa_prot",
    "special  CBF73680           embl_tpa_prot",
    "special  CBF73682           embl_tpa_prot",
    "special  CBF73684           embl_tpa_prot",
    "special  CBF73686           embl_tpa_prot",
    "special  CBF73688           embl_tpa_prot",
    "special  CBF73690           embl_tpa_prot",
    "special  CBF73692           embl_tpa_prot",
    "special  CBF73694           embl_tpa_prot",
    "special  CBF73696-CBF73697  embl_tpa_prot",
    "special  CBF73699           embl_tpa_prot",
    "special  CBF73701           embl_tpa_prot",
    "special  CBF73703           embl_tpa_prot",
    "special  CBF73705           embl_tpa_prot",
    "special  CBF73707           embl_tpa_prot",
    "special  CBF73709           embl_tpa_prot",
    "special  CBF73711           embl_tpa_prot",
    "special  CBF73713           embl_tpa_prot",
    "special  CBF73715           embl_tpa_prot",
    "special  CBF73717           embl_tpa_prot",
    "special  CBF73719-CBF73720  embl_tpa_prot",
    "special  CBF73722           embl_tpa_prot",
    "special  CBF73724           embl_tpa_prot",
    "special  CBF73726           embl_tpa_prot",
    "special  CBF73728           embl_tpa_prot",
    "special  CBF73730-CBF73731  embl_tpa_prot",
    "special  CBF73733           embl_tpa_prot",
    "special  CBF73735           embl_tpa_prot",
    "special  CBF73737           embl_tpa_prot",
    "special  CBF73739           embl_tpa_prot",
    "special  CBF73741           embl_tpa_prot",
    "special  CBF73743           embl_tpa_prot",
    "special  CBF73745           embl_tpa_prot",
    "special  CBF73747           embl_tpa_prot",
    "special  CBF73749           embl_tpa_prot",
    "special  CBF73751-CBF73752  embl_tpa_prot",
    "special  CBF73754           embl_tpa_prot",
    "special  CBF73756           embl_tpa_prot",
    "special  CBF73758           embl_tpa_prot",
    "special  CBF73760           embl_tpa_prot",
    "special  CBF73762           embl_tpa_prot",
    "special  CBF73764-CBF73765  embl_tpa_prot",
    "special  CBF73767           embl_tpa_prot",
    "special  CBF73769           embl_tpa_prot",
    "special  CBF73771           embl_tpa_prot",
    "special  CBF73773           embl_tpa_prot",
    "special  CBF73775           embl_tpa_prot",
    "special  CBF73777-CBF73778  embl_tpa_prot",
    "special  CBF73780           embl_tpa_prot",
    "special  CBF73782           embl_tpa_prot",
    "special  CBF73784           embl_tpa_prot",
    "special  CBF73786           embl_tpa_prot",
    "special  CBF73788           embl_tpa_prot",
    "special  CBF73790           embl_tpa_prot",
    "special  CBF73792-CBF73793  embl_tpa_prot",
    "special  CBF73795           embl_tpa_prot",
    "special  CBF73797           embl_tpa_prot",
    "special  CBF73799           embl_tpa_prot",
    "special  CBF73801           embl_tpa_prot",
    "special  CBF73803           embl_tpa_prot",
    "special  CBF73805-CBF73806  embl_tpa_prot",
    "special  CBF73808-CBF73809  embl_tpa_prot",
    "special  CBF73811           embl_tpa_prot",
    "special  CBF73813           embl_tpa_prot",
    "special  CBF73815           embl_tpa_prot",
    "special  CBF73817-CBF73818  embl_tpa_prot",
    "special  CBF73820           embl_tpa_prot",
    "special  CBF73822           embl_tpa_prot",
    "special  CBF73824           embl_tpa_prot",
    "special  CBF73826           embl_tpa_prot",
    "special  CBF73828           embl_tpa_prot",
    "special  CBF73830           embl_tpa_prot",
    "special  CBF73832-CBF73833  embl_tpa_prot",
    "special  CBF73835           embl_tpa_prot",
    "special  CBF73838-CBF73839  embl_tpa_prot",
    "special  CBF73841           embl_tpa_prot",
    "special  CBF73843           embl_tpa_prot",
    "special  CBF73845           embl_tpa_prot",
    "special  CBF73847-CBF73848  embl_tpa_prot",
    "special  CBF73850           embl_tpa_prot",
    "special  CBF73852           embl_tpa_prot",
    "special  CBF73854           embl_tpa_prot",
    "special  CBF73856           embl_tpa_prot",
    "special  CBF73858           embl_tpa_prot",
    "special  CBF73860           embl_tpa_prot",
    "special  CBF73862           embl_tpa_prot",
    "special  CBF73864           embl_tpa_prot",
    "special  CBF73866           embl_tpa_prot",
    "special  CBF73868           embl_tpa_prot",
    "special  CBF73870-CBF73871  embl_tpa_prot",
    "special  CBF73873           embl_tpa_prot",
    "special  CBF73875-CBF73876  embl_tpa_prot",
    "special  CBF73878           embl_tpa_prot",
    "special  CBF73880           embl_tpa_prot",
    "special  CBF73882           embl_tpa_prot",
    "special  CBF73884-CBF73885  embl_tpa_prot",
    "special  CBF73887-CBF73888  embl_tpa_prot",
    "special  CBF73890-CBF73891  embl_tpa_prot",
    "special  CBF73893           embl_tpa_prot",
    "special  CBF73895           embl_tpa_prot",
    "special  CBF73897-CBF73898  embl_tpa_prot",
    "special  CBF73900           embl_tpa_prot",
    "special  CBF73902           embl_tpa_prot",
    "special  CBF73904           embl_tpa_prot",
    "special  CBF73906           embl_tpa_prot",
    "special  CBF73908           embl_tpa_prot",
    "special  CBF73910-CBF73911  embl_tpa_prot",
    "special  CBF73913           embl_tpa_prot",
    "special  CBF73915           embl_tpa_prot",
    "special  CBF73917           embl_tpa_prot",
    "special  CBF73919           embl_tpa_prot",
    "special  CBF73921           embl_tpa_prot",
    "special  CBF73923-CBF73924  embl_tpa_prot",
    "special  CBF73926           embl_tpa_prot",
    "special  CBF73928           embl_tpa_prot",
    "special  CBF73930           embl_tpa_prot",
    "special  CBF73932-CBF73933  embl_tpa_prot",
    "special  CBF73935           embl_tpa_prot",
    "special  CBF73937-CBF73938  embl_tpa_prot",
    "special  CBF73940           embl_tpa_prot",
    "special  CBF73942           embl_tpa_prot",
    "special  CBF73944-CBF73945  embl_tpa_prot",
    "special  CBF73947           embl_tpa_prot",
    "special  CBF73949           embl_tpa_prot",
    "special  CBF73951-CBF73952  embl_tpa_prot",
    "special  CBF73954-CBF73955  embl_tpa_prot",
    "special  CBF73957           embl_tpa_prot",
    "special  CBF73959           embl_tpa_prot",
    "special  CBF73961           embl_tpa_prot",
    "special  CBF73963           embl_tpa_prot",
    "special  CBF73965           embl_tpa_prot",
    "special  CBF73967           embl_tpa_prot",
    "special  CBF73969           embl_tpa_prot",
    "special  CBF73971-CBF73972  embl_tpa_prot",
    "special  CBF73974           embl_tpa_prot",
    "special  CBF73976           embl_tpa_prot",
    "special  CBF73978-CBF73979  embl_tpa_prot",
    "special  CBF73981-CBF73982  embl_tpa_prot",
    "special  CBF73984           embl_tpa_prot",
    "special  CBF73986           embl_tpa_prot",
    "special  CBF73988-CBF73989  embl_tpa_prot",
    "special  CBF73991           embl_tpa_prot",
    "special  CBF73993           embl_tpa_prot",
    "special  CBF73995           embl_tpa_prot",
    "special  CBF73997           embl_tpa_prot",
    "special  CBF73999-CBF74000  embl_tpa_prot",
    "special  CBF74002           embl_tpa_prot",
    "special  CBF74004           embl_tpa_prot",
    "special  CBF74006           embl_tpa_prot",
    "special  CBF74008-CBF74009  embl_tpa_prot",
    "special  CBF74011           embl_tpa_prot",
    "special  CBF74013           embl_tpa_prot",
    "special  CBF74015           embl_tpa_prot",
    "special  CBF74017           embl_tpa_prot",
    "special  CBF74019           embl_tpa_prot",
    "special  CBF74021           embl_tpa_prot",
    "special  CBF74023           embl_tpa_prot",
    "special  CBF74025           embl_tpa_prot",
    "special  CBF74027-CBF74028  embl_tpa_prot",
    "special  CBF74030           embl_tpa_prot",
    "special  CBF74032           embl_tpa_prot",
    "special  CBF74034-CBF74035  embl_tpa_prot",
    "special  CBF74037           embl_tpa_prot",
    "special  CBF74039           embl_tpa_prot",
    "special  CBF74041           embl_tpa_prot",
    "special  CBF74043           embl_tpa_prot",
    "special  CBF74045-CBF74046  embl_tpa_prot",
    "special  CBF74048           embl_tpa_prot",
    "special  CBF74050           embl_tpa_prot",
    "special  CBF74052           embl_tpa_prot",
    "special  CBF74054           embl_tpa_prot",
    "special  CBF74056           embl_tpa_prot",
    "special  CBF74058           embl_tpa_prot",
    "special  CBF74060           embl_tpa_prot",
    "special  CBF74062           embl_tpa_prot",
    "special  CBF74064           embl_tpa_prot",
    "special  CBF74066           embl_tpa_prot",
    "special  CBF74068-CBF74069  embl_tpa_prot",
    "special  CBF74071           embl_tpa_prot",
    "special  CBF74073-CBF74074  embl_tpa_prot",
    "special  CBF74076           embl_tpa_prot",
    "special  CBF74078-CBF74079  embl_tpa_prot",
    "special  CBF74081           embl_tpa_prot",
    "special  CBF74083           embl_tpa_prot",
    "special  CBF74085           embl_tpa_prot",
    "special  CBF74087           embl_tpa_prot",
    "special  CBF74089           embl_tpa_prot",
    "special  CBF74091           embl_tpa_prot",
    "special  CBF74093           embl_tpa_prot",
    "special  CBF74095           embl_tpa_prot",
    "special  CBF74097-CBF74098  embl_tpa_prot",
    "special  CBF74100           embl_tpa_prot",
    "special  CBF74102           embl_tpa_prot",
    "special  CBF74104           embl_tpa_prot",
    "special  CBF74106           embl_tpa_prot",
    "special  CBF74108           embl_tpa_prot",
    "special  CBF74110           embl_tpa_prot",
    "special  CBF74112           embl_tpa_prot",
    "special  CBF74114           embl_tpa_prot",
    "special  CBF74116           embl_tpa_prot",
    "special  CBF74118           embl_tpa_prot",
    "special  CBF74120-CBF74121  embl_tpa_prot",
    "special  CBF74123           embl_tpa_prot",
    "special  CBF74125           embl_tpa_prot",
    "special  CBF74127           embl_tpa_prot",
    "special  CBF74129           embl_tpa_prot",
    "special  CBF74131           embl_tpa_prot",
    "special  CBF74133           embl_tpa_prot",
    "special  CBF74135-CBF74136  embl_tpa_prot",
    "special  CBF74138           embl_tpa_prot",
    "special  CBF74140           embl_tpa_prot",
    "special  CBF74142           embl_tpa_prot",
    "special  CBF74144           embl_tpa_prot",
    "special  CBF74146           embl_tpa_prot",
    "special  CBF74148-CBF74149  embl_tpa_prot",
    "special  CBF74151           embl_tpa_prot",
    "special  CBF74153           embl_tpa_prot",
    "special  CBF74155-CBF74156  embl_tpa_prot",
    "special  CBF74158           embl_tpa_prot",
    "special  CBF74160           embl_tpa_prot",
    "special  CBF74162-CBF74163  embl_tpa_prot",
    "special  CBF74165           embl_tpa_prot",
    "special  CBF74167           embl_tpa_prot",
    "special  CBF74169           embl_tpa_prot",
    "special  CBF74171           embl_tpa_prot",
    "special  CBF74173           embl_tpa_prot",
    "special  CBF74175           embl_tpa_prot",
    "special  CBF74177-CBF74178  embl_tpa_prot",
    "special  CBF74180           embl_tpa_prot",
    "special  CBF74182           embl_tpa_prot",
    "special  CBF74184           embl_tpa_prot",
    "special  CBF74186-CBF74187  embl_tpa_prot",
    "special  CBF74189           embl_tpa_prot",
    "special  CBF74191           embl_tpa_prot",
    "special  CBF74193           embl_tpa_prot",
    "special  CBF74195           embl_tpa_prot",
    "special  CBF74197           embl_tpa_prot",
    "special  CBF74199           embl_tpa_prot",
    "special  CBF74201-CBF74202  embl_tpa_prot",
    "special  CBF74204           embl_tpa_prot",
    "special  CBF74206           embl_tpa_prot",
    "special  CBF74208           embl_tpa_prot",
    "special  CBF74210           embl_tpa_prot",
    "special  CBF74212-CBF74213  embl_tpa_prot",
    "special  CBF74215           embl_tpa_prot",
    "special  CBF74217           embl_tpa_prot",
    "special  CBF74219           embl_tpa_prot",
    "special  CBF74221           embl_tpa_prot",
    "special  CBF74223-CBF74224  embl_tpa_prot",
    "special  CBF74226           embl_tpa_prot",
    "special  CBF74228           embl_tpa_prot",
    "special  CBF74230           embl_tpa_prot",
    "special  CBF74232           embl_tpa_prot",
    "special  CBF74234-CBF74235  embl_tpa_prot",
    "special  CBF74237           embl_tpa_prot",
    "special  CBF74239           embl_tpa_prot",
    "special  CBF74241-CBF74242  embl_tpa_prot",
    "special  CBF74244           embl_tpa_prot",
    "special  CBF74246           embl_tpa_prot",
    "special  CBF74248           embl_tpa_prot",
    "special  CBF74250           embl_tpa_prot",
    "special  CBF74252           embl_tpa_prot",
    "special  CBF74254           embl_tpa_prot",
    "special  CBF74256           embl_tpa_prot",
    "special  CBF74258           embl_tpa_prot",
    "special  CBF74260-CBF74261  embl_tpa_prot",
    "special  CBF74263           embl_tpa_prot",
    "special  CBF74265           embl_tpa_prot",
    "special  CBF74267           embl_tpa_prot",
    "special  CBF74269           embl_tpa_prot",
    "special  CBF74271-CBF74272  embl_tpa_prot",
    "special  CBF74274           embl_tpa_prot",
    "special  CBF74276           embl_tpa_prot",
    "special  CBF74278-CBF74279  embl_tpa_prot",
    "special  CBF74281           embl_tpa_prot",
    "special  CBF74283           embl_tpa_prot",
    "special  CBF74285           embl_tpa_prot",
    "special  CBF74287           embl_tpa_prot",
    "special  CBF74289           embl_tpa_prot",
    "special  CBF74291           embl_tpa_prot",
    "special  CBF74293           embl_tpa_prot",
    "special  CBF74295-CBF74296  embl_tpa_prot",
    "special  CBF74298           embl_tpa_prot",
    "special  CBF74300           embl_tpa_prot",
    "special  CBF74302           embl_tpa_prot",
    "special  CBF74304           embl_tpa_prot",
    "special  CBF74306           embl_tpa_prot",
    "special  CBF74308           embl_tpa_prot",
    "special  CBF74310-CBF74311  embl_tpa_prot",
    "special  CBF74313           embl_tpa_prot",
    "special  CBF74315           embl_tpa_prot",
    "special  CBF74317           embl_tpa_prot",
    "special  CBF74319           embl_tpa_prot",
    "special  CBF74321           embl_tpa_prot",
    "special  CBF74323           embl_tpa_prot",
    "special  CBF74325-CBF74326  embl_tpa_prot",
    "special  CBF74328           embl_tpa_prot",
    "special  CBF74330           embl_tpa_prot",
    "special  CBF74332           embl_tpa_prot",
    "special  CBF74334           embl_tpa_prot",
    "special  CBF74336           embl_tpa_prot",
    "special  CBF74338           embl_tpa_prot",
    "special  CBF74340-CBF74341  embl_tpa_prot",
    "special  CBF74343           embl_tpa_prot",
    "special  CBF74345           embl_tpa_prot",
    "special  CBF74347           embl_tpa_prot",
    "special  CBF74349           embl_tpa_prot",
    "special  CBF74351           embl_tpa_prot",
    "special  CBF74353           embl_tpa_prot",
    "special  CBF74355-CBF74356  embl_tpa_prot",
    "special  CBF74358           embl_tpa_prot",
    "special  CBF74360           embl_tpa_prot",
    "special  CBF74362           embl_tpa_prot",
    "special  CBF74364-CBF74365  embl_tpa_prot",
    "special  CBF74367           embl_tpa_prot",
    "special  CBF74369           embl_tpa_prot",
    "special  CBF74371           embl_tpa_prot",
    "special  CBF74373           embl_tpa_prot",
    "special  CBF74375-CBF74376  embl_tpa_prot",
    "special  CBF74378           embl_tpa_prot",
    "special  CBF74380           embl_tpa_prot",
    "special  CBF74382           embl_tpa_prot",
    "special  CBF74384           embl_tpa_prot",
    "special  CBF74386-CBF74387  embl_tpa_prot",
    "special  CBF74389           embl_tpa_prot",
    "special  CBF74391           embl_tpa_prot",
    "special  CBF74393           embl_tpa_prot",
    "special  CBF74395-CBF74396  embl_tpa_prot",
    "special  CBF74398           embl_tpa_prot",
    "special  CBF74401-CBF74402  embl_tpa_prot",
    "special  CBF74404           embl_tpa_prot",
    "special  CBF74406           embl_tpa_prot",
    "special  CBF74408           embl_tpa_prot",
    "special  CBF74410           embl_tpa_prot",
    "special  CBF74412-CBF74413  embl_tpa_prot",
    "special  CBF74415           embl_tpa_prot",
    "special  CBF74417           embl_tpa_prot",
    "special  CBF74419           embl_tpa_prot",
    "special  CBF74421           embl_tpa_prot",
    "special  CBF74423-CBF74424  embl_tpa_prot",
    "special  CBF74426           embl_tpa_prot",
    "special  CBF74428           embl_tpa_prot",
    "special  CBF74430           embl_tpa_prot",
    "special  CBF74432           embl_tpa_prot",
    "special  CBF74434           embl_tpa_prot",
    "special  CBF74436-CBF74438  embl_tpa_prot",
    "special  CBF74440           embl_tpa_prot",
    "special  CBF74442           embl_tpa_prot",
    "special  CBF74444           embl_tpa_prot",
    "special  CBF74446           embl_tpa_prot",
    "special  CBF74448           embl_tpa_prot",
    "special  CBF74450           embl_tpa_prot",
    "special  CBF74452-CBF74453  embl_tpa_prot",
    "special  CBF74455-CBF74456  embl_tpa_prot",
    "special  CBF74458           embl_tpa_prot",
    "special  CBF74460-CBF74461  embl_tpa_prot",
    "special  CBF74463           embl_tpa_prot",
    "special  CBF74465           embl_tpa_prot",
    "special  CBF74467           embl_tpa_prot",
    "special  CBF74469           embl_tpa_prot",
    "special  CBF74471           embl_tpa_prot",
    "special  CBF74473           embl_tpa_prot",
    "special  CBF74475-CBF74476  embl_tpa_prot",
    "special  CBF74478           embl_tpa_prot",
    "special  CBF74480           embl_tpa_prot",
    "special  CBF74482           embl_tpa_prot",
    "special  CBF74484-CBF74485  embl_tpa_prot",
    "special  CBF74487           embl_tpa_prot",
    "special  CBF74489           embl_tpa_prot",
    "special  CBF74491           embl_tpa_prot",
    "special  CBF74493           embl_tpa_prot",
    "special  CBF74495-CBF74496  embl_tpa_prot",
    "special  CBF74498           embl_tpa_prot",
    "special  CBF74500           embl_tpa_prot",
    "special  CBF74502-CBF74503  embl_tpa_prot",
    "special  CBF74505           embl_tpa_prot",
    "special  CBF74507           embl_tpa_prot",
    "special  CBF74509           embl_tpa_prot",
    "special  CBF74511-CBF74512  embl_tpa_prot",
    "special  CBF74514           embl_tpa_prot",
    "special  CBF74516           embl_tpa_prot",
    "special  CBF74518           embl_tpa_prot",
    "special  CBF74520-CBF74521  embl_tpa_prot",
    "special  CBF74523           embl_tpa_prot",
    "special  CBF74525           embl_tpa_prot",
    "special  CBF74527           embl_tpa_prot",
    "special  CBF74529           embl_tpa_prot",
    "special  CBF74531           embl_tpa_prot",
    "special  CBF74533-CBF74534  embl_tpa_prot",
    "special  CBF74536           embl_tpa_prot",
    "special  CBF74538           embl_tpa_prot",
    "special  CBF74540           embl_tpa_prot",
    "special  CBF74542-CBF74543  embl_tpa_prot",
    "special  CBF74545           embl_tpa_prot",
    "special  CBF74547-CBF74548  embl_tpa_prot",
    "special  CBF74550           embl_tpa_prot",
    "special  CBF74552-CBF74553  embl_tpa_prot",
    "special  CBF74555-CBF74556  embl_tpa_prot",
    "special  CBF74558           embl_tpa_prot",
    "special  CBF74560           embl_tpa_prot",
    "special  CBF74562           embl_tpa_prot",
    "special  CBF74564           embl_tpa_prot",
    "special  CBF74566-CBF74567  embl_tpa_prot",
    "special  CBF74569           embl_tpa_prot",
    "special  CBF74571-CBF74572  embl_tpa_prot",
    "special  CBF74574           embl_tpa_prot",
    "special  CBF74576           embl_tpa_prot",
    "special  CBF74578           embl_tpa_prot",
    "special  CBF74580           embl_tpa_prot",
    "special  CBF74582           embl_tpa_prot",
    "special  CBF74584           embl_tpa_prot",
    "special  CBF74586           embl_tpa_prot",
    "special  CBF74588           embl_tpa_prot",
    "special  CBF74590-CBF74591  embl_tpa_prot",
    "special  CBF74593           embl_tpa_prot",
    "special  CBF74595           embl_tpa_prot",
    "special  CBF74597           embl_tpa_prot",
    "special  CBF74599           embl_tpa_prot",
    "special  CBF74601           embl_tpa_prot",
    "special  CBF74603           embl_tpa_prot",
    "special  CBF74605-CBF74606  embl_tpa_prot",
    "special  CBF74608-CBF74610  embl_tpa_prot",
    "special  CBF74612           embl_tpa_prot",
    "special  CBF74614           embl_tpa_prot",
    "special  CBF74617-CBF74618  embl_tpa_prot",
    "special  CBF74620           embl_tpa_prot",
    "special  CBF74622           embl_tpa_prot",
    "special  CBF74624           embl_tpa_prot",
    "special  CBF74626           embl_tpa_prot",
    "special  CBF74628           embl_tpa_prot",
    "special  CBF74630           embl_tpa_prot",
    "special  CBF74632           embl_tpa_prot",
    "special  CBF74634           embl_tpa_prot",
    "special  CBF74636-CBF74637  embl_tpa_prot",
    "special  CBF74639           embl_tpa_prot",
    "special  CBF74641           embl_tpa_prot",
    "special  CBF74643           embl_tpa_prot",
    "special  CBF74645           embl_tpa_prot",
    "special  CBF74647-CBF74648  embl_tpa_prot",
    "special  CBF74650           embl_tpa_prot",
    "special  CBF74652           embl_tpa_prot",
    "special  CBF74654           embl_tpa_prot",
    "special  CBF74656           embl_tpa_prot",
    "special  CBF74658           embl_tpa_prot",
    "special  CBF74660-CBF74661  embl_tpa_prot",
    "special  CBF74663           embl_tpa_prot",
    "special  CBF74665           embl_tpa_prot",
    "special  CBF74667           embl_tpa_prot",
    "special  CBF74669           embl_tpa_prot",
    "special  CBF74671           embl_tpa_prot",
    "special  CBF74673           embl_tpa_prot",
    "special  CBF74675           embl_tpa_prot",
    "special  CBF74677           embl_tpa_prot",
    "special  CBF74679           embl_tpa_prot",
    "special  CBF74681           embl_tpa_prot",
    "special  CBF74683           embl_tpa_prot",
    "special  CBF74685           embl_tpa_prot",
    "special  CBF74687           embl_tpa_prot",
    "special  CBF74689           embl_tpa_prot",
    "special  CBF74691-CBF74692  embl_tpa_prot",
    "special  CBF74694           embl_tpa_prot",
    "special  CBF74696           embl_tpa_prot",
    "special  CBF74698           embl_tpa_prot",
    "special  CBF74700           embl_tpa_prot",
    "special  CBF74702           embl_tpa_prot",
    "special  CBF74704           embl_tpa_prot",
    "special  CBF74706           embl_tpa_prot",
    "special  CBF74708           embl_tpa_prot",
    "special  CBF74710-CBF74711  embl_tpa_prot",
    "special  CBF74713           embl_tpa_prot",
    "special  CBF74715           embl_tpa_prot",
    "special  CBF74717           embl_tpa_prot",
    "special  CBF74719           embl_tpa_prot",
    "special  CBF74721-CBF74722  embl_tpa_prot",
    "special  CBF74724           embl_tpa_prot",
    "special  CBF74726           embl_tpa_prot",
    "special  CBF74728           embl_tpa_prot",
    "special  CBF74730           embl_tpa_prot",
    "special  CBF74732           embl_tpa_prot",
    "special  CBF74734           embl_tpa_prot",
    "special  CBF74736           embl_tpa_prot",
    "special  CBF74738           embl_tpa_prot",
    "special  CBF74740           embl_tpa_prot",
    "special  CBF74742-CBF74743  embl_tpa_prot",
    "special  CBF74745           embl_tpa_prot",
    "special  CBF74747           embl_tpa_prot",
    "special  CBF74749           embl_tpa_prot",
    "special  CBF74751           embl_tpa_prot",
    "special  CBF74753-CBF74755  embl_tpa_prot",
    "special  CBF74757           embl_tpa_prot",
    "special  CBF74759           embl_tpa_prot",
    "special  CBF74761           embl_tpa_prot",
    "special  CBF74763           embl_tpa_prot",
    "special  CBF74765           embl_tpa_prot",
    "special  CBF74767           embl_tpa_prot",
    "special  CBF74769           embl_tpa_prot",
    "special  CBF74771           embl_tpa_prot",
    "special  CBF74773           embl_tpa_prot",
    "special  CBF74775           embl_tpa_prot",
    "special  CBF74777           embl_tpa_prot",
    "special  CBF74779           embl_tpa_prot",
    "special  CBF74781           embl_tpa_prot",
    "special  CBF74783           embl_tpa_prot",
    "special  CBF74785           embl_tpa_prot",
    "special  CBF74787           embl_tpa_prot",
    "special  CBF74789           embl_tpa_prot",
    "special  CBF74791           embl_tpa_prot",
    "special  CBF74793           embl_tpa_prot",
    "special  CBF74795           embl_tpa_prot",
    "special  CBF74797           embl_tpa_prot",
    "special  CBF74799           embl_tpa_prot",
    "special  CBF74801           embl_tpa_prot",
    "special  CBF74803           embl_tpa_prot",
    "special  CBF74805           embl_tpa_prot",
    "special  CBF74807           embl_tpa_prot",
    "special  CBF74809           embl_tpa_prot",
    "special  CBF74811           embl_tpa_prot",
    "special  CBF74813           embl_tpa_prot",
    "special  CBF74815           embl_tpa_prot",
    "special  CBF74817           embl_tpa_prot",
    "special  CBF74819           embl_tpa_prot",
    "special  CBF74821           embl_tpa_prot",
    "special  CBF74823           embl_tpa_prot",
    "special  CBF74825           embl_tpa_prot",
    "special  CBF74827           embl_tpa_prot",
    "special  CBF74829           embl_tpa_prot",
    "special  CBF74831           embl_tpa_prot",
    "special  CBF74833           embl_tpa_prot",
    "special  CBF74835           embl_tpa_prot",
    "special  CBF74837           embl_tpa_prot",
    "special  CBF74839           embl_tpa_prot",
    "special  CBF74841           embl_tpa_prot",
    "special  CBF74843           embl_tpa_prot",
    "special  CBF74845           embl_tpa_prot",
    "special  CBF74847           embl_tpa_prot",
    "special  CBF74849           embl_tpa_prot",
    "special  CBF74851           embl_tpa_prot",
    "special  CBF74853-CBF74854  embl_tpa_prot",
    "special  CBF74856           embl_tpa_prot",
    "special  CBF74858           embl_tpa_prot",
    "special  CBF74860           embl_tpa_prot",
    "special  CBF74862           embl_tpa_prot",
    "special  CBF74864           embl_tpa_prot",
    "special  CBF74866           embl_tpa_prot",
    "special  CBF74868           embl_tpa_prot",
    "special  CBF74870-CBF74871  embl_tpa_prot",
    "special  CBF74873           embl_tpa_prot",
    "special  CBF74875           embl_tpa_prot",
    "special  CBF74877           embl_tpa_prot",
    "special  CBF74880           embl_tpa_prot",
    "special  CBF74882           embl_tpa_prot",
    "special  CBF74884           embl_tpa_prot",
    "special  CBF74886           embl_tpa_prot",
    "special  CBF74888           embl_tpa_prot",
    "special  CBF74890           embl_tpa_prot",
    "special  CBF74892-CBF74893  embl_tpa_prot",
    "special  CBF74895           embl_tpa_prot",
    "special  CBF74897           embl_tpa_prot",
    "special  CBF74899           embl_tpa_prot",
    "special  CBF74901           embl_tpa_prot",
    "special  CBF74903           embl_tpa_prot",
    "special  CBF74905           embl_tpa_prot",
    "special  CBF74907-CBF74908  embl_tpa_prot",
    "special  CBF74910           embl_tpa_prot",
    "special  CBF74912           embl_tpa_prot",
    "special  CBF74914           embl_tpa_prot",
    "special  CBF74916           embl_tpa_prot",
    "special  CBF74918           embl_tpa_prot",
    "special  CBF74920           embl_tpa_prot",
    "special  CBF74922           embl_tpa_prot",
    "special  CBF74924           embl_tpa_prot",
    "special  CBF74926           embl_tpa_prot",
    "special  CBF74928           embl_tpa_prot",
    "special  CBF74930           embl_tpa_prot",
    "special  CBF74932           embl_tpa_prot",
    "special  CBF74934           embl_tpa_prot",
    "special  CBF74936           embl_tpa_prot",
    "special  CBF74938           embl_tpa_prot",
    "special  CBF74940           embl_tpa_prot",
    "special  CBF74942           embl_tpa_prot",
    "special  CBF74944           embl_tpa_prot",
    "special  CBF74946           embl_tpa_prot",
    "special  CBF74948           embl_tpa_prot",
    "special  CBF74950           embl_tpa_prot",
    "special  CBF74952           embl_tpa_prot",
    "special  CBF74954           embl_tpa_prot",
    "special  CBF74956           embl_tpa_prot",
    "special  CBF74958           embl_tpa_prot",
    "special  CBF74960           embl_tpa_prot",
    "special  CBF74962           embl_tpa_prot",
    "special  CBF74964           embl_tpa_prot",
    "special  CBF74966           embl_tpa_prot",
    "special  CBF74968-CBF74969  embl_tpa_prot",
    "special  CBF74971           embl_tpa_prot",
    "special  CBF74973           embl_tpa_prot",
    "special  CBF74975           embl_tpa_prot",
    "special  CBF74977           embl_tpa_prot",
    "special  CBF74979           embl_tpa_prot",
    "special  CBF74981           embl_tpa_prot",
    "special  CBF74983           embl_tpa_prot",
    "special  CBF74985           embl_tpa_prot",
    "special  CBF74987           embl_tpa_prot",
    "special  CBF74989           embl_tpa_prot",
    "special  CBF74991           embl_tpa_prot",
    "special  CBF74993-CBF74994  embl_tpa_prot",
    "special  CBF74996           embl_tpa_prot",
    "special  CBF74998           embl_tpa_prot",
    "special  CBF75000           embl_tpa_prot",
    "special  CBF75002           embl_tpa_prot",
    "special  CBF75004           embl_tpa_prot",
    "special  CBF75006           embl_tpa_prot",
    "special  CBF75008           embl_tpa_prot",
    "special  CBF75011-CBF75012  embl_tpa_prot",
    "special  CBF75014           embl_tpa_prot",
    "special  CBF75016           embl_tpa_prot",
    "special  CBF75018           embl_tpa_prot",
    "special  CBF75020           embl_tpa_prot",
    "special  CBF75022           embl_tpa_prot",
    "special  CBF75024           embl_tpa_prot",
    "special  CBF75026           embl_tpa_prot",
    "special  CBF75028           embl_tpa_prot",
    "special  CBF75030           embl_tpa_prot",
    "special  CBF75032           embl_tpa_prot",
    "special  CBF75034           embl_tpa_prot",
    "special  CBF75036           embl_tpa_prot",
    "special  CBF75038           embl_tpa_prot",
    "special  CBF75040           embl_tpa_prot",
    "special  CBF75042           embl_tpa_prot",
    "special  CBF75044           embl_tpa_prot",
    "special  CBF75046           embl_tpa_prot",
    "special  CBF75048           embl_tpa_prot",
    "special  CBF75050           embl_tpa_prot",
    "special  CBF75052           embl_tpa_prot",
    "special  CBF75054           embl_tpa_prot",
    "special  CBF75056           embl_tpa_prot",
    "special  CBF75058           embl_tpa_prot",
    "special  CBF75060           embl_tpa_prot",
    "special  CBF75062           embl_tpa_prot",
    "special  CBF75064           embl_tpa_prot",
    "special  CBF75066           embl_tpa_prot",
    "special  CBF75068           embl_tpa_prot",
    "special  CBF75070           embl_tpa_prot",
    "special  CBF75072           embl_tpa_prot",
    "special  CBF75074           embl_tpa_prot",
    "special  CBF75076           embl_tpa_prot",
    "special  CBF75078           embl_tpa_prot",
    "special  CBF75080           embl_tpa_prot",
    "special  CBF75082           embl_tpa_prot",
    "special  CBF75084           embl_tpa_prot",
    "special  CBF75086           embl_tpa_prot",
    "special  CBF75088           embl_tpa_prot",
    "special  CBF75090           embl_tpa_prot",
    "special  CBF75092           embl_tpa_prot",
    "special  CBF75094           embl_tpa_prot",
    "special  CBF75096           embl_tpa_prot",
    "special  CBF75098           embl_tpa_prot",
    "special  CBF75100           embl_tpa_prot",
    "special  CBF75102-CBF75103  embl_tpa_prot",
    "special  CBF75105           embl_tpa_prot",
    "special  CBF75107           embl_tpa_prot",
    "special  CBF75109           embl_tpa_prot",
    "special  CBF75111           embl_tpa_prot",
    "special  CBF75113           embl_tpa_prot",
    "special  CBF75115           embl_tpa_prot",
    "special  CBF75117           embl_tpa_prot",
    "special  CBF75119           embl_tpa_prot",
    "special  CBF75121           embl_tpa_prot",
    "special  CBF75123           embl_tpa_prot",
    "special  CBF75125           embl_tpa_prot",
    "special  CBF75127           embl_tpa_prot",
    "special  CBF75129           embl_tpa_prot",
    "special  CBF75131-CBF75132  embl_tpa_prot",
    "special  CBF75134           embl_tpa_prot",
    "special  CBF75136           embl_tpa_prot",
    "special  CBF75138           embl_tpa_prot",
    "special  CBF75140           embl_tpa_prot",
    "special  CBF75142           embl_tpa_prot",
    "special  CBF75144           embl_tpa_prot",
    "special  CBF75146           embl_tpa_prot",
    "special  CBF75148           embl_tpa_prot",
    "special  CBF75150           embl_tpa_prot",
    "special  CBF75152           embl_tpa_prot",
    "special  CBF75154           embl_tpa_prot",
    "special  CBF75156           embl_tpa_prot",
    "special  CBF75158           embl_tpa_prot",
    "special  CBF75160           embl_tpa_prot",
    "special  CBF75162-CBF75163  embl_tpa_prot",
    "special  CBF75165           embl_tpa_prot",
    "special  CBF75167           embl_tpa_prot",
    "special  CBF75169           embl_tpa_prot",
    "special  CBF75171           embl_tpa_prot",
    "special  CBF75173-CBF75174  embl_tpa_prot",
    "special  CBF75176           embl_tpa_prot",
    "special  CBF75178           embl_tpa_prot",
    "special  CBF75180           embl_tpa_prot",
    "special  CBF75182           embl_tpa_prot",
    "special  CBF75184           embl_tpa_prot",
    "special  CBF75186           embl_tpa_prot",
    "special  CBF75188-CBF75189  embl_tpa_prot",
    "special  CBF75191           embl_tpa_prot",
    "special  CBF75193           embl_tpa_prot",
    "special  CBF75195           embl_tpa_prot",
    "special  CBF75197           embl_tpa_prot",
    "special  CBF75199           embl_tpa_prot",
    "special  CBF75201           embl_tpa_prot",
    "special  CBF75203           embl_tpa_prot",
    "special  CBF75205           embl_tpa_prot",
    "special  CBF75207           embl_tpa_prot",
    "special  CBF75209           embl_tpa_prot",
    "special  CBF75211           embl_tpa_prot",
    "special  CBF75213           embl_tpa_prot",
    "special  CBF75215           embl_tpa_prot",
    "special  CBF75217-CBF75218  embl_tpa_prot",
    "special  CBF75220           embl_tpa_prot",
    "special  CBF75222-CBF75223  embl_tpa_prot",
    "special  CBF75225           embl_tpa_prot",
    "special  CBF75228           embl_tpa_prot",
    "special  CBF75230           embl_tpa_prot",
    "special  CBF75232           embl_tpa_prot",
    "special  CBF75234           embl_tpa_prot",
    "special  CBF75236           embl_tpa_prot",
    "special  CBF75238           embl_tpa_prot",
    "special  CBF75240           embl_tpa_prot",
    "special  CBF75242           embl_tpa_prot",
    "special  CBF75244           embl_tpa_prot",
    "special  CBF75246           embl_tpa_prot",
    "special  CBF75248           embl_tpa_prot",
    "special  CBF75250           embl_tpa_prot",
    "special  CBF75252           embl_tpa_prot",
    "special  CBF75254           embl_tpa_prot",
    "special  CBF75256           embl_tpa_prot",
    "special  CBF75258           embl_tpa_prot",
    "special  CBF75260-CBF75261  embl_tpa_prot",
    "special  CBF75263           embl_tpa_prot",
    "special  CBF75265           embl_tpa_prot",
    "special  CBF75267           embl_tpa_prot",
    "special  CBF75269           embl_tpa_prot",
    "special  CBF75271           embl_tpa_prot",
    "special  CBF75273           embl_tpa_prot",
    "special  CBF75275           embl_tpa_prot",
    "special  CBF75277           embl_tpa_prot",
    "special  CBF75279           embl_tpa_prot",
    "special  CBF75281           embl_tpa_prot",
    "special  CBF75283           embl_tpa_prot",
    "special  CBF75285           embl_tpa_prot",
    "special  CBF75287           embl_tpa_prot",
    "special  CBF75289           embl_tpa_prot",
    "special  CBF75291           embl_tpa_prot",
    "special  CBF75293-CBF75294  embl_tpa_prot",
    "special  CBF75296           embl_tpa_prot",
    "special  CBF75298           embl_tpa_prot",
    "special  CBF75300           embl_tpa_prot",
    "special  CBF75302           embl_tpa_prot",
    "special  CBF75304-CBF75305  embl_tpa_prot",
    "special  CBF75307-CBF75308  embl_tpa_prot",
    "special  CBF75310           embl_tpa_prot",
    "special  CBF75312           embl_tpa_prot",
    "special  CBF75314           embl_tpa_prot",
    "special  CBF75316           embl_tpa_prot",
    "special  CBF75318           embl_tpa_prot",
    "special  CBF75320           embl_tpa_prot",
    "special  CBF75322           embl_tpa_prot",
    "special  CBF75324           embl_tpa_prot",
    "special  CBF75326           embl_tpa_prot",
    "special  CBF75328           embl_tpa_prot",
    "special  CBF75330           embl_tpa_prot",
    "special  CBF75332           embl_tpa_prot",
    "special  CBF75334           embl_tpa_prot",
    "special  CBF75336           embl_tpa_prot",
    "special  CBF75338           embl_tpa_prot",
    "special  CBF75340           embl_tpa_prot",
    "special  CBF75342           embl_tpa_prot",
    "special  CBF75344           embl_tpa_prot",
    "special  CBF75346           embl_tpa_prot",
    "special  CBF75348           embl_tpa_prot",
    "special  CBF75350           embl_tpa_prot",
    "special  CBF75352           embl_tpa_prot",
    "special  CBF75354           embl_tpa_prot",
    "special  CBF75356           embl_tpa_prot",
    "special  CBF75358           embl_tpa_prot",
    "special  CBF75360           embl_tpa_prot",
    "special  CBF75362           embl_tpa_prot",
    "special  CBF75364           embl_tpa_prot",
    "special  CBF75366           embl_tpa_prot",
    "special  CBF75368           embl_tpa_prot",
    "special  CBF75370           embl_tpa_prot",
    "special  CBF75372           embl_tpa_prot",
    "special  CBF75374           embl_tpa_prot",
    "special  CBF75376           embl_tpa_prot",
    "special  CBF75378           embl_tpa_prot",
    "special  CBF75380           embl_tpa_prot",
    "special  CBF75382           embl_tpa_prot",
    "special  CBF75384           embl_tpa_prot",
    "special  CBF75386           embl_tpa_prot",
    "special  CBF75388           embl_tpa_prot",
    "special  CBF75390           embl_tpa_prot",
    "special  CBF75392           embl_tpa_prot",
    "special  CBF75394           embl_tpa_prot",
    "special  CBF75396           embl_tpa_prot",
    "special  CBF75398           embl_tpa_prot",
    "special  CBF75400           embl_tpa_prot",
    "special  CBF75402-CBF75403  embl_tpa_prot",
    "special  CBF75405           embl_tpa_prot",
    "special  CBF75407           embl_tpa_prot",
    "special  CBF75409           embl_tpa_prot",
    "special  CBF75411           embl_tpa_prot",
    "special  CBF75413           embl_tpa_prot",
    "special  CBF75415           embl_tpa_prot",
    "special  CBF75417           embl_tpa_prot",
    "special  CBF75419           embl_tpa_prot",
    "special  CBF75421           embl_tpa_prot",
    "special  CBF75423           embl_tpa_prot",
    "special  CBF75425           embl_tpa_prot",
    "special  CBF75427           embl_tpa_prot",
    "special  CBF75429-CBF75430  embl_tpa_prot",
    "special  CBF75432           embl_tpa_prot",
    "special  CBF75434           embl_tpa_prot",
    "special  CBF75436           embl_tpa_prot",
    "special  CBF75438           embl_tpa_prot",
    "special  CBF75440           embl_tpa_prot",
    "special  CBF75442           embl_tpa_prot",
    "special  CBF75444           embl_tpa_prot",
    "special  CBF75446           embl_tpa_prot",
    "special  CBF75448           embl_tpa_prot",
    "special  CBF75450           embl_tpa_prot",
    "special  CBF75452           embl_tpa_prot",
    "special  CBF75454           embl_tpa_prot",
    "special  CBF75456           embl_tpa_prot",
    "special  CBF75458           embl_tpa_prot",
    "special  CBF75460           embl_tpa_prot",
    "special  CBF75462           embl_tpa_prot",
    "special  CBF75464           embl_tpa_prot",
    "special  CBF75466           embl_tpa_prot",
    "special  CBF75468           embl_tpa_prot",
    "special  CBF75470           embl_tpa_prot",
    "special  CBF75472           embl_tpa_prot",
    "special  CBF75474           embl_tpa_prot",
    "special  CBF75476           embl_tpa_prot",
    "special  CBF75478           embl_tpa_prot",
    "special  CBF75480           embl_tpa_prot",
    "special  CBF75482           embl_tpa_prot",
    "special  CBF75484           embl_tpa_prot",
    "special  CBF75486           embl_tpa_prot",
    "special  CBF75488           embl_tpa_prot",
    "special  CBF75490-CBF75491  embl_tpa_prot",
    "special  CBF75493           embl_tpa_prot",
    "special  CBF75495           embl_tpa_prot",
    "special  CBF75497           embl_tpa_prot",
    "special  CBF75499           embl_tpa_prot",
    "special  CBF75501           embl_tpa_prot",
    "special  CBF75503           embl_tpa_prot",
    "special  CBF75506           embl_tpa_prot",
    "special  CBF75508           embl_tpa_prot",
    "special  CBF75510           embl_tpa_prot",
    "special  CBF75512           embl_tpa_prot",
    "special  CBF75514           embl_tpa_prot",
    "special  CBF75516           embl_tpa_prot",
    "special  CBF75518           embl_tpa_prot",
    "special  CBF75520           embl_tpa_prot",
    "special  CBF75522           embl_tpa_prot",
    "special  CBF75524-CBF75525  embl_tpa_prot",
    "special  CBF75527           embl_tpa_prot",
    "special  CBF75529           embl_tpa_prot",
    "special  CBF75531           embl_tpa_prot",
    "special  CBF75533           embl_tpa_prot",
    "special  CBF75535           embl_tpa_prot",
    "special  CBF75537           embl_tpa_prot",
    "special  CBF75539           embl_tpa_prot",
    "special  CBF75541           embl_tpa_prot",
    "special  CBF75543           embl_tpa_prot",
    "special  CBF75545           embl_tpa_prot",
    "special  CBF75547           embl_tpa_prot",
    "special  CBF75549           embl_tpa_prot",
    "special  CBF75551           embl_tpa_prot",
    "special  CBF75553           embl_tpa_prot",
    "special  CBF75555-CBF75556  embl_tpa_prot",
    "special  CBF75558           embl_tpa_prot",
    "special  CBF75560           embl_tpa_prot",
    "special  CBF75562           embl_tpa_prot",
    "special  CBF75564           embl_tpa_prot",
    "special  CBF75566           embl_tpa_prot",
    "special  CBF75568           embl_tpa_prot",
    "special  CBF75570           embl_tpa_prot",
    "special  CBF75572           embl_tpa_prot",
    "special  CBF75574           embl_tpa_prot",
    "special  CBF75576           embl_tpa_prot",
    "special  CBF75578           embl_tpa_prot",
    "special  CBF75580           embl_tpa_prot",
    "special  CBF75582           embl_tpa_prot",
    "special  CBF75584           embl_tpa_prot",
    "special  CBF75587           embl_tpa_prot",
    "special  CBF75589           embl_tpa_prot",
    "special  CBF75591           embl_tpa_prot",
    "special  CBF75593-CBF75594  embl_tpa_prot",
    "special  CBF75596           embl_tpa_prot",
    "special  CBF75598           embl_tpa_prot",
    "special  CBF75600           embl_tpa_prot",
    "special  CBF75602           embl_tpa_prot",
    "special  CBF75604-CBF75606  embl_tpa_prot",
    "special  CBF75608           embl_tpa_prot",
    "special  CBF75610-CBF75611  embl_tpa_prot",
    "special  CBF75613           embl_tpa_prot",
    "special  CBF75615           embl_tpa_prot",
    "special  CBF75617           embl_tpa_prot",
    "special  CBF75619           embl_tpa_prot",
    "special  CBF75621           embl_tpa_prot",
    "special  CBF75623           embl_tpa_prot",
    "special  CBF75625           embl_tpa_prot",
    "special  CBF75627           embl_tpa_prot",
    "special  CBF75629-CBF75630  embl_tpa_prot",
    "special  CBF75632           embl_tpa_prot",
    "special  CBF75634           embl_tpa_prot",
    "special  CBF75636           embl_tpa_prot",
    "special  CBF75638           embl_tpa_prot",
    "special  CBF75640           embl_tpa_prot",
    "special  CBF75642           embl_tpa_prot",
    "special  CBF75644           embl_tpa_prot",
    "special  CBF75646           embl_tpa_prot",
    "special  CBF75648-CBF75649  embl_tpa_prot",
    "special  CBF75651           embl_tpa_prot",
    "special  CBF75653           embl_tpa_prot",
    "special  CBF75655           embl_tpa_prot",
    "special  CBF75657           embl_tpa_prot",
    "special  CBF75659           embl_tpa_prot",
    "special  CBF75661           embl_tpa_prot",
    "special  CBF75663           embl_tpa_prot",
    "special  CBF75665           embl_tpa_prot",
    "special  CBF75667           embl_tpa_prot",
    "special  CBF75669           embl_tpa_prot",
    "special  CBF75671           embl_tpa_prot",
    "special  CBF75673           embl_tpa_prot",
    "special  CBF75675           embl_tpa_prot",
    "special  CBF75677           embl_tpa_prot",
    "special  CBF75679           embl_tpa_prot",
    "special  CBF75681           embl_tpa_prot",
    "special  CBF75683           embl_tpa_prot",
    "special  CBF75685           embl_tpa_prot",
    "special  CBF75687           embl_tpa_prot",
    "special  CBF75689           embl_tpa_prot",
    "special  CBF75691           embl_tpa_prot",
    "special  CBF75693           embl_tpa_prot",
    "special  CBF75695           embl_tpa_prot",
    "special  CBF75697           embl_tpa_prot",
    "special  CBF75699           embl_tpa_prot",
    "special  CBF75701           embl_tpa_prot",
    "special  CBF75703-CBF75704  embl_tpa_prot",
    "special  CBF75706           embl_tpa_prot",
    "special  CBF75708           embl_tpa_prot",
    "special  CBF75710           embl_tpa_prot",
    "special  CBF75712           embl_tpa_prot",
    "special  CBF75714           embl_tpa_prot",
    "special  CBF75716           embl_tpa_prot",
    "special  CBF75718           embl_tpa_prot",
    "special  CBF75720           embl_tpa_prot",
    "special  CBF75722-CBF75723  embl_tpa_prot",
    "special  CBF75725           embl_tpa_prot",
    "special  CBF75727           embl_tpa_prot",
    "special  CBF75729           embl_tpa_prot",
    "special  CBF75731           embl_tpa_prot",
    "special  CBF75733           embl_tpa_prot",
    "special  CBF75735           embl_tpa_prot",
    "special  CBF75737           embl_tpa_prot",
    "special  CBF75739           embl_tpa_prot",
    "special  CBF75741           embl_tpa_prot",
    "special  CBF75743           embl_tpa_prot",
    "special  CBF75745           embl_tpa_prot",
    "special  CBF75747-CBF75748  embl_tpa_prot",
    "special  CBF75750           embl_tpa_prot",
    "special  CBF75752           embl_tpa_prot",
    "special  CBF75754           embl_tpa_prot",
    "special  CBF75756           embl_tpa_prot",
    "special  CBF75758           embl_tpa_prot",
    "special  CBF75760           embl_tpa_prot",
    "special  CBF75762           embl_tpa_prot",
    "special  CBF75764           embl_tpa_prot",
    "special  CBF75766           embl_tpa_prot",
    "special  CBF75768           embl_tpa_prot",
    "special  CBF75770           embl_tpa_prot",
    "special  CBF75772           embl_tpa_prot",
    "special  CBF75774           embl_tpa_prot",
    "special  CBF75776           embl_tpa_prot",
    "special  CBF75778-CBF75779  embl_tpa_prot",
    "special  CBF75781           embl_tpa_prot",
    "special  CBF75783           embl_tpa_prot",
    "special  CBF75785           embl_tpa_prot",
    "special  CBF75787           embl_tpa_prot",
    "special  CBF75789-CBF75790  embl_tpa_prot",
    "special  CBF75792           embl_tpa_prot",
    "special  CBF75794           embl_tpa_prot",
    "special  CBF75796           embl_tpa_prot",
    "special  CBF75798           embl_tpa_prot",
    "special  CBF75800           embl_tpa_prot",
    "special  CBF75802           embl_tpa_prot",
    "special  CBF75804           embl_tpa_prot",
    "special  CBF75806           embl_tpa_prot",
    "special  CBF75808-CBF75809  embl_tpa_prot",
    "special  CBF75811           embl_tpa_prot",
    "special  CBF75813           embl_tpa_prot",
    "special  CBF75815           embl_tpa_prot",
    "special  CBF75817           embl_tpa_prot",
    "special  CBF75819           embl_tpa_prot",
    "special  CBF75821           embl_tpa_prot",
    "special  CBF75823           embl_tpa_prot",
    "special  CBF75825           embl_tpa_prot",
    "special  CBF75827           embl_tpa_prot",
    "special  CBF75829           embl_tpa_prot",
    "special  CBF75831           embl_tpa_prot",
    "special  CBF75833           embl_tpa_prot",
    "special  CBF75835           embl_tpa_prot",
    "special  CBF75837           embl_tpa_prot",
    "special  CBF75839           embl_tpa_prot",
    "special  CBF75841           embl_tpa_prot",
    "special  CBF75843           embl_tpa_prot",
    "special  CBF75845           embl_tpa_prot",
    "special  CBF75847           embl_tpa_prot",
    "special  CBF75849           embl_tpa_prot",
    "special  CBF75851           embl_tpa_prot",
    "special  CBF75853           embl_tpa_prot",
    "special  CBF75855           embl_tpa_prot",
    "special  CBF75857-CBF75858  embl_tpa_prot",
    "special  CBF75860           embl_tpa_prot",
    "special  CBF75862           embl_tpa_prot",
    "special  CBF75864           embl_tpa_prot",
    "special  CBF75866           embl_tpa_prot",
    "special  CBF75868           embl_tpa_prot",
    "special  CBF75870           embl_tpa_prot",
    "special  CBF75872           embl_tpa_prot",
    "special  CBF75874           embl_tpa_prot",
    "special  CBF75876           embl_tpa_prot",
    "special  CBF75878           embl_tpa_prot",
    "special  CBF75880           embl_tpa_prot",
    "special  CBF75882           embl_tpa_prot",
    "special  CBF75884           embl_tpa_prot",
    "special  CBF75886           embl_tpa_prot",
    "special  CBF75888           embl_tpa_prot",
    "special  CBF75890           embl_tpa_prot",
    "special  CBF75892           embl_tpa_prot",
    "special  CBF75894           embl_tpa_prot",
    "special  CBF75896           embl_tpa_prot",
    "special  CBF75898           embl_tpa_prot",
    "special  CBF75900           embl_tpa_prot",
    "special  CBF75902           embl_tpa_prot",
    "special  CBF75904           embl_tpa_prot",
    "special  CBF75906           embl_tpa_prot",
    "special  CBF75908           embl_tpa_prot",
    "special  CBF75910           embl_tpa_prot",
    "special  CBF75912           embl_tpa_prot",
    "special  CBF75914           embl_tpa_prot",
    "special  CBF75916           embl_tpa_prot",
    "special  CBF75918           embl_tpa_prot",
    "special  CBF75920           embl_tpa_prot",
    "special  CBF75922           embl_tpa_prot",
    "special  CBF75924-CBF75925  embl_tpa_prot",
    "special  CBF75928           embl_tpa_prot",
    "special  CBF75930           embl_tpa_prot",
    "special  CBF75932           embl_tpa_prot",
    "special  CBF75934           embl_tpa_prot",
    "special  CBF75936           embl_tpa_prot",
    "special  CBF75938           embl_tpa_prot",
    "special  CBF75940           embl_tpa_prot",
    "special  CBF75942           embl_tpa_prot",
    "special  CBF75944           embl_tpa_prot",
    "special  CBF75946           embl_tpa_prot",
    "special  CBF75948           embl_tpa_prot",
    "special  CBF75950           embl_tpa_prot",
    "special  CBF75952           embl_tpa_prot",
    "special  CBF75954           embl_tpa_prot",
    "special  CBF75956           embl_tpa_prot",
    "special  CBF75958           embl_tpa_prot",
    "special  CBF75960           embl_tpa_prot",
    "special  CBF75962           embl_tpa_prot",
    "special  CBF75964           embl_tpa_prot",
    "special  CBF75966           embl_tpa_prot",
    "special  CBF75968           embl_tpa_prot",
    "special  CBF75970           embl_tpa_prot",
    "special  CBF75972           embl_tpa_prot",
    "special  CBF75974           embl_tpa_prot",
    "special  CBF75976           embl_tpa_prot",
    "special  CBF75978           embl_tpa_prot",
    "special  CBF75980           embl_tpa_prot",
    "special  CBF75982           embl_tpa_prot",
    "special  CBF75984           embl_tpa_prot",
    "special  CBF75986           embl_tpa_prot",
    "special  CBF75988           embl_tpa_prot",
    "special  CBF75990           embl_tpa_prot",
    "special  CBF75992           embl_tpa_prot",
    "special  CBF75994           embl_tpa_prot",
    "special  CBF75996           embl_tpa_prot",
    "special  CBF75998           embl_tpa_prot",
    "special  CBF76000           embl_tpa_prot",
    "special  CBF76002           embl_tpa_prot",
    "special  CBF76004           embl_tpa_prot",
    "special  CBF76006           embl_tpa_prot",
    "special  CBF76008           embl_tpa_prot",
    "special  CBF76010           embl_tpa_prot",
    "special  CBF76012           embl_tpa_prot",
    "special  CBF76014           embl_tpa_prot",
    "special  CBF76016           embl_tpa_prot",
    "special  CBF76018           embl_tpa_prot",
    "special  CBF76020           embl_tpa_prot",
    "special  CBF76022           embl_tpa_prot",
    "special  CBF76024           embl_tpa_prot",
    "special  CBF76026           embl_tpa_prot",
    "special  CBF76028           embl_tpa_prot",
    "special  CBF76030           embl_tpa_prot",
    "special  CBF76032           embl_tpa_prot",
    "special  CBF76034           embl_tpa_prot",
    "special  CBF76036           embl_tpa_prot",
    "special  CBF76038           embl_tpa_prot",
    "special  CBF76040           embl_tpa_prot",
    "special  CBF76042           embl_tpa_prot",
    "special  CBF76044           embl_tpa_prot",
    "special  CBF76046           embl_tpa_prot",
    "special  CBF76048           embl_tpa_prot",
    "special  CBF76050           embl_tpa_prot",
    "special  CBF76052           embl_tpa_prot",
    "special  CBF76054           embl_tpa_prot",
    "special  CBF76056           embl_tpa_prot",
    "special  CBF76058           embl_tpa_prot",
    "special  CBF76060           embl_tpa_prot",
    "special  CBF76062           embl_tpa_prot",
    "special  CBF76064           embl_tpa_prot",
    "special  CBF76066           embl_tpa_prot",
    "special  CBF76068           embl_tpa_prot",
    "special  CBF76070           embl_tpa_prot",
    "special  CBF76072           embl_tpa_prot",
    "special  CBF76074-CBF76075  embl_tpa_prot",
    "special  CBF76078-CBF76079  embl_tpa_prot",
    "special  CBF76081           embl_tpa_prot",
    "special  CBF76083           embl_tpa_prot",
    "special  CBF76085           embl_tpa_prot",
    "special  CBF76093           embl_tpa_prot",
    "special  CBF76095           embl_tpa_prot",
    "special  CBF76097           embl_tpa_prot",
    "special  CBF76101           embl_tpa_prot",
    "special  CBF76103           embl_tpa_prot",
    "special  CBF76105           embl_tpa_prot",
    "special  CBF76107           embl_tpa_prot",
    "special  CBF76109           embl_tpa_prot",
    "special  CBF76111           embl_tpa_prot",
    "special  CBF76113           embl_tpa_prot",
    "special  CBF76115           embl_tpa_prot",
    "special  CBF76117           embl_tpa_prot",
    "special  CBF76119           embl_tpa_prot",
    "special  CBF76121           embl_tpa_prot",
    "special  CBF76123           embl_tpa_prot",
    "special  CBF76125           embl_tpa_prot",
    "special  CBF76127           embl_tpa_prot",
    "special  CBF76129           embl_tpa_prot",
    "special  CBF76131           embl_tpa_prot",
    "special  CBF76133           embl_tpa_prot",
    "special  CBF76135           embl_tpa_prot",
    "special  CBF76137           embl_tpa_prot",
    "special  CBF76139           embl_tpa_prot",
    "special  CBF76141           embl_tpa_prot",
    "special  CBF76143           embl_tpa_prot",
    "special  CBF76145           embl_tpa_prot",
    "special  CBF76147           embl_tpa_prot",
    "special  CBF76149           embl_tpa_prot",
    "special  CBF76151           embl_tpa_prot",
    "special  CBF76153           embl_tpa_prot",
    "special  CBF76155           embl_tpa_prot",
    "special  CBF76157           embl_tpa_prot",
    "special  CBF76159           embl_tpa_prot",
    "special  CBF76161           embl_tpa_prot",
    "special  CBF76163           embl_tpa_prot",
    "special  CBF76165           embl_tpa_prot",
    "special  CBF76167           embl_tpa_prot",
    "special  CBF76169           embl_tpa_prot",
    "special  CBF76171           embl_tpa_prot",
    "special  CBF76173           embl_tpa_prot",
    "special  CBF76175           embl_tpa_prot",
    "special  CBF76177           embl_tpa_prot",
    "special  CBF76179           embl_tpa_prot",
    "special  CBF76181           embl_tpa_prot",
    "special  CBF76183           embl_tpa_prot",
    "special  CBF76185           embl_tpa_prot",
    "special  CBF76187           embl_tpa_prot",
    "special  CBF76189           embl_tpa_prot",
    "special  CBF76191           embl_tpa_prot",
    "special  CBF76193           embl_tpa_prot",
    "special  CBF76195           embl_tpa_prot",
    "special  CBF76197           embl_tpa_prot",
    "special  CBF76199           embl_tpa_prot",
    "special  CBF76201           embl_tpa_prot",
    "special  CBF76203           embl_tpa_prot",
    "special  CBF76205           embl_tpa_prot",
    "special  CBF76207           embl_tpa_prot",
    "special  CBF76209           embl_tpa_prot",
    "special  CBF76211           embl_tpa_prot",
    "special  CBF76213           embl_tpa_prot",
    "special  CBF76215           embl_tpa_prot",
    "special  CBF76217           embl_tpa_prot",
    "special  CBF76219           embl_tpa_prot",
    "special  CBF76221           embl_tpa_prot",
    "special  CBF76223           embl_tpa_prot",
    "special  CBF76225           embl_tpa_prot",
    "special  CBF76227           embl_tpa_prot",
    "special  CBF76229           embl_tpa_prot",
    "special  CBF76231           embl_tpa_prot",
    "special  CBF76233           embl_tpa_prot",
    "special  CBF76235           embl_tpa_prot",
    "special  CBF76237           embl_tpa_prot",
    "special  CBF76239           embl_tpa_prot",
    "special  CBF76241           embl_tpa_prot",
    "special  CBF76243           embl_tpa_prot",
    "special  CBF76245           embl_tpa_prot",
    "special  CBF76247           embl_tpa_prot",
    "special  CBF76249           embl_tpa_prot",
    "special  CBF76251           embl_tpa_prot",
    "special  CBF76253           embl_tpa_prot",
    "special  CBF76255           embl_tpa_prot",
    "special  CBF76257           embl_tpa_prot",
    "special  CBF76259           embl_tpa_prot",
    "special  CBF76261           embl_tpa_prot",
    "special  CBF76263           embl_tpa_prot",
    "special  CBF76265           embl_tpa_prot",
    "special  CBF76267           embl_tpa_prot",
    "special  CBF76269           embl_tpa_prot",
    "special  CBF76271           embl_tpa_prot",
    "special  CBF76273           embl_tpa_prot",
    "special  CBF76275           embl_tpa_prot",
    "special  CBF76277           embl_tpa_prot",
    "special  CBF76279           embl_tpa_prot",
    "special  CBF76281           embl_tpa_prot",
    "special  CBF76283           embl_tpa_prot",
    "special  CBF76285           embl_tpa_prot",
    "special  CBF76287           embl_tpa_prot",
    "special  CBF76289           embl_tpa_prot",
    "special  CBF76291-CBF76292  embl_tpa_prot",
    "special  CBF76294           embl_tpa_prot",
    "special  CBF76296           embl_tpa_prot",
    "special  CBF76298           embl_tpa_prot",
    "special  CBF76300           embl_tpa_prot",
    "special  CBF76302           embl_tpa_prot",
    "special  CBF76304           embl_tpa_prot",
    "special  CBF76306           embl_tpa_prot",
    "special  CBF76308           embl_tpa_prot",
    "special  CBF76310           embl_tpa_prot",
    "special  CBF76312           embl_tpa_prot",
    "special  CBF76314           embl_tpa_prot",
    "special  CBF76316           embl_tpa_prot",
    "special  CBF76318           embl_tpa_prot",
    "special  CBF76320           embl_tpa_prot",
    "special  CBF76322           embl_tpa_prot",
    "special  CBF76324           embl_tpa_prot",
    "special  CBF76326           embl_tpa_prot",
    "special  CBF76328           embl_tpa_prot",
    "special  CBF76330           embl_tpa_prot",
    "special  CBF76332           embl_tpa_prot",
    "special  CBF76334           embl_tpa_prot",
    "special  CBF76336           embl_tpa_prot",
    "special  CBF76338           embl_tpa_prot",
    "special  CBF76340           embl_tpa_prot",
    "special  CBF76342           embl_tpa_prot",
    "special  CBF76344           embl_tpa_prot",
    "special  CBF76346           embl_tpa_prot",
    "special  CBF76348           embl_tpa_prot",
    "special  CBF76350           embl_tpa_prot",
    "special  CBF76352           embl_tpa_prot",
    "special  CBF76354           embl_tpa_prot",
    "special  CBF76356           embl_tpa_prot",
    "special  CBF76358           embl_tpa_prot",
    "special  CBF76360           embl_tpa_prot",
    "special  CBF76362           embl_tpa_prot",
    "special  CBF76364           embl_tpa_prot",
    "special  CBF76366           embl_tpa_prot",
    "special  CBF76368           embl_tpa_prot",
    "special  CBF76370           embl_tpa_prot",
    "special  CBF76372           embl_tpa_prot",
    "special  CBF76374           embl_tpa_prot",
    "special  CBF76376           embl_tpa_prot",
    "special  CBF76378           embl_tpa_prot",
    "special  CBF76380           embl_tpa_prot",
    "special  CBF76382           embl_tpa_prot",
    "special  CBF76384           embl_tpa_prot",
    "special  CBF76386           embl_tpa_prot",
    "special  CBF76388           embl_tpa_prot",
    "special  CBF76390           embl_tpa_prot",
    "special  CBF76392           embl_tpa_prot",
    "special  CBF76394           embl_tpa_prot",
    "special  CBF76396           embl_tpa_prot",
    "special  CBF76398           embl_tpa_prot",
    "special  CBF76400           embl_tpa_prot",
    "special  CBF76402           embl_tpa_prot",
    "special  CBF76404           embl_tpa_prot",
    "special  CBF76406           embl_tpa_prot",
    "special  CBF76408           embl_tpa_prot",
    "special  CBF76410           embl_tpa_prot",
    "special  CBF76412           embl_tpa_prot",
    "special  CBF76414           embl_tpa_prot",
    "special  CBF76416-CBF76417  embl_tpa_prot",
    "special  CBF76419           embl_tpa_prot",
    "special  CBF76421           embl_tpa_prot",
    "special  CBF76423           embl_tpa_prot",
    "special  CBF76425           embl_tpa_prot",
    "special  CBF76427           embl_tpa_prot",
    "special  CBF76429           embl_tpa_prot",
    "special  CBF76431           embl_tpa_prot",
    "special  CBF76433           embl_tpa_prot",
    "special  CBF76435           embl_tpa_prot",
    "special  CBF76437           embl_tpa_prot",
    "special  CBF76439           embl_tpa_prot",
    "special  CBF76441           embl_tpa_prot",
    "special  CBF76443           embl_tpa_prot",
    "special  CBF76445           embl_tpa_prot",
    "special  CBF76447           embl_tpa_prot",
    "special  CBF76449           embl_tpa_prot",
    "special  CBF76451           embl_tpa_prot",
    "special  CBF76453           embl_tpa_prot",
    "special  CBF76455           embl_tpa_prot",
    "special  CBF76457           embl_tpa_prot",
    "special  CBF76459-CBF76460  embl_tpa_prot",
    "special  CBF76462           embl_tpa_prot",
    "special  CBF76464           embl_tpa_prot",
    "special  CBF76466           embl_tpa_prot",
    "special  CBF76468           embl_tpa_prot",
    "special  CBF76470           embl_tpa_prot",
    "special  CBF76472           embl_tpa_prot",
    "special  CBF76474           embl_tpa_prot",
    "special  CBF76476           embl_tpa_prot",
    "special  CBF76478           embl_tpa_prot",
    "special  CBF76480           embl_tpa_prot",
    "special  CBF76482           embl_tpa_prot",
    "special  CBF76484           embl_tpa_prot",
    "special  CBF76486           embl_tpa_prot",
    "special  CBF76488           embl_tpa_prot",
    "special  CBF76490           embl_tpa_prot",
    "special  CBF76492           embl_tpa_prot",
    "special  CBF76494           embl_tpa_prot",
    "special  CBF76496           embl_tpa_prot",
    "special  CBF76498           embl_tpa_prot",
    "special  CBF76500           embl_tpa_prot",
    "special  CBF76502           embl_tpa_prot",
    "special  CBF76504           embl_tpa_prot",
    "special  CBF76506           embl_tpa_prot",
    "special  CBF76508-CBF76509  embl_tpa_prot",
    "special  CBF76511           embl_tpa_prot",
    "special  CBF76513           embl_tpa_prot",
    "special  CBF76515           embl_tpa_prot",
    "special  CBF76517           embl_tpa_prot",
    "special  CBF76519           embl_tpa_prot",
    "special  CBF76521           embl_tpa_prot",
    "special  CBF76523           embl_tpa_prot",
    "special  CBF76525           embl_tpa_prot",
    "special  CBF76527           embl_tpa_prot",
    "special  CBF76529-CBF76530  embl_tpa_prot",
    "special  CBF76532           embl_tpa_prot",
    "special  CBF76534           embl_tpa_prot",
    "special  CBF76536           embl_tpa_prot",
    "special  CBF76538           embl_tpa_prot",
    "special  CBF76540           embl_tpa_prot",
    "special  CBF76542           embl_tpa_prot",
    "special  CBF76544           embl_tpa_prot",
    "special  CBF76546           embl_tpa_prot",
    "special  CBF76548-CBF76549  embl_tpa_prot",
    "special  CBF76551           embl_tpa_prot",
    "special  CBF76553           embl_tpa_prot",
    "special  CBF76555           embl_tpa_prot",
    "special  CBF76557           embl_tpa_prot",
    "special  CBF76559           embl_tpa_prot",
    "special  CBF76561           embl_tpa_prot",
    "special  CBF76563           embl_tpa_prot",
    "special  CBF76565           embl_tpa_prot",
    "special  CBF76567           embl_tpa_prot",
    "special  CBF76569           embl_tpa_prot",
    "special  CBF76571           embl_tpa_prot",
    "special  CBF76573           embl_tpa_prot",
    "special  CBF76575           embl_tpa_prot",
    "special  CBF76577           embl_tpa_prot",
    "special  CBF76579           embl_tpa_prot",
    "special  CBF76581           embl_tpa_prot",
    "special  CBF76583           embl_tpa_prot",
    "special  CBF76585           embl_tpa_prot",
    "special  CBF76587           embl_tpa_prot",
    "special  CBF76589           embl_tpa_prot",
    "special  CBF76591           embl_tpa_prot",
    "special  CBF76593           embl_tpa_prot",
    "special  CBF76595           embl_tpa_prot",
    "special  CBF76597           embl_tpa_prot",
    "special  CBF76599           embl_tpa_prot",
    "special  CBF76601           embl_tpa_prot",
    "special  CBF76603           embl_tpa_prot",
    "special  CBF76605           embl_tpa_prot",
    "special  CBF76607           embl_tpa_prot",
    "special  CBF76609           embl_tpa_prot",
    "special  CBF76611           embl_tpa_prot",
    "special  CBF76613           embl_tpa_prot",
    "special  CBF76615           embl_tpa_prot",
    "special  CBF76617           embl_tpa_prot",
    "special  CBF76619           embl_tpa_prot",
    "special  CBF76621           embl_tpa_prot",
    "special  CBF76623           embl_tpa_prot",
    "special  CBF76625           embl_tpa_prot",
    "special  CBF76627           embl_tpa_prot",
    "special  CBF76629           embl_tpa_prot",
    "special  CBF76631           embl_tpa_prot",
    "special  CBF76633           embl_tpa_prot",
    "special  CBF76635           embl_tpa_prot",
    "special  CBF76637-CBF76638  embl_tpa_prot",
    "special  CBF76640           embl_tpa_prot",
    "special  CBF76642           embl_tpa_prot",
    "special  CBF76644           embl_tpa_prot",
    "special  CBF76646           embl_tpa_prot",
    "special  CBF76648           embl_tpa_prot",
    "special  CBF76650           embl_tpa_prot",
    "special  CBF76652           embl_tpa_prot",
    "special  CBF76654           embl_tpa_prot",
    "special  CBF76656           embl_tpa_prot",
    "special  CBF76658           embl_tpa_prot",
    "special  CBF76660           embl_tpa_prot",
    "special  CBF76662           embl_tpa_prot",
    "special  CBF76664           embl_tpa_prot",
    "special  CBF76666           embl_tpa_prot",
    "special  CBF76668           embl_tpa_prot",
    "special  CBF76670           embl_tpa_prot",
    "special  CBF76672           embl_tpa_prot",
    "special  CBF76674           embl_tpa_prot",
    "special  CBF76676           embl_tpa_prot",
    "special  CBF76678           embl_tpa_prot",
    "special  CBF76680           embl_tpa_prot",
    "special  CBF76682           embl_tpa_prot",
    "special  CBF76684           embl_tpa_prot",
    "special  CBF76686           embl_tpa_prot",
    "special  CBF76688           embl_tpa_prot",
    "special  CBF76690           embl_tpa_prot",
    "special  CBF76692           embl_tpa_prot",
    "special  CBF76694           embl_tpa_prot",
    "special  CBF76696-CBF76697  embl_tpa_prot",
    "special  CBF76699           embl_tpa_prot",
    "special  CBF76701           embl_tpa_prot",
    "special  CBF76703           embl_tpa_prot",
    "special  CBF76705           embl_tpa_prot",
    "special  CBF76707           embl_tpa_prot",
    "special  CBF76709           embl_tpa_prot",
    "special  CBF76711           embl_tpa_prot",
    "special  CBF76713           embl_tpa_prot",
    "special  CBF76715           embl_tpa_prot",
    "special  CBF76717           embl_tpa_prot",
    "special  CBF76719           embl_tpa_prot",
    "special  CBF76721           embl_tpa_prot",
    "special  CBF76723           embl_tpa_prot",
    "special  CBF76725           embl_tpa_prot",
    "special  CBF76727           embl_tpa_prot",
    "special  CBF76729           embl_tpa_prot",
    "special  CBF76731           embl_tpa_prot",
    "special  CBF76733           embl_tpa_prot",
    "special  CBF76735           embl_tpa_prot",
    "special  CBF76737           embl_tpa_prot",
    "special  CBF76739           embl_tpa_prot",
    "special  CBF76741           embl_tpa_prot",
    "special  CBF76743           embl_tpa_prot",
    "special  CBF76745           embl_tpa_prot",
    "special  CBF76747           embl_tpa_prot",
    "special  CBF76749           embl_tpa_prot",
    "special  CBF76751           embl_tpa_prot",
    "special  CBF76753           embl_tpa_prot",
    "special  CBF76755           embl_tpa_prot",
    "special  CBF76757           embl_tpa_prot",
    "special  CBF76759           embl_tpa_prot",
    "special  CBF76761           embl_tpa_prot",
    "special  CBF76763           embl_tpa_prot",
    "special  CBF76765           embl_tpa_prot",
    "special  CBF76767           embl_tpa_prot",
    "special  CBF76769           embl_tpa_prot",
    "special  CBF76771-CBF76772  embl_tpa_prot",
    "special  CBF76774           embl_tpa_prot",
    "special  CBF76776           embl_tpa_prot",
    "special  CBF76778           embl_tpa_prot",
    "special  CBF76780           embl_tpa_prot",
    "special  CBF76782           embl_tpa_prot",
    "special  CBF76784           embl_tpa_prot",
    "special  CBF76786           embl_tpa_prot",
    "special  CBF76788           embl_tpa_prot",
    "special  CBF76790           embl_tpa_prot",
    "special  CBF76792           embl_tpa_prot",
    "special  CBF76794           embl_tpa_prot",
    "special  CBF76796           embl_tpa_prot",
    "special  CBF76798           embl_tpa_prot",
    "special  CBF76800           embl_tpa_prot",
    "special  CBF76802           embl_tpa_prot",
    "special  CBF76804           embl_tpa_prot",
    "special  CBF76806           embl_tpa_prot",
    "special  CBF76808           embl_tpa_prot",
    "special  CBF76810           embl_tpa_prot",
    "special  CBF76812           embl_tpa_prot",
    "special  CBF76814           embl_tpa_prot",
    "special  CBF76816           embl_tpa_prot",
    "special  CBF76818           embl_tpa_prot",
    "special  CBF76820           embl_tpa_prot",
    "special  CBF76822           embl_tpa_prot",
    "special  CBF76824           embl_tpa_prot",
    "special  CBF76826           embl_tpa_prot",
    "special  CBF76828           embl_tpa_prot",
    "special  CBF76830           embl_tpa_prot",
    "special  CBF76832-CBF76833  embl_tpa_prot",
    "special  CBF76835           embl_tpa_prot",
    "special  CBF76837           embl_tpa_prot",
    "special  CBF76839           embl_tpa_prot",
    "special  CBF76842           embl_tpa_prot",
    "special  CBF76844           embl_tpa_prot",
    "special  CBF76846           embl_tpa_prot",
    "special  CBF76848           embl_tpa_prot",
    "special  CBF76850           embl_tpa_prot",
    "special  CBF76852           embl_tpa_prot",
    "special  CBF76854           embl_tpa_prot",
    "special  CBF76856           embl_tpa_prot",
    "special  CBF76858           embl_tpa_prot",
    "special  CBF76860           embl_tpa_prot",
    "special  CBF76862           embl_tpa_prot",
    "special  CBF76864           embl_tpa_prot",
    "special  CBF76866           embl_tpa_prot",
    "special  CBF76868           embl_tpa_prot",
    "special  CBF76870           embl_tpa_prot",
    "special  CBF76872           embl_tpa_prot",
    "special  CBF76874           embl_tpa_prot",
    "special  CBF76876           embl_tpa_prot",
    "special  CBF76878           embl_tpa_prot",
    "special  CBF76880           embl_tpa_prot",
    "special  CBF76882           embl_tpa_prot",
    "special  CBF76884-CBF76885  embl_tpa_prot",
    "special  CBF76887           embl_tpa_prot",
    "special  CBF76889           embl_tpa_prot",
    "special  CBF76891           embl_tpa_prot",
    "special  CBF76893           embl_tpa_prot",
    "special  CBF76895           embl_tpa_prot",
    "special  CBF76897           embl_tpa_prot",
    "special  CBF76899           embl_tpa_prot",
    "special  CBF76901           embl_tpa_prot",
    "special  CBF76903-CBF76904  embl_tpa_prot",
    "special  CBF76906           embl_tpa_prot",
    "special  CBF76908           embl_tpa_prot",
    "special  CBF76910           embl_tpa_prot",
    "special  CBF76912           embl_tpa_prot",
    "special  CBF76914           embl_tpa_prot",
    "special  CBF76916           embl_tpa_prot",
    "special  CBF76918           embl_tpa_prot",
    "special  CBF76920           embl_tpa_prot",
    "special  CBF76922           embl_tpa_prot",
    "special  CBF76924           embl_tpa_prot",
    "special  CBF76926           embl_tpa_prot",
    "special  CBF76928           embl_tpa_prot",
    "special  CBF76930           embl_tpa_prot",
    "special  CBF76932           embl_tpa_prot",
    "special  CBF76934           embl_tpa_prot",
    "special  CBF76936           embl_tpa_prot",
    "special  CBF76938           embl_tpa_prot",
    "special  CBF76940           embl_tpa_prot",
    "special  CBF76942           embl_tpa_prot",
    "special  CBF76944-CBF76945  embl_tpa_prot",
    "special  CBF76947           embl_tpa_prot",
    "special  CBF76949           embl_tpa_prot",
    "special  CBF76951           embl_tpa_prot",
    "special  CBF76953           embl_tpa_prot",
    "special  CBF76955           embl_tpa_prot",
    "special  CBF76957           embl_tpa_prot",
    "special  CBF76959           embl_tpa_prot",
    "special  CBF76961           embl_tpa_prot",
    "special  CBF76963           embl_tpa_prot",
    "special  CBF76965           embl_tpa_prot",
    "special  CBF76967           embl_tpa_prot",
    "special  CBF76969           embl_tpa_prot",
    "special  CBF76971           embl_tpa_prot",
    "special  CBF76973           embl_tpa_prot",
    "special  CBF76975           embl_tpa_prot",
    "special  CBF76977           embl_tpa_prot",
    "special  CBF76979           embl_tpa_prot",
    "special  CBF76981           embl_tpa_prot",
    "special  CBF76983           embl_tpa_prot",
    "special  CBF76985           embl_tpa_prot",
    "special  CBF76987-CBF76988  embl_tpa_prot",
    "special  CBF76990           embl_tpa_prot",
    "special  CBF76992           embl_tpa_prot",
    "special  CBF76994           embl_tpa_prot",
    "special  CBF76996           embl_tpa_prot",
    "special  CBF76998           embl_tpa_prot",
    "special  CBF77000           embl_tpa_prot",
    "special  CBF77002           embl_tpa_prot",
    "special  CBF77004           embl_tpa_prot",
    "special  CBF77006           embl_tpa_prot",
    "special  CBF77008           embl_tpa_prot",
    "special  CBF77010           embl_tpa_prot",
    "special  CBF77012           embl_tpa_prot",
    "special  CBF77014           embl_tpa_prot",
    "special  CBF77016           embl_tpa_prot",
    "special  CBF77018           embl_tpa_prot",
    "special  CBF77020           embl_tpa_prot",
    "special  CBF77022           embl_tpa_prot",
    "special  CBF77024           embl_tpa_prot",
    "special  CBF77026-CBF77027  embl_tpa_prot",
    "special  CBF77029           embl_tpa_prot",
    "special  CBF77031           embl_tpa_prot",
    "special  CBF77033           embl_tpa_prot",
    "special  CBF77035           embl_tpa_prot",
    "special  CBF77037           embl_tpa_prot",
    "special  CBF77039-CBF77040  embl_tpa_prot",
    "special  CBF77042           embl_tpa_prot",
    "special  CBF77044           embl_tpa_prot",
    "special  CBF77046-CBF77047  embl_tpa_prot",
    "special  CBF77049           embl_tpa_prot",
    "special  CBF77051           embl_tpa_prot",
    "special  CBF77053           embl_tpa_prot",
    "special  CBF77056           embl_tpa_prot",
    "special  CBF77058           embl_tpa_prot",
    "special  CBF77060           embl_tpa_prot",
    "special  CBF77062-CBF77063  embl_tpa_prot",
    "special  CBF77065           embl_tpa_prot",
    "special  CBF77067           embl_tpa_prot",
    "special  CBF77069           embl_tpa_prot",
    "special  CBF77071           embl_tpa_prot",
    "special  CBF77073           embl_tpa_prot",
    "special  CBF77075           embl_tpa_prot",
    "special  CBF77077           embl_tpa_prot",
    "special  CBF77079           embl_tpa_prot",
    "special  CBF77081           embl_tpa_prot",
    "special  CBF77083           embl_tpa_prot",
    "special  CBF77085           embl_tpa_prot",
    "special  CBF77087-CBF77088  embl_tpa_prot",
    "special  CBF77090           embl_tpa_prot",
    "special  CBF77092           embl_tpa_prot",
    "special  CBF77094           embl_tpa_prot",
    "special  CBF77096           embl_tpa_prot",
    "special  CBF77098           embl_tpa_prot",
    "special  CBF77100           embl_tpa_prot",
    "special  CBF77102           embl_tpa_prot",
    "special  CBF77104           embl_tpa_prot",
    "special  CBF77106           embl_tpa_prot",
    "special  CBF77108           embl_tpa_prot",
    "special  CBF77110           embl_tpa_prot",
    "special  CBF77112           embl_tpa_prot",
    "special  CBF77114           embl_tpa_prot",
    "special  CBF77116           embl_tpa_prot",
    "special  CBF77118           embl_tpa_prot",
    "special  CBF77120           embl_tpa_prot",
    "special  CBF77122           embl_tpa_prot",
    "special  CBF77124-CBF77125  embl_tpa_prot",
    "special  CBF77127           embl_tpa_prot",
    "special  CBF77129           embl_tpa_prot",
    "special  CBF77131           embl_tpa_prot",
    "special  CBF77133           embl_tpa_prot",
    "special  CBF77135           embl_tpa_prot",
    "special  CBF77137           embl_tpa_prot",
    "special  CBF77139           embl_tpa_prot",
    "special  CBF77141           embl_tpa_prot",
    "special  CBF77143-CBF77144  embl_tpa_prot",
    "special  CBF77146           embl_tpa_prot",
    "special  CBF77148           embl_tpa_prot",
    "special  CBF77150           embl_tpa_prot",
    "special  CBF77152           embl_tpa_prot",
    "special  CBF77154           embl_tpa_prot",
    "special  CBF77156           embl_tpa_prot",
    "special  CBF77158           embl_tpa_prot",
    "special  CBF77160           embl_tpa_prot",
    "special  CBF77162           embl_tpa_prot",
    "special  CBF77164-CBF77165  embl_tpa_prot",
    "special  CBF77167           embl_tpa_prot",
    "special  CBF77169           embl_tpa_prot",
    "special  CBF77171           embl_tpa_prot",
    "special  CBF77173           embl_tpa_prot",
    "special  CBF77175           embl_tpa_prot",
    "special  CBF77177           embl_tpa_prot",
    "special  CBF77179           embl_tpa_prot",
    "special  CBF77181           embl_tpa_prot",
    "special  CBF77183           embl_tpa_prot",
    "special  CBF77185           embl_tpa_prot",
    "special  CBF77187           embl_tpa_prot",
    "special  CBF77189           embl_tpa_prot",
    "special  CBF77191           embl_tpa_prot",
    "special  CBF77193           embl_tpa_prot",
    "special  CBF77195           embl_tpa_prot",
    "special  CBF77197           embl_tpa_prot",
    "special  CBF77199           embl_tpa_prot",
    "special  CBF77201           embl_tpa_prot",
    "special  CBF77203           embl_tpa_prot",
    "special  CBF77205           embl_tpa_prot",
    "special  CBF77207           embl_tpa_prot",
    "special  CBF77209           embl_tpa_prot",
    "special  CBF77211           embl_tpa_prot",
    "special  CBF77213           embl_tpa_prot",
    "special  CBF77215           embl_tpa_prot",
    "special  CBF77217           embl_tpa_prot",
    "special  CBF77219-CBF77220  embl_tpa_prot",
    "special  CBF77222           embl_tpa_prot",
    "special  CBF77224           embl_tpa_prot",
    "special  CBF77226           embl_tpa_prot",
    "special  CBF77228           embl_tpa_prot",
    "special  CBF77230           embl_tpa_prot",
    "special  CBF77232           embl_tpa_prot",
    "special  CBF77234           embl_tpa_prot",
    "special  CBF77236           embl_tpa_prot",
    "special  CBF77238           embl_tpa_prot",
    "special  CBF77240           embl_tpa_prot",
    "special  CBF77242           embl_tpa_prot",
    "special  CBF77244           embl_tpa_prot",
    "special  CBF77246           embl_tpa_prot",
    "special  CBF77248           embl_tpa_prot",
    "special  CBF77250           embl_tpa_prot",
    "special  CBF77252           embl_tpa_prot",
    "special  CBF77254           embl_tpa_prot",
    "special  CBF77256           embl_tpa_prot",
    "special  CBF77258           embl_tpa_prot",
    "special  CBF77260           embl_tpa_prot",
    "special  CBF77262-CBF77263  embl_tpa_prot",
    "special  CBF77265           embl_tpa_prot",
    "special  CBF77267           embl_tpa_prot",
    "special  CBF77269           embl_tpa_prot",
    "special  CBF77271           embl_tpa_prot",
    "special  CBF77273           embl_tpa_prot",
    "special  CBF77275           embl_tpa_prot",
    "special  CBF77277           embl_tpa_prot",
    "special  CBF77279           embl_tpa_prot",
    "special  CBF77281           embl_tpa_prot",
    "special  CBF77283           embl_tpa_prot",
    "special  CBF77285-CBF77286  embl_tpa_prot",
    "special  CBF77288           embl_tpa_prot",
    "special  CBF77290           embl_tpa_prot",
    "special  CBF77292           embl_tpa_prot",
    "special  CBF77294           embl_tpa_prot",
    "special  CBF77296           embl_tpa_prot",
    "special  CBF77298           embl_tpa_prot",
    "special  CBF77300           embl_tpa_prot",
    "special  CBF77302           embl_tpa_prot",
    "special  CBF77304           embl_tpa_prot",
    "special  CBF77306           embl_tpa_prot",
    "special  CBF77308           embl_tpa_prot",
    "special  CBF77310           embl_tpa_prot",
    "special  CBF77312           embl_tpa_prot",
    "special  CBF77314           embl_tpa_prot",
    "special  CBF77316           embl_tpa_prot",
    "special  CBF77318           embl_tpa_prot",
    "special  CBF77320           embl_tpa_prot",
    "special  CBF77322           embl_tpa_prot",
    "special  CBF77324           embl_tpa_prot",
    "special  CBF77326           embl_tpa_prot",
    "special  CBF77328           embl_tpa_prot",
    "special  CBF77330-CBF77331  embl_tpa_prot",
    "special  CBF77333           embl_tpa_prot",
    "special  CBF77335           embl_tpa_prot",
    "special  CBF77337           embl_tpa_prot",
    "special  CBF77339           embl_tpa_prot",
    "special  CBF77341           embl_tpa_prot",
    "special  CBF77343           embl_tpa_prot",
    "special  CBF77345           embl_tpa_prot",
    "special  CBF77347           embl_tpa_prot",
    "special  CBF77349           embl_tpa_prot",
    "special  CBF77351           embl_tpa_prot",
    "special  CBF77353-CBF77354  embl_tpa_prot",
    "special  CBF77356           embl_tpa_prot",
    "special  CBF77358           embl_tpa_prot",
    "special  CBF77360           embl_tpa_prot",
    "special  CBF77362           embl_tpa_prot",
    "special  CBF77364           embl_tpa_prot",
    "special  CBF77366-CBF77367  embl_tpa_prot",
    "special  CBF77369           embl_tpa_prot",
    "special  CBF77371           embl_tpa_prot",
    "special  CBF77373           embl_tpa_prot",
    "special  CBF77375-CBF77376  embl_tpa_prot",
    "special  CBF77378-CBF77379  embl_tpa_prot",
    "special  CBF77381           embl_tpa_prot",
    "special  CBF77383           embl_tpa_prot",
    "special  CBF77385-CBF77386  embl_tpa_prot",
    "special  CBF77388           embl_tpa_prot",
    "special  CBF77390           embl_tpa_prot",
    "special  CBF77392           embl_tpa_prot",
    "special  CBF77394           embl_tpa_prot",
    "special  CBF77396           embl_tpa_prot",
    "special  CBF77398           embl_tpa_prot",
    "special  CBF77400           embl_tpa_prot",
    "special  CBF77402           embl_tpa_prot",
    "special  CBF77404           embl_tpa_prot",
    "special  CBF77406           embl_tpa_prot",
    "special  CBF77408           embl_tpa_prot",
    "special  CBF77410           embl_tpa_prot",
    "special  CBF77412           embl_tpa_prot",
    "special  CBF77414           embl_tpa_prot",
    "special  CBF77416           embl_tpa_prot",
    "special  CBF77418           embl_tpa_prot",
    "special  CBF77420           embl_tpa_prot",
    "special  CBF77422           embl_tpa_prot",
    "special  CBF77424           embl_tpa_prot",
    "special  CBF77426           embl_tpa_prot",
    "special  CBF77428           embl_tpa_prot",
    "special  CBF77430           embl_tpa_prot",
    "special  CBF77432           embl_tpa_prot",
    "special  CBF77434           embl_tpa_prot",
    "special  CBF77436           embl_tpa_prot",
    "special  CBF77438           embl_tpa_prot",
    "special  CBF77440           embl_tpa_prot",
    "special  CBF77442           embl_tpa_prot",
    "special  CBF77444           embl_tpa_prot",
    "special  CBF77446           embl_tpa_prot",
    "special  CBF77448           embl_tpa_prot",
    "special  CBF77450           embl_tpa_prot",
    "special  CBF77452-CBF77453  embl_tpa_prot",
    "special  CBF77455           embl_tpa_prot",
    "special  CBF77457           embl_tpa_prot",
    "special  CBF77459           embl_tpa_prot",
    "special  CBF77461           embl_tpa_prot",
    "special  CBF77463           embl_tpa_prot",
    "special  CBF77465           embl_tpa_prot",
    "special  CBF77467           embl_tpa_prot",
    "special  CBF77469           embl_tpa_prot",
    "special  CBF77471           embl_tpa_prot",
    "special  CBF77473           embl_tpa_prot",
    "special  CBF77475           embl_tpa_prot",
    "special  CBF77477           embl_tpa_prot",
    "special  CBF77479           embl_tpa_prot",
    "special  CBF77481           embl_tpa_prot",
    "special  CBF77483           embl_tpa_prot",
    "special  CBF77485           embl_tpa_prot",
    "special  CBF77488           embl_tpa_prot",
    "special  CBF77490           embl_tpa_prot",
    "special  CBF77492           embl_tpa_prot",
    "special  CBF77494           embl_tpa_prot",
    "special  CBF77496           embl_tpa_prot",
    "special  CBF77498           embl_tpa_prot",
    "special  CBF77500           embl_tpa_prot",
    "special  CBF77502           embl_tpa_prot",
    "special  CBF77504           embl_tpa_prot",
    "special  CBF77506           embl_tpa_prot",
    "special  CBF77508           embl_tpa_prot",
    "special  CBF77510           embl_tpa_prot",
    "special  CBF77512           embl_tpa_prot",
    "special  CBF77514           embl_tpa_prot",
    "special  CBF77516           embl_tpa_prot",
    "special  CBF77518           embl_tpa_prot",
    "special  CBF77520           embl_tpa_prot",
    "special  CBF77522           embl_tpa_prot",
    "special  CBF77524           embl_tpa_prot",
    "special  CBF77526           embl_tpa_prot",
    "special  CBF77528           embl_tpa_prot",
    "special  CBF77530           embl_tpa_prot",
    "special  CBF77532           embl_tpa_prot",
    "special  CBF77534           embl_tpa_prot",
    "special  CBF77536           embl_tpa_prot",
    "special  CBF77538           embl_tpa_prot",
    "special  CBF77540           embl_tpa_prot",
    "special  CBF77542-CBF77543  embl_tpa_prot",
    "special  CBF77545           embl_tpa_prot",
    "special  CBF77547           embl_tpa_prot",
    "special  CBF77549           embl_tpa_prot",
    "special  CBF77551           embl_tpa_prot",
    "special  CBF77553           embl_tpa_prot",
    "special  CBF77555           embl_tpa_prot",
    "special  CBF77557           embl_tpa_prot",
    "special  CBF77559           embl_tpa_prot",
    "special  CBF77561           embl_tpa_prot",
    "special  CBF77563           embl_tpa_prot",
    "special  CBF77565           embl_tpa_prot",
    "special  CBF77567           embl_tpa_prot",
    "special  CBF77569           embl_tpa_prot",
    "special  CBF77571           embl_tpa_prot",
    "special  CBF77573-CBF77574  embl_tpa_prot",
    "special  CBF77576           embl_tpa_prot",
    "special  CBF77578           embl_tpa_prot",
    "special  CBF77580           embl_tpa_prot",
    "special  CBF77582           embl_tpa_prot",
    "special  CBF77584           embl_tpa_prot",
    "special  CBF77586           embl_tpa_prot",
    "special  CBF77588           embl_tpa_prot",
    "special  CBF77590           embl_tpa_prot",
    "special  CBF77592           embl_tpa_prot",
    "special  CBF77594           embl_tpa_prot",
    "special  CBF77596           embl_tpa_prot",
    "special  CBF77598           embl_tpa_prot",
    "special  CBF77600           embl_tpa_prot",
    "special  CBF77602           embl_tpa_prot",
    "special  CBF77604           embl_tpa_prot",
    "special  CBF77606           embl_tpa_prot",
    "special  CBF77608           embl_tpa_prot",
    "special  CBF77610           embl_tpa_prot",
    "special  CBF77612           embl_tpa_prot",
    "special  CBF77614           embl_tpa_prot",
    "special  CBF77616           embl_tpa_prot",
    "special  CBF77618           embl_tpa_prot",
    "special  CBF77620           embl_tpa_prot",
    "special  CBF77622           embl_tpa_prot",
    "special  CBF77624           embl_tpa_prot",
    "special  CBF77626-CBF77627  embl_tpa_prot",
    "special  CBF77629           embl_tpa_prot",
    "special  CBF77631           embl_tpa_prot",
    "special  CBF77633           embl_tpa_prot",
    "special  CBF77635           embl_tpa_prot",
    "special  CBF77637           embl_tpa_prot",
    "special  CBF77639           embl_tpa_prot",
    "special  CBF77641           embl_tpa_prot",
    "special  CBF77643           embl_tpa_prot",
    "special  CBF77645           embl_tpa_prot",
    "special  CBF77647           embl_tpa_prot",
    "special  CBF77649           embl_tpa_prot",
    "special  CBF77651           embl_tpa_prot",
    "special  CBF77653           embl_tpa_prot",
    "special  CBF77655           embl_tpa_prot",
    "special  CBF77657           embl_tpa_prot",
    "special  CBF77659           embl_tpa_prot",
    "special  CBF77661-CBF77662  embl_tpa_prot",
    "special  CBF77664           embl_tpa_prot",
    "special  CBF77666           embl_tpa_prot",
    "special  CBF77668           embl_tpa_prot",
    "special  CBF77670           embl_tpa_prot",
    "special  CBF77672           embl_tpa_prot",
    "special  CBF77674           embl_tpa_prot",
    "special  CBF77676           embl_tpa_prot",
    "special  CBF77678           embl_tpa_prot",
    "special  CBF77680           embl_tpa_prot",
    "special  CBF77682           embl_tpa_prot",
    "special  CBF77684           embl_tpa_prot",
    "special  CBF77686           embl_tpa_prot",
    "special  CBF77688           embl_tpa_prot",
    "special  CBF77690           embl_tpa_prot",
    "special  CBF77692           embl_tpa_prot",
    "special  CBF77694           embl_tpa_prot",
    "special  CBF77696           embl_tpa_prot",
    "special  CBF77698-CBF77699  embl_tpa_prot",
    "special  CBF77701           embl_tpa_prot",
    "special  CBF77703           embl_tpa_prot",
    "special  CBF77705           embl_tpa_prot",
    "special  CBF77707           embl_tpa_prot",
    "special  CBF77709           embl_tpa_prot",
    "special  CBF77711           embl_tpa_prot",
    "special  CBF77713           embl_tpa_prot",
    "special  CBF77715-CBF77716  embl_tpa_prot",
    "special  CBF77718           embl_tpa_prot",
    "special  CBF77720           embl_tpa_prot",
    "special  CBF77722           embl_tpa_prot",
    "special  CBF77724           embl_tpa_prot",
    "special  CBF77726           embl_tpa_prot",
    "special  CBF77728           embl_tpa_prot",
    "special  CBF77730           embl_tpa_prot",
    "special  CBF77732           embl_tpa_prot",
    "special  CBF77734           embl_tpa_prot",
    "special  CBF77736           embl_tpa_prot",
    "special  CBF77738-CBF77739  embl_tpa_prot",
    "special  CBF77741           embl_tpa_prot",
    "special  CBF77743           embl_tpa_prot",
    "special  CBF77745           embl_tpa_prot",
    "special  CBF77747           embl_tpa_prot",
    "special  CBF77749           embl_tpa_prot",
    "special  CBF77751           embl_tpa_prot",
    "special  CBF77753-CBF77754  embl_tpa_prot",
    "special  CBF77756           embl_tpa_prot",
    "special  CBF77758           embl_tpa_prot",
    "special  CBF77760           embl_tpa_prot",
    "special  CBF77762           embl_tpa_prot",
    "special  CBF77764           embl_tpa_prot",
    "special  CBF77766           embl_tpa_prot",
    "special  CBF77768           embl_tpa_prot",
    "special  CBF77770           embl_tpa_prot",
    "special  CBF77772-CBF77773  embl_tpa_prot",
    "special  CBF77775           embl_tpa_prot",
    "special  CBF77777           embl_tpa_prot",
    "special  CBF77779           embl_tpa_prot",
    "special  CBF77781           embl_tpa_prot",
    "special  CBF77783           embl_tpa_prot",
    "special  CBF77785-CBF77786  embl_tpa_prot",
    "special  CBF77788           embl_tpa_prot",
    "special  CBF77790           embl_tpa_prot",
    "special  CBF77792           embl_tpa_prot",
    "special  CBF77794           embl_tpa_prot",
    "special  CBF77796           embl_tpa_prot",
    "special  CBF77798           embl_tpa_prot",
    "special  CBF77800           embl_tpa_prot",
    "special  CBF77802-CBF77803  embl_tpa_prot",
    "special  CBF77805           embl_tpa_prot",
    "special  CBF77807           embl_tpa_prot",
    "special  CBF77809           embl_tpa_prot",
    "special  CBF77811           embl_tpa_prot",
    "special  CBF77813           embl_tpa_prot",
    "special  CBF77815           embl_tpa_prot",
    "special  CBF77817           embl_tpa_prot",
    "special  CBF77819           embl_tpa_prot",
    "special  CBF77821-CBF77822  embl_tpa_prot",
    "special  CBF77824           embl_tpa_prot",
    "special  CBF77827           embl_tpa_prot",
    "special  CBF77829           embl_tpa_prot",
    "special  CBF77831           embl_tpa_prot",
    "special  CBF77833           embl_tpa_prot",
    "special  CBF77835-CBF77836  embl_tpa_prot",
    "special  CBF77838           embl_tpa_prot",
    "special  CBF77840           embl_tpa_prot",
    "special  CBF77842           embl_tpa_prot",
    "special  CBF77844           embl_tpa_prot",
    "special  CBF77846-CBF77847  embl_tpa_prot",
    "special  CBF77849           embl_tpa_prot",
    "special  CBF77851           embl_tpa_prot",
    "special  CBF77853           embl_tpa_prot",
    "special  CBF77855           embl_tpa_prot",
    "special  CBF77857           embl_tpa_prot",
    "special  CBF77859           embl_tpa_prot",
    "special  CBF77861           embl_tpa_prot",
    "special  CBF77863           embl_tpa_prot",
    "special  CBF77865           embl_tpa_prot",
    "special  CBF77867           embl_tpa_prot",
    "special  CBF77869-CBF77870  embl_tpa_prot",
    "special  CBF77872           embl_tpa_prot",
    "special  CBF77874           embl_tpa_prot",
    "special  CBF77876           embl_tpa_prot",
    "special  CBF77878           embl_tpa_prot",
    "special  CBF77880           embl_tpa_prot",
    "special  CBF77883           embl_tpa_prot",
    "special  CBF77885-CBF77886  embl_tpa_prot",
    "special  CBF77888           embl_tpa_prot",
    "special  CBF77890           embl_tpa_prot",
    "special  CBF77892           embl_tpa_prot",
    "special  CBF77894           embl_tpa_prot",
    "special  CBF77896           embl_tpa_prot",
    "special  CBF77898           embl_tpa_prot",
    "special  CBF77900           embl_tpa_prot",
    "special  CBF77902           embl_tpa_prot",
    "special  CBF77904           embl_tpa_prot",
    "special  CBF77906-CBF77907  embl_tpa_prot",
    "special  CBF77909           embl_tpa_prot",
    "special  CBF77911           embl_tpa_prot",
    "special  CBF77913           embl_tpa_prot",
    "special  CBF77915           embl_tpa_prot",
    "special  CBF77917           embl_tpa_prot",
    "special  CBF77919           embl_tpa_prot",
    "special  CBF77921           embl_tpa_prot",
    "special  CBF77923           embl_tpa_prot",
    "special  CBF77925-CBF77926  embl_tpa_prot",
    "special  CBF77928           embl_tpa_prot",
    "special  CBF77930           embl_tpa_prot",
    "special  CBF77932           embl_tpa_prot",
    "special  CBF77934           embl_tpa_prot",
    "special  CBF77936           embl_tpa_prot",
    "special  CBF77938           embl_tpa_prot",
    "special  CBF77940-CBF77941  embl_tpa_prot",
    "special  CBF77943           embl_tpa_prot",
    "special  CBF77945           embl_tpa_prot",
    "special  CBF77947           embl_tpa_prot",
    "special  CBF77949           embl_tpa_prot",
    "special  CBF77951           embl_tpa_prot",
    "special  CBF77953           embl_tpa_prot",
    "special  CBF77955-CBF77956  embl_tpa_prot",
    "special  CBF77958           embl_tpa_prot",
    "special  CBF77960           embl_tpa_prot",
    "special  CBF77962           embl_tpa_prot",
    "special  CBF77964           embl_tpa_prot",
    "special  CBF77966           embl_tpa_prot",
    "special  CBF77968-CBF77969  embl_tpa_prot",
    "special  CBF77971           embl_tpa_prot",
    "special  CBF77973           embl_tpa_prot",
    "special  CBF77975           embl_tpa_prot",
    "special  CBF77977           embl_tpa_prot",
    "special  CBF77979           embl_tpa_prot",
    "special  CBF77981           embl_tpa_prot",
    "special  CBF77983           embl_tpa_prot",
    "special  CBF77985           embl_tpa_prot",
    "special  CBF77987-CBF77988  embl_tpa_prot",
    "special  CBF77990           embl_tpa_prot",
    "special  CBF77992           embl_tpa_prot",
    "special  CBF77994           embl_tpa_prot",
    "special  CBF77996           embl_tpa_prot",
    "special  CBF77998-CBF77999  embl_tpa_prot",
    "special  CBF78001           embl_tpa_prot",
    "special  CBF78003           embl_tpa_prot",
    "special  CBF78005           embl_tpa_prot",
    "special  CBF78007           embl_tpa_prot",
    "special  CBF78009           embl_tpa_prot",
    "special  CBF78011           embl_tpa_prot",
    "special  CBF78013-CBF78014  embl_tpa_prot",
    "special  CBF78016           embl_tpa_prot",
    "special  CBF78018           embl_tpa_prot",
    "special  CBF78020           embl_tpa_prot",
    "special  CBF78022           embl_tpa_prot",
    "special  CBF78024           embl_tpa_prot",
    "special  CBF78026-CBF78027  embl_tpa_prot",
    "special  CBF78029           embl_tpa_prot",
    "special  CBF78031           embl_tpa_prot",
    "special  CBF78033           embl_tpa_prot",
    "special  CBF78035           embl_tpa_prot",
    "special  CBF78037           embl_tpa_prot",
    "special  CBF78039           embl_tpa_prot",
    "special  CBF78041           embl_tpa_prot",
    "special  CBF78043           embl_tpa_prot",
    "special  CBF78045-CBF78046  embl_tpa_prot",
    "special  CBF78048           embl_tpa_prot",
    "special  CBF78050           embl_tpa_prot",
    "special  CBF78052           embl_tpa_prot",
    "special  CBF78054           embl_tpa_prot",
    "special  CBF78056           embl_tpa_prot",
    "special  CBF78058           embl_tpa_prot",
    "special  CBF78060-CBF78061  embl_tpa_prot",
    "special  CBF78063           embl_tpa_prot",
    "special  CBF78065           embl_tpa_prot",
    "special  CBF78067           embl_tpa_prot",
    "special  CBF78069           embl_tpa_prot",
    "special  CBF78071-CBF78072  embl_tpa_prot",
    "special  CBF78074           embl_tpa_prot",
    "special  CBF78076           embl_tpa_prot",
    "special  CBF78078           embl_tpa_prot",
    "special  CBF78080-CBF78081  embl_tpa_prot",
    "special  CBF78083           embl_tpa_prot",
    "special  CBF78085           embl_tpa_prot",
    "special  CBF78087-CBF78088  embl_tpa_prot",
    "special  CBF78090           embl_tpa_prot",
    "special  CBF78092           embl_tpa_prot",
    "special  CBF78094           embl_tpa_prot",
    "special  CBF78096           embl_tpa_prot",
    "special  CBF78098           embl_tpa_prot",
    "special  CBF78100           embl_tpa_prot",
    "special  CBF78102-CBF78103  embl_tpa_prot",
    "special  CBF78105           embl_tpa_prot",
    "special  CBF78107           embl_tpa_prot",
    "special  CBF78110           embl_tpa_prot",
    "special  CBF78112           embl_tpa_prot",
    "special  CBF78114           embl_tpa_prot",
    "special  CBF78116           embl_tpa_prot",
    "special  CBF78118           embl_tpa_prot",
    "special  CBF78120           embl_tpa_prot",
    "special  CBF78122-CBF78123  embl_tpa_prot",
    "special  CBF78125           embl_tpa_prot",
    "special  CBF78127           embl_tpa_prot",
    "special  CBF78129           embl_tpa_prot",
    "special  CBF78131           embl_tpa_prot",
    "special  CBF78133           embl_tpa_prot",
    "special  CBF78135-CBF78136  embl_tpa_prot",
    "special  CBF78138           embl_tpa_prot",
    "special  CBF78140           embl_tpa_prot",
    "special  CBF78142           embl_tpa_prot",
    "special  CBF78144           embl_tpa_prot",
    "special  CBF78146           embl_tpa_prot",
    "special  CBF78148           embl_tpa_prot",
    "special  CBF78150           embl_tpa_prot",
    "special  CBF78152-CBF78153  embl_tpa_prot",
    "special  CBF78155           embl_tpa_prot",
    "special  CBF78157           embl_tpa_prot",
    "special  CBF78159           embl_tpa_prot",
    "special  CBF78161           embl_tpa_prot",
    "special  CBF78163           embl_tpa_prot",
    "special  CBF78165           embl_tpa_prot",
    "special  CBF78167           embl_tpa_prot",
    "special  CBF78169-CBF78170  embl_tpa_prot",
    "special  CBF78172           embl_tpa_prot",
    "special  CBF78174           embl_tpa_prot",
    "special  CBF78176           embl_tpa_prot",
    "special  CBF78178           embl_tpa_prot",
    "special  CBF78180           embl_tpa_prot",
    "special  CBF78182-CBF78183  embl_tpa_prot",
    "special  CBF78185           embl_tpa_prot",
    "special  CBF78187           embl_tpa_prot",
    "special  CBF78189           embl_tpa_prot",
    "special  CBF78191           embl_tpa_prot",
    "special  CBF78193           embl_tpa_prot",
    "special  CBF78195           embl_tpa_prot",
    "special  CBF78197           embl_tpa_prot",
    "special  CBF78199-CBF78200  embl_tpa_prot",
    "special  CBF78202           embl_tpa_prot",
    "special  CBF78204           embl_tpa_prot",
    "special  CBF78206           embl_tpa_prot",
    "special  CBF78208           embl_tpa_prot",
    "special  CBF78210           embl_tpa_prot",
    "special  CBF78212-CBF78213  embl_tpa_prot",
    "special  CBF78215           embl_tpa_prot",
    "special  CBF78217           embl_tpa_prot",
    "special  CBF78219           embl_tpa_prot",
    "special  CBF78221           embl_tpa_prot",
    "special  CBF78223-CBF78224  embl_tpa_prot",
    "special  CBF78226           embl_tpa_prot",
    "special  CBF78228           embl_tpa_prot",
    "special  CBF78230           embl_tpa_prot",
    "special  CBF78232           embl_tpa_prot",
    "special  CBF78234           embl_tpa_prot",
    "special  CBF78236           embl_tpa_prot",
    "special  CBF78238           embl_tpa_prot",
    "special  CBF78240           embl_tpa_prot",
    "special  CBF78242           embl_tpa_prot",
    "special  CBF78244-CBF78245  embl_tpa_prot",
    "special  CBF78247           embl_tpa_prot",
    "special  CBF78249           embl_tpa_prot",
    "special  CBF78251           embl_tpa_prot",
    "special  CBF78253           embl_tpa_prot",
    "special  CBF78256           embl_tpa_prot",
    "special  CBF78258           embl_tpa_prot",
    "special  CBF78260-CBF78261  embl_tpa_prot",
    "special  CBF78263           embl_tpa_prot",
    "special  CBF78265           embl_tpa_prot",
    "special  CBF78267           embl_tpa_prot",
    "special  CBF78269           embl_tpa_prot",
    "special  CBF78271           embl_tpa_prot",
    "special  CBF78273           embl_tpa_prot",
    "special  CBF78275           embl_tpa_prot",
    "special  CBF78277           embl_tpa_prot",
    "special  CBF78279-CBF78280  embl_tpa_prot",
    "special  CBF78282           embl_tpa_prot",
    "special  CBF78284           embl_tpa_prot",
    "special  CBF78286           embl_tpa_prot",
    "special  CBF78288           embl_tpa_prot",
    "special  CBF78290           embl_tpa_prot",
    "special  CBF78292           embl_tpa_prot",
    "special  CBF78294           embl_tpa_prot",
    "special  CBF78296           embl_tpa_prot",
    "special  CBF78298-CBF78299  embl_tpa_prot",
    "special  CBF78301           embl_tpa_prot",
    "special  CBF78303           embl_tpa_prot",
    "special  CBF78305           embl_tpa_prot",
    "special  CBF78307           embl_tpa_prot",
    "special  CBF78309           embl_tpa_prot",
    "special  CBF78311-CBF78312  embl_tpa_prot",
    "special  CBF78314           embl_tpa_prot",
    "special  CBF78316           embl_tpa_prot",
    "special  CBF78318           embl_tpa_prot",
    "special  CBF78320           embl_tpa_prot",
    "special  CBF78322           embl_tpa_prot",
    "special  CBF78324           embl_tpa_prot",
    "special  CBF78326           embl_tpa_prot",
    "special  CBF78328-CBF78329  embl_tpa_prot",
    "special  CBF78331           embl_tpa_prot",
    "special  CBF78333           embl_tpa_prot",
    "special  CBF78335           embl_tpa_prot",
    "special  CBF78337           embl_tpa_prot",
    "special  CBF78339           embl_tpa_prot",
    "special  CBF78341           embl_tpa_prot",
    "special  CBF78343-CBF78344  embl_tpa_prot",
    "special  CBF78346           embl_tpa_prot",
    "special  CBF78348           embl_tpa_prot",
    "special  CBF78350           embl_tpa_prot",
    "special  CBF78352           embl_tpa_prot",
    "special  CBF78354           embl_tpa_prot",
    "special  CBF78356           embl_tpa_prot",
    "special  CBF78358           embl_tpa_prot",
    "special  CBF78360-CBF78361  embl_tpa_prot",
    "special  CBF78363           embl_tpa_prot",
    "special  CBF78365           embl_tpa_prot",
    "special  CBF78367           embl_tpa_prot",
    "special  CBF78369           embl_tpa_prot",
    "special  CBF78371           embl_tpa_prot",
    "special  CBF78373           embl_tpa_prot",
    "special  CBF78375           embl_tpa_prot",
    "special  CBF78377           embl_tpa_prot",
    "special  CBF78379           embl_tpa_prot",
    "special  CBF78381-CBF78382  embl_tpa_prot",
    "special  CBF78384           embl_tpa_prot",
    "special  CBF78386           embl_tpa_prot",
    "special  CBF78388           embl_tpa_prot",
    "special  CBF78390           embl_tpa_prot",
    "special  CBF78392-CBF78393  embl_tpa_prot",
    "special  CBF78395           embl_tpa_prot",
    "special  CBF78397           embl_tpa_prot",
    "special  CBF78399           embl_tpa_prot",
    "special  CBF78401           embl_tpa_prot",
    "special  CBF78403           embl_tpa_prot",
    "special  CBF78409           embl_tpa_prot",
    "special  CBF78411-CBF78412  embl_tpa_prot",
    "special  CBF78414-CBF78415  embl_tpa_prot",
    "special  CBF78417           embl_tpa_prot",
    "special  CBF78419-CBF78421  embl_tpa_prot",
    "special  CBF78423           embl_tpa_prot",
    "special  CBF78425           embl_tpa_prot",
    "special  CBF78427           embl_tpa_prot",
    "special  CBF78429           embl_tpa_prot",
    "special  CBF78431           embl_tpa_prot",
    "special  CBF78433           embl_tpa_prot",
    "special  CBF78435           embl_tpa_prot",
    "special  CBF78437           embl_tpa_prot",
    "special  CBF78439           embl_tpa_prot",
    "special  CBF78441           embl_tpa_prot",
    "special  CBF78443           embl_tpa_prot",
    "special  CBF78445           embl_tpa_prot",
    "special  CBF78447           embl_tpa_prot",
    "special  CBF78449           embl_tpa_prot",
    "special  CBF78451           embl_tpa_prot",
    "special  CBF78453           embl_tpa_prot",
    "special  CBF78455           embl_tpa_prot",
    "special  CBF78457           embl_tpa_prot",
    "special  CBF78459           embl_tpa_prot",
    "special  CBF78461           embl_tpa_prot",
    "special  CBF78463           embl_tpa_prot",
    "special  CBF78465           embl_tpa_prot",
    "special  CBF78467           embl_tpa_prot",
    "special  CBF78469-CBF78470  embl_tpa_prot",
    "special  CBF78472           embl_tpa_prot",
    "special  CBF78474           embl_tpa_prot",
    "special  CBF78476           embl_tpa_prot",
    "special  CBF78478           embl_tpa_prot",
    "special  CBF78480           embl_tpa_prot",
    "special  CBF78482           embl_tpa_prot",
    "special  CBF78484           embl_tpa_prot",
    "special  CBF78486           embl_tpa_prot",
    "special  CBF78488           embl_tpa_prot",
    "special  CBF78490           embl_tpa_prot",
    "special  CBF78492-CBF78493  embl_tpa_prot",
    "special  CBF78495           embl_tpa_prot",
    "special  CBF78497           embl_tpa_prot",
    "special  CBF78499           embl_tpa_prot",
    "special  CBF78501           embl_tpa_prot",
    "special  CBF78503           embl_tpa_prot",
    "special  CBF78505           embl_tpa_prot",
    "special  CBF78507           embl_tpa_prot",
    "special  CBF78509           embl_tpa_prot",
    "special  CBF78511           embl_tpa_prot",
    "special  CBF78513           embl_tpa_prot",
    "special  CBF78515           embl_tpa_prot",
    "special  CBF78517           embl_tpa_prot",
    "special  CBF78519           embl_tpa_prot",
    "special  CBF78521           embl_tpa_prot",
    "special  CBF78523           embl_tpa_prot",
    "special  CBF78525           embl_tpa_prot",
    "special  CBF78527-CBF78528  embl_tpa_prot",
    "special  CBF78530           embl_tpa_prot",
    "special  CBF78532           embl_tpa_prot",
    "special  CBF78534           embl_tpa_prot",
    "special  CBF78536           embl_tpa_prot",
    "special  CBF78538           embl_tpa_prot",
    "special  CBF78540           embl_tpa_prot",
    "special  CBF78542           embl_tpa_prot",
    "special  CBF78544           embl_tpa_prot",
    "special  CBF78546           embl_tpa_prot",
    "special  CBF78548           embl_tpa_prot",
    "special  CBF78550           embl_tpa_prot",
    "special  CBF78552           embl_tpa_prot",
    "special  CBF78554           embl_tpa_prot",
    "special  CBF78556           embl_tpa_prot",
    "special  CBF78558-CBF78559  embl_tpa_prot",
    "special  CBF78561           embl_tpa_prot",
    "special  CBF78563           embl_tpa_prot",
    "special  CBF78565-CBF78566  embl_tpa_prot",
    "special  CBF78568           embl_tpa_prot",
    "special  CBF78570           embl_tpa_prot",
    "special  CBF78572           embl_tpa_prot",
    "special  CBF78574           embl_tpa_prot",
    "special  CBF78576-CBF78577  embl_tpa_prot",
    "special  CBF78579           embl_tpa_prot",
    "special  CBF78581           embl_tpa_prot",
    "special  CBF78583-CBF78585  embl_tpa_prot",
    "special  CBF78587           embl_tpa_prot",
    "special  CBF78589           embl_tpa_prot",
    "special  CBF78591           embl_tpa_prot",
    "special  CBF78593-CBF78595  embl_tpa_prot",
    "special  CBF78597           embl_tpa_prot",
    "special  CBF78599           embl_tpa_prot",
    "special  CBF78601           embl_tpa_prot",
    "special  CBF78603           embl_tpa_prot",
    "special  CBF78605-CBF78606  embl_tpa_prot",
    "special  CBF78608           embl_tpa_prot",
    "special  CBF78610           embl_tpa_prot",
    "special  CBF78612           embl_tpa_prot",
    "special  CBF78614           embl_tpa_prot",
    "special  CBF78616           embl_tpa_prot",
    "special  CBF78618           embl_tpa_prot",
    "special  CBF78620-CBF78621  embl_tpa_prot",
    "special  CBF78623           embl_tpa_prot",
    "special  CBF78625           embl_tpa_prot",
    "special  CBF78627           embl_tpa_prot",
    "special  CBF78629           embl_tpa_prot",
    "special  CBF78631-CBF78632  embl_tpa_prot",
    "special  CBF78634           embl_tpa_prot",
    "special  CBF78636           embl_tpa_prot",
    "special  CBF78638           embl_tpa_prot",
    "special  CBF78640           embl_tpa_prot",
    "special  CBF78642           embl_tpa_prot",
    "special  CBF78644           embl_tpa_prot",
    "special  CBF78646           embl_tpa_prot",
    "special  CBF78648           embl_tpa_prot",
    "special  CBF78650           embl_tpa_prot",
    "special  CBF78652           embl_tpa_prot",
    "special  CBF78654           embl_tpa_prot",
    "special  CBF78656           embl_tpa_prot",
    "special  CBF78658           embl_tpa_prot",
    "special  CBF78660           embl_tpa_prot",
    "special  CBF78662-CBF78663  embl_tpa_prot",
    "special  CBF78665           embl_tpa_prot",
    "special  CBF78667           embl_tpa_prot",
    "special  CBF78669           embl_tpa_prot",
    "special  CBF78671           embl_tpa_prot",
    "special  CBF78673           embl_tpa_prot",
    "special  CBF78675-CBF78676  embl_tpa_prot",
    "special  CBF78678           embl_tpa_prot",
    "special  CBF78680           embl_tpa_prot",
    "special  CBF78682           embl_tpa_prot",
    "special  CBF78684           embl_tpa_prot",
    "special  CBF78686           embl_tpa_prot",
    "special  CBF78688           embl_tpa_prot",
    "special  CBF78690-CBF78691  embl_tpa_prot",
    "special  CBF78693           embl_tpa_prot",
    "special  CBF78695           embl_tpa_prot",
    "special  CBF78697           embl_tpa_prot",
    "special  CBF78699           embl_tpa_prot",
    "special  CBF78701           embl_tpa_prot",
    "special  CBF78703           embl_tpa_prot",
    "special  CBF78705-CBF78706  embl_tpa_prot",
    "special  CBF78708           embl_tpa_prot",
    "special  CBF78710           embl_tpa_prot",
    "special  CBF78712           embl_tpa_prot",
    "special  CBF78714           embl_tpa_prot",
    "special  CBF78716-CBF78717  embl_tpa_prot",
    "special  CBF78719           embl_tpa_prot",
    "special  CBF78721           embl_tpa_prot",
    "special  CBF78723           embl_tpa_prot",
    "special  CBF78725-CBF78726  embl_tpa_prot",
    "special  CBF78728           embl_tpa_prot",
    "special  CBF78730           embl_tpa_prot",
    "special  CBF78732           embl_tpa_prot",
    "special  CBF78734           embl_tpa_prot",
    "special  CBF78736-CBF78737  embl_tpa_prot",
    "special  CBF78739           embl_tpa_prot",
    "special  CBF78741           embl_tpa_prot",
    "special  CBF78743           embl_tpa_prot",
    "special  CBF78745           embl_tpa_prot",
    "special  CBF78747           embl_tpa_prot",
    "special  CBF78749-CBF78750  embl_tpa_prot",
    "special  CBF78752           embl_tpa_prot",
    "special  CBF78754           embl_tpa_prot",
    "special  CBF78756           embl_tpa_prot",
    "special  CBF78758           embl_tpa_prot",
    "special  CBF78760-CBF78761  embl_tpa_prot",
    "special  CBF78763           embl_tpa_prot",
    "special  CBF78765           embl_tpa_prot",
    "special  CBF78767-CBF78768  embl_tpa_prot",
    "special  CBF78770           embl_tpa_prot",
    "special  CBF78772           embl_tpa_prot",
    "special  CBF78774-CBF78775  embl_tpa_prot",
    "special  CBF78777-CBF78778  embl_tpa_prot",
    "special  CBF78780           embl_tpa_prot",
    "special  CBF78782           embl_tpa_prot",
    "special  CBF78784           embl_tpa_prot",
    "special  CBF78786           embl_tpa_prot",
    "special  CBF78788           embl_tpa_prot",
    "special  CBF78790-CBF78791  embl_tpa_prot",
    "special  CBF78793           embl_tpa_prot",
    "special  CBF78795           embl_tpa_prot",
    "special  CBF78797           embl_tpa_prot",
    "special  CBF78799           embl_tpa_prot",
    "special  CBF78801           embl_tpa_prot",
    "special  CBF78803           embl_tpa_prot",
    "special  CBF78805-CBF78807  embl_tpa_prot",
    "special  CBF78809           embl_tpa_prot",
    "special  CBF78811           embl_tpa_prot",
    "special  CBF78813           embl_tpa_prot",
    "special  CBF78815-CBF78816  embl_tpa_prot",
    "special  CBF78818           embl_tpa_prot",
    "special  CBF78820           embl_tpa_prot",
    "special  CBF78822           embl_tpa_prot",
    "special  CBF78824           embl_tpa_prot",
    "special  CBF78826-CBF78827  embl_tpa_prot",
    "special  CBF78829           embl_tpa_prot",
    "special  CBF78831           embl_tpa_prot",
    "special  CBF78833           embl_tpa_prot",
    "special  CBF78835           embl_tpa_prot",
    "special  CBF78837-CBF78838  embl_tpa_prot",
    "special  CBF78840           embl_tpa_prot",
    "special  CBF78842           embl_tpa_prot",
    "special  CBF78844           embl_tpa_prot",
    "special  CBF78846-CBF78847  embl_tpa_prot",
    "special  CBF78849           embl_tpa_prot",
    "special  CBF78851           embl_tpa_prot",
    "special  CBF78853           embl_tpa_prot",
    "special  CBF78855           embl_tpa_prot",
    "special  CBF78857           embl_tpa_prot",
    "special  CBF78859           embl_tpa_prot",
    "special  CBF78861           embl_tpa_prot",
    "special  CBF78863-CBF78864  embl_tpa_prot",
    "special  CBF78866           embl_tpa_prot",
    "special  CBF78868           embl_tpa_prot",
    "special  CBF78870-CBF78871  embl_tpa_prot",
    "special  CBF78873           embl_tpa_prot",
    "special  CBF78875           embl_tpa_prot",
    "special  CBF78877           embl_tpa_prot",
    "special  CBF78879           embl_tpa_prot",
    "special  CBF78881-CBF78882  embl_tpa_prot",
    "special  CBF78884           embl_tpa_prot",
    "special  CBF78886-CBF78887  embl_tpa_prot",
    "special  CBF78889           embl_tpa_prot",
    "special  CBF78891           embl_tpa_prot",
    "special  CBF78893           embl_tpa_prot",
    "special  CBF78895           embl_tpa_prot",
    "special  CBF78897-CBF78898  embl_tpa_prot",
    "special  CBF78900           embl_tpa_prot",
    "special  CBF78902           embl_tpa_prot",
    "special  CBF78904           embl_tpa_prot",
    "special  CBF78906           embl_tpa_prot",
    "special  CBF78908-CBF78909  embl_tpa_prot",
    "special  CBF78911           embl_tpa_prot",
    "special  CBF78913           embl_tpa_prot",
    "special  CBF78915           embl_tpa_prot",
    "special  CBF78917           embl_tpa_prot",
    "special  CBF78919           embl_tpa_prot",
    "special  CBF78921           embl_tpa_prot",
    "special  CBF78923-CBF78924  embl_tpa_prot",
    "special  CBF78926           embl_tpa_prot",
    "special  CBF78928           embl_tpa_prot",
    "special  CBF78930           embl_tpa_prot",
    "special  CBF78932-CBF78933  embl_tpa_prot",
    "special  CBF78935           embl_tpa_prot",
    "special  CBF78937-CBF78938  embl_tpa_prot",
    "special  CBF78940           embl_tpa_prot",
    "special  CBF78942           embl_tpa_prot",
    "special  CBF78944           embl_tpa_prot",
    "special  CBF78946           embl_tpa_prot",
    "special  CBF78948-CBF78949  embl_tpa_prot",
    "special  CBF78951           embl_tpa_prot",
    "special  CBF78953           embl_tpa_prot",
    "special  CBF78955           embl_tpa_prot",
    "special  CBF78957           embl_tpa_prot",
    "special  CBF78959           embl_tpa_prot",
    "special  CBF78961           embl_tpa_prot",
    "special  CBF78963           embl_tpa_prot",
    "special  CBF78965-CBF78966  embl_tpa_prot",
    "special  CBF78968           embl_tpa_prot",
    "special  CBF78970           embl_tpa_prot",
    "special  CBF78972           embl_tpa_prot",
    "special  CBF78974-CBF78975  embl_tpa_prot",
    "special  CBF78977           embl_tpa_prot",
    "special  CBF78979           embl_tpa_prot",
    "special  CBF78981           embl_tpa_prot",
    "special  CBF78983           embl_tpa_prot",
    "special  CBF78985-CBF78986  embl_tpa_prot",
    "special  CBF78988-CBF78989  embl_tpa_prot",
    "special  CBF78991           embl_tpa_prot",
    "special  CBF78993           embl_tpa_prot",
    "special  CBF78995           embl_tpa_prot",
    "special  CBF78997-CBF78998  embl_tpa_prot",
    "special  CBF79000           embl_tpa_prot",
    "special  CBF79002           embl_tpa_prot",
    "special  CBF79004           embl_tpa_prot",
    "special  CBF79006-CBF79007  embl_tpa_prot",
    "special  CBF79009           embl_tpa_prot",
    "special  CBF79011           embl_tpa_prot",
    "special  CBF79013-CBF79014  embl_tpa_prot",
    "special  CBF79016           embl_tpa_prot",
    "special  CBF79018           embl_tpa_prot",
    "special  CBF79020           embl_tpa_prot",
    "special  CBF79022           embl_tpa_prot",
    "special  CBF79024           embl_tpa_prot",
    "special  CBF79026           embl_tpa_prot",
    "special  CBF79028           embl_tpa_prot",
    "special  CBF79030-CBF79031  embl_tpa_prot",
    "special  CBF79033           embl_tpa_prot",
    "special  CBF79035           embl_tpa_prot",
    "special  CBF79037           embl_tpa_prot",
    "special  CBF79039-CBF79040  embl_tpa_prot",
    "special  CBF79042           embl_tpa_prot",
    "special  CBF79044           embl_tpa_prot",
    "special  CBF79046           embl_tpa_prot",
    "special  CBF79048           embl_tpa_prot",
    "special  CBF79050           embl_tpa_prot",
    "special  CBF79052-CBF79053  embl_tpa_prot",
    "special  CBF79055           embl_tpa_prot",
    "special  CBF79057           embl_tpa_prot",
    "special  CBF79059           embl_tpa_prot",
    "special  CBF79061           embl_tpa_prot",
    "special  CBF79063           embl_tpa_prot",
    "special  CBF79065           embl_tpa_prot",
    "special  CBF79067           embl_tpa_prot",
    "special  CBF79069-CBF79070  embl_tpa_prot",
    "special  CBF79072           embl_tpa_prot",
    "special  CBF79074           embl_tpa_prot",
    "special  CBF79076           embl_tpa_prot",
    "special  CBF79078           embl_tpa_prot",
    "special  CBF79080-CBF79081  embl_tpa_prot",
    "special  CBF79083           embl_tpa_prot",
    "special  CBF79085-CBF79086  embl_tpa_prot",
    "special  CBF79088           embl_tpa_prot",
    "special  CBF79090           embl_tpa_prot",
    "special  CBF79092-CBF79093  embl_tpa_prot",
    "special  CBF79095           embl_tpa_prot",
    "special  CBF79097           embl_tpa_prot",
    "special  CBF79099           embl_tpa_prot",
    "special  CBF79101           embl_tpa_prot",
    "special  CBF79103           embl_tpa_prot",
    "special  CBF79105-CBF79106  embl_tpa_prot",
    "special  CBF79108           embl_tpa_prot",
    "special  CBF79110           embl_tpa_prot",
    "special  CBF79112-CBF79113  embl_tpa_prot",
    "special  CBF79115           embl_tpa_prot",
    "special  CBF79117           embl_tpa_prot",
    "special  CBF79119           embl_tpa_prot",
    "special  CBF79121-CBF79122  embl_tpa_prot",
    "special  CBF79124           embl_tpa_prot",
    "special  CBF79126           embl_tpa_prot",
    "special  CBF79128           embl_tpa_prot",
    "special  CBF79130           embl_tpa_prot",
    "special  CBF79132           embl_tpa_prot",
    "special  CBF79134           embl_tpa_prot",
    "special  CBF79136           embl_tpa_prot",
    "special  CBF79138-CBF79139  embl_tpa_prot",
    "special  CBF79141           embl_tpa_prot",
    "special  CBF79143           embl_tpa_prot",
    "special  CBF79145           embl_tpa_prot",
    "special  CBF79147           embl_tpa_prot",
    "special  CBF79149-CBF79150  embl_tpa_prot",
    "special  CBF79152           embl_tpa_prot",
    "special  CBF79154           embl_tpa_prot",
    "special  CBF79156           embl_tpa_prot",
    "special  CBF79158           embl_tpa_prot",
    "special  CBF79160           embl_tpa_prot",
    "special  CBF79162           embl_tpa_prot",
    "special  CBF79164           embl_tpa_prot",
    "special  CBF79166-CBF79167  embl_tpa_prot",
    "special  CBF79169           embl_tpa_prot",
    "special  CBF79171           embl_tpa_prot",
    "special  CBF79173           embl_tpa_prot",
    "special  CBF79175-CBF79176  embl_tpa_prot",
    "special  CBF79178           embl_tpa_prot",
    "special  CBF79180           embl_tpa_prot",
    "special  CBF79182           embl_tpa_prot",
    "special  CBF79184           embl_tpa_prot",
    "special  CBF79186-CBF79187  embl_tpa_prot",
    "special  CBF79189-CBF79191  embl_tpa_prot",
    "special  CBF79193           embl_tpa_prot",
    "special  CBF79195           embl_tpa_prot",
    "special  CBF79197           embl_tpa_prot",
    "special  CBF79199-CBF79200  embl_tpa_prot",
    "special  CBF79202           embl_tpa_prot",
    "special  CBF79204           embl_tpa_prot",
    "special  CBF79206           embl_tpa_prot",
    "special  CBF79208-CBF79209  embl_tpa_prot",
    "special  CBF79211           embl_tpa_prot",
    "special  CBF79213           embl_tpa_prot",
    "special  CBF79215           embl_tpa_prot",
    "special  CBF79217           embl_tpa_prot",
    "special  CBF79219-CBF79220  embl_tpa_prot",
    "special  CBF79222           embl_tpa_prot",
    "special  CBF79224           embl_tpa_prot",
    "special  CBF79226-CBF79227  embl_tpa_prot",
    "special  CBF79229           embl_tpa_prot",
    "special  CBF79231           embl_tpa_prot",
    "special  CBF79233           embl_tpa_prot",
    "special  CBF79235           embl_tpa_prot",
    "special  CBF79237-CBF79238  embl_tpa_prot",
    "special  CBF79240           embl_tpa_prot",
    "special  CBF79242           embl_tpa_prot",
    "special  CBF79244           embl_tpa_prot",
    "special  CBF79246           embl_tpa_prot",
    "special  CBF79248           embl_tpa_prot",
    "special  CBF79250-CBF79251  embl_tpa_prot",
    "special  CBF79253           embl_tpa_prot",
    "special  CBF79255           embl_tpa_prot",
    "special  CBF79257-CBF79258  embl_tpa_prot",
    "special  CBF79260           embl_tpa_prot",
    "special  CBF79262           embl_tpa_prot",
    "special  CBF79264-CBF79265  embl_tpa_prot",
    "special  CBF79267           embl_tpa_prot",
    "special  CBF79269           embl_tpa_prot",
    "special  CBF79271           embl_tpa_prot",
    "special  CBF79273           embl_tpa_prot",
    "special  CBF79275           embl_tpa_prot",
    "special  CBF79277           embl_tpa_prot",
    "special  CBF79279           embl_tpa_prot",
    "special  CBF79281           embl_tpa_prot",
    "special  CBF79283-CBF79284  embl_tpa_prot",
    "special  CBF79286           embl_tpa_prot",
    "special  CBF79288           embl_tpa_prot",
    "special  CBF79290           embl_tpa_prot",
    "special  CBF79292           embl_tpa_prot",
    "special  CBF79294           embl_tpa_prot",
    "special  CBF79296-CBF79297  embl_tpa_prot",
    "special  CBF79299           embl_tpa_prot",
    "special  CBF79301           embl_tpa_prot",
    "special  CBF79303           embl_tpa_prot",
    "special  CBF79305-CBF79306  embl_tpa_prot",
    "special  CBF79308           embl_tpa_prot",
    "special  CBF79310           embl_tpa_prot",
    "special  CBF79312-CBF79313  embl_tpa_prot",
    "special  CBF79315           embl_tpa_prot",
    "special  CBF79317           embl_tpa_prot",
    "special  CBF79319           embl_tpa_prot",
    "special  CBF79321           embl_tpa_prot",
    "special  CBF79323           embl_tpa_prot",
    "special  CBF79325           embl_tpa_prot",
    "special  CBF79327           embl_tpa_prot",
    "special  CBF79329-CBF79330  embl_tpa_prot",
    "special  CBF79332           embl_tpa_prot",
    "special  CBF79334           embl_tpa_prot",
    "special  CBF79336           embl_tpa_prot",
    "special  CBF79338           embl_tpa_prot",
    "special  CBF79340           embl_tpa_prot",
    "special  CBF79342           embl_tpa_prot",
    "special  CBF79344-CBF79345  embl_tpa_prot",
    "special  CBF79347           embl_tpa_prot",
    "special  CBF79349           embl_tpa_prot",
    "special  CBF79351           embl_tpa_prot",
    "special  CBF79353-CBF79354  embl_tpa_prot",
    "special  CBF79356           embl_tpa_prot",
    "special  CBF79358           embl_tpa_prot",
    "special  CBF79360           embl_tpa_prot",
    "special  CBF79362           embl_tpa_prot",
    "special  CBF79364-CBF79365  embl_tpa_prot",
    "special  CBF79367           embl_tpa_prot",
    "special  CBF79369           embl_tpa_prot",
    "special  CBF79371           embl_tpa_prot",
    "special  CBF79373           embl_tpa_prot",
    "special  CBF79375-CBF79376  embl_tpa_prot",
    "special  CBF79378           embl_tpa_prot",
    "special  CBF79380           embl_tpa_prot",
    "special  CBF79382           embl_tpa_prot",
    "special  CBF79384           embl_tpa_prot",
    "special  CBF79386-CBF79387  embl_tpa_prot",
    "special  CBF79389           embl_tpa_prot",
    "special  CBF79391           embl_tpa_prot",
    "special  CBF79393           embl_tpa_prot",
    "special  CBF79395           embl_tpa_prot",
    "special  CBF79397-CBF79398  embl_tpa_prot",
    "special  CBF79400           embl_tpa_prot",
    "special  CBF79402           embl_tpa_prot",
    "special  CBF79404           embl_tpa_prot",
    "special  CBF79406           embl_tpa_prot",
    "special  CBF79408           embl_tpa_prot",
    "special  CBF79410-CBF79412  embl_tpa_prot",
    "special  CBF79414           embl_tpa_prot",
    "special  CBF79416-CBF79417  embl_tpa_prot",
    "special  CBF79419           embl_tpa_prot",
    "special  CBF79421           embl_tpa_prot",
    "special  CBF79423           embl_tpa_prot",
    "special  CBF79425           embl_tpa_prot",
    "special  CBF79427-CBF79428  embl_tpa_prot",
    "special  CBF79430           embl_tpa_prot",
    "special  CBF79432           embl_tpa_prot",
    "special  CBF79434           embl_tpa_prot",
    "special  CBF79436           embl_tpa_prot",
    "special  CBF79438           embl_tpa_prot",
    "special  CBF79440           embl_tpa_prot",
    "special  CBF79442-CBF79443  embl_tpa_prot",
    "special  CBF79445           embl_tpa_prot",
    "special  CBF79447           embl_tpa_prot",
    "special  CBF79449-CBF79450  embl_tpa_prot",
    "special  CBF79452           embl_tpa_prot",
    "special  CBF79454           embl_tpa_prot",
    "special  CBF79456           embl_tpa_prot",
    "special  CBF79458-CBF79459  embl_tpa_prot",
    "special  CBF79461           embl_tpa_prot",
    "special  CBF79463           embl_tpa_prot",
    "special  CBF79465           embl_tpa_prot",
    "special  CBF79467-CBF79468  embl_tpa_prot",
    "special  CBF79470           embl_tpa_prot",
    "special  CBF79472           embl_tpa_prot",
    "special  CBF79474           embl_tpa_prot",
    "special  CBF79476           embl_tpa_prot",
    "special  CBF79478           embl_tpa_prot",
    "special  CBF79480           embl_tpa_prot",
    "special  CBF79482-CBF79483  embl_tpa_prot",
    "special  CBF79485           embl_tpa_prot",
    "special  CBF79487           embl_tpa_prot",
    "special  CBF79489           embl_tpa_prot",
    "special  CBF79491-CBF79492  embl_tpa_prot",
    "special  CBF79494           embl_tpa_prot",
    "special  CBF79496-CBF79497  embl_tpa_prot",
    "special  CBF79499           embl_tpa_prot",
    "special  CBF79501           embl_tpa_prot",
    "special  CBF79503           embl_tpa_prot",
    "special  CBF79505           embl_tpa_prot",
    "special  CBF79507-CBF79508  embl_tpa_prot",
    "special  CBF79510           embl_tpa_prot",
    "special  CBF79512           embl_tpa_prot",
    "special  CBF79514           embl_tpa_prot",
    "special  CBF79516           embl_tpa_prot",
    "special  CBF79518           embl_tpa_prot",
    "special  CBF79520           embl_tpa_prot",
    "special  CBF79522-CBF79523  embl_tpa_prot",
    "special  CBF79525           embl_tpa_prot",
    "special  CBF79527           embl_tpa_prot",
    "special  CBF79529           embl_tpa_prot",
    "special  CBF79531-CBF79532  embl_tpa_prot",
    "special  CBF79534           embl_tpa_prot",
    "special  CBF79536           embl_tpa_prot",
    "special  CBF79538           embl_tpa_prot",
    "special  CBF79540           embl_tpa_prot",
    "special  CBF79542           embl_tpa_prot",
    "special  CBF79544           embl_tpa_prot",
    "special  CBF79546           embl_tpa_prot",
    "special  CBF79548-CBF79549  embl_tpa_prot",
    "special  CBF79551           embl_tpa_prot",
    "special  CBF79553           embl_tpa_prot",
    "special  CBF79555           embl_tpa_prot",
    "special  CBF79557           embl_tpa_prot",
    "special  CBF79559           embl_tpa_prot",
    "special  CBF79561           embl_tpa_prot",
    "special  CBF79563           embl_tpa_prot",
    "special  CBF79565-CBF79566  embl_tpa_prot",
    "special  CBF79568           embl_tpa_prot",
    "special  CBF79570           embl_tpa_prot",
    "special  CBF79572           embl_tpa_prot",
    "special  CBF79574-CBF79575  embl_tpa_prot",
    "special  CBF79577           embl_tpa_prot",
    "special  CBF79579           embl_tpa_prot",
    "special  CBF79581           embl_tpa_prot",
    "special  CBF79583           embl_tpa_prot",
    "special  CBF79585           embl_tpa_prot",
    "special  CBF79587           embl_tpa_prot",
    "special  CBF79589-CBF79590  embl_tpa_prot",
    "special  CBF79592           embl_tpa_prot",
    "special  CBF79594           embl_tpa_prot",
    "special  CBF79596           embl_tpa_prot",
    "special  CBF79598           embl_tpa_prot",
    "special  CBF79600-CBF79601  embl_tpa_prot",
    "special  CBF79603           embl_tpa_prot",
    "special  CBF79605           embl_tpa_prot",
    "special  CBF79607           embl_tpa_prot",
    "special  CBF79609-CBF79610  embl_tpa_prot",
    "special  CBF79612-CBF79613  embl_tpa_prot",
    "special  CBF79615           embl_tpa_prot",
    "special  CBF79617           embl_tpa_prot",
    "special  CBF79619           embl_tpa_prot",
    "special  CBF79621-CBF79622  embl_tpa_prot",
    "special  CBF79624-CBF79625  embl_tpa_prot",
    "special  CBF79627-CBF79628  embl_tpa_prot",
    "special  CBF79630           embl_tpa_prot",
    "special  CBF79632           embl_tpa_prot",
    "special  CBF79634           embl_tpa_prot",
    "special  CBF79636           embl_tpa_prot",
    "special  CBF79638-CBF79641  embl_tpa_prot",
    "special  CBF79643           embl_tpa_prot",
    "special  CBF79645-CBF79646  embl_tpa_prot",
    "special  CBF79648           embl_tpa_prot",
    "special  CBF79650           embl_tpa_prot",
    "special  CBF79652           embl_tpa_prot",
    "special  CBF79654           embl_tpa_prot",
    "special  CBF79656           embl_tpa_prot",
    "special  CBF79658           embl_tpa_prot",
    "special  CBF79660-CBF79661  embl_tpa_prot",
    "special  CBF79663           embl_tpa_prot",
    "special  CBF79665           embl_tpa_prot",
    "special  CBF79667-CBF79668  embl_tpa_prot",
    "special  CBF79670           embl_tpa_prot",
    "special  CBF79672           embl_tpa_prot",
    "special  CBF79674           embl_tpa_prot",
    "special  CBF79676-CBF79677  embl_tpa_prot",
    "special  CBF79679           embl_tpa_prot",
    "special  CBF79681           embl_tpa_prot",
    "special  CBF79683-CBF79684  embl_tpa_prot",
    "special  CBF79686           embl_tpa_prot",
    "special  CBF79688           embl_tpa_prot",
    "special  CBF79690           embl_tpa_prot",
    "special  CBF79692           embl_tpa_prot",
    "special  CBF79695-CBF79696  embl_tpa_prot",
    "special  CBF79698           embl_tpa_prot",
    "special  CBF79700           embl_tpa_prot",
    "special  CBF79702           embl_tpa_prot",
    "special  CBF79704-CBF79705  embl_tpa_prot",
    "special  CBF79707           embl_tpa_prot",
    "special  CBF79709           embl_tpa_prot",
    "special  CBF79711           embl_tpa_prot",
    "special  CBF79713           embl_tpa_prot",
    "special  CBF79715           embl_tpa_prot",
    "special  CBF79717-CBF79718  embl_tpa_prot",
    "special  CBF79720           embl_tpa_prot",
    "special  CBF79722           embl_tpa_prot",
    "special  CBF79724           embl_tpa_prot",
    "special  CBF79726           embl_tpa_prot",
    "special  CBF79728           embl_tpa_prot",
    "special  CBF79730           embl_tpa_prot",
    "special  CBF79732           embl_tpa_prot",
    "special  CBF79734-CBF79735  embl_tpa_prot",
    "special  CBF79737           embl_tpa_prot",
    "special  CBF79739           embl_tpa_prot",
    "special  CBF79741           embl_tpa_prot",
    "special  CBF79743-CBF79744  embl_tpa_prot",
    "special  CBF79746-CBF79747  embl_tpa_prot",
    "special  CBF79749           embl_tpa_prot",
    "special  CBF79751           embl_tpa_prot",
    "special  CBF79753           embl_tpa_prot",
    "special  CBF79755           embl_tpa_prot",
    "special  CBF79757-CBF79758  embl_tpa_prot",
    "special  CBF79760           embl_tpa_prot",
    "special  CBF79762           embl_tpa_prot",
    "special  CBF79764           embl_tpa_prot",
    "special  CBF79766           embl_tpa_prot",
    "special  CBF79768           embl_tpa_prot",
    "special  CBF79770           embl_tpa_prot",
    "special  CBF79772-CBF79774  embl_tpa_prot",
    "special  CBF79776-CBF79777  embl_tpa_prot",
    "special  CBF79779           embl_tpa_prot",
    "special  CBF79781           embl_tpa_prot",
    "special  CBF79783           embl_tpa_prot",
    "special  CBF79785           embl_tpa_prot",
    "special  CBF79787           embl_tpa_prot",
    "special  CBF79789           embl_tpa_prot",
    "special  CBF79791           embl_tpa_prot",
    "special  CBF79793           embl_tpa_prot",
    "special  CBF79795-CBF79796  embl_tpa_prot",
    "special  CBF79798           embl_tpa_prot",
    "special  CBF79800           embl_tpa_prot",
    "special  CBF79802           embl_tpa_prot",
    "special  CBF79804-CBF79805  embl_tpa_prot",
    "special  CBF79808-CBF79809  embl_tpa_prot",
    "special  CBF79811           embl_tpa_prot",
    "special  CBF79813           embl_tpa_prot",
    "special  CBF79815           embl_tpa_prot",
    "special  CBF79817           embl_tpa_prot",
    "special  CBF79819           embl_tpa_prot",
    "special  CBF79821           embl_tpa_prot",
    "special  CBF79823-CBF79824  embl_tpa_prot",
    "special  CBF79826           embl_tpa_prot",
    "special  CBF79828           embl_tpa_prot",
    "special  CBF79830           embl_tpa_prot",
    "special  CBF79832           embl_tpa_prot",
    "special  CBF79834-CBF79835  embl_tpa_prot",
    "special  CBF79837           embl_tpa_prot",
    "special  CBF79839           embl_tpa_prot",
    "special  CBF79841           embl_tpa_prot",
    "special  CBF79843           embl_tpa_prot",
    "special  CBF79845           embl_tpa_prot",
    "special  CBF79847           embl_tpa_prot",
    "special  CBF79849           embl_tpa_prot",
    "special  CBF79851           embl_tpa_prot",
    "special  CBF79853-CBF79854  embl_tpa_prot",
    "special  CBF79856           embl_tpa_prot",
    "special  CBF79858           embl_tpa_prot",
    "special  CBF79860-CBF79861  embl_tpa_prot",
    "special  CBF79863           embl_tpa_prot",
    "special  CBF79865           embl_tpa_prot",
    "special  CBF79867           embl_tpa_prot",
    "special  CBF79869-CBF79870  embl_tpa_prot",
    "special  CBF79872           embl_tpa_prot",
    "special  CBF79874           embl_tpa_prot",
    "special  CBF79876-CBF79877  embl_tpa_prot",
    "special  CBF79879           embl_tpa_prot",
    "special  CBF79881           embl_tpa_prot",
    "special  CBF79883           embl_tpa_prot",
    "special  CBF79885           embl_tpa_prot",
    "special  CBF79887           embl_tpa_prot",
    "special  CBF79889           embl_tpa_prot",
    "special  CBF79891-CBF79892  embl_tpa_prot",
    "special  CBF79894           embl_tpa_prot",
    "special  CBF79896           embl_tpa_prot",
    "special  CBF79898           embl_tpa_prot",
    "special  CBF79900           embl_tpa_prot",
    "special  CBF79902           embl_tpa_prot",
    "special  CBF79904           embl_tpa_prot",
    "special  CBF79906           embl_tpa_prot",
    "special  CBF79908-CBF79909  embl_tpa_prot",
    "special  CBF79911           embl_tpa_prot",
    "special  CBF79913-CBF79914  embl_tpa_prot",
    "special  CBF79916-CBF79917  embl_tpa_prot",
    "special  CBF79919           embl_tpa_prot",
    "special  CBF79921           embl_tpa_prot",
    "special  CBF79923           embl_tpa_prot",
    "special  CBF79925           embl_tpa_prot",
    "special  CBF79927           embl_tpa_prot",
    "special  CBF79929           embl_tpa_prot",
    "special  CBF79931-CBF79932  embl_tpa_prot",
    "special  CBF79934-CBF79935  embl_tpa_prot",
    "special  CBF79937           embl_tpa_prot",
    "special  CBF79939           embl_tpa_prot",
    "special  CBF79941           embl_tpa_prot",
    "special  CBF79943           embl_tpa_prot",
    "special  CBF79945           embl_tpa_prot",
    "special  CBF79947           embl_tpa_prot",
    "special  CBF79949-CBF79950  embl_tpa_prot",
    "special  CBF79952           embl_tpa_prot",
    "special  CBF79954           embl_tpa_prot",
    "special  CBF79956           embl_tpa_prot",
    "special  CBF79958-CBF79959  embl_tpa_prot",
    "special  CBF79961           embl_tpa_prot",
    "special  CBF79963-CBF79964  embl_tpa_prot",
    "special  CBF79966           embl_tpa_prot",
    "special  CBF79968           embl_tpa_prot",
    "special  CBF79970           embl_tpa_prot",
    "special  CBF79972-CBF79973  embl_tpa_prot",
    "special  CBF79975-CBF79976  embl_tpa_prot",
    "special  CBF79978-CBF79979  embl_tpa_prot",
    "special  CBF79981           embl_tpa_prot",
    "special  CBF79983-CBF79984  embl_tpa_prot",
    "special  CBF79986           embl_tpa_prot",
    "special  CBF79988           embl_tpa_prot",
    "special  CBF79990           embl_tpa_prot",
    "special  CBF79992           embl_tpa_prot",
    "special  CBF79994           embl_tpa_prot",
    "special  CBF79996-CBF79997  embl_tpa_prot",
    "special  CBF80000           embl_tpa_prot",
    "special  CBF80002           embl_tpa_prot",
    "special  CBF80004-CBF80005  embl_tpa_prot",
    "special  CBF80007           embl_tpa_prot",
    "special  CBF80009           embl_tpa_prot",
    "special  CBF80011           embl_tpa_prot",
    "special  CBF80013           embl_tpa_prot",
    "special  CBF80015           embl_tpa_prot",
    "special  CBF80017           embl_tpa_prot",
    "special  CBF80019           embl_tpa_prot",
    "special  CBF80021           embl_tpa_prot",
    "special  CBF80023           embl_tpa_prot",
    "special  CBF80025-CBF80026  embl_tpa_prot",
    "special  CBF80028           embl_tpa_prot",
    "special  CBF80030           embl_tpa_prot",
    "special  CBF80032           embl_tpa_prot",
    "special  CBF80034-CBF80035  embl_tpa_prot",
    "special  CBF80037           embl_tpa_prot",
    "special  CBF80039-CBF80040  embl_tpa_prot",
    "special  CBF80042           embl_tpa_prot",
    "special  CBF80044           embl_tpa_prot",
    "special  CBF80046           embl_tpa_prot",
    "special  CBF80048           embl_tpa_prot",
    "special  CBF80050           embl_tpa_prot",
    "special  CBF80052           embl_tpa_prot",
    "special  CBF80054           embl_tpa_prot",
    "special  CBF80056           embl_tpa_prot",
    "special  CBF80058           embl_tpa_prot",
    "special  CBF80060-CBF80061  embl_tpa_prot",
    "special  CBF80063           embl_tpa_prot",
    "special  CBF80065           embl_tpa_prot",
    "special  CBF80067           embl_tpa_prot",
    "special  CBF80069           embl_tpa_prot",
    "special  CBF80071           embl_tpa_prot",
    "special  CBF80073-CBF80074  embl_tpa_prot",
    "special  CBF80076           embl_tpa_prot",
    "special  CBF80078           embl_tpa_prot",
    "special  CBF80080           embl_tpa_prot",
    "special  CBF80082           embl_tpa_prot",
    "special  CBF80084           embl_tpa_prot",
    "special  CBF80086           embl_tpa_prot",
    "special  CBF80088-CBF80089  embl_tpa_prot",
    "special  CBF80091           embl_tpa_prot",
    "special  CBF80093           embl_tpa_prot",
    "special  CBF80095           embl_tpa_prot",
    "special  CBF80097           embl_tpa_prot",
    "special  CBF80099           embl_tpa_prot",
    "special  CBF80101           embl_tpa_prot",
    "special  CBF80103-CBF80104  embl_tpa_prot",
    "special  CBF80106           embl_tpa_prot",
    "special  CBF80108           embl_tpa_prot",
    "special  CBF80110           embl_tpa_prot",
    "special  CBF80112           embl_tpa_prot",
    "special  CBF80114-CBF80115  embl_tpa_prot",
    "special  CBF80117           embl_tpa_prot",
    "special  CBF80119           embl_tpa_prot",
    "special  CBF80121           embl_tpa_prot",
    "special  CBF80123           embl_tpa_prot",
    "special  CBF80125           embl_tpa_prot",
    "special  CBF80127           embl_tpa_prot",
    "special  CBF80129           embl_tpa_prot",
    "special  CBF80131           embl_tpa_prot",
    "special  CBF80133-CBF80134  embl_tpa_prot",
    "special  CBF80136           embl_tpa_prot",
    "special  CBF80138           embl_tpa_prot",
    "special  CBF80140           embl_tpa_prot",
    "special  CBF80142           embl_tpa_prot",
    "special  CBF80144           embl_tpa_prot",
    "special  CBF80146-CBF80147  embl_tpa_prot",
    "special  CBF80149           embl_tpa_prot",
    "special  CBF80151           embl_tpa_prot",
    "special  CBF80153-CBF80154  embl_tpa_prot",
    "special  CBF80156           embl_tpa_prot",
    "special  CBF80158           embl_tpa_prot",
    "special  CBF80160           embl_tpa_prot",
    "special  CBF80162           embl_tpa_prot",
    "special  CBF80164-CBF80165  embl_tpa_prot",
    "special  CBF80167           embl_tpa_prot",
    "special  CBF80169           embl_tpa_prot",
    "special  CBF80171           embl_tpa_prot",
    "special  CBF80173-CBF80174  embl_tpa_prot",
    "special  CBF80176           embl_tpa_prot",
    "special  CBF80178           embl_tpa_prot",
    "special  CBF80180           embl_tpa_prot",
    "special  CBF80182           embl_tpa_prot",
    "special  CBF80184           embl_tpa_prot",
    "special  CBF80186-CBF80187  embl_tpa_prot",
    "special  CBF80189           embl_tpa_prot",
    "special  CBF80191           embl_tpa_prot",
    "special  CBF80193-CBF80194  embl_tpa_prot",
    "special  CBF80196           embl_tpa_prot",
    "special  CBF80198           embl_tpa_prot",
    "special  CBF80200-CBF80201  embl_tpa_prot",
    "special  CBF80203           embl_tpa_prot",
    "special  CBF80205           embl_tpa_prot",
    "special  CBF80207           embl_tpa_prot",
    "special  CBF80209           embl_tpa_prot",
    "special  CBF80211-CBF80212  embl_tpa_prot",
    "special  CBF80214           embl_tpa_prot",
    "special  CBF80216           embl_tpa_prot",
    "special  CBF80218-CBF80219  embl_tpa_prot",
    "special  CBF80221           embl_tpa_prot",
    "special  CBF80223           embl_tpa_prot",
    "special  CBF80225-CBF80226  embl_tpa_prot",
    "special  CBF80228           embl_tpa_prot",
    "special  CBF80230           embl_tpa_prot",
    "special  CBF80232           embl_tpa_prot",
    "special  CBF80234           embl_tpa_prot",
    "special  CBF80236-CBF80237  embl_tpa_prot",
    "special  CBF80239           embl_tpa_prot",
    "special  CBF80241           embl_tpa_prot",
    "special  CBF80248           embl_tpa_prot",
    "special  CBF80250           embl_tpa_prot",
    "special  CBF80252-CBF80253  embl_tpa_prot",
    "special  CBF80255           embl_tpa_prot",
    "special  CBF80257           embl_tpa_prot",
    "special  CBF80259           embl_tpa_prot",
    "special  CBF80261-CBF80262  embl_tpa_prot",
    "special  CBF80264           embl_tpa_prot",
    "special  CBF80266           embl_tpa_prot",
    "special  CBF80268           embl_tpa_prot",
    "special  CBF80270           embl_tpa_prot",
    "special  CBF80272           embl_tpa_prot",
    "special  CBF80274-CBF80275  embl_tpa_prot",
    "special  CBF80277           embl_tpa_prot",
    "special  CBF80279           embl_tpa_prot",
    "special  CBF80281           embl_tpa_prot",
    "special  CBF80283           embl_tpa_prot",
    "special  CBF80285           embl_tpa_prot",
    "special  CBF80287-CBF80288  embl_tpa_prot",
    "special  CBF80290           embl_tpa_prot",
    "special  CBF80292           embl_tpa_prot",
    "special  CBF80294           embl_tpa_prot",
    "special  CBF80296           embl_tpa_prot",
    "special  CBF80298-CBF80299  embl_tpa_prot",
    "special  CBF80301           embl_tpa_prot",
    "special  CBF80303           embl_tpa_prot",
    "special  CBF80305           embl_tpa_prot",
    "special  CBF80307           embl_tpa_prot",
    "special  CBF80309-CBF80310  embl_tpa_prot",
    "special  CBF80312           embl_tpa_prot",
    "special  CBF80314           embl_tpa_prot",
    "special  CBF80316           embl_tpa_prot",
    "special  CBF80318           embl_tpa_prot",
    "special  CBF80320           embl_tpa_prot",
    "special  CBF80322-CBF80323  embl_tpa_prot",
    "special  CBF80325           embl_tpa_prot",
    "special  CBF80327           embl_tpa_prot",
    "special  CBF80329           embl_tpa_prot",
    "special  CBF80331           embl_tpa_prot",
    "special  CBF80333           embl_tpa_prot",
    "special  CBF80335-CBF80336  embl_tpa_prot",
    "special  CBF80338           embl_tpa_prot",
    "special  CBF80340           embl_tpa_prot",
    "special  CBF80342           embl_tpa_prot",
    "special  CBF80344           embl_tpa_prot",
    "special  CBF80346           embl_tpa_prot",
    "special  CBF80348           embl_tpa_prot",
    "special  CBF80350           embl_tpa_prot",
    "special  CBF80352           embl_tpa_prot",
    "special  CBF80354-CBF80355  embl_tpa_prot",
    "special  CBF80357           embl_tpa_prot",
    "special  CBF80359           embl_tpa_prot",
    "special  CBF80361           embl_tpa_prot",
    "special  CBF80363           embl_tpa_prot",
    "special  CBF80365           embl_tpa_prot",
    "special  CBF80367-CBF80368  embl_tpa_prot",
    "special  CBF80370           embl_tpa_prot",
    "special  CBF80372           embl_tpa_prot",
    "special  CBF80374           embl_tpa_prot",
    "special  CBF80376           embl_tpa_prot",
    "special  CBF80378           embl_tpa_prot",
    "special  CBF80380-CBF80381  embl_tpa_prot",
    "special  CBF80383           embl_tpa_prot",
    "special  CBF80385           embl_tpa_prot",
    "special  CBF80387           embl_tpa_prot",
    "special  CBF80389           embl_tpa_prot",
    "special  CBF80391-CBF80392  embl_tpa_prot",
    "special  CBF80394           embl_tpa_prot",
    "special  CBF80396           embl_tpa_prot",
    "special  CBF80398           embl_tpa_prot",
    "special  CBF80400           embl_tpa_prot",
    "special  CBF80402-CBF80403  embl_tpa_prot",
    "special  CBF80405           embl_tpa_prot",
    "special  CBF80407-CBF80408  embl_tpa_prot",
    "special  CBF80410-CBF80411  embl_tpa_prot",
    "special  CBF80413           embl_tpa_prot",
    "special  CBF80415-CBF80416  embl_tpa_prot",
    "special  CBF80418-CBF80419  embl_tpa_prot",
    "special  CBF80421-CBF80422  embl_tpa_prot",
    "special  CBF80424           embl_tpa_prot",
    "special  CBF80426           embl_tpa_prot",
    "special  CBF80428           embl_tpa_prot",
    "special  CBF80430           embl_tpa_prot",
    "special  CBF80432           embl_tpa_prot",
    "special  CBF80434           embl_tpa_prot",
    "special  CBF80436-CBF80437  embl_tpa_prot",
    "special  CBF80439           embl_tpa_prot",
    "special  CBF80441           embl_tpa_prot",
    "special  CBF80443           embl_tpa_prot",
    "special  CBF80445           embl_tpa_prot",
    "special  CBF80447-CBF80448  embl_tpa_prot",
    "special  CBF80450           embl_tpa_prot",
    "special  CBF80452           embl_tpa_prot",
    "special  CBF80454           embl_tpa_prot",
    "special  CBF80456           embl_tpa_prot",
    "special  CBF80458           embl_tpa_prot",
    "special  CBF80460-CBF80461  embl_tpa_prot",
    "special  CBF80463           embl_tpa_prot",
    "special  CBF80465           embl_tpa_prot",
    "special  CBF80467           embl_tpa_prot",
    "special  CBF80469           embl_tpa_prot",
    "special  CBF80471-CBF80472  embl_tpa_prot",
    "special  CBF80474           embl_tpa_prot",
    "special  CBF80476-CBF80477  embl_tpa_prot",
    "special  CBF80479           embl_tpa_prot",
    "special  CBF80481           embl_tpa_prot",
    "special  CBF80483           embl_tpa_prot",
    "special  CBF80485           embl_tpa_prot",
    "special  CBF80487           embl_tpa_prot",
    "special  CBF80489           embl_tpa_prot",
    "special  CBF80491           embl_tpa_prot",
    "special  CBF80493           embl_tpa_prot",
    "special  CBF80495           embl_tpa_prot",
    "special  CBF80497           embl_tpa_prot",
    "special  CBF80499-CBF80500  embl_tpa_prot",
    "special  CBF80502           embl_tpa_prot",
    "special  CBF80504           embl_tpa_prot",
    "special  CBF80506           embl_tpa_prot",
    "special  CBF80508           embl_tpa_prot",
    "special  CBF80510           embl_tpa_prot",
    "special  CBF80512           embl_tpa_prot",
    "special  CBF80514           embl_tpa_prot",
    "special  CBF80516           embl_tpa_prot",
    "special  CBF80518           embl_tpa_prot",
    "special  CBF80520           embl_tpa_prot",
    "special  CBF80522           embl_tpa_prot",
    "special  CBF80524           embl_tpa_prot",
    "special  CBF80526-CBF80527  embl_tpa_prot",
    "special  CBF80529           embl_tpa_prot",
    "special  CBF80531           embl_tpa_prot",
    "special  CBF80533           embl_tpa_prot",
    "special  CBF80535           embl_tpa_prot",
    "special  CBF80537           embl_tpa_prot",
    "special  CBF80539           embl_tpa_prot",
    "special  CBF80541           embl_tpa_prot",
    "special  CBF80543           embl_tpa_prot",
    "special  CBF80545-CBF80546  embl_tpa_prot",
    "special  CBF80548           embl_tpa_prot",
    "special  CBF80550           embl_tpa_prot",
    "special  CBF80552           embl_tpa_prot",
    "special  CBF80554           embl_tpa_prot",
    "special  CBF80556           embl_tpa_prot",
    "special  CBF80558           embl_tpa_prot",
    "special  CBF80560           embl_tpa_prot",
    "special  CBF80562           embl_tpa_prot",
    "special  CBF80564-CBF80565  embl_tpa_prot",
    "special  CBF80567           embl_tpa_prot",
    "special  CBF80569           embl_tpa_prot",
    "special  CBF80571           embl_tpa_prot",
    "special  CBF80573           embl_tpa_prot",
    "special  CBF80575           embl_tpa_prot",
    "special  CBF80577           embl_tpa_prot",
    "special  CBF80579-CBF80580  embl_tpa_prot",
    "special  CBF80582           embl_tpa_prot",
    "special  CBF80584           embl_tpa_prot",
    "special  CBF80586           embl_tpa_prot",
    "special  CBF80588-CBF80589  embl_tpa_prot",
    "special  CBF80591           embl_tpa_prot",
    "special  CBF80593           embl_tpa_prot",
    "special  CBF80595           embl_tpa_prot",
    "special  CBF80597           embl_tpa_prot",
    "special  CBF80599           embl_tpa_prot",
    "special  CBF80601-CBF80602  embl_tpa_prot",
    "special  CBF80604           embl_tpa_prot",
    "special  CBF80606           embl_tpa_prot",
    "special  CBF80608           embl_tpa_prot",
    "special  CBF80610           embl_tpa_prot",
    "special  CBF80612           embl_tpa_prot",
    "special  CBF80614-CBF80615  embl_tpa_prot",
    "special  CBF80617           embl_tpa_prot",
    "special  CBF80619           embl_tpa_prot",
    "special  CBF80621-CBF80622  embl_tpa_prot",
    "special  CBF80624           embl_tpa_prot",
    "special  CBF80626           embl_tpa_prot",
    "special  CBF80628           embl_tpa_prot",
    "special  CBF80630           embl_tpa_prot",
    "special  CBF80632-CBF80633  embl_tpa_prot",
    "special  CBF80635           embl_tpa_prot",
    "special  CBF80637           embl_tpa_prot",
    "special  CBF80639           embl_tpa_prot",
    "special  CBF80641           embl_tpa_prot",
    "special  CBF80643           embl_tpa_prot",
    "special  CBF80645           embl_tpa_prot",
    "special  CBF80647-CBF80648  embl_tpa_prot",
    "special  CBF80650           embl_tpa_prot",
    "special  CBF80652           embl_tpa_prot",
    "special  CBF80654           embl_tpa_prot",
    "special  CBF80656           embl_tpa_prot",
    "special  CBF80658           embl_tpa_prot",
    "special  CBF80660           embl_tpa_prot",
    "special  CBF80662-CBF80663  embl_tpa_prot",
    "special  CBF80665           embl_tpa_prot",
    "special  CBF80667           embl_tpa_prot",
    "special  CBF80669           embl_tpa_prot",
    "special  CBF80671           embl_tpa_prot",
    "special  CBF80673           embl_tpa_prot",
    "special  CBF80675           embl_tpa_prot",
    "special  CBF80677-CBF80678  embl_tpa_prot",
    "special  CBF80680           embl_tpa_prot",
    "special  CBF80682           embl_tpa_prot",
    "special  CBF80684           embl_tpa_prot",
    "special  CBF80686           embl_tpa_prot",
    "special  CBF80688           embl_tpa_prot",
    "special  CBF80690           embl_tpa_prot",
    "special  CBF80692           embl_tpa_prot",
    "special  CBF80694-CBF80695  embl_tpa_prot",
    "special  CBF80697           embl_tpa_prot",
    "special  CBF80699           embl_tpa_prot",
    "special  CBF80701           embl_tpa_prot",
    "special  CBF80703           embl_tpa_prot",
    "special  CBF80705           embl_tpa_prot",
    "special  CBF80707           embl_tpa_prot",
    "special  CBF80709           embl_tpa_prot",
    "special  CBF80711-CBF80712  embl_tpa_prot",
    "special  CBF80714           embl_tpa_prot",
    "special  CBF80716           embl_tpa_prot",
    "special  CBF80718           embl_tpa_prot",
    "special  CBF80720           embl_tpa_prot",
    "special  CBF80722           embl_tpa_prot",
    "special  CBF80724-CBF80725  embl_tpa_prot",
    "special  CBF80727           embl_tpa_prot",
    "special  CBF80729           embl_tpa_prot",
    "special  CBF80731           embl_tpa_prot",
    "special  CBF80733           embl_tpa_prot",
    "special  CBF80735           embl_tpa_prot",
    "special  CBF80737-CBF80738  embl_tpa_prot",
    "special  CBF80740           embl_tpa_prot",
    "special  CBF80742           embl_tpa_prot",
    "special  CBF80744           embl_tpa_prot",
    "special  CBF80746           embl_tpa_prot",
    "special  CBF80748           embl_tpa_prot",
    "special  CBF80750           embl_tpa_prot",
    "special  CBF80752-CBF80753  embl_tpa_prot",
    "special  CBF80755           embl_tpa_prot",
    "special  CBF80757           embl_tpa_prot",
    "special  CBF80759           embl_tpa_prot",
    "special  CBF80761           embl_tpa_prot",
    "special  CBF80763           embl_tpa_prot",
    "special  CBF80765-CBF80766  embl_tpa_prot",
    "special  CBF80768           embl_tpa_prot",
    "special  CBF80770           embl_tpa_prot",
    "special  CBF80772           embl_tpa_prot",
    "special  CBF80774           embl_tpa_prot",
    "special  CBF80776-CBF80777  embl_tpa_prot",
    "special  CBF80779           embl_tpa_prot",
    "special  CBF80781           embl_tpa_prot",
    "special  CBF80783           embl_tpa_prot",
    "special  CBF80785           embl_tpa_prot",
    "special  CBF80787           embl_tpa_prot",
    "special  CBF80789           embl_tpa_prot",
    "special  CBF80791-CBF80792  embl_tpa_prot",
    "special  CBF80794           embl_tpa_prot",
    "special  CBF80796           embl_tpa_prot",
    "special  CBF80798           embl_tpa_prot",
    "special  CBF80800           embl_tpa_prot",
    "special  CBF80802           embl_tpa_prot",
    "special  CBF80804-CBF80805  embl_tpa_prot",
    "special  CBF80807           embl_tpa_prot",
    "special  CBF80809           embl_tpa_prot",
    "special  CBF80811           embl_tpa_prot",
    "special  CBF80813           embl_tpa_prot",
    "special  CBF80815           embl_tpa_prot",
    "special  CBF80817-CBF80818  embl_tpa_prot",
    "special  CBF80820           embl_tpa_prot",
    "special  CBF80822           embl_tpa_prot",
    "special  CBF80824           embl_tpa_prot",
    "special  CBF80826           embl_tpa_prot",
    "special  CBF80828           embl_tpa_prot",
    "special  CBF80830           embl_tpa_prot",
    "special  CBF80832           embl_tpa_prot",
    "special  CBF80834           embl_tpa_prot",
    "special  CBF80836           embl_tpa_prot",
    "special  CBF80838-CBF80839  embl_tpa_prot",
    "special  CBF80843           embl_tpa_prot",
    "special  CBF80845           embl_tpa_prot",
    "special  CBF80847           embl_tpa_prot",
    "special  CBF80849           embl_tpa_prot",
    "special  CBF80851           embl_tpa_prot",
    "special  CBF80853           embl_tpa_prot",
    "special  CBF80855-CBF80856  embl_tpa_prot",
    "special  CBF80858           embl_tpa_prot",
    "special  CBF80860           embl_tpa_prot",
    "special  CBF80862           embl_tpa_prot",
    "special  CBF80864           embl_tpa_prot",
    "special  CBF80866           embl_tpa_prot",
    "special  CBF80868-CBF80869  embl_tpa_prot",
    "special  CBF80871           embl_tpa_prot",
    "special  CBF80873           embl_tpa_prot",
    "special  CBF80875           embl_tpa_prot",
    "special  CBF80877           embl_tpa_prot",
    "special  CBF80879           embl_tpa_prot",
    "special  CBF80881           embl_tpa_prot",
    "special  CBF80883           embl_tpa_prot",
    "special  CBF80885-CBF80886  embl_tpa_prot",
    "special  CBF80888           embl_tpa_prot",
    "special  CBF80890           embl_tpa_prot",
    "special  CBF80892           embl_tpa_prot",
    "special  CBF80894           embl_tpa_prot",
    "special  CBF80896           embl_tpa_prot",
    "special  CBF80898           embl_tpa_prot",
    "special  CBF80900-CBF80901  embl_tpa_prot",
    "special  CBF80903           embl_tpa_prot",
    "special  CBF80905           embl_tpa_prot",
    "special  CBF80907           embl_tpa_prot",
    "special  CBF80909-CBF80910  embl_tpa_prot",
    "special  CBF80912           embl_tpa_prot",
    "special  CBF80914           embl_tpa_prot",
    "special  CBF80916           embl_tpa_prot",
    "special  CBF80918           embl_tpa_prot",
    "special  CBF80920           embl_tpa_prot",
    "special  CBF80922           embl_tpa_prot",
    "special  CBF80924-CBF80925  embl_tpa_prot",
    "special  CBF80927           embl_tpa_prot",
    "special  CBF80929           embl_tpa_prot",
    "special  CBF80931           embl_tpa_prot",
    "special  CBF80933           embl_tpa_prot",
    "special  CBF80935           embl_tpa_prot",
    "special  CBF80937-CBF80938  embl_tpa_prot",
    "special  CBF80940           embl_tpa_prot",
    "special  CBF80942           embl_tpa_prot",
    "special  CBF80944           embl_tpa_prot",
    "special  CBF80946-CBF80947  embl_tpa_prot",
    "special  CBF80949           embl_tpa_prot",
    "special  CBF80951           embl_tpa_prot",
    "special  CBF80953           embl_tpa_prot",
    "special  CBF80955           embl_tpa_prot",
    "special  CBF80957           embl_tpa_prot",
    "special  CBF80959-CBF80960  embl_tpa_prot",
    "special  CBF80962           embl_tpa_prot",
    "special  CBF80964           embl_tpa_prot",
    "special  CBF80966           embl_tpa_prot",
    "special  CBF80968           embl_tpa_prot",
    "special  CBF80970           embl_tpa_prot",
    "special  CBF80972-CBF80973  embl_tpa_prot",
    "special  CBF80975           embl_tpa_prot",
    "special  CBF80977           embl_tpa_prot",
    "special  CBF80979           embl_tpa_prot",
    "special  CBF80981           embl_tpa_prot",
    "special  CBF80983-CBF80984  embl_tpa_prot",
    "special  CBF80986           embl_tpa_prot",
    "special  CBF80988           embl_tpa_prot",
    "special  CBF80990           embl_tpa_prot",
    "special  CBF80992           embl_tpa_prot",
    "special  CBF80994           embl_tpa_prot",
    "special  CBF80996           embl_tpa_prot",
    "special  CBF80998           embl_tpa_prot",
    "special  CBF81000           embl_tpa_prot",
    "special  CBF81002-CBF81003  embl_tpa_prot",
    "special  CBF81005           embl_tpa_prot",
    "special  CBF81007-CBF81008  embl_tpa_prot",
    "special  CBF81010-CBF81011  embl_tpa_prot",
    "special  CBF81013           embl_tpa_prot",
    "special  CBF81015           embl_tpa_prot",
    "special  CBF81017           embl_tpa_prot",
    "special  CBF81019           embl_tpa_prot",
    "special  CBF81021-CBF81022  embl_tpa_prot",
    "special  CBF81024           embl_tpa_prot",
    "special  CBF81026           embl_tpa_prot",
    "special  CBF81028-CBF81029  embl_tpa_prot",
    "special  CBF81031           embl_tpa_prot",
    "special  CBF81033           embl_tpa_prot",
    "special  CBF81035           embl_tpa_prot",
    "special  CBF81037           embl_tpa_prot",
    "special  CBF81039           embl_tpa_prot",
    "special  CBF81041           embl_tpa_prot",
    "special  CBF81043           embl_tpa_prot",
    "special  CBF81045-CBF81046  embl_tpa_prot",
    "special  CBF81048           embl_tpa_prot",
    "special  CBF81050           embl_tpa_prot",
    "special  CBF81052           embl_tpa_prot",
    "special  CBF81054           embl_tpa_prot",
    "special  CBF81056-CBF81057  embl_tpa_prot",
    "special  CBF81059           embl_tpa_prot",
    "special  CBF81061           embl_tpa_prot",
    "special  CBF81063           embl_tpa_prot",
    "special  CBF81065           embl_tpa_prot",
    "special  CBF81067           embl_tpa_prot",
    "special  CBF81069-CBF81070  embl_tpa_prot",
    "special  CBF81072           embl_tpa_prot",
    "special  CBF81074           embl_tpa_prot",
    "special  CBF81076-CBF81077  embl_tpa_prot",
    "special  CBF81079           embl_tpa_prot",
    "special  CBF81081           embl_tpa_prot",
    "special  CBF81083           embl_tpa_prot",
    "special  CBF81085           embl_tpa_prot",
    "special  CBF81087           embl_tpa_prot",
    "special  CBF81089           embl_tpa_prot",
    "special  CBF81091-CBF81092  embl_tpa_prot",
    "special  CBF81094           embl_tpa_prot",
    "special  CBF81096           embl_tpa_prot",
    "special  CBF81098           embl_tpa_prot",
    "special  CBF81100-CBF81101  embl_tpa_prot",
    "special  CBF81103           embl_tpa_prot",
    "special  CBF81105           embl_tpa_prot",
    "special  CBF81107-CBF81108  embl_tpa_prot",
    "special  CBF81110           embl_tpa_prot",
    "special  CBF81112           embl_tpa_prot",
    "special  CBF81114           embl_tpa_prot",
    "special  CBF81116           embl_tpa_prot",
    "special  CBF81118           embl_tpa_prot",
    "special  CBF81120           embl_tpa_prot",
    "special  CBF81122           embl_tpa_prot",
    "special  CBF81124-CBF81125  embl_tpa_prot",
    "special  CBF81127           embl_tpa_prot",
    "special  CBF81129           embl_tpa_prot",
    "special  CBF81131           embl_tpa_prot",
    "special  CBF81133           embl_tpa_prot",
    "special  CBF81135           embl_tpa_prot",
    "special  CBF81137-CBF81138  embl_tpa_prot",
    "special  CBF81140           embl_tpa_prot",
    "special  CBF81142           embl_tpa_prot",
    "special  CBF81144           embl_tpa_prot",
    "special  CBF81146           embl_tpa_prot",
    "special  CBF81148           embl_tpa_prot",
    "special  CBF81150-CBF81151  embl_tpa_prot",
    "special  CBF81153           embl_tpa_prot",
    "special  CBF81155           embl_tpa_prot",
    "special  CBF81157           embl_tpa_prot",
    "special  CBF81159           embl_tpa_prot",
    "special  CBF81161           embl_tpa_prot",
    "special  CBF81163-CBF81164  embl_tpa_prot",
    "special  CBF81166           embl_tpa_prot",
    "special  CBF81168           embl_tpa_prot",
    "special  CBF81170           embl_tpa_prot",
    "special  CBF81172           embl_tpa_prot",
    "special  CBF81174           embl_tpa_prot",
    "special  CBF81176           embl_tpa_prot",
    "special  CBF81178-CBF81179  embl_tpa_prot",
    "special  CBF81181           embl_tpa_prot",
    "special  CBF81183           embl_tpa_prot",
    "special  CBF81185           embl_tpa_prot",
    "special  CBF81187           embl_tpa_prot",
    "special  CBF81189           embl_tpa_prot",
    "special  CBF81191           embl_tpa_prot",
    "special  CBF81193-CBF81194  embl_tpa_prot",
    "special  CBF81196           embl_tpa_prot",
    "special  CBF81198           embl_tpa_prot",
    "special  CBF81200           embl_tpa_prot",
    "special  CBF81202           embl_tpa_prot",
    "special  CBF81204-CBF81205  embl_tpa_prot",
    "special  CBF81207           embl_tpa_prot",
    "special  CBF81209           embl_tpa_prot",
    "special  CBF81211           embl_tpa_prot",
    "special  CBF81213           embl_tpa_prot",
    "special  CBF81215           embl_tpa_prot",
    "special  CBF81217           embl_tpa_prot",
    "special  CBF81219           embl_tpa_prot",
    "special  CBF81221-CBF81222  embl_tpa_prot",
    "special  CBF81224           embl_tpa_prot",
    "special  CBF81226           embl_tpa_prot",
    "special  CBF81228           embl_tpa_prot",
    "special  CBF81230           embl_tpa_prot",
    "special  CBF81232           embl_tpa_prot",
    "special  CBF81234           embl_tpa_prot",
    "special  CBF81236-CBF81237  embl_tpa_prot",
    "special  CBF81239           embl_tpa_prot",
    "special  CBF81241           embl_tpa_prot",
    "special  CBF81243-CBF81244  embl_tpa_prot",
    "special  CBF81246           embl_tpa_prot",
    "special  CBF81248           embl_tpa_prot",
    "special  CBF81250           embl_tpa_prot",
    "special  CBF81252           embl_tpa_prot",
    "special  CBF81254           embl_tpa_prot",
    "special  CBF81256           embl_tpa_prot",
    "special  CBF81258-CBF81259  embl_tpa_prot",
    "special  CBF81261           embl_tpa_prot",
    "special  CBF81263           embl_tpa_prot",
    "special  CBF81265           embl_tpa_prot",
    "special  CBF81267-CBF81268  embl_tpa_prot",
    "special  CBF81270           embl_tpa_prot",
    "special  CBF81272           embl_tpa_prot",
    "special  CBF81274           embl_tpa_prot",
    "special  CBF81276           embl_tpa_prot",
    "special  CBF81278-CBF81279  embl_tpa_prot",
    "special  CBF81281           embl_tpa_prot",
    "special  CBF81283           embl_tpa_prot",
    "special  CBF81285           embl_tpa_prot",
    "special  CBF81287-CBF81288  embl_tpa_prot",
    "special  CBF81290           embl_tpa_prot",
    "special  CBF81292           embl_tpa_prot",
    "special  CBF81294           embl_tpa_prot",
    "special  CBF81296           embl_tpa_prot",
    "special  CBF81298-CBF81299  embl_tpa_prot",
    "special  CBF81301           embl_tpa_prot",
    "special  CBF81303           embl_tpa_prot",
    "special  CBF81305           embl_tpa_prot",
    "special  CBF81307           embl_tpa_prot",
    "special  CBF81309           embl_tpa_prot",
    "special  CBF81311           embl_tpa_prot",
    "special  CBF81313-CBF81314  embl_tpa_prot",
    "special  CBF81316           embl_tpa_prot",
    "special  CBF81318           embl_tpa_prot",
    "special  CBF81320           embl_tpa_prot",
    "special  CBF81322           embl_tpa_prot",
    "special  CBF81324           embl_tpa_prot",
    "special  CBF81326           embl_tpa_prot",
    "special  CBF81328           embl_tpa_prot",
    "special  CBF81330           embl_tpa_prot",
    "special  CBF81332-CBF81333  embl_tpa_prot",
    "special  CBF81335           embl_tpa_prot",
    "special  CBF81337           embl_tpa_prot",
    "special  CBF81339           embl_tpa_prot",
    "special  CBF81341           embl_tpa_prot",
    "special  CBF81343           embl_tpa_prot",
    "special  CBF81345           embl_tpa_prot",
    "special  CBF81347-CBF81348  embl_tpa_prot",
    "special  CBF81350           embl_tpa_prot",
    "special  CBF81352           embl_tpa_prot",
    "special  CBF81354           embl_tpa_prot",
    "special  CBF81356           embl_tpa_prot",
    "special  CBF81358-CBF81359  embl_tpa_prot",
    "special  CBF81361           embl_tpa_prot",
    "special  CBF81363           embl_tpa_prot",
    "special  CBF81365           embl_tpa_prot",
    "special  CBF81367           embl_tpa_prot",
    "special  CBF81369-CBF81370  embl_tpa_prot",
    "special  CBF81372           embl_tpa_prot",
    "special  CBF81374           embl_tpa_prot",
    "special  CBF81376           embl_tpa_prot",
    "special  CBF81378           embl_tpa_prot",
    "special  CBF81380-CBF81381  embl_tpa_prot",
    "special  CBF81383           embl_tpa_prot",
    "special  CBF81385           embl_tpa_prot",
    "special  CBF81387           embl_tpa_prot",
    "special  CBF81389           embl_tpa_prot",
    "special  CBF81391           embl_tpa_prot",
    "special  CBF81393           embl_tpa_prot",
    "special  CBF81395           embl_tpa_prot",
    "special  CBF81397-CBF81398  embl_tpa_prot",
    "special  CBF81400           embl_tpa_prot",
    "special  CBF81402           embl_tpa_prot",
    "special  CBF81404-CBF81405  embl_tpa_prot",
    "special  CBF81407           embl_tpa_prot",
    "special  CBF81409-CBF81410  embl_tpa_prot",
    "special  CBF81412           embl_tpa_prot",
    "special  CBF81414           embl_tpa_prot",
    "special  CBF81416           embl_tpa_prot",
    "special  CBF81418-CBF81419  embl_tpa_prot",
    "special  CBF81421           embl_tpa_prot",
    "special  CBF81423           embl_tpa_prot",
    "special  CBF81425           embl_tpa_prot",
    "special  CBF81427           embl_tpa_prot",
    "special  CBF81429           embl_tpa_prot",
    "special  CBF81431           embl_tpa_prot",
    "special  CBF81433           embl_tpa_prot",
    "special  CBF81435           embl_tpa_prot",
    "special  CBF81437           embl_tpa_prot",
    "special  CBF81439-CBF81440  embl_tpa_prot",
    "special  CBF81442           embl_tpa_prot",
    "special  CBF81444           embl_tpa_prot",
    "special  CBF81446           embl_tpa_prot",
    "special  CBF81448-CBF81449  embl_tpa_prot",
    "special  CBF81451           embl_tpa_prot",
    "special  CBF81453           embl_tpa_prot",
    "special  CBF81455           embl_tpa_prot",
    "special  CBF81457           embl_tpa_prot",
    "special  CBF81459-CBF81460  embl_tpa_prot",
    "special  CBF81462           embl_tpa_prot",
    "special  CBF81464           embl_tpa_prot",
    "special  CBF81466           embl_tpa_prot",
    "special  CBF81468-CBF81469  embl_tpa_prot",
    "special  CBF81471           embl_tpa_prot",
    "special  CBF81473           embl_tpa_prot",
    "special  CBF81475           embl_tpa_prot",
    "special  CBF81477           embl_tpa_prot",
    "special  CBF81479           embl_tpa_prot",
    "special  CBF81481           embl_tpa_prot",
    "special  CBF81483-CBF81484  embl_tpa_prot",
    "special  CBF81486           embl_tpa_prot",
    "special  CBF81488           embl_tpa_prot",
    "special  CBF81490           embl_tpa_prot",
    "special  CBF81492-CBF81493  embl_tpa_prot",
    "special  CBF81495           embl_tpa_prot",
    "special  CBF81497           embl_tpa_prot",
    "special  CBF81499           embl_tpa_prot",
    "special  CBF81501           embl_tpa_prot",
    "special  CBF81503-CBF81504  embl_tpa_prot",
    "special  CBF81506           embl_tpa_prot",
    "special  CBF81508           embl_tpa_prot",
    "special  CBF81510           embl_tpa_prot",
    "special  CBF81512           embl_tpa_prot",
    "special  CBF81514           embl_tpa_prot",
    "special  CBF81516           embl_tpa_prot",
    "special  CBF81518-CBF81519  embl_tpa_prot",
    "special  CBF81521           embl_tpa_prot",
    "special  CBF81523           embl_tpa_prot",
    "special  CBF81525           embl_tpa_prot",
    "special  CBF81527           embl_tpa_prot",
    "special  CBF81529           embl_tpa_prot",
    "special  CBF81531           embl_tpa_prot",
    "special  CBF81533-CBF81534  embl_tpa_prot",
    "special  CBF81536           embl_tpa_prot",
    "special  CBF81538           embl_tpa_prot",
    "special  CBF81540-CBF81541  embl_tpa_prot",
    "special  CBF81543           embl_tpa_prot",
    "special  CBF81545           embl_tpa_prot",
    "special  CBF81547           embl_tpa_prot",
    "special  CBF81549           embl_tpa_prot",
    "special  CBF81551           embl_tpa_prot",
    "special  CBF81553           embl_tpa_prot",
    "special  CBF81555           embl_tpa_prot",
    "special  CBF81557-CBF81558  embl_tpa_prot",
    "special  CBF81560           embl_tpa_prot",
    "special  CBF81562           embl_tpa_prot",
    "special  CBF81564           embl_tpa_prot",
    "special  CBF81566-CBF81567  embl_tpa_prot",
    "special  CBF81569           embl_tpa_prot",
    "special  CBF81572           embl_tpa_prot",
    "special  CBF81574           embl_tpa_prot",
    "special  CBF81576           embl_tpa_prot",
    "special  CBF81578-CBF81579  embl_tpa_prot",
    "special  CBF81581           embl_tpa_prot",
    "special  CBF81583           embl_tpa_prot",
    "special  CBF81585-CBF81586  embl_tpa_prot",
    "special  CBF81588           embl_tpa_prot",
    "special  CBF81590           embl_tpa_prot",
    "special  CBF81592           embl_tpa_prot",
    "special  CBF81594           embl_tpa_prot",
    "special  CBF81596-CBF81597  embl_tpa_prot",
    "special  CBF81599           embl_tpa_prot",
    "special  CBF81601           embl_tpa_prot",
    "special  CBF81603           embl_tpa_prot",
    "special  CBF81605-CBF81606  embl_tpa_prot",
    "special  CBF81608           embl_tpa_prot",
    "special  CBF81610           embl_tpa_prot",
    "special  CBF81612           embl_tpa_prot",
    "special  CBF81614           embl_tpa_prot",
    "special  CBF81616-CBF81617  embl_tpa_prot",
    "special  CBF81619           embl_tpa_prot",
    "special  CBF81621           embl_tpa_prot",
    "special  CBF81623           embl_tpa_prot",
    "special  CBF81625           embl_tpa_prot",
    "special  CBF81627           embl_tpa_prot",
    "special  CBF81629-CBF81630  embl_tpa_prot",
    "special  CBF81632           embl_tpa_prot",
    "special  CBF81634           embl_tpa_prot",
    "special  CBF81636           embl_tpa_prot",
    "special  CBF81638           embl_tpa_prot",
    "special  CBF81640-CBF81641  embl_tpa_prot",
    "special  CBF81643           embl_tpa_prot",
    "special  CBF81645           embl_tpa_prot",
    "special  CBF81647           embl_tpa_prot",
    "special  CBF81649           embl_tpa_prot",
    "special  CBF81651-CBF81652  embl_tpa_prot",
    "special  CBF81654           embl_tpa_prot",
    "special  CBF81656           embl_tpa_prot",
    "special  CBF81658           embl_tpa_prot",
    "special  CBF81660           embl_tpa_prot",
    "special  CBF81662-CBF81663  embl_tpa_prot",
    "special  CBF81665           embl_tpa_prot",
    "special  CBF81667           embl_tpa_prot",
    "special  CBF81669-CBF81670  embl_tpa_prot",
    "special  CBF81672           embl_tpa_prot",
    "special  CBF81674           embl_tpa_prot",
    "special  CBF81676           embl_tpa_prot",
    "special  CBF81678-CBF81679  embl_tpa_prot",
    "special  CBF81681           embl_tpa_prot",
    "special  CBF81683           embl_tpa_prot",
    "special  CBF81685           embl_tpa_prot",
    "special  CBF81687           embl_tpa_prot",
    "special  CBF81689           embl_tpa_prot",
    "special  CBF81691           embl_tpa_prot",
    "special  CBF81693           embl_tpa_prot",
    "special  CBF81695-CBF81696  embl_tpa_prot",
    "special  CBF81698           embl_tpa_prot",
    "special  CBF81700           embl_tpa_prot",
    "special  CBF81702           embl_tpa_prot",
    "special  CBF81704           embl_tpa_prot",
    "special  CBF81706           embl_tpa_prot",
    "special  CBF81708           embl_tpa_prot",
    "special  CBF81710           embl_tpa_prot",
    "special  CBF81712           embl_tpa_prot",
    "special  CBF81714-CBF81715  embl_tpa_prot",
    "special  CBF81717           embl_tpa_prot",
    "special  CBF81719           embl_tpa_prot",
    "special  CBF81721-CBF81722  embl_tpa_prot",
    "special  CBF81724           embl_tpa_prot",
    "special  CBF81726           embl_tpa_prot",
    "special  CBF81728-CBF81729  embl_tpa_prot",
    "special  CBF81731           embl_tpa_prot",
    "special  CBF81733-CBF81734  embl_tpa_prot",
    "special  CBF81736           embl_tpa_prot",
    "special  CBF81738-CBF81739  embl_tpa_prot",
    "special  CBF81741           embl_tpa_prot",
    "special  CBF81743           embl_tpa_prot",
    "special  CBF81745-CBF81746  embl_tpa_prot",
    "special  CBF81748           embl_tpa_prot",
    "special  CBF81750           embl_tpa_prot",
    "special  CBF81752           embl_tpa_prot",
    "special  CBF81754-CBF81755  embl_tpa_prot",
    "special  CBF81757           embl_tpa_prot",
    "special  CBF81759           embl_tpa_prot",
    "special  CBF81761           embl_tpa_prot",
    "special  CBF81763           embl_tpa_prot",
    "special  CBF81765-CBF81766  embl_tpa_prot",
    "special  CBF81768           embl_tpa_prot",
    "special  CBF81770           embl_tpa_prot",
    "special  CBF81772           embl_tpa_prot",
    "special  CBF81774           embl_tpa_prot",
    "special  CBF81776           embl_tpa_prot",
    "special  CBF81778-CBF81779  embl_tpa_prot",
    "special  CBF81781           embl_tpa_prot",
    "special  CBF81783           embl_tpa_prot",
    "special  CBF81785           embl_tpa_prot",
    "special  CBF81787           embl_tpa_prot",
    "special  CBF81789           embl_tpa_prot",
    "special  CBF81791           embl_tpa_prot",
    "special  CBF81793           embl_tpa_prot",
    "special  CBF81795-CBF81796  embl_tpa_prot",
    "special  CBF81798           embl_tpa_prot",
    "special  CBF81800           embl_tpa_prot",
    "special  CBF81802           embl_tpa_prot",
    "special  CBF81804           embl_tpa_prot",
    "special  CBF81806           embl_tpa_prot",
    "special  CBF81808-CBF81809  embl_tpa_prot",
    "special  CBF81811           embl_tpa_prot",
    "special  CBF81813           embl_tpa_prot",
    "special  CBF81815           embl_tpa_prot",
    "special  CBF81817           embl_tpa_prot",
    "special  CBF81819-CBF81820  embl_tpa_prot",
    "special  CBF81822           embl_tpa_prot",
    "special  CBF81824           embl_tpa_prot",
    "special  CBF81826           embl_tpa_prot",
    "special  CBF81828           embl_tpa_prot",
    "special  CBF81830-CBF81831  embl_tpa_prot",
    "special  CBF81833           embl_tpa_prot",
    "special  CBF81837           embl_tpa_prot",
    "special  CBF81839           embl_tpa_prot",
    "special  CBF81841           embl_tpa_prot",
    "special  CBF81843-CBF81844  embl_tpa_prot",
    "special  CBF81846           embl_tpa_prot",
    "special  CBF81848           embl_tpa_prot",
    "special  CBF81850           embl_tpa_prot",
    "special  CBF81852-CBF81853  embl_tpa_prot",
    "special  CBF81855           embl_tpa_prot",
    "special  CBF81857           embl_tpa_prot",
    "special  CBF81859-CBF81860  embl_tpa_prot",
    "special  CBF81862           embl_tpa_prot",
    "special  CBF81864           embl_tpa_prot",
    "special  CBF81866           embl_tpa_prot",
    "special  CBF81868           embl_tpa_prot",
    "special  CBF81870           embl_tpa_prot",
    "special  CBF81872           embl_tpa_prot",
    "special  CBF81874           embl_tpa_prot",
    "special  CBF81876           embl_tpa_prot",
    "special  CBF81878           embl_tpa_prot",
    "special  CBF81880           embl_tpa_prot",
    "special  CBF81882-CBF81883  embl_tpa_prot",
    "special  CBF81885           embl_tpa_prot",
    "special  CBF81887           embl_tpa_prot",
    "special  CBF81889-CBF81890  embl_tpa_prot",
    "special  CBF81892           embl_tpa_prot",
    "special  CBF81894-CBF81895  embl_tpa_prot",
    "special  CBF81897           embl_tpa_prot",
    "special  CBF81899           embl_tpa_prot",
    "special  CBF81901-CBF81902  embl_tpa_prot",
    "special  CBF81904-CBF81905  embl_tpa_prot",
    "special  CBF81907           embl_tpa_prot",
    "special  CBF81909           embl_tpa_prot",
    "special  CBF81911-CBF81913  embl_tpa_prot",
    "special  CBF81915-CBF81916  embl_tpa_prot",
    "special  CBF81918-CBF81919  embl_tpa_prot",
    "special  CBF81921           embl_tpa_prot",
    "special  CBF81923-CBF81925  embl_tpa_prot",
    "special  CBF81927           embl_tpa_prot",
    "special  CBF81929-CBF81931  embl_tpa_prot",
    "special  CBF81933-CBF81934  embl_tpa_prot",
    "special  CBF81936           embl_tpa_prot",
    "special  CBF81938-CBF81939  embl_tpa_prot",
    "special  CBF81941-CBF81942  embl_tpa_prot",
    "special  CBF81944           embl_tpa_prot",
    "special  CBF81946-CBF81948  embl_tpa_prot",
    "special  CBF81950           embl_tpa_prot",
    "special  CBF81952-CBF81953  embl_tpa_prot",
    "special  CBF81955           embl_tpa_prot",
    "special  CBF81957-CBF81959  embl_tpa_prot",
    "special  CBF81961           embl_tpa_prot",
    "special  CBF81963-CBF81966  embl_tpa_prot",
    "special  CBF81968           embl_tpa_prot",
    "special  CBF81970-CBF81971  embl_tpa_prot",
    "special  CBF81973           embl_tpa_prot",
    "special  CBF81975-CBF81977  embl_tpa_prot",
    "special  CBF81979           embl_tpa_prot",
    "special  CBF81981-CBF81982  embl_tpa_prot",
    "special  CBF81984           embl_tpa_prot",
    "special  CBF81986-CBF81988  embl_tpa_prot",
    "special  CBF81990           embl_tpa_prot",
    "special  CBF81992-CBF81993  embl_tpa_prot",
    "special  CBF81995           embl_tpa_prot",
    "special  CBF81997-CBF81998  embl_tpa_prot",
    "special  CBF82000           embl_tpa_prot",
    "special  CBF82002           embl_tpa_prot",
    "special  CBF82004-CBF82006  embl_tpa_prot",
    "special  CBF82008-CBF82009  embl_tpa_prot",
    "special  CBF82011-CBF82012  embl_tpa_prot",
    "special  CBF82014           embl_tpa_prot",
    "special  CBF82016           embl_tpa_prot",
    "special  CBF82018           embl_tpa_prot",
    "special  CBF82020           embl_tpa_prot",
    "special  CBF82022-CBF82023  embl_tpa_prot",
    "special  CBF82025           embl_tpa_prot",
    "special  CBF82027-CBF82029  embl_tpa_prot",
    "special  CBF82031           embl_tpa_prot",
    "special  CBF82033-CBF82034  embl_tpa_prot",
    "special  CBF82036           embl_tpa_prot",
    "special  CBF82038-CBF82039  embl_tpa_prot",
    "special  CBF82041-CBF82043  embl_tpa_prot",
    "special  CBF82045           embl_tpa_prot",
    "special  CBF82047-CBF82048  embl_tpa_prot",
    "special  CBF82050           embl_tpa_prot",
    "special  CBF82052-CBF82053  embl_tpa_prot",
    "special  CBF82055-CBF82056  embl_tpa_prot",
    "special  CBF82058-CBF82059  embl_tpa_prot",
    "special  CBF82061           embl_tpa_prot",
    "special  CBF82063-CBF82065  embl_tpa_prot",
    "special  CBF82067           embl_tpa_prot",
    "special  CBF82069-CBF82070  embl_tpa_prot",
    "special  CBF82072-CBF82073  embl_tpa_prot",
    "special  CBF82075-CBF82076  embl_tpa_prot",
    "special  CBF82078           embl_tpa_prot",
    "special  CBF82080-CBF82081  embl_tpa_prot",
    "special  CBF82083           embl_tpa_prot",
    "special  CBF82085           embl_tpa_prot",
    "special  CBF82087-CBF82088  embl_tpa_prot",
    "special  CBF82090           embl_tpa_prot",
    "special  CBF82092-CBF82093  embl_tpa_prot",
    "special  CBF82095-CBF82097  embl_tpa_prot",
    "special  CBF82099           embl_tpa_prot",
    "special  CBF82101-CBF82102  embl_tpa_prot",
    "special  CBF82104-CBF82105  embl_tpa_prot",
    "special  CBF82107           embl_tpa_prot",
    "special  CBF82109           embl_tpa_prot",
    "special  CBF82111-CBF82112  embl_tpa_prot",
    "special  CBF82114-CBF82115  embl_tpa_prot",
    "special  CBF82117-CBF82118  embl_tpa_prot",
    "special  CBF82120           embl_tpa_prot",
    "special  CBF82122           embl_tpa_prot",
    "special  CBF82124-CBF82125  embl_tpa_prot",
    "special  CBF82127           embl_tpa_prot",
    "special  CBF82129-CBF82130  embl_tpa_prot",
    "special  CBF82132-CBF82133  embl_tpa_prot",
    "special  CBF82135-CBF82136  embl_tpa_prot",
    "special  CBF82138           embl_tpa_prot",
    "special  CBF82140           embl_tpa_prot",
    "special  CBF82142-CBF82143  embl_tpa_prot",
    "special  CBF82145           embl_tpa_prot",
    "special  CBF82147           embl_tpa_prot",
    "special  CBF82149-CBF82150  embl_tpa_prot",
    "special  CBF82152-CBF82153  embl_tpa_prot",
    "special  CBF82155-CBF82156  embl_tpa_prot",
    "special  CBF82158-CBF82159  embl_tpa_prot",
    "special  CBF82161           embl_tpa_prot",
    "special  CBF82163-CBF82164  embl_tpa_prot",
    "special  CBF82166-CBF82167  embl_tpa_prot",
    "special  CBF82169           embl_tpa_prot",
    "special  CBF82171           embl_tpa_prot",
    "special  CBF82173           embl_tpa_prot",
    "special  CBF82175-CBF82176  embl_tpa_prot",
    "special  CBF82178           embl_tpa_prot",
    "special  CBF82180-CBF82181  embl_tpa_prot",
    "special  CBF82183           embl_tpa_prot",
    "special  CBF82185-CBF82186  embl_tpa_prot",
    "special  CBF82188           embl_tpa_prot",
    "special  CBF82190           embl_tpa_prot",
    "special  CBF82192-CBF82193  embl_tpa_prot",
    "special  CBF82195           embl_tpa_prot",
    "special  CBF82197-CBF82198  embl_tpa_prot",
    "special  CBF82200           embl_tpa_prot",
    "special  CBF82202-CBF82203  embl_tpa_prot",
    "special  CBF82205-CBF82206  embl_tpa_prot",
    "special  CBF82208-CBF82209  embl_tpa_prot",
    "special  CBF82211           embl_tpa_prot",
    "special  CBF82213           embl_tpa_prot",
    "special  CBF82215-CBF82216  embl_tpa_prot",
    "special  CBF82218           embl_tpa_prot",
    "special  CBF82220-CBF82222  embl_tpa_prot",
    "special  CBF82224           embl_tpa_prot",
    "special  CBF82226           embl_tpa_prot",
    "special  CBF82228           embl_tpa_prot",
    "special  CBF82230           embl_tpa_prot",
    "special  CBF82232-CBF82233  embl_tpa_prot",
    "special  CBF82235           embl_tpa_prot",
    "special  CBF82237-CBF82238  embl_tpa_prot",
    "special  CBF82240           embl_tpa_prot",
    "special  CBF82242           embl_tpa_prot",
    "special  CBF82244           embl_tpa_prot",
    "special  CBF82246           embl_tpa_prot",
    "special  CBF82248-CBF82249  embl_tpa_prot",
    "special  CBF82251           embl_tpa_prot",
    "special  CBF82261           embl_tpa_prot",
    "special  CBF82263           embl_tpa_prot",
    "special  CBF82265           embl_tpa_prot",
    "special  CBF82267           embl_tpa_prot",
    "special  CBF82269-CBF82270  embl_tpa_prot",
    "special  CBF82272           embl_tpa_prot",
    "special  CBF82274-CBF82275  embl_tpa_prot",
    "special  CBF82277           embl_tpa_prot",
    "special  CBF82279           embl_tpa_prot",
    "special  CBF82281           embl_tpa_prot",
    "special  CBF82283-CBF82284  embl_tpa_prot",
    "special  CBF82286           embl_tpa_prot",
    "special  CBF82288           embl_tpa_prot",
    "special  CBF82290           embl_tpa_prot",
    "special  CBF82292-CBF82293  embl_tpa_prot",
    "special  CBF82295           embl_tpa_prot",
    "special  CBF82297           embl_tpa_prot",
    "special  CBF82299           embl_tpa_prot",
    "special  CBF82301-CBF82302  embl_tpa_prot",
    "special  CBF82304           embl_tpa_prot",
    "special  CBF82306           embl_tpa_prot",
    "special  CBF82308-CBF82309  embl_tpa_prot",
    "special  CBF82311           embl_tpa_prot",
    "special  CBF82313           embl_tpa_prot",
    "special  CBF82315           embl_tpa_prot",
    "special  CBF82317           embl_tpa_prot",
    "special  CBF82319-CBF82320  embl_tpa_prot",
    "special  CBF82322           embl_tpa_prot",
    "special  CBF82324           embl_tpa_prot",
    "special  CBF82326           embl_tpa_prot",
    "special  CBF82328-CBF82329  embl_tpa_prot",
    "special  CBF82331           embl_tpa_prot",
    "special  CBF82333           embl_tpa_prot",
    "special  CBF82335           embl_tpa_prot",
    "special  CBF82337           embl_tpa_prot",
    "special  CBF82339-CBF82340  embl_tpa_prot",
    "special  CBF82342           embl_tpa_prot",
    "special  CBF82344           embl_tpa_prot",
    "special  CBF82346           embl_tpa_prot",
    "special  CBF82348           embl_tpa_prot",
    "special  CBF82350           embl_tpa_prot",
    "special  CBF82352           embl_tpa_prot",
    "special  CBF82354           embl_tpa_prot",
    "special  CBF82356           embl_tpa_prot",
    "special  CBF82358           embl_tpa_prot",
    "special  CBF82360-CBF82361  embl_tpa_prot",
    "special  CBF82363           embl_tpa_prot",
    "special  CBF82365           embl_tpa_prot",
    "special  CBF82367           embl_tpa_prot",
    "special  CBF82369-CBF82370  embl_tpa_prot",
    "special  CBF82372           embl_tpa_prot",
    "special  CBF82374           embl_tpa_prot",
    "special  CBF82376-CBF82377  embl_tpa_prot",
    "special  CBF82379           embl_tpa_prot",
    "special  CBF82381-CBF82382  embl_tpa_prot",
    "special  CBF82384           embl_tpa_prot",
    "special  CBF82386-CBF82387  embl_tpa_prot",
    "special  CBF82389           embl_tpa_prot",
    "special  CBF82391           embl_tpa_prot",
    "special  CBF82393-CBF82394  embl_tpa_prot",
    "special  CBF82396           embl_tpa_prot",
    "special  CBF82398           embl_tpa_prot",
    "special  CBF82400-CBF82401  embl_tpa_prot",
    "special  CBF82403           embl_tpa_prot",
    "special  CBF82405           embl_tpa_prot",
    "special  CBF82407-CBF82408  embl_tpa_prot",
    "special  CBF82410           embl_tpa_prot",
    "special  CBF82412           embl_tpa_prot",
    "special  CBF82414           embl_tpa_prot",
    "special  CBF82416           embl_tpa_prot",
    "special  CBF82418           embl_tpa_prot",
    "special  CBF82420-CBF82421  embl_tpa_prot",
    "special  CBF82423           embl_tpa_prot",
    "special  CBF82425           embl_tpa_prot",
    "special  CBF82427           embl_tpa_prot",
    "special  CBF82429           embl_tpa_prot",
    "special  CBF82431           embl_tpa_prot",
    "special  CBF82433           embl_tpa_prot",
    "special  CBF82435-CBF82436  embl_tpa_prot",
    "special  CBF82438           embl_tpa_prot",
    "special  CBF82440           embl_tpa_prot",
    "special  CBF82442           embl_tpa_prot",
    "special  CBF82444           embl_tpa_prot",
    "special  CBF82446-CBF82447  embl_tpa_prot",
    "special  CBF82449           embl_tpa_prot",
    "special  CBF82451           embl_tpa_prot",
    "special  CBF82453           embl_tpa_prot",
    "special  CBF82455-CBF82456  embl_tpa_prot",
    "special  CBF82458           embl_tpa_prot",
    "special  CBF82460           embl_tpa_prot",
    "special  CBF82462           embl_tpa_prot",
    "special  CBF82464           embl_tpa_prot",
    "special  CBF82466-CBF82467  embl_tpa_prot",
    "special  CBF82469           embl_tpa_prot",
    "special  CBF82471           embl_tpa_prot",
    "special  CBF82473           embl_tpa_prot",
    "special  CBF82475           embl_tpa_prot",
    "special  CBF82477           embl_tpa_prot",
    "special  CBF82479           embl_tpa_prot",
    "special  CBF82481-CBF82482  embl_tpa_prot",
    "special  CBF82484           embl_tpa_prot",
    "special  CBF82486           embl_tpa_prot",
    "special  CBF82488           embl_tpa_prot",
    "special  CBF82490           embl_tpa_prot",
    "special  CBF82492-CBF82493  embl_tpa_prot",
    "special  CBF82495           embl_tpa_prot",
    "special  CBF82497           embl_tpa_prot",
    "special  CBF82499           embl_tpa_prot",
    "special  CBF82501           embl_tpa_prot",
    "special  CBF82503-CBF82504  embl_tpa_prot",
    "special  CBF82506           embl_tpa_prot",
    "special  CBF82508           embl_tpa_prot",
    "special  CBF82510           embl_tpa_prot",
    "special  CBF82512-CBF82513  embl_tpa_prot",
    "special  CBF82515           embl_tpa_prot",
    "special  CBF82517           embl_tpa_prot",
    "special  CBF82519           embl_tpa_prot",
    "special  CBF82521           embl_tpa_prot",
    "special  CBF82523           embl_tpa_prot",
    "special  CBF82525           embl_tpa_prot",
    "special  CBF82527-CBF82528  embl_tpa_prot",
    "special  CBF82530           embl_tpa_prot",
    "special  CBF82532           embl_tpa_prot",
    "special  CBF82534           embl_tpa_prot",
    "special  CBF82536           embl_tpa_prot",
    "special  CBF82538-CBF82539  embl_tpa_prot",
    "special  CBF82541           embl_tpa_prot",
    "special  CBF82543           embl_tpa_prot",
    "special  CBF82545           embl_tpa_prot",
    "special  CBF82547           embl_tpa_prot",
    "special  CBF82549-CBF82550  embl_tpa_prot",
    "special  CBF82552           embl_tpa_prot",
    "special  CBF82554           embl_tpa_prot",
    "special  CBF82556           embl_tpa_prot",
    "special  CBF82558           embl_tpa_prot",
    "special  CBF82560           embl_tpa_prot",
    "special  CBF82562           embl_tpa_prot",
    "special  CBF82564-CBF82565  embl_tpa_prot",
    "special  CBF82567           embl_tpa_prot",
    "special  CBF82569           embl_tpa_prot",
    "special  CBF82571-CBF82572  embl_tpa_prot",
    "special  CBF82574           embl_tpa_prot",
    "special  CBF82576           embl_tpa_prot",
    "special  CBF82578           embl_tpa_prot",
    "special  CBF82580           embl_tpa_prot",
    "special  CBF82582           embl_tpa_prot",
    "special  CBF82584-CBF82585  embl_tpa_prot",
    "special  CBF82587           embl_tpa_prot",
    "special  CBF82589           embl_tpa_prot",
    "special  CBF82591           embl_tpa_prot",
    "special  CBF82593           embl_tpa_prot",
    "special  CBF82595-CBF82596  embl_tpa_prot",
    "special  CBF82598           embl_tpa_prot",
    "special  CBF82600           embl_tpa_prot",
    "special  CBF82602           embl_tpa_prot",
    "special  CBF82604-CBF82605  embl_tpa_prot",
    "special  CBF82607           embl_tpa_prot",
    "special  CBF82609           embl_tpa_prot",
    "special  CBF82611           embl_tpa_prot",
    "special  CBF82613           embl_tpa_prot",
    "special  CBF82615-CBF82616  embl_tpa_prot",
    "special  CBF82618           embl_tpa_prot",
    "special  CBF82620           embl_tpa_prot",
    "special  CBF82622           embl_tpa_prot",
    "special  CBF82624-CBF82625  embl_tpa_prot",
    "special  CBF82627           embl_tpa_prot",
    "special  CBF82629           embl_tpa_prot",
    "special  CBF82631           embl_tpa_prot",
    "special  CBF82633           embl_tpa_prot",
    "special  CBF82635           embl_tpa_prot",
    "special  CBF82637-CBF82638  embl_tpa_prot",
    "special  CBF82640           embl_tpa_prot",
    "special  CBF82642           embl_tpa_prot",
    "special  CBF82644           embl_tpa_prot",
    "special  CBF82646           embl_tpa_prot",
    "special  CBF82648-CBF82649  embl_tpa_prot",
    "special  CBF82651           embl_tpa_prot",
    "special  CBF82653           embl_tpa_prot",
    "special  CBF82655           embl_tpa_prot",
    "special  CBF82657           embl_tpa_prot",
    "special  CBF82659-CBF82660  embl_tpa_prot",
    "special  CBF82662           embl_tpa_prot",
    "special  CBF82664           embl_tpa_prot",
    "special  CBF82666           embl_tpa_prot",
    "special  CBF82668           embl_tpa_prot",
    "special  CBF82670           embl_tpa_prot",
    "special  CBF82672           embl_tpa_prot",
    "special  CBF82674-CBF82675  embl_tpa_prot",
    "special  CBF82677           embl_tpa_prot",
    "special  CBF82679           embl_tpa_prot",
    "special  CBF82681           embl_tpa_prot",
    "special  CBF82683           embl_tpa_prot",
    "special  CBF82685           embl_tpa_prot",
    "special  CBF82687-CBF82688  embl_tpa_prot",
    "special  CBF82690           embl_tpa_prot",
    "special  CBF82692           embl_tpa_prot",
    "special  CBF82694           embl_tpa_prot",
    "special  CBF82696           embl_tpa_prot",
    "special  CBF82698           embl_tpa_prot",
    "special  CBF82700-CBF82701  embl_tpa_prot",
    "special  CBF82703           embl_tpa_prot",
    "special  CBF82705           embl_tpa_prot",
    "special  CBF82707           embl_tpa_prot",
    "special  CBF82709           embl_tpa_prot",
    "special  CBF82711-CBF82712  embl_tpa_prot",
    "special  CBF82714           embl_tpa_prot",
    "special  CBF82716           embl_tpa_prot",
    "special  CBF82718           embl_tpa_prot",
    "special  CBF82720           embl_tpa_prot",
    "special  CBF82722-CBF82723  embl_tpa_prot",
    "special  CBF82725           embl_tpa_prot",
    "special  CBF82727           embl_tpa_prot",
    "special  CBF82729           embl_tpa_prot",
    "special  CBF82731           embl_tpa_prot",
    "special  CBF82733-CBF82734  embl_tpa_prot",
    "special  CBF82736           embl_tpa_prot",
    "special  CBF82738           embl_tpa_prot",
    "special  CBF82740           embl_tpa_prot",
    "special  CBF82742-CBF82743  embl_tpa_prot",
    "special  CBF82745           embl_tpa_prot",
    "special  CBF82747           embl_tpa_prot",
    "special  CBF82749           embl_tpa_prot",
    "special  CBF82751           embl_tpa_prot",
    "special  CBF82754           embl_tpa_prot",
    "special  CBF82756           embl_tpa_prot",
    "special  CBF82758           embl_tpa_prot",
    "special  CBF82760           embl_tpa_prot",
    "special  CBF82762           embl_tpa_prot",
    "special  CBF82764           embl_tpa_prot",
    "special  CBF82766           embl_tpa_prot",
    "special  CBF82768           embl_tpa_prot",
    "special  CBF82770-CBF82771  embl_tpa_prot",
    "special  CBF82773           embl_tpa_prot",
    "special  CBF82775           embl_tpa_prot",
    "special  CBF82777           embl_tpa_prot",
    "special  CBF82779-CBF82780  embl_tpa_prot",
    "special  CBF82782           embl_tpa_prot",
    "special  CBF82784           embl_tpa_prot",
    "special  CBF82786-CBF82787  embl_tpa_prot",
    "special  CBF82789           embl_tpa_prot",
    "special  CBF82791           embl_tpa_prot",
    "special  CBF82793           embl_tpa_prot",
    "special  CBF82795           embl_tpa_prot",
    "special  CBF82797           embl_tpa_prot",
    "special  CBF82799-CBF82800  embl_tpa_prot",
    "special  CBF82802           embl_tpa_prot",
    "special  CBF82804           embl_tpa_prot",
    "special  CBF82806           embl_tpa_prot",
    "special  CBF82808           embl_tpa_prot",
    "special  CBF82810           embl_tpa_prot",
    "special  CBF82812           embl_tpa_prot",
    "special  CBF82814-CBF82815  embl_tpa_prot",
    "special  CBF82817           embl_tpa_prot",
    "special  CBF82819           embl_tpa_prot",
    "special  CBF82821-CBF82822  embl_tpa_prot",
    "special  CBF82824           embl_tpa_prot",
    "special  CBF82826-CBF82827  embl_tpa_prot",
    "special  CBF82829           embl_tpa_prot",
    "special  CBF82831           embl_tpa_prot",
    "special  CBF82833           embl_tpa_prot",
    "special  CBF82835-CBF82836  embl_tpa_prot",
    "special  CBF82838           embl_tpa_prot",
    "special  CBF82840           embl_tpa_prot",
    "special  CBF82842           embl_tpa_prot",
    "special  CBF82844           embl_tpa_prot",
    "special  CBF82846-CBF82847  embl_tpa_prot",
    "special  CBF82849           embl_tpa_prot",
    "special  CBF82851           embl_tpa_prot",
    "special  CBF82853           embl_tpa_prot",
    "special  CBF82855           embl_tpa_prot",
    "special  CBF82857           embl_tpa_prot",
    "special  CBF82859-CBF82860  embl_tpa_prot",
    "special  CBF82862           embl_tpa_prot",
    "special  CBF82864           embl_tpa_prot",
    "special  CBF82866           embl_tpa_prot",
    "special  CBF82868           embl_tpa_prot",
    "special  CBF82870           embl_tpa_prot",
    "special  CBF82872-CBF82873  embl_tpa_prot",
    "special  CBF82875           embl_tpa_prot",
    "special  CBF82877           embl_tpa_prot",
    "special  CBF82879           embl_tpa_prot",
    "special  CBF82881           embl_tpa_prot",
    "special  CBF82883           embl_tpa_prot",
    "special  CBF82885           embl_tpa_prot",
    "special  CBF82887-CBF82888  embl_tpa_prot",
    "special  CBF82890           embl_tpa_prot",
    "special  CBF82892           embl_tpa_prot",
    "special  CBF82894           embl_tpa_prot",
    "special  CBF82896           embl_tpa_prot",
    "special  CBF82898           embl_tpa_prot",
    "special  CBF82900-CBF82901  embl_tpa_prot",
    "special  CBF82903           embl_tpa_prot",
    "special  CBF82905           embl_tpa_prot",
    "special  CBF82907           embl_tpa_prot",
    "special  CBF82909           embl_tpa_prot",
    "special  CBF82911           embl_tpa_prot",
    "special  CBF82913-CBF82914  embl_tpa_prot",
    "special  CBF82916           embl_tpa_prot",
    "special  CBF82918           embl_tpa_prot",
    "special  CBF82920           embl_tpa_prot",
    "special  CBF82922           embl_tpa_prot",
    "special  CBF82924-CBF82925  embl_tpa_prot",
    "special  CBF82927           embl_tpa_prot",
    "special  CBF82929           embl_tpa_prot",
    "special  CBF82931           embl_tpa_prot",
    "special  CBF82933-CBF82934  embl_tpa_prot",
    "special  CBF82936           embl_tpa_prot",
    "special  CBF82938           embl_tpa_prot",
    "special  CBF82940           embl_tpa_prot",
    "special  CBF82942-CBF82943  embl_tpa_prot",
    "special  CBF82945           embl_tpa_prot",
    "special  CBF82947           embl_tpa_prot",
    "special  CBF82949           embl_tpa_prot",
    "special  CBF82951           embl_tpa_prot",
    "special  CBF82953-CBF82954  embl_tpa_prot",
    "special  CBF82956           embl_tpa_prot",
    "special  CBF82958           embl_tpa_prot",
    "special  CBF82960           embl_tpa_prot",
    "special  CBF82962-CBF82963  embl_tpa_prot",
    "special  CBF82965           embl_tpa_prot",
    "special  CBF82967           embl_tpa_prot",
    "special  CBF82969           embl_tpa_prot",
    "special  CBF82971           embl_tpa_prot",
    "special  CBF82973-CBF82974  embl_tpa_prot",
    "special  CBF82976           embl_tpa_prot",
    "special  CBF82978           embl_tpa_prot",
    "special  CBF82980           embl_tpa_prot",
    "special  CBF82982-CBF82983  embl_tpa_prot",
    "special  CBF82985           embl_tpa_prot",
    "special  CBF82987           embl_tpa_prot",
    "special  CBF82989           embl_tpa_prot",
    "special  CBF82991           embl_tpa_prot",
    "special  CBF82993           embl_tpa_prot",
    "special  CBF82995-CBF82996  embl_tpa_prot",
    "special  CBF82998           embl_tpa_prot",
    "special  CBF83000           embl_tpa_prot",
    "special  CBF83002           embl_tpa_prot",
    "special  CBF83004-CBF83005  embl_tpa_prot",
    "special  CBF83007           embl_tpa_prot",
    "special  CBF83009           embl_tpa_prot",
    "special  CBF83011           embl_tpa_prot",
    "special  CBF83013-CBF83014  embl_tpa_prot",
    "special  CBF83016           embl_tpa_prot",
    "special  CBF83018           embl_tpa_prot",
    "special  CBF83020           embl_tpa_prot",
    "special  CBF83022-CBF83023  embl_tpa_prot",
    "special  CBF83025           embl_tpa_prot",
    "special  CBF83027           embl_tpa_prot",
    "special  CBF83029           embl_tpa_prot",
    "special  CBF83031           embl_tpa_prot",
    "special  CBF83033           embl_tpa_prot",
    "special  CBF83035-CBF83036  embl_tpa_prot",
    "special  CBF83038           embl_tpa_prot",
    "special  CBF83040           embl_tpa_prot",
    "special  CBF83042           embl_tpa_prot",
    "special  CBF83044           embl_tpa_prot",
    "special  CBF83046           embl_tpa_prot",
    "special  CBF83048-CBF83049  embl_tpa_prot",
    "special  CBF83051           embl_tpa_prot",
    "special  CBF83053           embl_tpa_prot",
    "special  CBF83055           embl_tpa_prot",
    "special  CBF83057-CBF83058  embl_tpa_prot",
    "special  CBF83060           embl_tpa_prot",
    "special  CBF83062           embl_tpa_prot",
    "special  CBF83064           embl_tpa_prot",
    "special  CBF83068           embl_tpa_prot",
    "special  CBF83070           embl_tpa_prot",
    "special  CBF83072           embl_tpa_prot",
    "special  CBF83074           embl_tpa_prot",
    "special  CBF83076           embl_tpa_prot",
    "special  CBF83078-CBF83079  embl_tpa_prot",
    "special  CBF83081           embl_tpa_prot",
    "special  CBF83083-CBF83084  embl_tpa_prot",
    "special  CBF83086-CBF83087  embl_tpa_prot",
    "special  CBF83089           embl_tpa_prot",
    "special  CBF83091           embl_tpa_prot",
    "special  CBF83093-CBF83094  embl_tpa_prot",
    "special  CBF83096           embl_tpa_prot",
    "special  CBF83098-CBF83099  embl_tpa_prot",
    "special  CBF83101           embl_tpa_prot",
    "special  CBF83103           embl_tpa_prot",
    "special  CBF83105           embl_tpa_prot",
    "special  CBF83107-CBF83108  embl_tpa_prot",
    "special  CBF83110           embl_tpa_prot",
    "special  CBF83112           embl_tpa_prot",
    "special  CBF83114           embl_tpa_prot",
    "special  CBF83116           embl_tpa_prot",
    "special  CBF83118           embl_tpa_prot",
    "special  CBF83120           embl_tpa_prot",
    "special  CBF83122           embl_tpa_prot",
    "special  CBF83124           embl_tpa_prot",
    "special  CBF83126           embl_tpa_prot",
    "special  CBF83128           embl_tpa_prot",
    "special  CBF83130           embl_tpa_prot",
    "special  CBF83132           embl_tpa_prot",
    "special  CBF83134           embl_tpa_prot",
    "special  CBF83136           embl_tpa_prot",
    "special  CBF83138-CBF83139  embl_tpa_prot",
    "special  CBF83141           embl_tpa_prot",
    "special  CBF83143           embl_tpa_prot",
    "special  CBF83145           embl_tpa_prot",
    "special  CBF83147           embl_tpa_prot",
    "special  CBF83149           embl_tpa_prot",
    "special  CBF83151           embl_tpa_prot",
    "special  CBF83153           embl_tpa_prot",
    "special  CBF83155           embl_tpa_prot",
    "special  CBF83157-CBF83158  embl_tpa_prot",
    "special  CBF83160           embl_tpa_prot",
    "special  CBF83162           embl_tpa_prot",
    "special  CBF83164           embl_tpa_prot",
    "special  CBF83166           embl_tpa_prot",
    "special  CBF83168-CBF83169  embl_tpa_prot",
    "special  CBF83171           embl_tpa_prot",
    "special  CBF83173           embl_tpa_prot",
    "special  CBF83175           embl_tpa_prot",
    "special  CBF83177-CBF83178  embl_tpa_prot",
    "special  CBF83180           embl_tpa_prot",
    "special  CBF83182           embl_tpa_prot",
    "special  CBF83184           embl_tpa_prot",
    "special  CBF83186           embl_tpa_prot",
    "special  CBF83188           embl_tpa_prot",
    "special  CBF83190           embl_tpa_prot",
    "special  CBF83192           embl_tpa_prot",
    "special  CBF83194-CBF83195  embl_tpa_prot",
    "special  CBF83197           embl_tpa_prot",
    "special  CBF83199           embl_tpa_prot",
    "special  CBF83201           embl_tpa_prot",
    "special  CBF83203           embl_tpa_prot",
    "special  CBF83206-CBF83207  embl_tpa_prot",
    "special  CBF83209           embl_tpa_prot",
    "special  CBF83211           embl_tpa_prot",
    "special  CBF83213           embl_tpa_prot",
    "special  CBF83215           embl_tpa_prot",
    "special  CBF83217           embl_tpa_prot",
    "special  CBF83219           embl_tpa_prot",
    "special  CBF83221           embl_tpa_prot",
    "special  CBF83223-CBF83224  embl_tpa_prot",
    "special  CBF83226           embl_tpa_prot",
    "special  CBF83228           embl_tpa_prot",
    "special  CBF83230           embl_tpa_prot",
    "special  CBF83232           embl_tpa_prot",
    "special  CBF83234           embl_tpa_prot",
    "special  CBF83236           embl_tpa_prot",
    "special  CBF83238           embl_tpa_prot",
    "special  CBF83240           embl_tpa_prot",
    "special  CBF83242           embl_tpa_prot",
    "special  CBF83244-CBF83245  embl_tpa_prot",
    "special  CBF83247           embl_tpa_prot",
    "special  CBF83249           embl_tpa_prot",
    "special  CBF83251           embl_tpa_prot",
    "special  CBF83253           embl_tpa_prot",
    "special  CBF83255           embl_tpa_prot",
    "special  CBF83257           embl_tpa_prot",
    "special  CBF83259           embl_tpa_prot",
    "special  CBF83261-CBF83262  embl_tpa_prot",
    "special  CBF83264           embl_tpa_prot",
    "special  CBF83266           embl_tpa_prot",
    "special  CBF83268           embl_tpa_prot",
    "special  CBF83270-CBF83271  embl_tpa_prot",
    "special  CBF83273           embl_tpa_prot",
    "special  CBF83275           embl_tpa_prot",
    "special  CBF83277-CBF83278  embl_tpa_prot",
    "special  CBF83280           embl_tpa_prot",
    "special  CBF83282           embl_tpa_prot",
    "special  CBF83284           embl_tpa_prot",
    "special  CBF83286           embl_tpa_prot",
    "special  CBF83288-CBF83289  embl_tpa_prot",
    "special  CBF83291           embl_tpa_prot",
    "special  CBF83293           embl_tpa_prot",
    "special  CBF83295           embl_tpa_prot",
    "special  CBF83297           embl_tpa_prot",
    "special  CBF83299           embl_tpa_prot",
    "special  CBF83301           embl_tpa_prot",
    "special  CBF83303-CBF83304  embl_tpa_prot",
    "special  CBF83306           embl_tpa_prot",
    "special  CBF83308           embl_tpa_prot",
    "special  CBF83310           embl_tpa_prot",
    "special  CBF83312           embl_tpa_prot",
    "special  CBF83314-CBF83315  embl_tpa_prot",
    "special  CBF83317           embl_tpa_prot",
    "special  CBF83319           embl_tpa_prot",
    "special  CBF83321           embl_tpa_prot",
    "special  CBF83323           embl_tpa_prot",
    "special  CBF83325           embl_tpa_prot",
    "special  CBF83327           embl_tpa_prot",
    "special  CBF83329           embl_tpa_prot",
    "special  CBF83331           embl_tpa_prot",
    "special  CBF83333           embl_tpa_prot",
    "special  CBF83335-CBF83336  embl_tpa_prot",
    "special  CBF83338           embl_tpa_prot",
    "special  CBF83340           embl_tpa_prot",
    "special  CBF83342-CBF83343  embl_tpa_prot",
    "special  CBF83345           embl_tpa_prot",
    "special  CBF83347           embl_tpa_prot",
    "special  CBF83349-CBF83350  embl_tpa_prot",
    "special  CBF83352           embl_tpa_prot",
    "special  CBF83354           embl_tpa_prot",
    "special  CBF83356           embl_tpa_prot",
    "special  CBF83358-CBF83359  embl_tpa_prot",
    "special  CBF83361           embl_tpa_prot",
    "special  CBF83363           embl_tpa_prot",
    "special  CBF83365           embl_tpa_prot",
    "special  CBF83367           embl_tpa_prot",
    "special  CBF83369           embl_tpa_prot",
    "special  CBF83371-CBF83372  embl_tpa_prot",
    "special  CBF83374           embl_tpa_prot",
    "special  CBF83376           embl_tpa_prot",
    "special  CBF83378           embl_tpa_prot",
    "special  CBF83380-CBF83381  embl_tpa_prot",
    "special  CBF83383           embl_tpa_prot",
    "special  CBF83385-CBF83386  embl_tpa_prot",
    "special  CBF83388           embl_tpa_prot",
    "special  CBF83390           embl_tpa_prot",
    "special  CBF83392           embl_tpa_prot",
    "special  CBF83394-CBF83395  embl_tpa_prot",
    "special  CBF83397           embl_tpa_prot",
    "special  CBF83399-CBF83400  embl_tpa_prot",
    "special  CBF83402           embl_tpa_prot",
    "special  CBF83404-CBF83405  embl_tpa_prot",
    "special  CBF83407-CBF83408  embl_tpa_prot",
    "special  CBF83410           embl_tpa_prot",
    "special  CBF83412           embl_tpa_prot",
    "special  CBF83414           embl_tpa_prot",
    "special  CBF83416-CBF83417  embl_tpa_prot",
    "special  CBF83419           embl_tpa_prot",
    "special  CBF83421           embl_tpa_prot",
    "special  CBF83423           embl_tpa_prot",
    "special  CBF83425-CBF83426  embl_tpa_prot",
    "special  CBF83428           embl_tpa_prot",
    "special  CBF83430-CBF83431  embl_tpa_prot",
    "special  CBF83433           embl_tpa_prot",
    "special  CBF83435           embl_tpa_prot",
    "special  CBF83437-CBF83438  embl_tpa_prot",
    "special  CBF83440           embl_tpa_prot",
    "special  CBF83442           embl_tpa_prot",
    "special  CBF83444           embl_tpa_prot",
    "special  CBF83446           embl_tpa_prot",
    "special  CBF83448           embl_tpa_prot",
    "special  CBF83450-CBF83451  embl_tpa_prot",
    "special  CBF83453           embl_tpa_prot",
    "special  CBF83455           embl_tpa_prot",
    "special  CBF83457-CBF83458  embl_tpa_prot",
    "special  CBF83460           embl_tpa_prot",
    "special  CBF83462           embl_tpa_prot",
    "special  CBF83464-CBF83465  embl_tpa_prot",
    "special  CBF83467           embl_tpa_prot",
    "special  CBF83469           embl_tpa_prot",
    "special  CBF83471           embl_tpa_prot",
    "special  CBF83473           embl_tpa_prot",
    "special  CBF83475           embl_tpa_prot",
    "special  CBF83477-CBF83478  embl_tpa_prot",
    "special  CBF83480           embl_tpa_prot",
    "special  CBF83482           embl_tpa_prot",
    "special  CBF83484-CBF83485  embl_tpa_prot",
    "special  CBF83487           embl_tpa_prot",
    "special  CBF83489           embl_tpa_prot",
    "special  CBF83491           embl_tpa_prot",
    "special  CBF83493           embl_tpa_prot",
    "special  CBF83495-CBF83496  embl_tpa_prot",
    "special  CBF83498           embl_tpa_prot",
    "special  CBF83500           embl_tpa_prot",
    "special  CBF83502-CBF83503  embl_tpa_prot",
    "special  CBF83505           embl_tpa_prot",
    "special  CBF83507           embl_tpa_prot",
    "special  CBF83509-CBF83510  embl_tpa_prot",
    "special  CBF83512           embl_tpa_prot",
    "special  CBF83514           embl_tpa_prot",
    "special  CBF83516-CBF83517  embl_tpa_prot",
    "special  CBF83519           embl_tpa_prot",
    "special  CBF83521           embl_tpa_prot",
    "special  CBF83523           embl_tpa_prot",
    "special  CBF83525-CBF83526  embl_tpa_prot",
    "special  CBF83528           embl_tpa_prot",
    "special  CBF83530           embl_tpa_prot",
    "special  CBF83532-CBF83533  embl_tpa_prot",
    "special  CBF83535           embl_tpa_prot",
    "special  CBF83537           embl_tpa_prot",
    "special  CBF83539           embl_tpa_prot",
    "special  CBF83541-CBF83542  embl_tpa_prot",
    "special  CBF83544           embl_tpa_prot",
    "special  CBF83546           embl_tpa_prot",
    "special  CBF83548           embl_tpa_prot",
    "special  CBF83550           embl_tpa_prot",
    "special  CBF83552-CBF83553  embl_tpa_prot",
    "special  CBF83555           embl_tpa_prot",
    "special  CBF83557           embl_tpa_prot",
    "special  CBF83559-CBF83560  embl_tpa_prot",
    "special  CBF83562           embl_tpa_prot",
    "special  CBF83564           embl_tpa_prot",
    "special  CBF83566           embl_tpa_prot",
    "special  CBF83568-CBF83569  embl_tpa_prot",
    "special  CBF83571           embl_tpa_prot",
    "special  CBF83573           embl_tpa_prot",
    "special  CBF83575           embl_tpa_prot",
    "special  CBF83577-CBF83578  embl_tpa_prot",
    "special  CBF83580           embl_tpa_prot",
    "special  CBF83582           embl_tpa_prot",
    "special  CBF83584-CBF83585  embl_tpa_prot",
    "special  CBF83587           embl_tpa_prot",
    "special  CBF83589           embl_tpa_prot",
    "special  CBF83591           embl_tpa_prot",
    "special  CBF83593           embl_tpa_prot",
    "special  CBF83595           embl_tpa_prot",
    "special  CBF83597-CBF83598  embl_tpa_prot",
    "special  CBF83600           embl_tpa_prot",
    "special  CBF83602           embl_tpa_prot",
    "special  CBF83604-CBF83605  embl_tpa_prot",
    "special  CBF83607           embl_tpa_prot",
    "special  CBF83609           embl_tpa_prot",
    "special  CBF83611-CBF83612  embl_tpa_prot",
    "special  CBF83614           embl_tpa_prot",
    "special  CBF83616-CBF83617  embl_tpa_prot",
    "special  CBF83619           embl_tpa_prot",
    "special  CBF83621           embl_tpa_prot",
    "special  CBF83623-CBF83624  embl_tpa_prot",
    "special  CBF83626           embl_tpa_prot",
    "special  CBF83628           embl_tpa_prot",
    "special  CBF83630           embl_tpa_prot",
    "special  CBF83632-CBF83633  embl_tpa_prot",
    "special  CBF83635           embl_tpa_prot",
    "special  CBF83637           embl_tpa_prot",
    "special  CBF83639           embl_tpa_prot",
    "special  CBF83641-CBF83642  embl_tpa_prot",
    "special  CBF83644           embl_tpa_prot",
    "special  CBF83646           embl_tpa_prot",
    "special  CBF83648-CBF83649  embl_tpa_prot",
    "special  CBF83651           embl_tpa_prot",
    "special  CBF83653           embl_tpa_prot",
    "special  CBF83655           embl_tpa_prot",
    "special  CBF83657-CBF83658  embl_tpa_prot",
    "special  CBF83660           embl_tpa_prot",
    "special  CBF83662           embl_tpa_prot",
    "special  CBF83664-CBF83665  embl_tpa_prot",
    "special  CBF83667           embl_tpa_prot",
    "special  CBF83669           embl_tpa_prot",
    "special  CBF83671-CBF83672  embl_tpa_prot",
    "special  CBF83674           embl_tpa_prot",
    "special  CBF83676           embl_tpa_prot",
    "special  CBF83678           embl_tpa_prot",
    "special  CBF83680           embl_tpa_prot",
    "special  CBF83682           embl_tpa_prot",
    "special  CBF83684-CBF83685  embl_tpa_prot",
    "special  CBF83687           embl_tpa_prot",
    "special  CBF83689           embl_tpa_prot",
    "special  CBF83691           embl_tpa_prot",
    "special  CBF83693           embl_tpa_prot",
    "special  CBF83695-CBF83697  embl_tpa_prot",
    "special  CBF83699           embl_tpa_prot",
    "special  CBF83701           embl_tpa_prot",
    "special  CBF83703-CBF83704  embl_tpa_prot",
    "special  CBF83706           embl_tpa_prot",
    "special  CBF83708           embl_tpa_prot",
    "special  CBF83710-CBF83711  embl_tpa_prot",
    "special  CBF83713           embl_tpa_prot",
    "special  CBF83715-CBF83716  embl_tpa_prot",
    "special  CBF83718           embl_tpa_prot",
    "special  CBF83720           embl_tpa_prot",
    "special  CBF83722-CBF83723  embl_tpa_prot",
    "special  CBF83725           embl_tpa_prot",
    "special  CBF83727-CBF83728  embl_tpa_prot",
    "special  CBF83730           embl_tpa_prot",
    "special  CBF83732           embl_tpa_prot",
    "special  CBF83734           embl_tpa_prot",
    "special  CBF83736           embl_tpa_prot",
    "special  CBF83738-CBF83739  embl_tpa_prot",
    "special  CBF83741           embl_tpa_prot",
    "special  CBF83743           embl_tpa_prot",
    "special  CBF83745           embl_tpa_prot",
    "special  CBF83748-CBF83749  embl_tpa_prot",
    "special  CBF83751           embl_tpa_prot",
    "special  CBF83753           embl_tpa_prot",
    "special  CBF83755-CBF83756  embl_tpa_prot",
    "special  CBF83758           embl_tpa_prot",
    "special  CBF83760           embl_tpa_prot",
    "special  CBF83762           embl_tpa_prot",
    "special  CBF83764-CBF83765  embl_tpa_prot",
    "special  CBF83767           embl_tpa_prot",
    "special  CBF83769           embl_tpa_prot",
    "special  CBF83771-CBF83772  embl_tpa_prot",
    "special  CBF83774           embl_tpa_prot",
    "special  CBF83776           embl_tpa_prot",
    "special  CBF83778           embl_tpa_prot",
    "special  CBF83780-CBF83781  embl_tpa_prot",
    "special  CBF83783           embl_tpa_prot",
    "special  CBF83785           embl_tpa_prot",
    "special  CBF83787           embl_tpa_prot",
    "special  CBF83789-CBF83790  embl_tpa_prot",
    "special  CBF83792           embl_tpa_prot",
    "special  CBF83794           embl_tpa_prot",
    "special  CBF83796-CBF83797  embl_tpa_prot",
    "special  CBF83799           embl_tpa_prot",
    "special  CBF83801           embl_tpa_prot",
    "special  CBF83803           embl_tpa_prot",
    "special  CBF83805-CBF83806  embl_tpa_prot",
    "special  CBF83808           embl_tpa_prot",
    "special  CBF83810           embl_tpa_prot",
    "special  CBF83812-CBF83813  embl_tpa_prot",
    "special  CBF83815           embl_tpa_prot",
    "special  CBF83817           embl_tpa_prot",
    "special  CBF83819-CBF83820  embl_tpa_prot",
    "special  CBF83822           embl_tpa_prot",
    "special  CBF83824           embl_tpa_prot",
    "special  CBF83826-CBF83827  embl_tpa_prot",
    "special  CBF83829           embl_tpa_prot",
    "special  CBF83831           embl_tpa_prot",
    "special  CBF83833           embl_tpa_prot",
    "special  CBF83835           embl_tpa_prot",
    "special  CBF83837-CBF83838  embl_tpa_prot",
    "special  CBF83840           embl_tpa_prot",
    "special  CBF83842           embl_tpa_prot",
    "special  CBF83844-CBF83845  embl_tpa_prot",
    "special  CBF83847           embl_tpa_prot",
    "special  CBF83849           embl_tpa_prot",
    "special  CBF83851           embl_tpa_prot",
    "special  CBF83853-CBF83854  embl_tpa_prot",
    "special  CBF83856           embl_tpa_prot",
    "special  CBF83858           embl_tpa_prot",
    "special  CBF83860           embl_tpa_prot",
    "special  CBF83862-CBF83863  embl_tpa_prot",
    "special  CBF83865           embl_tpa_prot",
    "special  CBF83867           embl_tpa_prot",
    "special  CBF83869-CBF83870  embl_tpa_prot",
    "special  CBF83872           embl_tpa_prot",
    "special  CBF83874-CBF83875  embl_tpa_prot",
    "special  CBF83877           embl_tpa_prot",
    "special  CBF83879           embl_tpa_prot",
    "special  CBF83881           embl_tpa_prot",
    "special  CBF83883-CBF83884  embl_tpa_prot",
    "special  CBF83886           embl_tpa_prot",
    "special  CBF83888           embl_tpa_prot",
    "special  CBF83890           embl_tpa_prot",
    "special  CBF83892-CBF83893  embl_tpa_prot",
    "special  CBF83895           embl_tpa_prot",
    "special  CBF83897           embl_tpa_prot",
    "special  CBF83899           embl_tpa_prot",
    "special  CBF83901-CBF83902  embl_tpa_prot",
    "special  CBF83904           embl_tpa_prot",
    "special  CBF83906           embl_tpa_prot",
    "special  CBF83908-CBF83909  embl_tpa_prot",
    "special  CBF83911           embl_tpa_prot",
    "special  CBF83913           embl_tpa_prot",
    "special  CBF83915           embl_tpa_prot",
    "special  CBF83917-CBF83918  embl_tpa_prot",
    "special  CBF83920           embl_tpa_prot",
    "special  CBF83922           embl_tpa_prot",
    "special  CBF83924           embl_tpa_prot",
    "special  CBF83926-CBF83927  embl_tpa_prot",
    "special  CBF83929           embl_tpa_prot",
    "special  CBF83931           embl_tpa_prot",
    "special  CBF83933           embl_tpa_prot",
    "special  CBF83935           embl_tpa_prot",
    "special  CBF83937-CBF83938  embl_tpa_prot",
    "special  CBF83940           embl_tpa_prot",
    "special  CBF83942-CBF83943  embl_tpa_prot",
    "special  CBF83945           embl_tpa_prot",
    "special  CBF83947-CBF83948  embl_tpa_prot",
    "special  CBF83950           embl_tpa_prot",
    "special  CBF83952           embl_tpa_prot",
    "special  CBF83954-CBF83955  embl_tpa_prot",
    "special  CBF83957           embl_tpa_prot",
    "special  CBF83959           embl_tpa_prot",
    "special  CBF83961           embl_tpa_prot",
    "special  CBF83963           embl_tpa_prot",
    "special  CBF83965           embl_tpa_prot",
    "special  CBF83967-CBF83968  embl_tpa_prot",
    "special  CBF83970           embl_tpa_prot",
    "special  CBF83972-CBF83973  embl_tpa_prot",
    "special  CBF83975           embl_tpa_prot",
    "special  CBF83977           embl_tpa_prot",
    "special  CBF83979-CBF83980  embl_tpa_prot",
    "special  CBF83982           embl_tpa_prot",
    "special  CBF83984           embl_tpa_prot",
    "special  CBF83986           embl_tpa_prot",
    "special  CBF83988           embl_tpa_prot",
    "special  CBF83990           embl_tpa_prot",
    "special  CBF83992-CBF83993  embl_tpa_prot",
    "special  CBF83995           embl_tpa_prot",
    "special  CBF83997           embl_tpa_prot",
    "special  CBF83999-CBF84000  embl_tpa_prot",
    "special  CBF84002           embl_tpa_prot",
    "special  CBF84004           embl_tpa_prot",
    "special  CBF84006           embl_tpa_prot",
    "special  CBF84008           embl_tpa_prot",
    "special  CBF84010-CBF84011  embl_tpa_prot",
    "special  CBF84013           embl_tpa_prot",
    "special  CBF84015           embl_tpa_prot",
    "special  CBF84017-CBF84018  embl_tpa_prot",
    "special  CBF84020           embl_tpa_prot",
    "special  CBF84022           embl_tpa_prot",
    "special  CBF84024-CBF84025  embl_tpa_prot",
    "special  CBF84027           embl_tpa_prot",
    "special  CBF84029-CBF84030  embl_tpa_prot",
    "special  CBF84032           embl_tpa_prot",
    "special  CBF84034           embl_tpa_prot",
    "special  CBF84036-CBF84037  embl_tpa_prot",
    "special  CBF84039           embl_tpa_prot",
    "special  CBF84041           embl_tpa_prot",
    "special  CBF84043           embl_tpa_prot",
    "special  CBF84045-CBF84046  embl_tpa_prot",
    "special  CBF84048           embl_tpa_prot",
    "special  CBF84050-CBF84051  embl_tpa_prot",
    "special  CBF84053           embl_tpa_prot",
    "special  CBF84055           embl_tpa_prot",
    "special  CBF84057           embl_tpa_prot",
    "special  CBF84059-CBF84060  embl_tpa_prot",
    "special  CBF84062           embl_tpa_prot",
    "special  CBF84064           embl_tpa_prot",
    "special  CBF84066-CBF84067  embl_tpa_prot",
    "special  CBF84069-CBF84070  embl_tpa_prot",
    "special  CBF84072           embl_tpa_prot",
    "special  CBF84074           embl_tpa_prot",
    "special  CBF84076           embl_tpa_prot",
    "special  CBF84078-CBF84079  embl_tpa_prot",
    "special  CBF84081           embl_tpa_prot",
    "special  CBF84083           embl_tpa_prot",
    "special  CBF84085-CBF84086  embl_tpa_prot",
    "special  CBF84088           embl_tpa_prot",
    "special  CBF84090           embl_tpa_prot",
    "special  CBF84092           embl_tpa_prot",
    "special  CBF84094           embl_tpa_prot",
    "special  CBF84096           embl_tpa_prot",
    "special  CBF84098           embl_tpa_prot",
    "special  CBF84100-CBF84101  embl_tpa_prot",
    "special  CBF84103           embl_tpa_prot",
    "special  CBF84105           embl_tpa_prot",
    "special  CBF84107-CBF84108  embl_tpa_prot",
    "special  CBF84110           embl_tpa_prot",
    "special  CBF84112           embl_tpa_prot",
    "special  CBF84114           embl_tpa_prot",
    "special  CBF84116-CBF84117  embl_tpa_prot",
    "special  CBF84119           embl_tpa_prot",
    "special  CBF84121           embl_tpa_prot",
    "special  CBF84123-CBF84124  embl_tpa_prot",
    "special  CBF84126           embl_tpa_prot",
    "special  CBF84128           embl_tpa_prot",
    "special  CBF84130-CBF84131  embl_tpa_prot",
    "special  CBF84133           embl_tpa_prot",
    "special  CBF84135           embl_tpa_prot",
    "special  CBF84137           embl_tpa_prot",
    "special  CBF84139           embl_tpa_prot",
    "special  CBF84141-CBF84142  embl_tpa_prot",
    "special  CBF84144           embl_tpa_prot",
    "special  CBF84146           embl_tpa_prot",
    "special  CBF84148-CBF84149  embl_tpa_prot",
    "special  CBF84151           embl_tpa_prot",
    "special  CBF84153           embl_tpa_prot",
    "special  CBF84155           embl_tpa_prot",
    "special  CBF84157-CBF84158  embl_tpa_prot",
    "special  CBF84160           embl_tpa_prot",
    "special  CBF84162-CBF84163  embl_tpa_prot",
    "special  CBF84165           embl_tpa_prot",
    "special  CBF84167           embl_tpa_prot",
    "special  CBF84169-CBF84170  embl_tpa_prot",
    "special  CBF84172           embl_tpa_prot",
    "special  CBF84174           embl_tpa_prot",
    "special  CBF84176           embl_tpa_prot",
    "special  CBF84178           embl_tpa_prot",
    "special  CBF84180-CBF84181  embl_tpa_prot",
    "special  CBF84183           embl_tpa_prot",
    "special  CBF84185           embl_tpa_prot",
    "special  CBF84187           embl_tpa_prot",
    "special  CBF84189-CBF84191  embl_tpa_prot",
    "special  CBF84193-CBF84194  embl_tpa_prot",
    "special  CBF84196           embl_tpa_prot",
    "special  CBF84198           embl_tpa_prot",
    "special  CBF84200           embl_tpa_prot",
    "special  CBF84202-CBF84203  embl_tpa_prot",
    "special  CBF84205           embl_tpa_prot",
    "special  CBF84207           embl_tpa_prot",
    "special  CBF84209-CBF84210  embl_tpa_prot",
    "special  CBF84212-CBF84213  embl_tpa_prot",
    "special  CBF84215           embl_tpa_prot",
    "special  CBF84217           embl_tpa_prot",
    "special  CBF84219           embl_tpa_prot",
    "special  CBF84222           embl_tpa_prot",
    "special  CBF84224-CBF84225  embl_tpa_prot",
    "special  CBF84227           embl_tpa_prot",
    "special  CBF84229           embl_tpa_prot",
    "special  CBF84231           embl_tpa_prot",
    "special  CBF84233-CBF84234  embl_tpa_prot",
    "special  CBF84236           embl_tpa_prot",
    "special  CBF84238           embl_tpa_prot",
    "special  CBF84240-CBF84241  embl_tpa_prot",
    "special  CBF84243           embl_tpa_prot",
    "special  CBF84245           embl_tpa_prot",
    "special  CBF84247           embl_tpa_prot",
    "special  CBF84249           embl_tpa_prot",
    "special  CBF84251-CBF84252  embl_tpa_prot",
    "special  CBF84254           embl_tpa_prot",
    "special  CBF84256           embl_tpa_prot",
    "special  CBF84258-CBF84259  embl_tpa_prot",
    "special  CBF84261           embl_tpa_prot",
    "special  CBF84263           embl_tpa_prot",
    "special  CBF84265           embl_tpa_prot",
    "special  CBF84267           embl_tpa_prot",
    "special  CBF84269-CBF84270  embl_tpa_prot",
    "special  CBF84273-CBF84274  embl_tpa_prot",
    "special  CBF84276           embl_tpa_prot",
    "special  CBF84278           embl_tpa_prot",
    "special  CBF84280           embl_tpa_prot",
    "special  CBF84282           embl_tpa_prot",
    "special  CBF84284-CBF84285  embl_tpa_prot",
    "special  CBF84287           embl_tpa_prot",
    "special  CBF84289           embl_tpa_prot",
    "special  CBF84291-CBF84292  embl_tpa_prot",
    "special  CBF84294           embl_tpa_prot",
    "special  CBF84296           embl_tpa_prot",
    "special  CBF84298           embl_tpa_prot",
    "special  CBF84300           embl_tpa_prot",
    "special  CBF84302           embl_tpa_prot",
    "special  CBF84304           embl_tpa_prot",
    "special  CBF84306-CBF84307  embl_tpa_prot",
    "special  CBF84309           embl_tpa_prot",
    "special  CBF84311           embl_tpa_prot",
    "special  CBF84313           embl_tpa_prot",
    "special  CBF84315-CBF84316  embl_tpa_prot",
    "special  CBF84318           embl_tpa_prot",
    "special  CBF84320           embl_tpa_prot",
    "special  CBF84322           embl_tpa_prot",
    "special  CBF84324           embl_tpa_prot",
    "special  CBF84326           embl_tpa_prot",
    "special  CBF84328-CBF84329  embl_tpa_prot",
    "special  CBF84331           embl_tpa_prot",
    "special  CBF84333           embl_tpa_prot",
    "special  CBF84335-CBF84336  embl_tpa_prot",
    "special  CBF84338           embl_tpa_prot",
    "special  CBF84340           embl_tpa_prot",
    "special  CBF84342           embl_tpa_prot",
    "special  CBF84344           embl_tpa_prot",
    "special  CBF84346-CBF84347  embl_tpa_prot",
    "special  CBF84349           embl_tpa_prot",
    "special  CBF84351           embl_tpa_prot",
    "special  CBF84353           embl_tpa_prot",
    "special  CBF84355           embl_tpa_prot",
    "special  CBF84357           embl_tpa_prot",
    "special  CBF84359           embl_tpa_prot",
    "special  CBF84361           embl_tpa_prot",
    "special  CBF84372-CBF84373  embl_tpa_prot",
    "special  CBF84375           embl_tpa_prot",
    "special  CBF84377           embl_tpa_prot",
    "special  CBF84379           embl_tpa_prot",
    "special  CBF84381           embl_tpa_prot",
    "special  CBF84383-CBF84384  embl_tpa_prot",
    "special  CBF84386           embl_tpa_prot",
    "special  CBF84388           embl_tpa_prot",
    "special  CBF84390-CBF84391  embl_tpa_prot",
    "special  CBF84393           embl_tpa_prot",
    "special  CBF84395-CBF84396  embl_tpa_prot",
    "special  CBF84398           embl_tpa_prot",
    "special  CBF84400           embl_tpa_prot",
    "special  CBF84402           embl_tpa_prot",
    "special  CBF84404           embl_tpa_prot",
    "special  CBF84406           embl_tpa_prot",
    "special  CBF84408           embl_tpa_prot",
    "special  CBF84410           embl_tpa_prot",
    "special  CBF84412           embl_tpa_prot",
    "special  CBF84414           embl_tpa_prot",
    "special  CBF84416-CBF84417  embl_tpa_prot",
    "special  CBF84419           embl_tpa_prot",
    "special  CBF84421           embl_tpa_prot",
    "special  CBF84423           embl_tpa_prot",
    "special  CBF84425           embl_tpa_prot",
    "special  CBF84427-CBF84428  embl_tpa_prot",
    "special  CBF84430           embl_tpa_prot",
    "special  CBF84432           embl_tpa_prot",
    "special  CBF84434           embl_tpa_prot",
    "special  CBF84436           embl_tpa_prot",
    "special  CBF84438-CBF84439  embl_tpa_prot",
    "special  CBF84441           embl_tpa_prot",
    "special  CBF84443           embl_tpa_prot",
    "special  CBF84445           embl_tpa_prot",
    "special  CBF84447           embl_tpa_prot",
    "special  CBF84449-CBF84450  embl_tpa_prot",
    "special  CBF84452           embl_tpa_prot",
    "special  CBF84454           embl_tpa_prot",
    "special  CBF84456           embl_tpa_prot",
    "special  CBF84458           embl_tpa_prot",
    "special  CBF84460-CBF84461  embl_tpa_prot",
    "special  CBF84463           embl_tpa_prot",
    "special  CBF84465           embl_tpa_prot",
    "special  CBF84467           embl_tpa_prot",
    "special  CBF84469           embl_tpa_prot",
    "special  CBF84471           embl_tpa_prot",
    "special  CBF84473           embl_tpa_prot",
    "special  CBF84475-CBF84476  embl_tpa_prot",
    "special  CBF84478           embl_tpa_prot",
    "special  CBF84480           embl_tpa_prot",
    "special  CBF84482           embl_tpa_prot",
    "special  CBF84484           embl_tpa_prot",
    "special  CBF84486           embl_tpa_prot",
    "special  CBF84488-CBF84489  embl_tpa_prot",
    "special  CBF84491           embl_tpa_prot",
    "special  CBF84493           embl_tpa_prot",
    "special  CBF84495           embl_tpa_prot",
    "special  CBF84497           embl_tpa_prot",
    "special  CBF84499-CBF84500  embl_tpa_prot",
    "special  CBF84502           embl_tpa_prot",
    "special  CBF84504           embl_tpa_prot",
    "special  CBF84506           embl_tpa_prot",
    "special  CBF84508           embl_tpa_prot",
    "special  CBF84510           embl_tpa_prot",
    "special  CBF84512           embl_tpa_prot",
    "special  CBF84514-CBF84515  embl_tpa_prot",
    "special  CBF84517           embl_tpa_prot",
    "special  CBF84519           embl_tpa_prot",
    "special  CBF84521           embl_tpa_prot",
    "special  CBF84523-CBF84524  embl_tpa_prot",
    "special  CBF84526           embl_tpa_prot",
    "special  CBF84528-CBF84529  embl_tpa_prot",
    "special  CBF84531           embl_tpa_prot",
    "special  CBF84533           embl_tpa_prot",
    "special  CBF84535           embl_tpa_prot",
    "special  CBF84537           embl_tpa_prot",
    "special  CBF84539           embl_tpa_prot",
    "special  CBF84541-CBF84542  embl_tpa_prot",
    "special  CBF84544           embl_tpa_prot",
    "special  CBF84546           embl_tpa_prot",
    "special  CBF84548           embl_tpa_prot",
    "special  CBF84550           embl_tpa_prot",
    "special  CBF84552           embl_tpa_prot",
    "special  CBF84554-CBF84555  embl_tpa_prot",
    "special  CBF84557           embl_tpa_prot",
    "special  CBF84559           embl_tpa_prot",
    "special  CBF84561           embl_tpa_prot",
    "special  CBF84563           embl_tpa_prot",
    "special  CBF84565           embl_tpa_prot",
    "special  CBF84567           embl_tpa_prot",
    "special  CBF84569           embl_tpa_prot",
    "special  CBF84571-CBF84572  embl_tpa_prot",
    "special  CBF84574           embl_tpa_prot",
    "special  CBF84576           embl_tpa_prot",
    "special  CBF84578           embl_tpa_prot",
    "special  CBF84580-CBF84581  embl_tpa_prot",
    "special  CBF84583           embl_tpa_prot",
    "special  CBF84585           embl_tpa_prot",
    "special  CBF84587           embl_tpa_prot",
    "special  CBF84589           embl_tpa_prot",
    "special  CBF84591-CBF84592  embl_tpa_prot",
    "special  CBF84594           embl_tpa_prot",
    "special  CBF84596           embl_tpa_prot",
    "special  CBF84598           embl_tpa_prot",
    "special  CBF84600           embl_tpa_prot",
    "special  CBF84602           embl_tpa_prot",
    "special  CBF84604           embl_tpa_prot",
    "special  CBF84606           embl_tpa_prot",
    "special  CBF84608-CBF84609  embl_tpa_prot",
    "special  CBF84611           embl_tpa_prot",
    "special  CBF84613           embl_tpa_prot",
    "special  CBF84615           embl_tpa_prot",
    "special  CBF84617           embl_tpa_prot",
    "special  CBF84619           embl_tpa_prot",
    "special  CBF84621           embl_tpa_prot",
    "special  CBF84623-CBF84624  embl_tpa_prot",
    "special  CBF84626           embl_tpa_prot",
    "special  CBF84628           embl_tpa_prot",
    "special  CBF84630           embl_tpa_prot",
    "special  CBF84632           embl_tpa_prot",
    "special  CBF84634           embl_tpa_prot",
    "special  CBF84636           embl_tpa_prot",
    "special  CBF84638           embl_tpa_prot",
    "special  CBF84640           embl_tpa_prot",
    "special  CBF84642           embl_tpa_prot",
    "special  CBF84644-CBF84645  embl_tpa_prot",
    "special  CBF84647           embl_tpa_prot",
    "special  CBF84649           embl_tpa_prot",
    "special  CBF84651           embl_tpa_prot",
    "special  CBF84653           embl_tpa_prot",
    "special  CBF84655-CBF84656  embl_tpa_prot",
    "special  CBF84658           embl_tpa_prot",
    "special  CBF84660           embl_tpa_prot",
    "special  CBF84662           embl_tpa_prot",
    "special  CBF84664           embl_tpa_prot",
    "special  CBF84666           embl_tpa_prot",
    "special  CBF84668           embl_tpa_prot",
    "special  CBF84670           embl_tpa_prot",
    "special  CBF84672           embl_tpa_prot",
    "special  CBF84674-CBF84675  embl_tpa_prot",
    "special  CBF84677           embl_tpa_prot",
    "special  CBF84679           embl_tpa_prot",
    "special  CBF84681           embl_tpa_prot",
    "special  CBF84683           embl_tpa_prot",
    "special  CBF84685-CBF84686  embl_tpa_prot",
    "special  CBF84688-CBF84689  embl_tpa_prot",
    "special  CBF84691           embl_tpa_prot",
    "special  CBF84693           embl_tpa_prot",
    "special  CBF84695           embl_tpa_prot",
    "special  CBF84697           embl_tpa_prot",
    "special  CBF84699           embl_tpa_prot",
    "special  CBF84701-CBF84702  embl_tpa_prot",
    "special  CBF84704           embl_tpa_prot",
    "special  CBF84706           embl_tpa_prot",
    "special  CBF84708           embl_tpa_prot",
    "special  CBF84710-CBF84711  embl_tpa_prot",
    "special  CBF84713           embl_tpa_prot",
    "special  CBF84715           embl_tpa_prot",
    "special  CBF84717           embl_tpa_prot",
    "special  CBF84719           embl_tpa_prot",
    "special  CBF84721           embl_tpa_prot",
    "special  CBF84723-CBF84724  embl_tpa_prot",
    "special  CBF84726           embl_tpa_prot",
    "special  CBF84729           embl_tpa_prot",
    "special  CBF84731           embl_tpa_prot",
    "special  CBF84733           embl_tpa_prot",
    "special  CBF84735           embl_tpa_prot",
    "special  CBF84738-CBF84739  embl_tpa_prot",
    "special  CBF84741           embl_tpa_prot",
    "special  CBF84743           embl_tpa_prot",
    "special  CBF84745           embl_tpa_prot",
    "special  CBF84747           embl_tpa_prot",
    "special  CBF84749           embl_tpa_prot",
    "special  CBF84751           embl_tpa_prot",
    "special  CBF84753-CBF84754  embl_tpa_prot",
    "special  CBF84756           embl_tpa_prot",
    "special  CBF84758           embl_tpa_prot",
    "special  CBF84760           embl_tpa_prot",
    "special  CBF84762           embl_tpa_prot",
    "special  CBF84764-CBF84765  embl_tpa_prot",
    "special  CBF84767           embl_tpa_prot",
    "special  CBF84769           embl_tpa_prot",
    "special  CBF84771           embl_tpa_prot",
    "special  CBF84773           embl_tpa_prot",
    "special  CBF84775           embl_tpa_prot",
    "special  CBF84777           embl_tpa_prot",
    "special  CBF84779-CBF84780  embl_tpa_prot",
    "special  CBF84782           embl_tpa_prot",
    "special  CBF84784           embl_tpa_prot",
    "special  CBF84786           embl_tpa_prot",
    "special  CBF84788-CBF84789  embl_tpa_prot",
    "special  CBF84791           embl_tpa_prot",
    "special  CBF84793           embl_tpa_prot",
    "special  CBF84795           embl_tpa_prot",
    "special  CBF84797           embl_tpa_prot",
    "special  CBF84799           embl_tpa_prot",
    "special  CBF84801-CBF84802  embl_tpa_prot",
    "special  CBF84804           embl_tpa_prot",
    "special  CBF84806           embl_tpa_prot",
    "special  CBF84808           embl_tpa_prot",
    "special  CBF84810           embl_tpa_prot",
    "special  CBF84812-CBF84813  embl_tpa_prot",
    "special  CBF84815           embl_tpa_prot",
    "special  CBF84817           embl_tpa_prot",
    "special  CBF84819           embl_tpa_prot",
    "special  CBF84821           embl_tpa_prot",
    "special  CBF84823           embl_tpa_prot",
    "special  CBF84825           embl_tpa_prot",
    "special  CBF84827-CBF84828  embl_tpa_prot",
    "special  CBF84830           embl_tpa_prot",
    "special  CBF84832           embl_tpa_prot",
    "special  CBF84834           embl_tpa_prot",
    "special  CBF84836           embl_tpa_prot",
    "special  CBF84838           embl_tpa_prot",
    "special  CBF84840           embl_tpa_prot",
    "special  CBF84842-CBF84843  embl_tpa_prot",
    "special  CBF84845           embl_tpa_prot",
    "special  CBF84847           embl_tpa_prot",
    "special  CBF84849           embl_tpa_prot",
    "special  CBF84851           embl_tpa_prot",
    "special  CBF84853           embl_tpa_prot",
    "special  CBF84855           embl_tpa_prot",
    "special  CBF84857-CBF84858  embl_tpa_prot",
    "special  CBF84860           embl_tpa_prot",
    "special  CBF84862           embl_tpa_prot",
    "special  CBF84864           embl_tpa_prot",
    "special  CBF84867-CBF84868  embl_tpa_prot",
    "special  CBF84870-CBF84871  embl_tpa_prot",
    "special  CBF84873           embl_tpa_prot",
    "special  CBF84875           embl_tpa_prot",
    "special  CBF84877           embl_tpa_prot",
    "special  CBF84879-CBF84880  embl_tpa_prot",
    "special  CBF84882           embl_tpa_prot",
    "special  CBF84884           embl_tpa_prot",
    "special  CBF84886           embl_tpa_prot",
    "special  CBF84888           embl_tpa_prot",
    "special  CBF84890-CBF84891  embl_tpa_prot",
    "special  CBF84893           embl_tpa_prot",
    "special  CBF84895           embl_tpa_prot",
    "special  CBF84897           embl_tpa_prot",
    "special  CBF84899           embl_tpa_prot",
    "special  CBF84901           embl_tpa_prot",
    "special  CBF84903           embl_tpa_prot",
    "special  CBF84905-CBF84906  embl_tpa_prot",
    "special  CBF84908           embl_tpa_prot",
    "special  CBF84910           embl_tpa_prot",
    "special  CBF84912-CBF84913  embl_tpa_prot",
    "special  CBF84915           embl_tpa_prot",
    "special  CBF84917           embl_tpa_prot",
    "special  CBF84919           embl_tpa_prot",
    "special  CBF84921           embl_tpa_prot",
    "special  CBF84923-CBF84924  embl_tpa_prot",
    "special  CBF84926           embl_tpa_prot",
    "special  CBF84928           embl_tpa_prot",
    "special  CBF84930           embl_tpa_prot",
    "special  CBF84932           embl_tpa_prot",
    "special  CBF84934           embl_tpa_prot",
    "special  CBF84936-CBF84937  embl_tpa_prot",
    "special  CBF84939           embl_tpa_prot",
    "special  CBF84941           embl_tpa_prot",
    "special  CBF84943           embl_tpa_prot",
    "special  CBF84945           embl_tpa_prot",
    "special  CBF84947           embl_tpa_prot",
    "special  CBF84949-CBF84950  embl_tpa_prot",
    "special  CBF84952           embl_tpa_prot",
    "special  CBF84954           embl_tpa_prot",
    "special  CBF84956           embl_tpa_prot",
    "special  CBF84958           embl_tpa_prot",
    "special  CBF84960           embl_tpa_prot",
    "special  CBF84962           embl_tpa_prot",
    "special  CBF84964-CBF84965  embl_tpa_prot",
    "special  CBF84967-CBF84968  embl_tpa_prot",
    "special  CBF84970-CBF84971  embl_tpa_prot",
    "special  CBF84973-CBF84974  embl_tpa_prot",
    "special  CBF84976           embl_tpa_prot",
    "special  CBF84978           embl_tpa_prot",
    "special  CBF84980           embl_tpa_prot",
    "special  CBF84982           embl_tpa_prot",
    "special  CBF84984           embl_tpa_prot",
    "special  CBF84986-CBF84987  embl_tpa_prot",
    "special  CBF84989           embl_tpa_prot",
    "special  CBF84991           embl_tpa_prot",
    "special  CBF84993           embl_tpa_prot",
    "special  CBF84995-CBF84996  embl_tpa_prot",
    "special  CBF84998           embl_tpa_prot",
    "special  CBF85000           embl_tpa_prot",
    "special  CBF85002           embl_tpa_prot",
    "special  CBF85004           embl_tpa_prot",
    "special  CBF85006-CBF85007  embl_tpa_prot",
    "special  CBF85009           embl_tpa_prot",
    "special  CBF85011           embl_tpa_prot",
    "special  CBF85013           embl_tpa_prot",
    "special  CBF85015           embl_tpa_prot",
    "special  CBF85017           embl_tpa_prot",
    "special  CBF85019-CBF85020  embl_tpa_prot",
    "special  CBF85022           embl_tpa_prot",
    "special  CBF85024           embl_tpa_prot",
    "special  CBF85026           embl_tpa_prot",
    "special  CBF85028           embl_tpa_prot",
    "special  CBF85030-CBF85031  embl_tpa_prot",
    "special  CBF85033           embl_tpa_prot",
    "special  CBF85035           embl_tpa_prot",
    "special  CBF85037           embl_tpa_prot",
    "special  CBF85039-CBF85040  embl_tpa_prot",
    "special  CBF85042           embl_tpa_prot",
    "special  CBF85044           embl_tpa_prot",
    "special  CBF85046           embl_tpa_prot",
    "special  CBF85048           embl_tpa_prot",
    "special  CBF85050           embl_tpa_prot",
    "special  CBF85052           embl_tpa_prot",
    "special  CBF85054           embl_tpa_prot",
    "special  CBF85056           embl_tpa_prot",
    "special  CBF85058           embl_tpa_prot",
    "special  CBF85060           embl_tpa_prot",
    "special  CBF85062           embl_tpa_prot",
    "special  CBF85064-CBF85065  embl_tpa_prot",
    "special  CBF85067           embl_tpa_prot",
    "special  CBF85069           embl_tpa_prot",
    "special  CBF85071           embl_tpa_prot",
    "special  CBF85073           embl_tpa_prot",
    "special  CBF85075-CBF85076  embl_tpa_prot",
    "special  CBF85078           embl_tpa_prot",
    "special  CBF85080           embl_tpa_prot",
    "special  CBF85082           embl_tpa_prot",
    "special  CBF85084-CBF85085  embl_tpa_prot",
    "special  CBF85087           embl_tpa_prot",
    "special  CBF85089           embl_tpa_prot",
    "special  CBF85091           embl_tpa_prot",
    "special  CBF85093           embl_tpa_prot",
    "special  CBF85095           embl_tpa_prot",
    "special  CBF85097-CBF85098  embl_tpa_prot",
    "special  CBF85100           embl_tpa_prot",
    "special  CBF85102           embl_tpa_prot",
    "special  CBF85104-CBF85105  embl_tpa_prot",
    "special  CBF85107           embl_tpa_prot",
    "special  CBF85109           embl_tpa_prot",
    "special  CBF85111           embl_tpa_prot",
    "special  CBF85113           embl_tpa_prot",
    "special  CBF85115           embl_tpa_prot",
    "special  CBF85117-CBF85118  embl_tpa_prot",
    "special  CBF85120           embl_tpa_prot",
    "special  CBF85122           embl_tpa_prot",
    "special  CBF85124-CBF85125  embl_tpa_prot",
    "special  CBF85127           embl_tpa_prot",
    "special  CBF85129-CBF85130  embl_tpa_prot",
    "special  CBF85132           embl_tpa_prot",
    "special  CBF85134           embl_tpa_prot",
    "special  CBF85136           embl_tpa_prot",
    "special  CBF85138           embl_tpa_prot",
    "special  CBF85140           embl_tpa_prot",
    "special  CBF85142           embl_tpa_prot",
    "special  CBF85144           embl_tpa_prot",
    "special  CBF85146           embl_tpa_prot",
    "special  CBF85148-CBF85149  embl_tpa_prot",
    "special  CBF85151           embl_tpa_prot",
    "special  CBF85153           embl_tpa_prot",
    "special  CBF85155           embl_tpa_prot",
    "special  CBF85157           embl_tpa_prot",
    "special  CBF85159           embl_tpa_prot",
    "special  CBF85161-CBF85162  embl_tpa_prot",
    "special  CBF85164           embl_tpa_prot",
    "special  CBF85166           embl_tpa_prot",
    "special  CBF85168           embl_tpa_prot",
    "special  CBF85170-CBF85171  embl_tpa_prot",
    "special  CBF85173           embl_tpa_prot",
    "special  CBF85175           embl_tpa_prot",
    "special  CBF85177           embl_tpa_prot",
    "special  CBF85179           embl_tpa_prot",
    "special  CBF85181-CBF85182  embl_tpa_prot",
    "special  CBF85184           embl_tpa_prot",
    "special  CBF85186           embl_tpa_prot",
    "special  CBF85188           embl_tpa_prot",
    "special  CBF85190           embl_tpa_prot",
    "special  CBF85192-CBF85193  embl_tpa_prot",
    "special  CBF85195           embl_tpa_prot",
    "special  CBF85197           embl_tpa_prot",
    "special  CBF85199           embl_tpa_prot",
    "special  CBF85201-CBF85202  embl_tpa_prot",
    "special  CBF85204           embl_tpa_prot",
    "special  CBF85206           embl_tpa_prot",
    "special  CBF85208           embl_tpa_prot",
    "special  CBF85210           embl_tpa_prot",
    "special  CBF85212-CBF85213  embl_tpa_prot",
    "special  CBF85215           embl_tpa_prot",
    "special  CBF85217           embl_tpa_prot",
    "special  CBF85220-CBF85221  embl_tpa_prot",
    "special  CBF85223           embl_tpa_prot",
    "special  CBF85225-CBF85226  embl_tpa_prot",
    "special  CBF85228           embl_tpa_prot",
    "special  CBF85230           embl_tpa_prot",
    "special  CBF85232           embl_tpa_prot",
    "special  CBF85234           embl_tpa_prot",
    "special  CBF85236-CBF85237  embl_tpa_prot",
    "special  CBF85239           embl_tpa_prot",
    "special  CBF85241           embl_tpa_prot",
    "special  CBF85243           embl_tpa_prot",
    "special  CBF85245           embl_tpa_prot",
    "special  CBF85247           embl_tpa_prot",
    "special  CBF85249           embl_tpa_prot",
    "special  CBF85251-CBF85252  embl_tpa_prot",
    "special  CBF85254           embl_tpa_prot",
    "special  CBF85256           embl_tpa_prot",
    "special  CBF85258           embl_tpa_prot",
    "special  CBF85260           embl_tpa_prot",
    "special  CBF85262           embl_tpa_prot",
    "special  CBF85264-CBF85265  embl_tpa_prot",
    "special  CBF85267           embl_tpa_prot",
    "special  CBF85269           embl_tpa_prot",
    "special  CBF85271           embl_tpa_prot",
    "special  CBF85273           embl_tpa_prot",
    "special  CBF85275           embl_tpa_prot",
    "special  CBF85277           embl_tpa_prot",
    "special  CBF85279           embl_tpa_prot",
    "special  CBF85281           embl_tpa_prot",
    "special  CBF85283-CBF85284  embl_tpa_prot",
    "special  CBF85286           embl_tpa_prot",
    "special  CBF85288           embl_tpa_prot",
    "special  CBF85290           embl_tpa_prot",
    "special  CBF85292           embl_tpa_prot",
    "special  CBF85294-CBF85295  embl_tpa_prot",
    "special  CBF85297           embl_tpa_prot",
    "special  CBF85299           embl_tpa_prot",
    "special  CBF85301           embl_tpa_prot",
    "special  CBF85303           embl_tpa_prot",
    "special  CBF85305-CBF85306  embl_tpa_prot",
    "special  CBF85308           embl_tpa_prot",
    "special  CBF85310           embl_tpa_prot",
    "special  CBF85312           embl_tpa_prot",
    "special  CBF85314           embl_tpa_prot",
    "special  CBF85316           embl_tpa_prot",
    "special  CBF85318-CBF85319  embl_tpa_prot",
    "special  CBF85321           embl_tpa_prot",
    "special  CBF85323           embl_tpa_prot",
    "special  CBF85325           embl_tpa_prot",
    "special  CBF85327           embl_tpa_prot",
    "special  CBF85329           embl_tpa_prot",
    "special  CBF85331-CBF85332  embl_tpa_prot",
    "special  CBF85334           embl_tpa_prot",
    "special  CBF85336           embl_tpa_prot",
    "special  CBF85338           embl_tpa_prot",
    "special  CBF85340-CBF85341  embl_tpa_prot",
    "special  CBF85343           embl_tpa_prot",
    "special  CBF85345           embl_tpa_prot",
    "special  CBF85347           embl_tpa_prot",
    "special  CBF85349           embl_tpa_prot",
    "special  CBF85351           embl_tpa_prot",
    "special  CBF85353-CBF85354  embl_tpa_prot",
    "special  CBF85356           embl_tpa_prot",
    "special  CBF85358           embl_tpa_prot",
    "special  CBF85360           embl_tpa_prot",
    "special  CBF85362           embl_tpa_prot",
    "special  CBF85364-CBF85365  embl_tpa_prot",
    "special  CBF85367           embl_tpa_prot",
    "special  CBF85369           embl_tpa_prot",
    "special  CBF85371-CBF85372  embl_tpa_prot",
    "special  CBF85374           embl_tpa_prot",
    "special  CBF85376           embl_tpa_prot",
    "special  CBF85378           embl_tpa_prot",
    "special  CBF85380           embl_tpa_prot",
    "special  CBF85382           embl_tpa_prot",
    "special  CBF85384-CBF85385  embl_tpa_prot",
    "special  CBF85387           embl_tpa_prot",
    "special  CBF85389           embl_tpa_prot",
    "special  CBF85391-CBF85392  embl_tpa_prot",
    "special  CBF85394           embl_tpa_prot",
    "special  CBF85396           embl_tpa_prot",
    "special  CBF85398           embl_tpa_prot",
    "special  CBF85400           embl_tpa_prot",
    "special  CBF85402           embl_tpa_prot",
    "special  CBF85404-CBF85405  embl_tpa_prot",
    "special  CBF85407           embl_tpa_prot",
    "special  CBF85409           embl_tpa_prot",
    "special  CBF85411           embl_tpa_prot",
    "special  CBF85413-CBF85414  embl_tpa_prot",
    "special  CBF85416           embl_tpa_prot",
    "special  CBF85418           embl_tpa_prot",
    "special  CBF85420           embl_tpa_prot",
    "special  CBF85422           embl_tpa_prot",
    "special  CBF85424-CBF85425  embl_tpa_prot",
    "special  CBF85427           embl_tpa_prot",
    "special  CBF85429           embl_tpa_prot",
    "special  CBF85431           embl_tpa_prot",
    "special  CBF85433           embl_tpa_prot",
    "special  CBF85435-CBF85436  embl_tpa_prot",
    "special  CBF85438           embl_tpa_prot",
    "special  CBF85440           embl_tpa_prot",
    "special  CBF85442           embl_tpa_prot",
    "special  CBF85444           embl_tpa_prot",
    "special  CBF85446-CBF85447  embl_tpa_prot",
    "special  CBF85449           embl_tpa_prot",
    "special  CBF85451           embl_tpa_prot",
    "special  CBF85453           embl_tpa_prot",
    "special  CBF85455-CBF85456  embl_tpa_prot",
    "special  CBF85458           embl_tpa_prot",
    "special  CBF85460           embl_tpa_prot",
    "special  CBF85462           embl_tpa_prot",
    "special  CBF85464           embl_tpa_prot",
    "special  CBF85466-CBF85467  embl_tpa_prot",
    "special  CBF85469           embl_tpa_prot",
    "special  CBF85471           embl_tpa_prot",
    "special  CBF85473           embl_tpa_prot",
    "special  CBF85475           embl_tpa_prot",
    "special  CBF85477           embl_tpa_prot",
    "special  CBF85479-CBF85480  embl_tpa_prot",
    "special  CBF85482           embl_tpa_prot",
    "special  CBF85484           embl_tpa_prot",
    "special  CBF85486-CBF85487  embl_tpa_prot",
    "special  CBF85489           embl_tpa_prot",
    "special  CBF85492           embl_tpa_prot",
    "special  CBF85494           embl_tpa_prot",
    "special  CBF85496           embl_tpa_prot",
    "special  CBF85498-CBF85499  embl_tpa_prot",
    "special  CBF85501           embl_tpa_prot",
    "special  CBF85503           embl_tpa_prot",
    "special  CBF85505           embl_tpa_prot",
    "special  CBF85507           embl_tpa_prot",
    "special  CBF85509           embl_tpa_prot",
    "special  CBF85511-CBF85512  embl_tpa_prot",
    "special  CBF85514           embl_tpa_prot",
    "special  CBF85516           embl_tpa_prot",
    "special  CBF85518           embl_tpa_prot",
    "special  CBF85520-CBF85521  embl_tpa_prot",
    "special  CBF85523           embl_tpa_prot",
    "special  CBF85525           embl_tpa_prot",
    "special  CBF85527           embl_tpa_prot",
    "special  CBF85529-CBF85530  embl_tpa_prot",
    "special  CBF85532           embl_tpa_prot",
    "special  CBF85534           embl_tpa_prot",
    "special  CBF85536           embl_tpa_prot",
    "special  CBF85538-CBF85539  embl_tpa_prot",
    "special  CBF85541           embl_tpa_prot",
    "special  CBF85543           embl_tpa_prot",
    "special  CBF85545-CBF85546  embl_tpa_prot",
    "special  CBF85548           embl_tpa_prot",
    "special  CBF85550-CBF85551  embl_tpa_prot",
    "special  CBF85553           embl_tpa_prot",
    "special  CBF85555           embl_tpa_prot",
    "special  CBF85557           embl_tpa_prot",
    "special  CBF85559-CBF85560  embl_tpa_prot",
    "special  CBF85562           embl_tpa_prot",
    "special  CBF85564           embl_tpa_prot",
    "special  CBF85566           embl_tpa_prot",
    "special  CBF85568-CBF85569  embl_tpa_prot",
    "special  CBF85571           embl_tpa_prot",
    "special  CBF85573           embl_tpa_prot",
    "special  CBF85575           embl_tpa_prot",
    "special  CBF85577           embl_tpa_prot",
    "special  CBF85579-CBF85580  embl_tpa_prot",
    "special  CBF85582           embl_tpa_prot",
    "special  CBF85584           embl_tpa_prot",
    "special  CBF85586           embl_tpa_prot",
    "special  CBF85588-CBF85589  embl_tpa_prot",
    "special  CBF85591           embl_tpa_prot",
    "special  CBF85593           embl_tpa_prot",
    "special  CBF85595-CBF85596  embl_tpa_prot",
    "special  CBF85598           embl_tpa_prot",
    "special  CBF85600           embl_tpa_prot",
    "special  CBF85602           embl_tpa_prot",
    "special  CBF85604           embl_tpa_prot",
    "special  CBF85606-CBF85607  embl_tpa_prot",
    "special  CBF85609           embl_tpa_prot",
    "special  CBF85611           embl_tpa_prot",
    "special  CBF85613           embl_tpa_prot",
    "special  CBF85615-CBF85616  embl_tpa_prot",
    "special  CBF85618           embl_tpa_prot",
    "special  CBF85620           embl_tpa_prot",
    "special  CBF85622           embl_tpa_prot",
    "special  CBF85624           embl_tpa_prot",
    "special  CBF85626           embl_tpa_prot",
    "special  CBF85628-CBF85629  embl_tpa_prot",
    "special  CBF85631           embl_tpa_prot",
    "special  CBF85633           embl_tpa_prot",
    "special  CBF85635           embl_tpa_prot",
    "special  CBF85637           embl_tpa_prot",
    "special  CBF85639-CBF85640  embl_tpa_prot",
    "special  CBF85642           embl_tpa_prot",
    "special  CBF85644           embl_tpa_prot",
    "special  CBF85646           embl_tpa_prot",
    "special  CBF85648           embl_tpa_prot",
    "special  CBF85650           embl_tpa_prot",
    "special  CBF85652-CBF85653  embl_tpa_prot",
    "special  CBF85655           embl_tpa_prot",
    "special  CBF85657           embl_tpa_prot",
    "special  CBF85659           embl_tpa_prot",
    "special  CBF85661-CBF85662  embl_tpa_prot",
    "special  CBF85664           embl_tpa_prot",
    "special  CBF85666           embl_tpa_prot",
    "special  CBF85668           embl_tpa_prot",
    "special  CBF85670           embl_tpa_prot",
    "special  CBF85672-CBF85673  embl_tpa_prot",
    "special  CBF85675           embl_tpa_prot",
    "special  CBF85677           embl_tpa_prot",
    "special  CBF85679           embl_tpa_prot",
    "special  CBF85681           embl_tpa_prot",
    "special  CBF85683           embl_tpa_prot",
    "special  CBF85685-CBF85686  embl_tpa_prot",
    "special  CBF85688           embl_tpa_prot",
    "special  CBF85690           embl_tpa_prot",
    "special  CBF85692           embl_tpa_prot",
    "special  CBF85694-CBF85695  embl_tpa_prot",
    "special  CBF85697           embl_tpa_prot",
    "special  CBF85699           embl_tpa_prot",
    "special  CBF85701           embl_tpa_prot",
    "special  CBF85703           embl_tpa_prot",
    "special  CBF85705-CBF85706  embl_tpa_prot",
    "special  CBF85708           embl_tpa_prot",
    "special  CBF85710           embl_tpa_prot",
    "special  CBF85712           embl_tpa_prot",
    "special  CBF85714-CBF85715  embl_tpa_prot",
    "special  CBF85717           embl_tpa_prot",
    "special  CBF85719           embl_tpa_prot",
    "special  CBF85721           embl_tpa_prot",
    "special  CBF85723           embl_tpa_prot",
    "special  CBF85725           embl_tpa_prot",
    "special  CBF85727           embl_tpa_prot",
    "special  CBF85729-CBF85730  embl_tpa_prot",
    "special  CBF85732-CBF85733  embl_tpa_prot",
    "special  CBF85735           embl_tpa_prot",
    "special  CBF85737           embl_tpa_prot",
    "special  CBF85739           embl_tpa_prot",
    "special  CBF85741-CBF85742  embl_tpa_prot",
    "special  CBF85744           embl_tpa_prot",
    "special  CBF85746           embl_tpa_prot",
    "special  CBF85748-CBF85749  embl_tpa_prot",
    "special  CBF85751           embl_tpa_prot",
    "special  CBF85753           embl_tpa_prot",
    "special  CBF85755           embl_tpa_prot",
    "special  CBF85757           embl_tpa_prot",
    "special  CBF85759           embl_tpa_prot",
    "special  CBF85761           embl_tpa_prot",
    "special  CBF85763           embl_tpa_prot",
    "special  CBF85765           embl_tpa_prot",
    "special  CBF85767           embl_tpa_prot",
    "special  CBF85769-CBF85770  embl_tpa_prot",
    "special  CBF85772           embl_tpa_prot",
    "special  CBF85774           embl_tpa_prot",
    "special  CBF85776-CBF85777  embl_tpa_prot",
    "special  CBF85779           embl_tpa_prot",
    "special  CBF85781           embl_tpa_prot",
    "special  CBF85783-CBF85784  embl_tpa_prot",
    "special  CBF85786           embl_tpa_prot",
    "special  CBF85788           embl_tpa_prot",
    "special  CBF85790           embl_tpa_prot",
    "special  CBF85792           embl_tpa_prot",
    "special  CBF85794-CBF85795  embl_tpa_prot",
    "special  CBF85797           embl_tpa_prot",
    "special  CBF85799           embl_tpa_prot",
    "special  CBF85801           embl_tpa_prot",
    "special  CBF85803           embl_tpa_prot",
    "special  CBF85805-CBF85806  embl_tpa_prot",
    "special  CBF85808           embl_tpa_prot",
    "special  CBF85810           embl_tpa_prot",
    "special  CBF85812           embl_tpa_prot",
    "special  CBF85814-CBF85815  embl_tpa_prot",
    "special  CBF85817           embl_tpa_prot",
    "special  CBF85819           embl_tpa_prot",
    "special  CBF85821           embl_tpa_prot",
    "special  CBF85823-CBF85824  embl_tpa_prot",
    "special  CBF85826           embl_tpa_prot",
    "special  CBF85828           embl_tpa_prot",
    "special  CBF85830           embl_tpa_prot",
    "special  CBF85832           embl_tpa_prot",
    "special  CBF85834-CBF85835  embl_tpa_prot",
    "special  CBF85837           embl_tpa_prot",
    "special  CBF85839-CBF85840  embl_tpa_prot",
    "special  CBF85842           embl_tpa_prot",
    "special  CBF85844           embl_tpa_prot",
    "special  CBF85846           embl_tpa_prot",
    "special  CBF85848           embl_tpa_prot",
    "special  CBF85850-CBF85851  embl_tpa_prot",
    "special  CBF85853           embl_tpa_prot",
    "special  CBF85855           embl_tpa_prot",
    "special  CBF85857-CBF85858  embl_tpa_prot",
    "special  CBF85860-CBF85861  embl_tpa_prot",
    "special  CBF85863           embl_tpa_prot",
    "special  CBF85865           embl_tpa_prot",
    "special  CBF85867-CBF85868  embl_tpa_prot",
    "special  CBF85870           embl_tpa_prot",
    "special  CBF85872           embl_tpa_prot",
    "special  CBF85874           embl_tpa_prot",
    "special  CBF85876-CBF85877  embl_tpa_prot",
    "special  CBF85879           embl_tpa_prot",
    "special  CBF85881           embl_tpa_prot",
    "special  CBF85883           embl_tpa_prot",
    "special  CBF85885-CBF85886  embl_tpa_prot",
    "special  CBF85888           embl_tpa_prot",
    "special  CBF85890           embl_tpa_prot",
    "special  CBF85892           embl_tpa_prot",
    "special  CBF85894           embl_tpa_prot",
    "special  CBF85896           embl_tpa_prot",
    "special  CBF85898-CBF85899  embl_tpa_prot",
    "special  CBF85901           embl_tpa_prot",
    "special  CBF85903           embl_tpa_prot",
    "special  CBF85905           embl_tpa_prot",
    "special  CBF85907-CBF85908  embl_tpa_prot",
    "special  CBF85910           embl_tpa_prot",
    "special  CBF85912           embl_tpa_prot",
    "special  CBF85914           embl_tpa_prot",
    "special  CBF85916           embl_tpa_prot",
    "special  CBF85918           embl_tpa_prot",
    "special  CBF85920-CBF85921  embl_tpa_prot",
    "special  CBF85923           embl_tpa_prot",
    "special  CBF85925           embl_tpa_prot",
    "special  CBF85927           embl_tpa_prot",
    "special  CBF85929           embl_tpa_prot",
    "special  CBF85931           embl_tpa_prot",
    "special  CBF85933           embl_tpa_prot",
    "special  CBF85935-CBF85936  embl_tpa_prot",
    "special  CBF85938           embl_tpa_prot",
    "special  CBF85940-CBF85941  embl_tpa_prot",
    "special  CBF85943           embl_tpa_prot",
    "special  CBF85945           embl_tpa_prot",
    "special  CBF85947           embl_tpa_prot",
    "special  CBF85949           embl_tpa_prot",
    "special  CBF85951           embl_tpa_prot",
    "special  CBF85953-CBF85954  embl_tpa_prot",
    "special  CBF85956           embl_tpa_prot",
    "special  CBF85958           embl_tpa_prot",
    "special  CBF85960           embl_tpa_prot",
    "special  CBF85962           embl_tpa_prot",
    "special  CBF85964           embl_tpa_prot",
    "special  CBF85966           embl_tpa_prot",
    "special  CBF85968           embl_tpa_prot",
    "special  CBF85970-CBF85971  embl_tpa_prot",
    "special  CBF85973           embl_tpa_prot",
    "special  CBF85975           embl_tpa_prot",
    "special  CBF85977           embl_tpa_prot",
    "special  CBF85979           embl_tpa_prot",
    "special  CBF85981           embl_tpa_prot",
    "special  CBF85983           embl_tpa_prot",
    "special  CBF85985-CBF85986  embl_tpa_prot",
    "special  CBF85988           embl_tpa_prot",
    "special  CBF85990           embl_tpa_prot",
    "special  CBF85992           embl_tpa_prot",
    "special  CBF85994-CBF85995  embl_tpa_prot",
    "special  CBF85997           embl_tpa_prot",
    "special  CBF85999           embl_tpa_prot",
    "special  CBF86001           embl_tpa_prot",
    "special  CBF86003-CBF86004  embl_tpa_prot",
    "special  CBF86006           embl_tpa_prot",
    "special  CBF86008           embl_tpa_prot",
    "special  CBF86010           embl_tpa_prot",
    "special  CBF86012-CBF86013  embl_tpa_prot",
    "special  CBF86015           embl_tpa_prot",
    "special  CBF86017           embl_tpa_prot",
    "special  CBF86019           embl_tpa_prot",
    "special  CBF86021           embl_tpa_prot",
    "special  CBF86023           embl_tpa_prot",
    "special  CBF86025-CBF86026  embl_tpa_prot",
    "special  CBF86028           embl_tpa_prot",
    "special  CBF86030           embl_tpa_prot",
    "special  CBF86032           embl_tpa_prot",
    "special  CBF86034-CBF86035  embl_tpa_prot",
    "special  CBF86037           embl_tpa_prot",
    "special  CBF86039           embl_tpa_prot",
    "special  CBF86041           embl_tpa_prot",
    "special  CBF86043           embl_tpa_prot",
    "special  CBF86045-CBF86046  embl_tpa_prot",
    "special  CBF86048           embl_tpa_prot",
    "special  CBF86050           embl_tpa_prot",
    "special  CBF86052           embl_tpa_prot",
    "special  CBF86054           embl_tpa_prot",
    "special  CBF86056-CBF86057  embl_tpa_prot",
    "special  CBF86059           embl_tpa_prot",
    "special  CBF86061           embl_tpa_prot",
    "special  CBF86063           embl_tpa_prot",
    "special  CBF86065-CBF86066  embl_tpa_prot",
    "special  CBF86068           embl_tpa_prot",
    "special  CBF86070-CBF86071  embl_tpa_prot",
    "special  CBF86073           embl_tpa_prot",
    "special  CBF86075           embl_tpa_prot",
    "special  CBF86077           embl_tpa_prot",
    "special  CBF86079-CBF86080  embl_tpa_prot",
    "special  CBF86082           embl_tpa_prot",
    "special  CBF86084           embl_tpa_prot",
    "special  CBF86086-CBF86087  embl_tpa_prot",
    "special  CBF86089           embl_tpa_prot",
    "special  CBF86091           embl_tpa_prot",
    "special  CBF86093           embl_tpa_prot",
    "special  CBF86095           embl_tpa_prot",
    "special  CBF86097-CBF86098  embl_tpa_prot",
    "special  CBF86100           embl_tpa_prot",
    "special  CBF86102           embl_tpa_prot",
    "special  CBF86104           embl_tpa_prot",
    "special  CBF86106           embl_tpa_prot",
    "special  CBF86108-CBF86109  embl_tpa_prot",
    "special  CBF86111           embl_tpa_prot",
    "special  CBF86113           embl_tpa_prot",
    "special  CBF86115           embl_tpa_prot",
    "special  CBF86117           embl_tpa_prot",
    "special  CBF86119-CBF86120  embl_tpa_prot",
    "special  CBF86122           embl_tpa_prot",
    "special  CBF86124           embl_tpa_prot",
    "special  CBF86126           embl_tpa_prot",
    "special  CBF86128           embl_tpa_prot",
    "special  CBF86130           embl_tpa_prot",
    "special  CBF86132-CBF86133  embl_tpa_prot",
    "special  CBF86135           embl_tpa_prot",
    "special  CBF86137           embl_tpa_prot",
    "special  CBF86139-CBF86140  embl_tpa_prot",
    "special  CBF86142           embl_tpa_prot",
    "special  CBF86144           embl_tpa_prot",
    "special  CBF86146           embl_tpa_prot",
    "special  CBF86148           embl_tpa_prot",
    "special  CBF86150-CBF86151  embl_tpa_prot",
    "special  CBF86153           embl_tpa_prot",
    "special  CBF86155           embl_tpa_prot",
    "special  CBF86157           embl_tpa_prot",
    "special  CBF86159           embl_tpa_prot",
    "special  CBF86161-CBF86162  embl_tpa_prot",
    "special  CBF86164           embl_tpa_prot",
    "special  CBF86166           embl_tpa_prot",
    "special  CBF86168           embl_tpa_prot",
    "special  CBF86170           embl_tpa_prot",
    "special  CBF86172-CBF86173  embl_tpa_prot",
    "special  CBF86175-CBF86176  embl_tpa_prot",
    "special  CBF86178           embl_tpa_prot",
    "special  CBF86180           embl_tpa_prot",
    "special  CBF86182           embl_tpa_prot",
    "special  CBF86184-CBF86185  embl_tpa_prot",
    "special  CBF86187           embl_tpa_prot",
    "special  CBF86189           embl_tpa_prot",
    "special  CBF86191-CBF86192  embl_tpa_prot",
    "special  CBF86194           embl_tpa_prot",
    "special  CBF86196           embl_tpa_prot",
    "special  CBF86198           embl_tpa_prot",
    "special  CBF86200-CBF86201  embl_tpa_prot",
    "special  CBF86203           embl_tpa_prot",
    "special  CBF86205-CBF86206  embl_tpa_prot",
    "special  CBF86208           embl_tpa_prot",
    "special  CBF86210           embl_tpa_prot",
    "special  CBF86212-CBF86213  embl_tpa_prot",
    "special  CBF86215-CBF86216  embl_tpa_prot",
    "special  CBF86218           embl_tpa_prot",
    "special  CBF86220-CBF86221  embl_tpa_prot",
    "special  CBF86223-CBF86225  embl_tpa_prot",
    "special  CBF86227           embl_tpa_prot",
    "special  CBF86229-CBF86230  embl_tpa_prot",
    "special  CBF86232           embl_tpa_prot",
    "special  CBF86234           embl_tpa_prot",
    "special  CBF86236-CBF86237  embl_tpa_prot",
    "special  CBF86239           embl_tpa_prot",
    "special  CBF86241           embl_tpa_prot",
    "special  CBF86243-CBF86244  embl_tpa_prot",
    "special  CBF86246           embl_tpa_prot",
    "special  CBF86248           embl_tpa_prot",
    "special  CBF86250           embl_tpa_prot",
    "special  CBF86252-CBF86253  embl_tpa_prot",
    "special  CBF86255           embl_tpa_prot",
    "special  CBF86257           embl_tpa_prot",
    "special  CBF86259-CBF86260  embl_tpa_prot",
    "special  CBF86262-CBF86263  embl_tpa_prot",
    "special  CBF86265-CBF86266  embl_tpa_prot",
    "special  CBF86268           embl_tpa_prot",
    "special  CBF86270-CBF86271  embl_tpa_prot",
    "special  CBF86273           embl_tpa_prot",
    "special  CBF86275-CBF86276  embl_tpa_prot",
    "special  CBF86278-CBF86279  embl_tpa_prot",
    "special  CBF86282           embl_tpa_prot",
    "special  CBF86284-CBF86285  embl_tpa_prot",
    "special  CBF86287           embl_tpa_prot",
    "special  CBF86289           embl_tpa_prot",
    "special  CBF86291-CBF86292  embl_tpa_prot",
    "special  CBF86294           embl_tpa_prot",
    "special  CBF86296-CBF86297  embl_tpa_prot",
    "special  CBF86299           embl_tpa_prot",
    "special  CBF86301           embl_tpa_prot",
    "special  CBF86303           embl_tpa_prot",
    "special  CBF86305-CBF86306  embl_tpa_prot",
    "special  CBF86308           embl_tpa_prot",
    "special  CBF86310-CBF86311  embl_tpa_prot",
    "special  CBF86313-CBF86314  embl_tpa_prot",
    "special  CBF86316-CBF86317  embl_tpa_prot",
    "special  CBF86319           embl_tpa_prot",
    "special  CBF86321-CBF86322  embl_tpa_prot",
    "special  CBF86324-CBF86325  embl_tpa_prot",
    "special  CBF86327           embl_tpa_prot",
    "special  CBF86329           embl_tpa_prot",
    "special  CBF86331-CBF86332  embl_tpa_prot",
    "special  CBF86334           embl_tpa_prot",
    "special  CBF86336           embl_tpa_prot",
    "special  CBF86338-CBF86339  embl_tpa_prot",
    "special  CBF86341           embl_tpa_prot",
    "special  CBF86343           embl_tpa_prot",
    "special  CBF86345-CBF86346  embl_tpa_prot",
    "special  CBF86348-CBF86349  embl_tpa_prot",
    "special  CBF86351           embl_tpa_prot",
    "special  CBF86353           embl_tpa_prot",
    "special  CBF86355-CBF86357  embl_tpa_prot",
    "special  CBF86359           embl_tpa_prot",
    "special  CBF86361           embl_tpa_prot",
    "special  CBF86363-CBF86364  embl_tpa_prot",
    "special  CBF86366           embl_tpa_prot",
    "special  CBF86370           embl_tpa_prot",
    "special  CBF86372           embl_tpa_prot",
    "special  CBF86374-CBF86375  embl_tpa_prot",
    "special  CBF86377           embl_tpa_prot",
    "special  CBF86379           embl_tpa_prot",
    "special  CBF86381           embl_tpa_prot",
    "special  CBF86383-CBF86384  embl_tpa_prot",
    "special  CBF86386           embl_tpa_prot",
    "special  CBF86388           embl_tpa_prot",
    "special  CBF86390-CBF86391  embl_tpa_prot",
    "special  CBF86393           embl_tpa_prot",
    "special  CBF86395           embl_tpa_prot",
    "special  CBF86397-CBF86398  embl_tpa_prot",
    "special  CBF86400           embl_tpa_prot",
    "special  CBF86402           embl_tpa_prot",
    "special  CBF86404           embl_tpa_prot",
    "special  CBF86406-CBF86407  embl_tpa_prot",
    "special  CBF86409           embl_tpa_prot",
    "special  CBF86411           embl_tpa_prot",
    "special  CBF86413           embl_tpa_prot",
    "special  CBF86415-CBF86416  embl_tpa_prot",
    "special  CBF86418           embl_tpa_prot",
    "special  CBF86420           embl_tpa_prot",
    "special  CBF86422           embl_tpa_prot",
    "special  CBF86424-CBF86426  embl_tpa_prot",
    "special  CBF86428           embl_tpa_prot",
    "special  CBF86430           embl_tpa_prot",
    "special  CBF86432           embl_tpa_prot",
    "special  CBF86434-CBF86435  embl_tpa_prot",
    "special  CBF86437-CBF86440  embl_tpa_prot",
    "special  CBF86442-CBF86444  embl_tpa_prot",
    "special  CBF86446-CBF86447  embl_tpa_prot",
    "special  CBF86449           embl_tpa_prot",
    "special  CBF86451-CBF86452  embl_tpa_prot",
    "special  CBF86454-CBF86455  embl_tpa_prot",
    "special  CBF86457-CBF86458  embl_tpa_prot",
    "special  CBF86460           embl_tpa_prot",
    "special  CBF86462           embl_tpa_prot",
    "special  CBF86464-CBF86465  embl_tpa_prot",
    "special  CBF86467           embl_tpa_prot",
    "special  CBF86469           embl_tpa_prot",
    "special  CBF86471-CBF86472  embl_tpa_prot",
    "special  CBF86474           embl_tpa_prot",
    "special  CBF86476           embl_tpa_prot",
    "special  CBF86478           embl_tpa_prot",
    "special  CBF86480           embl_tpa_prot",
    "special  CBF86482           embl_tpa_prot",
    "special  CBF86484           embl_tpa_prot",
    "special  CBF86486-CBF86487  embl_tpa_prot",
    "special  CBF86489           embl_tpa_prot",
    "special  CBF86491           embl_tpa_prot",
    "special  CBF86493-CBF86494  embl_tpa_prot",
    "special  CBF86496           embl_tpa_prot",
    "special  CBF86498           embl_tpa_prot",
    "special  CBF86500-CBF86501  embl_tpa_prot",
    "special  CBF86503           embl_tpa_prot",
    "special  CBF86505           embl_tpa_prot",
    "special  CBF86507           embl_tpa_prot",
    "special  CBF86509           embl_tpa_prot",
    "special  CBF86511           embl_tpa_prot",
    "special  CBF86513           embl_tpa_prot",
    "special  CBF86515-CBF86516  embl_tpa_prot",
    "special  CBF86518           embl_tpa_prot",
    "special  CBF86520           embl_tpa_prot",
    "special  CBF86522-CBF86523  embl_tpa_prot",
    "special  CBF86525           embl_tpa_prot",
    "special  CBF86527           embl_tpa_prot",
    "special  CBF86529           embl_tpa_prot",
    "special  CBF86531           embl_tpa_prot",
    "special  CBF86533           embl_tpa_prot",
    "special  CBF86535           embl_tpa_prot",
    "special  CBF86537           embl_tpa_prot",
    "special  CBF86539-CBF86540  embl_tpa_prot",
    "special  CBF86542           embl_tpa_prot",
    "special  CBF86544           embl_tpa_prot",
    "special  CBF86546           embl_tpa_prot",
    "special  CBF86548-CBF86549  embl_tpa_prot",
    "special  CBF86551           embl_tpa_prot",
    "special  CBF86553           embl_tpa_prot",
    "special  CBF86555           embl_tpa_prot",
    "special  CBF86557           embl_tpa_prot",
    "special  CBF86559-CBF86560  embl_tpa_prot",
    "special  CBF86562           embl_tpa_prot",
    "special  CBF86564           embl_tpa_prot",
    "special  CBF86566           embl_tpa_prot",
    "special  CBF86568           embl_tpa_prot",
    "special  CBF86570-CBF86571  embl_tpa_prot",
    "special  CBF86573           embl_tpa_prot",
    "special  CBF86575           embl_tpa_prot",
    "special  CBF86577           embl_tpa_prot",
    "special  CBF86579           embl_tpa_prot",
    "special  CBF86581           embl_tpa_prot",
    "special  CBF86583-CBF86584  embl_tpa_prot",
    "special  CBF86586           embl_tpa_prot",
    "special  CBF86588           embl_tpa_prot",
    "special  CBF86590           embl_tpa_prot",
    "special  CBF86592-CBF86593  embl_tpa_prot",
    "special  CBF86595           embl_tpa_prot",
    "special  CBF86597           embl_tpa_prot",
    "special  CBF86599           embl_tpa_prot",
    "special  CBF86601           embl_tpa_prot",
    "special  CBF86603-CBF86604  embl_tpa_prot",
    "special  CBF86606           embl_tpa_prot",
    "special  CBF86608           embl_tpa_prot",
    "special  CBF86610           embl_tpa_prot",
    "special  CBF86612           embl_tpa_prot",
    "special  CBF86614-CBF86615  embl_tpa_prot",
    "special  CBF86617           embl_tpa_prot",
    "special  CBF86619-CBF86620  embl_tpa_prot",
    "special  CBF86622           embl_tpa_prot",
    "special  CBF86624           embl_tpa_prot",
    "special  CBF86626           embl_tpa_prot",
    "special  CBF86628           embl_tpa_prot",
    "special  CBF86630           embl_tpa_prot",
    "special  CBF86632           embl_tpa_prot",
    "special  CBF86634-CBF86635  embl_tpa_prot",
    "special  CBF86637           embl_tpa_prot",
    "special  CBF86639           embl_tpa_prot",
    "special  CBF86641           embl_tpa_prot",
    "special  CBF86643           embl_tpa_prot",
    "special  CBF86645-CBF86646  embl_tpa_prot",
    "special  CBF86648           embl_tpa_prot",
    "special  CBF86650           embl_tpa_prot",
    "special  CBF86652           embl_tpa_prot",
    "special  CBF86654           embl_tpa_prot",
    "special  CBF86656           embl_tpa_prot",
    "special  CBF86658           embl_tpa_prot",
    "special  CBF86660-CBF86661  embl_tpa_prot",
    "special  CBF86663           embl_tpa_prot",
    "special  CBF86665           embl_tpa_prot",
    "special  CBF86667           embl_tpa_prot",
    "special  CBF86669           embl_tpa_prot",
    "special  CBF86671           embl_tpa_prot",
    "special  CBF86673-CBF86674  embl_tpa_prot",
    "special  CBF86676           embl_tpa_prot",
    "special  CBF86678           embl_tpa_prot",
    "special  CBF86680           embl_tpa_prot",
    "special  CBF86682           embl_tpa_prot",
    "special  CBF86684           embl_tpa_prot",
    "special  CBF86686-CBF86687  embl_tpa_prot",
    "special  CBF86689           embl_tpa_prot",
    "special  CBF86691           embl_tpa_prot",
    "special  CBF86693           embl_tpa_prot",
    "special  CBF86695-CBF86696  embl_tpa_prot",
    "special  CBF86698           embl_tpa_prot",
    "special  CBF86700           embl_tpa_prot",
    "special  CBF86702           embl_tpa_prot",
    "special  CBF86704           embl_tpa_prot",
    "special  CBF86706-CBF86707  embl_tpa_prot",
    "special  CBF86709           embl_tpa_prot",
    "special  CBF86711           embl_tpa_prot",
    "special  CBF86713           embl_tpa_prot",
    "special  CBF86715-CBF86716  embl_tpa_prot",
    "special  CBF86718           embl_tpa_prot",
    "special  CBF86720           embl_tpa_prot",
    "special  CBF86722           embl_tpa_prot",
    "special  CBF86724           embl_tpa_prot",
    "special  CBF86727-CBF86728  embl_tpa_prot",
    "special  CBF86730           embl_tpa_prot",
    "special  CBF86732           embl_tpa_prot",
    "special  CBF86734           embl_tpa_prot",
    "special  CBF86736           embl_tpa_prot",
    "special  CBF86738-CBF86739  embl_tpa_prot",
    "special  CBF86741           embl_tpa_prot",
    "special  CBF86743           embl_tpa_prot",
    "special  CBF86745           embl_tpa_prot",
    "special  CBF86747           embl_tpa_prot",
    "special  CBF86749           embl_tpa_prot",
    "special  CBF86751           embl_tpa_prot",
    "special  CBF86753           embl_tpa_prot",
    "special  CBF86755-CBF86756  embl_tpa_prot",
    "special  CBF86758           embl_tpa_prot",
    "special  CBF86760           embl_tpa_prot",
    "special  CBF86762           embl_tpa_prot",
    "special  CBF86764           embl_tpa_prot",
    "special  CBF86766           embl_tpa_prot",
    "special  CBF86768           embl_tpa_prot",
    "special  CBF86770-CBF86771  embl_tpa_prot",
    "special  CBF86773           embl_tpa_prot",
    "special  CBF86775           embl_tpa_prot",
    "special  CBF86777           embl_tpa_prot",
    "special  CBF86779           embl_tpa_prot",
    "special  CBF86781           embl_tpa_prot",
    "special  CBF86783           embl_tpa_prot",
    "special  CBF86785           embl_tpa_prot",
    "special  CBF86787           embl_tpa_prot",
    "special  CBF86789           embl_tpa_prot",
    "special  CBF86791-CBF86792  embl_tpa_prot",
    "special  CBF86794           embl_tpa_prot",
    "special  CBF86796           embl_tpa_prot",
    "special  CBF86798           embl_tpa_prot",
    "special  CBF86800           embl_tpa_prot",
    "special  CBF86802           embl_tpa_prot",
    "special  CBF86804-CBF86805  embl_tpa_prot",
    "special  CBF86807           embl_tpa_prot",
    "special  CBF86809           embl_tpa_prot",
    "special  CBF86811           embl_tpa_prot",
    "special  CBF86813           embl_tpa_prot",
    "special  CBF86815-CBF86816  embl_tpa_prot",
    "special  CBF86818           embl_tpa_prot",
    "special  CBF86820           embl_tpa_prot",
    "special  CBF86822           embl_tpa_prot",
    "special  CBF86824           embl_tpa_prot",
    "special  CBF86826-CBF86827  embl_tpa_prot",
    "special  CBF86829           embl_tpa_prot",
    "special  CBF86831           embl_tpa_prot",
    "special  CBF86833           embl_tpa_prot",
    "special  CBF86835           embl_tpa_prot",
    "special  CBF86837           embl_tpa_prot",
    "special  CBF86839           embl_tpa_prot",
    "special  CBF86841           embl_tpa_prot",
    "special  CBF86843           embl_tpa_prot",
    "special  CBF86845           embl_tpa_prot",
    "special  CBF86847-CBF86848  embl_tpa_prot",
    "special  CBF86850           embl_tpa_prot",
    "special  CBF86852           embl_tpa_prot",
    "special  CBF86854           embl_tpa_prot",
    "special  CBF86856           embl_tpa_prot",
    "special  CBF86858           embl_tpa_prot",
    "special  CBF86860-CBF86861  embl_tpa_prot",
    "special  CBF86863           embl_tpa_prot",
    "special  CBF86865           embl_tpa_prot",
    "special  CBF86867           embl_tpa_prot",
    "special  CBF86869           embl_tpa_prot",
    "special  CBF86871           embl_tpa_prot",
    "special  CBF86873-CBF86874  embl_tpa_prot",
    "special  CBF86876           embl_tpa_prot",
    "special  CBF86878           embl_tpa_prot",
    "special  CBF86880           embl_tpa_prot",
    "special  CBF86882-CBF86883  embl_tpa_prot",
    "special  CBF86885           embl_tpa_prot",
    "special  CBF86887-CBF86888  embl_tpa_prot",
    "special  CBF86890           embl_tpa_prot",
    "special  CBF86892           embl_tpa_prot",
    "special  CBF86894-CBF86895  embl_tpa_prot",
    "special  CBF86897           embl_tpa_prot",
    "special  CBF86899           embl_tpa_prot",
    "special  CBF86901           embl_tpa_prot",
    "special  CBF86903-CBF86904  embl_tpa_prot",
    "special  CBF86906-CBF86907  embl_tpa_prot",
    "special  CBF86909           embl_tpa_prot",
    "special  CBF86911-CBF86912  embl_tpa_prot",
    "special  CBF86914           embl_tpa_prot",
    "special  CBF86916-CBF86917  embl_tpa_prot",
    "special  CBF86919           embl_tpa_prot",
    "special  CBF86921-CBF86922  embl_tpa_prot",
    "special  CBF86924-CBF86925  embl_tpa_prot",
    "special  CBF86927-CBF86928  embl_tpa_prot",
    "special  CBF86930           embl_tpa_prot",
    "special  CBF86932-CBF86933  embl_tpa_prot",
    "special  CBF86935-CBF86936  embl_tpa_prot",
    "special  CBF86938           embl_tpa_prot",
    "special  CBF86940-CBF86941  embl_tpa_prot",
    "special  CBF86943-CBF86944  embl_tpa_prot",
    "special  CBF86946           embl_tpa_prot",
    "special  CBF86948-CBF86949  embl_tpa_prot",
    "special  CBF86951           embl_tpa_prot",
    "special  CBF86953           embl_tpa_prot",
    "special  CBF86955           embl_tpa_prot",
    "special  CBF86957-CBF86958  embl_tpa_prot",
    "special  CBF86960-CBF86961  embl_tpa_prot",
    "special  CBF86963-CBF86965  embl_tpa_prot",
    "special  CBF86967-CBF86968  embl_tpa_prot",
    "special  CBF86970           embl_tpa_prot",
    "special  CBF86972           embl_tpa_prot",
    "special  CBF86974           embl_tpa_prot",
    "special  CBF86976-CBF86977  embl_tpa_prot",
    "special  CBF86979           embl_tpa_prot",
    "special  CBF86981-CBF86982  embl_tpa_prot",
    "special  CBF86984           embl_tpa_prot",
    "special  CBF86986           embl_tpa_prot",
    "special  CBF86988-CBF86989  embl_tpa_prot",
    "special  CBF86991           embl_tpa_prot",
    "special  CBF86993           embl_tpa_prot",
    "special  CBF86995           embl_tpa_prot",
    "special  CBF86997-CBF86998  embl_tpa_prot",
    "special  CBF87000           embl_tpa_prot",
    "special  CBF87002-CBF87003  embl_tpa_prot",
    "special  CBF87005           embl_tpa_prot",
    "special  CBF87007-CBF87008  embl_tpa_prot",
    "special  CBF87010           embl_tpa_prot",
    "special  CBF87012           embl_tpa_prot",
    "special  CBF87014           embl_tpa_prot",
    "special  CBF87016-CBF87018  embl_tpa_prot",
    "special  CBF87020-CBF87021  embl_tpa_prot",
    "special  CBF87023           embl_tpa_prot",
    "special  CBF87025           embl_tpa_prot",
    "special  CBF87027-CBF87028  embl_tpa_prot",
    "special  CBF87030           embl_tpa_prot",
    "special  CBF87032           embl_tpa_prot",
    "special  CBF87034           embl_tpa_prot",
    "special  CBF87036-CBF87037  embl_tpa_prot",
    "special  CBF87039           embl_tpa_prot",
    "special  CBF87041           embl_tpa_prot",
    "special  CBF87043           embl_tpa_prot",
    "special  CBF87045-CBF87046  embl_tpa_prot",
    "special  CBF87048           embl_tpa_prot",
    "special  CBF87050           embl_tpa_prot",
    "special  CBF87052           embl_tpa_prot",
    "special  CBF87054           embl_tpa_prot",
    "special  CBF87056           embl_tpa_prot",
    "special  CBF87058-CBF87059  embl_tpa_prot",
    "special  CBF87061           embl_tpa_prot",
    "special  CBF87063           embl_tpa_prot",
    "special  CBF87065           embl_tpa_prot",
    "special  CBF87067           embl_tpa_prot",
    "special  CBF87069           embl_tpa_prot",
    "special  CBF87071-CBF87072  embl_tpa_prot",
    "special  CBF87074           embl_tpa_prot",
    "special  CBF87076           embl_tpa_prot",
    "special  CBF87078           embl_tpa_prot",
    "special  CBF87080           embl_tpa_prot",
    "special  CBF87082           embl_tpa_prot",
    "special  CBF87084           embl_tpa_prot",
    "special  CBF87086-CBF87087  embl_tpa_prot",
    "special  CBF87089           embl_tpa_prot",
    "special  CBF87091-CBF87092  embl_tpa_prot",
    "special  CBF87094           embl_tpa_prot",
    "special  CBF87096-CBF87097  embl_tpa_prot",
    "special  CBF87099-CBF87100  embl_tpa_prot",
    "special  CBF87102           embl_tpa_prot",
    "special  CBF87104-CBF87105  embl_tpa_prot",
    "special  CBF87107           embl_tpa_prot",
    "special  CBF87109           embl_tpa_prot",
    "special  CBF87111           embl_tpa_prot",
    "special  CBF87113-CBF87114  embl_tpa_prot",
    "special  CBF87116           embl_tpa_prot",
    "special  CBF87118           embl_tpa_prot",
    "special  CBF87120           embl_tpa_prot",
    "special  CBF87122-CBF87123  embl_tpa_prot",
    "special  CBF87125           embl_tpa_prot",
    "special  CBF87127           embl_tpa_prot",
    "special  CBF87129-CBF87130  embl_tpa_prot",
    "special  CBF87132-CBF87133  embl_tpa_prot",
    "special  CBF87135           embl_tpa_prot",
    "special  CBF87137           embl_tpa_prot",
    "special  CBF87139-CBF87140  embl_tpa_prot",
    "special  CBF87142           embl_tpa_prot",
    "special  CBF87144-CBF87145  embl_tpa_prot",
    "special  CBF87147           embl_tpa_prot",
    "special  CBF87149           embl_tpa_prot",
    "special  CBF87151           embl_tpa_prot",
    "special  CBF87153           embl_tpa_prot",
    "special  CBF87155-CBF87156  embl_tpa_prot",
    "special  CBF87158-CBF87159  embl_tpa_prot",
    "special  CBF87161           embl_tpa_prot",
    "special  CBF87163           embl_tpa_prot",
    "special  CBF87165           embl_tpa_prot",
    "special  CBF87167           embl_tpa_prot",
    "special  CBF87169-CBF87170  embl_tpa_prot",
    "special  CBF87172           embl_tpa_prot",
    "special  CBF87174-CBF87175  embl_tpa_prot",
    "special  CBF87177           embl_tpa_prot",
    "special  CBF87179           embl_tpa_prot",
    "special  CBF87181           embl_tpa_prot",
    "special  CBF87183           embl_tpa_prot",
    "special  CBF87185           embl_tpa_prot",
    "special  CBF87187-CBF87188  embl_tpa_prot",
    "special  CBF87190           embl_tpa_prot",
    "special  CBF87192           embl_tpa_prot",
    "special  CBF87194           embl_tpa_prot",
    "special  CBF87196-CBF87197  embl_tpa_prot",
    "special  CBF87199           embl_tpa_prot",
    "special  CBF87201           embl_tpa_prot",
    "special  CBF87203-CBF87204  embl_tpa_prot",
    "special  CBF87206           embl_tpa_prot",
    "special  CBF87221           embl_tpa_prot",
    "special  CBF87223-CBF87224  embl_tpa_prot",
    "special  CBF87226           embl_tpa_prot",
    "special  CBF87228           embl_tpa_prot",
    "special  CBF87230-CBF87231  embl_tpa_prot",
    "special  CBF87233           embl_tpa_prot",
    "special  CBF87235-CBF87236  embl_tpa_prot",
    "special  CBF87238           embl_tpa_prot",
    "special  CBF87240-CBF87241  embl_tpa_prot",
    "special  CBF87243           embl_tpa_prot",
    "special  CBF87245           embl_tpa_prot",
    "special  CBF87247           embl_tpa_prot",
    "special  CBF87249           embl_tpa_prot",
    "special  CBF87251           embl_tpa_prot",
    "special  CBF87253-CBF87254  embl_tpa_prot",
    "special  CBF87256           embl_tpa_prot",
    "special  CBF87258           embl_tpa_prot",
    "special  CBF87260           embl_tpa_prot",
    "special  CBF87262-CBF87263  embl_tpa_prot",
    "special  CBF87265           embl_tpa_prot",
    "special  CBF87267           embl_tpa_prot",
    "special  CBF87269-CBF87270  embl_tpa_prot",
    "special  CBF87272           embl_tpa_prot",
    "special  CBF87274-CBF87275  embl_tpa_prot",
    "special  CBF87277           embl_tpa_prot",
    "special  CBF87279           embl_tpa_prot",
    "special  CBF87281-CBF87282  embl_tpa_prot",
    "special  CBF87284-CBF87285  embl_tpa_prot",
    "special  CBF87287           embl_tpa_prot",
    "special  CBF87289-CBF87290  embl_tpa_prot",
    "special  CBF87292           embl_tpa_prot",
    "special  CBF87294-CBF87295  embl_tpa_prot",
    "special  CBF87297           embl_tpa_prot",
    "special  CBF87299           embl_tpa_prot",
    "special  CBF87301-CBF87302  embl_tpa_prot",
    "special  CBF87304           embl_tpa_prot",
    "special  CBF87306           embl_tpa_prot",
    "special  CBF87308-CBF87309  embl_tpa_prot",
    "special  CBF87311-CBF87312  embl_tpa_prot",
    "special  CBF87314           embl_tpa_prot",
    "special  CBF87316           embl_tpa_prot",
    "special  CBF87318-CBF87319  embl_tpa_prot",
    "special  CBF87321           embl_tpa_prot",
    "special  CBF87323           embl_tpa_prot",
    "special  CBF87325-CBF87326  embl_tpa_prot",
    "special  CBF87330           embl_tpa_prot",
    "special  CBF87332           embl_tpa_prot",
    "special  CBF87334           embl_tpa_prot",
    "special  CBF87336-CBF87337  embl_tpa_prot",
    "special  CBF87339           embl_tpa_prot",
    "special  CBF87341           embl_tpa_prot",
    "special  CBF87343           embl_tpa_prot",
    "special  CBF87345-CBF87346  embl_tpa_prot",
    "special  CBF87348           embl_tpa_prot",
    "special  CBF87350-CBF87351  embl_tpa_prot",
    "special  CBF87353           embl_tpa_prot",
    "special  CBF87355           embl_tpa_prot",
    "special  CBF87357           embl_tpa_prot",
    "special  CBF87359-CBF87360  embl_tpa_prot",
    "special  CBF87362           embl_tpa_prot",
    "special  CBF87364           embl_tpa_prot",
    "special  CBF87366           embl_tpa_prot",
    "special  CBF87368-CBF87369  embl_tpa_prot",
    "special  CBF87371           embl_tpa_prot",
    "special  CBF87373           embl_tpa_prot",
    "special  CBF87375-CBF87376  embl_tpa_prot",
    "special  CBF87378           embl_tpa_prot",
    "special  CBF87380           embl_tpa_prot",
    "special  CBF87382           embl_tpa_prot",
    "special  CBF87384-CBF87385  embl_tpa_prot",
    "special  CBF87387           embl_tpa_prot",
    "special  CBF87389           embl_tpa_prot",
    "special  CBF87391           embl_tpa_prot",
    "special  CBF87393-CBF87394  embl_tpa_prot",
    "special  CBF87396           embl_tpa_prot",
    "special  CBF87398           embl_tpa_prot",
    "special  CBF87400-CBF87402  embl_tpa_prot",
    "special  CBF87404           embl_tpa_prot",
    "special  CBF87406-CBF87407  embl_tpa_prot",
    "special  CBF87409           embl_tpa_prot",
    "special  CBF87411-CBF87412  embl_tpa_prot",
    "special  CBF87414-CBF87415  embl_tpa_prot",
    "special  CBF87417-CBF87418  embl_tpa_prot",
    "special  CBF87420           embl_tpa_prot",
    "special  CBF87422-CBF87423  embl_tpa_prot",
    "special  CBF87425-CBF87426  embl_tpa_prot",
    "special  CBF87428           embl_tpa_prot",
    "special  CBF87430-CBF87431  embl_tpa_prot",
    "special  CBF87433           embl_tpa_prot",
    "special  CBF87435-CBF87436  embl_tpa_prot",
    "special  CBF87438-CBF87439  embl_tpa_prot",
    "special  CBF87441-CBF87442  embl_tpa_prot",
    "special  CBF87444           embl_tpa_prot",
    "special  CBF87446-CBF87447  embl_tpa_prot",
    "special  CBF87449-CBF87450  embl_tpa_prot",
    "special  CBF87452-CBF87453  embl_tpa_prot",
    "special  CBF87455-CBF87456  embl_tpa_prot",
    "special  CBF87458           embl_tpa_prot",
    "special  CBF87460-CBF87461  embl_tpa_prot",
    "special  CBF87463           embl_tpa_prot",
    "special  CBF87465-CBF87466  embl_tpa_prot",
    "special  CBF87468           embl_tpa_prot",
    "special  CBF87470           embl_tpa_prot",
    "special  CBF87472           embl_tpa_prot",
    "special  CBF87474           embl_tpa_prot",
    "special  CBF87476           embl_tpa_prot",
    "special  CBF87478-CBF87479  embl_tpa_prot",
    "special  CBF87481-CBF87485  embl_tpa_prot",
    "special  CBF87487           embl_tpa_prot",
    "special  CBF87489           embl_tpa_prot",
    "special  CBF87491           embl_tpa_prot",
    "special  CBF87493           embl_tpa_prot",
    "special  CBF87495-CBF87496  embl_tpa_prot",
    "special  CBF87498           embl_tpa_prot",
    "special  CBF87500           embl_tpa_prot",
    "special  CBF87502           embl_tpa_prot",
    "special  CBF87504           embl_tpa_prot",
    "special  CBF87506           embl_tpa_prot",
    "special  CBF87508-CBF87509  embl_tpa_prot",
    "special  CBF87511           embl_tpa_prot",
    "special  CBF87513           embl_tpa_prot",
    "special  CBF87515-CBF87516  embl_tpa_prot",
    "special  CBF87518           embl_tpa_prot",
    "special  CBF87520           embl_tpa_prot",
    "special  CBF87522           embl_tpa_prot",
    "special  CBF87524-CBF87526  embl_tpa_prot",
    "special  CBF87528-CBF87529  embl_tpa_prot",
    "special  CBF87531           embl_tpa_prot",
    "special  CBF87533           embl_tpa_prot",
    "special  CBF87535           embl_tpa_prot",
    "special  CBF87537-CBF87538  embl_tpa_prot",
    "special  CBF87540           embl_tpa_prot",
    "special  CBF87542           embl_tpa_prot",
    "special  CBF87544-CBF87545  embl_tpa_prot",
    "special  CBF87547           embl_tpa_prot",
    "special  CBF87549           embl_tpa_prot",
    "special  CBF87551           embl_tpa_prot",
    "special  CBF87553-CBF87554  embl_tpa_prot",
    "special  CBF87556           embl_tpa_prot",
    "special  CBF87558-CBF87559  embl_tpa_prot",
    "special  CBF87561           embl_tpa_prot",
    "special  CBF87563           embl_tpa_prot",
    "special  CBF87565           embl_tpa_prot",
    "special  CBF87567-CBF87568  embl_tpa_prot",
    "special  CBF87570           embl_tpa_prot",
    "special  CBF87572           embl_tpa_prot",
    "special  CBF87574           embl_tpa_prot",
    "special  CBF87576           embl_tpa_prot",
    "special  CBF87578-CBF87579  embl_tpa_prot",
    "special  CBF87581           embl_tpa_prot",
    "special  CBF87583-CBF87585  embl_tpa_prot",
    "special  CBF87587           embl_tpa_prot",
    "special  CBF87589-CBF87590  embl_tpa_prot",
    "special  CBF87592           embl_tpa_prot",
    "special  CBF87594           embl_tpa_prot",
    "special  CBF87596-CBF87598  embl_tpa_prot",
    "special  CBF87600           embl_tpa_prot",
    "special  CBF87602           embl_tpa_prot",
    "special  CBF87604           embl_tpa_prot",
    "special  CBF87606-CBF87607  embl_tpa_prot",
    "special  CBF87609-CBF87610  embl_tpa_prot",
    "special  CBF87612-CBF87613  embl_tpa_prot",
    "special  CBF87615           embl_tpa_prot",
    "special  CBF87617           embl_tpa_prot",
    "special  CBF87619           embl_tpa_prot",
    "special  CBF87621-CBF87622  embl_tpa_prot",
    "special  CBF87624-CBF87625  embl_tpa_prot",
    "special  CBF87627           embl_tpa_prot",
    "special  CBF87629-CBF87630  embl_tpa_prot",
    "special  CBF87632           embl_tpa_prot",
    "special  CBF87634           embl_tpa_prot",
    "special  CBF87636-CBF87637  embl_tpa_prot",
    "special  CBF87639-CBF87640  embl_tpa_prot",
    "special  CBF87642           embl_tpa_prot",
    "special  CBF87644           embl_tpa_prot",
    "special  CBF87646-CBF87647  embl_tpa_prot",
    "special  CBF87649-CBF87650  embl_tpa_prot",
    "special  CBF87652           embl_tpa_prot",
    "special  CBF87654           embl_tpa_prot",
    "special  CBF87656-CBF87657  embl_tpa_prot",
    "special  CBF87659           embl_tpa_prot",
    "special  CBF87661-CBF87662  embl_tpa_prot",
    "special  CBF87664           embl_tpa_prot",
    "special  CBF87666-CBF87667  embl_tpa_prot",
    "special  CBF87669           embl_tpa_prot",
    "special  CBF87671           embl_tpa_prot",
    "special  CBF87673-CBF87674  embl_tpa_prot",
    "special  CBF87676           embl_tpa_prot",
    "special  CBF87678           embl_tpa_prot",
    "special  CBF87680-CBF87681  embl_tpa_prot",
    "special  CBF87683           embl_tpa_prot",
    "special  CBF87685           embl_tpa_prot",
    "special  CBF87687-CBF87688  embl_tpa_prot",
    "special  CBF87690           embl_tpa_prot",
    "special  CBF87692           embl_tpa_prot",
    "special  CBF87694-CBF87695  embl_tpa_prot",
    "special  CBF87697           embl_tpa_prot",
    "special  CBF87699           embl_tpa_prot",
    "special  CBF87701           embl_tpa_prot",
    "special  CBF87703           embl_tpa_prot",
    "special  CBF87705-CBF87706  embl_tpa_prot",
    "special  CBF87708           embl_tpa_prot",
    "special  CBF87710           embl_tpa_prot",
    "special  CBF87712-CBF87713  embl_tpa_prot",
    "special  CBF87715           embl_tpa_prot",
    "special  CBF87717-CBF87718  embl_tpa_prot",
    "special  CBF87720           embl_tpa_prot",
    "special  CBF87722           embl_tpa_prot",
    "special  CBF87724           embl_tpa_prot",
    "special  CBF87726-CBF87727  embl_tpa_prot",
    "special  CBF87729-CBF87730  embl_tpa_prot",
    "special  CBF87732           embl_tpa_prot",
    "special  CBF87734           embl_tpa_prot",
    "special  CBF87736-CBF87737  embl_tpa_prot",
    "special  CBF87739           embl_tpa_prot",
    "special  CBF87741           embl_tpa_prot",
    "special  CBF87743           embl_tpa_prot",
    "special  CBF87745-CBF87746  embl_tpa_prot",
    "special  CBF87748           embl_tpa_prot",
    "special  CBF87750-CBF87751  embl_tpa_prot",
    "special  CBF87753           embl_tpa_prot",
    "special  CBF87755           embl_tpa_prot",
    "special  CBF87757-CBF87759  embl_tpa_prot",
    "special  CBF87761-CBF87762  embl_tpa_prot",
    "special  CBF87764           embl_tpa_prot",
    "special  CBF87766-CBF87767  embl_tpa_prot",
    "special  CBF87769           embl_tpa_prot",
    "special  CBF87771           embl_tpa_prot",
    "special  CBF87773-CBF87775  embl_tpa_prot",
    "special  CBF87777-CBF87778  embl_tpa_prot",
    "special  CBF87780-CBF87781  embl_tpa_prot",
    "special  CBF87783           embl_tpa_prot",
    "special  CBF87785-CBF87786  embl_tpa_prot",
    "special  CBF87788           embl_tpa_prot",
    "special  CBF87790-CBF87791  embl_tpa_prot",
    "special  CBF87793-CBF87794  embl_tpa_prot",
    "special  CBF87796           embl_tpa_prot",
    "special  CBF87798           embl_tpa_prot",
    "special  CBF87800-CBF87801  embl_tpa_prot",
    "special  CBF87803           embl_tpa_prot",
    "special  CBF87805           embl_tpa_prot",
    "special  CBF87807-CBF87808  embl_tpa_prot",
    "special  CBF87810-CBF87811  embl_tpa_prot",
    "special  CBF87813-CBF87814  embl_tpa_prot",
    "special  CBF87816-CBF87817  embl_tpa_prot",
    "special  CBF87819           embl_tpa_prot",
    "special  CBF87821-CBF87822  embl_tpa_prot",
    "special  CBF87824           embl_tpa_prot",
    "special  CBF87826-CBF87827  embl_tpa_prot",
    "special  CBF87829-CBF87830  embl_tpa_prot",
    "special  CBF87832-CBF87833  embl_tpa_prot",
    "special  CBF87835-CBF87836  embl_tpa_prot",
    "special  CBF87838-CBF87839  embl_tpa_prot",
    "special  CBF87841           embl_tpa_prot",
    "special  CBF87843-CBF87844  embl_tpa_prot",
    "special  CBF87846           embl_tpa_prot",
    "special  CBF87848-CBF87849  embl_tpa_prot",
    "special  CBF87851           embl_tpa_prot",
    "special  CBF87853           embl_tpa_prot",
    "special  CBF87855-CBF87856  embl_tpa_prot",
    "special  CBF87858           embl_tpa_prot",
    "special  CBF87860-CBF87861  embl_tpa_prot",
    "special  CBF87863           embl_tpa_prot",
    "special  CBF87865           embl_tpa_prot",
    "special  CBF87867           embl_tpa_prot",
    "special  CBF87869-CBF87870  embl_tpa_prot",
    "special  CBF87872           embl_tpa_prot",
    "special  CBF87874           embl_tpa_prot",
    "special  CBF87876           embl_tpa_prot",
    "special  CBF87878-CBF87879  embl_tpa_prot",
    "special  CBF87881           embl_tpa_prot",
    "special  CBF87883           embl_tpa_prot",
    "special  CBF87885-CBF87886  embl_tpa_prot",
    "special  CBF87888           embl_tpa_prot",
    "special  CBF87890           embl_tpa_prot",
    "special  CBF87892           embl_tpa_prot",
    "special  CBF87894-CBF87895  embl_tpa_prot",
    "special  CBF87897           embl_tpa_prot",
    "special  CBF87899-CBF87900  embl_tpa_prot",
    "special  CBF87902           embl_tpa_prot",
    "special  CBF87904           embl_tpa_prot",
    "special  CBF87906           embl_tpa_prot",
    "special  CBF87908-CBF87909  embl_tpa_prot",
    "special  CBF87911           embl_tpa_prot",
    "special  CBF87913           embl_tpa_prot",
    "special  CBF87915-CBF87916  embl_tpa_prot",
    "special  CBF87918           embl_tpa_prot",
    "special  CBF87920           embl_tpa_prot",
    "special  CBF87922           embl_tpa_prot",
    "special  CBF87924           embl_tpa_prot",
    "special  CBF87926           embl_tpa_prot",
    "special  CBF87928           embl_tpa_prot",
    "special  CBF87930           embl_tpa_prot",
    "special  CBF87932           embl_tpa_prot",
    "special  CBF87934           embl_tpa_prot",
    "special  CBF87936-CBF87937  embl_tpa_prot",
    "special  CBF87939           embl_tpa_prot",
    "special  CBF87941           embl_tpa_prot",
    "special  CBF87943           embl_tpa_prot",
    "special  CBF87945-CBF87946  embl_tpa_prot",
    "special  CBF87948           embl_tpa_prot",
    "special  CBF87950           embl_tpa_prot",
    "special  CBF87952           embl_tpa_prot",
    "special  CBF87954-CBF87955  embl_tpa_prot",
    "special  CBF87957           embl_tpa_prot",
    "special  CBF87959           embl_tpa_prot",
    "special  CBF87961           embl_tpa_prot",
    "special  CBF87963           embl_tpa_prot",
    "special  CBF87965           embl_tpa_prot",
    "special  CBF87967           embl_tpa_prot",
    "special  CBF87969-CBF87970  embl_tpa_prot",
    "special  CBF87972           embl_tpa_prot",
    "special  CBF87974-CBF87975  embl_tpa_prot",
    "special  CBF87977           embl_tpa_prot",
    "special  CBF87979           embl_tpa_prot",
    "special  CBF87981           embl_tpa_prot",
    "special  CBF87983           embl_tpa_prot",
    "special  CBF87985           embl_tpa_prot",
    "special  CBF87987           embl_tpa_prot",
    "special  CBF87989           embl_tpa_prot",
    "special  CBF87991-CBF87992  embl_tpa_prot",
    "special  CBF87994           embl_tpa_prot",
    "special  CBF87996           embl_tpa_prot",
    "special  CBF87998-CBF87999  embl_tpa_prot",
    "special  CBF88001           embl_tpa_prot",
    "special  CBF88003           embl_tpa_prot",
    "special  CBF88005           embl_tpa_prot",
    "special  CBF88007           embl_tpa_prot",
    "special  CBF88009           embl_tpa_prot",
    "special  CBF88011           embl_tpa_prot",
    "special  CBF88013           embl_tpa_prot",
    "special  CBF88015           embl_tpa_prot",
    "special  CBF88017           embl_tpa_prot",
    "special  CBF88019-CBF88020  embl_tpa_prot",
    "special  CBF88022           embl_tpa_prot",
    "special  CBF88024           embl_tpa_prot",
    "special  CBF88026           embl_tpa_prot",
    "special  CBF88028-CBF88029  embl_tpa_prot",
    "special  CBF88031-CBF88032  embl_tpa_prot",
    "special  CBF88034           embl_tpa_prot",
    "special  CBF88036           embl_tpa_prot",
    "special  CBF88038           embl_tpa_prot",
    "special  CBF88040           embl_tpa_prot",
    "special  CBF88042           embl_tpa_prot",
    "special  CBF88044           embl_tpa_prot",
    "special  CBF88046           embl_tpa_prot",
    "special  CBF88048           embl_tpa_prot",
    "special  CBF88050-CBF88051  embl_tpa_prot",
    "special  CBF88053           embl_tpa_prot",
    "special  CBF88055-CBF88056  embl_tpa_prot",
    "special  CBF88058           embl_tpa_prot",
    "special  CBF88060           embl_tpa_prot",
    "special  CBF88062           embl_tpa_prot",
    "special  CBF88064           embl_tpa_prot",
    "special  CBF88066-CBF88067  embl_tpa_prot",
    "special  CBF88069           embl_tpa_prot",
    "special  CBF88071-CBF88072  embl_tpa_prot",
    "special  CBF88074           embl_tpa_prot",
    "special  CBF88076           embl_tpa_prot",
    "special  CBF88078           embl_tpa_prot",
    "special  CBF88080-CBF88081  embl_tpa_prot",
    "special  CBF88083           embl_tpa_prot",
    "special  CBF88085           embl_tpa_prot",
    "special  CBF88087           embl_tpa_prot",
    "special  CBF88089-CBF88090  embl_tpa_prot",
    "special  CBF88092           embl_tpa_prot",
    "special  CBF88095-CBF88096  embl_tpa_prot",
    "special  CBF88098           embl_tpa_prot",
    "special  CBF88100           embl_tpa_prot",
    "special  CBF88102           embl_tpa_prot",
    "special  CBF88104           embl_tpa_prot",
    "special  CBF88106-CBF88107  embl_tpa_prot",
    "special  CBF88109           embl_tpa_prot",
    "special  CBF88111           embl_tpa_prot",
    "special  CBF88113           embl_tpa_prot",
    "special  CBF88115           embl_tpa_prot",
    "special  CBF88117           embl_tpa_prot",
    "special  CBF88119-CBF88120  embl_tpa_prot",
    "special  CBF88122           embl_tpa_prot",
    "special  CBF88124           embl_tpa_prot",
    "special  CBF88126           embl_tpa_prot",
    "special  CBF88128           embl_tpa_prot",
    "special  CBF88130-CBF88131  embl_tpa_prot",
    "special  CBF88133           embl_tpa_prot",
    "special  CBF88135           embl_tpa_prot",
    "special  CBF88137-CBF88138  embl_tpa_prot",
    "special  CBF88140           embl_tpa_prot",
    "special  CBF88142           embl_tpa_prot",
    "special  CBF88144-CBF88145  embl_tpa_prot",
    "special  CBF88147           embl_tpa_prot",
    "special  CBF88149           embl_tpa_prot",
    "special  CBF88151           embl_tpa_prot",
    "special  CBF88153           embl_tpa_prot",
    "special  CBF88155           embl_tpa_prot",
    "special  CBF88157           embl_tpa_prot",
    "special  CBF88159           embl_tpa_prot",
    "special  CBF88161           embl_tpa_prot",
    "special  CBF88163-CBF88164  embl_tpa_prot",
    "special  CBF88166           embl_tpa_prot",
    "special  CBF88168           embl_tpa_prot",
    "special  CBF88170           embl_tpa_prot",
    "special  CBF88172           embl_tpa_prot",
    "special  CBF88174-CBF88175  embl_tpa_prot",
    "special  CBF88177           embl_tpa_prot",
    "special  CBF88179-CBF88180  embl_tpa_prot",
    "special  CBF88182           embl_tpa_prot",
    "special  CBF88184           embl_tpa_prot",
    "special  CBF88186           embl_tpa_prot",
    "special  CBF88188           embl_tpa_prot",
    "special  CBF88190           embl_tpa_prot",
    "special  CBF88192           embl_tpa_prot",
    "special  CBF88194           embl_tpa_prot",
    "special  CBF88196-CBF88197  embl_tpa_prot",
    "special  CBF88199           embl_tpa_prot",
    "special  CBF88201           embl_tpa_prot",
    "special  CBF88203           embl_tpa_prot",
    "special  CBF88205           embl_tpa_prot",
    "special  CBF88207           embl_tpa_prot",
    "special  CBF88209           embl_tpa_prot",
    "special  CBF88211           embl_tpa_prot",
    "special  CBF88213           embl_tpa_prot",
    "special  CBF88215           embl_tpa_prot",
    "special  CBF88218-CBF88219  embl_tpa_prot",
    "special  CBF88221           embl_tpa_prot",
    "special  CBF88223           embl_tpa_prot",
    "special  CBF88225           embl_tpa_prot",
    "special  CBF88227           embl_tpa_prot",
    "special  CBF88229-CBF88230  embl_tpa_prot",
    "special  CBF88232           embl_tpa_prot",
    "special  CBF88234           embl_tpa_prot",
    "special  CBF88236           embl_tpa_prot",
    "special  CBF88238-CBF88239  embl_tpa_prot",
    "special  CBF88241           embl_tpa_prot",
    "special  CBF88243           embl_tpa_prot",
    "special  CBF88245           embl_tpa_prot",
    "special  CBF88247           embl_tpa_prot",
    "special  CBF88249-CBF88250  embl_tpa_prot",
    "special  CBF88252           embl_tpa_prot",
    "special  CBF88254           embl_tpa_prot",
    "special  CBF88256-CBF88257  embl_tpa_prot",
    "special  CBF88259           embl_tpa_prot",
    "special  CBF88261           embl_tpa_prot",
    "special  CBF88263           embl_tpa_prot",
    "special  CBF88265           embl_tpa_prot",
    "special  CBF88267           embl_tpa_prot",
    "special  CBF88269           embl_tpa_prot",
    "special  CBF88271-CBF88272  embl_tpa_prot",
    "special  CBF88274           embl_tpa_prot",
    "special  CBF88276           embl_tpa_prot",
    "special  CBF88278           embl_tpa_prot",
    "special  CBF88280-CBF88281  embl_tpa_prot",
    "special  CBF88283           embl_tpa_prot",
    "special  CBF88285           embl_tpa_prot",
    "special  CBF88287           embl_tpa_prot",
    "special  CBF88289           embl_tpa_prot",
    "special  CBF88291           embl_tpa_prot",
    "special  CBF88293           embl_tpa_prot",
    "special  CBF88295           embl_tpa_prot",
    "special  CBF88297-CBF88298  embl_tpa_prot",
    "special  CBF88300           embl_tpa_prot",
    "special  CBF88302           embl_tpa_prot",
    "special  CBF88304           embl_tpa_prot",
    "special  CBF88306           embl_tpa_prot",
    "special  CBF88308           embl_tpa_prot",
    "special  CBF88310           embl_tpa_prot",
    "special  CBF88312           embl_tpa_prot",
    "special  CBF88314           embl_tpa_prot",
    "special  CBF88316           embl_tpa_prot",
    "special  CBF88318           embl_tpa_prot",
    "special  CBF88320-CBF88321  embl_tpa_prot",
    "special  CBF88323           embl_tpa_prot",
    "special  CBF88325           embl_tpa_prot",
    "special  CBF88327-CBF88328  embl_tpa_prot",
    "special  CBF88330           embl_tpa_prot",
    "special  CBF88332           embl_tpa_prot",
    "special  CBF88334           embl_tpa_prot",
    "special  CBF88336-CBF88337  embl_tpa_prot",
    "special  CBF88339           embl_tpa_prot",
    "special  CBF88341           embl_tpa_prot",
    "special  CBF88343           embl_tpa_prot",
    "special  CBF88345           embl_tpa_prot",
    "special  CBF88347           embl_tpa_prot",
    "special  CBF88349-CBF88350  embl_tpa_prot",
    "special  CBF88352           embl_tpa_prot",
    "special  CBF88354           embl_tpa_prot",
    "special  CBF88356           embl_tpa_prot",
    "special  CBF88358           embl_tpa_prot",
    "special  CBF88360           embl_tpa_prot",
    "special  CBF88362           embl_tpa_prot",
    "special  CBF88364-CBF88365  embl_tpa_prot",
    "special  CBF88367           embl_tpa_prot",
    "special  CBF88369           embl_tpa_prot",
    "special  CBF88371           embl_tpa_prot",
    "special  CBF88373           embl_tpa_prot",
    "special  CBF88375           embl_tpa_prot",
    "special  CBF88377-CBF88378  embl_tpa_prot",
    "special  CBF88380           embl_tpa_prot",
    "special  CBF88382           embl_tpa_prot",
    "special  CBF88384-CBF88385  embl_tpa_prot",
    "special  CBF88387           embl_tpa_prot",
    "special  CBF88389           embl_tpa_prot",
    "special  CBF88391           embl_tpa_prot",
    "special  CBF88393           embl_tpa_prot",
    "special  CBF88395           embl_tpa_prot",
    "special  CBF88397-CBF88398  embl_tpa_prot",
    "special  CBF88400           embl_tpa_prot",
    "special  CBF88402           embl_tpa_prot",
    "special  CBF88404           embl_tpa_prot",
    "special  CBF88406           embl_tpa_prot",
    "special  CBF88408-CBF88409  embl_tpa_prot",
    "special  CBF88411           embl_tpa_prot",
    "special  CBF88413           embl_tpa_prot",
    "special  CBF88415           embl_tpa_prot",
    "special  CBF88417           embl_tpa_prot",
    "special  CBF88419-CBF88420  embl_tpa_prot",
    "special  CBF88422           embl_tpa_prot",
    "special  CBF88424           embl_tpa_prot",
    "special  CBF88426           embl_tpa_prot",
    "special  CBF88428           embl_tpa_prot",
    "special  CBF88430           embl_tpa_prot",
    "special  CBF88432-CBF88433  embl_tpa_prot",
    "special  CBF88435           embl_tpa_prot",
    "special  CBF88437           embl_tpa_prot",
    "special  CBF88439-CBF88440  embl_tpa_prot",
    "special  CBF88442           embl_tpa_prot",
    "special  CBF88444           embl_tpa_prot",
    "special  CBF88446           embl_tpa_prot",
    "special  CBF88448           embl_tpa_prot",
    "special  CBF88450           embl_tpa_prot",
    "special  CBF88452           embl_tpa_prot",
    "special  CBF88454           embl_tpa_prot",
    "special  CBF88456-CBF88457  embl_tpa_prot",
    "special  CBF88459           embl_tpa_prot",
    "special  CBF88461           embl_tpa_prot",
    "special  CBF88463           embl_tpa_prot",
    "special  CBF88465           embl_tpa_prot",
    "special  CBF88467           embl_tpa_prot",
    "special  CBF88469-CBF88470  embl_tpa_prot",
    "special  CBF88472           embl_tpa_prot",
    "special  CBF88474-CBF88475  embl_tpa_prot",
    "special  CBF88477           embl_tpa_prot",
    "special  CBF88479           embl_tpa_prot",
    "special  CBF88481           embl_tpa_prot",
    "special  CBF88483           embl_tpa_prot",
    "special  CBF88485           embl_tpa_prot",
    "special  CBF88487           embl_tpa_prot",
    "special  CBF88489           embl_tpa_prot",
    "special  CBF88491           embl_tpa_prot",
    "special  CBF88493           embl_tpa_prot",
    "special  CBF88495-CBF88496  embl_tpa_prot",
    "special  CBF88498           embl_tpa_prot",
    "special  CBF88500           embl_tpa_prot",
    "special  CBF88502           embl_tpa_prot",
    "special  CBF88504           embl_tpa_prot",
    "special  CBF88506           embl_tpa_prot",
    "special  CBF88508-CBF88509  embl_tpa_prot",
    "special  CBF88511           embl_tpa_prot",
    "special  CBF88513           embl_tpa_prot",
    "special  CBF88515           embl_tpa_prot",
    "special  CBF88517           embl_tpa_prot",
    "special  CBF88519           embl_tpa_prot",
    "special  CBF88521           embl_tpa_prot",
    "special  CBF88523           embl_tpa_prot",
    "special  CBF88525           embl_tpa_prot",
    "special  CBF88527-CBF88528  embl_tpa_prot",
    "special  CBF88530           embl_tpa_prot",
    "special  CBF88532           embl_tpa_prot",
    "special  CBF88534           embl_tpa_prot",
    "special  CBF88536-CBF88537  embl_tpa_prot",
    "special  CBF88539           embl_tpa_prot",
    "special  CBF88541           embl_tpa_prot",
    "special  CBF88543           embl_tpa_prot",
    "special  CBF88545-CBF88546  embl_tpa_prot",
    "special  CBF88548           embl_tpa_prot",
    "special  CBF88550           embl_tpa_prot",
    "special  CBF88552           embl_tpa_prot",
    "special  CBF88554           embl_tpa_prot",
    "special  CBF88556           embl_tpa_prot",
    "special  CBF88558           embl_tpa_prot",
    "special  CBF88560           embl_tpa_prot",
    "special  CBF88562           embl_tpa_prot",
    "special  CBF88564           embl_tpa_prot",
    "special  CBF88566-CBF88567  embl_tpa_prot",
    "special  CBF88569           embl_tpa_prot",
    "special  CBF88571           embl_tpa_prot",
    "special  CBF88573           embl_tpa_prot",
    "special  CBF88575           embl_tpa_prot",
    "special  CBF88577           embl_tpa_prot",
    "special  CBF88579-CBF88580  embl_tpa_prot",
    "special  CBF88582           embl_tpa_prot",
    "special  CBF88584           embl_tpa_prot",
    "special  CBF88586           embl_tpa_prot",
    "special  CBF88588           embl_tpa_prot",
    "special  CBF88590           embl_tpa_prot",
    "special  CBF88592           embl_tpa_prot",
    "special  CBF88594           embl_tpa_prot",
    "special  CBF88596           embl_tpa_prot",
    "special  CBF88598-CBF88599  embl_tpa_prot",
    "special  CBF88602-CBF88603  embl_tpa_prot",
    "special  CBF88605           embl_tpa_prot",
    "special  CBF88607           embl_tpa_prot",
    "special  CBF88609           embl_tpa_prot",
    "special  CBF88611           embl_tpa_prot",
    "special  CBF88613           embl_tpa_prot",
    "special  CBF88615           embl_tpa_prot",
    "special  CBF88617           embl_tpa_prot",
    "special  CBF88619           embl_tpa_prot",
    "special  CBF88621           embl_tpa_prot",
    "special  CBF88623           embl_tpa_prot",
    "special  CBF88625           embl_tpa_prot",
    "special  CBF88627-CBF88628  embl_tpa_prot",
    "special  CBF88630           embl_tpa_prot",
    "special  CBF88632           embl_tpa_prot",
    "special  CBF88634           embl_tpa_prot",
    "special  CBF88636           embl_tpa_prot",
    "special  CBF88638           embl_tpa_prot",
    "special  CBF88640-CBF88641  embl_tpa_prot",
    "special  CBF88644-CBF88645  embl_tpa_prot",
    "special  CBF88647           embl_tpa_prot",
    "special  CBF88649           embl_tpa_prot",
    "special  CBF88651           embl_tpa_prot",
    "special  CBF88653           embl_tpa_prot",
    "special  CBF88655           embl_tpa_prot",
    "special  CBF88657           embl_tpa_prot",
    "special  CBF88659           embl_tpa_prot",
    "special  CBF88661-CBF88662  embl_tpa_prot",
    "special  CBF88664           embl_tpa_prot",
    "special  CBF88666           embl_tpa_prot",
    "special  CBF88668           embl_tpa_prot",
    "special  CBF88670           embl_tpa_prot",
    "special  CBF88672           embl_tpa_prot",
    "special  CBF88674           embl_tpa_prot",
    "special  CBF88676           embl_tpa_prot",
    "special  CBF88678-CBF88679  embl_tpa_prot",
    "special  CBF88681           embl_tpa_prot",
    "special  CBF88683-CBF88684  embl_tpa_prot",
    "special  CBF88686           embl_tpa_prot",
    "special  CBF88688           embl_tpa_prot",
    "special  CBF88690           embl_tpa_prot",
    "special  CBF88692           embl_tpa_prot",
    "special  CBF88694-CBF88695  embl_tpa_prot",
    "special  CBF88697           embl_tpa_prot",
    "special  CBF88699           embl_tpa_prot",
    "special  CBF88701           embl_tpa_prot",
    "special  CBF88703           embl_tpa_prot",
    "special  CBF88705-CBF88706  embl_tpa_prot",
    "special  CBF88708           embl_tpa_prot",
    "special  CBF88710           embl_tpa_prot",
    "special  CBF88712           embl_tpa_prot",
    "special  CBF88714           embl_tpa_prot",
    "special  CBF88716           embl_tpa_prot",
    "special  CBF88718           embl_tpa_prot",
    "special  CBF88720-CBF88721  embl_tpa_prot",
    "special  CBF88723           embl_tpa_prot",
    "special  CBF88725           embl_tpa_prot",
    "special  CBF88727-CBF88728  embl_tpa_prot",
    "special  CBF88730           embl_tpa_prot",
    "special  CBF88732           embl_tpa_prot",
    "special  CBF88734           embl_tpa_prot",
    "special  CBF88736           embl_tpa_prot",
    "special  CBF88738-CBF88739  embl_tpa_prot",
    "special  CBF88741           embl_tpa_prot",
    "special  CBF88743           embl_tpa_prot",
    "special  CBF88745           embl_tpa_prot",
    "special  CBF88747-CBF88748  embl_tpa_prot",
    "special  CBF88750           embl_tpa_prot",
    "special  CBF88752           embl_tpa_prot",
    "special  CBF88754           embl_tpa_prot",
    "special  CBF88756           embl_tpa_prot",
    "special  CBF88758-CBF88759  embl_tpa_prot",
    "special  CBF88761           embl_tpa_prot",
    "special  CBF88763           embl_tpa_prot",
    "special  CBF88765           embl_tpa_prot",
    "special  CBF88767-CBF88768  embl_tpa_prot",
    "special  CBF88770           embl_tpa_prot",
    "special  CBF88772           embl_tpa_prot",
    "special  CBF88774           embl_tpa_prot",
    "special  CBF88776           embl_tpa_prot",
    "special  CBF88778           embl_tpa_prot",
    "special  CBF88780           embl_tpa_prot",
    "special  CBF88782-CBF88783  embl_tpa_prot",
    "special  CBF88785           embl_tpa_prot",
    "special  CBF88787           embl_tpa_prot",
    "special  CBF88789           embl_tpa_prot",
    "special  CBF88791-CBF88792  embl_tpa_prot",
    "special  CBF88794           embl_tpa_prot",
    "special  CBF88796           embl_tpa_prot",
    "special  CBF88798           embl_tpa_prot",
    "special  CBF88800           embl_tpa_prot",
    "special  CBF88802           embl_tpa_prot",
    "special  CBF88804           embl_tpa_prot",
    "special  CBF88806           embl_tpa_prot",
    "special  CBF88808-CBF88809  embl_tpa_prot",
    "special  CBF88811           embl_tpa_prot",
    "special  CBF88813           embl_tpa_prot",
    "special  CBF88815           embl_tpa_prot",
    "special  CBF88817           embl_tpa_prot",
    "special  CBF88819-CBF88820  embl_tpa_prot",
    "special  CBF88822           embl_tpa_prot",
    "special  CBF88824           embl_tpa_prot",
    "special  CBF88826           embl_tpa_prot",
    "special  CBF88828           embl_tpa_prot",
    "special  CBF88830           embl_tpa_prot",
    "special  CBF88832           embl_tpa_prot",
    "special  CBF88834-CBF88835  embl_tpa_prot",
    "special  CBF88837           embl_tpa_prot",
    "special  CBF88839           embl_tpa_prot",
    "special  CBF88841           embl_tpa_prot",
    "special  CBF88843           embl_tpa_prot",
    "special  CBF88845           embl_tpa_prot",
    "special  CBF88847-CBF88848  embl_tpa_prot",
    "special  CBF88850           embl_tpa_prot",
    "special  CBF88852           embl_tpa_prot",
    "special  CBF88854           embl_tpa_prot",
    "special  CBF88856           embl_tpa_prot",
    "special  CBF88858           embl_tpa_prot",
    "special  CBF88861-CBF88862  embl_tpa_prot",
    "special  CBF88864           embl_tpa_prot",
    "special  CBF88866           embl_tpa_prot",
    "special  CBF88868           embl_tpa_prot",
    "special  CBF88870-CBF88871  embl_tpa_prot",
    "special  CBF88873           embl_tpa_prot",
    "special  CBF88875           embl_tpa_prot",
    "special  CBF88877           embl_tpa_prot",
    "special  CBF88879           embl_tpa_prot",
    "special  CBF88882-CBF88883  embl_tpa_prot",
    "special  CBF88885           embl_tpa_prot",
    "special  CBF88887           embl_tpa_prot",
    "special  CBF88889-CBF88890  embl_tpa_prot",
    "special  CBF88892           embl_tpa_prot",
    "special  CBF88894           embl_tpa_prot",
    "special  CBF88896           embl_tpa_prot",
    "special  CBF88898           embl_tpa_prot",
    "special  CBF88900           embl_tpa_prot",
    "special  CBF88902-CBF88903  embl_tpa_prot",
    "special  CBF88905           embl_tpa_prot",
    "special  CBF88907           embl_tpa_prot",
    "special  CBF88909           embl_tpa_prot",
    "special  CBF88911-CBF88912  embl_tpa_prot",
    "special  CBF88914           embl_tpa_prot",
    "special  CBF88916           embl_tpa_prot",
    "special  CBF88918           embl_tpa_prot",
    "special  CBF88920-CBF88921  embl_tpa_prot",
    "special  CBF88923           embl_tpa_prot",
    "special  CBF88925           embl_tpa_prot",
    "special  CBF88927           embl_tpa_prot",
    "special  CBF88929           embl_tpa_prot",
    "special  CBF88931           embl_tpa_prot",
    "special  CBF88933           embl_tpa_prot",
    "special  CBF88935-CBF88936  embl_tpa_prot",
    "special  CBF88938           embl_tpa_prot",
    "special  CBF88940           embl_tpa_prot",
    "special  CBF88942           embl_tpa_prot",
    "special  CBF88944           embl_tpa_prot",
    "special  CBF88946           embl_tpa_prot",
    "special  CBF88948           embl_tpa_prot",
    "special  CBF88950-CBF88951  embl_tpa_prot",
    "special  CBF88953           embl_tpa_prot",
    "special  CBF88955           embl_tpa_prot",
    "special  CBF88957-CBF88958  embl_tpa_prot",
    "special  CBF88960           embl_tpa_prot",
    "special  CBF88962-CBF88963  embl_tpa_prot",
    "special  CBF88965           embl_tpa_prot",
    "special  CBF88967-CBF88968  embl_tpa_prot",
    "special  CBF88970           embl_tpa_prot",
    "special  CBF88972-CBF88973  embl_tpa_prot",
    "special  CBF88975           embl_tpa_prot",
    "special  CBF88977           embl_tpa_prot",
    "special  CBF88979           embl_tpa_prot",
    "special  CBF88981           embl_tpa_prot",
    "special  CBF88983-CBF88984  embl_tpa_prot",
    "special  CBF88986           embl_tpa_prot",
    "special  CBF88988           embl_tpa_prot",
    "special  CBF88990-CBF88991  embl_tpa_prot",
    "special  CBF88993           embl_tpa_prot",
    "special  CBF88995           embl_tpa_prot",
    "special  CBF88997-CBF88998  embl_tpa_prot",
    "special  CBF89000           embl_tpa_prot",
    "special  CBF89002           embl_tpa_prot",
    "special  CBF89004           embl_tpa_prot",
    "special  CBF89006-CBF89007  embl_tpa_prot",
    "special  CBF89009           embl_tpa_prot",
    "special  CBF89011-CBF89012  embl_tpa_prot",
    "special  CBF89014           embl_tpa_prot",
    "special  CBF89016           embl_tpa_prot",
    "special  CBF89018           embl_tpa_prot",
    "special  CBF89020           embl_tpa_prot",
    "special  CBF89022-CBF89023  embl_tpa_prot",
    "special  CBF89025           embl_tpa_prot",
    "special  CBF89027           embl_tpa_prot",
    "special  CBF89029           embl_tpa_prot",
    "special  CBF89031           embl_tpa_prot",
    "special  CBF89033-CBF89034  embl_tpa_prot",
    "special  CBF89036           embl_tpa_prot",
    "special  CBF89038           embl_tpa_prot",
    "special  CBF89040           embl_tpa_prot",
    "special  CBF89042           embl_tpa_prot",
    "special  CBF89044-CBF89045  embl_tpa_prot",
    "special  CBF89047           embl_tpa_prot",
    "special  CBF89049           embl_tpa_prot",
    "special  CBF89051           embl_tpa_prot",
    "special  CBF89053           embl_tpa_prot",
    "special  CBF89055           embl_tpa_prot",
    "special  CBF89057-CBF89058  embl_tpa_prot",
    "special  CBF89060           embl_tpa_prot",
    "special  CBF89062-CBF89063  embl_tpa_prot",
    "special  CBF89065           embl_tpa_prot",
    "special  CBF89067           embl_tpa_prot",
    "special  CBF89069           embl_tpa_prot",
    "special  CBF89071           embl_tpa_prot",
    "special  CBF89073           embl_tpa_prot",
    "special  CBF89075           embl_tpa_prot",
    "special  CBF89077           embl_tpa_prot",
    "special  CBF89079           embl_tpa_prot",
    "special  CBF89081           embl_tpa_prot",
    "special  CBF89083           embl_tpa_prot",
    "special  CBF89085           embl_tpa_prot",
    "special  CBF89087-CBF89088  embl_tpa_prot",
    "special  CBF89090           embl_tpa_prot",
    "special  CBF89092           embl_tpa_prot",
    "special  CBF89094           embl_tpa_prot",
    "special  CBF89096-CBF89097  embl_tpa_prot",
    "special  CBF89099           embl_tpa_prot",
    "special  CBF89101           embl_tpa_prot",
    "special  CBF89103           embl_tpa_prot",
    "special  CBF89105-CBF89106  embl_tpa_prot",
    "special  CBF89108           embl_tpa_prot",
    "special  CBF89110           embl_tpa_prot",
    "special  CBF89112           embl_tpa_prot",
    "special  CBF89115           embl_tpa_prot",
    "special  CBF89117           embl_tpa_prot",
    "special  CBF89119-CBF89120  embl_tpa_prot",
    "special  CBF89122           embl_tpa_prot",
    "special  CBF89124           embl_tpa_prot",
    "special  CBF89126-CBF89127  embl_tpa_prot",
    "special  CBF89129           embl_tpa_prot",
    "special  CBF89131           embl_tpa_prot",
    "special  CBF89133           embl_tpa_prot",
    "special  CBF89135           embl_tpa_prot",
    "special  CBF89137           embl_tpa_prot",
    "special  CBF89139-CBF89140  embl_tpa_prot",
    "special  CBF89142           embl_tpa_prot",
    "special  CBF89144-CBF89145  embl_tpa_prot",
    "special  CBF89147           embl_tpa_prot",
    "special  CBF89149           embl_tpa_prot",
    "special  CBF89151           embl_tpa_prot",
    "special  CBF89153           embl_tpa_prot",
    "special  CBF89155           embl_tpa_prot",
    "special  CBF89157-CBF89158  embl_tpa_prot",
    "special  CBF89160           embl_tpa_prot",
    "special  CBF89162           embl_tpa_prot",
    "special  CBF89164           embl_tpa_prot",
    "special  CBF89166           embl_tpa_prot",
    "special  CBF89168-CBF89169  embl_tpa_prot",
    "special  CBF89171           embl_tpa_prot",
    "special  CBF89173           embl_tpa_prot",
    "special  CBF89175           embl_tpa_prot",
    "special  CBF89177           embl_tpa_prot",
    "special  CBF89179           embl_tpa_prot",
    "special  CBF89181           embl_tpa_prot",
    "special  CBF89183-CBF89184  embl_tpa_prot",
    "special  CBF89186           embl_tpa_prot",
    "special  CBF89188           embl_tpa_prot",
    "special  CBF89190           embl_tpa_prot",
    "special  CBF89192           embl_tpa_prot",
    "special  CBF89194           embl_tpa_prot",
    "special  CBF89196-CBF89197  embl_tpa_prot",
    "special  CBF89199           embl_tpa_prot",
    "special  CBF89201           embl_tpa_prot",
    "special  CBF89203           embl_tpa_prot",
    "special  CBF89205-CBF89206  embl_tpa_prot",
    "special  CBF89208           embl_tpa_prot",
    "special  CBF89210           embl_tpa_prot",
    "special  CBF89212           embl_tpa_prot",
    "special  CBF89214           embl_tpa_prot",
    "special  CBF89216-CBF89217  embl_tpa_prot",
    "special  CBF89219           embl_tpa_prot",
    "special  CBF89221           embl_tpa_prot",
    "special  CBF89223-CBF89224  embl_tpa_prot",
    "special  CBF89226           embl_tpa_prot",
    "special  CBF89228           embl_tpa_prot",
    "special  CBF89230           embl_tpa_prot",
    "special  CBF89232           embl_tpa_prot",
    "special  CBF89234           embl_tpa_prot",
    "special  CBF89236-CBF89237  embl_tpa_prot",
    "special  CBF89239           embl_tpa_prot",
    "special  CBF89241           embl_tpa_prot",
    "special  CBF89243           embl_tpa_prot",
    "special  CBF89245           embl_tpa_prot",
    "special  CBF89247-CBF89248  embl_tpa_prot",
    "special  CBF89250           embl_tpa_prot",
    "special  CBF89252           embl_tpa_prot",
    "special  CBF89254           embl_tpa_prot",
    "special  CBF89256           embl_tpa_prot",
    "special  CBF89258           embl_tpa_prot",
    "special  CBF89260           embl_tpa_prot",
    "special  CBF89262-CBF89263  embl_tpa_prot",
    "special  CBF89265           embl_tpa_prot",
    "special  CBF89267           embl_tpa_prot",
    "special  CBF89269-CBF89270  embl_tpa_prot",
    "special  CBF89272           embl_tpa_prot",
    "special  CBF89274           embl_tpa_prot",
    "special  CBF89276           embl_tpa_prot",
    "special  CBF89278-CBF89279  embl_tpa_prot",
    "special  CBF89281           embl_tpa_prot",
    "special  CBF89283           embl_tpa_prot",
    "special  CBF89285-CBF89286  embl_tpa_prot",
    "special  CBF89288           embl_tpa_prot",
    "special  CBF89290           embl_tpa_prot",
    "special  CBF89292-CBF89293  embl_tpa_prot",
    "special  CBF89295           embl_tpa_prot",
    "special  CBF89297           embl_tpa_prot",
    "special  CBF89299           embl_tpa_prot",
    "special  CBF89301           embl_tpa_prot",
    "special  CBF89303           embl_tpa_prot",
    "special  CBF89305           embl_tpa_prot",
    "special  CBF89307           embl_tpa_prot",
    "special  CBF89309           embl_tpa_prot",
    "special  CBF89311-CBF89312  embl_tpa_prot",
    "special  CBF89314           embl_tpa_prot",
    "special  CBF89316           embl_tpa_prot",
    "special  CBF89318           embl_tpa_prot",
    "special  CBF89320           embl_tpa_prot",
    "special  CBF89322-CBF89323  embl_tpa_prot",
    "special  CBF89325           embl_tpa_prot",
    "special  CBF89327           embl_tpa_prot",
    "special  CBF89329           embl_tpa_prot",
    "special  CBF89331           embl_tpa_prot",
    "special  CBF89333-CBF89334  embl_tpa_prot",
    "special  CBF89336           embl_tpa_prot",
    "special  CBF89338-CBF89339  embl_tpa_prot",
    "special  CBF89341           embl_tpa_prot",
    "special  CBF89343           embl_tpa_prot",
    "special  CBF89345-CBF89346  embl_tpa_prot",
    "special  CBF89348           embl_tpa_prot",
    "special  CBF89350           embl_tpa_prot",
    "special  CBF89352-CBF89353  embl_tpa_prot",
    "special  CBF89355           embl_tpa_prot",
    "special  CBF89357           embl_tpa_prot",
    "special  CBF89359           embl_tpa_prot",
    "special  CBF89361           embl_tpa_prot",
    "special  CBF89363           embl_tpa_prot",
    "special  CBF89365-CBF89366  embl_tpa_prot",
    "special  CBF89368-CBF89369  embl_tpa_prot",
    "special  CBF89371           embl_tpa_prot",
    "special  CBF89373           embl_tpa_prot",
    "special  CBF89375           embl_tpa_prot",
    "special  CBF89377           embl_tpa_prot",
    "special  CBF89379-CBF89380  embl_tpa_prot",
    "special  CBF89382           embl_tpa_prot",
    "special  CBF89384           embl_tpa_prot",
    "special  CBF89386           embl_tpa_prot",
    "special  CBF89388           embl_tpa_prot",
    "special  CBF89390           embl_tpa_prot",
    "special  CBF89392           embl_tpa_prot",
    "special  CBF89394           embl_tpa_prot",
    "special  CBF89396-CBF89397  embl_tpa_prot",
    "special  CBF89399           embl_tpa_prot",
    "special  CBF89401           embl_tpa_prot",
    "special  CBF89403           embl_tpa_prot",
    "special  CBF89405-CBF89406  embl_tpa_prot",
    "special  CBF89408           embl_tpa_prot",
    "special  CBF89410           embl_tpa_prot",
    "special  CBF89412           embl_tpa_prot",
    "special  CBF89414           embl_tpa_prot",
    "special  CBF89416           embl_tpa_prot",
    "special  CBF89418           embl_tpa_prot",
    "special  CBF89420           embl_tpa_prot",
    "special  CBF89422-CBF89423  embl_tpa_prot",
    "special  CBF89425           embl_tpa_prot",
    "special  CBF89427           embl_tpa_prot",
    "special  CBF89429-CBF89430  embl_tpa_prot",
    "special  CBF89432-CBF89433  embl_tpa_prot",
    "special  CBF89435           embl_tpa_prot",
    "special  CBF89437-CBF89439  embl_tpa_prot",
    "special  CBF89441           embl_tpa_prot",
    "special  CBF89443-CBF89444  embl_tpa_prot",
    "special  CBF89446           embl_tpa_prot",
    "special  CBF89448-CBF89449  embl_tpa_prot",
    "special  CBF89451           embl_tpa_prot",
    "special  CBF89453           embl_tpa_prot",
    "special  CBF89455           embl_tpa_prot",
    "special  CBF89457           embl_tpa_prot",
    "special  CBF89459           embl_tpa_prot",
    "special  CBF89461           embl_tpa_prot",
    "special  CBF89463           embl_tpa_prot",
    "special  CBF89465           embl_tpa_prot",
    "special  CBF89467-CBF89468  embl_tpa_prot",
    "special  CBF89470           embl_tpa_prot",
    "special  CBF89472           embl_tpa_prot",
    "special  CBF89474           embl_tpa_prot",
    "special  CBF89476           embl_tpa_prot",
    "special  CBF89478           embl_tpa_prot",
    "special  CBF89480           embl_tpa_prot",
    "special  CBF89482-CBF89483  embl_tpa_prot",
    "special  CBF89485           embl_tpa_prot",
    "special  CBF89487           embl_tpa_prot",
    "special  CBF89489           embl_tpa_prot",
    "special  CBF89491           embl_tpa_prot",
    "special  CBF89493           embl_tpa_prot",
    "special  CBF89495-CBF89496  embl_tpa_prot",
    "special  CBF89498           embl_tpa_prot",
    "special  CBF89500           embl_tpa_prot",
    "special  CBF89502           embl_tpa_prot",
    "special  CBF89504           embl_tpa_prot",
    "special  CBF89506           embl_tpa_prot",
    "special  CBF89508-CBF89509  embl_tpa_prot",
    "special  CBF89511           embl_tpa_prot",
    "special  CBF89513-CBF89514  embl_tpa_prot",
    "special  CBF89516           embl_tpa_prot",
    "special  CBF89518           embl_tpa_prot",
    "special  CBF89520           embl_tpa_prot",
    "special  CBF89522-CBF89523  embl_tpa_prot",
    "special  CBF89525           embl_tpa_prot",
    "special  CBF89527           embl_tpa_prot",
    "special  CBF89529           embl_tpa_prot",
    "special  CBF89532-CBF89533  embl_tpa_prot",
    "special  CBF89535           embl_tpa_prot",
    "special  CBF89537           embl_tpa_prot",
    "special  CBF89539-CBF89540  embl_tpa_prot",
    "special  CBF89542           embl_tpa_prot",
    "special  CBF89544           embl_tpa_prot",
    "special  CBF89546           embl_tpa_prot",
    "special  CBF89548           embl_tpa_prot",
    "special  CBF89550           embl_tpa_prot",
    "special  CBF89552-CBF89553  embl_tpa_prot",
    "special  CBF89555           embl_tpa_prot",
    "special  CBF89557           embl_tpa_prot",
    "special  CBF89559           embl_tpa_prot",
    "special  CBF89561           embl_tpa_prot",
    "special  CBF89563           embl_tpa_prot",
    "special  CBF89565-CBF89566  embl_tpa_prot",
    "special  CBF89568           embl_tpa_prot",
    "special  CBF89570           embl_tpa_prot",
    "special  CBF89572           embl_tpa_prot",
    "special  CBF89574           embl_tpa_prot",
    "special  CBF89576-CBF89577  embl_tpa_prot",
    "special  CBF89579           embl_tpa_prot",
    "special  CBF89581           embl_tpa_prot",
    "special  CBF89583           embl_tpa_prot",
    "special  CBF89585           embl_tpa_prot",
    "special  CBF89587           embl_tpa_prot",
    "special  CBF89589           embl_tpa_prot",
    "special  CBF89591-CBF89592  embl_tpa_prot",
    "special  CBF89594           embl_tpa_prot",
    "special  CBF89596           embl_tpa_prot",
    "special  CBF89598           embl_tpa_prot",
    "special  CBF89600           embl_tpa_prot",
    "special  CBF89602           embl_tpa_prot",
    "special  CBF89604           embl_tpa_prot",
    "special  CBF89606           embl_tpa_prot",
    "special  CBF89608           embl_tpa_prot",
    "special  CBF89610           embl_tpa_prot",
    "special  CBF89612           embl_tpa_prot",
    "special  CBF89614           embl_tpa_prot",
    "special  CBF89616-CBF89617  embl_tpa_prot",
    "special  CBF89619           embl_tpa_prot",
    "special  CBF89621           embl_tpa_prot",
    "special  CBF89623           embl_tpa_prot",
    "special  CBF89625-CBF89626  embl_tpa_prot",
    "special  CBF89628           embl_tpa_prot",
    "special  CBF89630           embl_tpa_prot",
    "special  CBF89632           embl_tpa_prot",
    "special  CBF89634           embl_tpa_prot",
    "special  CBF89636           embl_tpa_prot",
    "special  CBF89638-CBF89639  embl_tpa_prot",
    "special  CBF89641           embl_tpa_prot",
    "special  CBF89643           embl_tpa_prot",
    "special  CBF89645-CBF89646  embl_tpa_prot",
    "special  CBF89648           embl_tpa_prot",
    "special  CBF89650           embl_tpa_prot",
    "special  CBF89652           embl_tpa_prot",
    "special  CBF89654-CBF89655  embl_tpa_prot",
    "special  CBF89657           embl_tpa_prot",
    "special  CBF89659           embl_tpa_prot",
    "special  CBF89661           embl_tpa_prot",
    "special  CBF89663           embl_tpa_prot",
    "special  CBF89665-CBF89666  embl_tpa_prot",
    "special  CBF89668           embl_tpa_prot",
    "special  CBF89670           embl_tpa_prot",
    "special  CBF89672           embl_tpa_prot",
    "special  CBF89674           embl_tpa_prot",
    "special  CBF89676           embl_tpa_prot",
    "special  CBF89678           embl_tpa_prot",
    "special  CBF89680           embl_tpa_prot",
    "special  CBF89682-CBF89683  embl_tpa_prot",
    "special  CBF89685           embl_tpa_prot",
    "special  CBF89687           embl_tpa_prot",
    "special  CBF89689           embl_tpa_prot",
    "special  CBF89691           embl_tpa_prot",
    "special  CBF89693-CBF89694  embl_tpa_prot",
    "special  CBF89696           embl_tpa_prot",
    "special  CBF89698           embl_tpa_prot",
    "special  CBF89700           embl_tpa_prot",
    "special  CBF89702           embl_tpa_prot",
    "special  CBF89704-CBF89705  embl_tpa_prot",
    "special  CBF89707           embl_tpa_prot",
    "special  CBF89709-CBF89710  embl_tpa_prot",
    "special  CBF89712           embl_tpa_prot",
    "special  CBF89714           embl_tpa_prot",
    "special  CBF89716           embl_tpa_prot",
    "special  CBF89718-CBF89719  embl_tpa_prot",
    "special  CBF89721           embl_tpa_prot",
    "special  CBF89723           embl_tpa_prot",
    "special  CBF89725-CBF89726  embl_tpa_prot",
    "special  CBF89728           embl_tpa_prot",
    "special  CBF89730-CBF89731  embl_tpa_prot",
    "special  CBF89733           embl_tpa_prot",
    "special  CBF89735           embl_tpa_prot",
    "special  CBF89737           embl_tpa_prot",
    "special  CBF89739-CBF89740  embl_tpa_prot",
    "special  CBF89742           embl_tpa_prot",
    "special  CBF89744           embl_tpa_prot",
    "special  CBF89746-CBF89747  embl_tpa_prot",
    "special  CBF89749           embl_tpa_prot",
    "special  CBF89751           embl_tpa_prot",
    "special  CBF89753           embl_tpa_prot",
    "special  CBF89755           embl_tpa_prot",
    "special  CBF89757           embl_tpa_prot",
    "special  CBF89759-CBF89760  embl_tpa_prot",
    "special  CBF89762           embl_tpa_prot",
    "special  CBF89764           embl_tpa_prot",
    "special  CBF89766-CBF89767  embl_tpa_prot",
    "special  CBF89769           embl_tpa_prot",
    "special  CBF89771           embl_tpa_prot",
    "special  CBF89773           embl_tpa_prot",
    "special  CBF89775           embl_tpa_prot",
    "special  CBF89777           embl_tpa_prot",
    "special  CBF89779-CBF89780  embl_tpa_prot",
    "special  CBF89782           embl_tpa_prot",
    "special  CBF89784           embl_tpa_prot",
    "special  CBF89786           embl_tpa_prot",
    "special  CBF89788           embl_tpa_prot",
    "special  CBF89790-CBF89791  embl_tpa_prot",
    "special  CBF89793           embl_tpa_prot",
    "special  CBF89795           embl_tpa_prot",
    "special  CBF89797           embl_tpa_prot",
    "special  CBF89799           embl_tpa_prot",
    "special  CBF89801-CBF89802  embl_tpa_prot",
    "special  CBF89804           embl_tpa_prot",
    "special  CBF89806           embl_tpa_prot",
    "special  CBF89808           embl_tpa_prot",
    "special  CBF89810           embl_tpa_prot",
    "special  CBF89812-CBF89813  embl_tpa_prot",
    "special  CBF89815           embl_tpa_prot",
    "special  CBF89817-CBF89818  embl_tpa_prot",
    "special  CBF89820           embl_tpa_prot",
    "special  CBF89822           embl_tpa_prot",
    "special  CBF89824           embl_tpa_prot",
    "special  CBF89826           embl_tpa_prot",
    "special  CBF89828           embl_tpa_prot",
    "special  CBF89830-CBF89831  embl_tpa_prot",
    "special  CBF89833           embl_tpa_prot",
    "special  CBF89835           embl_tpa_prot",
    "special  CBF89837           embl_tpa_prot",
    "special  CBF89839           embl_tpa_prot",
    "special  CBF89841           embl_tpa_prot",
    "special  CBF89843           embl_tpa_prot",
    "special  CBF89845           embl_tpa_prot",
    "special  CBF89847-CBF89848  embl_tpa_prot",
    "special  CBF89850           embl_tpa_prot",
    "special  CBF89852           embl_tpa_prot",
    "special  CBF89854-CBF89855  embl_tpa_prot",
    "special  CBF89857           embl_tpa_prot",
    "special  CBF89859           embl_tpa_prot",
    "special  CBF89861-CBF89862  embl_tpa_prot",
    "special  CBF89864-CBF89865  embl_tpa_prot",
    "special  CBF89867           embl_tpa_prot",
    "special  CBF89869           embl_tpa_prot",
    "special  CBF89871           embl_tpa_prot",
    "special  CBF89873-CBF89874  embl_tpa_prot",
    "special  CBF89876           embl_tpa_prot",
    "special  CBF89878           embl_tpa_prot",
    "special  CBF89880           embl_tpa_prot",
    "special  CBF89882           embl_tpa_prot",
    "special  CBF89884-CBF89885  embl_tpa_prot",
    "special  CBF89887           embl_tpa_prot",
    "special  CBF89889           embl_tpa_prot",
    "special  CBF89891           embl_tpa_prot",
    "special  CBF89893           embl_tpa_prot",
    "special  CBF89895           embl_tpa_prot",
    "special  CBF89897           embl_tpa_prot",
    "special  CBF89899-CBF89900  embl_tpa_prot",
    "special  CBF89903-CBF89904  embl_tpa_prot",
    "special  CBF89906           embl_tpa_prot",
    "special  CBF89908           embl_tpa_prot",
    "special  CBF89910           embl_tpa_prot",
    "special  CBF89912-CBF89913  embl_tpa_prot",
    "special  CBF89915           embl_tpa_prot",
    "special  CBF89917           embl_tpa_prot",
    "special  CBF89919           embl_tpa_prot",
    "special  CBF89921           embl_tpa_prot",
    "special  CBF89923           embl_tpa_prot",
    "special  CBF89925           embl_tpa_prot",
    "special  CBF89927           embl_tpa_prot",
    "special  CBF89929-CBF89930  embl_tpa_prot",
    "special  CBF89932-CBF89933  embl_tpa_prot",
    "special  CBF89935           embl_tpa_prot",
    "special  CBF89937           embl_tpa_prot",
    "special  CBF89939           embl_tpa_prot",
    "special  CBF89941           embl_tpa_prot",
    "special  CBF89943           embl_tpa_prot",
    "special  CBF89945-CBF89946  embl_tpa_prot",
    "special  CBF89948           embl_tpa_prot",
    "special  CBF89950           embl_tpa_prot",
    "special  CBF89952           embl_tpa_prot",
    "special  CBF89954           embl_tpa_prot",
    "special  CBF89956           embl_tpa_prot",
    "special  CBF89958-CBF89959  embl_tpa_prot",
    "special  CBF89961           embl_tpa_prot",
    "special  CBF89963           embl_tpa_prot",
    "special  CBF89965-CBF89966  embl_tpa_prot",
    "special  CBF89968           embl_tpa_prot",
    "special  CBF89970           embl_tpa_prot",
    "special  CBF89972           embl_tpa_prot",
    "special  CBF89974           embl_tpa_prot",
    "special  CBF89976           embl_tpa_prot",
    "special  CBF89978           embl_tpa_prot",
    "special  CBF89980           embl_tpa_prot",
    "special  CBF89982           embl_tpa_prot",
    "special  CBF89984-CBF89985  embl_tpa_prot",
    "special  CBF89987           embl_tpa_prot",
    "special  CBF89989           embl_tpa_prot",
    "special  CBF89991           embl_tpa_prot",
    "special  CBF89993-CBF89994  embl_tpa_prot",
    "special  CBF89996           embl_tpa_prot",
    "special  CBF89998           embl_tpa_prot",
    "special  CBF90000           embl_tpa_prot",
    "special  CBF90002           embl_tpa_prot",
    "special  CBF90004-CBF90005  embl_tpa_prot",
    "special  CBF90007           embl_tpa_prot",
    "special  CBF90009           embl_tpa_prot",
    "special  CBF90011           embl_tpa_prot",
    "special  CBF90013           embl_tpa_prot",
    "special  CBF90015           embl_tpa_prot",
    "special  CBF90017-CBF90018  embl_tpa_prot",
    "special  CBF90020           embl_tpa_prot",
    "special  CBF90022           embl_tpa_prot",
    "special  CBF90024-CBF90025  embl_tpa_prot",
    "special  CBF90027           embl_tpa_prot",
    "special  CBF90029           embl_tpa_prot",
    "special  CBF90031-CBF90032  embl_tpa_prot",
    "special  CBF90034           embl_tpa_prot",
    "special  CBF90036           embl_tpa_prot",
    "special  CBF90038-CBF90039  embl_tpa_prot",
    "special  CBF90041           embl_tpa_prot",
    "special  CBF90043           embl_tpa_prot",
    "special  CBF90045           embl_tpa_prot",
    "special  CBF90047           embl_tpa_prot",
    "special  CBF90049-CBF90050  embl_tpa_prot",
    "special  CBF90052           embl_tpa_prot",
    "special  CBF90054           embl_tpa_prot",
    "special  CBF90056           embl_tpa_prot",
    "special  CBF90058-CBF90059  embl_tpa_prot",
    "special  CBF90061           embl_tpa_prot",
    "special  CBF90063           embl_tpa_prot",
    "special  CBF90065-CBF90066  embl_tpa_prot",
    "special  CBF90068           embl_tpa_prot",
    "special  CBF90070           embl_tpa_prot",
    "special  CBF90072           embl_tpa_prot",
    "special  CBF90074-CBF90075  embl_tpa_prot",
    "special  CBF90077           embl_tpa_prot",
    "special  CBF90079           embl_tpa_prot",
    "special  CBF90081           embl_tpa_prot",
    "special  CBF90083           embl_tpa_prot",
    "special  CBF90085           embl_tpa_prot",
    "special  CBF90087-CBF90088  embl_tpa_prot",
    "special  CBF90090           embl_tpa_prot",
    "special  CBF90092           embl_tpa_prot",
    "special  CBF90094-CBF90095  embl_tpa_prot",
    "special  CBF90097           embl_tpa_prot",
    "special  CBF90099           embl_tpa_prot",
    "special  CBF90101           embl_tpa_prot",
    "special  CBF90103           embl_tpa_prot",
    "special  CBF90105           embl_tpa_prot",
    "special  CBF90107           embl_tpa_prot",
    "special  CBF90109           embl_tpa_prot",
    "special  CBF90111-CBF90112  embl_tpa_prot",
    "special  CBF90114           embl_tpa_prot",
    "special  CBF90116           embl_tpa_prot",
    "special  CBF90118-CBF90119  embl_tpa_prot",
    "special  CBF90121           embl_tpa_prot",
    "special  CBF90123           embl_tpa_prot",
    "special  CBF90125           embl_tpa_prot",
    "special  CBF90127           embl_tpa_prot",
    "special  CBF90129-CBF90130  embl_tpa_prot",
    "special  CBF90132           embl_tpa_prot",
    "special  CBF90134-CBF90135  embl_tpa_prot",
    "special  CBF90137           embl_tpa_prot",
    "special  CBF90139           embl_tpa_prot",
    "special  CBF90141           embl_tpa_prot",
    "special  CBF90143           embl_tpa_prot",
    "special  CBF90145           embl_tpa_prot",
    "special  CBF90147-CBF90148  embl_tpa_prot",
    "special  CBF90150           embl_tpa_prot",
    "special  CBF90152           embl_tpa_prot",
    "special  CBF90154           embl_tpa_prot",
    "special  CBF90156-CBF90157  embl_tpa_prot",
    "special  CBF90159           embl_tpa_prot",
    "special  CBF90161           embl_tpa_prot",
    "special  CBF90163           embl_tpa_prot",
    "special  CBF90165           embl_tpa_prot",
    "special  CBF90167           embl_tpa_prot",
    "special  CBF90169           embl_tpa_prot",
    "special  CBF90171-CBF90172  embl_tpa_prot",
    "special  CBF90174-CBF90175  embl_tpa_prot",
    "special  CBF90177           embl_tpa_prot",
    "special  CBF90179           embl_tpa_prot",
    "special  CBF90181           embl_tpa_prot",
    "special  CBF90183           embl_tpa_prot",
    "special  CBF90185-CBF90186  embl_tpa_prot",
    "special  CBF90188           embl_tpa_prot",
    "special  CBF90190           embl_tpa_prot",
    "special  CBF90192           embl_tpa_prot",
    "special  CBF90194           embl_tpa_prot",
    "special  CBF90196-CBF90197  embl_tpa_prot",
    "special  CBF90199           embl_tpa_prot",
    "special  CBF90201           embl_tpa_prot",
    "special  CBF90203           embl_tpa_prot",
    "special  CBF90205-CBF90206  embl_tpa_prot",
    "special  CBF90208           embl_tpa_prot",
    "special  CBF90210           embl_tpa_prot",
    "special  CBF90212           embl_tpa_prot",
    "special  CBF90214           embl_tpa_prot",
    "special  CBF90216           embl_tpa_prot",
    "special  CBF90218           embl_tpa_prot",
    "special  CBF90220           embl_tpa_prot",
    "special  CBF90222-CBF90223  embl_tpa_prot",
    "special  CBF90225           embl_tpa_prot",
    "special  CBF90227           embl_tpa_prot",
    "special  CBF90229           embl_tpa_prot",
    "special  CBF90231-CBF90232  embl_tpa_prot",
    "special  CBF90234           embl_tpa_prot",
    "special  CBF90236           embl_tpa_prot",
    "special  CBF90238           embl_tpa_prot",
    "special  CBF90240-CBF90241  embl_tpa_prot",
    "special  CBF90243           embl_tpa_prot",
    "special  CBF90245           embl_tpa_prot",
    "special  CBF90247-CBF90248  embl_tpa_prot",
    "special  CBF90250           embl_tpa_prot",
    "special  CBF90252           embl_tpa_prot",
    "special  CBF90254           embl_tpa_prot",
    "special  CBF90256           embl_tpa_prot",
    "special  CBF90258           embl_tpa_prot",
    "special  CBF90260           embl_tpa_prot",
    "special  CBF90262           embl_tpa_prot",
    "special  CBF90264           embl_tpa_prot",
    "special  CBF90266-CBF90267  embl_tpa_prot",
    "special  CBF90269           embl_tpa_prot",
    "special  CBF90271           embl_tpa_prot",
    "special  CBF90273           embl_tpa_prot",
    "special  CBF90275           embl_tpa_prot",
    "special  CBF90277           embl_tpa_prot",
    "special  CBF90279           embl_tpa_prot",
    "special  CBF90281-CBF90282  embl_tpa_prot",
    "special  CBF90284           embl_tpa_prot",
    "special  CBF90286           embl_tpa_prot",
    "special  CBF90288           embl_tpa_prot",
    "special  CBF90290           embl_tpa_prot",
    "special  CBF90292           embl_tpa_prot",
    "special  CBF90294           embl_tpa_prot",
    "special  CBF90296           embl_tpa_prot",
    "special  CBF90298-CBF90299  embl_tpa_prot",
    "special  CBF90301           embl_tpa_prot",
    "special  CBF90303           embl_tpa_prot",
    "special  CBF90305-CBF90306  embl_tpa_prot",
    "special  CBF90308           embl_tpa_prot",
    "special  CBF90310-CBF90311  embl_tpa_prot",
    "special  CBF90313           embl_tpa_prot",
    "special  CBF90315           embl_tpa_prot",
    "special  CBF90317           embl_tpa_prot",
    "special  CBF90319-CBF90320  embl_tpa_prot",
    "special  CBF90322           embl_tpa_prot",
    "special  CBF90324           embl_tpa_prot",
    "special  CBF90326           embl_tpa_prot",
    "special  CBF90328-CBF90329  embl_tpa_prot",
    "special  CBF90331           embl_tpa_prot",
    "special  CBF90333           embl_tpa_prot",
    "special  CBF90335           embl_tpa_prot",
    "special  CBF90337           embl_tpa_prot",
    "special  CBF90339           embl_tpa_prot",
    "special  CBF90341-CBF90342  embl_tpa_prot",
    "special  CBF90344           embl_tpa_prot",
    "special  CBF90346           embl_tpa_prot",
    "special  CBF90348           embl_tpa_prot",
    "special  CBF90350           embl_tpa_prot",
    "special  CBF90352           embl_tpa_prot",
    "special  CBF90354           embl_tpa_prot",
    "special  CBF90356           embl_tpa_prot",
    "special  CBF90358-CBF90359  embl_tpa_prot",
    "special  CBF90361           embl_tpa_prot",
    "special  CBF90363           embl_tpa_prot",
    "special  CBF90365-CBF90366  embl_tpa_prot",
    "special  CBF90370           embl_tpa_prot",
    "special  CBF90372           embl_tpa_prot",
    "special  CBF90374           embl_tpa_prot",
    "special  CBF90376           embl_tpa_prot",
    "special  CBF90378           embl_tpa_prot",
    "special  CBF90380           embl_tpa_prot",
    "special  CBF90384-CBF90385  embl_tpa_prot",
    "special  CBF90391           embl_tpa_prot",
    "special  CBF90396-CBF90397  embl_tpa_prot",
    "special  CBF90399           embl_tpa_prot",
    "special  CBF90401           embl_tpa_prot",
    "special  CBF90404           embl_tpa_prot",
    "special  CBK25604           embl_tpa_prot",
    "special  CBL43266-CBL43309  embl_tpa_prot",
    "special  CBL43311-CBL43352  embl_tpa_prot",
    "special  CBL43354-CBL43394  embl_tpa_prot",
    "special  CBL51956           embl_tpa_prot",
    "special  CBL79138           embl_tpa_prot",
    "special  CBL80808-CBL80809  embl_tpa_prot",
    "special  CBM43246           embl_tpa_prot",
    "special  CBN66325           embl_tpa_prot",
    "special  CBN69342           embl_tpa_prot",
    "special  CBN69349           embl_tpa_prot",
    "special  CBV36767-CBV36776  embl_tpa_prot",
    "special  CBX19677-CBX19679  embl_tpa_prot",
    "special  CBX19727-CBX19728  embl_tpa_prot",
    "special  CBX24371-CBX24373  embl_tpa_prot",
    "special  CBY65974-CBY66037  embl_tpa_prot",
    "special  CBY83944           embl_tpa_prot",
    "special  CBZ41152-CBZ41156  embl_tpa_prot",
    "special  CBZ41159-CBZ41160  embl_tpa_prot",
    "special  CBZ41162           embl_tpa_prot",
    "special  CBZ41165           embl_tpa_prot",
    "special  CBZ41168           embl_tpa_prot",
    "special  CBZ41768           embl_tpa_prot",
    "special  CCB84813           embl_tpa_prot",
    "special  CCC21095-CCC21104  embl_tpa_prot",
    "special  CCD22089-CCD22162  embl_tpa_prot",
    "special  CCE69367-CCE71257  embl_tpa_prot",
    "special  CCH35981-CCH35984  embl_tpa_prot",
    "special  CCP37863-CCP38020  embl_tpa_prot",
    "special  CCQ18550           embl_tpa_prot",
    "special  CDG31911-CDG32165  embl_tpa_prot",
    "special  CDG58552           embl_tpa_prot",
    "special  CDG80630-CDG80632  embl_tpa_prot",
    "special  CDG86183-CDG86301  embl_tpa_prot",
    "special  CDI30255-CDI40096  embl_tpa_prot",
    "special  CDI70255-CDI70287  embl_tpa_prot",
    "special  CDI70965-CDI70967  embl_tpa_prot",
    "special  CDK02602-CDK08087  embl_tpa_prot",
    "special  CDK08089-CDK12444  embl_tpa_prot",
    "special  CDM98735-CDM98850  embl_tpa_prot",
    "special  CDW51382-CDW51481  embl_tpa_prot",
    "special  CEL64082-CEL71605  embl_tpa_prot",
    "special  CEL71607-CEL73228  embl_tpa_prot",
    "special  CEL73230-CEL73266  embl_tpa_prot",
    "special  CEL73268-CEL74800  embl_tpa_prot",
    "special  CEL74802-CEL75130  embl_tpa_prot",
    "special  CEL75132-CEL75550  embl_tpa_prot",
    "special  CEL75552-CEL76203  embl_tpa_prot",
    "special  CEL76205-CEL76766  embl_tpa_prot",
    "special  CEL76768-CEL77188  embl_tpa_prot",
    "special  CEL77190-CEL78176  embl_tpa_prot",
    "special  CEL78178-CEL78353  embl_tpa_prot",
    "special  CEL78355-CEL78878  embl_tpa_prot",
    "special  CEO43666-CEO43667  embl_tpa_prot",
    "special  CRI06393-CRI06404  embl_tpa_prot",
    "special  CRK77046           embl_tpa_prot",
    "special  CTQ86077-CTQ86287  embl_tpa_prot",
    "special  CUQ99285-CUQ99292  embl_tpa_prot",
    "special  CUQ99294-CUQ99311  embl_tpa_prot",
    "special  CUQ99313-CUQ99319  embl_tpa_prot",
    "special  CUQ99321-CUQ99350  embl_tpa_prot",
    "special  CUQ99352-CUQ99386  embl_tpa_prot",
    "special  CUS27851-CUS27862  embl_tpa_prot",
    "special  CUS58523-CUS58613  embl_tpa_prot",
    "",
    "special  SAI82130-SAI82138  embl_tpa_prot",
    "special  SAI82141           embl_tpa_prot",
    "special  SAI82144-SAI82145  embl_tpa_prot",
    "special  SAI82147-SAI82149  embl_tpa_prot",
    "special  SAI82151-SAI82165  embl_tpa_prot",
    "special  SAI82168-SAI82180  embl_tpa_prot",
    "special  SAI82182-SAI82186  embl_tpa_prot",
    "special  SAI82188-SAI82198  embl_tpa_prot",
    "special  SAI82201-SAI82210  embl_tpa_prot",
    "special  SAI82212-SAI82222  embl_tpa_prot",
    "special  SAI82224-SAI82225  embl_tpa_prot",
    "special  SAI82227-SAI82235  embl_tpa_prot",
    "special  SAI82237-SAI82242  embl_tpa_prot",
    "special  SAI82244-SAI82255  embl_tpa_prot",
    "special  SAI82257-SAI82282  embl_tpa_prot",
    "special  SAI82284-SAI82285  embl_tpa_prot",
    "special  SAI82287           embl_tpa_prot",
    "special  SAI82289           embl_tpa_prot",
    "special  SAI82292           embl_tpa_prot",
    "special  SAI82294-SAI82296  embl_tpa_prot",
    "special  SAI82298-SAI82303  embl_tpa_prot",
    "special  SAQ69746-SAQ69766  embl_tpa_prot",
    "special  SAQ71209           embl_tpa_prot",
    "special  SCC98881-SCC98885  embl_tpa_prot",
    "special  SFW93197-SFW93317  embl_tpa_prot",
    "special  SNU76807-SNU78093  embl_tpa_prot",
    "special  SOR70182-SOR70392  embl_tpa_prot",
    "## Err on the side of caution on as yet unassigned IDs, and hope that",
    "## there's not *too* much more backfilling.",
    "#special SZF06859-SZZ99999  unreserved_prot"
};
