/*  $Id: wx_main_frame.cpp 43123 2019-05-16 18:41:46Z katargir $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Authors:  Andrey Yazhuk
 *
 */

#include <ncbi_pch.hpp>

// Generated by DialogBlocks (unregistered), 23/04/2007 14:31:59


#include <wx/accel.h>
#include <wx/artprov.h>
#include <wx/imaglist.h>
#include <wx/menu.h>
#include <wx/msgdlg.h>
#include <wx/log.h>
#include <wx/notebook.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/gauge.h>

////@begin includes
////@end includes

#include <gui/wx_demo/wx_main_frame.hpp>
#include <gui/wx_demo/test_table.hpp>

#include <gui/widgets/wx/fileartprov.hpp>
#include <gui/widgets/wx/wx_utils.hpp>
#include <gui/widgets/wx/app_status_bar.hpp>
#include <gui/widgets/wx/map_control.hpp>
#include <gui/widgets/wx/map_item.hpp>

#include <gui/widgets/wx/group_map_widget.hpp>

#include <gui/framework/diag_panel.hpp>

#include <gui/widgets/wx/sys_path.hpp>

#include <gui/wx_demo/about_dlg.hpp>

BEGIN_NCBI_SCOPE

#define ID_LAUNCH_JOBS          10101
#define ID_CHECK_JOBS_STATUS    10101
#define ID_CHECK_JOBS_PROGRESS  10101
#define ID_CANCEL_JOBS          10101   
    
////@begin XPM images
////@end XPM images


IMPLEMENT_CLASS( CwxMainFrame, wxFrame )

BEGIN_EVENT_TABLE( CwxMainFrame, wxFrame )

////@begin CwxMainFrame event table entries
    EVT_CLOSE( CwxMainFrame::OnCloseWindow )

    EVT_MENU( wxID_EXIT, CwxMainFrame::OnEXITClick )

    EVT_MENU( ID_TEST_MSG_BOXES, CwxMainFrame::OnTestMsgBoxesClick )

    EVT_MENU( ID_POST_EVENTS, CwxMainFrame::OnPostEventsClick )

    EVT_MENU( ID_MENUITEM1, CwxMainFrame::OnGoToSequence )

    EVT_MENU( ID_TEST_DIAG_PANEL, CwxMainFrame::OnTestDiagPanelClick )
    EVT_UPDATE_UI( ID_TEST_DIAG_PANEL, CwxMainFrame::OnTestDiagPanelUpdate )

    EVT_MENU( ID_CREATE_MAP_CONTROL, CwxMainFrame::OnCreateMapControlClick )

    EVT_MENU( ID_CREATE_GROUP_MAP_WIDGET, CwxMainFrame::OnCreateGroupMapWidgetClick )

    EVT_MENU( ID_CREATE_TABLE_CONTROL, CwxMainFrame::OnCreateTableControlClick )

    EVT_MENU( wxID_ABOUT, CwxMainFrame::OnABOUTClick )

////@end CwxMainFrame event table entries
    EVT_SEQ_GOTO( wxID_ANY, CwxMainFrame::OnSeqGoto )
    EVT_SEQ_GOTO_CLOSE( wxID_ANY, CwxMainFrame::OnSeqGotoClose )
END_EVENT_TABLE()


class CTestEvent : public CEvent
{
public:
    string m_Str;

    CTestEvent(const string& name)
        : CEvent(eEvent_Message, 0, NULL), m_Str(name)   {}
};

BEGIN_EVENT_MAP(CwxMainFrame, CEventHandler)
    ON_EVENT(CTestEvent, 0, &CwxMainFrame::OnTestEvent)
END_EVENT_MAP()


CwxMainFrame::CwxMainFrame()
:   m_SequenceGotoDlg()
{
    Init();
}


CwxMainFrame::CwxMainFrame( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
:   m_SequenceGotoDlg()
{
    Init();
    Create( parent, id, caption, pos, size, style );
}


bool CwxMainFrame::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
    wxFrame::Create( parent, id, caption, pos, size, style );

    CreateControls();
    Centre();
    return true;
}


CwxMainFrame::~CwxMainFrame()
{
////@begin CwxMainFrame destruction
////@end CwxMainFrame destruction
}


void CwxMainFrame::Init()
{
    m_MapControl = NULL;
    m_ItemsCounter = 0;
    m_TableControl = NULL;

////@begin CwxMainFrame member initialisation
    m_DiagnosticsTesting = false;
    m_GroupMapWidget = NULL;
////@end CwxMainFrame member initialisation

    m_PrimeClient.reset(new CPrimeNumberClient(CAppJobDispatcher::GetInstance()));
}


static wxAcceleratorEntry entries[3];

void CwxMainFrame::CreateControls()
{
    x_RegisterAliases();

////@begin CwxMainFrame content construction
    CwxMainFrame* itemFrame1 = this;

    wxMenuBar* menuBar = new wxMenuBar;
    wxMenu* itemMenu3 = new wxMenu;
    itemMenu3->AppendSeparator();
    itemMenu3->Append(wxID_EXIT, _("E&xit\tAlt+X"), wxEmptyString, wxITEM_NORMAL);
    menuBar->Append(itemMenu3, _("File"));
    wxMenu* itemMenu6 = new wxMenu;
    itemMenu6->Append(wxID_CUT, _("Cu&t"), wxEmptyString, wxITEM_NORMAL);
    itemMenu6->Append(wxID_COPY, _("&Copy"), wxEmptyString, wxITEM_NORMAL);
    itemMenu6->Append(wxID_PASTE, _("&Paste"), wxEmptyString, wxITEM_NORMAL);
    itemMenu6->AppendSeparator();
    itemMenu6->Append(wxID_SELECTALL, _("Select All"), wxEmptyString, wxITEM_NORMAL);
    menuBar->Append(itemMenu6, _("Edit"));
    wxMenu* itemMenu12 = new wxMenu;
    itemMenu12->Append(ID_TEST_MSG_BOXES, _("Message Boxes"), wxEmptyString, wxITEM_NORMAL);
    itemMenu12->Append(ID_POST_EVENTS, _("Post Events"), wxEmptyString, wxITEM_NORMAL);
    itemMenu12->Append(ID_MENUITEM1, _("Go to sequence"), wxEmptyString, wxITEM_NORMAL);
    itemMenu12->Append(ID_TEST_DIAG_PANEL, _("Test Diagnostics Console"), wxEmptyString, wxITEM_NORMAL);
    menuBar->Append(itemMenu12, _("Test"));
    wxMenu* itemMenu17 = new wxMenu;
    itemMenu17->Append(ID_CREATE_MAP_CONTROL, _("Create Map Control\tF1"), wxEmptyString, wxITEM_NORMAL);
    itemMenu17->Append(ID_CREATE_GROUP_MAP_WIDGET, _("Create Group Map Widget\tF2"), wxEmptyString, wxITEM_NORMAL);
    itemMenu17->Append(ID_CREATE_TABLE_CONTROL, _("Create Table Control\tF3"), wxEmptyString, wxITEM_NORMAL);
    menuBar->Append(itemMenu17, _("Test Controls"));
    wxMenu* itemMenu21 = new wxMenu;
    {
        wxMenuItem* menuItem = new wxMenuItem(itemMenu21, wxID_ABOUT, _("About"), wxEmptyString, wxITEM_NORMAL);
        wxBitmap bitmap(itemFrame1->GetBitmapResource(wxT("menu::about")));
        menuItem->SetBitmap(bitmap);
        itemMenu21->Append(menuItem);
    }
    menuBar->Append(itemMenu21, _("Help"));
    itemFrame1->SetMenuBar(menuBar);

    CStatusBar* itemStatusBar23 = new CStatusBar( itemFrame1, ID_STATUSBAR1, wxST_SIZEGRIP|wxNO_BORDER );
    itemStatusBar23->SetFieldsCount(5);
    itemFrame1->SetStatusBar(itemStatusBar23);

////@end CwxMainFrame content construction

    // insert submenu
    wxMenu* open_sub_menu = new wxMenu;
    open_sub_menu->Append(ID_OPEN_DATA, _("&Data"), wxEmptyString, wxITEM_NORMAL);
    open_sub_menu->Append(ID_OPEN_PROJECT, _("&Project"), wxEmptyString, wxITEM_NORMAL);
    open_sub_menu->Append(ID_OPEN_WORKSPACE, _("&Workspace"), wxEmptyString, wxITEM_NORMAL);

    itemMenu3->Insert(0, ID_MENU_OPEN, _("&Open"), open_sub_menu);

    // add App Job Dispatcher menu
    wxMenu* itemMenuApp = new wxMenu;
    itemMenuApp->Append(ID_LAUNCH_JOBS, _("Launch Jobs"), wxEmptyString, wxITEM_NORMAL);
    itemMenuApp->Append(ID_CHECK_JOBS_STATUS, _("Check Status"), wxEmptyString, wxITEM_NORMAL);
    itemMenuApp->Append(ID_CHECK_JOBS_PROGRESS, _("Check Progress"), wxEmptyString, wxITEM_NORMAL);
    itemMenuApp->Append(ID_CANCEL_JOBS, _("Cancel Jobs"), wxEmptyString, wxITEM_NORMAL);
    menuBar->Append(itemMenuApp, _("App Jobs Test"));

    // init Accelerators
    entries[0].Set(wxACCEL_CTRL, (int) 'X', wxID_CUT);
    entries[1].Set(wxACCEL_CTRL, (int) 'C', wxID_COPY);
    entries[2].Set(wxACCEL_CTRL, (int) 'V', wxID_PASTE);

    wxAcceleratorTable s_accel(3, entries);

    SetAcceleratorTable(s_accel);

    x_SetupStatusBar();

    m_Notebook = new wxNotebook(this, wxID_ANY);
}


void CwxMainFrame::x_SetupStatusBar()
{
    CStatusBar* bar = dynamic_cast<CStatusBar*>(GetStatusBar());

    int w[6] = { -4, 50, 50, -1, 50, 20 };
    bar->SetFieldsCount(6, w);

    bar->SetFieldWindow(1, new wxButton(this, wxID_OK, _("Yes")));
    bar->SetFieldWindow(2, new wxButton(this, wxID_OK, _("No")));
    bar->SetFieldWindow(3, new wxStaticText(this, wxID_ANY, _("Status Text")) );

    wxGauge* gauge =  new wxGauge(this, wxID_ANY, 100);
    gauge->SetValue(50);
    bar->SetFieldWindow(4, gauge);

    bar->Layout();
}


void CwxMainFrame::x_RegisterAliases()
{
    wxFileArtProvider* art_prov = new wxFileArtProvider();
    wxString dir = CSysPath::ResolvePath(wxT("<res>"));
    art_prov->AddDirectory(dir);

    // TODO this should be moved to window manager later
    art_prov->RegisterFileAlias(wxT("wm_menu"), wxT("wm_menu.png"));
    art_prov->RegisterFileAlias(wxT("wm_menu_active"), wxT("wm_menu_active.png"));
    art_prov->RegisterFileAlias(wxT("wm_close"), wxT("wm_close.png"));
    art_prov->RegisterFileAlias(wxT("wm_close_active"), wxT("wm_close_active.png"));

    art_prov->RegisterFileAlias(wxT("about"), wxT("about.png"));
    art_prov->RegisterFileAlias(wxT("search"), wxT("search.png"));
    art_prov->RegisterFileAlias(wxT("zoom_in"), wxT("zoom_in.png"));
    art_prov->RegisterFileAlias(wxT("zoom_out"), wxT("zoom_out.png"));
    art_prov->RegisterFileAlias(wxT("zoom_all"), wxT("zoom_all.png"));

    art_prov->RegisterFileAlias(wxT("menu"), wxT("wm_menu.png"));
    art_prov->RegisterFileAlias(wxT("minimize"), wxT("wm_minimize.png"));
    art_prov->RegisterFileAlias(wxT("restore"), wxT("wm_restore.png"));
    art_prov->RegisterFileAlias(wxT("maximize"), wxT("wm_maximize.png"));
    art_prov->RegisterFileAlias(wxT("close"), wxT("wm_close.png"));

    art_prov->RegisterFileAlias(wxT("map::arrow_open"),  wxT("arrow_open.png"));
    art_prov->RegisterFileAlias(wxT("map::arrow_close"), wxT("arrow_close.png"));

    wxArtProvider::Push(art_prov);
    wxArtProvider::Push(new CwxSplittingArtProvider());
}


bool CwxMainFrame::ShowToolTips()
{
    return true;
}

wxBitmap CwxMainFrame::GetBitmapResource( const wxString& name )
{
    return wxArtProvider::GetBitmap( name );
}

wxIcon CwxMainFrame::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin CwxMainFrame icon retrieval
    wxUnusedVar(name);
    return wxNullIcon;
////@end CwxMainFrame icon retrieval
}


void CwxMainFrame::OnABOUTClick( wxCommandEvent& event )
{
    CwxAboutDlg dlg(this);
    dlg.ShowModal();
}


void CwxMainFrame::OnEXITClick( wxCommandEvent& event )
{
    wxFrame::Close(true);
}

void CwxMainFrame::OnTestMsgBoxesClick( wxCommandEvent& event )
{
    wxMessageDialog dlg(NULL, _("Yes No Cancel dialog."), _("Question"),
                        wxYES_NO | wxCANCEL | wxICON_QUESTION);
    dlg.ShowModal();

    wxMessageDialog dlg_2(NULL, _("Ok Cancel dialog."), _("Error"),
                          wxOK | wxCANCEL | wxICON_ERROR);
    dlg_2.ShowModal();
}


void CwxMainFrame::OnPostEventsClick( wxCommandEvent& event )
{
    //LOG_POST("");
    static int n = 0;

    for( int i = 0; i < 10 ; i++) {
        string s = "Event #" + NStr::IntToString(++n);
        CRef<CEvent> evt(new CTestEvent(s));
        Post(evt);
        LOG_POST("Sent - " << s);
    }
}


void CwxMainFrame::OnTestEvent(CEvent* evt)
{
    CTestEvent* test_evt = dynamic_cast<CTestEvent*>(evt);
    LOG_POST("Recived - " + test_evt->m_Str);
}


void CwxMainFrame::OnLaunchJobs( wxCommandEvent& event )
{
    m_PrimeClient->StartJobs(10);
}


void CwxMainFrame::OnCancelJobs( wxCommandEvent& event )
{
    m_PrimeClient->CancelJobs();
}


void CwxMainFrame::OnCheckJobsStatus( wxCommandEvent& event )
{
    m_PrimeClient->CheckStatus();
}


void CwxMainFrame::OnCheckJobsProgress( wxCommandEvent& event )
{
    m_PrimeClient->CheckProgress();
}




void CwxMainFrame::OnGoToSequence( wxCommandEvent& event )
{
    if (m_SequenceGotoDlg == 0) {
        m_SequenceGotoDlg = new CSequenceGotoDlg(this, &m_SequenceGotoData);
        m_SequenceGotoDlg->Show(true);
    }
}


void CwxMainFrame::OnSeqGoto( CSequenceGotoEvent& event )
{
    long from, to;
    m_SequenceGotoData.GetRange(from, to);

    wxString msg;
    msg.Printf(_("Range:\nFrom:\t%ld\nTo:\t%ld"), from, to);
    wxMessageBox(msg, _("Goto"),wxOK | wxICON_EXCLAMATION, this);
}


void CwxMainFrame::OnSeqGotoClose( CSequenceGotoEvent& event )
{
    m_SequenceGotoDlg->Destroy();
    m_SequenceGotoDlg = NULL;
}


void CwxMainFrame::OnCloseWindow( wxCloseEvent& event )
{
    if( m_TableControl ){
        CGuiRegistry& reg = CGuiRegistry::GetInstance();
        CRegistryWriteView reg_view = reg.GetWriteView("TestTable");

        m_TableControl->SaveTableSettings(reg_view);
    }

    event.Skip();
}


void CwxMainFrame::OnTestDiagPanelClick( wxCommandEvent& event )
{
    event.Skip();
}


void CwxMainFrame::OnTestDiagPanelUpdate( wxUpdateUIEvent& event )
{
    event.Enable(true);
}


void CwxMainFrame::OnCreateMapControlClick( wxCommandEvent& event )
{
    _ASSERT(m_Notebook);

    m_MapControl = new CMapControl(m_Notebook);
	m_MapControl->GetProperties().m_SingleColumn = true;

    OnCreateMapControlItems();
    m_Notebook->AddPage(m_MapControl, _("Map Control"));
    m_Notebook->SetSelection(m_Notebook->GetPageCount() - 1);
}

void CwxMainFrame::OnCreateMapControlItems()
{
    _ASSERT(m_MapControl);
    m_MapControl->LockUpdates(true);

    m_MapControl->DeleteAllItems();
    m_ItemsCounter = 0;

    for( int i = 0; i < 20; i++)    {
        x_CreateNextItem();
    }

    m_MapControl->LockUpdates(false);
}

void CwxMainFrame::OnCreateGroupMapWidgetClick( wxCommandEvent& event )
{
    _ASSERT(m_Notebook);

    m_GroupMapWidget = new CGroupMapWidget(m_Notebook, wxID_ANY);
    m_Notebook->AddPage(m_GroupMapWidget, _("Group Map Widget"));
    m_Notebook->SetSelection(m_Notebook->GetPageCount() - 1);

    m_GroupMapWidget->AddGroup("Recent");
    m_GroupMapWidget->AddGroup("Sequence");
    m_GroupMapWidget->AddGroup("Alignment");
    m_GroupMapWidget->AddGroup("General");
    m_GroupMapWidget->AddGroup("Proteus");

    m_GroupMapWidget->AddItem("Recent", "Graphical View", "menu::zoom_in", NcbiEmptyString, false);
    m_GroupMapWidget->AddItem("Recent", "Feature Table View", "map::arrow_open", NcbiEmptyString, false);
    m_GroupMapWidget->AddItem("Recent", "Multiple Sequence Alignment View", "map::arrow_close", NcbiEmptyString, false);
    m_GroupMapWidget->AddItem("Recent", "Cross Alignment View", "menu::zoom_in", NcbiEmptyString, false);

    m_GroupMapWidget->AddItem("Sequence", "Graphical View", "menu::zoom_in", NcbiEmptyString, false);
    m_GroupMapWidget->AddItem("Sequence", "Feature Table View", "menu::zoom_in", NcbiEmptyString, false);

    m_GroupMapWidget->AddItem("Alignment", "Multiple Sequence Alignment View", "menu::zoom_in", NcbiEmptyString, false);
    m_GroupMapWidget->AddItem("Alignment", "Cross Alignment View", "menu::zoom_in", NcbiEmptyString, false);
    m_GroupMapWidget->AddItem("Alignment", "Alignment Span View", "menu::zoom_in", NcbiEmptyString, false);

}

void CwxMainFrame::OnCreateTableControlClick( wxCommandEvent& event )
{
    _ASSERT(m_Notebook);

    m_TableControl = new CwxTableListCtrl( m_Notebook );
    OnCreateTableControlItems();

    m_Notebook->AddPage( m_TableControl, _("Table Control") );
    m_Notebook->SetSelection( m_Notebook->GetPageCount() - 1 );
}

void CwxMainFrame::OnCreateTableControlItems()
{
    _ASSERT(m_TableControl);

    m_TableControl->SetModel( new CProteinModel(), true );

    CGuiRegistry& reg = CGuiRegistry::GetInstance();
    CRegistryReadView reg_view = reg.GetReadView("TestTable");

    m_TableControl->LoadTableSettings(reg_view, true);
}

void CwxMainFrame::x_CreateNextItem()
{
    string label, icon, descr;

    switch(m_ItemsCounter)  {
    case 0:
        label = "The First Item";
        icon = "menu::zoom_in";
        break;
    case 1:
        label = "The Second Item - with a description";
        icon = "map::arrow_open";
        break;
    case 2:
        label = "The Third Item - with a description that is much longer";
        icon = "menu::arrow_close";
        break;
    default:
        label = "Item # ";
        label += NStr::IntToString(m_ItemsCounter);
        icon = "menu::about";

        descr = "Description is";
        for( int i = 0; i < m_ItemsCounter; i++ )   {
            descr += " long";
        }
        break;
    }

    wxBitmap bmpIcon = GetBitmapResource(icon);
    CMapItem* item = new CMapItem(label, bmpIcon, descr);
    m_MapControl->AddItem(item);
    m_ItemsCounter++;
}


END_NCBI_SCOPE



