/*  $Id: json_version_info.cpp 45359 2020-07-14 14:09:56Z evgeniev $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *   Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Vladislav Evgeniev
 *
 * File Description: CCgiVersionInfo implementatoin
 *
 */

#include <ncbi_pch.hpp>
#include <sstream>
#include <corelib/ncbi_system.hpp>
#include <corelib/ncbireg.hpp>
#include <corelib/ncbiapp.hpp>
#include <corelib/ncbistre.hpp>
#include <cgi/cgi_exception.hpp>

#include <gui/objutils/json_version_info.hpp>

using namespace std;

BEGIN_NCBI_SCOPE

bool ReportJSONVersion(const CCgiRequest& request, CCgiResponse& response)
{
    string ver_type;
    bool found = false;
    ver_type = request.GetEntry("version", &found);
    if (!found)
        return false;

    bool hasCallback = !request.GetEntry("callback").empty();

    CNcbiOstream &out = response.out();

    if (hasCallback)
        response.SetContentType("text/javascript");
    else
        response.SetContentType("text/plain");

    response.WriteHeader();

    const auto app = CNcbiApplication::Instance();
    if (ver_type.empty() || ver_type == "short") {
        out << app->GetFullVersion().PrintJson(kEmptyStr, CVersion::fVersionInfo);
    }
    else if (ver_type == "full") {
        out << app->GetFullVersion().PrintJson(app->GetAppName());
    }
    else {
        NCBI_THROW(CCgiRequestException, eEntry,
                   "Unsupported ncbi_version argument value");
    }

    return true;
}

void TestDelay(const CCgiRequest& request)
{
    try {
        if (request.GetEntry("delaytest").empty())
            return;

        const CNcbiRegistry& reg(CNcbiApplication::Instance()->GetConfig());

        // get whether delay is allowed
        int max_delaytest = reg.GetInt("debug", "max_delaytest", 0);

        if (max_delaytest == 0)
            return;
    
        int delay_sec = NStr::StringToInt(request.GetEntry("delaytest"));

        SleepSec(delay_sec < max_delaytest ? delay_sec : max_delaytest);
    }
    catch(...) {
        // Ignore the potential numeric conversion exceptions, just don't do a delay
    }
}

END_NCBI_SCOPE
