/* $Id: gbench_svc_cli.cpp 35790 2016-06-23 21:02:31Z kuznets $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'gbench_svc.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <gui/objects/gbench_svc_cli.hpp>
#include <gui/objects/GBenchFeedbackRequest.hpp>
#include <gui/objects/GBenchFeedbackAttachment.hpp>
#include <gui/objects/GBenchInitRequest.hpp>
#include <gui/objects/GBenchInitReply.hpp>

#include <objects/general/Date.hpp>
#include <objects/general/User_object.hpp>
#include <objects/general/Object_id.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

static const STimeout s_DefaultTimeout = {10, 0};

// constructor
CGBenchService::CGBenchService(void)
{
	SetTimeout( &s_DefaultTimeout );
}

// destructor
CGBenchService::~CGBenchService(void)
{
}

CRef<CUser_object> CGBenchService::SendAppStart( const CGBenchVersionInfo& version )
{
	m_Timer.Start();

	string gbenchVersion, osVersion, buildDate;
    version.GetVersionString(&gbenchVersion);
    version.GetOsString(&osVersion);

    if (version.IsSetBuild_date()) {
        buildDate = version.GetBuild_date().AsCTime().AsString();
    }

    CRef<CUser_object> req(new CUser_object());
    req->SetType().SetStr("app-start");
    req->AddField("gbench-version", gbenchVersion);
    req->AddField("os-version", osVersion);
	if( !buildDate.empty() ){
        req->AddField("build-date", buildDate);
	}

    return AskGeneric(*req);
}

bool CGBenchService::SendAppFinish( const CGBenchVersionInfo& version )
{
	m_Timer.Stop();

	string gbenchVersion, osVersion, buildDate;
	version.GetVersionString(&gbenchVersion);
	version.GetOsString(&osVersion);

	if (version.IsSetBuild_date()) {
		buildDate = version.GetBuild_date().AsCTime().AsString();
	}

	CRef<CUser_object> req(new CUser_object());
	req->SetType().SetStr("app-finish");
	req->AddField("gbench-version", gbenchVersion);
	req->AddField("os-version", osVersion);
	if( !buildDate.empty() ){
		req->AddField("build-date", buildDate);
	}

	req->AddField( "uptime", (int)m_Timer.Elapsed() );

	//STimeout finish_timeout = {1, 0};
	//SetTimeout( &finish_timeout );
	AskGeneric(*req);

	SetTimeout( &s_DefaultTimeout );

	return true;
}


/// send an init message with information about our client
CRef<CGBenchInitReply>
CGBenchService::SendInit(const CGBenchVersionInfo& version)
{
    CGBenchInitRequest req;
    req.SetVersion().Assign(version);
    return AskInit(req);
}


void CGBenchService::SendFeedbackReport(const string& msg,
                                        const string& email_addr,
                                        const CGBenchVersionInfo& version,
                                        CNcbiIstream* app_log_istr,
                                        CNcbiIstream* sys_config_istr)
{
    ///
    /// format our feedback report
    ///
    CGBenchFeedbackRequest req;

    req.SetVersion().Assign(version);
    req.SetEmail_addr(email_addr);
    req.EncodeDesc(msg);

    if (app_log_istr) {
        req.EncodeApp_log(*app_log_istr);
    }

    if (sys_config_istr) {
        req.EncodeSys_config(*sys_config_istr);
    }

    ///
    /// send the report
    ///
    TReply reply;
    AskFeedback(req, &reply);
    LOG_POST(Info << "feedback sent");
}

void CGBenchService::x_Connect()
{
    string url("https://www.ncbi.nlm.nih.gov/projects/gbench/service/gbench_svc.cgi");
	//string url("http://iwebdev2/staff/voronov/gbsvc/gbench_svc.cgi");

	x_ConnectURL( url );
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 65, chars: 1900, CRC32: 786395d0 */
