/* $Id: WorkspaceFolder.cpp 30114 2014-04-09 18:11:20Z katargir $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'gui_project.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <gui/objects/WorkspaceFolder.hpp>

#include <objects/gbproj/FolderInfo.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

CAtomicCounter CWorkspaceFolder::m_IdCounter;

// destructor
CWorkspaceFolder::~CWorkspaceFolder(void)
{
}

const CGBProjectHandle* CWorkspaceFolder::GetProject(CGBProjectHandle::TId id) const
{
    if (!CanGetProjects())
        return 0;

    ITERATE (TProjects, it, GetProjects()) {
        if ((*it)->GetId() == id) {
            return *it;
        }
    }
    return 0;
}

CGBProjectHandle* CWorkspaceFolder::GetProject(CGBProjectHandle::TId id)
{
    const CGBProjectHandle* project = const_cast<const CWorkspaceFolder&>(*this).GetProject(id);
    return const_cast<CGBProjectHandle*>(project);
}

const CWorkspaceFolder* CWorkspaceFolder::FindParentFolder(CGBProjectHandle::TId id) const
{
    for (CTypeConstIterator<CWorkspaceFolder> it(*this);  it;  ++it) {
        if (it->GetProject(id)) {
            return &*it;
        }
    }
    return 0;
}

CWorkspaceFolder* CWorkspaceFolder::FindParentFolder(CGBProjectHandle::TId id)
{
    const CWorkspaceFolder* parent = const_cast<const CWorkspaceFolder&>(*this).FindParentFolder(id);
    return const_cast<CWorkspaceFolder*>(parent);
}

bool  CWorkspaceFolder::RemoveProject(CGBProjectHandle::TId id)
{
    if (CanGetProjects()) {
        TProjects& projects = SetProjects();
        NON_CONST_ITERATE (TProjects, it, projects) {
            if((*it)->GetId() == id) {
                projects.erase(it);
                return true;
            }
        }
    }
    return false;
}


/// CIdSelector finds a Project by Id
class CProjectSelector_Id : public CWorkspaceFolder::IProjectVisitor
{
public:
    CProjectSelector_Id(CGBProjectHandle::TId id)
        : m_Id(id), m_Project(NULL)  {}

    virtual bool    Visit(objects::CGBProjectHandle& project)
    {
        if(project.GetId() == m_Id)  {
            m_Project = &project;
            return false; // stop iterating
        }
        return true; // continue
    }

public:
    CGBProjectHandle::TId m_Id;
    CGBProjectHandle*   m_Project;
};


/// CFilenameSelector find a Project by its filename
class CFilenameSelector : public CWorkspaceFolder::IProjectVisitor
{
public:
    CFilenameSelector(const string& filename)
        : m_Filename(filename), m_Project(NULL)  {}

    virtual bool    Visit(objects::CGBProjectHandle& project)
    {
        if(project.GetFilename() == m_Filename)  {
            m_Project = &project;
            return false; // stop iterating
        }
        return true; // continue
    }

public:
    string m_Filename;
    CGBProjectHandle*   m_Project;
};


CGBProjectHandle* CWorkspaceFolder::FindProjectById(CGBProjectHandle::TId id,
                                                    bool recursive)
{
    CProjectSelector_Id selector(id);
    ForEachProject(selector, recursive);
    return selector.m_Project;
}


CGBProjectHandle*
    CWorkspaceFolder::FindProjectByFilename(const string& filename)
{
    CFilenameSelector selector(filename);
    ForEachProject(selector, true);
    return selector.m_Project;
}


bool CWorkspaceFolder::ForEachProject(IProjectVisitor& visitor, bool recursive)
{
    bool ok = true;

    // iterate through Projects in this Folder
    TProjects& projects = SetProjects();
    NON_CONST_ITERATE(TProjects, it, projects)    {
        CGBProjectHandle& proj = **it;
        ok = visitor.Visit(proj);
        if( ! ok)
            return false;
    }

    if(recursive)   {
        // recursively iterate through child Folders
        TFolders& folders = SetFolders();
        NON_CONST_ITERATE(TFolders, it, folders)    {
            CWorkspaceFolder& child = **it;
            ok = child.ForEachProject(visitor, true);
            if( ! ok) {
                return false;
            }
        }
    }
    return true;
}


CWorkspaceFolder* CWorkspaceFolder::FindChildFolderById(TId id, bool recursive)
{
    TFolders& folders = SetFolders();
    NON_CONST_ITERATE(TFolders, it, folders)    {
        CWorkspaceFolder& child = **it;
        if(child.GetId() == id)   {
            return &child;
        } else if(recursive)    {
            CWorkspaceFolder* res = child.FindChildFolderById(id, true);
            if(res) {
                return res;
            }
        }
    }
    return NULL; // not found
}


CWorkspaceFolder* CWorkspaceFolder::FindChildFolderByTitle(const string& title)
{
    TFolders& folders = SetFolders();
    NON_CONST_ITERATE(TFolders, it, folders)    {
        CWorkspaceFolder& child = **it;
        if(child.IsSetInfo()  &&  child.GetInfo().GetTitle() == title)   {
            return &child;
        }
    }
    return NULL; // not found
}


void CWorkspaceFolder::AddProject(CGBProjectHandle& project)
{
    CRef<CGBProjectHandle> ref(&project);
    SetProjects().push_back(ref);
}


void CWorkspaceFolder::AddChildFolder(CWorkspaceFolder& child_folder)
{
    CRef<CWorkspaceFolder> ref(&child_folder);
    TFolders& folders = SetFolders();
    folders.push_back(ref);
}


void CWorkspaceFolder::RemoveChildFolder(TId child_id)
{
    TFolders& folders = SetFolders();
    NON_CONST_ITERATE(TFolders, it, folders)    {
        CWorkspaceFolder& child = **it;
        if(child.GetId() == child_id)   {
            folders.erase(it);
            return;
        }
    }
}

CRef<CWorkspaceFolder> CWorkspaceFolder::RemoveProjectFolder(CWorkspaceFolder::TId id)
{
    for (CTypeIterator<CWorkspaceFolder> it(*this);  it;  ++it) {
        CWorkspaceFolder::TFolders& folders = it->SetFolders();
        for (CWorkspaceFolder::TFolders::iterator it2 = folders.begin(); it2 != folders.end(); ++it2) {
            if ((*it2)->GetId() == id) {
                CRef<CWorkspaceFolder> removed(*it2);
                folders.erase(it2);
                return removed;
            }
        }
    }
    return CRef<CWorkspaceFolder>();
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1754, CRC32: 47fb2b4 */
