/* $Id: PluginValue.cpp 17410 2008-07-25 20:59:32Z yazhuk $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the data definition file
 *   'plugin.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>
#include <gui/objects/plugin_exception.hpp>

// generated includes
#include <gui/objects/PluginValue.hpp>
#include <gui/objects/PluginObject.hpp>

#include <serial/typeinfo.hpp>

#include <gui/objutils/label.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::


// constructor
CPluginValue::CPluginValue(void)
{
}


CPluginValue::CPluginValue(int val)
{
    SetInteger(val);
}


CPluginValue::CPluginValue(double val)
{
    SetDouble(val);
}


CPluginValue::CPluginValue(bool val)
{
    SetBoolean(val);
}


CPluginValue::CPluginValue(const string& str)
{
    SetString(str);
}


CPluginValue::CPluginValue(const CGBProjectHandle& project)
{
    SetProject(project);
}


CPluginValue::CPluginValue(const CObject& obj,
                           const CGBProjectHandle* project,
                           const CDataHandle * dh)
{
    SetObject(obj, project, dh);
}


CPluginValue::CPluginValue(const CTypeInfo* info)
{
    SetObject(info);
}


// destructor
CPluginValue::~CPluginValue(void)
{
}


/// Print a copy of the value stored to the output stream
void CPluginValue::Print(CNcbiOstream& ostr) const
{
    switch (Which()) {
    case e_Integer:     ostr << GetInteger();   break;
    case e_Double:     ostr << GetDouble();   break;
    case e_String:     ostr << GetString();   break;
    case e_Secret_string:     ostr << string(GetSecret_string().size(), '*');   break;
    case e_Input_file:     ostr << GetInput_file();   break;
    case e_Output_file:     ostr << GetOutput_file();   break;
    case e_Boolean:     ostr << GetBoolean();   break;

    case e_Project:
    case e_DataHandle:
    case e_Object:
        {{
            const CObject*          obj    = GetObject();
            const CGBProjectHandle* handle = GetProject();
            if (obj  &&  handle) {
                string s;
                CLabel::GetLabel(*obj, &s, CLabel::eDefault, handle->GetScope());
                ostr << s;
            } else {
                ostr << "[NULL]";
            }
        }}
        break;

    default:
        ostr << "[unhandled]";
        break;
    }
}



const string& CPluginValue::SetInteger()
{
    return Tparent::SetInteger();
}


void CPluginValue::SetInteger(const string& val)
{
    Tparent::SetInteger(val);
}


void CPluginValue::SetInteger(int val)
{
    Tparent::SetInteger(NStr::IntToString(val));
}


const string& CPluginValue::SetDouble()
{
    return Tparent::SetDouble();
}


void CPluginValue::SetDouble(const string& val)
{
    Tparent::SetDouble(val);
}


void CPluginValue::SetDouble(double val)
{
    Tparent::SetDouble(NStr::DoubleToString(val));
}


const string& CPluginValue::SetBoolean()
{
    return Tparent::SetBoolean();
}


void CPluginValue::SetBoolean(const string& val)
{
    Tparent::SetBoolean(val);
}


void CPluginValue::SetBoolean(bool val)
{
    Tparent::SetBoolean(NStr::BoolToString(val));
}

void CPluginValue::SetObject(const CObject& obj, const CGBProjectHandle* project, const CDataHandle * dh)
{
    CPluginObject* obj_var = NULL;
    if (dynamic_cast<const CGBProjectHandle*>(&obj)) {
        obj_var = &Tparent::SetProject();
    } else {
        obj_var = &Tparent::SetObject();
    }
    if (obj_var) {
        obj_var->SetObject(obj, project, dh);
    }
}


void CPluginValue::SetObject(const string& type)
{
    CPluginObject& obj_var = Tparent::SetObject();
    obj_var.SetObject(type);
}


void CPluginValue::SetObject(const CTypeInfo* info)
{
    CPluginObject& obj_var = Tparent::SetObject();
    obj_var.SetObject(info);
}


void CPluginValue::SetProject(const CGBProjectHandle& project)
{
    CPluginObject& obj_var = Tparent::SetProject();
    obj_var.SetProject(&project);
}


void CPluginValue::SetProject(void)
{
    CPluginObject& obj_var = Tparent::SetProject();
    obj_var.SetProject(NULL);
}


const string& CPluginValue::GetObjectSubtype(void) const
{
    if (IsProject()) {
        return Tparent::GetProject().GetSubtype();
    } else if (IsObject()) {
        return Tparent::GetObject().GetSubtype();
    }

    return kEmptyStr;
}


bool CPluginValue::AsBoolean(void) const
{
    if ( !IsBoolean() ) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to access non-boolean value as boolean");
    }

    const string& str = GetBoolean();
    if (str.empty()) {
        return false;
    } else {
        return NStr::StringToBool(GetBoolean());
    }
}


int CPluginValue::AsInteger(void) const
{
    if ( !IsInteger() ) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to access non-integer value as integer");
    }

    if (GetInteger().empty()) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to access invalid integer value");
    }

    return NStr::StringToInt(GetInteger());
}


double CPluginValue::AsDouble(void) const
{
    if ( !IsDouble() ) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to access non-double value as double");
    }

    if (GetDouble().empty()) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to access invalid double value");
    }

    return NStr::StringToDouble(GetDouble());
}


const string& CPluginValue::AsSecretString(void) const
{
    if ( !IsSecret_string() ) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to access non-secret-string value as secret-string");
    }

    if (GetSecret_string().empty()) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to access invalid secret-string value");
    }

    return GetSecret_string();
}


const string& CPluginValue::AsString(void) const
{
    switch (Which()) {
    case e_Integer:
        _TRACE("CPluginValue::AsString(): access to integer value as string");
        return GetInteger();

    case e_Double:
        _TRACE("CPluginValue::AsString(): access to double value as string");
        return GetDouble();

    case e_Boolean:
        _TRACE("CPluginValue::AsString(): access to boolean value as string");
        return GetBoolean();

    case e_Input_file:
        _TRACE("CPluginValue::AsString(): access to input file value as string");
        return GetInput_file();

    case e_Output_file:
        _TRACE("CPluginValue::AsString(): access to output file value as string");
        return GetOutput_file();

    case e_String:
        return GetString();

    case e_Secret_string:
        return GetSecret_string();

    case e_Project:
    case e_Object:
    default:
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to access non-convertable value as string");
    }
}


const string& CPluginValue::AsInputFile(void) const
{
    if ( !IsInput_file() ) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to access non-file value as input file");
    }

    if (GetInput_file().empty()) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to access invalid input file value");
    }

    return GetInput_file();
}


const string& CPluginValue::AsOutputFile(void) const
{
    if ( !IsOutput_file() ) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to access non-file value as output file");
    }

    if (GetOutput_file().empty()) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to access invalid output file value");
    }

    return GetOutput_file();
}


const CGBProjectHandle& CPluginValue::AsProject(void) const
{
    if (IsProject()) {
        if (GetProject()) {
            return *GetProject();
        }
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to access NULL document");
    }
    NCBI_THROW(CPluginException, eInvalidArg,
               "Attempt to access non-document value as document");
}


const CObject& CPluginValue::AsObject(void) const
{
    if (IsObject()) {
        if (GetObject()) {
            return *GetObject();
        }
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to access NULL object");
    }
    NCBI_THROW(CPluginException, eInvalidArg,
               "Attempt to access non-object value as object");
}


//
// determine if this URL is empty
//
bool CPluginValue::IsEmpty(void) const
{
    switch (Which()) {
    case e_String:
        return (IsString()  &&  GetString().empty());

    case e_Secret_string:
        return (IsSecret_string()  &&  GetSecret_string().empty());

    case e_Input_file:
        return (IsInput_file()  &&  GetInput_file().empty());

    case e_Output_file:
        return (IsOutput_file()  &&  GetOutput_file().empty());

    case e_Integer:
        return (IsInteger()  &&  GetInteger().empty());

    case e_Double:
        return (IsDouble()  &&  GetDouble().empty());

    case e_Boolean:
        return (IsBoolean()  &&  GetBoolean().empty());

    case e_Object:
        return (IsObject()  &&  Tparent::GetObject().IsEmpty());

    case e_Project:
        return (IsProject()  &&  Tparent::GetProject().IsEmpty());

    default:
        // unhandled = always invalid, always empty
        return true;
    }
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 64, chars: 1864, CRC32: 5ef4a2cd */
