/* $Id: PluginReply.cpp 17410 2008-07-25 20:59:32Z yazhuk $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the data definition file
 *   'plugin.asn'.
 */

// standard includes

// generated includes
#include <ncbi_pch.hpp>
#include <gui/objects/PluginReply.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CPluginReply::~CPluginReply(void)
{
}


// add an object to this reply's raw object list
void CPluginReply::AddObject(const CObject& object, const CGBProjectHandle* project)
{
    CRef<CPluginValue> val(new CPluginValue(object, project));
    SetRaw().push_back(val);
}


// add an object to this reply's raw object list
void CPluginReply::AddObject(const CGBProjectHandle& project)
{
    CRef<CPluginValue> val(new CPluginValue(project));
    SetRaw().push_back(val);
}


void CPluginReply::AddAction(CPluginReplyAction::E_Choice choice,
                             const string& opts)
{
    CRef<CPluginReplyAction> action(new CPluginReplyAction());

    switch (choice) {
    case CPluginReplyAction::e_Create_project:
        action->SetCreate_project();
        SetAction().push_back(action);
        break;

    case CPluginReplyAction::e_Create_single_project:
        action->SetCreate_single_project();
        SetAction().push_back(action);
        break;

    case CPluginReplyAction::e_Add_to_project:
        action->SetAdd_to_project();
        SetAction().push_back(action);
        break;

    case CPluginReplyAction::e_Refresh_project:
        action->SetRefresh_project();
        SetAction().push_back(action);
        break;

    case CPluginReplyAction::e_New_view:
        action->SetNew_view(opts);
        SetAction().push_back(action);
        break;

    case CPluginReplyAction::e_Error:
        action->SetError(opts);
        SetAction().push_back(action);
        break;

    case CPluginReplyAction::e_Warning:
        action->SetWarning(opts);
        SetAction().push_back(action);
        break;

    case CPluginReplyAction::e_Info:
        action->SetInfo(opts);
        SetAction().push_back(action);
        break;

    case CPluginReplyAction::e_Store:
        action->SetStore();
        SetAction().push_back(action);
        break;

    case CPluginReplyAction::e_Plugin_cmd_run:
        action->SetPlugin_cmd_run(opts);
        SetAction().push_back(action);
        break;

    default:
        // not supported
        _ASSERT(false);
        break;
    }
}


TConstScopedObjects CPluginReply::DecomposeRaw() const
{
    TConstScopedObjects objs;

    if (IsSetRaw()) {
        ITERATE (TRaw, iter, GetRaw()) {
            const CGBProjectHandle* project = (*iter)->GetProject();
            const CObject*          obj     = (*iter)->GetObject();
            if ( !project  ||  !obj ) {
                continue;
            }

            SConstScopedObject sco;
            sco.object.Reset(obj);
            sco.scope.Reset(project->GetScope());
            objs.push_back(sco);
        }
    }

    return objs;
}

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 64, chars: 1883, CRC32: 971bc85 */
