/* $Id: PluginMessage.cpp 14666 2007-07-09 13:40:22Z dicuccio $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the data definition file
 *   'plugin.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>
#include <corelib/ncbistd.hpp>
#include <corelib/ncbiatomic.hpp>
#include <serial/enumvalues.hpp>
#include <gui/objects/PluginCommand.hpp>
#include <gui/objects/PluginRequest.hpp>
#include <gui/objects/PluginReply.hpp>

// generated includes
#include <gui/objects/PluginMessage.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// static members
static CAtomicCounter  s_PluginMsgCounter;


// constructor
CPluginMessage::CPluginMessage(void)
    : m_Id(s_PluginMsgCounter.Add(1))
    , m_Reporter(NULL)
{
}


// destructor
CPluginMessage::~CPluginMessage(void)
{
}


void CPluginMessage::ClearObjects(TClearType type)
{
    if (type & fClear_Request) {
        SetRequest().SetCommand().ClearObjects();
    }
    if (type & fClear_Reply) {
        SetReply().SetRaw().clear();
        SetReply().SetFormatted().ClearObjects();
    }
}

void CPluginMessage::SetReporter(IReporter* reporter)
{
    m_Reporter = reporter;
}


IReporter* CPluginMessage::SetReporter()
{
    return m_Reporter;
}


const IReporter* CPluginMessage::GetReporter() const
{
    return m_Reporter;
}

static void s_GetTypeString(const CPluginMessage& msg, string* str)
{
    const CPluginMessage::TRequest& request = msg.GetRequest();

    CPluginCommand::TCommand cmd(CPluginCommand::eCommand_no_command);
    if (request.IsSetCommand()) {
        cmd = request.GetCommand().GetCommand();
        const CEnumeratedTypeValues* ev =
            CPluginCommand::GetTypeInfo_enum_ECommand();
        *str += ev->FindName(cmd, true);
    }
    if ( !str->empty() ) {
        *str += ", ";
    }
    *str += "id #" + NStr::IntToString(msg.GetId());
}


static void s_GetContentString(const CPluginMessage& msg, string* str)
{
    if (msg.IsSetSource()) {
        *str += "source=";
        *str += msg.GetSource();
    }

    if (msg.IsSetDestination()) {
        *str += " dest=";
        *str += msg.GetDestination();
    }

    const CPluginMessage::TReply& reply = msg.GetReply();
    // status
    EMessageStatus status =
        reply.IsSetStatus() ? reply.GetStatus() : eMessageStatus_failed;
    *str += " status: " +
        GetTypeInfo_enum_EMessageStatus()
            ->FindName(status, true);
}


void CPluginMessage::GetLabel(string* str, ELabelType type, TFlags flags) const
{
    switch (type) {
    case eType:
        s_GetTypeString(*this, str);
        break;

    case eContent:
        s_GetContentString(*this, str);
        break;

    default:
    case eBoth:
        s_GetTypeString(*this, str);
        *str += " ";
        s_GetContentString(*this, str);
        break;
    }
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 64, chars: 1889, CRC32: b0cc0767 */
