/* $Id: PluginInfoSet.cpp 16652 2008-04-11 12:43:04Z dicuccio $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'plugin.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <gui/objects/PluginInfoSet.hpp>
#include <gui/utils/version.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CPluginInfoSet::~CPluginInfoSet(void)
{
}


CPluginInfo& CPluginInfoSet::CreateInfo(int major, int minor, int rev,
                                        const string& build_date,
                                        const string& class_name,
                                        const string& menu_item,
                                        const string& tooltip,
                                        const string& help_file)
{
    CRef<CPluginInfo> info(new CPluginInfo());
    info->SetInfo(major, minor, rev,
                  build_date, class_name, menu_item,
                  tooltip, help_file);
    Set().push_back(info);
    return *info;
}


CPluginInfo& CPluginInfoSet::CreateInfo(int major, int minor, int rev,
                                        const string& build_date,
                                        const string& class_name,
                                        const string& menu_item,
                                        const string& tooltip,
                                        const string& help_file,
                                        const string& icon_alias,
                                        const string& icon_local_path)
{
    CRef<CPluginInfo> info(new CPluginInfo());
    info->SetInfo(major, minor, rev,
                  build_date, class_name, menu_item,
                  tooltip, help_file, icon_alias, icon_local_path);
    Set().push_back(info);
    return *info;
}


int CPluginInfoSet::GetVer_major() const
{
    if ( !IsSet() ) {
        return CPluginVersion::eVersion_undefined;
    }

    Tdata::const_iterator iter = Get().begin();
    Tdata::const_iterator end  = Get().end();
    int ver = (*iter)->GetVer_major();
    for (++iter;  iter != end;  ++iter) {
        if ((*iter)->GetVer_major() != ver) {
            return CPluginVersion::eVersion_undefined;
        }
    }
    return ver;
}


int CPluginInfoSet::GetVer_minor() const
{
    if ( !IsSet() ) {
        return CPluginVersion::eVersion_undefined;
    }

    Tdata::const_iterator iter = Get().begin();
    Tdata::const_iterator end  = Get().end();
    int ver = (*iter)->GetVer_minor();
    for (++iter;  iter != end;  ++iter) {
        if ((*iter)->GetVer_minor() != ver) {
            return CPluginVersion::eVersion_undefined;
        }
    }
    return ver;
}

int CPluginInfoSet::GetVer_revision() const
{
    if ( !IsSet() ) {
        return CPluginVersion::eVersion_undefined;
    }

    Tdata::const_iterator iter = Get().begin();
    Tdata::const_iterator end  = Get().end();
    int ver = (*iter)->GetVer_revision();
    for (++iter;  iter != end;  ++iter) {
        if ((*iter)->GetVer_revision() != ver) {
            return CPluginVersion::eVersion_undefined;
        }
    }
    return ver;
}


string CPluginInfoSet::GetVer_build_date() const
{
    if ( !IsSet() ) {
        return kEmptyStr;
    }

    Tdata::const_iterator iter = Get().begin();
    Tdata::const_iterator end  = Get().end();
    string date = (*iter)->GetVer_build_date();
    for (++iter;  iter != end;  ++iter) {
        if ((*iter)->GetVer_build_date() != date) {
            return kEmptyStr;
        }
    }
    return date;
}

string CPluginInfoSet::GetClass_name() const
{
    if ( !IsSet() ) {
        return kEmptyStr;
    }

    Tdata::const_iterator iter = Get().begin();
    Tdata::const_iterator end  = Get().end();
    string date = (*iter)->GetClass_name();
    for (++iter;  iter != end;  ++iter) {
        if ((*iter)->GetClass_name() != date) {
            return kEmptyStr;
        }
    }
    return date;
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 65, chars: 1895, CRC32: b703286c */
