/* $Id: PluginCommandSet.cpp 14666 2007-07-09 13:40:22Z dicuccio $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Mike DiCuccio, Denis Vakatov, Anatoliy Kuznetsov
 *
 * File Description:
 *    CPluginCommandSet -- defines a set of similar commands exported by a
 *                         plugin.  This class is used by a plugin to declare
 *                         to the framework what sorts of commands are
 *                         understood by a given plugin.
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the data definition file
 *   'plugin.asn'.
 */

// standard includes

// generated includes
#include <ncbi_pch.hpp>
#include <gui/core/PluginCommandSet.hpp>
#include <gui/core/PluginCommand.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CPluginCommandSet::~CPluginCommandSet(void)
{
}


// create and return a new plugin argument object for a given command
CPluginCommand& CPluginCommandSet::AddAlgoCommand(EAlgoCommand cmd)
{
    CRef<CPluginCommand> args(new CPluginCommand());
    args->SetCommand(cmd);
    SetAlgo().push_back(args);
    return *args;
}


CPluginCommand& CPluginCommandSet::AddDataCommand(EDataCommand cmd)
{
    CRef<CPluginCommand> args(new CPluginCommand());
    args->SetCommand(cmd);
    SetData().push_back(args);
    return *args;
}


CPluginCommand& CPluginCommandSet::AddViewCommand(EViewCommand cmd)
{
    CRef<CPluginCommand> args(new CPluginCommand());
    args->SetCommand(cmd);
    SetView().push_back(args);
    return *args;
}



END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 64, chars: 1897, CRC32: 7ca245a9 */
