/* $Id: PluginCommand.cpp 14666 2007-07-09 13:40:22Z dicuccio $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Mike DiCuccio, Denis Vakatov, Anatoliy Kuznetsov
 *
 * File Description:
 *    CPluginCommand -- defines an interface for managing a single command
 *                      passed in to a plugin
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the data definition file
 *   'plugin.asn'.
 */

// standard includes

// generated includes
#include <ncbi_pch.hpp>
#include <gui/objects/PluginCommand.hpp>
#include <gui/objects/PluginArgSet.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CPluginCommand::~CPluginCommand(void)
{
}


void CPluginCommand::ClearObjects()
{
    SetArgs().ClearObjects();
}


// operator[] for indexing based on named argument
// this will throw if the named argument isn't found
const CPluginArg& CPluginCommand::operator[](const string& name) const
{
    return GetArgs()[ name ];
}

CPluginArg& CPluginCommand::operator[](const string& name)
{
    return SetArgs()[ name ];
}


// verify whether a named argument exists
bool CPluginCommand::HasArgument(const string& name) const
{
    return GetArgs().HasArgument(name);
}

/// Delete an existing argument
void CPluginCommand::RemoveArgument(const string& arg_name)
{
    SetArgs().RemoveArgument(arg_name);
}



// add a named argument.  This argument is required, and has no default
// value.  Attempts to access the value without setting the value will
// result in an exception being thrown.
CPluginArg& CPluginCommand::AddArgument(const string& name,
                                 const string& desc,
                                 CPluginArg::EType type,
                                 CPluginArg::TData::E_Choice single_or_array)
{
    return SetArgs().AddArgument(name, desc, type, single_or_array);
}


// add a named argument.  This argument is required, and has no default
// value.  Attempts to access the value without setting the value will
// result in an exception being thrown.
CPluginArg& CPluginCommand::AddArgument(const string& name,
                                 const string& desc,
                                 const CTypeInfo* type,
                                 CPluginArg::TData::E_Choice single_or_array)
{
    return SetArgs().AddArgument(name, desc, type, single_or_array);
}


CPluginArg& CPluginCommand::AddFlag(const string& name,
                                    const string& desc)
{
    return SetArgs().AddFlag(name, desc);
}


// Add a default argument to the set of arguments.  This function creates a
// named argument with a default value of type string.
CPluginArg& CPluginCommand::AddDefaultArgument(const string& name,
                                        const string& desc,
                                        CPluginArg::EType type,
                                        const string& val)
{
    return SetArgs().AddDefaultArgument(name, desc, type, val);
}


CPluginArg& CPluginCommand::AddDefaultFlag(const string& name,
                                           const string& desc,
                                           bool val)
{
    return SetArgs().AddDefaultFlag(name, desc, val);
}


// add an optional argument to the set of arguments.  This supports an
// optional default value argument.  For non-built-in types, the default
// value is ignored.
CPluginArg& CPluginCommand::AddOptionalArgument(const string& name,
                                         const string& desc,
                                         CPluginArg::EType type,
                                         CPluginArg::TData::E_Choice s_or_a)
{
    return SetArgs().AddOptionalArgument(name, desc, type, s_or_a);
}


CPluginArg& CPluginCommand::AddOptionalArgument(const string& name,
                                         const string& desc,
                                         const CTypeInfo* type,
                                         CPluginArg::TData::E_Choice s_or_a)
{
    return SetArgs().AddOptionalArgument(name, desc, type, s_or_a);
}


// add a constraint to a named argument
void CPluginCommand::SetConstraint(const string& name,
                                   CPluginValueConstraint& constraint)
{
    SetArgs().SetConstraint(name, constraint);
}


void CPluginCommand::AddConstraint(const string& name,
                                   CPluginValueConstraint& constraint)
{
    SetArgs().AddConstraint(name, constraint);
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 64, chars: 1885, CRC32: 56e32803 */
