/* $Id: PluginArgSet.cpp 14666 2007-07-09 13:40:22Z dicuccio $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Mike DiCuccio, Denis Vakatov, Anatoliy Kuznetsov
 *
 * File Description:
 *    CPluginArgSet -- defines an interface for collections of plugin arguments
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the data definition file
 *   'plugin.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>
#include <gui/objects/plugin_exception.hpp>

// generated includes
#include <gui/objects/PluginArgSet.hpp>
#include <gui/objects/PluginArg.hpp>
#include <gui/objects/PluginValueConstraint.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CPluginArgSet::~CPluginArgSet(void)
{
}


void CPluginArgSet::ClearObjects()
{
    NON_CONST_ITERATE (Tdata, iter, Set()) {
        (*iter)->ClearObjects();
    }
}

//
// indexing operator for accessing arguments based on names
//
const CPluginArg& CPluginArgSet::operator[] (const string& name) const
{
    ITERATE (Tdata, iter, Get()) {
        if ( (*iter)->GetName() == name) {
            return (**iter);
        }
    }

    // not found - we throw
    NCBI_THROW(CPluginException, eInvalidArg,
               "No argument named '" + name + "'");
}


CPluginArg& CPluginArgSet::operator[] (const string& name)
{
    NON_CONST_ITERATE (Tdata, iter, Set()) {
        if ( (*iter)->GetName() == name) {
            return (**iter);
        }
    }

    // not found - we throw
    NCBI_THROW(CPluginException, eInvalidArg,
               "No argument named '" + name + "'");
}


// HasArgument() can be used to tell whether this set of arguments contains an
// argument named 'name'
bool CPluginArgSet::HasArgument(const string& name) const
{
    ITERATE (Tdata, iter, Get()) {
        if ( (*iter)->GetName() == name) {
            return true;
        }
    }

    return false;
}

/// Delete an existing argument
void CPluginArgSet::RemoveArgument(const string& arg_name)
{
    NON_CONST_ITERATE (Tdata, iter, Set()) {
        if ( (*iter)->GetName() == arg_name) {
            Set().erase(iter);
            break;
        }
    }
}



// add a named argument.  This argument is required, and has no default
// value.  Attempts to access the value without setting the value will
// result in an exception being thrown.
CPluginArg&
CPluginArgSet::AddArgument(const string& name, const string& desc,
                           CPluginArg::EType type,
                           CPluginArg::TData::E_Choice single_or_array)
{
    if (HasArgument(name)) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   string("Argument `") + name + string("' already exists"));
    }

    CRef<CPluginArg> arg(new CPluginArg());
    switch (type) {
    case CPluginArg::eBoolean:
        arg->SetBoolean();
        break;
    case CPluginArg::eInteger:
        arg->SetInteger();
        break;
    case CPluginArg::eDouble:
        arg->SetDouble();
        break;
    case CPluginArg::eString:
        arg->SetString();
        break;
    case CPluginArg::eSecretString:
        arg->SetSecretString();
        break;
    case CPluginArg::eInputFile:
        arg->SetInputFile();
        break;
    case CPluginArg::eOutputFile:
        arg->SetOutputFile();
        break;
    case CPluginArg::eProject:
        arg->SetProject();
        break;
    case CPluginArg::eObject:
        arg->SetObject();
        break;
    case CPluginArg::eAnySerialObject:
        arg->SetObject("SerialObject");
        break;

    default:
    case CPluginArg::eNotSet:
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Invalid argument type in AddArgument()");
    }

    if (single_or_array == CPluginArg::TData::e_Array) {
        arg->SetList();
    }

    arg->SetName(name);
    arg->SetDesc(desc);
    Set().push_back(arg);
    return *arg;
}


// add a named argument.  This argument is required, and has no default
// value.  Attempts to access the value without setting the value will
// result in an exception being thrown.
CPluginArg&
CPluginArgSet::AddArgument(const string& name, const string& desc,
                           const CTypeInfo* type,
                           CPluginArg::TData::E_Choice single_or_array)
{
    if (HasArgument(name)) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   string("Argument `") + name + string("' already exists"));
    }

    CRef<CPluginArg> arg(new CPluginArg());
    arg->SetObject(type);
    arg->SetName(name);
    arg->SetDesc(desc);

    if (single_or_array == CPluginArg::TData::e_Array) {
        arg->SetList();
    }

    Set().push_back(arg);
    return *arg;
}


// Add a default argument to the set of arguments.  This function creates a
// named argument with a default value of type string.
CPluginArg&
CPluginArgSet::AddDefaultArgument(const string& name, const string& desc,
                                  CPluginArg::EType type,
                                  const string& val)
{
    if (HasArgument(name)) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   string("Argument `") + name + string("' already exists"));
    }

    CRef<CPluginArg> arg(new CPluginArg());
    arg->SetName(name);
    arg->SetDesc(desc);
    arg->SetDefault(true);
    switch (type) {
    case CPluginArg::eInteger:
        arg->SetInteger(NStr::StringToInt(val));
        break;

    case CPluginArg::eBoolean:
        arg->SetBoolean(NStr::StringToBool(val));
        break;

    case CPluginArg::eDouble:
        arg->SetDouble(NStr::StringToDouble(val));
        break;

    case CPluginArg::eSecretString:
        arg->SetSecretString(val);
        break;

    case CPluginArg::eString:
        arg->SetString(val);
        break;

    case CPluginArg::eInputFile:
        arg->SetInputFile(val);
        break;

    case CPluginArg::eOutputFile:
        arg->SetOutputFile(val);
        break;

    default:
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to create non-String argument type with "
                   "string default value");
    }

    Set().push_back(arg);
    return *arg;
}


CPluginArg&
CPluginArgSet::AddFlag(const string& name, const string& desc)
{
    return AddArgument(name, desc, CPluginArg::eBoolean);
}


CPluginArg&
CPluginArgSet::AddDefaultFlag(const string& name, const string& desc,
                              bool val)
{
    return AddDefaultArgument(name, desc, CPluginArg::eBoolean,
                              NStr::BoolToString(val));
}


// add an optional argument to the set of arguments.  This supports an
// optional default value argument.  For non-built-in types, the default
// value is ignored.
CPluginArg&
CPluginArgSet::AddOptionalArgument(const string& name, const string& desc,
                                   CPluginArg::EType type,
                                   CPluginArg::TData::E_Choice s_or_a)
{
    if (HasArgument(name)) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   string("Argument `") + name + string("' already exists"));
    }

    CRef<CPluginArg> arg(new CPluginArg());
    switch (type) {
    case CPluginArg::eBoolean:
        arg->SetBoolean();
        break;
    case CPluginArg::eInteger:
        arg->SetInteger();
        break;
    case CPluginArg::eDouble:
        arg->SetDouble();
        break;
    case CPluginArg::eSecretString:
        arg->SetSecretString();
        break;
    case CPluginArg::eString:
        arg->SetString();
        break;
    case CPluginArg::eInputFile:
        arg->SetInputFile();
        break;
    case CPluginArg::eOutputFile:
        arg->SetOutputFile();
        break;
    case CPluginArg::eProject:
        arg->SetProject();
        break;
    case CPluginArg::eObject:
        arg->SetObject();
        break;
    case CPluginArg::eAnySerialObject:
        arg->SetObject("SerialObject");
        break;

    default:
    case CPluginArg::eNotSet:
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Invalid argument type in AddArgument()");
    }

    arg->SetName(name);
    arg->SetDesc(desc);
    arg->SetOptional(true);
    if (s_or_a == CPluginArg::TData::e_Array) {
        arg->SetList();
    }

    Set().push_back(arg);
    return *arg;
}


CPluginArg&
CPluginArgSet::AddOptionalArgument(const string& name, const string& desc,
                                   const CTypeInfo* info,
                                   CPluginArg::TData::E_Choice s_or_a)
{
    if (HasArgument(name)) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   string("Argument `") + name + string("' already exists"));
    }

    CRef<CPluginArg> arg(new CPluginArg());
    arg->SetName(name);
    arg->SetDesc(desc);
    arg->SetOptional(true);
    arg->SetObject(info);
    if (s_or_a == CPluginArg::TData::e_Array) {
        arg->SetList();
    }

    Set().push_back(arg);
    return *arg;
}


//
// SetConstraint() resets the constraints for a given named argument and adds a
// new argument constraint
//
void CPluginArgSet::SetConstraint(const string& name,
                                  CPluginValueConstraint& constraint)
{
    CPluginArg& arg = (*this)[name];
    arg.SetConstraint().clear();
    arg.SetConstraint().push_back( CRef<CPluginValueConstraint>(&constraint) );
}


//
// AddConstraint() adds a constraint to a named argument
//
void CPluginArgSet::AddConstraint(const string& name,
                                  CPluginValueConstraint& constraint)
{
    CPluginArg& arg = (*this)[name];
    arg.SetConstraint().push_back( CRef<CPluginValueConstraint>(&constraint) );
}

void CPluginArgSet::RemoveConstraint(const string& name)
{
    CPluginArg& arg = (*this)[name];
    arg.ResetConstraint();
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 64, chars: 1873, CRC32: 1571727e */
