/* $Id: PluginArg.cpp 30280 2014-04-23 20:28:26Z katargir $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the data definition file
 *   'plugin.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>
#include <gui/objects/plugin_exception.hpp>

// generated includes
#include <gui/objects/PluginArg.hpp>
#include <gui/objects/PluginObject.hpp>
#include <gui/objects/PluginValue.hpp>
#include <gui/objects/PluginValueConstraint.hpp>
#include <gui/objects/PluginValueRangeConstraint.hpp>

#include <objects/seq/Bioseq.hpp>
#include <objects/seqalign/Seq_align.hpp>
#include <objects/seq/Seq_annot.hpp>
#include <objects/seqfeat/Seq_feat.hpp>
#include <objects/seqloc/Seq_id.hpp>
#include <objects/seqloc/Seq_loc.hpp>
#include <objects/seqres/Seq_graph.hpp>
#include <objects/seqset/Bioseq_set.hpp>
#include <objects/seqset/Seq_entry.hpp>

#include <serial/iterator.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CPluginArg::~CPluginArg(void)
{
}


// access the type for this argument
CPluginArg::EType CPluginArg::GetType(void) const
{
    CPluginValue::E_Choice choice = CPluginValue::e_not_set;
    if (GetData().IsSingle()) {
        choice = GetData().GetSingle().Which();
    } else if (GetData().IsArray()  &&
               GetData().GetArray().size() != 0) {
        choice = GetData().GetArray().front()->Which();
    }

    switch (choice) {
    case CPluginValue::e_Integer:
        return eInteger;
    case CPluginValue::e_Double:
        return eDouble;
    case CPluginValue::e_Boolean:
        return eBoolean;
    case CPluginValue::e_String:
        return eString;
    case CPluginValue::e_Secret_string:
        return eSecretString;
    case CPluginValue::e_Project:
        return eProject;
    case CPluginValue::e_Object:
        return eObject;
    case CPluginValue::e_Input_file:
        return eInputFile;
    case CPluginValue::e_Output_file:
        return eOutputFile;

    default:
        return eNotSet;
    }
}

// accessors for specific sub-components
const CGBProjectHandle* CPluginArg::GetProject(void) const
{
    if (GetData().IsSingle()) {
        return GetData().GetSingle().GetProject();
    } else {
        return GetData().GetArray().front()->GetProject();
    }
}

const CObject* CPluginArg::GetObject(void) const
{
    if (GetData().IsSingle()) {
        return GetData().GetSingle().GetObject();
    } else {
        return GetData().GetArray().front()->GetObject();
    }
}


const string& CPluginArg::GetObjectSubtype(void) const
{
    if (GetData().IsSingle()) {
        return GetData().GetSingle().GetObjectSubtype();
    } else {
        return GetData().GetArray().front()->GetObjectSubtype();
    }
}


bool CPluginArg::IsEmpty(void) const
{
    CTypeConstIterator<CPluginValue> iter(*this);
    for ( ;  iter;  ++iter) {
        if ( !iter->IsEmpty() ) {
            return false;
        }
    }

    return true;
}


void CPluginArg::ClearObjects()
{
    switch (GetType()) {
    default:
        break;

    case eProject:
        if (GetData().IsSingle()) {
            ResetData();
            SetProject();
        } else {
            ResetData();
            SetProject();
            SetList();
        }
        break;

    case eObject:
        {{
            string subtype = GetObjectSubtype();

            if (GetData().IsSingle()) {
                ResetData();
                SetObject(subtype);
            } else {
                ResetData();
                SetObject(subtype);
                SetList();
            }
        }}
        break;
    }
}


//
// integer handlers
//

void CPluginArg::SetInteger(void)
{
    SetData().Reset();
    SetData().SetSingle().SetInteger();
}


void CPluginArg::SetInteger(const string& arg)
{
    SetData().Reset();
    SetData().SetSingle().SetInteger(arg);
}


void CPluginArg::SetInteger(int arg)
{
    SetData().Reset();
    SetData().SetSingle().SetInteger(arg);
}


void CPluginArg::SetInteger(const list<int>& int_list)
{
    SetData().Reset();
    ITERATE (list<int>, iter, int_list) {
        CRef<CPluginValue> value(new CPluginValue());
        value->SetInteger(*iter);
        SetData().SetArray().push_back(value);
    }
}


int CPluginArg::AsInteger(void) const
{
    if ( !GetData().IsSingle() ) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to cast array argument to single object");
    }

    return GetData().GetSingle().AsInteger();
}


//
// double handlers
//

void CPluginArg::SetDouble(void)
{
    SetData().Reset();
    SetData().SetSingle().SetDouble();
}


void CPluginArg::SetDouble(const string& arg)
{
    SetData().Reset();
    SetData().SetSingle().SetDouble(arg);
}


void CPluginArg::SetDouble(double arg)
{
    SetData().Reset();
    SetData().SetSingle().SetDouble(arg);
}


void CPluginArg::SetDouble(const list<double>& double_list)
{
    SetData().Reset();
    ITERATE (list<double>, iter, double_list) {
        CRef<CPluginValue> value(new CPluginValue());
        value->SetDouble(*iter);
        SetData().SetArray().push_back(value);
    }
}


double CPluginArg::AsDouble(void) const
{
    if ( !GetData().IsSingle() ) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to cast array argument to single object");
    }

    return GetData().GetSingle().AsDouble();
}


//
// boolean handlers
//

void CPluginArg::SetBoolean(void)
{
    SetData().Reset();
    SetData().SetSingle().SetBoolean();
}


void CPluginArg::SetBoolean(bool arg)
{
    SetData().Reset();
    SetData().SetSingle().SetBoolean(arg);
}


void CPluginArg::SetBoolean(const list<bool>& bool_list)
{
    SetData().Reset();
    ITERATE (list<bool>, iter, bool_list) {
        CRef<CPluginValue> value(new CPluginValue());
        value->SetBoolean(*iter);
        SetData().SetArray().push_back(value);
    }
}


bool CPluginArg::AsBoolean(void) const
{
    if ( !GetData().IsSingle() ) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to cast array argument to single object");
    }

    return GetData().GetSingle().AsBoolean();
}


//
// string handlers
//

void CPluginArg::SetString(void)
{
    SetData().Reset();
    SetData().SetSingle().SetString();
}


void CPluginArg::SetString(const string& arg)
{
    SetData().Reset();
    SetData().SetSingle().SetString(arg);
}


void CPluginArg::SetString(const list<string>& string_list)
{
    SetData().Reset();
    ITERATE (list<string>, iter, string_list) {
        CRef<CPluginValue> value(new CPluginValue());
        value->SetString(*iter);
        SetData().SetArray().push_back(value);
    }
}


const string& CPluginArg::AsString(void) const
{
    if ( !GetData().IsSingle() ) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to cast array argument to single object");
    }

    return GetData().GetSingle().AsString();
}


//
// secret string handlers
//

void CPluginArg::SetSecretString(void)
{
    SetData().Reset();
    SetData().SetSingle().SetSecret_string();
}


void CPluginArg::SetSecretString(const string& arg)
{
    SetData().Reset();
    SetData().SetSingle().SetSecret_string(arg);
}


void CPluginArg::SetSecretString(const list<string>& string_list)
{
    SetData().Reset();
    ITERATE (list<string>, iter, string_list) {
        CRef<CPluginValue> value(new CPluginValue());
        value->SetSecret_string(*iter);
        SetData().SetArray().push_back(value);
    }
}


const string& CPluginArg::AsSecretString(void) const
{
    if ( !GetData().IsSingle() ) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to cast array argument to single object");
    }

    return GetData().GetSingle().AsSecretString();
}


//
// file handlers
//

void CPluginArg::SetInputFile(void)
{
    SetData().Reset();
    SetData().SetSingle().SetInput_file();
}


void CPluginArg::SetInputFile(const string& arg)
{
    SetData().Reset();
    SetData().SetSingle().SetInput_file(arg);
}


void CPluginArg::SetInputFile(const list<string>& file_list)
{
    SetData().Reset();
    ITERATE (list<string>, iter, file_list) {
        CRef<CPluginValue> value(new CPluginValue());
        value->SetInput_file(*iter);
        SetData().SetArray().push_back(value);
    }
}


const string& CPluginArg::AsInputFile(void) const
{
    if ( !GetData().IsSingle() ) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to cast array argument to single object");
    }

    return GetData().GetSingle().AsInputFile();
}


void CPluginArg::SetOutputFile(void)
{
    SetData().Reset();
    SetData().SetSingle().SetOutput_file();
}


void CPluginArg::SetOutputFile(const string& arg)
{
    SetData().Reset();
    SetData().SetSingle().SetOutput_file(arg);
}


void CPluginArg::SetOutputFile(const list<string>& file_list)
{
    SetData().Reset();
    ITERATE (list<string>, iter, file_list) {
        CRef<CPluginValue> value(new CPluginValue());
        value->SetOutput_file(*iter);
        SetData().SetArray().push_back(value);
    }
}


const string& CPluginArg::AsOutputFile(void) const
{
    if ( !GetData().IsSingle() ) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to cast array argument to single object");
    }

    return GetData().GetSingle().AsOutputFile();
}


//
// document handlers
//

void CPluginArg::SetProject(void)
{
    SetData().Reset();
    CPluginValue& value = SetData().SetSingle();
    value.SetProject();
}


void CPluginArg::SetProject(const CGBProjectHandle& arg)
{
    SetData().Reset();
    SetData().SetSingle().SetProject(arg);
}


void CPluginArg::SetProject(const TValues& Project_list)
{
    SetData().Reset();
    ITERATE (TValues, iter, Project_list) {
        CRef<CPluginValue> value(new CPluginValue());
        value->SetProject((*iter)->AsProject());
        SetData().SetArray().push_back(value);
    }
}


const CGBProjectHandle& CPluginArg::AsProject(void) const
{
    if ( !GetData().IsSingle() ) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to cast array argument to single object");
    }

    return GetData().GetSingle().AsProject();
}


//
// object handlers
//

void CPluginArg::SetObject(const string& type)
{
    SetData().Reset();
    SetData().SetSingle().SetObject(type);
}


void CPluginArg::SetObject(const CTypeInfo* info)
{
    SetData().Reset();
    SetData().SetSingle().SetObject(info);
}


void CPluginArg::SetObject(const CObject& obj, const CGBProjectHandle* doc, const CDataHandle * dh)
{
    SetData().Reset();
    SetData().SetSingle().SetObject(obj, doc, dh);
}


void CPluginArg::SetObject(const TValues& obj_list)
{
    SetData().Reset();
    ITERATE (TValues, iter, obj_list) {
        SetData().SetArray().push_back
            (CRef<CPluginValue> (const_cast<CPluginValue*>(iter->GetPointer())));
    }
}


const CObject& CPluginArg::AsObject(void) const
{
    if ( !GetData().IsSingle() ) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to cast array argument to single object");
    }

    return GetData().GetSingle().AsObject();
}


//
// generic list accessors
//

void CPluginArg::SetList(void)
{
    if (GetData().IsSingle()) {
        CRef<CPluginValue> value(&SetData().SetSingle());
        SetData().Reset();
        SetData().SetArray().push_back(value);
    }
}


void CPluginArg::SetList(const TValues& args)
{
    SetData().Reset();
    SetData().SetArray();
    ITERATE (TValues, iter, args) {
        CPluginValue* value = const_cast<CPluginValue*> (iter->GetPointer());
        SetData().SetArray().push_back( CRef<CPluginValue>(value));
    }
}


void CPluginArg::AsList(TValues& arg) const
{
    if ( !GetData().IsArray() ) {
        NCBI_THROW(CPluginException, eInvalidArg,
                   "Attempt to cast single argument to array");
    }

    arg.clear();
    ITERATE (TData::TArray, iter, GetData().GetArray()) {
        arg.push_back(*iter);
    }
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 64, chars: 1879, CRC32: 6874a1e4 */
