/* $Id: GBenchVersionInfo.cpp 44795 2020-03-17 19:22:19Z evgeniev $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'gbench_svc.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>


#if defined(NCBI_OS_DARWIN)
#import <Foundation/Foundation.h>
#import <Foundation/NSProcessInfo.h>
#include <CoreServices/CoreServices.h>

void GetOperatingSystemVersion(unsigned &major, unsigned &minor, unsigned &patch)
{
    NSOperatingSystemVersion versionObj = [NSProcessInfo processInfo].operatingSystemVersion;

    major = (unsigned)versionObj.majorVersion;
    minor = (unsigned)versionObj.minorVersion;
    patch = (unsigned)versionObj.patchVersion;
}
#endif

// generated includes
#include <gui/objects/GBenchVersionInfo.hpp>
#include <gui/objects/OS_Ver.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::


int CGBenchVersionInfo::major = 0;//CPluginVersion::eMajor;
int CGBenchVersionInfo::minor = 0;//CPluginVersion::eMinor;
int CGBenchVersionInfo::patch = 0;//CPluginVersion::ePatchLevel;
int CGBenchVersionInfo::osver = eOS_Ver_unknown;
int CGBenchVersionInfo::osarch = -1;

bool CGBenchVersionInfo::sInitialized = false;

void CGBenchVersionInfo::Initialize( size_t ver_major, size_t ver_minor, size_t ver_patch_level )
{
    if( sInitialized ) return;

    CGBenchVersionInfo::major = (int)ver_major;
    CGBenchVersionInfo::minor = (int)ver_minor;
    CGBenchVersionInfo::patch = (int)ver_patch_level;

#if defined(NCBI_OS_MSWIN)
    ///
    /// determine the OS version
    ///
    CGBenchVersionInfo::osver = eOS_Ver_windows_generic;
                           
    OSVERSIONINFOEXW osinfo;
    memset(&osinfo, 0, sizeof(osinfo));
    osinfo.dwOSVersionInfoSize = sizeof(osinfo);

    typedef LONG(WINAPI *PRtlGetVersion)(LPOSVERSIONINFOEXW);
    PRtlGetVersion pRtlGetVersion = (PRtlGetVersion)GetProcAddress(GetModuleHandle(TEXT("ntdll.dll")), "RtlGetVersion");
    LONG status = -1;
    if (pRtlGetVersion)
        status = pRtlGetVersion(&osinfo);

    if (status != 0) {
        memset(&osinfo, 0, sizeof(osinfo));
        osinfo.dwOSVersionInfoSize = sizeof(osinfo);

#ifdef _MSC_VER
#pragma warning(push)
#pragma warning(disable:4996) // 'xxx': was declared deprecated
#endif
		GetVersionExW((LPOSVERSIONINFOW)&osinfo);
#ifdef _MSC_VER
#pragma warning(pop)
#endif

	}

    switch( osinfo.dwMajorVersion ){
    default:
        break;

    case 3:
        CGBenchVersionInfo::osver = eOS_Ver_windows_351;
        break;

    case 4:
        switch( osinfo.dwMinorVersion ){
        case 0:
            CGBenchVersionInfo::osver = eOS_Ver_windows_95;
            break;

        case 10:
            CGBenchVersionInfo::osver = eOS_Ver_windows_98;
            break;

        case 90:
            CGBenchVersionInfo::osver = eOS_Ver_windows_me;
            break;

        default:
            CGBenchVersionInfo::osver = eOS_Ver_windows_95;
            break;
        }
        break;

    case 5:
        switch( osinfo.dwMinorVersion ){
        case 0:
        default:
            CGBenchVersionInfo::osver = eOS_Ver_windows_2000;
            break;

        case 1:
            CGBenchVersionInfo::osver = eOS_Ver_windows_xp;
            break;

        case 2:
            CGBenchVersionInfo::osver = eOS_Ver_windows_2003;
            // SMSERVERR2 is not defined; it is needed for distinction of R2
            break;
        }
        break;

    case 6:
        switch( osinfo.dwMinorVersion ){
        case 0:
        default:
            CGBenchVersionInfo::osver = 
                (osinfo.wProductType == VER_NT_WORKSTATION)
                ? eOS_Ver_windows_vista 
                : eOS_Ver_windows_2008
            ;
            break;

        case 1:
            CGBenchVersionInfo::osver = 
                (osinfo.wProductType == VER_NT_WORKSTATION)
                ? eOS_Ver_windows_seven 
                : eOS_Ver_windows_2008_R2
            ;
            break;
        case 2:
            CGBenchVersionInfo::osver =
                (osinfo.wProductType == VER_NT_WORKSTATION)
                ? eOS_Ver_windows_eight
                : eOS_Ver_windows_2012
                ;
            break;
        case 3:
            CGBenchVersionInfo::osver =
                (osinfo.wProductType == VER_NT_WORKSTATION)
                ? eOS_Ver_windows_eight_one
                : eOS_Ver_windows_2012_R2
                ;
            break;
        }
        break;
    case 10:
        CGBenchVersionInfo::osver =
            (osinfo.wProductType == VER_NT_WORKSTATION)
            ? eOS_Ver_windows_ten
            : eOS_Ver_windows_2016
            ;
        break;
    }

    CGBenchVersionInfo::osarch = -1;
    TOs_ver arch_flag = 0;

    SYSTEM_INFO sysinfo;
    memset(&sysinfo, 0, sizeof(sysinfo));

    typedef void (WINAPI *PGetSysInfo)(SYSTEM_INFO*);

    PGetSysInfo pGetSysInfo = (PGetSysInfo) GetProcAddress( GetModuleHandle(TEXT("kernel32.dll")), "GetNativeSystemInfo" );
    if( pGetSysInfo != NULL ){
        pGetSysInfo( &sysinfo );
    } else {
        GetSystemInfo( &sysinfo );
    }
    switch( sysinfo.wProcessorArchitecture ){
    case PROCESSOR_ARCHITECTURE_UNKNOWN:
    default:
        CGBenchVersionInfo::osarch = -1;
        arch_flag = 0;
        break;

    case PROCESSOR_ARCHITECTURE_INTEL:
        CGBenchVersionInfo::osarch = 0;
        arch_flag = eOS_Ver_intel_x32;
        break;
    case PROCESSOR_ARCHITECTURE_AMD64:
        CGBenchVersionInfo::osarch = 1;
        arch_flag = eOS_Ver_amd_x64;
        break;
    case PROCESSOR_ARCHITECTURE_IA64:
        CGBenchVersionInfo::osarch = 2;
        arch_flag = eOS_Ver_intel_x64;
        break;
    }
    CGBenchVersionInfo::osver |= arch_flag;


#elif defined(NCBI_OS_DARWIN)

    // The call to get the architecture is deprecated, so it will be hard-coded until another process architecture becomes available
    TOs_ver arch_flag = eOS_Ver_intel_x64;

    unsigned vers_maj;
    unsigned vers_min;
    unsigned vers_patch;
    
    GetOperatingSystemVersion(vers_maj, vers_min, vers_patch);

    switch (vers_min) {
    case 1:
        CGBenchVersionInfo::osver = eOS_Ver_macosx_10_1 | arch_flag;
        break;
    case 2:
        CGBenchVersionInfo::osver = eOS_Ver_macosx_10_2 | arch_flag;
        break;
    case 3:
        CGBenchVersionInfo::osver = eOS_Ver_macosx_10_3 | arch_flag;
        break;
    case 4:
        CGBenchVersionInfo::osver = eOS_Ver_macosx_10_4 | arch_flag;
        break;
    case 5:
        CGBenchVersionInfo::osver = eOS_Ver_macosx_10_5 | arch_flag;
        break;
    case 6:
        CGBenchVersionInfo::osver = eOS_Ver_macosx_10_6 | arch_flag;
        break;
    case 7:
        CGBenchVersionInfo::osver = eOS_Ver_macosx_10_7 | arch_flag;
        break;
    case 8:
        CGBenchVersionInfo::osver = eOS_Ver_macosx_10_8 | arch_flag;
        break;
    case 9:
        CGBenchVersionInfo::osver = eOS_Ver_macosx_10_9 | arch_flag;
        break;
    case 10:
        CGBenchVersionInfo::osver = eOS_Ver_macosx_10_10 | arch_flag;
        break;
    case 11:
        CGBenchVersionInfo::osver = eOS_Ver_macosx_10_11 | arch_flag;
        break;
    case 12:
        CGBenchVersionInfo::osver = eOS_Ver_macosx_10_12 | arch_flag;
        break;
    case 13:
        CGBenchVersionInfo::osver = eOS_Ver_macosx_10_13 | arch_flag;
        break;
    case 14:
        CGBenchVersionInfo::osver = eOS_Ver_macosx_10_14 | arch_flag;
        break;
    case 15:
        CGBenchVersionInfo::osver = eOS_Ver_macosx_10_15 | arch_flag;
        break;
    }

#elif defined(NCBI_OS_UNIX)

    CGBenchVersionInfo::osver = eOS_Ver_unix_generic;
#else

    CGBenchVersionInfo::osver = eOS_Ver_unknown;
#endif

    sInitialized = true;
}

CGBenchVersionInfo::CGBenchVersionInfo()
{
    if( sInitialized ){
        SetVer_major(CGBenchVersionInfo::major);
        SetVer_minor(CGBenchVersionInfo::minor);
        SetVer_patch(CGBenchVersionInfo::patch);
        SetOs_ver(CGBenchVersionInfo::osver);

        // Commented out until cgi update on server
        // SetOs_arch(CGBenchVersionInfo::osarch);
    }
}

// destructor
CGBenchVersionInfo::~CGBenchVersionInfo(void)
{
}


void CGBenchVersionInfo::GetLabel( string* str ) const
{
    if( !str ){
        return;
    }

    AddVersionString( str );

    *str += " (";
    AddOsString( str );
    *str += ")";

    if (IsSetBuild_date()) {
        *str += " [" + GetBuild_date().AsCTime().AsString() + "]";
    }
}

void CGBenchVersionInfo::GetVersionString( string* str ) const
{
    if( str ){
        str->clear();
        AddVersionString( str );
    }
}

void CGBenchVersionInfo::AddVersionString( string* str ) const
{
    *str += NStr::IntToString(GetVer_major());
    *str += '.';
    *str += NStr::IntToString(GetVer_minor());
    *str += '.';
    *str += NStr::IntToString(GetVer_patch());
}

void CGBenchVersionInfo::GetOsString( string* str ) const
{
    if( str ){
        str->clear();
        AddOsString( str );
    }
}

void CGBenchVersionInfo::AddOsString( string* str ) const
{
    const char* os_name;
    switch( GetOs_ver() & ~eOS_Ver_cpu_generic ){
    case eOS_Ver_windows_generic:
        os_name = "Windows";
        break;
    case eOS_Ver_windows_95:
        os_name = "Windows 95";
        break;
    case eOS_Ver_windows_98:
        os_name = "Windows 98";
        break;
    case eOS_Ver_windows_me:
        os_name = "Windows ME";
        break;
    case eOS_Ver_windows_351:
        os_name = "Windows NT 3.51";
        break;
    case eOS_Ver_windows_nt4:
        os_name = "Windows NT 4.0";
        break;
    case eOS_Ver_windows_2000:
        os_name = "Windows 2000";
        break;
    case eOS_Ver_windows_xp:
        os_name = "Windows XP";
        break;
    case eOS_Ver_windows_2003:
        os_name = "Windows 2003";
        break;
    case eOS_Ver_windows_2003_R2:
        os_name = "Windows 2003 R2";
        break;
    case eOS_Ver_windows_vista:
        os_name = "Windows Vista";
        break;
    case eOS_Ver_windows_2008:
        os_name = "Windows 2008";
        break;
    case eOS_Ver_windows_2008_R2:
        os_name = "Windows 2008 R2";
        break;
    case eOS_Ver_windows_seven:
        os_name = "Windows 7";
        break;
    case eOS_Ver_windows_2012:
        os_name = "Windows Server 2012";
        break;
    case eOS_Ver_windows_eight:
        os_name = "Windows 8.0";
        break;
    case eOS_Ver_windows_2012_R2:
        os_name = "Windows Server 2012 R2";
        break;
    case eOS_Ver_windows_eight_one:
        os_name = "Windows 8.1";
        break;
    case eOS_Ver_windows_2016:
        os_name = "Windows Server 2016";
        break;
    case eOS_Ver_windows_ten:
        os_name = "Windows 10";
        break;
    case eOS_Ver_macosx_generic:
        os_name = "MacOS X";
        break;
    case eOS_Ver_macosx_10_1:
        os_name = "MacOS X 10.1";
        break;
    case eOS_Ver_macosx_10_2:
        os_name = "MacOS X 10.2";
        break;
    case eOS_Ver_macosx_10_3:
        os_name = "MacOS X 10.3";
        break;
    case eOS_Ver_macosx_10_4:
        os_name = "MacOS X 10.4";
        break;
    case eOS_Ver_macosx_10_5:
        os_name = "MacOS X 10.5";
        break;
    case eOS_Ver_macosx_10_6:
        os_name = "MacOS X 10.6";
        break;
    case eOS_Ver_macosx_10_7:
        os_name = "MacOS X 10.7";
        break;
    case eOS_Ver_macosx_10_8:
        os_name = "MacOS X 10.8 Mountain Lion";
        break;
    case eOS_Ver_macosx_10_9:
        os_name = "MacOS X 10.9 Mavericks";
        break;
    case eOS_Ver_macosx_10_10:
        os_name = "MacOS X 10.10 Yosemite";
        break;
    case eOS_Ver_macosx_10_11:
        os_name = "MacOS X 10.11 El Capitan";
        break;
    case eOS_Ver_macosx_10_12:
        os_name = "MacOS X 10.12 Sierra";
        break;
    case eOS_Ver_macosx_10_13:
        os_name = "MacOS X 10.13 High Sierra";
        break;
    case eOS_Ver_macosx_10_14:
        os_name = "MacOS X 10.14 Mojave";
        break;
    case eOS_Ver_macosx_10_15:
        os_name = "MacOS X 10.15 Catalina";
        break;

    case eOS_Ver_unix_generic:
        os_name = "Unix";
        break;
    case eOS_Ver_unix_linux:
        os_name = "Unix/Linux";
        break;
    case eOS_Ver_unix_solaris_9:
        os_name = "Unix/Solaris 9";
        break;
    case eOS_Ver_unix_solaris_10:
        os_name = "Unix/Solaris 10";
        break;

    default:
        if( GetOs_ver() & eOS_Ver_windows_generic ){
            os_name = "Windows";
        } else if( GetOs_ver() & eOS_Ver_macosx_generic ){
            os_name = "MacOS X";
        } else if( GetOs_ver() & eOS_Ver_unix_generic ){
            os_name = "Unix";
        } else {
            os_name = "Unknown";
        }
        break;
    }

    const char* arch_name = "";
    switch( GetOs_ver() & eOS_Ver_cpu_generic ){
    case eOS_Ver_intel_x32:
        arch_name = " Intel-x32";
        break;
    case eOS_Ver_amd_x64:
        arch_name = " AMD-x64";
        break;
    case eOS_Ver_intel_x64:
        arch_name = " Intel-x64";
        break;
    case eOS_Ver_ppc:
        arch_name = " PowerPC";
        break;
    case eOS_Ver_sparc:
        arch_name = " Sparc";
        break;
    case eOS_Ver_mips:
        arch_name = " MIPS";
        break;
    case eOS_Ver_alpha:
        arch_name = " Alpha";
        break;
    }

    *str += os_name;
    *str += arch_name;
}

bool operator<(const CGBenchVersionInfo& v1, const CGBenchVersionInfo& v2)
{
    if (v1.GetVer_major() < v2.GetVer_major()) {
        return true;
    }
    if (v2.GetVer_major() < v1.GetVer_major()) {
        return false;
    }

    if (v1.GetVer_minor() < v2.GetVer_minor()) {
        return true;
    }
    if (v2.GetVer_minor() < v1.GetVer_minor()) {
        return false;
    }

    if (v1.GetVer_patch() < v2.GetVer_patch()) {
        return true;
    }
    if (v2.GetVer_patch() < v1.GetVer_patch()) {
        return false;
    }

    return false;
}

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 65, chars: 1911, CRC32: 1807b76f */
