/* $Id: GBenchFeedbackAttachment.cpp 21446 2010-05-27 14:53:02Z dicuccio $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'gui_objects.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <gui/objects/GBenchFeedbackAttachment.hpp>
#include <util/compress/zlib.hpp>
#include <util/compress/stream.hpp>
#include <connect/ncbi_conn_stream.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CGBenchFeedbackAttachment::~CGBenchFeedbackAttachment(void)
{
}

#if 0
static void s_Decompress(const vector<char>& data, string& str)
{
    CNcbiIstrstream strstr(&data[0], data.size());
    CZipStreamDecompressor proc(16384, 16384,
        15 /* window bits */,
        CZipCompression::fCheckFileHeader);
    CCompressionIStream istr(strstr, &proc);

    char buf[512];
    while ( !istr.fail() ) {
        istr.read(buf, sizeof(buf));
        str.append(buf, istr.gcount());
    }
}


static void s_Compress(CNcbiIstream& istr, vector<char>& data)
{
    CConn_MemoryStream mem_str;
    {{
        CZipStreamCompressor proc(CCompression::eLevel_Best,
            16384, 16384,
            15 /* window bits */,
            9  /* memory bits */,
            kZlibDefaultStrategy,
            CZipCompression::fWriteGZipFormat);
        CCompressionOStream ostr(mem_str, &proc);

        char buf[512];
        while (istr) {
            istr.read(buf, sizeof(buf));
            ostr.write(buf, istr.gcount());
        }
    }}
    mem_str.flush();

    data.resize(mem_str.tellp() - CT_POS_TYPE(0));
    mem_str.read(&data[0], data.size());
}
#endif

void CGBenchFeedbackAttachment::DecodeData( string& str ) const
{
    if( IsSetData() ){
        // s_Decompress( GetData(), str );
         const TData& data = GetData();

        CNcbiIstrstream strstr( &data[0], data.size() );
        CZipStreamDecompressor proc(
            16384, 16384,
            15 /* window bits */,
           CZipCompression::fCheckFileHeader
        );
        CCompressionIStream istr( strstr, &proc );

       char buf[512];
       while( !istr.fail() ){
           istr.read( buf, sizeof(buf) );
           str.append( buf, istr.gcount() );
       }
    }
}

void CGBenchFeedbackAttachment::EncodeData( const string& str )
{
    CNcbiIstrstream istr( str.data(), str.size() );
    EncodeData( istr );
}

void CGBenchFeedbackAttachment::EncodeData( CNcbiIstream& istr )
{
    //s_Compress( istr, SetData() );
    TData& data = SetData();

    CConn_MemoryStream mem_str;
    {{
        CZipStreamCompressor proc(
            CCompression::eLevel_Best,
            16384, 16384,
            15 /* window bits */,
            9  /* memory bits */,
            kZlibDefaultStrategy,
            CZipCompression::fWriteGZipFormat
        );
        CCompressionOStream ostr( mem_str, &proc );
        NcbiStreamCopy(ostr, istr);
        ostr.Finalize();
    }}
    mem_str.flush();

    data.resize( mem_str.tellp() - CT_POS_TYPE(0) );
    mem_str.read( &data[0], data.size() );
}

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1769, CRC32: 61048040 */
