/* $Id: GBProjectHandle.cpp 39250 2017-08-29 19:00:48Z katargir $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'gui_project.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

#include <serial/objistr.hpp>
#include <serial/serial.hpp>
#include <connect/ncbi_conn_stream.hpp>

#include <gui/objutils/label.hpp>
#include <gui/objutils/registry.hpp>

#include <gui/utils/id_generator.hpp>

#include <corelib/rwstream.hpp>
#include <serial/pack_string.hpp>
#include <serial/objostr.hpp>
#include <serial/iterator.hpp>
#include <objects/general/Dbtag.hpp>
#include <objects/general/Object_id.hpp>
#include <objects/seqfeat/Imp_feat.hpp>
#include <objects/seqfeat/Gb_qual.hpp>
#include <util/format_guess.hpp>

#include <corelib/ncbifile.hpp>

// generated includes
#include <gui/objects/GBProjectHandle.hpp>
#include <gui/objects/PluginMessage.hpp>
#include <objects/gbproj/LoaderDescriptor.hpp>


// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/// This class is intended to skip over plugin messages in
/// gbench projects that do not meet the current spec for a plugin message
class CReadHook_SkipError : public CReadObjectHook
{
public:
    CReadHook_SkipError(const string& msg, bool discard = true)
        : m_Message(msg)
        , m_Discard(discard)
    {
    }

    virtual void ReadObject(CObjectIStream& in, const CObjectInfo& info)
    {
        CStreamDelayBufferGuard guard(in);
        in.SkipAnyContentObject();
        CRef<CByteSource> bytes = guard.EndDelayBuffer();
        try {
            auto_ptr<CObjectIStream> tmp
                (CObjectIStream::Create(in.GetDataFormat(), *bytes));
            tmp->ReadObject(info);
        }
        catch (CException& e) {
            LOG_POST(Error << "Failed to read " << m_Message << ": " << e.what());
            if (m_Discard) {
                in.SetDiscardCurrObject();
            }
        }
    }

private:
    string m_Message;
    bool m_Discard;
};

typedef pair<CFormatGuess::EFormat, ESerialDataFormat> TSerialTypePair;
static const TSerialTypePair sc_DataTypes[] = {
    TSerialTypePair(CFormatGuess::eBinaryASN, eSerial_AsnBinary),
    TSerialTypePair(CFormatGuess::eTextASN, eSerial_AsnText),
    TSerialTypePair(CFormatGuess::eXml, eSerial_Xml)
};


template <class ProjectType>
CRef<ProjectType> ReadProject(CNcbiIstream& istr, const char* typeName, ICanceled* canceledCallback)
{
    CGuiRegistry& reg = CGuiRegistry::GetInstance();

    /// do we use memory pooling on deserialization?
    /// we have a compile-time constant as well as a config file override
    bool use_mempool =
#ifdef _DEBUG
        false;
#else
        true;
#endif
    use_mempool =
        reg.GetBool("GBENCH.Application.IO.UseMempool", use_mempool);

    /// should we pack strings?
    bool pack_strings =
        reg.GetBool("GBENCH.Application.IO.PackStrings", true);

    /// we try, in order, ASN.1 binary, ASN.1 text, and XML
    /// this is a different order from workspaces, and this
    /// is intentional.  For the release mode builds, binary ASN.1 projects
    /// will be written, so we try these first.  Debug mode will write
    /// ASN.1 text.
    CFormatGuess fg(istr);
    for (size_t i = 0;  i < sizeof(sc_DataTypes) / sizeof(TSerialTypePair);  ++i) {
        if (!fg.TestFormat(sc_DataTypes[i].first))
            continue;

        string errMsg = "ReadProject<";
        errMsg += typeName;
        errMsg += ">() : failed to read ";
        errMsg += CFormatGuess::GetFormatName(sc_DataTypes[i].first);

        try {
            CRef<ProjectType> project(new ProjectType());
            istr.clear();
            istr.seekg(0);
            auto_ptr<CObjectIStream> obj_istr
                (CObjectIStream::Open(sc_DataTypes[i].second, istr));

            if (canceledCallback)
                obj_istr->SetCanceledCallback(canceledCallback);

            /// memory profile optimization:
            /// we should use pooled strings to reduce the memory burden
            /// (from Eugene Vasilchenko)
            if (pack_strings) {
                CObjectTypeInfo info;
                info = CObjectTypeInfo(CType<CObject_id>());
                info.FindVariant("str")
                    .SetLocalReadHook(*obj_istr, new CPackStringChoiceHook);

                info = CObjectTypeInfo(CType<CImp_feat>());
                info.FindMember("key")
                    .SetLocalReadHook(*obj_istr, new CPackStringClassHook(32, 128));

                info = CObjectTypeInfo(CType<CDbtag>());
                info.FindMember("db")
                    .SetLocalReadHook(*obj_istr, new CPackStringClassHook);

                info = CType<CGb_qual>();
                info.FindMember("qual")
                    .SetLocalReadHook(*obj_istr, new CPackStringClassHook);
            }
            if (use_mempool) {
                obj_istr->UseMemoryPool();
            }

            /// add a read hook to track the reading of a plugin message
            /// we will permit a plugin message to be ill-formed
            /// in the case of an ill-formed object, we will ignore it
            CObjectTypeInfo msg_hook = CType<CPluginMessage>();
            CRef<CReadHook_SkipError> msg_hook_monitor
                (new CReadHook_SkipError("PluginMessage"));
            msg_hook.SetLocalReadHook(*obj_istr, msg_hook_monitor);

            /**
            CObjectTypeInfo item_hook = CType<CProjectItem>();
            CRef<CReadHook_SkipError> item_hook_monitor
                (new CReadHook_SkipError("ProjectItem"));
            item_hook.SetLocalReadHook(*obj_istr, item_hook_monitor);
            **/

            *obj_istr >> *project;
            return project;
        } NCBI_CATCH(errMsg);
    }

    return CRef<ProjectType>();
}


///////////////////////////////////////////////////////////
// label handler for genome workbench projects

class CGBDocumentLabelHandler : public ILabelHandler
{
public:
    void GetLabel(const CObject& obj, string* str,
                  CLabel::ELabelType type,
                  CScope* scope) const
    {
        const CGBProjectHandle* project = dynamic_cast<const CGBProjectHandle*>(&obj);
        if (project) {
            switch (type) {
            case CLabel::eUserType:
            case CLabel::eUserSubtype:
                *str += "CGBDocument - must not be shown";
                break;

            case CLabel::eType:
                *str += "Project";
                break;

            case CLabel::eDescriptionBrief:
            case CLabel::eDescription:
            case CLabel::eContent:
                if (project->IsLoaded()) {
                    string title;
                    if (project->GetDescr().IsSetTitle()) {
                        title = project->GetDescr().GetTitle();
                    } else {
                        ///
                        /// poke around in the internals
                        ///
                        const IGBProject& proj = project->GetProject();
                        const CGBProject* ver1 =
                            dynamic_cast<const CGBProject*>(&proj);
                        const CGBProject_ver2* ver2 =
                            dynamic_cast<const CGBProject_ver2*>(&proj);
                        if (ver1) {
                            CLabel::GetLabel(*ver1, &title, type, scope);
                        } else if (ver2) {
                            CLabel::GetLabel(*ver2, &title, type, scope);
                        }
                    }
                    if ( !title.empty() ) {
                        *str += title;
                    }
                } else {
                    /// unloaded - just report the file name
                    const string& fname = project->GetFilename();
                    if ( ! fname.empty() ) {
                        *str += fname;
                    } else {
                        *str += "(empty project)";
                    }
                }
                break;


            case CLabel::eUserTypeAndContent:
            default:
                {{
                    string type_str;
                    GetLabel(obj, &type_str, CLabel::eType, scope);
                    string content_str;
                    GetLabel(obj, &content_str, CLabel::eContent, scope);
                    *str += type_str;
                    if ( !type_str.empty()  &&  !content_str.empty() ) {
                        *str += ": ";
                    }
                    if ( !content_str.empty() ) {
                        *str += content_str;
                    }
                }}
                break;
            }
        }
    }
};

//////////////////////////////////////////////////////////////////////////////////////
/// CGBProjectHandle
CAtomicCounter CGBProjectHandle::sm_Counter;

CGBProjectHandle::TId CGBProjectHandle::sm_NullId = 0;

CGBProjectHandle::CGBProjectHandle(void)
    : m_Dirty(false)
    , m_Loaded(false)
{
    //m_Id = GetNextId();
    if ( !CLabel::HasHandler(*CGBProjectHandle::GetTypeInfo()) ) {
        CLabel::RegisterLabelHandler(*CGBProjectHandle::GetTypeInfo(),
                                     *new CGBDocumentLabelHandler());
    }

    SetFilename("");
}

CGBProjectHandle::CGBProjectHandle(CGBProject_ver2& proj_impl)
    : m_Dirty(false)
    , m_Loaded(true)
{
    m_Project = &proj_impl;
    //m_Id = GetNextId();

    if ( !CLabel::HasHandler(*CGBProjectHandle::GetTypeInfo()) ) {
        CLabel::RegisterLabelHandler(*CGBProjectHandle::GetTypeInfo(),
                                     *new CGBDocumentLabelHandler());
    }

    SetFilename("");
    x_LinkChildFolders(SetData());
}


CGBProjectHandle::~CGBProjectHandle(void)
{
}


const IGBProject& CGBProjectHandle::GetProject() const
{
    _ASSERT(m_Project);
    return m_Project.GetObject();
}


IGBProject& CGBProjectHandle::SetProject()
{
    // this function shall not create projects "on first use";
    // projects must be created explicitly!
    _ASSERT(m_Project);
    return m_Project.GetObject();
}


void CGBProjectHandle::SetScope(CScope* scope)
{
    _ASSERT(m_Scope.GetPointer() == NULL);
    _ASSERT(m_Project);
    m_Scope.Reset(scope);
}


CScope* CGBProjectHandle::GetScope() const
{
    return const_cast<CScope*>(m_Scope.GetPointer());
}


CGBProjectHandle::TId CGBProjectHandle::GetId() const
{
    return m_Id;
}


CGBProjectHandle::TId CGBProjectHandle::GetNextId()
{
    TId id = sm_Counter.Add(1);
    LOG_POST(Info << "CGBProjectHandle::GetNextId() " << id);
    return id;
}


bool CGBProjectHandle::IsLoaded() const
{
    return (m_Loaded.Get() != 0);
}

void CGBProjectHandle::SetLoaded(bool loaded)
{
    m_Loaded.Set(1);
}

bool CGBProjectHandle::IsDirty() const
{
    if (m_Loaded.Get() == 0)
        return false;

    return m_Project && (m_Dirty || m_DataModified);
}


void CGBProjectHandle::SetDirty(bool dirty)
{
    // SetFileName can be called on not loaded project 
    // _ASSERT(m_Project);

    if(m_Project)   {
        m_Dirty = dirty;

        if (dirty)
            m_Project->SetModifiedDate(CTime(CTime::eCurrent));
        else
            m_DataModified = false;
    }
}


bool CGBProjectHandle::GetDataModified() const
{
    if (m_Loaded.Get() == 0)
        return false;

    return m_Project &&  m_DataModified;
}


void CGBProjectHandle::SetDataModified(bool modified)
{
    if (m_Project)   {
        m_DataModified = modified;

        if (modified)
            m_Project->SetModifiedDate(CTime(CTime::eCurrent));
    }
}


/// retrieve our project's descriptor set
const CProjectDescr& CGBProjectHandle::GetDescr() const
{
    return GetProject().GetDescr();
}


CProjectDescr& CGBProjectHandle::SetDescr()
{
    return SetProject().SetDescr();
}


// Get a description of our contents.
// This is suitable for display in a GUI component such as a list view.
const string& CGBProjectHandle::GetTitle(void) const
{
    m_Title.erase();
    const CObject* obj = dynamic_cast<const CObject*>(m_Project.GetPointer());
    if (obj) {
        CLabel::GetLabel(*obj, &m_Title, CLabel::eDefault, GetScope());
    }
    return m_Title;
}


const string& CGBProjectHandle::GetShortTitle(void) const
{
    m_ShortTitle.erase();
    const CObject* obj = dynamic_cast<const CObject*>(m_Project.GetPointer());
    CLabel::GetLabel(*obj, &m_ShortTitle, CLabel::eDefault, GetScope());
    return m_ShortTitle;
}


bool CGBProjectHandle::Load(CNcbiIstream& istr, ICanceled* canceledCallback)
{
    /// try to read version 2 first
    {{
            CRef<CGBProject_ver2> ver2 = ReadProject<CGBProject_ver2>(istr, "CGBProject_ver2", canceledCallback);
        if (ver2) {
            m_Project.Reset(ver2.GetPointer());
            SetDirty(false);
            x_LinkChildFolders(SetData());
            x_FixIdGenerator(*ver2);
            return true;
        }
    }}

    /// now try to read version 1
    {{
        CRef<CGBProject> ver1 = ReadProject<CGBProject>(istr, "CGBProject", canceledCallback);
        if (ver1) {
            /// convert to version-2

            CRef<CGBProject_ver2> ver2(new CGBProject_ver2);
            ver2->SetCounter(ver1->GetCounter());
            ver2->SetDescr(ver1->SetDescr());
            ver2->SetData().SetItems()
                .push_back(CRef<CProjectItem>(&ver1->SetCore()));
            if (ver1->IsSetExtra()) {
                if (ver1->GetExtra().IsSetFolders()) {
                    NON_CONST_ITERATE (CProjectFolder::TFolders, iter, ver1->SetExtra().SetFolders()) {
                        ver2->SetData().SetFolders().push_back(*iter);
                    }
                }

                if (ver1->GetExtra().IsSetItems()) {
                    NON_CONST_ITERATE (CProjectFolder::TItems, iter, ver1->SetExtra().SetItems()) {
                        ver2->SetData().SetItems().push_back(*iter);
                    }
                }
            }
            if (ver1->IsSetOrig_message()) {
                // Orig_message is ingored intentionally after removal of
                // 'orig-message PluginMessage' from GBProject-ver2.
                //ver2->SetOrig_message(ver1->SetOrig_message());
            }
            if (ver1->IsSetHistory()) {
                ver2->SetHistory().swap(ver1->SetHistory());
            }
            if (ver1->IsSetData_plugin()) {
                ver2->SetData_plugin(ver1->SetData_plugin());
            }
            if (ver1->IsSetPlugin_param()) {
                ver2->SetPlugin_param(ver1->SetPlugin_param());
            }
            if (ver1->IsSetAnnot()) {
                ver2->SetAnnot().swap(ver1->SetAnnot());
            }

            /// save the project
            m_Project.Reset(ver2.GetPointer());
            SetDirty(false);
            x_LinkChildFolders(SetData());
            return true;
        }
    }}
    return false;
}


void CGBProjectHandle::Save(CNcbiOstream& ostr, ESerialDataFormat fmt) const
{
    auto_ptr<CObjectOStream> os(CObjectOStream::Open(fmt, ostr));

    const IGBProject& project = GetProject();
    switch (project.GetVersion()) {
    case IGBProject::eVersion1:
        *os << dynamic_cast<const CGBProject&>(project);
        break;

    case IGBProject::eVersion2:
        *os << dynamic_cast<const CGBProject_ver2&>(project);
        break;

    default:
        _ASSERT(false);
        NCBI_THROW(CException, eUnknown, "Unknown project version");
        break;
    }

    /// shut 'er down cleanly
    /// if we rely on destructors, we never see the exception
    os->Close();
    ostr.flush();
    if ( ! ostr) {
        NCBI_THROW(CException, eUnknown, "stream write failure");
    } else {
        CGBProjectHandle* nc_this = const_cast<CGBProjectHandle*>(this);
        nc_this->SetDirty(false);
    }
}


void CGBProjectHandle::Clear(void)
{
    m_Loaded.Set(0);
    m_Project.Reset();
    m_Scope.Reset();
}


bool CGBProjectHandle::IsProjectItemLabelUnique(const string& label) const
{
    const CProjectFolder& data = GetData();
    // TODO - iterator
    for ( CTypeConstIterator<CProjectItem> it(data);  it;  ++it) {
        const string& s = it->GetLabel();
        if(s == label)
            return false;
    }
    return true;
}


string CGBProjectHandle::MakeUniqueItemLabel(const string& label) const
{
    CUniqueLabelGenerator generator;
    const CProjectFolder& data = GetData();
    // TODO - iterator
    for ( CTypeConstIterator<CProjectItem> it(data);  it;  ++it) {
        const string& s = it->GetLabel();
        generator.AddExistingLabel(s);
    }
    return generator.MakeUniqueLabel(label);
}


// folder labels is not stored in m_LabelsSet and should be unique in the scope
// of its parent folder
string CGBProjectHandle::MakeUniqueFolderLabel(const string& label,
                                               CProjectFolder& parent_folder)  const
{
    CUniqueLabelGenerator generator;
    if(parent_folder.CanGetFolders())   {
        ITERATE(CProjectFolder::TFolders, it, parent_folder.GetFolders())   {
            const string& s = (*it)->GetInfo().GetTitle();
            generator.AddExistingLabel(s);
        }
    }
    return generator.MakeUniqueLabel(label);
}


string CGBProjectHandle::MakeUniqueDataLoaderLabel(const string& label) const
{
    CUniqueLabelGenerator generator;
    if (m_Project->IsSetDataLoaders()) {
        ITERATE (IGBProject::TDataLoaders, iter, m_Project->GetDataLoaders()) {
            const string& s = (*iter)->GetLabel();
            generator.AddExistingLabel(s);
        }
    }
    return generator.MakeUniqueLabel(label);

}


/// retrieve this project's version
/// this is fixed per subclass
IGBProject::EProjectVersion CGBProjectHandle::GetVersion() const
{
    return GetProject().GetVersion();
}


void CGBProjectHandle::AddDataLoader(CLoaderDescriptor& loader)
{
    m_Project->SetDataLoaders().push_back(CRef<CLoaderDescriptor>(&loader));
}


const CGBProjectHandle::TDataLoaders& CGBProjectHandle::GetDataLoaders() const
{
    return m_Project->GetDataLoaders();
}


CGBProjectHandle::TDataLoaders& CGBProjectHandle::GetDataLoaders()
{
    return m_Project->SetDataLoaders();
}


CRef<CLoaderDescriptor> CGBProjectHandle::FindDataLoaderByLabel(const string& label)
{
    CRef<CLoaderDescriptor> loader;
    if (m_Project->IsSetDataLoaders()) {
        NON_CONST_ITERATE (IGBProject::TDataLoaders,
                           iter, m_Project->SetDataLoaders()) {
            if ((*iter)->GetLabel() == label) {
                loader = *iter;
                break;
            }
        }
    }
    return loader;
}

CProjectFolder* CGBProjectHandle::FindProjectFolderById(CProjectFolder::TId id)
{
    CProjectFolder& data_folder = SetData();
    if (data_folder.GetId() == id)
        return &data_folder;
    return data_folder.FindChildFolderById(id);
}

CProjectItem* CGBProjectHandle::FindProjectItemById(CProjectItem::TId id)
{
    return SetData().FindProjectItemById(id);
}

string CGBProjectHandle::GetViewSettings(const string& view_type,
                                         const string& view_ins_id) const
{
    string settings;
    if (m_Project->IsSetViewSettings()) {
        ITERATE (IGBProject::TViewSettings, iter, m_Project->GetViewSettings()) {
            if ((*iter)->GetType().IsStr()  &&
                (*iter)->GetType().GetStr() == view_type) {
                CConstRef<CUser_field> field = (*iter)->GetFieldRef(view_ins_id);
                if (field) {
                    settings = field->GetData().GetStr();
                }
                break;
            }
        }
    }
    return settings;
}


void CGBProjectHandle::SaveViewSettings(const string& view_type,
                                        const string& view_ins_id,
                                        const string& settings)
{
    CRef<CUser_object> obj;
    if (m_Project->IsSetViewSettings()) {
        // first check if there is settings for this view type
        NON_CONST_ITERATE (IGBProject::TViewSettings, iter, m_Project->SetViewSettings()) {
            if ((*iter)->GetType().IsStr()  &&
                (*iter)->GetType().GetStr() == view_type) {
                obj = *iter;
                break;
            }
        }
    }
    if ( !obj ) {
        obj.Reset(new CUser_object);
        obj->SetType().SetStr(view_type);
        m_Project->SetViewSettings().push_back(obj);
    }

    CUser_field& field = obj->SetField(view_ins_id);
    field.SetData().SetStr(settings);
}


void CGBProjectHandle::AddItem(CProjectItem& item, CProjectFolder& folder)
{
    m_Project->AddItem(item, folder);
}


/// retrieve our project's data, in the form of a project folder
/// this may be a contrived entity, and it is up to a project to determine
/// what parts belong where
const CProjectFolder& CGBProjectHandle::GetData() const
{
    return GetProject().GetData();
}


CProjectFolder& CGBProjectHandle::SetData()
{
    return SetProject().SetData();
}


/// retrieve a set of annotations for this project
bool CGBProjectHandle::IsSetAnnot() const
{
    return GetProject().IsSetAnnot();
}


const IGBProject::TAnnot& CGBProjectHandle::GetAnnot() const
{
    return GetProject().GetAnnot();
}


IGBProject::TAnnot& CGBProjectHandle::SetAnnot()
{
    return SetProject().SetAnnot();
}


void CGBProjectHandle::SetCreateDate(const CDate& date)
{
    SetProject().SetCreateDate(date);
}


void CGBProjectHandle::SetModifiedDate(const CDate& date)
{
    SetProject().SetModifiedDate(date);
}


// updates links to Parent Folder in Project Folders and Items
void CGBProjectHandle::x_LinkChildFolders(CProjectFolder& folder)
{
    if(folder.CanGetItems())    {
        CProjectFolder::TItems& items = folder.SetItems();
        NON_CONST_ITERATE(CProjectFolder::TItems, it, items)    {
            CProjectItem& item = **it;
            if( ! item.CanGetLabel())  {
				CLabel::SetLabelByData(item);
            }
        }
    }
    if(folder.CanGetFolders())  {
        CProjectFolder::TFolders& folders = folder.SetFolders();
        NON_CONST_ITERATE(CProjectFolder::TFolders, it, folders)    {
            CProjectFolder& sub_folder = **it;
            x_LinkChildFolders(sub_folder);
        }
    }
}

void CGBProjectHandle::x_FixIdGenerator(CGBProject_ver2& project)
{
    int counter = 0;
    CTypeConstIterator<CProjectItem> item_iter(project.GetData());
    for (;  item_iter;  ++item_iter) {
        const CProjectItem& item = *item_iter;
        counter = max(counter, item.GetId());
    }
    ++counter;
    if (!project.IsSetCounter() || project.GetCounter() < counter) {
        project.SetCounter(counter);
    }
}

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1754, CRC32: 1289f084 */
