/* $Id: GBProject.cpp 28756 2013-08-23 17:44:43Z wuliangs $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'gui_project.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

#include <corelib/ncbitime.hpp>

#include <gui/objutils/label.hpp>
#include <gui/objutils/user_type.hpp>

// generated includes
#include <gui/objects/GBProject.hpp>
#include <objects/gbproj/GBProject_ver2.hpp>
#include <objects/gbproj/ProjectItem.hpp>
#include <objects/gbproj/ProjectDescr.hpp>
#include <objects/gbproj/ProjectFolder.hpp>
#include <objects/gbproj/FolderInfo.hpp>
#include <objects/general/Date.hpp>
#include <objects/seq/Annotdesc.hpp>
#include <serial/iterator.hpp>

#include <algorithm>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::




class CGBProjectLabelHandler : public ILabelHandler
{
public:
    void GetLabel(const CObject& obj, string* str,
                  CLabel::ELabelType type,
                  objects::CScope* scope) const
    {
        const CGBProject* proj = dynamic_cast<const CGBProject*>(&obj);
        if (proj) {
            switch (type) {
            case CLabel::eUserType:
                *str += CGUIUserType::sm_Tp_Project;
                break;

            case CLabel::eUserSubtype:
                *str += CGUIUserType::sm_SbTp_ProjectVer1;
                break;

            case CLabel::eType:
                *str += "Project (ver.1)";
                break;

            case CLabel::eDescriptionBrief:
            case CLabel::eContent:
                {{
                    string title;
                    if (proj->IsSetDescr()  &&  proj->GetDescr().IsSetTitle()) {
                        title = proj->GetDescr().GetTitle();
                    }

                    if ( !title.empty() ) {
                        *str += title;
                    } else if (proj->IsSetCore()) {
                        CTypeConstIterator<CProjectItem> iter(proj->GetCore());

                        string s;
                        for ( ;  iter;  ++iter) {
                            if ( !s.empty() ) {
                                s += ", ";
                            }
                            CLabel::GetLabel(*iter, &s, type, scope);
                        }
                        *str += s;
                    }
                }}
                break;

            case CLabel::eDescription:
            case CLabel::eUserTypeAndContent:
                {{
                    string type_str;
                    GetLabel(obj, &type_str, CLabel::eType, scope);
                    string content_str;
                    GetLabel(obj, &content_str, CLabel::eType, scope);
                    *str += type_str;
                    if ( !type_str.empty()  &&  !content_str.empty() ) {
                        *str += ": ";
                    }
                    if ( !content_str.empty() ) {
                        *str += content_str;
                    }
                }}
                break;

            default:
                break;
            }
        }
    }
};


CGBProject::CGBProject(void)
{
    if ( !CLabel::HasHandler(*CGBProject::GetTypeInfo()) ) {
        CLabel::RegisterLabelHandler(*CGBProject::GetTypeInfo(),
                                     *new CGBProjectLabelHandler());
    }

    CRef<CProjectFolder> folder(new CProjectFolder());
    CFolderInfo& info = folder->SetInfo();
    info.SetTitle("Supplementary Data");
    info.SetCreate_date(SetDescr().SetCreate_date());

    SetExtra(*folder);
}


CGBProject::~CGBProject(void)
{
}


void CGBProject::Lock()
{
    m_Mutex.Lock();
}


void CGBProject::Unlock()
{
    m_Mutex.Unlock();
}


void CGBProject::SetScope(CScope* scope)
{
    _ASSERT(m_Scope.GetPointer() == NULL);
    m_Scope.Reset(scope);
}


CScope* CGBProject::GetScope()
{
    return m_Scope.GetPointer();
}


/// retrieve the folders containing our project items
const CProjectFolder& CGBProject::GetData() const
{
    if ( !m_Folders ) {
        m_Folders.Reset(new CProjectFolder());
        CFolderInfo& info = m_Folders->SetInfo();
        info.SetTitle("Data");
        info.SetComment("Default folder for Project Items");
        info.SetCreateDate(CTime(CTime::eCurrent));

        CRef<CProjectItem> item
            (const_cast<CProjectItem*>(&GetCore()));
        m_Folders->SetItems().push_back(item);

        if (IsSetExtra()  &&  GetExtra().IsSetFolders()) {
            const CProjectFolder& extra = GetExtra();
            ITERATE (CProjectFolder::TFolders, iter, extra.GetFolders()) {
                CRef<CProjectFolder> f = *iter;
                m_Folders->SetFolders().push_back(f);
            }
        }

        if (IsSetExtra()  &&  GetExtra().IsSetItems()) {
            const CProjectFolder& extra = GetExtra();
            ITERATE (CProjectFolder::TItems, iter, extra.GetItems()) {
                CRef<CProjectItem> i = *iter;
                m_Folders->SetItems().push_back(i);
            }
        }
    }
    return *m_Folders;
}


CProjectFolder& CGBProject::SetData()
{
    GetData();
    return *m_Folders;
}



/// retrieve the descriptor set for this project
bool CGBProject::IsSetDescr() const
{
    return Tparent::IsSetDescr();
}


const CProjectDescr& CGBProject::GetDescr() const
{
    return Tparent::GetDescr();
}


CProjectDescr& CGBProject::SetDescr()
{
    return Tparent::SetDescr();
}


/// retrieve the descriptor set for this project
bool CGBProject::IsSetAnnot() const
{
    return Tparent::IsSetAnnot();
}


const IGBProject::TAnnot& CGBProject::GetAnnot() const
{
    return Tparent::GetAnnot();
}


IGBProject::TAnnot& CGBProject::SetAnnot()
{
    return Tparent::SetAnnot();
}


bool CGBProject::IsSetDataLoaders() const
{
    return Tparent::IsSetLoaders();
}


const CGBProject::TDataLoaders& CGBProject::GetDataLoaders() const
{
    return Tparent::GetLoaders();
}


CGBProject::TDataLoaders& CGBProject::SetDataLoaders()
{
    return Tparent::SetLoaders();
}


/// retrieve the descriptor set for this project
bool CGBProject::IsSetViews() const
{
    return Tparent::IsSetViews();
}


const IGBProject::TViews& CGBProject::GetViews() const
{
    return Tparent::GetViews();
}


IGBProject::TViews& CGBProject::SetViews()
{
    return Tparent::SetViews();
}



void CGBProject::AddItem(CProjectItem& item, CProjectFolder& folder)
{
    // first, set the ID to the next available
    item.SetId(GetCounter());
    SetCounter(GetCounter() + 1);

    folder.AddChildItem(item);
}


CProjectFolder* CGBProject::x_GetContainingFolder(CProjectFolder& root,
                                                  CProjectItem& item)
{
    NON_CONST_ITERATE(CProjectFolder::TItems, it, root.SetItems())  {
        if(it->GetPointer() == &item)   {
            return &root;
        }
    }
    // recursively looking child folders
    NON_CONST_ITERATE(CProjectFolder::TFolders, it, root.SetFolders())  {
        CProjectFolder& folder = **it;
        CProjectFolder* res = x_GetContainingFolder(folder, item);
        if(res) {
            return res;
        }
    }
    return NULL;
}


/*void CGBProject::RemoveItem(CProjectItem& item)
{
    CRef<CProjectItem> del_item(&item);

    //TODO do we need to look in Extra
    CProjectFolder* parent_folder = x_GetContainingFolder(SetData(), item);
    if (parent_folder)  {
        parent_folder->RemoveChildItem(item);
        CProjectFolder::TItems& items = parent_folder->SetItems();
    } else {
        NCBI_THROW(CException, eUnknown, "Failed to find project item in project");
    }
}
*/

void CGBProject::SetCreateDate(const CDate& date)
{
    SetDescr().SetCreate_date().Assign(date);
}


void CGBProject::SetModifiedDate(const CDate& date)
{
    SetDescr().SetModified_date().Assign(date);
}



END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 65, chars: 1888, CRC32: 92b5da2 */
