/*  $Id: event_record_details_dlg.cpp 31805 2014-11-17 16:56:57Z katargir $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Authors:
 *
 * File Description:
 *
 */

#include <ncbi_pch.hpp>

#include <gui/framework/event_record_details_dlg.hpp>
#include <gui/widgets/wx/wx_utils.hpp>


#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/icon.h>
#include <wx/bitmap.h>

BEGIN_NCBI_SCOPE


IMPLEMENT_DYNAMIC_CLASS( CEventRecordDetailsDlg, wxDialog )

BEGIN_EVENT_TABLE( CEventRecordDetailsDlg, wxDialog )
////@begin CEventRecordDetailsDlg event table entries
////@end CEventRecordDetailsDlg event table entries
END_EVENT_TABLE()

CEventRecordDetailsDlg::CEventRecordDetailsDlg()
{
    Init();
}

CEventRecordDetailsDlg::CEventRecordDetailsDlg( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
    Init();
    Create(parent, id, caption, pos, size, style);
}

bool CEventRecordDetailsDlg::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin CEventRecordDetailsDlg creation
    SetExtraStyle(wxWS_EX_BLOCK_EVENTS);
    wxDialog::Create( parent, id, caption, pos, size, style );

    CreateControls();
    if (GetSizer())
    {
        GetSizer()->SetSizeHints(this);
    }
    Centre();
////@end CEventRecordDetailsDlg creation
    return true;
}

CEventRecordDetailsDlg::~CEventRecordDetailsDlg()
{
////@begin CEventRecordDetailsDlg destruction
////@end CEventRecordDetailsDlg destruction
}

void CEventRecordDetailsDlg::Init()
{
////@begin CEventRecordDetailsDlg member initialisation
    m_HTMLWindow = NULL;
////@end CEventRecordDetailsDlg member initialisation
}

void CEventRecordDetailsDlg::CreateControls()
{
////@begin CEventRecordDetailsDlg content construction
    // Generated by DialogBlocks, Sat 16 Feb 2008 10:03:59 AM EST (unregistered)

    CEventRecordDetailsDlg* itemDialog1 = this;

    wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxVERTICAL);
    itemDialog1->SetSizer(itemBoxSizer2);

    m_HTMLWindow = new wxHtmlWindow( itemDialog1, ID_HTMLWINDOW1, wxDefaultPosition, wxSize(320, 140), wxHW_SCROLLBAR_AUTO|wxSUNKEN_BORDER|wxHSCROLL|wxVSCROLL );
    itemBoxSizer2->Add(m_HTMLWindow, 1, wxGROW|wxALL, 5);

    wxButton* itemButton4 = new wxButton( itemDialog1, wxID_OK, wxT("&Close"), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer2->Add(itemButton4, 0, wxALIGN_RIGHT|wxALL, 5);

////@end CEventRecordDetailsDlg content construction
}

bool CEventRecordDetailsDlg::ShowToolTips()
{
    return true;
}

wxBitmap CEventRecordDetailsDlg::GetBitmapResource( const wxString& name )
{
    // Bitmap retrieval
////@begin CEventRecordDetailsDlg bitmap retrieval
    wxUnusedVar(name);
    return wxNullBitmap;
////@end CEventRecordDetailsDlg bitmap retrieval
}


wxIcon CEventRecordDetailsDlg::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin CEventRecordDetailsDlg icon retrieval
    wxUnusedVar(name);
    return wxNullIcon;
////@end CEventRecordDetailsDlg icon retrieval
}


void CEventRecordDetailsDlg::SetRecord(const IEventRecord& record)
{
    m_Record.Reset(&record);

    string s = "<b>" + m_Record->GetTitle() + "</b><br />";
    s += m_Record->GetDescription() + "<br /><br />";

    m_HTMLWindow->SetPage(ToWxString(s));
}

END_NCBI_SCOPE
