/*  $Id: app_packages_dlg.cpp 43083 2019-05-13 19:26:43Z katargir $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Authors:  Roman Katargin
 *
 * File Description:
 *
 */

#include <ncbi_pch.hpp>

////@begin includes
#include "wx/imaglist.h"
////@end includes

#include <gui/framework/app_packages_dlg.hpp>
#include <gui/framework/pkg_manager.hpp>
#include <gui/framework/GuiPkgDependency.hpp>
#include <gui/framework/GuiDependentPkg.hpp>
#include <gui/widgets/wx/wx_utils.hpp>

#include <corelib/ncbidll.hpp>

#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/bitmap.h>
#include <wx/icon.h>
#include <wx/checkbox.h>
#include <wx/msgdlg.h>
#include <wx/sstream.h>
#include <wx/txtstrm.h>

BEGIN_NCBI_SCOPE

////@begin XPM images
////@end XPM images

IMPLEMENT_DYNAMIC_CLASS( CAppPackagesDlg, CDialog )

BEGIN_EVENT_TABLE( CAppPackagesDlg, CDialog )

////@begin CAppPackagesDlg event table entries
    EVT_LIST_ITEM_SELECTED( ID_LISTCTRL1, CAppPackagesDlg::OnPackageSelected )
    EVT_CHECKBOX( ID_CHECKBOX1, CAppPackagesDlg::OnShowInvalidPkgs )
    EVT_CHECKBOX( ID_CHECKBOX2, CAppPackagesDlg::OnEnablePkg )
    EVT_BUTTON( wxID_OK, CAppPackagesDlg::OnOkClick )
////@end CAppPackagesDlg event table entries

END_EVENT_TABLE()

CAppPackagesDlg::CAppPackagesDlg() : m_PkgManager()
{
    Init();
}

CAppPackagesDlg::CAppPackagesDlg( wxWindow* parent, CPkgManager* pkgManager, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
    : m_PkgManager(pkgManager)
{
    Init();
    Create(parent, id, caption, pos, size, style);
}

bool CAppPackagesDlg::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin CAppPackagesDlg creation
    SetExtraStyle(wxWS_EX_BLOCK_EVENTS);
    CDialog::Create( parent, id, caption, pos, size, style );

    CreateControls();
    if (GetSizer())
    {
        GetSizer()->SetSizeHints(this);
    }
    Centre();
////@end CAppPackagesDlg creation
    return true;
}

CAppPackagesDlg::~CAppPackagesDlg()
{
////@begin CAppPackagesDlg destruction
////@end CAppPackagesDlg destruction
}

void CAppPackagesDlg::Init()
{
////@begin CAppPackagesDlg member initialisation
    m_PkgList = NULL;
    m_PkgInfo = NULL;
    m_PkgEnable = NULL;
////@end CAppPackagesDlg member initialisation
}

void CAppPackagesDlg::CreateControls()
{
////@begin CAppPackagesDlg content construction
    // Generated by DialogBlocks, 13/05/2019 15:23:06 (unregistered)

    CAppPackagesDlg* itemCDialog1 = this;

    wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxVERTICAL);
    itemCDialog1->SetSizer(itemBoxSizer2);

    wxBoxSizer* itemBoxSizer3 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer2->Add(itemBoxSizer3, 1, wxGROW|wxALL, 0);

    wxBoxSizer* itemBoxSizer4 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer3->Add(itemBoxSizer4, 2, wxGROW|wxALL, 0);

    m_PkgList = new wxListCtrl( itemCDialog1, ID_LISTCTRL1, wxDefaultPosition, wxDLG_UNIT(itemCDialog1, wxSize(120, 110)), wxLC_REPORT|wxLC_SINGLE_SEL );
    itemBoxSizer4->Add(m_PkgList, 1, wxGROW|wxALL, wxDLG_UNIT(itemCDialog1, wxSize(5, -1)).x);

    wxCheckBox* itemCheckBox6 = new wxCheckBox( itemCDialog1, ID_CHECKBOX1, _("Show invalid packages"), wxDefaultPosition, wxDefaultSize, 0 );
    itemCheckBox6->SetValue(false);
    itemBoxSizer4->Add(itemCheckBox6, 0, wxALIGN_LEFT|wxALL, wxDLG_UNIT(itemCDialog1, wxSize(5, -1)).x);

    wxBoxSizer* itemBoxSizer7 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer3->Add(itemBoxSizer7, 3, wxGROW|wxALL, 0);

    m_PkgInfo = new wxTextCtrl( itemCDialog1, ID_TEXTCTRL1, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE|wxTE_READONLY );
    itemBoxSizer7->Add(m_PkgInfo, 1, wxGROW|wxALL, wxDLG_UNIT(itemCDialog1, wxSize(5, -1)).x);

    m_PkgEnable = new wxCheckBox( itemCDialog1, ID_CHECKBOX2, _("Enable"), wxDefaultPosition, wxDefaultSize, 0 );
    m_PkgEnable->SetValue(false);
    itemBoxSizer7->Add(m_PkgEnable, 0, wxALIGN_LEFT|wxALL, wxDLG_UNIT(itemCDialog1, wxSize(5, -1)).x);

    wxStaticLine* itemStaticLine10 = new wxStaticLine( itemCDialog1, wxID_STATIC, wxDefaultPosition, wxDefaultSize, wxLI_HORIZONTAL );
    itemBoxSizer2->Add(itemStaticLine10, 0, wxGROW|wxALL, wxDLG_UNIT(itemCDialog1, wxSize(5, -1)).x);

    wxStdDialogButtonSizer* itemStdDialogButtonSizer11 = new wxStdDialogButtonSizer;

    itemBoxSizer2->Add(itemStdDialogButtonSizer11, 0, wxALIGN_RIGHT|wxALL, wxDLG_UNIT(itemCDialog1, wxSize(5, -1)).x);
    wxButton* itemButton12 = new wxButton( itemCDialog1, wxID_OK, _("&OK"), wxDefaultPosition, wxDefaultSize, 0 );
    itemStdDialogButtonSizer11->AddButton(itemButton12);

    wxButton* itemButton13 = new wxButton( itemCDialog1, wxID_CANCEL, _("&Cancel"), wxDefaultPosition, wxDefaultSize, 0 );
    itemStdDialogButtonSizer11->AddButton(itemButton13);

    itemStdDialogButtonSizer11->Realize();

////@end CAppPackagesDlg content construction

    m_PkgList->InsertColumn(0, wxT("Package"));
    m_PkgList->InsertColumn(1, wxT("Status"));

    x_LoadPkgList(true);
}

void CAppPackagesDlg::x_LoadPkgList(bool firstTime)
{
    m_CurPkg.clear();

    wxCheckBox* itemCheckBox1 = (wxCheckBox*)FindWindow(ID_CHECKBOX1);
    bool showInvalid = itemCheckBox1->GetValue();

    m_PkgList->DeleteAllItems();
    m_PkgInfo->ChangeValue(wxT(""));
    wxCheckBox* itemCheckBox2 = (wxCheckBox*)FindWindow(ID_CHECKBOX2);
    itemCheckBox2->Enable(false);
    itemCheckBox2->SetValue(false);

    long pkg_num = 0;
    ITERATE (CPkgManager, it, *m_PkgManager) {
        const CPackageInfo& pkg_info = it->second;
        if (!showInvalid && pkg_info.m_State == CPackageInfo::eNotValid)
            continue;

        const objects::CGuiPkgManifest* manifest = pkg_info.m_Manifest.GetPointer();
        if (manifest) {
            long index = m_PkgList->InsertItem(m_PkgList->GetItemCount(),
                                               ToWxString(manifest->GetName()));

            switch(pkg_info.m_State) {
            case CPackageInfo::eValidated :
                m_PkgList->SetItem(index, 1, wxT("Not loaded"));
                break;
            case CPackageInfo::eLoaded :
                m_PkgList->SetItem(index, 1, wxT("Loaded"));
                break;
            case CPackageInfo::eNotValid :
                m_PkgList->SetItem(index, 1, wxT("Not valid"));
                break;
            default :
                m_PkgList->SetItem(index, 1, wxT("Undefined"));
                break;
            }

            m_PkgList->SetItemData(index, pkg_num);

            if (firstTime && pkg_info.m_State == CPackageInfo::eLoaded)
                m_EnabledPkgs.insert(it->first);
        }
        else {
            long index = m_PkgList->InsertItem(0, ToWxString(it->first));
            m_PkgList->SetItem(index, 1, wxT("App"));
            m_PkgList->SetItemData(index, pkg_num);
        }
        ++pkg_num;
    }
    m_PkgList->SetColumnWidth(0, wxLIST_AUTOSIZE);
}

bool CAppPackagesDlg::ShowToolTips()
{
    return true;
}
wxBitmap CAppPackagesDlg::GetBitmapResource( const wxString& name )
{
    // Bitmap retrieval
////@begin CAppPackagesDlg bitmap retrieval
    wxUnusedVar(name);
    return wxNullBitmap;
////@end CAppPackagesDlg bitmap retrieval
}
wxIcon CAppPackagesDlg::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin CAppPackagesDlg icon retrieval
    wxUnusedVar(name);
    return wxNullIcon;
////@end CAppPackagesDlg icon retrieval
}

void CAppPackagesDlg::OnPackageSelected( wxListEvent& event )
{
    int index = event.GetIndex();
    int pkg_num = (int)m_PkgList->GetItemData(index);
    string pkg_name;
    const CPackageInfo* pkg_info = m_PkgManager->GetPkgInfo(pkg_num, pkg_name);

    m_CurPkg = pkg_name;

    string version = "Version: ";
    string descr = "Description: ";
    wxCheckBox* itemCheckBox = (wxCheckBox*)FindWindow(ID_CHECKBOX2);

    if (!pkg_info) {
        m_PkgInfo->ChangeValue(wxT(""));
        itemCheckBox->SetValue(false);
        itemCheckBox->Enable(false);
    }
    else {
        wxStringOutputStream strstr;
        wxTextOutputStream os(strstr);
        x_DumpPkgInfo(os, pkg_name, *pkg_info);
        m_PkgInfo->ChangeValue(strstr.GetString());

        const objects::CGuiPkgManifest* manifest = pkg_info->m_Manifest.GetPointer();
        if (!manifest) { // Application
            itemCheckBox->Enable(false);
            itemCheckBox->SetValue(true);
        }
        else {
            switch(pkg_info->m_State) {
            case CPackageInfo::eValidated :
            case CPackageInfo::eLoaded :
                itemCheckBox->Enable(true);
                itemCheckBox->SetValue(m_EnabledPkgs.find(m_CurPkg) != m_EnabledPkgs.end());
                break;
            default :
                itemCheckBox->Enable(false);
                itemCheckBox->SetValue(false);
                break;
            }
        }
    }
}

#if wxUSE_UNICODE
inline wxTextOutputStream& operator <<( wxTextOutputStream& os, const string& str )
{
    return os << wxString::FromAscii(str.c_str());
}
#endif

void CAppPackagesDlg::x_DumpPkgInfo(wxTextOutputStream& os, const string& name, const CPackageInfo& pkg_info)
{
    const objects::CGuiPkgManifest* manifest = pkg_info.m_Manifest.GetPointer();

    if (!manifest) { // Application entry
        os << wxT("Package: ") << name << endl;
        os << wxT("Description: ") << name << wxT(" application") << endl;
        os << wxT("Version: ") << wxString::Format(wxT("%02d.%02d.%04d"),
                               (int)pkg_info.m_VerMajor,
                               (int)pkg_info.m_VerMinor,
                               (int)pkg_info.m_VerPatch) << endl;
    }
    else {
        os << wxT("Package: ") << manifest->GetName() << endl;
        os << wxT("Description: ") << manifest->GetDescription() << endl;
        os << wxT("Version: ");

        if (pkg_info.m_State == CPackageInfo::eLoaded)
            os << wxString::Format(wxT("%02d.%02d.%04d"),
                                   (int)pkg_info.m_VerMajor,
                                   (int)pkg_info.m_VerMinor,
                                   (int)pkg_info.m_VerPatch);
        else
            os << manifest->GetVersion();

        os << endl << endl;

        if (pkg_info.m_State != CPackageInfo::eValidated &&
            pkg_info.m_State != CPackageInfo::eLoaded) {
                os << wxT("ERROR: ") << pkg_info.m_ErrMsg;
            os << endl << endl;
        }

        os << wxT("Dll: ") << string(NCBI_PLUGIN_PREFIX) << manifest->GetMainDll() << string(NCBI_PLUGIN_SUFFIX) << endl;
        os << wxT("Dir: ") << pkg_info.m_Dir << endl;
        os << wxT("Depends on: ") << endl;
        const objects::CGuiPkgManifest::TGuiPkgDependency& deps = manifest->GetGuiPkgDependency();
        ITERATE(objects::CGuiPkgManifest::TGuiPkgDependency, it2, deps) {
            const objects::CGuiDependentPkg& pkg = (*it2)->GetGuiDependentPkg();
            os << wxT("    ") << pkg.GetName() << wxT(" ") << pkg.GetVersion() << endl;
        }
    }
}

void CAppPackagesDlg::OnShowInvalidPkgs( wxCommandEvent& WXUNUSED(event) )
{
    x_LoadPkgList();
}

void CAppPackagesDlg::OnEnablePkg( wxCommandEvent& event )
{
    if (event.IsChecked()) {
        vector<string> basePkgs;
        m_PkgManager->GetBasePkgs(m_CurPkg, basePkgs);
        m_EnabledPkgs.insert(m_CurPkg);
        ITERATE(vector<string>, it, basePkgs)
            m_EnabledPkgs.insert(*it);
    }
    else {
        vector<string> dependents;
        m_PkgManager->GetDependentPkgs(m_CurPkg, dependents);
        m_EnabledPkgs.erase(m_CurPkg);
        ITERATE(vector<string>, it, dependents)
            m_EnabledPkgs.erase(*it);
    }
}

void CAppPackagesDlg::OnOkClick( wxCommandEvent& event )
{
    vector<string> loadPkgs;
    back_insert_iterator<vector<string> > dest(loadPkgs);
    copy(m_EnabledPkgs.begin(), m_EnabledPkgs.end(), dest);
    m_PkgManager->SetPackagesToLoad(loadPkgs);

    wxMessageBox(wxT("Changes will take effect when you restart Genome Workbench."),
                 SYMBOL_CAPPPACKAGESDLG_TITLE, wxOK|wxICON_INFORMATION);

    event.Skip();
}

END_NCBI_SCOPE
