/* $Id: Cache_blob.hpp 501750 2016-05-18 17:08:34Z gouriano $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cache_blob.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'cache_blob.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: Cache_blob_.hpp


#ifndef INTERNAL_GPIPE_ASN_CACHE_LIB_CACHE_BLOB_HPP
#define INTERNAL_GPIPE_ASN_CACHE_LIB_CACHE_BLOB_HPP


// generated includes
#include <objtools/data_loaders/asn_cache/Cache_blob_.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

class CSeq_entry;

/////////////////////////////////////////////////////////////////////////////
class CCache_blob : public CCache_blob_Base
{
    typedef CCache_blob_Base Tparent;
public:

    enum {
        kVersion = 1,
        kMagicNum = 0x05D705DD,
        kMD5Size = 16
    };

    // constructor
    CCache_blob(void);
    // destructor
    ~CCache_blob(void);

    void Pack(const CSeq_entry& entry);
    void UnPack(CSeq_entry& entry) const;
    void UnPack(vector<unsigned char>& raw_bytes) const;

private:
    // Prohibit copy constructor and assignment operator
    CCache_blob(const CCache_blob& value);
    CCache_blob& operator=(const CCache_blob& value);

};

/////////////////// CCache_blob inline methods

/////////////////// end of CCache_blob inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // INTERNAL_GPIPE_ASN_CACHE_LIB_CACHE_BLOB_HPP
/* Original file checksum: lines: 86, chars: 2470, CRC32: 4964646f */
