#ifndef GUI_WIDGETS_SEQ_GRAPHIC___GUI_OBJECT_INFO_SEQ_ALIGN__HPP
#define GUI_WIDGETS_SEQ_GRAPHIC___GUI_OBJECT_INFO_SEQ_ALIGN__HPP

/*  $Id: gui_object_info_seq_align.hpp 45470 2020-08-12 22:51:16Z evgeniev $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Authors:  Liangshou Wu
 *
 * File Description:
 *
 */

#include <corelib/ncbistr.hpp>
#include <gui/objutils/interface_registry.hpp>
#include <gui/objutils/gui_object_info.hpp>
#include <objects/seqalign/Seq_align.hpp>
#include <gui/widgets/seq_graphic/alngraphic_ds.hpp>

/** @addtogroup GUI_UTILS
 *
 * @{
 */

BEGIN_NCBI_SCOPE

BEGIN_SCOPE(objects)
    class CUser_field;
END_SCOPE(objects)

class NCBI_GUIWIDGETS_SEQGRAPHIC_EXPORT CGuiObjectInfoSeq_align
    : public CObject
    , public IGuiObjectInfo
{
public:
    static CGuiObjectInfoSeq_align* CreateObject(SConstScopedObject& object, ICreateParams* params);

    virtual std::string GetType() const { return "Alignment"; }
    virtual std::string GetSubtype() const { return ""; }
    virtual std::string GetLabel() const;
    virtual void GetToolTip(ITooltipFormatter& tooltip, std::string& t_title,
        TSeqPos at_p = (TSeqPos)-1, bool* isGeneratedBySvc = NULL) const;
    virtual void GetLinks(ITooltipFormatter& /*links*/, bool /*no_ncbi_base*/) const;
    virtual std::string GetIcon() const { return "symbol::alignment"; }
    virtual std::string GetViewCategory() const { return "Alignment"; }   
    void SetAnchorRow(int anchor)  { m_AnchorRow = anchor; }
    void SetFlippedStrands(bool flipped = true) { m_FlippedStrands = flipped; }
    void SetReportInsertionSequences(bool report) { m_ReportInsertionSequences = report; }
    void SetScale(double scale) { m_Scale = scale; }
    void SetDataSource(const CConstRef<IAlnGraphicDataSource> &data_source) { m_DataSource = data_source; }
    virtual std::string GetSRAReadStatus() const;
    virtual double GetCoverage() const;

    static bool IsPolyA(const objects::CBioseq_Handle& bsh, TSeqPos start, TSeqPos stop);
    
    static const size_t kInsertionsPerTooltip = 3;
    static const float kSequenceLevel;
    using TSignedSeqRanges = std::vector<TSignedSeqRange>;
    static TSignedSeqRange GetRangeAroundPosition(const TSeqPos at_p, double scale, const IAlnGraphicDataSource& data_source);
    static size_t GetInsertionRanges(const TSignedSeqRange& aln_range, const IAlnGraphicDataSource& data_source, TSignedSeqRanges* ranges = nullptr);
    static std::string GetSeqString(IAlnGraphicDataSource::TNumrow row, const IAlnGraphicDataSource& data_source, const TSignedSeqRange& seq_rng, bool flipped_strands);

protected:
    void x_AddUserObject(ITooltipFormatter& tooltip, const objects::CUser_field &user_object) const;
    void x_GetAlignmentTooltip_Insert(const TSignedSeqRange& seq_r, ITooltipFormatter& tooltip) const;
    std::string x_GetTooltipSequence(TSeqPos from, TSeqPos to, IAlnGraphicDataSource::TNumrow row) const;

private:
    CConstRef<objects::CSeq_align> m_Align;
    mutable CRef<objects::CScope> m_Scope;
    /// anchor sequence row number, default is -1 (unknown)
    int  m_AnchorRow;
    bool m_FlippedStrands = false;
    bool m_ReportInsertionSequences = true;
    double m_Scale = 0.0;

    CConstRef<IAlnGraphicDataSource> m_DataSource;
};


END_NCBI_SCOPE

/* @} */

#endif  // GUI_WIDGETS_SEQ_GRAPHIC___GUI_OBJECT_INFO_SEQ_ALIGN__HPP
