/*  $Id: wx_tree_label_edit.hpp 30873 2014-07-31 20:37:16Z ucko $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Authors:  Bob Falk
 *
 * File Description:
 *
 */
// Generated by DialogBlocks (unregistered), 28/10/2013 09:21:36

#ifndef _WX_TREE_LABEL_EDIT_H_
#define _WX_TREE_LABEL_EDIT_H_


/*!
 * Includes
 */

#include <corelib/ncbistl.hpp>
#include <gui/utils/rgba_color.hpp>
#include <gui/widgets/phylo_tree/phylo_tree_scheme.hpp>
#include <gui/widgets/phylo_tree/phylo_tree.hpp>
#include <gui/widgets/phylo_tree/phylo_tree_ds.hpp>

// This header must (at least indirectly) precede any wxWidgets headers.
#include <gui/widgets/wx/fixed_base.hpp>

////@begin includes
#include <wx/clrpicker.h>
#include <wx/dialog.h>
#include <wx/choice.h>
#include <wx/textctrl.h>
////@end includes

/*!
 * Forward declarations
 */

////@begin forward declarations
class wxColourPickerCtrl;
////@end forward declarations

BEGIN_NCBI_SCOPE

class CPhyloTreeDataSource;
class CPhyloTreeScheme;

/*!
 * Control identifiers
 */

////@begin control identifiers
#define ID_CWXTREELABELEDIT 10046
#define ID_TREE_NAME_TXT 14047
#define ID_LABEL_POS_X 14048
#define ID_LABEL_POS_Y 14049
#define ID_LABEL_FONT_CHOICE 14044
#define m_LABEL_FONT_SIZE_CHOICE 14045
#define ID_TREE_FONT_COLOR 14050
#define SYMBOL_CWXTREELABELEDIT_STYLE wxDEFAULT_DIALOG_STYLE|wxCAPTION|wxRESIZE_BORDER|wxSYSTEM_MENU|wxCLOSE_BOX|wxTAB_TRAVERSAL
#define SYMBOL_CWXTREELABELEDIT_TITLE _("Tree Label Edit")
#define SYMBOL_CWXTREELABELEDIT_IDNAME ID_CWXTREELABELEDIT
#define SYMBOL_CWXTREELABELEDIT_SIZE wxSize(400, 300)
#define SYMBOL_CWXTREELABELEDIT_POSITION wxDefaultPosition
////@end control identifiers


/*!
 * CwxTreeLabelEdit class declaration
 */

class CwxTreeLabelEdit: public wxDialog
{    
    DECLARE_DYNAMIC_CLASS( CwxTreeLabelEdit )
    DECLARE_EVENT_TABLE()

public:
    CwxTreeLabelEdit();
    CwxTreeLabelEdit( wxWindow* parent, wxWindowID id = SYMBOL_CWXTREELABELEDIT_IDNAME, const wxString& caption = SYMBOL_CWXTREELABELEDIT_TITLE, const wxPoint& pos = SYMBOL_CWXTREELABELEDIT_POSITION, const wxSize& size = SYMBOL_CWXTREELABELEDIT_SIZE, long style = SYMBOL_CWXTREELABELEDIT_STYLE );

    bool Create( wxWindow* parent, wxWindowID id = SYMBOL_CWXTREELABELEDIT_IDNAME, const wxString& caption = SYMBOL_CWXTREELABELEDIT_TITLE, const wxPoint& pos = SYMBOL_CWXTREELABELEDIT_POSITION, const wxSize& size = SYMBOL_CWXTREELABELEDIT_SIZE, long style = SYMBOL_CWXTREELABELEDIT_STYLE );

    ~CwxTreeLabelEdit();

    void SetParams(CPhyloTreeDataSource* ds, CPhyloTreeScheme* sl);

    void Init();

    void CreateControls();

////@begin CwxTreeLabelEdit event handler declarations

    void OnLabelPosXTextUpdated( wxCommandEvent& event );

    void OnLabelPosYTextUpdated( wxCommandEvent& event );

    void OnLabelFontChoiceSelected( wxCommandEvent& event );

    void OnOkClick( wxCommandEvent& event );

////@end CwxTreeLabelEdit event handler declarations

////@begin CwxTreeLabelEdit member function declarations

    wxBitmap GetBitmapResource( const wxString& name );

    wxIcon GetIconResource( const wxString& name );
////@end CwxTreeLabelEdit member function declarations

    static bool ShowToolTips();

////@begin CwxTreeLabelEdit member variables
    wxTextCtrl* m_TreeName;
    wxTextCtrl* m_LabelPosX;
    wxTextCtrl* m_LabelPosY;
    wxChoice* m_FontName;
    wxChoice* m_FontSize;
    wxColourPickerCtrl* m_FontColorPicker;
////@end CwxTreeLabelEdit member variables

protected:

    CPhyloTreeDataSource* m_DS;
};

END_NCBI_SCOPE

#endif
    // _WX_TREE_LABEL_EDIT_H_
