/*  $Id: sequence_editing_cmds.hpp 45131 2020-06-04 17:41:11Z asztalos $
 * =========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * =========================================================================
 *
 * Authors: Igor Filippov
 *
 * File Description:
 *      Defines "Sequence Editing" commands enum for GBENCH.
 */

#ifndef _SEQUENCE_EDITING_CMDS_H_
#define _SEQUENCE_EDITING_CMDS_H_

#include <corelib/ncbistd.hpp>

BEGIN_NCBI_SCOPE

enum ESequenceEditingCommands {
    eCmdRemoveDescriptors = eBaseCmdLast + 1000,
    eCmdRemoveFeatures,
    eCmdRemoveUnindexedFeatures,
    eCmdApplyIndexerComments,
    eCmdRemoveSeqAnnotIds,
    eCmdRemoveCddFeatDbxref,
    eCmdRemoveBankitComment,
    eCmdRemoveUnverified,
    eCmdRemoveDuplicateStructuredComments,
    eCmdRemoveSequencesFromAlignments,
    eCmdRemoveSequences,
    eCmdRemoveSequences_ext,
    eCmdJustRemoveProteins,
    eCmdRemoveProteinsAndRenormalizeNucProtSets,
    eCmdRemoveOrphanedProteins,
    eCmdRemoveSet,
    eCmdRemoveSetsFromSet,
    eCmdRevCompSequences,
    eCmdRevCompSequences_ext,
    eCmdBioseqFeatsRevComp,
    eCmdBioseqOnlyRevComp,
    eCmdUnculTaxTool,
    eCmdMergeBiosources,
    eCmdCompareWithBiosample,
    eCmdCompareWithBiosampleFirstOnly,
    eCmdConsolidateLikeModsWithSemicolon,
    eCmdConsolidateLikeModsWithoutSemicolon,
    eCmdBarcodeTool,
    eCmdApplyFBOL,
    eCmdEditSequence,
    eCmdAlignmentAssistant,
    eCmdRemoveAlignments,
    eCmdRemoveGraphs,
    eCmdRemoveGenomeProjectId,
    eCmdRemoveEmptyGenomeProjectId,
    eCmdTaxFixCleanup,
    eCmdTaxFixCleanup_ext,
    eCmdSpecificHostCleanup,
    eCmdExtendedCleanup,
    eCmdFixNonReciprocalLinks,
    eCmdDisableStrainForwarding,
    eCmdEnableStrainForwarding,
    eCmdEditPubs,
    eCmdGlobalPubmedIdLookup,
    eCmdFixCapitalizationAll,
    eCmdFixCapitalizationAuthors,
    eCmdFixCapitalizationTitles,
    eCmdFixCapitalizationAffiliation,
    eCmdFixCapitalizationCountry,
    eCmdRemoveUnpublishedPublications,
    eCmdRemoveInPressPublications,
    eCmdRemovePublishedPublications,
    eCmdRemoveCollidingPublications,
    eCmdRemoveAllPublications,
    eCmdRemoveAuthorConsortiums,
    eCmdReverseAuthorNames,
    eCmdStripAuthorSuffixes,
    eCmdTruncateAuthorMiddleInitials,
    eCmdConvertAuthorToConstortiumWhereLastName,
    eCmdConvertAuthorToConsortiumAll,
    eCmdAddCitSubForUpdate,
    eCmdFixUsaAndStates,
    eCmdRetranslateCDSObeyStop,
    eCmdRetranslateCDSIgnoreStopExceptEnd,
    eCmdRetranslateCDSIgnoreStopExceptEnd_ext,
    eCmdRetranslateCDSChooseFrame,
    eCmdEditCdsFrame,
    eCmdRestoreRNAediting,
    eCmdResynchronizePartialsCDS,
    eCmdAddTranslExcept,
    eCmdRemoveAllStructuredComments,
    eCmdRemoveEmptyStructuredComments,
    eCmdModifyStructuredComment,
    eCmdSetGlobalRefGeneStatus,
    eCmdClearKeywords,
    eCmdClearNomenclature,
    eCmdConvertToDelayedGenProdSetQuals,
    eCmdConvertRptUnitRangeToLoc,
    eCmdRemoveStructuredCommentKeyword,
    eCmdAddStructuredCommentKeyword,
    eCmdAddKeywordGDS,
    eCmdAddKeywordTPA_inferential,
    eCmdAddKeywordTPA_experimental,
    eCmdAddKeywordTPA_assembly,
    eCmdAddKeywordWithConstraint,
    eCmdAddGenomeAssemblyStructuredComment,
    eCmdAddAssemblyStructuredComment,
    eCmdReorderStructuredComment,
    eCmdConvertComment,
    eCmdExportStructuredCommentsTable,
    eCmdLoadStructComments,
    eCmdParseComment,
    eCmdIllegalQualsToNote,
    eCmdRmIllegalQuals,
    eCmdWrongQualsToNote,
    eCmdConvertBadInference,
    eCmdRmWrongQuals,
    eCmdRemoveDbXrefsCDS,
    eCmdRemoveDbXrefsGenes,
    eCmdRemoveDbXrefsRNA,
    eCmdRemoveDbXrefsAllFeats,
    eCmdRemoveDbXrefsBioSource,
    eCmdRemoveDbXrefsBioSourceAndFeats,
    eCmdRemoveTaxonFeats,
    eCmdRemoveTaxonFeatsAndBioSource,
    eCmdGroupExplode,
    eCmdFindASN1,
    eCmdFuseFeatures,
    eCmdFuseJoinsInLocs,
    eCmdExplodeRNAFeats,
    eCmdLowercaseQuals,
    eCmdAssignFeatureIds,
    eCmdClearFeatureIds,
    eCmdReassignFeatureIds,
    eCmdUniqifyFeatureIds,
    eCmdTrimJunkInPrimerSeqs,
    eCmdFixiInPrimerSeqs,
    eCmdPrefixAuthWithTax,
    eCmdFocusSet,
    eCmdFocusClear,
    eCmdSetTransgSrcDesc,
    eCmdSplitDblinkQuals,
    eCmdFixOrgModInstitution,
    eCmdFixStructuredVouchers,
    eCmdSwapPrimerSeqName,
    eCmdMergePrimerSets,
    eCmdSplitPrimerSets,
    eCmdAppendModToOrg,
    eCmdParseCollectionDateMonthFirst,
    eCmdParseCollectionDateDayFirst,
    eCmdCountryFixupCap,
    eCmdCountryFixupNoCap,
    eCmdVectorTrim,
    eCmdSelectTarget,
    eCmdSelectTarget_ext,
    eCmdSelectFeature,
    eCmdApplyCDS,
    eCmdApplyAddRNA,
    eCmdApplyAddOther,
    eCmdApplyAddOther_ext,
    eCmdAddFeatureBetween,
    eCmdValidate,
    eCmdValidateNoAlignments,
    eCmdValidateCheckInferences,
    eCmdValidate_ext,
    eCmdSortUniqueCountText,
    eCmdSortUniqueCountTree,
    eCmdSortUniqueCountTree_ext,
    eCmdDiscrepancy,
    eCmdOncaller,
    eCmdSubmitter,
    eCmdSubmitter_ext,
    eCmdMega,
    eCmdRemoveAllFeatures,
    eCmdRemoveDupFeats,
    eCmdRemoveDupFeats_ext,
    eCmdRemoveDupFeatsWithOptions,
    eCmdRemoveDupFeatsWithOptions_ext,
    eCmdResolveIntersectingFeats,
    eCmdAutodefDefaultOptions,
    eCmdAutodefOptions,
    eCmdAutodefMisc,
    eCmdAutodefId,
    eCmdAutodefNoMods,
    eCmdAutodefPopset,
    eCmdAutodefRefresh,
    eCmdInstantiateProteinTitles,
    eCmdAddSequences,
    eCmdApplySourceQual,
    eCmdEditSourceQual,
    eCmdConvertSourceQual,
    eCmdSwapSourceQual,
    eCmdRemoveSourceQual,
    eCmdApplyRNAQual,
    eCmdEditRNAQual,
    eCmdConvertRNAQual,
    eCmdSwapRNAQual,
    eCmdRemoveRNAQual,
    eCmdApplyCGPQual,
    eCmdEditCGPQual,
    eCmdConvertCGPQual,
    eCmdSwapCGPQual,
    eCmdRemoveCGPQual,
    eCmdApplyFeatQual,
    eCmdEditFeatQual,
    eCmdConvertFeatQual,
    eCmdConvertSecondProtNameToDesc,
    eCmdConvertDescToSecondProtName,
    eCmdConvertDescToFeatComment,
    eCmdConvertDescToFeatSource,
    eCmdConvertDescToFeatPub,
    eCmdConvertDescToFeatPubConstraint,
    eCmdConvertFeatToDescComment,
    eCmdConvertFeatToDescSource,
    eCmdConvertFeatToDescPub,
    eCmdSwapFeatQual,
    eCmdRemoveFeatQual,
    eCmdRemoveTextOutsideString,
    eCmdEditFeatEv,
    eCmdEditFeatLoc,
    eCmdEditFeatLoc_ext,
    eCmdEditFeatStrand,
    eCmdEditFeatStrand_ext,
    eCmdEditFeatRevInt,
    eCmdEditFeatPseudo,
    eCmdEditFeatException,
    eCmdEditFeatExperiment,
    eCmdEditFeatInference,
    eCmdExtendPartialsConstr,
    eCmdExtendPartialsAll,
    eCmdGeneFromOtherFeat,
    eCmdGeneFeatFromXrefs,
    eCmdGeneXrefsFromFeats,
    eCmdRemoveAllGeneXrefs,
    eCmdRemoveUnnecessaryGeneXrefs,
    eCmdRemoveNonsuppressingGeneXrefs,
    eCmdRemoveOrphanLocusGeneXrefs,
    eCmdRemoveOrphanLocus_tagGeneXrefs,
    eCmdRemoveGeneXrefs,
    eCmdRemoveDuplicateGOTerms,
    eCmdExtendCDS,
    eCmdTruncateCDS,
    eCmdExtendCDSToStop,
    eCmdRecomputeIntervalsAndUpdateGenes,
    eCmdRecomputeIntervals,
    eCmdCdsFromGeneMrnaExon,
    eCmdmRNAFromGeneCdsExon,
    eCmdtRNAFromGene,
    eCmdExonFromCds,
    eCmdExonFromMRNA,
    eCmdExonFromTRNA,
    eCmdFixProductNamesDefault,
    eCmdFixProductNamesOptions,
    eCmdBulkApplyGenCode,
    eCmdEditSeqEndsWithAlign,
    eCmdEditSequenceEnds,
    eCmdUpdateAlign,
    eCmdSaveDescriptors,
    eCmdCreateSeqHistForTpaDetailed,
    eCmdCreateSeqHistForTpa,
    eCmdRemoveSeqHistAssembly,
    eCmdFarPointerSeq,
    eCmdConvertBadCdsAndRnaToMiscFeat,
    eCmdCreateProteinId,
    eCmdCreateLocusTagGene,
    eCmdNormalizeGeneQuals,
    eCmdGenusSpeciesFixup,
    eCmdCountryConflict,
    eCmdDuplicate,
    eCmdCorrectIntervalOrder,
    eCmdAddSecondary,
    eCmdPackageFeaturesOnParts,
    eCmdParseText,
    eCmdParseTextFromDefline,
    eCmdParseLocalToSrc,
    eCmdRemoveTextInsideStr,
    eCmdConvertFeatures,
    eCmdCdsToMatPeptide,
    eCmdConvertCdsToMiscFeat,
    eCmdConvertCdsWithInternalStopToMiscFeat,
    eCmdConvertCdsWithInternalStopToMiscFeatViral,
    eCmdConvertCdsWithInternalStopToMiscFeatUnverified,
    eCmdConvertCdsWithGapsToMiscFeat,
    eCmdTableReader,
    eCmdTableReader_ext,
    eCmdTableReaderClipboard,
    eCmdMolInfoEdit,
    eCmdExportTable,
    eCmdBulkSourceEdit,
    eCmdBulkCdsEdit,
    eCmdLatLonTool,
    eCmdCDSGeneRangeErrorSuppress,
    eCmdCDSGeneRangeErrorRestore,
    eCmdSuppressGenes,
    eCmdBulkGeneEdit,
    eCmdBulkRnaEdit,
    eCmdBulkMiscFeatEdit,
    eCmdCorrectGenes,
    eCmdSegregateSets,
    eCmdSequesterSets,
    eCmdDescriptorPropagateDown,
    eCmdReorderSeqById,
    eCmdCombineSelectedGenesIntoPseudogenes,
    eCmdWithdrawSequences,
    eCmdAddSet,
    eCmdPropagateDBLink,
    eCmdChangeSetClass,
    eCmdParseStrainSerotypeFromNames,
    eCmdAddStrainSerotypeToNames,
    eCmdFixupOrganismNames,
    eCmdSplitQualifiersAtCommas,
    eCmdSplitStructuredCollections,
    eCmdTrimOrganismNames,
    eCmdAddNamedrRNA12S,
    eCmdAddNamedrRNA16S,
    eCmdAddNamedrRNA23S,
    eCmdAddNamedrRNA18S,
    eCmdAddNamedrRNA28S,
    eCmdAddNamedrRNA26S,
    eCmdAddNamedrRNASmall,
    eCmdAddNamedrRNALarge,
    eCmdAddControlRegion,
    eCmdAddMicrosatellite,
    eCmdAddDefLine,
    eCmdPrefixOrgToDefLine,
    eCmdPrefixStrainToDefLine,
    eCmdPrefixCloneToDefLine,
    eCmdPrefixIsolateToDefLine,
    eCmdPrefixHaplotToDefLine,
    eCmdPrefixCultivarToDefLine,
    eCmdPrefixListToDefLine,
    eCmdCreateDescTPAAssembly,
    eCmdCreateDescStructuredComment,
    eCmdCreateDescRefGeneTracking,
    eCmdCreateDescDBLink,
    eCmdCreateDescUnverified,
    eCmdCreateDescAuthorizedAccess,
    eCmdCreateDescGenomeAssemblyComment,
    eCmdCreateDescGenBankBlock,
    eCmdCreateDescComment,
    eCmdCreateDescComment_ext,
    eCmdCreateDescTitle,
    eCmdCreateDescMolinfo,
    eCmdMakeBadSpecificHostTable,
    eCmdCorrectRNAStrand,
    eCmdTrimNsRich,
    eCmdTrimNsTerminal,
    eCmdAddFluComments,
    eCmdLabelRna,
    eCmdRemProtTitles,
    eCmdRemAllProtTitles,
    eCmdApplyRNA_ITS,
    eCmdListMacroButtonNames,
    eCmdAdjustConsensusSpliceSitesStrict,
    eCmdAdjustConsensusSpliceSitesStrict_ext,
    eCmdAdjustConsensusSpliceSitesRelaxed,
    eCmdAdjustConsensusSpliceSitesRelaxed_ext,
    eCmdAdjustConsensusSpliceSitesConsensusEnds,
    eCmdAdjustCDSForIntrons,
    eCmdAdjustrRNAForIntrons,
    eCmdAdjusttRNAForIntrons,
    eCmdAdjustmRNAForIntrons,
    eCmdApplyStructuredCommentField,
    eCmdEditStructuredCommentPrefixSuffixHIVData,
    eCmdEditStructuredCommentPrefixSuffixFluData,
    eCmdEditStructuredCommentPrefixSuffixMIGSData,
    eCmdEditStructuredCommentPrefixSuffixMIMSData,
    eCmdEditStructuredCommentPrefixSuffixMIENSData,
    eCmdEditStructuredCommentPrefixSuffixMIMARKS3_0,
    eCmdEditStructuredCommentPrefixSuffixMIGS3_0,
    eCmdEditStructuredCommentPrefixSuffixMIMS3_0,
    eCmdEditStructuredCommentPrefixSuffixAssemblyData,
    eCmdEditStructuredCommentPrefixSuffixGenAssData,
    eCmdEditStructuredCommentPrefixSuffixiBol,
    eCmdRemoveSegGaps,
    eCmdRawSeqToDeltaByNs,
    eCmdRawSeqToDeltaByNs_ext,
    eCmdRawSeqToDeltaByLoc,
    eCmdRawSeqToDeltaByAssemblyGapFeatures,
    eCmdAdjustFeaturesForGaps,
    eCmdDeltaSeqToRaw,
    eCmdDeltaSeqToRaw_ext,
    eCmdExpandGaps,
    eCmdConvertSelectedGapsToKnown,
    eCmdConvertSelectedGapsToUnknown,
    eCmdConvertGapsBySize,
    eCmdEditSelectedGaps,
    eCmdAddLinkageToGaps,
    eCmdAddLinkageToGaps_ext,
    eCmdCombineAdjacentGaps,
    eCmdSplitCDSwithTooManyXs,
    eCmdRmCultureNotes,
    eCmdEditSeqId,
    eCmdRemoveLocalSeqIdsFromNuc,
    eCmdRemoveLocalSeqIdsFromProt,
    eCmdRemoveLocalSeqIdsFromAll,
    eCmdRemoveGiSeqIdsFromAll,
    eCmdRemoveGenbankSeqIdsFromProt,
    eCmdRemoveGenbankSeqIdsFromAll,
    eCmdRemoveSeqIdNamesFromProtFeats,
    eCmdConvertAccessionToLocalIdsAll,
    eCmdConvertAccessionToLocalIdsNuc,
    eCmdConvertAccessionToLocalIdsProt,
    eCmdConvertAccessionToLocalIdsName,
    eCmdLocalToGeneralId,
    eCmdGeneralToLocalId,
    eCmdRemoveGeneralId,
    eCmdRemoveUnnecessaryExceptions,
    eCmdEditHistory,
    eCmdUpdate_Replaced_EC_numbers,
    eCmdUpdateSequence,
    eCmdUpdateSequence_ext,
    eCmdUpdateSequenceClipboard,
    eCmdUpdateSequenceAccession,
    eCmdUpdateMultiSequences,
    eCmdUpdateMultiSeqClipboard,
    eCmdImportFeatureTable,
    eCmdImportFeatureTable_ext,
    eCmdImportFeatureTableClipboard,
    eCmdImportGFF3,
    eCmdImportGFF3_ext,
    eCmdLoadSecondaryAccessions,
    eCmdLoadSecondaryAccessionsHistoryTakeover,
    eCmdAddGlobalCodeBreak,
    eCmdLinkSelectedmRNACDS,
    eCmdLinkmRNACDSOverlap,
    eCmdLinkmRNACDSProduct,
    eCmdLinkmRNACDSLabel,
    eCmdLinkmRNACDSLabelLocation,
    eCmdLinkmRNACDSProteinID,
    eCmdLinkmRNACDSTranscriptID,
    eCmdLinkmRNACDSUnidirectional,
    eCmdShowLinkedmRNACDS,
    eCmdShowFeatureTable,
    eCmdShowFeatureTable_ext,
    eCmdRestoreFromFile,
    eCmdRestoreAndConvertSeqSubmit,
    eCmdViewSortedProteins,
    eCmdCheckForMixedStrands,
    eCmdFixForTransSplicing,
    eCmdSaveSubmissionFile,
    eCmdSaveASN1File,
    eCmdCreateStructuredCommentPrefixSuffixMIMS, 
    eCmdCreateStructuredCommentPrefixSuffixMIGS, 
    eCmdCreateStructuredCommentPrefixSuffixMIMARKS,
    eCmdCreateStructuredCommentPrefixSuffixMIENSData,
    eCmdCreateStructuredCommentPrefixSuffixGenAnnData,
    eCmdCreateStructuredCommentPrefixSuffixGenAssData,
    eCmdDeleteStructuredCommentPrefixSuffixMIENSData,
    eCmdDeleteStructuredCommentPrefixSuffixMIMARKS,
    eCmdDeleteStructuredCommentPrefixSuffixMIGS,
    eCmdDeleteStructuredCommentPrefixSuffixMIMS,
    eCmdDeleteStructuredCommentPrefixSuffixGenAssData,
    eCmdDeleteStructuredCommentPrefixSuffixGenAnnData,
    eCmdCreateDescSource,    // Most of the new stuff can be added above, unless it expects a non-TSE type selection
    eCmdCreateDescPub_ext,
    eCmdCreateDescPub,
   
    eCmdEditingButtons, // This can be shown regardless of selection - buttons do their own selection search
    eCmdDiscrepancyList,
    eCmdMakeToolBarWindow,
    eCmdSuspectProductRulesEditor,
    eCmdMacroEditor,
    eCmdPrepareSeqSubmit,
    eCmdEnableHupId,
    eCmdIndexerTypeSelection,
    eCmdTestDialogView,
    eCmdTestFormView,
    eCmdHelpReports_ext,
    eCmdHelpImport_ext,
    eCmdHelpSequences_ext,
    eCmdHelpFeatures_ext,
    eCmdHelpComments_ext,
    eCmdHelpEditingTools_ext

};

static const char *kInternalIndexerRegistry =  "Dialogs.Edit.InternalIndexer";
static const char *kInternalIndexerRegistryType = "IndexerType";
enum EIndexerType {
    e_GenBankIndexer = 0,
    e_RefSeqIndexer,
    e_LastIndexer
};

END_NCBI_SCOPE
#endif
// _SEQUENCE_EDITING_CMDS_H_
