/*  $Id: inference_panel.hpp 41013 2018-05-09 21:07:35Z filippov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data,  the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties,  express or implied,  including
 *  warranties of performance,  merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Authors:  Colleen Bollin
 */
// Generated by DialogBlocks (unregistered), 08/12/2011 09:51:07

#ifndef _INFERENCE_PANEL_H_
#define _INFERENCE_PANEL_H_

#include <corelib/ncbistd.hpp>
#include <gui/gui_export.h>
#include <gui/widgets/edit/formattedqual_panel.hpp>

/*!
 * Includes
 */

////@begin includes
////@end includes

#include <wx/checkbox.h>

/*!
 * Forward declarations
 */

////@begin forward declarations
class wxBoxSizer;
////@end forward declarations

BEGIN_NCBI_SCOPE

/*!
 * Control identifiers
 */

////@begin control identifiers
#define SYMBOL_CINFERENCEPANEL_STYLE wxCAPTION|wxRESIZE_BORDER|wxSYSTEM_MENU|wxCLOSE_BOX|wxTAB_TRAVERSAL
#define SYMBOL_CINFERENCEPANEL_TITLE _("InferencePanel")
#define SYMBOL_CINFERENCEPANEL_IDNAME ID_CTWOPARTQUALPANEL
#define SYMBOL_CINFERENCEPANEL_SIZE wxDefaultSize
#define SYMBOL_CINFERENCEPANEL_POSITION wxDefaultPosition
////@end control identifiers


/*!
 * CInferencePanel class declaration
 */

class NCBI_GUIWIDGETS_EDIT_EXPORT CInferencePanel: public CFormattedQualPanel
{    
    DECLARE_DYNAMIC_CLASS( CInferencePanel )
	DECLARE_EVENT_TABLE()

	public:
	/// Constructors
	CInferencePanel();
    CInferencePanel( wxWindow* parent, wxWindowID id = SYMBOL_CINFERENCEPANEL_IDNAME, const wxPoint& pos = SYMBOL_CINFERENCEPANEL_POSITION, const wxSize& size = SYMBOL_CINFERENCEPANEL_SIZE, long style = SYMBOL_CINFERENCEPANEL_STYLE );

    /// Creation
    bool Create( wxWindow* parent, wxWindowID id = SYMBOL_CINFERENCEPANEL_IDNAME, const wxPoint& pos = SYMBOL_CINFERENCEPANEL_POSITION, const wxSize& size = SYMBOL_CINFERENCEPANEL_SIZE, long style = SYMBOL_CINFERENCEPANEL_STYLE );

    /// Destructor
    ~CInferencePanel();

    /// Initialises member variables
    void Init();

    /// Creates the controls and sizers
    void CreateControls();

    virtual void SetValue(string val);
    virtual string GetValue();
    virtual void GetDimensions(int *width, int *height);
    virtual void OnChildChange(wxWindow *wnd);

////@begin CInferencePanel event handler declarations

    /// wxEVT_COMMAND_CHOICE_SELECTED event handler for ID_CHOICE13
    void OnChoice13Selected( wxCommandEvent& event );

////@end CInferencePanel event handler declarations

////@begin CInferencePanel member function declarations

    /// Retrieves bitmap resources
    wxBitmap GetBitmapResource( const wxString& name );

    /// Retrieves icon resources
    wxIcon GetIconResource( const wxString& name );
////@end CInferencePanel member function declarations

    /// Should we show tooltips?
    static bool ShowToolTips();

////@begin CInferencePanel member variables
    wxChoice* m_CategoryCtrl;
    wxChoice* m_TypeCtrl;
    wxBoxSizer* m_ExtraCtrlSizer;
    /// Control identifiers
    enum {
        ID_CTWOPARTQUALPANEL = 10083,
        ID_CHOICE12 = 10084,
        ID_CHOICE13 = 10096
    };
////@end CInferencePanel member variables
private:
    // depending on the type of inference, different extra data to be collected
    int m_TopWidth;
};

END_NCBI_SCOPE

#endif
// _INFERENCE_PANEL_H_
