#ifndef GUI_WIDGETS_EDIT___FEATURE_TYPE_PANEL__HPP
#define GUI_WIDGETS_EDIT___FEATURE_TYPE_PANEL__HPP
/*  $Id: feature_type_panel.hpp 42432 2019-02-22 18:44:43Z filippov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data,  the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties,  express or implied,  including
 *  warranties of performance,  merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Authors:  Colleen Bollin
 */
// Generated by DialogBlocks (unregistered), 12/06/2013 08:31:07

#include <corelib/ncbistd.hpp>
#include <gui/widgets/edit/field_name_panel.hpp>
#include <wx/listbox.h>


/*!
 * Forward declarations
 */

////@begin forward declarations
////@end forward declarations

BEGIN_NCBI_SCOPE

/*!
 * Control identifiers
 */

////@begin control identifiers
#define ID_CFEATURETYPEPANEL 10179
#define ID_LISTBOX1 10180
#define SYMBOL_CFEATURETYPEPANEL_STYLE wxSIMPLE_BORDER|wxTAB_TRAVERSAL
#define SYMBOL_CFEATURETYPEPANEL_TITLE _("FeatureTypePanel")
#define SYMBOL_CFEATURETYPEPANEL_IDNAME ID_CFEATURETYPEPANEL
#define SYMBOL_CFEATURETYPEPANEL_SIZE wxDefaultSize
#define SYMBOL_CFEATURETYPEPANEL_POSITION wxDefaultPosition
////@end control identifiers


/*!
 * CFeatureTypePanel class declaration
 */

class NCBI_GUIWIDGETS_EDIT_EXPORT CFeatureTypePanel : public CFieldNamePanel
{    
    DECLARE_DYNAMIC_CLASS( CFeatureTypePanel )
    DECLARE_EVENT_TABLE()

public:
    /// Constructors
    CFeatureTypePanel();
    CFeatureTypePanel( wxWindow* parent, wxWindowID id = SYMBOL_CFEATURETYPEPANEL_IDNAME, const wxPoint& pos = SYMBOL_CFEATURETYPEPANEL_POSITION, const wxSize& size = SYMBOL_CFEATURETYPEPANEL_SIZE, long style = SYMBOL_CFEATURETYPEPANEL_STYLE );

    /// Creation
    bool Create( wxWindow* parent, wxWindowID id = SYMBOL_CFEATURETYPEPANEL_IDNAME, const wxPoint& pos = SYMBOL_CFEATURETYPEPANEL_POSITION, const wxSize& size = SYMBOL_CFEATURETYPEPANEL_SIZE, long style = SYMBOL_CFEATURETYPEPANEL_STYLE );

    /// Destructor
    ~CFeatureTypePanel();

    /// Initialises member variables
    void Init();

    /// Creates the controls and sizers
    void CreateControls();

////@begin CFeatureTypePanel event handler declarations

    /// wxEVT_COMMAND_LISTBOX_SELECTED event handler for ID_LISTBOX1
    void OnListbox1Selected( wxCommandEvent& event );

////@end CFeatureTypePanel event handler declarations

////@begin CFeatureTypePanel member function declarations
    // places an 'Any' item at the top of the feature list
    void ListAnyOption(void);
    void ListAllOption(void);

    // lists the features present on the record first
    void ListPresentFeaturesFirst(const objects::CSeq_entry_Handle& entry, vector<const objects::CFeatListItem *> *featlist = nullptr);
    /// Retrieves bitmap resources
    wxBitmap GetBitmapResource( const wxString& name );

    /// Retrieves icon resources
    wxIcon GetIconResource( const wxString& name );
////@end CFeatureTypePanel member function declarations

    /// Should we show tooltips?
    static bool ShowToolTips();

    static bool s_IsRarelyUsedOrDiscouragedFeatureType(int subtype);

////@begin CFeatureTypePanel member variables
    wxListBox* m_List;
////@end CFeatureTypePanel member variables
    virtual string GetFieldName(const bool subfield = false);
    virtual bool SetFieldName(const string& field);
    virtual void ClearValues(void);
    void SetListAllFeats(bool flag) {m_list_all_feats = flag;}
    virtual void SetShowLegalOnly(bool show);

private:
    vector<string> m_Featlist;
    bool m_list_all_feats;
    bool m_show_legal_only;
};


END_NCBI_SCOPE

#endif
    // GUI_WIDGETS_EDIT___FEATURE_TYPE_PANEL__HPP
