#ifndef GUI_WIDGETS_EDIT___EDIT_TEXT_OPTIONS_PANEL__HPP
#define GUI_WIDGETS_EDIT___EDIT_TEXT_OPTIONS_PANEL__HPP
/*  $Id: edit_text_options_panel.hpp 41250 2018-06-22 16:13:19Z asztalos $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data,  the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties,  express or implied,  including
 *  warranties of performance,  merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Authors:  Colleen Bollin
 */
// Generated by DialogBlocks (unregistered), 21/06/2013 07:11:28

#include <corelib/ncbistd.hpp>
#include <gui/objutils/macro_fn_aecr.hpp>

/*!
 * Includes
 */

////@begin includes
////@end includes

#include <wx/panel.h>
#include <wx/textctrl.h>
#include <wx/radiobut.h>
#include <wx/checkbox.h>

/*!
 * Forward declarations
 */

////@begin forward declarations
////@end forward declarations

BEGIN_NCBI_SCOPE

/*!
 * Control identifiers
 */

////@begin control identifiers
#define SYMBOL_CEDITTEXTOPTIONSPANEL_STYLE wxTAB_TRAVERSAL
#define SYMBOL_CEDITTEXTOPTIONSPANEL_TITLE _("EditTextOptionsPanel")
#define SYMBOL_CEDITTEXTOPTIONSPANEL_IDNAME ID_CEDITTEXTOPTIONSPANEL
#define SYMBOL_CEDITTEXTOPTIONSPANEL_SIZE wxDefaultSize //wxSize(400, 300)
#define SYMBOL_CEDITTEXTOPTIONSPANEL_POSITION wxDefaultPosition
////@end control identifiers


/*!
 * CEditTextOptionsPanel class declaration
 */

class NCBI_GUIWIDGETS_EDIT_EXPORT CEditTextOptionsPanel : public wxPanel
{    
    DECLARE_DYNAMIC_CLASS( CEditTextOptionsPanel )
    DECLARE_EVENT_TABLE()

public:
    /// Constructors
    CEditTextOptionsPanel();
    CEditTextOptionsPanel( wxWindow* parent, wxWindowID id = SYMBOL_CEDITTEXTOPTIONSPANEL_IDNAME, const wxPoint& pos = SYMBOL_CEDITTEXTOPTIONSPANEL_POSITION, const wxSize& size = SYMBOL_CEDITTEXTOPTIONSPANEL_SIZE, long style = SYMBOL_CEDITTEXTOPTIONSPANEL_STYLE );

    /// Creation
    bool Create( wxWindow* parent, wxWindowID id = SYMBOL_CEDITTEXTOPTIONSPANEL_IDNAME, const wxPoint& pos = SYMBOL_CEDITTEXTOPTIONSPANEL_POSITION, const wxSize& size = SYMBOL_CEDITTEXTOPTIONSPANEL_SIZE, long style = SYMBOL_CEDITTEXTOPTIONSPANEL_STYLE );

    /// Destructor
    ~CEditTextOptionsPanel();

    /// Initialises member variables
    void Init();

    /// Creates the controls and sizers
    void CreateControls();

////@begin CEditTextOptionsPanel event handler declarations

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EDITTEXTOPTIONS_COPY
    void OnEdittextoptionsCopyClick( wxCommandEvent& event );
    void OnRegExCheck( wxCommandEvent& event );

////@end CEditTextOptionsPanel event handler declarations

////@begin CEditTextOptionsPanel member function declarations

    /// Retrieves bitmap resources
    wxBitmap GetBitmapResource( const wxString& name );

    /// Retrieves icon resources
    wxIcon GetIconResource( const wxString& name );
////@end CEditTextOptionsPanel member function declarations

    /// Should we show tooltips?
    static bool ShowToolTips();

////@begin CEditTextOptionsPanel member variables
    wxTextCtrl* m_Find;
    wxTextCtrl* m_Replace;
    wxRadioButton* m_Anywhere;
    wxRadioButton* m_Beginning;
    wxRadioButton* m_End;
    wxCheckBox* m_IgnoreCase;
    wxCheckBox*  m_IsRegex;
    /// Control identifiers
    enum {
        ID_CEDITTEXTOPTIONSPANEL = 6250,
        ID_EDITTEXTOPTIONS_FIND = 6251,
        ID_EDITTEXTOPTIONS_REPLACE = 6252,
        ID_EDITTEXTOPTIONS_COPY = 6253,
        ID_EDITTEXTOPTIONS_ANYWHERE = 6254,
        ID_EDITTEXTOPTIONS_BEGINNING = 6255,
        ID_EDITTEXTOPTIONS_END = 6256,
        ID_EDITTEXTOPTIONS_CASE = 6257,
        ID_EDITTEXTOPTIONS_REGEX = 6258
    };
////@end CEditTextOptionsPanel member variables

    bool EditText(string& str);
    void SetFind(const string& str);

    string GetFind(void);
    string GetReplace(void);
    bool GetIgnoreCase(void);
    bool GetIsRegex(void);
    macro::CMacroFunction_EditStringQual::ESearchLoc GetSearchLoc(void);
    void ClearValues(void);
};

END_NCBI_SCOPE

#endif
    // GUI_WIDGETS_EDIT___EDIT_TEXT_OPTIONS_PANEL__HPP
