#ifndef _GUI_WIDGETS_EDIT___CROSSREF_FEATS_DLG_HPP_
#define _GUI_WIDGETS_EDIT___CROSSREF_FEATS_DLG_HPP_
/*  $Id: crossref_feats_dlg.hpp 32333 2015-02-05 21:05:04Z asztalos $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data,  the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties,  express or implied,  including
 *  warranties of performance,  merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Authors:  Andrea Asztalos
 */
// Generated by DialogBlocks (unregistered), 04/02/2015 12:11:44


#include <corelib/ncbistd.hpp>
#include <objmgr/seq_feat_handle.hpp>
#include <wx/dialog.h>

class wxCheckListBox;
class wxRadioBox;
class CCmdComposite;
class CFeat_id;

BEGIN_NCBI_SCOPE

/*!
 * Control identifiers
 */

////@begin control identifiers
#define SYMBOL_CCROSSREFFEATSDLG_STYLE wxCAPTION|wxRESIZE_BORDER|wxSYSTEM_MENU|wxCLOSE_BOX|wxTAB_TRAVERSAL
#define SYMBOL_CCROSSREFFEATSDLG_TITLE _("Cross referenced features")
#define SYMBOL_CCROSSREFFEATSDLG_IDNAME ID_CCROSSREFFEATSDLG
#define SYMBOL_CCROSSREFFEATSDLG_SIZE wxSize(400, 300)
#define SYMBOL_CCROSSREFFEATSDLG_POSITION wxDefaultPosition
////@end control identifiers


/*!
 * CCrossRefFeatsDlg class declaration
 */

class CCrossRefFeatsDlg: public wxDialog
{    
    DECLARE_DYNAMIC_CLASS( CCrossRefFeatsDlg )
    DECLARE_EVENT_TABLE()

public:
    typedef vector<objects::CSeq_feat_Handle> TFeatVec;
    /// Constructors
    CCrossRefFeatsDlg();
    CCrossRefFeatsDlg( wxWindow* parent, TFeatVec& feats, 
        const objects::CFeat_id::TLocal& feat_id,
        wxWindowID id = SYMBOL_CCROSSREFFEATSDLG_IDNAME, 
        const wxString& caption = SYMBOL_CCROSSREFFEATSDLG_TITLE, 
        const wxPoint& pos = SYMBOL_CCROSSREFFEATSDLG_POSITION, 
        const wxSize& size = SYMBOL_CCROSSREFFEATSDLG_SIZE, 
        long style = SYMBOL_CCROSSREFFEATSDLG_STYLE );

    /// Creation
    bool Create( wxWindow* parent, 
        wxWindowID id = SYMBOL_CCROSSREFFEATSDLG_IDNAME, 
        const wxString& caption = SYMBOL_CCROSSREFFEATSDLG_TITLE, 
        const wxPoint& pos = SYMBOL_CCROSSREFFEATSDLG_POSITION, 
        const wxSize& size = SYMBOL_CCROSSREFFEATSDLG_SIZE, 
        long style = SYMBOL_CCROSSREFFEATSDLG_STYLE );

    /// Destructor
    ~CCrossRefFeatsDlg();

    /// Initialises member variables
    void Init();

    /// Creates the controls and sizers
    void CreateControls();

////@begin CCrossRefFeatsDlg event handler declarations

////@end CCrossRefFeatsDlg event handler declarations

////@begin CCrossRefFeatsDlg member function declarations
    bool TransferDataToWindow();

    CRef<CCmdComposite> GetCommand();

    /// Retrieves bitmap resources
    wxBitmap GetBitmapResource( const wxString& name );

    /// Retrieves icon resources
    wxIcon GetIconResource( const wxString& name );
////@end CCrossRefFeatsDlg member function declarations

    /// Should we show tooltips?
    static bool ShowToolTips();

private:
////@begin CCrossRefFeatsDlg member variables
    wxCheckListBox* m_FeatList;
    wxRadioBox* m_Modify;

    TFeatVec m_Features;
    const objects::CFeat_id::TLocal* m_Featid;
    /// Control identifiers
    enum {
        ID_CCROSSREFFEATSDLG = 10000,
        ID_CHECKLISTBOX = 10001,
        ID_RADIOBOX = 10002
    };
////@end CCrossRefFeatsDlg member variables
};

END_NCBI_SCOPE

#endif
    // _GUI_WIDGETS_EDIT___CROSSREF_FEATS_DLG_HPP_
