#ifndef _GUI_PACKAGES_EDIT__TABLE_READER_MACRO_HPP_
#define _GUI_PACKAGES_EDIT__TABLE_READER_MACRO_HPP_

/*  $Id: table_reader_macro.hpp 45505 2020-08-19 20:50:12Z asztalos $
* ===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*               National Center for Biotechnology Information
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government have not placed any restriction on its use or reproduction.
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
*  Please cite the author in any work or product based on this material.
*
* ===========================================================================
*
* Authors:  Andrea Asztalos
*
* File Description:
*
*/

#include <corelib/ncbistd.hpp>
#include <objtools/edit/string_constraint.hpp>
#include <gui/widgets/edit/macro_editor_context.hpp>
#include <gui/packages/pkg_sequence_edit/macro_worker.hpp>

BEGIN_NCBI_SCOPE
BEGIN_SCOPE(objects)
    class CSeq_table;
    class CUser_object;
END_SCOPE(objects)

class IEditingAction;
class CConstraintPanel;

class NCBI_GUIPKG_SEQUENCE_EDIT_EXPORT CTableReaderMacro
{
public:
    using TVecMacroNames = CMacroWorker::TVecMacroNames;

    struct SColumnDelimiters
    {
        string m_Del;
        bool m_Merge_delimiters{ false };
        bool m_Split_first_col{ false };
        bool m_Multispace_to_tab{ false };
        bool m_Merge_first_two_cols{ false };
        bool m_Multiple_spaces_only{ false };

        SColumnDelimiters(const string& del,
            bool merge_delimiters = false,
            bool split_first_col = false,
            bool multispace_to_tab = false,
            bool merge_first_two_cols = false,
            bool multiple_spaces_only = false)
            : m_Del(del), m_Merge_delimiters(merge_delimiters), m_Split_first_col(split_first_col),
            m_Multispace_to_tab(multispace_to_tab), m_Merge_first_two_cols(merge_first_two_cols),
            m_Multiple_spaces_only (multiple_spaces_only)
        {}
    };
    CTableReaderMacro() {}
    ~CTableReaderMacro() {}


    TVecMacroNames CreateMacros(const wxString& filename,
        CRef<objects::CUser_object> column_properties, 
        const SColumnDelimiters& del_options,
        CConstraintPanel* panel = nullptr, 
        bool test = false);

    bool RunMacro(const TVecMacroNames& macros, objects::CSeq_entry_Handle entry, ICommandProccessor* cmd_processor);
    
    static bool s_LooksLikeHeader(const string& value);
    CTableReaderMacro(const CTableReaderMacro&) = delete;
    CTableReaderMacro& operator=(const CTableReaderMacro&) = delete;
private:

    struct SOneMacroData
    {
        string m_Iterator;
        EMacroFieldType m_Fieldtype{ EMacroFieldType::eNotSet };
        TStringPairsVector m_Values;
        vector<string> m_ColumnInfo;
        bool m_CreateProteins{ false };

        SOneMacroData() {}
        SOneMacroData(const string& iter) : m_Iterator(iter) {}
    };

    string x_GetVariables(const SColumnDelimiters& del_options, bool list_update_mrna = false) const;
    void x_GatherValuesAndMatchField();

    string x_GetIterator(const string& qual_type, EMacroFieldType& field_type, const string& qualifier, bool apply = false);
    
    // returns constraint pertaining to the maching field
    void x_GetMatchFieldConstraint(const SOneMacroData& data, const string& delimiter, TStringPairsVector& constraints);
    
    // returns a single string constraint
    TStringPairsVector x_GetStringConstraint(const string& target); 
    string x_GetFunction(SOneMacroData& data, TStringPairsVector& constraints);

    string x_GetMacro(SOneMacroData& data, const SColumnDelimiters& del_options);

    string x_GetCreateProtFeatsMacro();

    string m_Filename;
    CConstRef<objects::CUser_object> m_ColProperties;
    
    SFieldFromTable m_MatchField;
    EMacroFieldType m_MatchFieldType{ EMacroFieldType::eNotSet };

    CConstraintPanel* m_ConstraintPnl{ nullptr };

    vector<SOneMacroData> m_MacroVec;
};

END_NCBI_SCOPE

#endif
    // _GUI_PACKAGES_EDIT__TABLE_READER_MACRO_HPP_
