/*  $Id: string_constraint_select.hpp 34173 2015-11-17 20:39:26Z filippov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data,  the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties,  express or implied,  including
 *  warranties of performance,  merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Authors:  Igor Filippov
 */

// Generated by DialogBlocks (unregistered), 14/05/2014 15:44:27

#ifndef _STRING_CONSTRAINT_SELECT_H_
#define _STRING_CONSTRAINT_SELECT_H_


/*!
 * Includes
 */
#include <corelib/ncbistd.hpp>
#include <wx/grid.h>
#include <gui/packages/pkg_sequence_edit/string_constraint_panel.hpp>
#include <gui/packages/pkg_sequence_edit/seq_table_grid.hpp>

////@begin includes
////@end includes

/*!
 * Forward declarations
 */

////@begin forward declarations
////@end forward declarations

/*!
 * Control identifiers
 */
BEGIN_NCBI_SCOPE

////@begin control identifiers
#define ID_CSTRINGCONSTRAINTSELECT 10000
#define ID_CSTRINGCONSTRAINTSELECT_BUTTON 10001
#define ID_CSTRINGCONSTRAINTSELECT_BUTTON1 10002
#define ID_CSTRINGCONSTRAINTSELECT_RADIOBUTTON 10003
#define ID_CSTRINGCONSTRAINTSELECT_RADIOBUTTON1 10004
#define ID_CSTRINGCONSTRAINTSELECT_CHOICE 10005
#define ID_CSTRINGCONSTRAINTSELECT_PANEL 10006
#define ID_CSTRINGCONSTRAINTSELECT_BUTTON2 10007
#define SYMBOL_CSTRINGCONSTRAINTSELECT_STYLE wxTAB_TRAVERSAL
#define SYMBOL_CSTRINGCONSTRAINTSELECT_TITLE _("Check Rows")
#define SYMBOL_CSTRINGCONSTRAINTSELECT_IDNAME ID_CSTRINGCONSTRAINTSELECT
#define SYMBOL_CSTRINGCONSTRAINTSELECT_SIZE wxSize(400, 300)
#define SYMBOL_CSTRINGCONSTRAINTSELECT_POSITION wxDefaultPosition
////@end control identifiers


/*!
 * CStringConstraintSelect class declaration
 */

class CStringConstraintSelect: public wxPanel
{    
    DECLARE_DYNAMIC_CLASS( CStringConstraintSelect )
    DECLARE_EVENT_TABLE()

public:
    /// Constructors
    CStringConstraintSelect();
    CStringConstraintSelect( wxWindow* parent,  CSeqTableGridPanel* grid_panel, wxArrayString &choices, wxWindowID id = SYMBOL_CSTRINGCONSTRAINTSELECT_IDNAME, const wxPoint& pos = SYMBOL_CSTRINGCONSTRAINTSELECT_POSITION, const wxSize& size = SYMBOL_CSTRINGCONSTRAINTSELECT_SIZE, long style = SYMBOL_CSTRINGCONSTRAINTSELECT_STYLE );

    /// Creation
    bool Create( wxWindow* parent, wxWindowID id = SYMBOL_CSTRINGCONSTRAINTSELECT_IDNAME, const wxPoint& pos = SYMBOL_CSTRINGCONSTRAINTSELECT_POSITION, const wxSize& size = SYMBOL_CSTRINGCONSTRAINTSELECT_SIZE, long style = SYMBOL_CSTRINGCONSTRAINTSELECT_STYLE );

    /// Destructor
    ~CStringConstraintSelect();

    /// Initialises member variables
    void Init();

    /// Creates the controls and sizers
    void CreateControls();

////@begin CStringConstraintSelect event handler declarations

////@end CStringConstraintSelect event handler declarations

    void OnSelectAll( wxCommandEvent& event );
    void OnUnselectAll( wxCommandEvent& event );
    void OnApply( wxCommandEvent& event );

////@begin CStringConstraintSelect member function declarations

    /// Retrieves bitmap resources
    wxBitmap GetBitmapResource( const wxString& name );

    /// Retrieves icon resources
    wxIcon GetIconResource( const wxString& name );
////@end CStringConstraintSelect member function declarations

    /// Should we show tooltips?
    static bool ShowToolTips();

    void SetColumns(wxArrayString &columns) {m_ChoiceList->Set(columns);m_ChoiceList->SetSelection(0);Refresh();}
////@begin CStringConstraintSelect member variables
////@end CStringConstraintSelect member variables

    void UpdateCountSelectedDisplay(int num);
 private:
    int GetConstrainedColumn();
    void GetSelectedRows(set<int> &selected);

    CStringConstraintPanel* m_StringConstraintPanel;
    CSeqTableGridPanel* m_GridPanel;
    wxGrid *m_Grid;
    wxArrayString *m_Choices;
    wxRadioButton *m_CheckWhereButton, *m_UncheckWhereButton, *m_AddButton, *m_ExtractButton;
    wxChoice* m_ChoiceList;
    wxStaticText* m_Num;
};

END_NCBI_SCOPE
#endif
    // _STRING_CONSTRAINT_SELECT_H_
