/*  $Id: remove_text_outside_string_panel.hpp 41476 2018-08-02 20:44:57Z asztalos $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data,  the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties,  express or implied,  including
 *  warranties of performance,  merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Authors:  Colleen Bollin
 */
// Generated by DialogBlocks (unregistered), 15/07/2013 13:54:19

#ifndef _REMOVE_TEXT_OUTSIDE_STRING_PANEL_H_
#define _REMOVE_TEXT_OUTSIDE_STRING_PANEL_H_

#include <corelib/ncbistd.hpp>
#include <gui/objutils/macro_util.hpp>

/*!
 * Includes
 */

////@begin includes
////@end includes

#include <wx/textctrl.h>
#include <wx/checkbox.h>
#include <wx/radiobut.h>
#include <wx/panel.h>
#include <wx/sizer.h>

/*!
 * Forward declarations
 */

////@begin forward declarations
////@end forward declarations

BEGIN_NCBI_SCOPE

    /*!
 * Control identifiers
 */

////@begin control identifiers
#define SYMBOL_CREMOVETEXTOUTSIDESTRINGPANEL_STYLE wxTAB_TRAVERSAL
#define SYMBOL_CREMOVETEXTOUTSIDESTRINGPANEL_TITLE _("RemoveTextOutsideStringPanel")
#define SYMBOL_CREMOVETEXTOUTSIDESTRINGPANEL_IDNAME ID_CREMOVETEXTOUTSIDESTRINGPANEL
#define SYMBOL_CREMOVETEXTOUTSIDESTRINGPANEL_SIZE wxSize(400, 300)
#define SYMBOL_CREMOVETEXTOUTSIDESTRINGPANEL_POSITION wxDefaultPosition
////@end control identifiers


/*!
 * CRemoveTextOutsideStringPanel class declaration
 */

class CRemoveTextOutsideStringPanel: public wxPanel
{    
    DECLARE_DYNAMIC_CLASS( CRemoveTextOutsideStringPanel )
    DECLARE_EVENT_TABLE()

public:
    /// Constructors
    CRemoveTextOutsideStringPanel();
    CRemoveTextOutsideStringPanel( wxWindow* parent, wxWindowID id = SYMBOL_CREMOVETEXTOUTSIDESTRINGPANEL_IDNAME, const wxPoint& pos = SYMBOL_CREMOVETEXTOUTSIDESTRINGPANEL_POSITION, const wxSize& size = SYMBOL_CREMOVETEXTOUTSIDESTRINGPANEL_SIZE, long style = SYMBOL_CREMOVETEXTOUTSIDESTRINGPANEL_STYLE );

    /// Creation
    bool Create( wxWindow* parent, wxWindowID id = SYMBOL_CREMOVETEXTOUTSIDESTRINGPANEL_IDNAME, const wxPoint& pos = SYMBOL_CREMOVETEXTOUTSIDESTRINGPANEL_POSITION, const wxSize& size = SYMBOL_CREMOVETEXTOUTSIDESTRINGPANEL_SIZE, long style = SYMBOL_CREMOVETEXTOUTSIDESTRINGPANEL_STYLE );

    /// Destructor
    ~CRemoveTextOutsideStringPanel();

    /// Initialises member variables
    void Init();

    /// Creates the controls and sizers
    void CreateControls();

////@begin CRemoveTextOutsideStringPanel event handler declarations

    /// wxEVT_COMMAND_CHECKBOX_CLICKED event handler for ID_BEFORE_CHECKBOX
    void OnBeforeCheckboxClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for ID_BEFORE_TEXT_BTN
    void OnBeforeTextBtnSelected( wxCommandEvent& event );

    /// wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for ID_BEFORE_DIGITS_BTN
    void OnBeforeDigitsBtnSelected( wxCommandEvent& event );

    /// wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for ID_BEFORE_LETTERS_BTN
    void OnBeforeLettersBtnSelected( wxCommandEvent& event );

    /// wxEVT_COMMAND_CHECKBOX_CLICKED event handler for ID_AFTER_CHECKBOX
    void OnAfterCheckboxClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for ID_AFTER_TEXT_BTN
    void OnAfterTextBtnSelected( wxCommandEvent& event );

    /// wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for ID_AFTER_DIGITS_BTN
    void OnAfterDigitsBtnSelected( wxCommandEvent& event );

    /// wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for ID_AFTER_LETTERS_BTN
    void OnAfterLettersBtnSelected( wxCommandEvent& event );

////@end CRemoveTextOutsideStringPanel event handler declarations

////@begin CRemoveTextOutsideStringPanel member function declarations
    void ClearValues(void);

    /// Retrieves bitmap resources
    wxBitmap GetBitmapResource( const wxString& name );

    /// Retrieves icon resources
    wxIcon GetIconResource( const wxString& name );
////@end CRemoveTextOutsideStringPanel member function declarations

    /// Should we show tooltips?
    static bool ShowToolTips();

////@begin CRemoveTextOutsideStringPanel member variables
    wxCheckBox* m_BeforeCheckbox;
    wxRadioButton* m_BeforeTextBtn;
    wxTextCtrl* m_BeforeTextTxt;
    wxRadioButton* m_BeforeDigitsBtn;
    wxRadioButton* m_BeforeLettersBtn;
    wxCheckBox* m_AlsoRemoveBefore;
    wxCheckBox* m_AfterCheckbox;
    wxRadioButton* m_AfterTextBtn;
    wxTextCtrl* m_AfterTextTxt;
    wxRadioButton* m_AfterDigitsBtn;
    wxRadioButton* m_AfterLettersBtn;
    wxCheckBox* m_AlsoRemoveAfter;
    wxCheckBox* m_CaseBtn;
    wxCheckBox* m_WholeWordBtn;
////@end CRemoveTextOutsideStringPanel member variables

    CRef<macro::CRemoveTextOptions> GetRemoveTextOptions();

    enum {
        ID_CREMOVETEXTOUTSIDESTRINGPANEL = 6270,
        ID_BEFORE_CHECKBOX,
        ID_BEFORE_TEXT_BTN,
        ID_BEFORE_TEXT_TXT,
        ID_BEFORE_DIGITS_BTN,
        ID_BEFORE_LETTERS_BTN,
        ID_ALSO_REMOVE_BEFORE,
        ID_AFTER_CHECKBOX,
        ID_AFTER_TEXT_BTN,
        ID_AFTER_TEXT_TXT,
        ID_AFTER_DIGITS_BTN,
        ID_AFTER_LETTERS_BTN,
        ID_ALSO_REMOVE_AFTER,
        ID_CASE_BTN,
        ID_WHOLE_WORD_BTN
    };

private:
    void x_UpdateControls();
};

END_NCBI_SCOPE

#endif
    // _REMOVE_TEXT_OUTSIDE_STRING_PANEL_H_
