/*  $Id: field_choice_panel.hpp 42721 2019-04-05 16:17:33Z filippov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data,  the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties,  express or implied,  including
 *  warranties of performance,  merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Authors:  Colleen Bollin
 */
// Generated by DialogBlocks (unregistered), 12/06/2013 14:35:26

#ifndef _FIELD_CHOICE_PANEL_H_
#define _FIELD_CHOICE_PANEL_H_

#include <corelib/ncbistd.hpp>
#include <gui/widgets/edit/field_name_panel.hpp>

/*!
 * Includes
 */

////@begin includes
////@end includes

#include <wx/sizer.h>
#include <wx/choice.h>

/*!
 * Forward declarations
 */

////@begin forward declarations
class wxBoxSizer;
////@end forward declarations

BEGIN_NCBI_SCOPE

/*!
 * Control identifiers
 */

////@begin control identifiers
#define SYMBOL_CFIELDCHOICEPANEL_STYLE wxSIMPLE_BORDER|wxTAB_TRAVERSAL
#define SYMBOL_CFIELDCHOICEPANEL_TITLE _("FieldChoicePanel")
#define SYMBOL_CFIELDCHOICEPANEL_IDNAME ID_CFIELDCHOICEPANEL
#define SYMBOL_CFIELDCHOICEPANEL_SIZE wxDefaultSize
#define SYMBOL_CFIELDCHOICEPANEL_POSITION wxDefaultPosition
////@end control identifiers


/*!
 * CFieldChoicePanel class declaration
 */

class NCBI_GUIPKG_SEQUENCE_EDIT_EXPORT CFieldChoicePanel: public CFieldNamePanel
{    
    DECLARE_DYNAMIC_CLASS( CFieldChoicePanel )
    DECLARE_EVENT_TABLE()

public:
    /// Constructors
    CFieldChoicePanel();
    CFieldChoicePanel( wxWindow* parent, 
        const vector<CFieldNamePanel::EFieldType>& field_types, 
        bool horizontal = false, 
        bool is_pair = false, 
        wxWindowID id = SYMBOL_CFIELDCHOICEPANEL_IDNAME, 
        const wxPoint& pos = SYMBOL_CFIELDCHOICEPANEL_POSITION, 
        const wxSize& size = SYMBOL_CFIELDCHOICEPANEL_SIZE, 
        long style = SYMBOL_CFIELDCHOICEPANEL_STYLE );

    /// Creation
    bool Create( wxWindow* parent, 
        const vector<CFieldNamePanel::EFieldType>& field_types, 
        bool horizontal, 
        wxWindowID id = SYMBOL_CFIELDCHOICEPANEL_IDNAME, 
        const wxPoint& pos = SYMBOL_CFIELDCHOICEPANEL_POSITION, 
        const wxSize& size = SYMBOL_CFIELDCHOICEPANEL_SIZE, 
        long style = SYMBOL_CFIELDCHOICEPANEL_STYLE );

    /// Destructor
    ~CFieldChoicePanel();

    /// Initialises member variables
    void Init();

    /// Creates the controls and sizers
    void CreateControls();

////@begin CFieldChoicePanel event handler declarations

////@end CFieldChoicePanel event handler declarations

////@begin CFieldChoicePanel member function declarations

    /// Retrieves bitmap resources
    wxBitmap GetBitmapResource( const wxString& name );

    /// Retrieves icon resources
    wxIcon GetIconResource( const wxString& name );
////@end CFieldChoicePanel member function declarations

    /// Should we show tooltips?
    static bool ShowToolTips();

////@begin CFieldChoicePanel member variables
    wxBoxSizer* m_TopFieldTypeSizer;
    wxBoxSizer* m_SideFieldTypeSizer;
    wxBoxSizer* m_FieldPicker;
////@end CFieldChoicePanel member variables

    void OnFieldTypeChoiceSelected( wxCommandEvent& event );
    bool SetFieldType(CFieldNamePanel::EFieldType field_type, bool is_pair = false);
    void SetSubpanelSelection(const string &sel);
    string GetField1(const bool subfield = false);
    string GetField2(const bool subfield = false);
    const vector<CFieldNamePanel::EFieldType> GetFieldTypes();
    CFieldNamePanel::EFieldType GetFieldType();
    virtual vector<string> GetChoices(bool& allow_other);
    virtual string GetFieldName(const bool subfield = false);
    virtual bool SetFieldName(const string& field);
    // only set the first field name 
    bool SetOneFieldName(const string& field);
    // returns true if one of the fiels corresponds to 'protein name'
    bool IsOneFieldProteinName( void );
    void IncludeComposedItems(bool show);

    static string AutoMatch(string field_name);
    static string AutoMatch(string field_name, CFieldNamePanel::EFieldType field_type);
    static string AutoMatchSrc(string field_name);
    static string AutoMatchCGP(string field_name);
    static string AutoMatchMisc(string field_name);
    static string AutoMatchFeat(string field_name);
    static string AutoMatchRNA(string field_name);
    static string AutoMatchPub(string field_name);
    static string AutoMatchDBLink(string field_name);
    static string AutoMatchMolInfo(string field_name);

    static bool LooksLikeHeader(const vector<string>& field_names);
    CFieldNamePanel * GetFieldNamePanel(void) {return m_Field1;}
    CFieldNamePanel * GetFieldNamePanel2(void) {return m_Field2;}
    void SetShowLegalOnly(bool val) {m_show_legal_only = val;}

    enum {
        ID_CFIELDCHOICEPANEL = 6210,
        ID_CFIELD_TYPE_CHOICE
    };
private:
    wxChoice* m_FieldType;
    bool m_IsPair;
    bool m_IsHorizontal;
    bool m_Composed;
    vector<CFieldNamePanel::EFieldType> m_FieldTypes;
    CFieldNamePanel *m_Field1;
    CFieldNamePanel *m_Field2;
    bool m_show_legal_only;
};

wxDECLARE_EVENT(wxEVT_COMMAND_UPDATE_CONSTRAINT_FIELD, wxCommandEvent);

END_NCBI_SCOPE

#endif
    // _FIELD_CHOICE_PANEL_H_
