/*  $Id: autodef_org_panel.hpp 34927 2016-03-02 20:22:56Z asztalos $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data,  the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties,  express or implied,  including
 *  warranties of performance,  merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Authors:  Colleen Bollin
 */
// Generated by DialogBlocks (unregistered), 21/06/2013 14:02:01

#ifndef _AUTODEF_ORG_PANEL_H_
#define _AUTODEF_ORG_PANEL_H_

#include <corelib/ncbistd.hpp>

#include <gui/packages/pkg_sequence_edit/autodef_org_panel.hpp>
#include <gui/packages/pkg_sequence_edit/autodef_params.hpp>

/*!
 * Includes
 */

////@begin includes
////@end includes

#include <wx/sizer.h>
#include <wx/panel.h>
#include <wx/choice.h>
#include <wx/stattext.h>
#include <wx/checkbox.h>
#include <wx/radiobox.h>
#include <wx/statbox.h>

/*!
 * Forward declarations
 */

////@begin forward declarations
class wxFlexGridSizer;
class wxBoxSizer;
////@end forward declarations

BEGIN_NCBI_SCOPE

/*!
 * Control identifiers
 */

////@begin control identifiers
#define ID_CAUTODEFORGPANEL 10204
#define ID_MOD_LIST_TYPE 10190
#define ID_AD_MODLIMIT 10191
#define ID_AD_USE_LABELS 10199
#define ID_AD_LEAVE_PARENTHETICAL 10192
#define ID_AD_INCLUDE_COUNTRY_TEXT 10193
#define ID_AD_KEEP_AFTER_SEMICOLON 10194
#define ID_AD_DO_NOT_APPLY_TO_SP 10195
#define ID_AD_DO_NOT_APPLY_TO_CF 10196
#define ID_AD_DO_NOT_APPLY_TO_AFF 10196
#define ID_AD_DO_NOT_APPLY_TO_NR 10197
#define ID_AD_NO_MATCH_TAXNAME 10198
#define SYMBOL_CAUTODEFORGPANEL_STYLE wxTAB_TRAVERSAL
#define SYMBOL_CAUTODEFORGPANEL_TITLE _("AutodefOrgPanel")
#define SYMBOL_CAUTODEFORGPANEL_IDNAME ID_CAUTODEFORGPANEL
#define SYMBOL_CAUTODEFORGPANEL_SIZE wxSize(400, 300)
#define SYMBOL_CAUTODEFORGPANEL_POSITION wxDefaultPosition
////@end control identifiers


/*!
 * CAutodefOrgPanel class declaration
 */

class CAutodefOrgPanel: public wxPanel
{    
    DECLARE_DYNAMIC_CLASS( CAutodefOrgPanel )
    DECLARE_EVENT_TABLE()

public:
    /// Constructors
    CAutodefOrgPanel();
    CAutodefOrgPanel( wxWindow* parent, wxWindowID id = SYMBOL_CAUTODEFORGPANEL_IDNAME, const wxPoint& pos = SYMBOL_CAUTODEFORGPANEL_POSITION, const wxSize& size = SYMBOL_CAUTODEFORGPANEL_SIZE, long style = SYMBOL_CAUTODEFORGPANEL_STYLE );

    /// Creation
    bool Create( wxWindow* parent, wxWindowID id = SYMBOL_CAUTODEFORGPANEL_IDNAME, const wxPoint& pos = SYMBOL_CAUTODEFORGPANEL_POSITION, const wxSize& size = SYMBOL_CAUTODEFORGPANEL_SIZE, long style = SYMBOL_CAUTODEFORGPANEL_STYLE );

    /// Destructor
    ~CAutodefOrgPanel();

    /// Initialises member variables
    void Init();

    /// Creates the controls and sizers
    void CreateControls();

////@begin CAutodefOrgPanel event handler declarations

////@end CAutodefOrgPanel event handler declarations

////@begin CAutodefOrgPanel member function declarations

    /// Retrieves bitmap resources
    wxBitmap GetBitmapResource( const wxString& name );

    /// Retrieves icon resources
    wxIcon GetIconResource( const wxString& name );
////@end CAutodefOrgPanel member function declarations

    /// Should we show tooltips?
    static bool ShowToolTips();

////@begin CAutodefOrgPanel member variables
    wxChoice* m_ModListType;
    wxStaticText* m_MaxMods;
    wxChoice* m_MaxModifiers;
    wxCheckBox* m_UseLabels;
    wxStaticBox* m_AvailableModifiersSizer;
    wxFlexGridSizer* m_ModifierSizer;
    wxFlexGridSizer* m_OtherOptionsGrid;
    wxCheckBox* m_LeaveParen;
    wxCheckBox* m_IncludeCountry;
    wxCheckBox* m_KeepAfterSemicolon;
    wxCheckBox* m_NoSp;
    wxCheckBox* m_NoCf;
    wxCheckBox* m_NoAff;
    wxCheckBox* m_NoNr;
    wxCheckBox* m_NoMatchTaxname;
    wxBoxSizer* m_HIVRuleSizer;
////@end CAutodefOrgPanel member variables

    void SetParams(SAutodefParams* params);
    void PopulateParams(SAutodefParams& params);

    void Clear();

private:
    vector<wxCheckBox *> m_ModifierButtons;
    wxRadioBox* m_HIVRule;

    // number of columns of m_ModifierSizer 
    int m_ModifierSizerColumns;

    void x_AddHIVRule();
    // returns the number of listed modifiers;
    int x_ListModifiers(SAutodefParams& params);
};

END_NCBI_SCOPE

#endif
    // _AUTODEF_ORG_PANEL_H_
