/*  $Id: autodef_feat_clause_panel.hpp 36138 2016-08-16 12:00:45Z bollin $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data,  the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties,  express or implied,  including
 *  warranties of performance,  merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Authors:  Colleen Bollin
 */
// Generated by DialogBlocks (unregistered), 21/06/2013 14:35:39

#ifndef _AUTODEF_FEAT_CLAUSE_PANEL_H_
#define _AUTODEF_FEAT_CLAUSE_PANEL_H_

#include <corelib/ncbistd.hpp>

#include <gui/packages/pkg_sequence_edit/autodef_opt_feat_panel.hpp>
#include <gui/packages/pkg_sequence_edit/autodef_params.hpp>

/*!
 * Includes
 */

////@begin includes
////@end includes

#include <wx/choice.h>
#include <wx/checkbox.h>
#include <wx/panel.h>
#include <wx/textctrl.h>

/*!
 * Forward declarations
 */

////@begin forward declarations
class CAutodefOptFeatPanel;
////@end forward declarations

BEGIN_NCBI_SCOPE

/*!
 * Control identifiers
 */

////@begin control identifiers
#define SYMBOL_CAUTODEFFEATCLAUSEPANEL_STYLE wxTAB_TRAVERSAL
#define SYMBOL_CAUTODEFFEATCLAUSEPANEL_TITLE _("AutodefFeatClausePanel")
#define SYMBOL_CAUTODEFFEATCLAUSEPANEL_IDNAME ID_CAUTODEFFEATCLAUSEPANEL
#define SYMBOL_CAUTODEFFEATCLAUSEPANEL_SIZE wxSize(400, 300)
#define SYMBOL_CAUTODEFFEATCLAUSEPANEL_POSITION wxDefaultPosition
////@end control identifiers


/*!
 * CAutodefFeatClausePanel class declaration
 */

class CAutodefFeatClausePanel: public wxPanel
{    
    DECLARE_DYNAMIC_CLASS( CAutodefFeatClausePanel )
    DECLARE_EVENT_TABLE()

public:
    /// Constructors
    CAutodefFeatClausePanel();
    CAutodefFeatClausePanel( wxWindow* parent, wxWindowID id = SYMBOL_CAUTODEFFEATCLAUSEPANEL_IDNAME, const wxPoint& pos = SYMBOL_CAUTODEFFEATCLAUSEPANEL_POSITION, const wxSize& size = SYMBOL_CAUTODEFFEATCLAUSEPANEL_SIZE, long style = SYMBOL_CAUTODEFFEATCLAUSEPANEL_STYLE );

    /// Creation
    bool Create( wxWindow* parent, wxWindowID id = SYMBOL_CAUTODEFFEATCLAUSEPANEL_IDNAME, const wxPoint& pos = SYMBOL_CAUTODEFFEATCLAUSEPANEL_POSITION, const wxSize& size = SYMBOL_CAUTODEFFEATCLAUSEPANEL_SIZE, long style = SYMBOL_CAUTODEFFEATCLAUSEPANEL_STYLE );

    /// Destructor
    ~CAutodefFeatClausePanel();

    /// Initialises member variables
    void Init();

    /// Creates the controls and sizers
    void CreateControls();

////@begin CAutodefFeatClausePanel event handler declarations

    /// wxEVT_COMMAND_CHOICE_SELECTED event handler for ID_AD_LISTCHOICE
    void OnAdListchoiceSelected( wxCommandEvent& event );

    /// wxEVT_LEFT_DOWN event handler for ID_SUPPRESSFEATURETYPELIST
    void OnLeftDown( wxMouseEvent& event );

////@end CAutodefFeatClausePanel event handler declarations

////@begin CAutodefFeatClausePanel member function declarations

    /// Retrieves bitmap resources
    wxBitmap GetBitmapResource( const wxString& name );

    /// Retrieves icon resources
    wxIcon GetIconResource( const wxString& name );
////@end CAutodefFeatClausePanel member function declarations

    /// Should we show tooltips?
    static bool ShowToolTips();

////@begin CAutodefFeatClausePanel member variables
    wxChoice* m_FeatureListChoice;
    wxTextCtrl* m_CustomPhrase;
    wxChoice* m_ProductClauseChoice;
    wxCheckBox* m_AppendAltSplice;
    wxCheckBox* m_UseNcRNAComment;
    CAutodefOptFeatPanel* m_OptFeatPanel;
    wxTextCtrl* m_SuppressedFeatureTypeList;
    wxCheckBox* m_SuppressTransposon;
    wxCheckBox* m_SupressGeneCluster;
    wxCheckBox* m_SuppressLocusTags;
    wxCheckBox* m_SuppressAltSplice;
    wxCheckBox* m_SuppressMiscFeatSubFeat;
    /// Control identifiers
    enum {
        ID_CAUTODEFFEATCLAUSEPANEL = 10205,
        ID_AD_LISTCHOICE = 10200,
        ID_TEXTCTRL5 = 10061,
        ID_AD_PRODUCT_CLAUSE = 10201,
        ID_AD_ALTSPLICE_ADD = 10202,
        ID_AD_NCRNA_NOTE = 10203,
        ID_AD_WINDOW9 = 10224,
        ID_SUPPRESSFEATURETYPELIST = 10225,
        ID_AD_MOBILE_ELEMENT = 10226,
        ID_AD_GENE_CLUSTER = 10227,
        ID_AD_LOCUS_TAG = 10228,
        ID_AD_ALT_SPLICE_PHRASE = 10229,
        ID_AD_MISC_FEAT_SUBFEAT = 10006
    };
////@end CAutodefFeatClausePanel member variables
    void SetParams(SAutodefParams* params);
    void PopulateParams(SAutodefParams& params);

    void Clear();
private:
    set<objects::CFeatListItem> m_SuppressedFeatures;

    void x_UpdateSuppressedFeatureTypeList();
    void x_AllowFeatureOptions(bool val = true);
};

END_NCBI_SCOPE

#endif
    // _AUTODEF_FEAT_CLAUSE_PANEL_H_
