#ifndef PKG_ALIGNMENT___TAXTREE_TOOL_PARAMS__HPP
#define PKG_ALIGNMENT___TAXTREE_TOOL_PARAMS__HPP

/*  $Id: taxtree_tool_params.hpp 37336 2016-12-23 21:13:16Z katargir $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Authors:  Roman Katargin
 *
 * File Description:
 *
 */

#include <corelib/ncbiobj.hpp>

#include <gui/objutils/objects.hpp>
#include <gui/objutils/reg_settings.hpp>

#include <wx/string.h>

BEGIN_NCBI_SCOPE

/** @addtogroup GUI_PKG_ALIGNMENT
 *
 * @{
 */

/*!
 * CTaxTreeToolParams class declaration
 */

class CTaxTreeToolParams: public IRegSettings
{    
    friend class CTaxTreeToolPanel;
public:
    CTaxTreeToolParams();

    CTaxTreeToolParams(const CTaxTreeToolParams& data);

    ~CTaxTreeToolParams();

    void operator=(const CTaxTreeToolParams& data);

    bool operator==(const CTaxTreeToolParams& data) const;

    void Copy(const CTaxTreeToolParams& data);

    void Init();

    /// IRegSettings
    virtual void SetRegistryPath(const string& path) { m_RegPath = path; }
    virtual void SaveSettings() const;
    virtual void LoadSettings();

    const TConstScopedObjects& GetObjects() const { return m_Objects; }
    TConstScopedObjects& SetObjects() { return m_Objects; }

////@begin CTaxTreeToolParams member function declarations
////@end CTaxTreeToolParams member function declarations

////@begin CTaxTreeToolParams member variables
////@end CTaxTreeToolParams member variables

    string m_RegPath;
    TConstScopedObjects m_Objects;
};

/* @} */

END_NCBI_SCOPE

#endif // PKG_ALIGNMENT___TAXTREE_TOOL_PARAMS__HPP
