/*  $Id: group_alignments_params_panel.hpp 32655 2015-04-07 18:11:22Z evgeniev $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Authors:  Andrey Yazhuk
 *
 * File Description:
 *
 */

// Generated by DialogBlocks (unregistered), 17/07/2008 12:36:52

#ifndef _GROUP_ALIGNMENTS_PARAMS_PANEL_H_
#define _GROUP_ALIGNMENTS_PARAMS_PANEL_H_


/*!
 * Includes
 */

////@begin includes
#include "wx/listctrl.h"
////@end includes

#include <gui/objutils/reg_settings.hpp>

#include <gui/core/algo_tool_manager_base.hpp>

/*!
 * Forward declarations
 */

////@begin forward declarations
class CObjectListWidget;
////@end forward declarations

/*!
 * Control identifiers
 */

////@begin control identifiers
#define SYMBOL_CGROUPALIGNMENTSPARAMSPANEL_STYLE wxTAB_TRAVERSAL
#define SYMBOL_CGROUPALIGNMENTSPARAMSPANEL_TITLE _("Group Alignments Params Panel")
#define SYMBOL_CGROUPALIGNMENTSPARAMSPANEL_IDNAME ID_CGROUPALIGNMENTSPARAMSPANEL
#define SYMBOL_CGROUPALIGNMENTSPARAMSPANEL_SIZE wxSize(400, 300)
#define SYMBOL_CGROUPALIGNMENTSPARAMSPANEL_POSITION wxDefaultPosition
////@end control identifiers

BEGIN_NCBI_SCOPE

/** @addtogroup GUI_PKG_ALIGNMENT
 *
 * @{
 */

class CObjectListWidget;


class SGroupAlignmentsParams : public IRegSettings
{
public:
    SGroupAlignmentsParams();

    void Init();

    /// @name IRegSettings interface implementation
    /// @{
    virtual void SetRegistryPath(const string& reg_path);
    virtual void LoadSettings();
    virtual void SaveSettings() const;
    /// @}

public:
    string m_RegPath;

    TConstScopedObjects     m_Alignments;
    bool    m_GroupBySeqId;
    bool    m_GroupByStrand;
    bool    m_GroupByTaxId;
    bool    m_GroupByLikeTaxId;
    bool    m_GroupByRefSeq;
    bool    m_GroupByPredictedRefSeq;
    bool    m_GroupByEST;
    bool    m_GroupByGenBank;
    bool    m_GroupByWGS;
    bool    m_GroupByHTGS;
    bool    m_GroupByPatent;
};

///////////////////////////////////////////////////////////////////////////////
/// CGroupAlignmentsParamsPanel

class CGroupAlignmentsParamsPanel: public CAlgoToolManagerParamsPanel
{
    DECLARE_DYNAMIC_CLASS( CGroupAlignmentsParamsPanel )
    DECLARE_EVENT_TABLE()

public:
    CGroupAlignmentsParamsPanel();
    CGroupAlignmentsParamsPanel( wxWindow* parent, wxWindowID id = SYMBOL_CGROUPALIGNMENTSPARAMSPANEL_IDNAME, const wxPoint& pos = SYMBOL_CGROUPALIGNMENTSPARAMSPANEL_POSITION, const wxSize& size = SYMBOL_CGROUPALIGNMENTSPARAMSPANEL_SIZE, long style = SYMBOL_CGROUPALIGNMENTSPARAMSPANEL_STYLE );

    bool Create( wxWindow* parent, wxWindowID id = SYMBOL_CGROUPALIGNMENTSPARAMSPANEL_IDNAME, const wxPoint& pos = SYMBOL_CGROUPALIGNMENTSPARAMSPANEL_POSITION, const wxSize& size = SYMBOL_CGROUPALIGNMENTSPARAMSPANEL_SIZE, long style = SYMBOL_CGROUPALIGNMENTSPARAMSPANEL_STYLE );

    ~CGroupAlignmentsParamsPanel();

    void Init();

    void CreateControls();

    void SetParams(SGroupAlignmentsParams* params, TConstScopedObjects* objects);
    bool TransferDataToWindow();
    bool TransferDataFromWindow();

    /// @name CAlgoToolManagerParamsPanel implementation
    void RestoreDefaults();
    /// @}

////@begin CGroupAlignmentsParamsPanel event handler declarations

////@end CGroupAlignmentsParamsPanel event handler declarations

////@begin CGroupAlignmentsParamsPanel member function declarations

    wxBitmap GetBitmapResource( const wxString& name );

    wxIcon GetIconResource( const wxString& name );
////@end CGroupAlignmentsParamsPanel member function declarations

    static bool ShowToolTips();

////@begin CGroupAlignmentsParamsPanel member variables
    CObjectListWidget* m_ObjectList;
    wxCheckBox* m_GroupBySeqId;
    wxCheckBox* m_GroupByStrand;
    wxCheckBox* m_GroupByTaxId;
    wxCheckBox* m_GroupByLikeTaxId;
    wxCheckBox* m_GroupByRefSeq;
    wxCheckBox* m_GroupByEST;
    wxCheckBox* m_GroupByPredictedRefSeq;
    wxCheckBox* m_GroupByGenBank;
    wxCheckBox* m_GroupByWGS;
    wxCheckBox* m_GroupByHTGS;
    wxCheckBox* m_GroupByPatent;
    enum {
        ID_CGROUPALIGNMENTSPARAMSPANEL = 10002,
        ID_LISTCTRL = 10004,
        ID_CHECKBOX_SEQID = 10005,
        ID_CHECKBOX_STRAND = 10006,
        ID_CHECKBOX_TAXID = 10000,
        ID_CHECKBOX_SIMILAR_TAXID = 10001,
        ID_CHECKBOX_REFSEQ = 10007,
        ID_CHECKBOX_EST = 10008,
        ID_CHECKBOX_REFSEQ_PREDICTED = 10009,
        ID_CHECKBOX_GENBANK = 10010,
        ID_CHECKBOX_WGS = 10011,
        ID_CHECKBOX_HTGS = 10012,
        ID_CHECKBOX_PATENT = 10003
    };
////@end CGroupAlignmentsParamsPanel member variables

public:
    virtual void    SetRegistryPath(const string& path);
    virtual void    LoadSettings();
    virtual void    SaveSettings() const;

protected:
    SGroupAlignmentsParams* m_Params;
    TConstScopedObjects*    m_InputObjects;

    bool    m_InputListDirty;

    string  m_RegPath;
};

/* @} */

END_NCBI_SCOPE

#endif
    // _GROUP_ALIGNMENTS_PARAMS_PANEL_H_
