/*  $Id: cleanup_alignments_params_panel.hpp 32655 2015-04-07 18:11:22Z evgeniev $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Authors:  Andrey Yazhuk
 *
 * File Description:
 *
 */

// Generated by DialogBlocks (unregistered), 18/07/2008 15:31:02

#ifndef _CLEANUP_ALIGNMENTS_PARAMS_PANEL_H_
#define _CLEANUP_ALIGNMENTS_PARAMS_PANEL_H_


/*!
 * Includes
 */

#include <gui/objutils/reg_settings.hpp>
#include <gui/widgets/object_list/object_list_widget.hpp>
#include <gui/core/algo_tool_manager_base.hpp>


////@begin includes
#include "wx/listctrl.h"
////@end includes

#include <wx/combobox.h>

/*!
 * Forward declarations
 */

////@begin forward declarations
class CObjectListWidget;
class wxBoxSizer;
////@end forward declarations

/*!
 * Control identifiers
 */

////@begin control identifiers
#define SYMBOL_CCLEANUPALIGNMENTSPARAMSPANEL_STYLE wxTAB_TRAVERSAL
#define SYMBOL_CCLEANUPALIGNMENTSPARAMSPANEL_TITLE _("Clean Up Alignments Params Panel")
#define SYMBOL_CCLEANUPALIGNMENTSPARAMSPANEL_IDNAME ID_CCLEANUPALIGNMENTSPARAMSPANEL
#define SYMBOL_CCLEANUPALIGNMENTSPARAMSPANEL_SIZE wxSize(400, 300)
#define SYMBOL_CCLEANUPALIGNMENTSPARAMSPANEL_POSITION wxDefaultPosition
////@end control identifiers

BEGIN_NCBI_SCOPE

/** @addtogroup GUI_PKG_ALIGNMENT
 *
 * @{
 */

class CObjectListWidget;

/*!
 * CCleanupAlignmentsParamsPanel class declaration
 */

class SCleanupAlignmentsParams : public IRegSettings
{
public:
    SCleanupAlignmentsParams();

    void Init();

    /// @name IRegSettings interface implementation
    /// @{
    virtual void SetRegistryPath(const string& reg_path);
    virtual void LoadSettings();
    virtual void SaveSettings() const;
    /// @}

public:
    string m_RegPath;
    TConstScopedObjects     m_Alignments;

    /// which algorithm are we using?
    enum EAlgorithm {
        eHitFilter,
        eAlignmentManager
    };
    EAlgorithm m_Algo;

    //
    // hit filter params
    //
    int   m_HitFilter_MinLength;
    float m_HitFilter_MinIdentity;

    //
    // alignment manager params
    //
    bool m_AlnMgr_PreserveRows;
    bool m_AlnMgr_Transloc;
    bool m_AlnMgr_Sort;
    bool m_AlnMgr_FillUnaligned;
};

class CCleanupAlignmentsParamsPanel: public CAlgoToolManagerParamsPanel
{
    DECLARE_DYNAMIC_CLASS( CCleanupAlignmentsParamsPanel )
    DECLARE_EVENT_TABLE()

public:
    CCleanupAlignmentsParamsPanel();
    CCleanupAlignmentsParamsPanel( wxWindow* parent, wxWindowID id = SYMBOL_CCLEANUPALIGNMENTSPARAMSPANEL_IDNAME, const wxPoint& pos = SYMBOL_CCLEANUPALIGNMENTSPARAMSPANEL_POSITION, const wxSize& size = SYMBOL_CCLEANUPALIGNMENTSPARAMSPANEL_SIZE, long style = SYMBOL_CCLEANUPALIGNMENTSPARAMSPANEL_STYLE );

    bool Create( wxWindow* parent, wxWindowID id = SYMBOL_CCLEANUPALIGNMENTSPARAMSPANEL_IDNAME, const wxPoint& pos = SYMBOL_CCLEANUPALIGNMENTSPARAMSPANEL_POSITION, const wxSize& size = SYMBOL_CCLEANUPALIGNMENTSPARAMSPANEL_SIZE, long style = SYMBOL_CCLEANUPALIGNMENTSPARAMSPANEL_STYLE );

    ~CCleanupAlignmentsParamsPanel();

    void Init();

    void CreateControls();

    void SetParams(SCleanupAlignmentsParams* params, TConstScopedObjects* objects);
    bool TransferDataToWindow();
    bool TransferDataFromWindow();

    /// @name CAlgoToolManagerParamsPanel implementation
    void RestoreDefaults();
    /// @}

    virtual void    SetRegistryPath(const string& path);
    virtual void    LoadSettings();
    virtual void    SaveSettings() const;

////@begin CCleanupAlignmentsParamsPanel event handler declarations

    void OnComboboxSelected( wxCommandEvent& event );

////@end CCleanupAlignmentsParamsPanel event handler declarations

////@begin CCleanupAlignmentsParamsPanel member function declarations

    wxBitmap GetBitmapResource( const wxString& name );

    wxIcon GetIconResource( const wxString& name );
////@end CCleanupAlignmentsParamsPanel member function declarations

    static bool ShowToolTips();

////@begin CCleanupAlignmentsParamsPanel member variables
    CObjectListWidget* m_ObjectList;
    wxComboBox* m_AlgoSelector;
    wxBoxSizer* m_ParamsPanel;
    wxTextCtrl* m_HitFilter_MinIdentity;
    wxTextCtrl* m_HitFilter_MinLength;
    wxCheckBox* m_AlnMgr_Transloc;
    wxCheckBox* m_AlnMgr_Sort;
    wxCheckBox* m_AlnMgr_PreserveRows;
    wxCheckBox* m_AlnMgr_FillUnaligned;
    enum {
        ID_CCLEANUPALIGNMENTSPARAMSPANEL = 10013,
        ID_LISTCTRL2 = 10014,
        ID_COMBOBOX = 10015,
        ID_TEXTCTRL1 = 10017,
        ID_TEXTCTRL = 10016,
        ID_CHECKBOX1 = 10019,
        ID_CHECKBOX2 = 10020,
        ID_CHECKBOX = 10018,
        ID_CHECKBOX5 = 10033
    };
////@end CCleanupAlignmentsParamsPanel member variables

private:
    /// Switch params panel according to current algo-selector
    void x_AdjustToAlgoSelector();
private:
    SCleanupAlignmentsParams* m_Params;
    TConstScopedObjects*    m_InputObjects;

    bool    m_InputListDirty;

    string  m_RegPath;
};


/* @} */

END_NCBI_SCOPE

#endif // _CLEANUP_ALIGNMENTS_PARAMS_PANEL_H_
