#ifndef GUI_OBJUTILS___JSON_VERSION_INFO__HPP
#define GUI_OBJUTILS___JSON_VERSION_INFO__HPP

/*  $Id: json_version_info.hpp 45355 2020-07-13 19:58:34Z evgeniev $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Vladislav Evgeniev
 *
 *
 */

/// @file json_version_info.hpp
/// Define Returns binary version information in JSON format.

#include <string>
#include <gui/gui_export.h>
#include <cgi/ncbicgi.hpp>
#include <cgi/ncbicgir.hpp>

BEGIN_NCBI_SCOPE

/// Reports version information in JSON format
/// @param[in] request
///     Reference to the CGI request.
/// @param[in] response
///     Reference to the CGI response.
/// @return
///     True if this is a version information request, false otherwise.
NCBI_GUIOBJUTILS_EXPORT bool ReportJSONVersion(const CCgiRequest& request, CCgiResponse& response);

/// Delay test, simulating Grid framework delay
/// @param[in] request
///     Reference to the CGI request.
NCBI_GUIOBJUTILS_EXPORT void TestDelay(const CCgiRequest& request);

END_NCBI_SCOPE

#endif  /// GUI_OBJUTILS___JSON_VERSION_INFO__HPP
