/* $Id: gbench_svc_cli.hpp 25559 2012-04-06 22:45:48Z voronov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file gbench_svc_cli.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'gbench_svc.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: gbench_svc_cli_.hpp


#ifndef GUI_CORE_GBENCH_SVC_CLI_HPP
#define GUI_CORE_GBENCH_SVC_CLI_HPP

#include <corelib/ncbitime.hpp>

#include <gui/objects/gbench_svc_cli_.hpp>
#include <gui/objects/GBenchVersionInfo.hpp>


BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

//TODO this library is a wrong place for this class !!!

/////////////////////////////////////////////////////////////////////////////
class NCBI_GUIOBJECTS_EXPORT CGBenchService : public CGBenchService_Base
{
    typedef CGBenchService_Base Tparent;
public:
    // constructor
    CGBenchService(void);
    // destructor
    ~CGBenchService(void);

    /// send an init message with information about our client
    CRef<CGBenchInitReply> SendInit(const CGBenchVersionInfo& version);

    /// format and file a feedback report
    void SendFeedbackReport(const string& msg, const string& email_addr,
                            const CGBenchVersionInfo& version,
                            CNcbiIstream* app_log_istr,
                            CNcbiIstream* sys_config_istr);

    CRef<CUser_object> SendAppStart( const CGBenchVersionInfo& version );
	bool SendAppFinish( const CGBenchVersionInfo& version );

private:
    /// override x_Connect() to provide a testing interface
    void x_Connect();

private:
    // Prohibit copy constructor and assignment operator
    CGBenchService(const CGBenchService& value);
    CGBenchService& operator=(const CGBenchService& value);

private:
	CStopWatch m_Timer;
};

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

#endif // GUI_CORE_GBENCH_SVC_CLI_HPP
/* Original file checksum: lines: 94, chars: 2640, CRC32: a1b5a91d */
