#ifndef GUI_OBJECTS_GUI_PROJECT_WORKSPACEFOLDER_HPP
#define GUI_OBJECTS_GUI_PROJECT_WORKSPACEFOLDER_HPP

/* $Id: WorkspaceFolder.hpp 30114 2014-04-09 18:11:20Z katargir $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file WorkspaceFolder.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'gui_project.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: WorkspaceFolder_.hpp


// generated includes
#include <gui/objects/WorkspaceFolder_.hpp>

// generated classes

#include <corelib/ncbicntr.hpp>

#include <gui/objects/GBProjectHandle.hpp>

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

class CGBProjectHandle;

/////////////////////////////////////////////////////////////////////////////
class NCBI_GUIOBJECTS_EXPORT CWorkspaceFolder : public CWorkspaceFolder_Base
{
    typedef CWorkspaceFolder_Base Tparent;
public:
    /// auto-incremented project Id, unique within an application session
    typedef int TId;

    class IProjectVisitor
    {
    public:
        virtual bool    Visit(objects::CGBProjectHandle& project) = 0;
        virtual ~IProjectVisitor()    {};
    };

public:
    CWorkspaceFolder(void);
    ~CWorkspaceFolder(void);

public:
    TId GetId() const { return m_Id; }

    const CGBProjectHandle* GetProject(CGBProjectHandle::TId id) const;
    CGBProjectHandle*       GetProject(CGBProjectHandle::TId id);

    const CWorkspaceFolder* FindParentFolder(CGBProjectHandle::TId id) const;
    CWorkspaceFolder*       FindParentFolder(CGBProjectHandle::TId id);

    bool    RemoveProject(CGBProjectHandle::TId id);

    CGBProjectHandle* FindProjectById(CGBProjectHandle::TId id,
                                      bool recursive);
    /// finds a project in the folder and its sub folders
    CGBProjectHandle* FindProjectByFilename(const string& filename);

    CWorkspaceFolder* FindChildFolderById(TId id, bool recursive);
    CWorkspaceFolder* FindChildFolderByTitle(const string& title);

    void    AddProject(CGBProjectHandle& project);

    void    AddChildFolder(CWorkspaceFolder& child_folder);
    void    RemoveChildFolder(TId id);

    CRef<CWorkspaceFolder>  RemoveProjectFolder(CWorkspaceFolder::TId id);

    /// applies the given visitor to all projects until the visitor returns false
    bool    ForEachProject(IProjectVisitor& visitor, bool recursive);

private:
    // Prohibit copy constructor and assignment operator
    CWorkspaceFolder(const CWorkspaceFolder& value);
    CWorkspaceFolder& operator=(const CWorkspaceFolder& value);

protected:
    static CAtomicCounter   m_IdCounter;

    /// instance run-time Id, unique within an application session
    TId m_Id;
};

/////////////////// CWorkspaceFolder inline methods

// constructor
inline
CWorkspaceFolder::CWorkspaceFolder(void)
{
    m_Id = m_IdCounter.Add(1) - 1;
}

/////////////////// end of CWorkspaceFolder inline methods

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // GUI_OBJECTS_GUI_PROJECT_WORKSPACEFOLDER_HPP
/* Original file checksum: lines: 86, chars: 2569, CRC32: 512adbca */
