/* $Id: PluginValueConstraint.hpp 14666 2007-07-09 13:40:22Z dicuccio $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the data definition file
 *   'plugin.asn'.
 */

#ifndef GUI_CORE_PLUGIN_PLUGINVALUECONSTRAINT_HPP
#define GUI_CORE_PLUGIN_PLUGINVALUECONSTRAINT_HPP


// generated includes
#include <gui/objects/PluginValueConstraint_.hpp>
#include <objects/seq/Seq_inst.hpp>
#include <objects/seq/Seq_annot.hpp>
#include <objects/seqfeat/Seq_feat.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

class NCBI_GUIOBJECTS_EXPORT CPluginValueConstraint : public CPluginValueConstraint_Base
{
    typedef CPluginValueConstraint_Base Tparent;
public:
    // default constructor
    CPluginValueConstraint(void);

    // destructor
    ~CPluginValueConstraint(void);

    //
    // static factory create functions to create and return constraints
    //

    // create a constraint for a built-in type such that the value is greater
    // than or equal to a given bound
    static CPluginValueConstraint* CreateLower(const string& low_val);

    // create a constraint for a built-in type such that the value is less
    // than or equal to a given bound
    static CPluginValueConstraint* CreateUpper(const string& hi_val);

    // create a constraint for a built-in type such that the value is bounded
    // in the range [low_val, hi_val]
    static CPluginValueConstraint* CreateRange(const string& low_val,
                                             const string& hi_val);

    // create a constraint for a built-in type such that the value is one of a
    // member of a set of values
    static CPluginValueConstraint* CreateSet(void);

    // create a constraint on a given sequence representation  Types are
    // appended with the ',' operator.  For example:
    //     *CreateSeqMol(), CSeq_inst::eRepr_raw, CSeq_inst::eRepr_delta
    static CPluginValueConstraint* CreateSeqRepr();

    // create a constraint on a given molecule type,  Types are appended
    // with the ',' operator.  For example:
    //     *CreateSeqMol(), CSeq_inst::eMol_dna, CSeq_ins::eMol_na
    static CPluginValueConstraint* CreateSeqMol();

    // create a constraint on a given molecule type to be the same for multiple
    // sequences
    static CPluginValueConstraint* CreateSeqSameMol(void);

    // create a constraint on a given sequence length (lower bound)
    static CPluginValueConstraint* CreateSeqLenLower(TSeqPos min_len);

    // create a constraint on a given sequence length (upper bound)
    static CPluginValueConstraint* CreateSeqLenUpper(TSeqPos max_len);

    // create a constraint on a given sequence length (range)
    static CPluginValueConstraint* CreateSeqLenRange(TSeqPos min_len,
                                                   TSeqPos max_len);

    // create a constraint on a given molecule type
    static CPluginValueConstraint* CreateAnnotType(CSeq_annot::TData::E_Choice);

    // create a constraint on a given feature type
    static CPluginValueConstraint* CreateFeatType();

    // create a constraint on a given feature subtype
    static CPluginValueConstraint* CreateFeatSubtype();

    // create a constraint that a given feature have its product set
    static CPluginValueConstraint* CreateFeatProduct();

    // create a constraint that a given feature have its product set
    static CPluginValueConstraint* CreateProjectItemType(const CTypeInfo* info);

    // operator, adds elements to the set, or replaces the value stored
    CPluginValueConstraint& operator,(const string& val);
    CPluginValueConstraint& operator,(int val);

private:
    // Prohibit copy constructor and assignment operator
    CPluginValueConstraint(const CPluginValueConstraint& value);
    CPluginValueConstraint& operator=(const CPluginValueConstraint& value);

};



/////////////////// CPluginValueConstraint inline methods

// constructor
inline
CPluginValueConstraint::CPluginValueConstraint(void)
{
}


/////////////////// end of CPluginValueConstraint inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

#endif // GUI_CORE_PLUGIN_PLUGINVALUECONSTRAINT_HPP
/* Original file checksum: lines: 93, chars: 2569, CRC32: adc3c61b */
