/* $Id: PluginValue.hpp 30280 2014-04-23 20:28:26Z katargir $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the data definition file
 *   'plugin.asn'.
 */

#ifndef GUI_CORE_PLUGIN_PLUGINURL_HPP
#define GUI_CORE_PLUGIN_PLUGINURL_HPP


// generated includes
#include <gui/objects/PluginObject.hpp>
#include <gui/objects/PluginValue_.hpp>
#include <gui/objects/PluginArg.hpp>

#include <gui/objects/plugin_exception.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE /// namespace ncbi::objects::

class CGBProjectHandle;


class NCBI_GUIOBJECTS_EXPORT CPluginValue
    : public CPluginValue_Base
{
    typedef CPluginValue_Base Tparent;
public:
    /// default constructor
    CPluginValue(void);

    /// conversion constructors
    CPluginValue(int i);
    CPluginValue(double d);
    CPluginValue(bool b);
    CPluginValue(const string& str);
    CPluginValue(const CGBProjectHandle& doc);
    CPluginValue(const CObject& obj, const CGBProjectHandle* doc = NULL, const CDataHandle * dh = NULL);
    CPluginValue(const CTypeInfo* info);

    /// destructor
    ~CPluginValue(void);

    /// Print a copy of the value stored to the output stream
    void Print(CNcbiOstream& ostr) const;

    /// determine if this argument has an empty value
    bool IsEmpty(void) const;

    /// Special accessor for the implied or actual document
    const CGBProjectHandle* GetProject(void) const;

    /// Special accessor for the stored object
    const CObject*   GetObject(void) const;

    /// Special accessor for any named object subtype
    const string&  GetObjectSubtype(void) const;

    bool             AsBoolean     (void) const;
    int              AsInteger     (void) const;
    double           AsDouble      (void) const;
    const string&    AsString      (void) const;
    const string&    AsSecretString(void) const;
    const string&    AsInputFile   (void) const;
    const string&    AsOutputFile  (void) const;
    const CGBProjectHandle& AsProject    (void) const;
    const CObject&   AsObject      (void) const;

    /// type-specific setters
    const string& SetInteger();
    void SetInteger(const string& str);
    void SetInteger(int val);

    const string& SetDouble();
    void SetDouble(const string& str);
    void SetDouble(double val);

    const string& SetBoolean();
    void SetBoolean(const string& str);
    void SetBoolean(bool val);

    /// setters for object arguments
    void SetProject(void);
    void SetProject(const CGBProjectHandle& doc);

    void SetObject(const CObject& obj, const CGBProjectHandle* doc = NULL, const CDataHandle * dh = NULL);
    void SetObject(const CTypeInfo* info = NULL);
    void SetObject(const string& subtype);

private:

    /// Prohibit copy constructor and assignment operator
    CPluginValue(const CPluginValue& value);
    CPluginValue& operator=(const CPluginValue& value);

};


/////////////////// CPluginValue inline methods

inline
const CGBProjectHandle* CPluginValue::GetProject(void) const
{
    if (IsProject()) {
        return Tparent::GetProject().GetProject();
    }

    if (IsObject()) {
        return Tparent::GetObject().GetProject();
    }

    NCBI_THROW(CPluginException, eInvalidArg,
               "Attempt to access non-object argument as object");
}


inline
const CObject* CPluginValue::GetObject(void) const
{
    if (IsProject()) {
        return Tparent::GetProject().GetObject();
    } else if (IsObject()) {
        return Tparent::GetObject().GetObject();
    }

    NCBI_THROW(CPluginException, eInvalidArg,
               "Attempt to access non-object argument as object");
}

/////////////////// end of CPluginValue inline methods


END_objects_SCOPE /// namespace ncbi::objects::

END_NCBI_SCOPE

#endif /// GUI_CORE_PLUGIN_PLUGINURL_HPP
/* Original file checksum: lines: 93, chars: 2297, CRC32: e57c0a79 */
