/* $Id: PluginObject.hpp 30280 2014-04-23 20:28:26Z katargir $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the data definition file
 *   'plugin.asn'.
 */

#ifndef GUI_PLUGIN_PLUGINOBJECT_HPP
#define GUI_PLUGIN_PLUGINOBJECT_HPP


// generated includes
#include <gui/objects/PluginObject_.hpp>

// generated classes

BEGIN_NCBI_SCOPE


BEGIN_objects_SCOPE /// namespace ncbi::objects::

class NCBI_GUIOBJECTS_EXPORT CPluginObject
    : public CPluginObject_Base, public CSerialUserOp
{
    typedef CPluginObject_Base Tparent;
public:
    /// constructor
    CPluginObject(void);
    /// destructor
    ~CPluginObject(void);

    /// overloaded Reset() - allows us to clear our derived types
    void Reset(void);

    /// PostRead() - provides ability to set derived type
    void PostRead();

    /// access the project for this object
    const CGBProjectHandle* GetProject(void) const;

    /// access the object for this object
    const CObject* GetObject(void) const;

    /// find out if this object is empty
    bool IsEmpty(void) const;

    void SetProject(const CGBProjectHandle* doc);
    void SetObject(const string& type);
    void SetObject(const CTypeInfo* info = NULL);
    void SetObject(const CObject& obj, const CGBProjectHandle* scope = NULL, const CDataHandle * dh = NULL);


protected:
    /// From CSerialUserOp
    virtual void UserOp_Assign(const CSerialUserOp& source);
    virtual bool UserOp_Equals(const CSerialUserOp& object) const;

    /// we must hold CConstRef<>s of our object to make sure they don't
    /// fall out of scope
    CConstRef<CGBProjectHandle> m_Project;
    CConstRef<CObject>          m_Object;

private:
    /// Prohibit copy constructor and assignment operator
    CPluginObject(const CPluginObject& value);
    CPluginObject& operator=(const CPluginObject& value);

};



/////////////////// CPluginObject inline methods

// constructor
inline
CPluginObject::CPluginObject(void)
{
}


inline
const CObject* CPluginObject::GetObject(void) const
{
    return m_Object.GetPointer();
}


inline
const CGBProjectHandle* CPluginObject::GetProject(void) const
{
    return m_Project.GetPointer();
}


inline
bool CPluginObject::IsEmpty(void) const
{
    return ( !m_Project  &&  !m_Object );
}


/////////////////// end of CPluginObject inline methods


END_objects_SCOPE /// namespace ncbi::objects::

END_NCBI_SCOPE

NCBISER_HAVE_POST_READ(ncbi::objects::CPluginObject)

#endif /// GUI_PLUGIN_PLUGINOBJECT_HPP
/* Original file checksum: lines: 93, chars: 2452, CRC32: c82dc3f1 */
