/* $Id: PluginInfoSet.hpp 14666 2007-07-09 13:40:22Z dicuccio $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @PluginInfoSet.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'plugin.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: PluginInfoSet_.hpp


#ifndef GUI_CORE_PLUGININFOSET_HPP
#define GUI_CORE_PLUGININFOSET_HPP


// generated includes
#include <gui/objects/PluginInfoSet_.hpp>
#include <gui/objects/PluginInfo.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_GUIOBJECTS_EXPORT CPluginInfoSet : public CPluginInfoSet_Base
{
    typedef CPluginInfoSet_Base Tparent;
public:
    // constructor
    CPluginInfoSet(void);
    // destructor
    ~CPluginInfoSet(void);

    // set all fields in one pass
    CPluginInfo& CreateInfo(int major, int minor, int rev,
                            const string& build_date,
                            const string& class_name,
                            const string& menu_item,
                            const string& tooltip,
                            const string& help_file);

    /// for view plugins only
    CPluginInfo& CreateInfo(int major, int minor, int rev,
                            const string& build_date,
                            const string& class_name,
                            const string& menu_item,
                            const string& tooltip,
                            const string& help_file,
                            const string& icon_alias,
                            const string& icon_local_path);

    int GetVer_major() const;
    int GetVer_minor() const;
    int GetVer_revision() const;
    string GetVer_build_date() const;
    string GetClass_name() const;

private:
    // Prohibit copy constructor and assignment operator
    CPluginInfoSet(const CPluginInfoSet& value);
    CPluginInfoSet& operator=(const CPluginInfoSet& value);

};

/////////////////// CPluginInfoSet inline methods

// constructor
inline
CPluginInfoSet::CPluginInfoSet(void)
{
}


/////////////////// end of CPluginInfoSet inline methods


END_objects_SCOPE // namespace ncbi::objects::

#define MAKE_MENU_PATH( path, name )    path name

END_NCBI_SCOPE

#endif // GUI_CORE_PLUGININFOSET_HPP
/* Original file checksum: lines: 94, chars: 2627, CRC32: a8bad1e0 */
