/* $Id: PluginInfo.hpp 15168 2007-10-15 19:11:34Z dicuccio $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the data definition file
 *   'plugin.asn'.
 */

#ifndef GUI_PLUGIN_PLUGININFO_HPP
#define GUI_PLUGIN_PLUGININFO_HPP

#include <corelib/ncbistr.hpp>

// generated includes
#include <gui/objects/PluginInfo_.hpp>
#include <gui/objects/PluginCommand.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

class NCBI_GUIOBJECTS_EXPORT CPluginInfo : public CPluginInfo_Base
{
    typedef CPluginInfo_Base Tparent;
public:
    // constructor
    CPluginInfo(void);
    // destructor
    ~CPluginInfo(void);

    // set all fields in one pass
    void SetInfo(int major, int minor, int rev,
                 const string& build_date,
                 const string& class_name,
                 const string& menu_item,
                 const string& tooltip,
                 const string& help_file);

    void SetInfo(int major, int minor, int rev,
                 const string& build_date,
                 const string& class_name,
                 const string& menu_item,
                 const string& tooltip,
                 const string& help_file,
                 const string& icon_alias,
                 const string& icon_local_path);

    CPluginCommand& SetAlgoCommand(CPluginCommand::TCommand cmd);
    CPluginCommand& SetViewCommand(CPluginCommand::TCommand cmd);
    CPluginCommand& SetDataCommand(CPluginCommand::TCommand cmd);

    void AddApplicableUserType(const string& type, const string& subtype = kEmptyStr);

private:
    // Prohibit copy constructor and assignment operator
    CPluginInfo(const CPluginInfo& value);
    CPluginInfo& operator=(const CPluginInfo& value);

};



/////////////////// CPluginInfo inline methods

// constructor
inline
CPluginInfo::CPluginInfo(void)
{
}


/////////////////// end of CPluginInfo inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

#endif // GUI_PLUGIN_PLUGININFO_HPP
/* Original file checksum: lines: 93, chars: 2396, CRC32: ca7b428c */
