/* $Id: PluginArgSet.hpp 14666 2007-07-09 13:40:22Z dicuccio $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Mike DiCuccio, Denis Vakatov, Anatoliy Kuznetsov
 *
 * File Description:
 *    CPluginArgSet -- defines an interface for a collection of arguments for a
 *                     plugin
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the data definition file
 *   'plugin.asn'.
 */

#ifndef GUI_CORE_PLUGIN_PLUGINARGSET_HPP
#define GUI_CORE_PLUGIN_PLUGINARGSET_HPP


// generated includes
#include <gui/objects/PluginArgSet_.hpp>
#include <gui/objects/PluginArg.hpp>
#include <gui/objects/PluginValueConstraint.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE /// namespace ncbi::objects::


//
// class CPluginArgSet is the primary argument interface class.
//

class NCBI_GUIOBJECTS_EXPORT CPluginArgSet : public CPluginArgSet_Base
{
    typedef CPluginArgSet_Base Tparent;
public:
    /// constructor
    CPluginArgSet(void);
    /// destructor
    ~CPluginArgSet(void);

    /// operator[] for indexing based on named argument
    /// this will throw if the named argument isn't found
    const CPluginArg&   operator[](const string& name) const;

    /// operator[] for indexing based on named argument (non-const)
    /// this will throw if the named argument isn't found
    CPluginArg&          operator[](const string& name);

    /// Clear all objects from object-based arguments
    void ClearObjects();

    /// HasArgument() verifies that an argument exists
    bool HasArgument(const string& name) const;

    /// Delete an existing argument
    void RemoveArgument(const string& arg_name);

    /// add a named argument.  This argument is required, and has no default
    /// value.  Attempts to access the value without setting the value will
    /// result in an exception being thrown.
    CPluginArg& AddArgument(const string& name, const string& desc,
                            CPluginArg::EType type,
                            CPluginArg::TData::E_Choice single_or_array =
                            CPluginArg::TData::e_Single);

    /// add a named argument.  This argument is required, and has no default
    /// value.  Attempts to access the value without setting the value will
    /// result in an exception being thrown.
    CPluginArg& AddArgument(const string& name, const string& desc,
                            const CTypeInfo* info,
                            CPluginArg::TData::E_Choice single_or_array =
                            CPluginArg::TData::e_Single);

    /// Add a flag value.  This is a helper API; the request is reformatted
    /// and passed on to AddArgument()
    CPluginArg& AddFlag(const string& name, const string& desc);

    /// Add a default argument to the set of arguments.  This function creates a
    /// named argument with a default value of type string.
    CPluginArg& AddDefaultArgument(const string& name,
                                   const string& description,
                                   CPluginArg::EType type, const string& val);

    /// Add a flag argument with a default value.  This is a helper API; the
    /// request is reformatted and passed on to AddDefaultArgument
    CPluginArg& AddDefaultFlag(const string& name, const string& desc,
                               bool val);

    /// add an optional argument to the set of arguments.  This supports an
    /// optional default value argument.  For non-built-in types, the default
    /// value is ignored.
    CPluginArg&
    AddOptionalArgument(const string& name,
                        const string& description,
                        CPluginArg::EType type,
                        CPluginArg::TData::E_Choice single_or_array =
                        CPluginArg::TData::e_Single);

    CPluginArg&
    AddOptionalArgument(const string& name, const string& description,
                        const CTypeInfo* info,
                        CPluginArg::TData::E_Choice single_or_array =
                        CPluginArg::TData::e_Single);

    /// Set the constraint of a named argument.  This will throw an exception if
    /// the argument is not found, and will replace all previous constraints if
    /// the argument is found
    void SetConstraint(const string& name, CPluginValueConstraint& constraint);

    /// Add a constraint to a named argument.  This will throw an exception if
    /// the argument is not found
    void AddConstraint(const string& name, CPluginValueConstraint& constraint);

    /// Remove the constraint of a named argument.  This will throw an exception if
    /// the argument is not found.
    void RemoveConstraint(const string& name);

private:

    /// Prohibit copy constructor and assignment operator
    CPluginArgSet(const CPluginArgSet& value);
    CPluginArgSet& operator=(const CPluginArgSet& value);
};



/////////////////// CPluginArgSet inline methods

// constructor
inline
CPluginArgSet::CPluginArgSet(void)
{
}


/////////////////// end of CPluginArgSet inline methods


END_objects_SCOPE /// namespace ncbi::objects::

END_NCBI_SCOPE

#endif /// GUI_CORE_PLUGIN_PLUGINARGSET_HPP
/* Original file checksum: lines: 93, chars: 2348, CRC32: 56c3af4a */
