/* $Id: PluginArg.hpp 30280 2014-04-23 20:28:26Z katargir $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Mike DiCuccio, Denis Vakatov, Anatoliy Kuznetsov
 *
 * File Description:
 *    CPluginArg -- defines an interface for a single plugin argument
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the data definition file
 *   'plugin.asn'.
 */

#ifndef GUI_CORE_PLUGIN_PLUGINARG_HPP
#define GUI_CORE_PLUGIN_PLUGINARG_HPP


// generated includes
#include <gui/objects/PluginArg_.hpp>

// generated classes

BEGIN_NCBI_SCOPE

// predeclarations
class CObject;

BEGIN_objects_SCOPE /// namespace ncbi::objects::

class CDataHandle;
class CGBProjectHandle;


class NCBI_GUIOBJECTS_EXPORT CPluginArg : public CPluginArg_Base
{
    typedef CPluginArg_Base Tparent;
public:


    /// constructor
    CPluginArg(void);
    /// destructor
    ~CPluginArg(void);

    /// enumerated list of types we support
    enum EType {
        eNotSet,

        eBoolean,
        eProject,
        eDouble,
        eInteger,
        eObject,
        eString,
        eSecretString,
        eInputFile,
        eOutputFile,

        /// special type: could be any CSerialObject-derived object
        eAnySerialObject,

        /// this must be last!
        eMaxArg
    };

    /// typedefs for collections of argument types
    /// CPluginValue supports type-specific data retrieval of single entities
    /// and also wraps the necessary document
    typedef list< CConstRef<CPluginValue> > TValues;

    /// access the type for this argument
    EType GetType(void) const;

    /// determine if this argument is empty (i.e., has all type information but
    /// no values)
    bool IsEmpty(void) const;

    /// clear any objects from object-based arguments
    void ClearObjects();

    /// accessors for specific sub-components
    /// in the event that the data type is list, NULL is returned
    const CGBProjectHandle* GetProject   (void) const;
    const CObject*          GetObject    (void) const;

    /// accessor for the object-specific type info
    /// in the event the data type is list, the type info for the first
    /// item is returned, as we guarantee that all items in a list will
    /// be equivalently typed
    const string& GetObjectSubtype(void) const;

    /// set this argument as an integer
    void SetBoolean(void);
    void SetBoolean(bool arg);
    void SetBoolean(const list<bool>& arg);
    bool AsBoolean (void) const;

    /// set this argument as an integer
    void SetInteger(void);
    void SetInteger(const string& arg);
    void SetInteger(int arg);
    void SetInteger(const list<int>& arg);
    int  AsInteger (void) const;

    /// set this argument as a double
    void   SetDouble(void);
    void   SetDouble(const string& arg);
    void   SetDouble(double arg);
    void   SetDouble(const list<double>& arg);
    double AsDouble (void) const;

    /// set this argument as a string
    void          SetString(void);
    void          SetString(const string& arg);
    void          SetString(const list<string>& arg);
    const string& AsString (void) const;

    /// set this argument as a secret string
    void          SetSecretString(void);
    void          SetSecretString(const string& arg);
    void          SetSecretString(const list<string>& arg);
    const string& AsSecretString (void) const;

    /// set this argument as an input file
    void          SetInputFile(void);
    void          SetInputFile(const string& arg);
    void          SetInputFile(const list<string>& arg);
    const string& AsInputFile (void) const;

    /// set this argument as an output file
    void          SetOutputFile(void);
    void          SetOutputFile(const string& arg);
    void          SetOutputFile(const list<string>& arg);
    const string& AsOutputFile (void) const;

    /// set this argument as a CGBProjectHandle
    void             SetProject(void);
    void             SetProject(const CGBProjectHandle& arg);
    void             SetProject(const TValues& arg);
    const CGBProjectHandle& AsProject (void) const;

    /// set this argument as a CObject.  There are multiple forms of this;
    /// we provide for the passing in of a CTypeInfo object that provides
    /// additional information, specifically about CSerialObject-derived
    /// objects
    void           SetObject(const string& type);
    void           SetObject(const CTypeInfo* info = NULL);
    void           SetObject(const CObject& arg, const CGBProjectHandle* doc = NULL, const CDataHandle * dh = NULL);
    void           SetObject(const TValues& arg);
    const CObject& AsObject (void) const;

    /// insure that this argument can accept a list of its current type
    void SetList(void);
    void SetList(const TValues& values);
    void AsList(TValues& values) const;

private:
    /// Prohibit copy constructor and assignment operator
    CPluginArg(const CPluginArg& value);
    CPluginArg& operator=(const CPluginArg& value);
};


/////////////////// CPluginArg inline methods

// constructor
inline
CPluginArg::CPluginArg(void)
{
}


/////////////////// end of CPluginArg inline methods


END_objects_SCOPE /// namespace ncbi::objects::

END_NCBI_SCOPE

#endif /// GUI_CORE_PLUGIN_PLUGINARG_HPP
/* Original file checksum: lines: 93, chars: 2382, CRC32: fb41a3 */
