/* $Id: GBenchVersionInfo.hpp 21410 2010-05-19 23:01:10Z voronov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GBenchVersionInfo.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'gbench_svc.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: GBenchVersionInfo_.hpp


#ifndef GUI_CORE_GBENCHVERSIONINFO_HPP
#define GUI_CORE_GBENCHVERSIONINFO_HPP


// generated includes
#include <gui/objects/GBenchVersionInfo_.hpp>

// generated classes

BEGIN_NCBI_SCOPE

class CGBenchVersion;

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_GUIOBJECTS_EXPORT CGBenchVersionInfo : public CGBenchVersionInfo_Base
{
    typedef CGBenchVersionInfo_Base Tparent;
public:
    // constructor
    CGBenchVersionInfo(void);
    // destructor
    ~CGBenchVersionInfo(void);

    /// Format a label for this version
    void GetLabel(string* str) const;

    /// retrieve just the version info
    void GetVersionString(string* str) const;
    void AddVersionString(string* str) const;

    void GetOsString(string* str) const;
    void AddOsString(string* str) const;

    /// Forced to make this method public as far as friend declaration
    /// does not work on Linux.
    static void Initialize( size_t ver_major, size_t ver_minor, size_t ver_patch_level );

private:
    static TVer_major major;
    static TVer_minor minor;
    static TVer_patch patch;
    static TOs_ver osver;
    // Commented out until cgi update on server
    // static TOs_arch osarch;
    static int osarch;
    static bool sInitialized;

    // Prohibit copy constructor and assignment operator
    CGBenchVersionInfo(const CGBenchVersionInfo& value);
    CGBenchVersionInfo& operator=(const CGBenchVersionInfo& value);

};


NCBI_GUIOBJECTS_EXPORT
bool operator<(const CGBenchVersionInfo& v1, const CGBenchVersionInfo& v2);


/////////////////// end of CGBenchVersionInfo inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

#endif // GUI_CORE_GBENCHVERSIONINFO_HPP
/* Original file checksum: lines: 94, chars: 2712, CRC32: ed968fd */
